*        Encryption Subroutine
*        Encrypts 8 data bytes pointed to by (X)...
*            according to 8 byte key stored in locations KEY
*        Result is stored as 8 byte string at (X)
*
*        Encryption algorithm is as follows:
*            Result:=ValuetobeEncrypted
*            For bit=64 to 1 -- one iteration per bit
*                If MSB(Result) -- Inspect MSB of Result to decide what to do
*                Then
*                    -- Encrypt step: XOR with KEY
*                    Result:=(Result XOR KEY)*2+[MSB(Result) XOR MSB(KEY)]
*                Else
*                    -- Randomize step: XOR with Randomizing constant
*                    Result:=(Result XOR RNDIZER)*2+[MSB(Result) XOR MSB(KEY)]
*                Fi
*            Endloop -- Encrypted result is in Result
*
*        Decryption algorithm is as follows:
*            Result:=ValuetobeDecrypted
*            For bit=64 to 1 -- one iteration per bit
*                If LSB(Result) XOR MSB(KEY) -- Decrypt LSB to decide how undo
*                Then -- Decrypt step
*                     Result:=[INT(Result/2)+LSB(Result)*2^63] XOR KEY
*                Else -- "UnRandomize" step
*                     Result:=INT([Result XOR (Randomizer*2)]/2)
*                Fi
*             Endloop -- Decrypted result is in "Result"
*
*        Randomizer constant is as follows (random 64 bit string):
*        To prevent loss of this string due to accidental damage to this text,
*        it is repeated 5 times here:
*        %0101010110100110000010101001110011100011010101111010110000111001
*        %0101010110100110000010101001110011100011010101111010110000111001
*        %0101010110100110000010101001110011100011010101111010110000111001
*        %0101010110100110000010101001110011100011010101111010110000111001
*        %0101010110100110000010101001110011100011010101111010110000111001
*
*        The Hex equivalent of the randomizer string is:
*
*        $55 A6 0A 9C E3 57 AC 39
*
*
*        KEY is a buffer of 8 bytes; it should be in page zero for speed!
*        (it could, perhaps, be inserted inline in the encrypt/decrypt code!)
*
Eorall8bytes ; Compute XOR of all 8 bytes
         ldaa  4,x          Why are the index displacements all mixed up?
         eora  7,x          Because it puzzle the hell out of whoever...
         eora  5,x          attempts to dis-assemble it!
         eora  0,x
         eora  2,x
         eora  6,x
         eora  1,x
         eora  3,x           so Most sig byte of result depends on all 64 bits
         rts

EncryptLSB ; Set MSB to XOR of all 8 bytes
*     think about this, someday...
*     Dennis Painter sez: put key just below (S) and run with
*     Interrupts disabled.  Then it cannot be damaged unless an
*     NMI occurs, which will erase it.
Encrypt  ; And now it begins
*        ldab  #64           = # iterations to execute (too slow!)
         ldab  key+7         do 8 + 2 lsb of key iterations
         andb  #3
         addb  #8
         jsr   Eorall8bytes  scramble MSB
         staa  0,x           examine sign bit to decide what to do
         bpl   encryptrandomize b/ MSB is zero, go do randomize step
encryptstep ; MSB is one, perform encryption step
*        EOR current value with key, shift left
         ldaa  7,x           EOR this byte with key byte
         eora  key+7
         asla                shift left, forcing LSB=0
         staa  7,x
         ldaa  6,x           EOR this byte with key byte
         eora  key+6
         rola                shift left, saving carry from byte to right
         staa  6,x
         ldaa  5,x           EOR this byte with key byte
         eora  key+5
         rola                shift left, saving carry from byte to right
         staa  5,x
         ldaa  4,x           EOR this byte with key byte
         eora  key+4
         rola                shift left, saving carry from byte to right
         staa  4,x
         ldaa  3,x           EOR this byte with key byte
         eora  key+3
         rola                shift left, saving carry from byte to right
         staa  3,x
         ldaa  2,x           EOR this byte with key byte
         eora  key+2
         rola                shift left, saving carry from byte to right
         staa  2,x
         ldaa  1,x           EOR this byte with key byte
         eora  key+1
         rola                shift left, saving carry from byte to right
         staa  1,x
         ldaa  0,x           EOR this byte with key byte
         eora  key+0
         rola                shift left, saving carry from byte to right
         bcc   encryptstep0  b/ encrypted MSB is now zero
         inc   7,x           remember that encrypted MSB is a one
encryptstep0 ; encrypted MSB has been recorded in LSB of result
         decb                down count # iterations to perform
         beq   encryptrts    b/ done encrypting
         staa  0,x
         bmi   encryptstep   b/ new MSB is one, go do encrypt step
encryptrandomize ; MSB is zero, perform randomize step
         ldaa  7,x           EOR this byte with randomizer byte
         eora  #$39
         asla                shift left, forcing LSB to be zeroed
         staa  7,x
         ldaa  6,x           EOR this byte with randomizer byte
         eora  #$AC
         rola                shift left, saving carry from byte to right
         staa  6,x
         ldaa  5,x           EOR this byte with randomizer byte
         eora  #$57
         rola                shift left, saving carry from byte to right
         staa  5,x
         ldaa  4,x           EOR this byte with randomizer byte
         eora  #$E3
         rola                shift left, saving carry from byte to right
         staa  4,x
         ldaa  3,x           EOR this byte with randomizer byte
         eora  #$9C
         rola                shift left, saving carry from byte to right
         staa  3,x
         ldaa  2,x           EOR this byte with randomizer byte
         eora  #$0A
         rola                shift left, saving carry from byte to right
         staa  2,x
         ldaa  1,x           EOR this byte with randomizer byte
         eora  #$A6
         rola                shift left, saving carry from byte to right
         staa  1,x
         ldaa  key           EOR MSB of result with MSB of key
         anda  #$80          (Note: this requires that MSB(randomizer) be zero)
         eora  0,x           EOR MSB with MSB of key
         eora  #$55          and EOR rest with randomizer
         rola                shift left, saving carry from byte to right
         bcc   encryptrand0  b/ encrypted MSB=0
         inc   7,x           record that encrypted MSB is 1
encryptrand0 ; encrypted MSB is now saved in LSB of result
         decb                down count # iterations to perform
         beq   encryptrts    b/ done encrypting
         staa  0,x
         bpl   encryptrandomize b/ next bit is zero
         jmp   encryptstep

encryptrts ; encryption is complete
         staa  0,x           store MSB of final result
         jsr   eorall8bytes  scramble lsbyte
         staa  7,x
         rts
         page
*
*        Decrypt -- Undoes Encrypt
*            Decryption key is stored at KEY
*            Block of 8 bytes at (X) is decrypted in place
*
decrypt0 ; "encrypt" bit was 0, right shift current value and EOR with randomizer
         eora  key+0         undo "eora key+0" done by decryptloop
         anda  #$7F          force MSB to be zero
         eora  #$55          EOR with randomizer byte
         staa  0,x           (Note: MSB(Randomizer) must be zero)
         ldaa  1,x           EOR with this byte of key
         rora                shift right, saving carry from left
         eora  #$A6
         staa  1,x
         ldaa  2,x           EOR with this byte of key
         rora                shift right, saving carry from left
         eora  #$0A
         staa  2,x
         ldaa  3,x           EOR with this byte of key
         rora                shift right, saving carry from left
         eora  #$9C
         staa  3,x
         ldaa  4,x           EOR with this byte of key
         rora                shift right, saving carry from left
         eora  #$E3
         staa  4,x
         ldaa  5,x           EOR with this byte of key
         rora                shift right, saving carry from left
         eora  #$57
         staa  5,x
         ldaa  6,x           EOR with this byte of key
         rora                shift right, saving carry from left
         eora  #$AC
         staa  6,x
         ldaa  7,x           EOR with this byte of key
         rora                shift right, saving carry from left
         eora  #$39
         staa  7,x
         decb                down count # iterations
         bne   decryptloop   b/ more iterations to try
         jmp   decryptrts    decryption complete, result is in Result

Decrypt ; Do the encryption in reverse, literally
*        ldab  #64           64 iterations of reverse encryption required
         ldab  key+7         do 8 + 2 lsb of key iterations
         andb  #3
         addb  #8
         jsr   eorall8bytes  unscramble least significant byte
         staa  7,x           do first decryption iteration
decryptloop ; right shift current value and EOR with key
         rora                Shift encrypted "encrypt" bit into carry...
         ldaa  0,x           EOR with this byte of key
         rora                shift right, saving carry from left
         eora  key+0
         bpl   decrypt0      b/ encrypt bit was zero, go do "unrandomize" step
         staa  0,x
         ldaa  1,x           EOR with this byte of key
         rora                shift right, saving carry from left
         eora  key+1
         staa  1,x
         ldaa  2,x           EOR with this byte of key
         rora                shift right, saving carry from left
         eora  key+2
         staa  2,x
         ldaa  3,x           EOR with this byte of key
         rora                shift right, saving carry from left
         eora  key+3
         staa  3,x
         ldaa  4,x           EOR with this byte of key
         rora                shift right, saving carry from left
         eora  key+4
         staa  4,x
         ldaa  5,x           EOR with this byte of key
         rora                shift right, saving carry from left
         eora  key+5
         staa  5,x
         ldaa  6,x           EOR with this byte of key
         rora                shift right, saving carry from left
         eora  key+6
         staa  6,x
         ldaa  7,x           EOR with this byte of key
         rora                shift right, saving carry from left
         eora  key+7
         staa  7,x
         decb                down count # iterations
         bne   decryptloop   b/ more to do
decryptrts
         jsr   eorall8bytes  now unscramble Most significant byte
         staa  0,x
         rts                 decryption complete, result is in Result
