.np
.cd
.br
APPLICATION PROGRAMMERS' GUIDE
.BR
ROUGH DRAFT
.pa
.fs 15
.ce
S D O S
.sp
.ce
APPLICATION PROGRAMMERS' GUIDE
.sp 10
.ce
COPYRIGHT (C) 1978 SOFTWARE DYNAMICS
.sp
.ce
4th Printing
.pa
.bp
.dd
.fs 8
.ce
NOTICE
.BR
.CE
------
.SP
This manual describes Software Dynamics Operating System (SDOS) Version 1.1.
Software Dynamics has carefully checked the information given in this manual,
and it is believed to be entirely reliable.  However, no
responsibility is assumed for inaccuracies.
.sp
SD reserves the right to change the specifications without notice.
.SP
.pw 120
.ll 100
.im 21
**********************************************************************
** This manual  describes software  which is a proprietary  product **
** of Software Dynamics (SD).  SD software is licensed for use on a **
** single copy per computer basis, and is covered by U.S  copyright **
** laws.  Unless a written exception is obtained from SD, the soft- **
** ware must be used only on the single computer whose unique,  SD- **
** assigned serial number matches that for which  the  software was **
** purchased.  Copying the software  for  any  purpose  other  than **
** archival storage, or use of the  software on other than the  as- **
** signed serial numbered CPU is strictly  prohibited.   SD assumes **
** no liability regarding the use of the software.                  **
** Certain  software  programs and  datafiles are delivered for use **
** in an encrypted  format.  The content of such  programs and data **
** are  considered  to be a  trade  secret of SD.  Attempts or suc- **
** cess at  breaking the  encryption, publication of the results of **
** such attempts or successes, or copying, storage or use of such a **
** file in clear text form will be treated as theft of a trade sec- **
** ret, and prosecuted as such.                                     **
** POSSESSION OR USE  OF THIS  MANUAL OR THE SOFTWARE  IT DESCRIBES **
** CONSTITUTES AGREEMENT BY THE USER TO THESE TERMS.                **
**********************************************************************
.ix Encryption
.sp
.ll 65
.pw 85
This manual and the software it describes are the copyrighted property of
Software Dynamics.
.he SDOS APPLICATION PROGRAMMERS' GUIDE
.pa
INTRODUCTION
.sp
.tc
This manual gives detailed information needed by programmers building
programs to operate under SDOS 1.1. The reader should be familiar with SDOS
concepts; the SDOS User's Guide provides the appropriate background.
.sp
This document presumes some familiarity on the part of the reader with
assembly language coding for M6800, M6801 and M6809 microprocessors. This
knowledge is needed to understand fully the implications of the SDOS System
Call (SYSCALL) interface and the rules about error propagation. Practical
use of SDOS does not generally require assembly assembly language
programming, as most programming is done in SD BASIC, which provides
statements for performing SDOS System Calls.
.sp
This document covers three main areas:
.in 5
.sp
SDOS SYSCALL structure and assembly language interface
.sp
Device Independent I/O - Concepts and device specific descriptions
.sp
SDOS File System Structure
.in 0
.sh SECTION I: DEVICE-INDEPENDENT I/O
.pa
.IL COPYRIGHT (C) 1978
.IR Software Dynamics
.bp
.pa 1
.BP
.tc
DEVICE-INDEPENDENT I/O
.tc
.ix Device-Independent I/O
.ix Disk File
.ix I/O Device
.ix LPT:
.sp
SDOS allows user programs to view all disk files and I/O devices as being
fundamentally the same, i.e., if one can perform an operation on a device of
type x (say, LPT:), one can generally perform that same operation on a
different device of type y.
.sp
.ix Disk File
.ix Device
Since disk files and devices are treated essentially identical, we will use
file sometimes to mean device.
.sp
.ix File Model
.ix Line Printer
.ix CRT
.ix Digital to Analog Converter
.ix Device Driver Routine
.ix I/O Package
In this section, a conceptual model of how files/devices should act is
presented (later sections describe in detail the system calls used to
implement this model).  SDOS is designed in such a way that disk files
conform to this model very closely; exceptions will be noted later.  Real
devices such as line printers, CRT's, Digital-to-Analog converters, etc.,
are made to emulate this model as closely as possible via a device driver
routine in the I/O package; the degree of closeness depends entirely on this
driver.  In many cases, it is not practical or appropriate for a device to
.ix Device-Dependent Limitation
match the desired model; this means that
there are device-dependent (actually, driver-dependent) limitations on this
device independence.
.sp
.ix File
.ix Data Storing
.ix Data Retrieving
.ix Data Byte
.ix File Size
SDOS implements files for the purpose of storing and retrieving data. A file
is assumed to consist of a sequential set of 8 bit data bytes, with the
first byte being numbered zero, the second being number 1, the nth being
numbered n-1.  Each file has a size, which is equal to the number of bytes
of data stored in the file.  The data in a file can
.ix Variable-Size Block
.ix Random Access
.ix Binary Fomat
.ix ASCII Format
be read or written sequentially in variable-size blocks. If new data needs
to be added to the end of a file, the file can be automatically extended. 
Commands exist to allow a file to be positioned to a specified byte position
in preparation for a later read or write operation, thus providing random
access.  Data can be read or written in pure binary, or in ASCII (text)
format.
.sp
.ix CLOCK
A device is (usually) a physical piece of hardware capable of retrieving and
storing data, converting data to/from printed form, etc.  (some devices,
such as the CLOCK:, are almost purely software).  In many cases a device is
treated as a file by SDOS.  Some devices can actually store many separate
data files (such as a disk device).
.sp
.IX I/O Channel
.IX Data Read
.ix Data Write
.ix I/O Channel Number
.ix User Program
User programs communicate with files via mechanisms called "I/O channels". A
channel remembers which file is being manipulated, and where in the file
that the next data transfer should take place. Each user can have several
I/O channels; typical SDOS systems allow eight I/O channels per user. I/O
channels for a user are given numbers 0 to 255 maximum.
.sp
.ix SYSCALL:OPEN
.IX SYSCALL:CREATE
.ix Interaction Between Independent Operations
Virtually all operations on a file must be performed in conjunction with an
I/O channel.  An initial connection is established between a user-program
specified I/O channel and a particular file by use of a SYSCALL:OPEN (or
SYSCALL:CREATE).  All further operations on that file must specify the
operation desired, and the I/O channel number associated with a file.  Note
that a particular file may be open on several I/O channels, thus causing
interactions between what appear to be independent operations. The
.ix SYSCLL:CLOSE
.IX OPEN
.IX CREATE
association between a channel and a file is broken with a SYSCALL:CLOSE
operation; a channel on which this operation is the most recently executed
valid operation is said to be CLOSED.  No operations except OPEN or CREATE
are valid on a closed I/O channel.
.sp
.ix Associated I/O Channel
.ix Data Position Within File
.ix Column Count
The I/O channel has associated with it several pieces of information:
whether that channel is open or closed; the particular device driver which
is responsible for that file; information selecting which file on that
device is to be used; data selecting a position within that file; and a
column count (next print position on a real or simulated printing device).
.sp
.ix Position Zero
.ix File Beginning
.ix Read Operation
.ix Write Operation
When a file is first opened, the position is reset to zero (beginning of the
file).  Each read or write operation on an I/O channel advances the position
for that channel by the amount of data
.ix End of File
.ix I/O Channel, Two Open
read/written.  An End Of File condition is said to have occurred whenever
the file position on a particular channel is equal or larger than the file
size (in bytes).  Note that two I/O channels open to the same file are not
necessarily positioned to the same place within that file.
.sp
.ix Column Count
.ix Tabbing
.ix Data, Binary
.ix Copy
A column count is maintained for the purpose of "tabbing" (a text concept). 
This column count is zeroed whenever binary data (non-text) is read or
written to a file, and adjusted to reflect the position along an imaginary
typewriter line whenever textual data is copied to or from a file.
.sp
.ix System Call
.ix Buffer, Write
.ix Buffer, Reply
.ix Operation Subcode
.ix Reply Length
.ix RPLEN
.ix SYSCALL
Operations prformed on files are done via SDOS System Calls (SYSCALLs).
SYSCALLs specify an operation, a Write Buffer (containing data going to a
file or to SDOS), a Reply Buffer (where data or status from SDOS is
returned), a channel number and/or operation subcode, and a reply length
(RPLEN).
.pa
Operations defined on files include, but are not limited to:
.sp
.IX Open
.IX Create
.IX Close
.IX Delete
.ix Rename
.ix READA
.ix READB
.ix WRITEA
.ix WRITEB
.ix Control
.ix Status
.ix Position
.ix GETEOF
.ix GETCOLCNT
OPEN, CREATE, CLOSE, DELETE, RENAME, READA, READB, WRITEA, WRITEB, CONTROL,
STATUS, POSITION, GETEOF, GETCOLCNT
.sp
Other operations are device-driver specific.
.sp
.ix OPEN
.ix Device Type
.in 5
.un 5
OPEN is intended to associate an I/O channel with a file (device) that
already exists, for the purpose of reading (or updating) data in that file. 
Data-input only devices such as paper tape readers must be OPENed in order
to read data.  All devices can be OPENed so that the device type is easily
read without knowing the kind of device being OPENed.
.sp
.ix CREATE
.ix CRT
.ix Line Printer
.ix Device, Input
.ix Device, Output
.un 5
CREATE is intended to associate a file or device with an I/O channel which
is to be used whenever an entirely new stream of data is to be written or
stored.  In particular, when a new disk file is needed, or data sent to an
output-only device (such as a line printer) a CREATE should be performed.
Some devices, like CRT's, which are both input and output, can be either
OPENed or CREATEd.
.sp
.ix CLOSE
.un 5
CLOSE is used to break the association between a file and an I/O channel,
and to cause the driver for the device on which that file resides to finish
any operations on that file.
.sp
.ix DELETE
.un 5
.ix OPEN
.ix Lost Data
.ix File, Disk
DELETE is used to delete (disk) files from devices that store multiple named
files.  Devices cannot be deleted.  Once a file is deleted, it cannot be
OPENed and its contents are permanently lost.
.sp
.ix RENAME
.ix File, Disk
.un 5
RENAME is used to change the name of a disk file, and is illegal when
directed specifically at a device.
.sp
.ix READA
.IX WRITEA
.IX Data, ASCII
.ix Read from Console
.ix Line Printer
.ix File, Automatic Expansion
.ix Channel Number
.un 5
READA and WRITEA are used to read and write ASCII (textual) data.  This is
used to read data from consoles, print on line printers, etc.  If a file has
no more room for new data written, then the file is automatically expanded. 
A channel number must be given to select the desired file.
.sp
.ix READB
.ix WRITEB
.ix Binary Data Read
.ix Binary Data Write
.ix I/O Channel Number
.ix Digital to Analog Converter
.un 5
READB and WRITEB are used to read and write binary data to and from devices
(data stored in a form convenient for the computer).  An I/O channel number
is required to select the desired file.  Some devices, like Digital to
Analog converters, can only perform Write Binary.
.sp
.ix CONTROL
.ix Device-Specific Operation
.ix GETTYP
.ix POSITION
.ix Dump Buffer
.un 5
CONTROL operations are used to cause device-specific operations that do not
fit into the above types of operations.  Typical control operations are
GETTYP (get device type), POSITION, DUMP BUFFERS, etc.
.sp
.ix Status Operation
.ix Read
.ix Device Type
.ix FILESIZE
.ix EOF
.ix COLCNT
.un 5
STATUS operations are used to read device or file specific data.  Typical
status data is DEVICE TYPE, FILESIZE, EOF flag and COLCNT.
.pa
.ix POSITION
.ix File, Read
.ix File, Write
.ix I/O Channel
.ix File, Position
.ix File, Implied Position
.un 5
POSITION is used to change the place in the file that the next read or write
will start transferring data to or from. POSITION affects an I/O channel,
not the file itself, so several I/O channels may be positioned to different
points in the same file.  A file can be positioned anywhere past the last
data byte; this is used to expand a file. Although POSITION operations can
be performed independently of read or write operations, it is generally more
efficient to perform both in the same step; to allow this, an "implied
position" operation can be added to read and write operations.
.sp
.ix GETEOF
.ix End of File
.un 5
GETEOF is used to determine if the position of a particular file is at or
past the file size (i.e., there is no more data to read).
.sp
.ix GETCOLCNT
.ix Simulated Print Head
.ix File, ASCII
.ix Tabular Display
.ix I/O Channel
.un 5
GETCOLCNT is used to read back the simulated print head position of an ASCII
text file (or an actual print head position for a line printer, etc.).  This
is useful when a tabular display is desired.  Like the file position, this
value is I/O channel dependent.
.in 0
.sh SECTION II: DEVICE DRIVERS
.pa
.tc
DEVICE DRIVER CHARACTERISTICS
.tc
.ix Device Driver Characteristic
.sp
This section describes the actual characteristics of the device drivers, and
how operations on these drivers differ from an "ideal" device (as described
under DEVICE-INDEPENDENT I/O).
.sp
.ix Assembly Language Programmer
.ix Syscall
.ix BASIC
.ix Assembly Language
These characteristics are observable directly by the assembly language
programmer via "Syscalls".  Many features of the device drivers may be
masked by a high level language such as BASIC; to use these features, an
escape to assembly language may be required.
.pa
.tc
DISK File Driver
.ix Disk File Driver
.sp
.ix Disk File
.ix Device-Independent I/O
Disk files under SDOS implement virtually all aspects of general file
handling as described under Device-Independent I/O. This section details
exactly the operations implemented by the SDOS Disk File Driver.
.sp
.ix SDOSDISKINIT
.ix Byte, Data
.ix File Size
.ix File Size, Apparent
.ix File, Sparse
An SDOS disk file can physically contain as few as zero data bytes, and as
many as the remaining free space after an SDOSDISKINIT.  SDOS keeps track of
disk file sizes accurate to the byte.  Apparent file size may be much larger
than the actually allocated disk space; such a file is said to be "sparse".
.sp
.ix File, Dense
Disk files may be allocated "dense"ly or "sparse"ly.  A dense file is one in
which data clusters are allocated for each data byte
.ix File, Sparse
whose position is less than the file size.  A sparse file may have a
position (with a smaller value than the file size) for which no data cluster
is allocated (data read from this area of the file appears as zeroes).
.sp
.ix OPEN
.IX CREATE
.IX File, Read
.ix File, Update
.ix Error
.ix File, Write Protected
An OPEN is used to open a disk file (that must already exist) for reading
and/or update.  If the file does not exist, an error will occur.  A CREATE
will CREATE a new disk file which will supersede the old version of the file
when the new file is closed.  The new file will contain zero data bytes
after creation.  A new file cannot be created if the old file is write
protected, or a new file by that name is being created.
.sp
.ix OPEN
.ix CREATE
.ix Default Disk
Any OPEN or CREATE that specifies a filename that does not contain an
explicit device identifier will be automatically assumed to be a disk file
on the default disk (DISK:).  Also, any filename that is prefixed by a disk
device name, and does not consist solely of the device name is assumed to be
the name of a disk file on the specified disk.
.sp
.ix File Name, Disk
.ix File Name, Device
.ix Integer, Parenthesized
.ix CREATE
For the form of disk file names, see the section on DEVICE and DISK FILE
NAMES.  Disk file names may include a parenthesized integer; this integer is
used by CREATE to allocate enough disk space at file creation time to
.ix Disk Space
.ix Byte
contain the number of data bytes specified by the integer. This has two
advantages: first, it decreases the amount of time needed to allocate the
space to the file (it is cheaper to allocate all at once than to allocate
several little pieces when SDOS discovers it needs them) and it increases
the probability the allocation of the file on the disk is
.ix Contiguous Space
.ix Random Access Time
.ix Error
.ix Disk Space
.ix OPEN
contiguous, which decreases random access time to the file. No error is
given if there is not enough disk space to satisfy the request. OPEN will
parse but ignore the size.
.sp
.ix CREATE
.ix File, Delete
.ix File, Write Protected
.ix Channel, Open
If CREATE is used to make a new disk file, and there is an old file by the
same name, the old file must not be delete or write protected or an error
will occur and the new file will not be created (nor will the channel be
opened).  Also, no file by that name may be CREATEd simultaneously (i.e., in
psuedo-BASIC,
.sp
.im 2
        CREATE #1,"X"
        CREATE #2,"X"
.sp
.ix Being CREATEd
.ix OPEN SYSCALL
.ix File Name, Duplicate
will result in an error).  Otherwise, the new file is created, and the
channel is opened.  As long as the newly created file is still open on the
channel on which it was created, that new file is in the state of "being
CREATEd". If an old file with the same name does exist, an OPEN SYSCALL
executed after the CREATE, looking for the same file, will open
.ix System Crash
.ix Channel Closed
.ix Disk Space Free
the old file.  If the system crashes before the new file is closed, the old
file will be unaffected in any way.  Even after the new file is closed,
channels still open to the old file will not notice any difference. When the
.IX OPEN
last channel OPEN to the old file is closed, the space for the old file is
returned to free disk space.
.sp
Example:
.sp
.im 9
TIME                OPERATION              ACTION
1              OPEN #1, "ABC"        Opens old ABC
2              CREATE #2, "ABC"      CREATEs a replacement
3              OPEN #3, "ABC"        Opens old ABC
4              CLOSE #2, "ABC"       Marks old verson of ABC
                                     as deleted
5              OPEN #4, "ABC"        Opens file generated at
                                     time 2
6              CLOSE #1,#3           Deletes old ABC
.sp
.IX CLOSEing A Disk File
.ix File Size
.ix File Protection
CLOSEing a disk file causes changes to the file size, protection, and other
characteristics to be updated on the disk.
.ix System Crash
.ix Lost Data
.ix Directory
.ix Allocated Disk Space
.ix Free Space
IF THE SYSTEM CRASHES WHILE THE FILE IS OPEN, THESE CHANGES ARE LOST (NOT
RECORDED IN THE DIRECTORY). If the disk file is newly created, and is not
replacing another by the same name, closing will make its name appear in the
directory.  If the file is newly created, and it is a replacement for a file
that already exists (i.e., one by the same name), then the new file will
replace the old in the directory, and the disk space allocated to the old
file will be returned to free space as soon as no other I/O channels remain
open to the old version of the file.
Disk space allocated to a file beyond the file size will be returned
to the free disk space pool when a file is closed.
.sp
.ix RENAME
.ix Disk File
.ix OPEN
.ix Directory
RENAME is used to change the name of a disk file.  RENAMEing a disk file to
its own name is legal, and can speed up later OPENs of that file since a
rename causes the file name to be re-hashed into the directory.  Refer to
hash-lookup
.ix Write Protect
.ix File Name, Create
description of files.  A disk file cannot be renamed if it is write
protected, or a file by that name already exists, or a new file by that name
is being created.
.pa
.ix DELETE
.ix Free Space
.ix Disk File
.ix Directory
.ix Write Protect
DELETE is used to free the space being used by a disk file and remove the
filename from the directory.  A file cannot be deleted if it is delete or
write protected, or if a new version of the file is being created.
.sp
.ix READA
.ix SYSCALL:READA
.ix File, Sparse
.ix WRITEA
.IX WRITEB
.IX READB
.IX SYSCALL
.ix Error, Read
.ix Error, Write
.ix File Position
READA performs exactly as specified by SYSCALL:READA. READAing through a
large, sparse portion of a file may take an excessive amount of time due to
the automatic suppression of all the zero bytes found in the sparse area. 
WRITEA, WRITEB, and READB match the SYSCALLs exactly.  If an error occurs
during a read or write, the file position may not be advanced properly.
.sp
.ix CONTROL Operation
CONTROL operations available on disk files are the following:
.sp
.ix CC:POSITION
.in 5
.un 5
CC:POSITION
.br
Used to set file position before a read or write operation.
See also SYSCALL:WRITEx and SYSCALL:READx.
.sp
.ix CC:DUMPBUFFERS
.un 5
CC:DUMPBUFFERS
.br
Forces all data related to the file back to the disk media, so it is
recorded permanently in case of a later crash.
.sp
.ix CC:SETFILEDATE
.un 5
CC:SETFILEDATE
.br
Sets the creation/update date of the file. The date supplied must
be in the same format as returned by a SYSCALL:READB to the CLOCK: device.
Note that the file date is automatically updated whenever a WRITE or
CC:SETFILESIZE operation is applied to a file.
.sp
.un 5
CC:SETFILEPROT
.ix CC:SETFILEPROT
.ix CC:SETFILESIZE
.IX DIRECTORY.SYS
.ix File Protection
.ix RENAME
.ix DELETE
.ix WRITE
.br
Sets the file protection byte to the byte supplied. See DIRECTORY.SYS for
structure of file protection byte. If the BACKUP protection bit is set, it
will be cleared if any RENAME, CC:SETFILESIZE, or WRITE operation occurs. If
the DELETE protection bit is set, the operations RENAME, DELETE, WRITE and
CC:SETFILESIZE will not be allowed.
.sp
.un 5
CC:SETFILESIZE
.ix CC:SETFILESIZE
.ix Sparse File
.ix File Size
.ix Data Cluster
.ix Free Cluster Pool
.ix Truncate File
.br
Sets the file size to the current file position.  This operation can be used
to extend a file (the extension will be sparse until written) or to truncate
a file (data written beyond the file position given by the file size will
become inaccessible, and data clusters that were allocated beyond that point
will be returned to the pool of free clusters when the file is closed).
.sp
.un 5
CC:POSITIONTOEND
.ix CC:POSITIONTOEND
.ix File Position
.ix CC:POSITION
.ix SC:GETFILESIZE
.ix File, Extend
.br
Sets the file position equal to the file size; has the same effect as
as a CC:POSITION applied to the result of an SC:GETFILESIZE.  Generally
used when extending a file is desired.
.pa
.in 0
.ix STATUS
STATUSes obtainable from a disk file are:
.sp
.in 5
.ix SC:GETPOS
.un 5
SC:GETPOS
.br
Read position of file.
.sp
.IX SC:GETCOL
.IX File Column Number
.IX Value, Zero
.ix READB
.ix WRITEB
.ix ASCII
.ix Sequential ASCII Read
.ix Sequential ASCII Write
.un 5
SC:GETCOL
.br
Get file column number.  This value is zeroed by a CC:POSITION or
READB/WRITEB and adjusted as data bytes are read or written in ASCII mode. 
The disk file driver advances the column count
by one for any visible character read/written; decrements by one if
ASCII:BS is encountered; zeros the column count if ASCII:CR is encountered;
advances the column count to the next multiple of 8 if ASCII:HT is found;
and leaves the column count alone for all other codes.
The value of the column count at a particular point in a file thus depends
on the last operation of a file; it is intended only for use with sequential
ASCII reads and writes.
.sp
.ix SC:GETEOF
.ix End of File
.ix File Size
.ix File Extended
.un 5
SC:GETEOF
.br
Returns EOF hit flag.  EOF is set if positioned at or past file size.  EOF
also set when last byte of file is read or overwritten, or file is extended.
EOF is reset when file is positioned with a positioning value less than the
file size.
.sp
.ix SC:GETTYPE
.ix Device Type
.ix DVTYPE.FILE
.IX SDOSUSERDEFS.ASM
.un 5
SC:GETTYPE
.br
Returns device type of DVTYP.FILE.  See SDOSUSERDEFS.ASM.  All devices
(drivers) are able to return a device type.
.sp
.ix SC:GETFILESIZE
.ix Last Data Byte
.un 5
SC:GETFILESIZE
.br
Returns the position of the last data byte written to the file, plus 1.
If file has no data written in it, returns zero.
.sp
.ix SC:GETPARAMS
.ix Sector Size
.ix Cluster Size
.un 5
SC:GETPARAMS
.br
Returns data about the file, such as sector size in bytes, and the cluster
size.
.sp
.un 5
SC:GETFILEDATE
.ix SC:GETFILEDATE
.ix Creation Date
.ix Update Date
.br
.ix SYSCALL:READB
.ix CLOCK:
Returns the creation/update date of the file in the standard system date
format (same format as a SYSCALL:READB would return from the CLOCK:).
device.
.sp
.un 5
SC:GETFILEPROT
.ix SC:GETFILEPROT
.IX Protection Byte
.ix DIRECTORY.SYS
.br
Returns the protection byte currently associated with the file. See
DIRECTORY.SYS description for format of protection byte.
.sp
.pa
.br
.sp
.in 0
.ix Disk File
.ix Data Cluster
.ix End of File
.ix Sparse
No other status is obtainable from a disk file.
.SP
SDOS will allocate data clusters to a file automatically whenever a write
request to a non-allocated part of a file occurs (it does not allocate from
the current end of file up to the point of the write; it simply leaves that
part of the file sparse).  A cluster allocated in a formerly sparse part of
a file is automatically zeroed to preserve the "zero" property of the part
not modified.
.sp
.ix Logical Cluster Number
.ix Sequential Processing Time
.ix Data Cluster
.ix BOOT:MIDALLOC
.ix MIDALLOC
SDOS attempts to allocate data clusters contiguously (with respect to
Logical Cluster Numbers) to minimize scattering of the file over a disk and
to minimize sequential processing time.  If absolutely contiguous allocation
is not possible, SDOS allocates the closest free LCN that starts a
contiguous block of BOOT:MIDALLOC free clusters.
.sp
.ix Disk File Driver
.ix OPEN
.IX CREATE
.IX File Control Block
.ix FCB
.ix File, Open
.ix DIRECTORY.SYS Entry
.ix Disk Space Allocated
.ix Apparent Size
.ix Channel
The SDOS disk file driver keeps track of OPENed (CREATEd) files via File
Control Blocks.  FCBs are in one-to-one correspondence with open files (not
channels), and contain what amounts to a DIRECTORY.SYS entry.  In
particular, the FCB holds the amount of disk space allocated to a file and
its apparent size.  If a file is extended on one channel, the extension will
be apparent immediately on a different channel on which that file is also
open because of the shared FCB.
.sp
.ix Disk Sector
.ix Sector Pool
.ix Channel, I/O
.ix Sector, Modified
Disk sectors are kept in a pool of sectors to minimize disk reads of
frequently accessed data.  Data written into a file will be immediately
available through another I/O channel on which that file is open because the
(modified) disk sector in the pool is shared.  Modified sectors in the pool
are written back to the disk as space is required to bring in another disk
sector according to a Least Recently Used discipline. The oldest sector on
the queue will be written back if its disk is free.
.sp
.ix FCB Side Effect
.ix Disk Sector Buffer Pool
.ix Common Data Base
.ix File, Share
These side effects of the FCBs and the disk sector buffer pool are subtle
but desirable because it is appropriate that different programs be able to
share a file and its contents exactly as it is in any instant in time.  Many
disk operating systems do not provide this exact sharing capability, and
consequently make it hard to build a set of programs that interact through a
common data base.
.sp
.ix Sequential I/O
.ix Disk File
.ix Read-Ahead
.ix Sector Pool
.ix Sequential File Processing Time
SDOS optimizes sequential I/O to disk files via "read-ahead". Whenever data
from a particular sector of a disk file is fetched, SDOS pre-reads the next
sector of that disk file into the sector pool.  The read-ahead happens in
parallel with processing of data from the first sector.  This scheme
decreases sequential file processing time, and lowers the cost of reading
records that span sector boundaries to an acceptable level.
.pa
.tc
DISK Device Driver
.ix Disk Device Driver
.ix Disk Content
.ix File Structure, Initialize
.ix File Structure, Repair
.ix File Structure, Check Out
.ix Available Disk Space
.ix File Access Time
.sp
The SDOS disk device driver allows access to the entire contents of a disk
as though it were a single, large file. This facility is generally only used
by utility programs to initialize, check out, and repair the file structure
on a disk, but it may also be used to squeeze out the last ounce of
available disk space, to cut down access time to a large file, or to
read/write disks compatible with the drive but intended for other disk
operating systems.
.sp
.ix Dismount
Disk device drivers may also be used to perform operations on the device
itself, such as to dismount a disk.
.sp
.ix OPEN
.ix CC:UNLOCKDISK
.ix Write, Illegal
.ix File Structure Protection
A disk device driver is OPENed when SDOS is asked to OPEN a file whose name
consists only of a disk name. (Writes to the device are illegal until a
CC:UNLOCKDISK call is made to enable this; this protects the file structure
against damage from casual programs since they typically don't issue this
call.)
.sp
.IX DISMOUNT
.ix Map Algorithm
.ix BOOT.SYS
A disk device which has been DISMOUNTed recently will have a Map Algorithm
of :0001.  If the disk device is already mounted (i.e., has been used for
disk file operations), then the map algorithm will be that given by the
BOOT.SYS file on the disk.
.sp
.ix CREATE
.ix OPEN
The disk device driver treats CREATE calls exactly like an OPEN.
.sp
.ix Channel Number, I/O
.ix CLOSE
CLOSEing a disk device simply disassociates the I/O channel number, and
otherwise does nothing.
.sp
.ix RENAME
.IX DELETE
.ix Error
RENAME and DELETE operations directed to a disk device will cause an error.
.sp
.ix READA
.ix READB
.ix SYSCALL
.ix WRITEA
.ix WRITEB
.ix CC:UNLOCKDISK
.ix Error, End of File
.ix Lost Data
READA and READB act as described under SYSCALLs; the contents of the disk
are treated as a single, large stream of bytes. WRITEA and WRITEB act as
described (once enabled by CC:UNLOCKDISK), however, a disk device cannot be
"extended" when more space is needed, so writing off the "end" of the disk
device will cause an End of File error, and the written data will be lost.
.sp
.ix Sector Access
.ix Sector Size
Access to sectors may be obtained by positioning a disk device to a byte
position which is a multiple of the sector size for that disk.
.pa
.ix CONTROL
Disk device drivers support the following CONTROL operations:
.sp
.in 5
.un 5
CC:POSITION
.br
To position for later reads/writes.
.sp
.un 5
CC:DUMPBUFFERS
.ix FCBs
.ix Dismount
.br
This control operation will cause all modified sectors belonging to the disk
to be written back to it.  It will also cause information changed in FCBs of
files open on that disk to be written back. Information in FCBs for newly
created but not yet closed files is NOT written back to the disk.  This is
not a substitute for a DISMOUNT control operation.  No parameters are
needed.
.sp
.un 5
CC:UNLOCKDISK
.ix CC:UNLOCKDISK
.ix WRITEA
.IX WRITEB
.ix Error, Write Protected
.ix CLOSE
.br
This enables WRITEA and WRITEB to work properly on a disk device.  If
CC:UNLOCKDISK is not issued after OPENing a disk, and prior to a write, a
"disk is software write protected" error will occur. Requiring this control
operation to write on the disk device prevents accidental writing to a disk
device.  CLOSEing the disk device re-enables the write protection.  No
parameters are needed.
.sp
.un 5
CC:DISMOUNTDISK
.ix CC:DISMOUNTDISK
.ix DUMPBUFFERS
.IX OPEN
.ix Error, Dismount
.ix I/O Driver
.ix FORMAT
.ix Map Algorithm
.ix Dismount
.ix SDOSDISKVALIDATE
.br
This operation is used to make SDOS let go of a disk entirely so it may be
removed from the drive.  An implied DUMPBUFFERS occurs.  If there are any
(new or old) disk files OPEN on that disk, an error will occur and the
dismount operation will not take place (one should repeatedly issue
dismounts until no errors are detected; a disk I/O fault on a dismount
will probably require SDOSDISKVALIDATE to repair the disk). The disk I/O
driver will be called so that it may physically eject the disk or perform
other needed cleanup.  A successful dismount also turns off the FORMAT
mode switch in the disk sector I/O driver.  The map algorithm is set to
:0001 if the dismount succeeds.
.sp
.un 5
CC:SETMAPALGORITHM
.ix CC:SETMAPALGORITHM
.IX CC:DUMPBUFFERS
.IX OPEN
.IX Error
.ix WRBUF
.ix SYSCALL Block
.br
This allows the 16 bit Map Algorithm for the disk to be changed.  An implied
CC:DUMPBUFFERS occurs first; if there are any disk files OPEN on that disk,
an error will occur.  If any error occurs, the map algorithm will not be
changed.  The map algorithm is passed in the WRBUF of the SYSCALL block.
.sp
.un 5
CC:FORMAT
.ix CC:FORMAT
.IX Blind Write Mode
.br
CC:FORMAT is used to switch into "blind write" mode, intended for disk
formatting purposes.  See Disk I/O drivers.  This operation may not be
available on all disk devices.
.pa
.in 0
.ix CONTROL Code
.ix Disk Device Driver
.ix Disk Sector I/O Driver
Any other CONTROL code is simply passed by the SDOS Disk Device Driver to
the Disk Sector I/O driver for its use.
.sp
.ix STATUS
STATUS information obtainable from a disk device is the following:
.in 5
.sp
.un 5
SC:GETPOS
.ix SC:GETPOS
.br
As described under SYSCALLs
.sp
.un 5
SC:GETCOL
.ix SC:GETCOL
.br
As described under SYSCALLs
.sp
.un 5
SC:GETEOF
.ix SC:GETEOF
.br
As described under SYSCALLs
.sp
.un 5
SC:GETPARAMS
.ix SC:GETPARAMS
.IX NBPS
.ix NSPT
.IX NTPC
.IX NCYL
.IX SDOSUSERDEFS.ASM
.br
Returns NBPS (number of bytes per sector), NSPT (number of sectors per
track), NTPC (number of tracks per cylinder), and NCYL (number of cylinders)
each as 2 byte values.  See SDOSUSERDEFS.ASM for details on format of
result.
.sp
.un 5
SC:GETFILESIZE
.ix SC:GETFILESIZE
.IX NBPS
.IX NSPT
.IX NTPC
.IX NCYL
.ix Sector Size in Bytes
.ix Disk Sector
.br
Returns the size of the disk in bytes; equal to NBPS*NSPT*NTPC*NCYL (the
product of the sector size in bytes, and the number of sectors on the
disk).
.sp
.un 5
SC:GETTYPE
.ix SC:GETTYPE
.IX DVTYP.DISK
.br
Returns DVTYP.DISK
.sp
.un 5
SC:GETLASTBADLSN
.ix SC:GETLASTBADLSN
.ix Logical Sector Number
.ix Error, Read
.ix Error, Write
.ix Error, Seek
.IX CC:DISMOUNT
.IX CC:SETMAPALGORITHM
.IX SDOSDISKVALIDATE
.br
Returns the Logical Sector Number of the disk sector which last caused a
Seek, Read or Write error.  The LSN is returned as 3 bytes; an LSN of
:FFFFFF means "no bad LSN". Executing SC:GETLASTBADLSN, CC:DISMOUNT, or
CC:SETMAPALGORITHM causes the value to be reset "to no bad LSN".  This
STATUS is intended primarily for use by SDOSDISKVALIDATE.
.sp
.ix SC:GETERRORSTATS
.ix Error Statistic
.ix CC:DISMOUNT
.ix CC:SETMAPALGORITHM
.ix DISMOUNT
.ix LSN, Soft Error
.un 5
SC:GETERRORSTATS
.br
Returns error statistics collected by the disk driver selected. Such error
statistics record counts and disk controller status after each failed
attempt by the driver to perform a seek, read or write operation, and the
the LSN of the sector involved when the failed attempt last occurred.  Since
the disk drivers retry failed attempts, nonzero error statistics can occur
and yet the system will still function without error; such errors are known
as "soft" errors and are only an indication that some difficulty may be
present. Executing SC:GETERRORSTATS, CC:DISMOUNT or CC:SETMAPALGORITHM
causes the value to be reset "to no bad LSN".  This STATUS is intended
primarily meant for display by the DISMOUNT command.
.in 0
.pa
VIRTUAL TERMINAL DRIVER
.tc
.BR
.in 5
.ix CONSOLE:
.IX LPT:
.IX Serial Device, ASCII-Oriented
(CONSOLE:, LPT: and Other ASCII-Oriented Serial Devices)
.in 0
.sp
.ix SDVT11C
.ix Virtual Terminal Driver
.ix Application Program
.ix Physical Terminal Characteristic
.ix Printer Device
This section describes SDVT11C, known as the "Virtual Terminal
Driver". The Virtual Terminal driver is intended to allow an applications
program to operate with the majority of display-oriented display units
(terminals), without knowing physical terminal characteristics.  Inasmuch
as printer devices and terminals have a great deal in common, with respect
to output, the secondary intent of the VT driver is to give the
application the same uniform view of printer devices.
.sp
.ix Display-Oriented Operation
.ix Imaginary Terminal
This is accomplished by defining a set of display-oriented operations  for
an imaginary (virtual) terminal.  The application controls the terminal with
this set of operations, giving no regard to the type of physical terminal
which may be ultimately used.  At time of program execution, the operations
commanded by the application are mapped into equivalent operations which the
physical terminal can perform.
.sp
.ix CONTROL Call, Installation-Dependent
.ix STATUS Call, Installation-Dependent
.ix Binary Operation
.ix READB
.ix WRITEB
.ix Program Portability
In the event that an applications programmer desires to explicitly reference
a feature peculiar to a particular terminal, he may use
installation-dependent CONTROL or STATUS calls, or the binary operations
READB and WRITEB to bypass the general nature of the VT driver. In so doing,
however, that program becomes tied to a particular terminal and is no longer
portable to all terminals serviced by the VT driver.
.sp
.ix Keyboard Entry
.ix Line Input Editing
.ix Text Display Function
.ix Cursor Position
.ix Data Entry via Field
.ix Display-Oriented Application
The VT driver provides keyboard entry, line input editing, and text display
functions.  For CRTs, the VT driver also provides a standard method of
dealing with cursor positioning, data entry via fields, and various screen
attributes (denoted as "Coloring" in this document) thus making
display-oriented applications portable over a wide variety of terminals.
.sp
.ix Input Byte Stream to Application
.ix Output Byte Stream to Application
.ix Type-Ahead Buffer
.ix Request for Data
.ix READA
.ix READB
.ix Input Line Buffer
.ix Activation Character
For each virtual terminal device, the VT driver presents an indefinitely
long input or output byte stream to the application.  The path of input,
from typist to application, travels through several territories, before
reaching its destination.  Keystrokes are first collected in a type-ahead
buffer.  When a request for data is made (via a READA or READB, for
instance), characters are removed from the type-ahead buffer, in the order
received, and assembled in the input line buffer.  Characters are moved from
the type-ahead buffer to the input line buffer, up to and including the
character which terminates the buffer filling process.  All
.ix Type-Ahead Buffer Empty
.ix Keyboard Input
.ix READA
.ix READB
.ix Binary Mode
.ix ASCII Mode
.ix CC:ACTIVATIONCK
.ix Parity Bit
subsequent data requests are satisfied from this line buffer, until it has
been exhausted; then, the type-ahead buffer is again referenced. If the
type-ahead buffer is empty, then input is taken from the keyboard, a
keystroke at a time. The type of the last data request (READA, READB, etc.)
determines how the type-ahead buffer is filled.  If the binary mode has been
selected (the last request was a READB), then all keystrokes are faithfully
stored in the type-ahead buffer.  On the other hand, if the ASCII mode has
been selected (the last request was a READA or CC:ACTIVATIONCK control
call), the parity bit is stripped from all characters; certain control
.ix Control Character
.ix Input Line Editing
.ix Input Line Buffer
.ix RDBUF
.ix Switch Request
characters are assigned special meaning (see Control Characters in this
section) and are not stored in the type-ahead buffer. Editing of the input
line is performed at the time of character transfer from the type-ahead
buffer to the input line buffer: if a READA or a CC:ACTIVATIONCK control
call initiated the transfer, then the input line buffer is filled in ASCII
mode and line editing is performed; otherwise, the data is transparently
copied through the input line buffer to the RDBUF specified by the request. 
When ASCII mode keystrokes are being stored in the type-ahead buffer, switch
requests, such as ^A, ^C, ^S, and ^P (to name a few), are serviced
immediately, and are not retained in the type-ahead buffer.
.sp
.ix Device Profile Block
.ix DPB
.ix Device-Specific Operation
.ix Cursor Position
.ix SDOSSET
.ix Profile Malleable
Associated with each virtual terminal device is a "Device Profile Block".
The DPB customizes the terminal to operate with specific manufacturers'
devices so that standard SDOS operations are converted to equivalent
device-specific operations. This allows application programs to position
cursors, "color" the screen or screen regions, or update and erase the
screen without knowing the specific device type. A system command, SDOSSET,
can be used to change which device profile is in use; some profiles are
"malleable"; i.e., changeable, so even devices with properties not handled
by standard DPBs in a system can be accommodated. There are also special
control calls to allow an application to select or modify particular
profiles.
.sp
.ix OPEN
.IX CREATE
.IX Terminal Device Name
.ix ASCII Activation Set
.ix Tab
.ix CC:ECHO
.ix CC:KILLENABLE
.ix CC:BACKGROUND
.ix Non-Ready Device
.ix Number of Open Channels
.ix Output Display
.tc
A terminal may be OPENed or CREATEd, using the device name "CONSOLE:",
"PORT1:", "PORT2:", etc.; a printer to "LPT:", "LINEPRINTER:", etc. Doing an
OPEN or CREATE sets the ASCII activation set to <CR> only, sets the tabs to
8, 16, 24 .... up to 132, performs CC:ECHO and CC:KILLENABLE control calls,
and sets the background color to "black" (see CC:BACKGROUND). CREATEs to
non-ready devices are aborted with a "Device Not Ready" or "Printer Not
Ready", depending on whether the device was a console or printer,
respectively; this prevents applications from outputting data to un-ready
devices in a way which is convenient to test. A terminal/printer may be open
on several channels provided that all channels belong to the same task;
output display by the terminal is exactly what would be seen if the  I/O
requests had been all directed to one channel in the same order.
.SP
.ix CLOSE
.ix I/O Channel
.ix WRITEA
.ix ASCII:CR
.ix CC:DUMPBUFFERS
.ix Device Time Out
.ix ASCII:FF
.tc
CLOSE disassociates the I/O channel from the driver. For printers, if part
of a line has been printed, the VT driver will complete the line by
effectively WRITEAing ASCII:CR; if a partial page has been printed, it will
finish the page by effectively WRITEAing ASCII:FF, thus assuring that each
use of a printer leaves the paper aligned at top of form for the next use.
CLOSE finally does an implied CC:DUMPBUFFERS, and gives an error if the
device times out.
.sp
.tc
RENAME and DELETE operations are illegal.
.ix RENAME
.ix DELETE
.ix Illegal Operation
.pa
.ix READA
.ix WRITEA
.ix I/O Mode Used
.ix SYSCALL Specification
.ix Input Line Buffer
.ix Type-Ahead Buffer
.ix Editing
.ix Echoing
.ix End of File Condition
.tc
READA and WRITEA are the normal I/O modes used with the terminal, and match
the SYSCALL specification.  A READA causes the characters to be taken from
an input line buffer maintained by the driver.  When the input line is
exhausted, and a READA is issued, the driver processes characters from the
type-ahead buffer, placing regular keystrokes in the input line buffer,
performing editing as directed by control keys, and performing echoing for
the typist's benefit.  A ^Z read from the type-ahead buffer will cause an
.ix Parity Stripped
.ix Activation Character
.ix RDBUF
.ix Activation Not In Buffer
.ix Line Mode
.ix Illegal Device Operation
.ix Change of Mode, Binary
.ix Change of Mode, Ascii
End of File condition to occur.  Parity is stripped, leaving only 7-bit
ASCII codes. Characters are not taken from the input line buffer until
activation has been signaled.  READA terminates when an activation character
is encountered, or RDBUF has no room for the next character.   In the latter
case, an "Activation Not in Buffer" error is returned, along with as much
data as RDBUF can hold. READA must be done in line mode: a non-line mode
request for more than zero bytes will result in an "Illegal Device
Operation" error; READA non-line mode for zero bytes is accepted for
backwards compatibility reasons to allow change of mode from Binary reads
to Ascii reads.
.sp
.ix READB
.ix Input Line Buffer
.ix Type-Ahead Buffer
.ix Pre-Processing
.ix Parity Bit
.ix <CR>
.ix Line Feed
.tc
As a general rule, SDOS uses a single <CR> character to represent <CR><LF>
as a pair. Line feeds are not an acceptable alternative.
.sp
.ix WARNING
When a READB is issued, keystrokes are accumulated in the input line buffer
(and the type-ahead buffer, as necessary), with neither echoing nor
pre-processing of any kind. The exact key codes generated by the terminal
hardware are passed directly to the application, including the parity bit.
READB is terminated when the reply buffer is filled. WARNING: an unsatisfied
READB to a VT device cannot be aborted; we do not recommend using this.
.sp
.ix READA
.ix Last Operation on Terminal
.ix ASCII:ESC
.ix ASCII:RUBOUT
.ix Type-Ahead Buffer
.ix READB
.ix Zero-Byte Read Request
.ix Changing Input Mode
.ix Control Character
.tc
If the last operation upon the terminal was READA, then most control keys,
including ASCII:ESC and ASCII:RUBOUT cause various actions to be taken by
the VT driver; these keystrokes are not passed to the application.  If READB
was last issued, no special interpretation of any keystroke is made; all
keystrokes are placed in the type-ahead buffer for processing by the
application. READA and READB permit a 0-byte read request for the purpose of
changing input modes.  See section on Control Characters for a complete list
of the control characters, and their actions, upon both input and output.
.pa
.ix WRITEA
.ix Parity Bit
.ix Interpretation
.ix Printing Character
.ix Tab Character
.ix Tab Table
.ix ASCII:CR
.ix ASCII:LF
.ix Idle Character
.ix CRT Screen
.ix Printer
.ix Control Character
WRITEA causes text to be output to the terminal.  All characters are first
stripped of the "parity" bit (bit 7), and then inspected to determine their
interpretation.  Printing characters are sent to the device. Tab characters
are expanded according to the tab table assigned to each terminal.  
ASCII:CR characters cause an ASCII:LF and a variable number of idle
characters to be output after them.  ASCII:FF (form) characters cause CRT
screens to be cleared, and cause printers to move to top-of-next-page. Other
control characters are generally printed as ^c, where c is the keystroke
used with the control key. See Table of Control Characters for a complete
list of the control characters, and their actions, upon both input and
output.
.sp
.ix WRITEB
.ix Write Buffer
.ix Parity Bit
.ix Line Feed
.ix Idle Character
.ix Logical Column Count
.ix Cursor Location
.ix CC:POSITION
.ix Implied Position Call
WRITEB causes the bytes to be sent to the terminal exactly as specified in
the write buffer, including the "parity" bit. No linefeeds or idles are
inserted. The logical column count is zeroed, and the VT driver assumes it
no longer knows the location of the cursor (the application must issue a
CC:POSITION or perform an implied positioning call before the VT will know
where the cursor is again).
.pa
.ix Control Operation
The VT driver supports the following control operations:
.sp
.in 5
.un 5
CC:POSITION
.tc
.ix CC:POSITION
.br
.ix Cursor Position
.ix Illegal Device Operation
.ix Hard Copy Terminal
.ix Printer
.IX SYSCALL:READA
.IX SYSCALL:READB
.IX SYSCALL:WRITEA
.IX SYSCALL:WRITEB
.IX SCBLK:EXTENSION
.ix Implied Position
.ix I/O
The positioning information is treated as a cursor position of the form
R*256+C, where R is the desired row (0 is the top row), and C is the desired
column (0 is the leftmost column).  Any value which would cause the cursor
to position off the display, will result in an Illegal Device Operation
error, and the cursor will not be moved. Positioning the cursor of a
hardcopy terminal (display depth is zero) or a printer is not permitted, and
will result in an Illegal Device Operation error. Note that SYSCALL:READA,
SYSCALL:READB, SYSCALL:WRITEA and SYSCALL:WRITEB all allow implied positions
in SCBLK:EXTENSION, so that a single call can both position the cursor and
do I/O.
.sp
.un 5
CC:DUMPBUFFERS
.tc
.ix CC:DUMPBUFFERS
.ix Device Time Out
.br
This is generally a no-op, since the driver dumps characters to the device
as fast as it can; it does check for a device timeout.  No parameters are
needed.
.sp
.un 5
CC:ECHO
.tc
.ix CC:ECHO
.ix READA
.br
This enables echo on READA.  No parameters are needed.
.sp
.un 5
CC:NOECHO
.tc
.ix CC:NOECHO
.ix READA
.br
This shuts off echo on READA.  No parameters are needed.
.sp
.un 5
CC:WRAP
.tc
.ix CC:WRAP
.IX Line Wrapping
.br
This enables line wrapping when a line exceeds the display width.
.sp
.un 5
CC:NOWRAP
.tc
.ix CC:NOWRAP
.ix Truncated Line
.ix Cursor Position
.br
This disables line wrapping when a line exceeds the display width: the line
is truncated, and the cursor is left on the same line, following the last
character displayed.
.sp
.un 5
CC:IDLES
.tc
.ix CC:IDLES
.ix Transmitted Idle
.ix WRBUF
.ix Idle Count
.ix Character Default
.ix OPEN
.IX CREATE
.IX CLOSE
.ix Illegal Device Operation
.ix Profile Not Malleable
.br
This sets the number of idles to be transmitted after a <CR> or <LF>. The
first byte in WRBUF is the idle count (0 is legal), the second byte  in
WRBUF is the character after which the idles are to follow.  If the second
byte is not present, idle trigger defaults to <LF>.  A character other than
<CR> or <LF> will cause an "Illegal Device Operation" error. This
information is not changed by OPENs, CREATEs, or CLOSEs. Note that the
current profile must be either malleable or hardcopy (an option which must
be SYSGENed into the I/O package); otherwise, a Profile Not Malleable error
will be returned.
.sp
.in 13
.ix <LF><CR>
.ix <CR><LF>
.un 8
Caveat:~Some terminals will behave differently for <LF><CR> than for
<CR><LF>.
.in 5
.pa
.un 5
CC:TABS
.tc
.ix CC:TABS
.ix Tab Simulation
.ix WRBUF
.ix Column Number
.ix Tab Default
.ix Illegal Device Operation
.ix CONSOLE: Tab
.br
This sets tab stops for tab simulation.  The WRBUF must hold a string of
bytes, each byte specifying the next tab stop.  Each successive byte must
contain a column number larger than the previous one.  When the terminal is
first opened, tab columns are set at every eighth column, up to 132 columns
(0 is the first column). Up to 16 tab stops may be set; if too many are
supplied, an "Illegal Device Operation" error will result.  If the order of
the tab stops is incorrect (not monotonically increasing), an "Illegal
Device Operation" error will be returned, and the old tab settings will be
undisturbed.  Since CONSOLE: devices tend to stay open for long periods of
time, CONSOLE: tab settings have a tendency to remain in effect long after
needed.
.sp
.un 5
CC:SETACTBLOCK
.tc
.ix CC:SETACTBLOCK
.ix Activation Character
.ix ASCII Character Set
.ix Control Character
.ix OPEN
.ix CREATE
.ix ASCII:RUBOUT
.ix Printing Character Echo
.br
This specifies a non-standard set of activation characters. The non-standard
set is specified with a vector of 128 bits (arranged in WRBUF as 16 bytes), 
corresponding to the ASCII character set.  The least significant bit in the
first byte corresponds to character code 00, and the most significant bit of
the 16th byte corresponds to character code :7F.  When a bit is set, the
corresponding character is interpreted as a non-standard activation
character; when the bit is reset, the standard interpretation applies (see
the chart of Control Characters,  below).  The activation set is restored to
the standard interpretation (all bits reset) by OPEN and CREATE. When marked
as activation characters, control characters and ASCII:RUBOUT are never
echoed, while printing characters echo only if echo is enabled. Note that
<CR> is always an activation character~-- marking it as a non-standard
activation character only changes its echoing characteristics (as a standard
activation character, it echoes if echo is enabled; as not-standard, it does
not echo).
.sp
.un 5
CC:CLRINPUT
.tc
.ix CC:CLRINPUT
.ix Input Line
.ix Type-Ahead Buffer
.ix Abnormal Condition
.br
This clears the input line and type-ahead buffers. This is useful when
input, following an abnormal condition, is required.
.sp
.tc
.un 5
CC:CLROUTPUT
.ix CC:CLROUTPUT
.ix Output Buffer
.br
This clears the output buffer.  It is generally useful only when the output
buffer for a device is very big, or the device is very slow; otherwise, the
buffer will empty quickly anyway.
.pa
.un 5
CC:SETREADTIMEOUT
.tc
.ix CC:SETREADTIMEOUT
.ix READA
.ix CC:ACTIVATIONCK
.ix Timed Input Expired
.ix RDBUF
.ix WRBUF
.ix WRLEN
.br
This sets a timeout on a subsequent READA or CC:ACTIVATIONCK control call.
The timed period begins when the subsequent input operation is issued.  When
the timed period has expired, the input operation is terminated with a
"Timed Input Expired" error, and the data input thus far is returned in the
RDBUF supplied by the input operation. The length of the period is expressed
in 60ths of a second, as a 16-bit value. Note that the period allowed is
only approximately what is specified, but is guaranteed to be longer than
the value given. The value is found in WRBUF, and WRLEN must be 2.
.sp
.un 5
CC:SETPROFILE
.tc
.ix CC:SETPROFILE
.ix Default Set
.ix Width
.ix Depth
.ix Output Timeout
.ix Cursor Position
.ix Profile Malleable
.ix WRBUF
.ix No Such Profile
.ix WRLEN
.ix SDOSSET
.ix IOVTDPBS.ASM
.br
This selects a new device profile, which includes a function mapping VT
operations to physical terminal operations. Selection of a profile sets
default device width, depth and output timeouts; it specifies how the device
will position the cursor, clear the screen, erase to end of line, and go to
new lines; it controls how "coloring" is to be displayed, etc. Such a
profile generally represents a particular model of CRT/printer.  The new
profile replaces the old profile, and is retained until changed or the
system is re-booted. Some profiles are malleable and may be somewhat altered
to accomodate devices for which there is no specific profile (see below). As
the malleable profile is a template, any alterations are retained with the
device, rather than with the profile. Selection of a new profile will cause
previous alterations to be lost. WRBUF contains one number, which is the
profile "name". Specification of a profile not sysgenned into the I/O
package will result in a "No such Profile" error.  WRLEN must be 1. This
call is normally only used by the SDOSSET program. For a list of profile
names, see the documentation for SDOSSET or the file IOVTDPBS.ASM.
.sp
.ix I/O Package
Note that adding a new profile requires changes to the I/O package.
.in 0
.pa
.in 5
.un 5
CC:ALTERPROFILE
.tc
.IX CC:ALTERPROFILE
.br
.ix Profile Malleable
.ix Profile Not Malleable
.ix Cursor Position Sequence
.ix Illegal Device Operation
.ix Parameter
.ix Column Number
This alters the currently selected profile (see above), if it is malleable;
if it is not, a "Profile Not Malleable" error is returned.  The alterations
are confined to defining a cursor-positioning sequence, an erase to end of
line (EEOL) sequence, and a home and clear screen (CLEAR) sequence.  An
"Illegal Device Operation" will be given if the parameter supplied are
unreasonable. Note that the cursor positioning sequence contains, in place
of the row and column numbers, the offsets to be added to the row and column
numbers supplied by the application; thus, the cursor positioning sequence
could be used, by itself, to position to location (0,0).  More extensive
alteration must be accomplished by defining a new profile and incorporating
it into a newly-generated system.
.sp
.ix WRBUF
WRBUF must contain the following data:
.sp
.in 30
.un 23
.ix ALTERPROFILE:CPLEN
.ix Cursor Position
ALTERPROFILE:CPLEN~~~~~significant length of cursor positioning sequence
following; 1 byte in range 3 to 4.  If this length is < 3, then the VT
driver will output '@@' instead of a cursor position.
.sp
.un 23
.ix ALTERPROFILE:CPSEQ
.ix Cursor Position Sequence
ALTERPROFILE:CPSEQ~~~~~cursor position sequence, which includes the row and
column offsets; 4 bytes
.sp
.un 23
.ix ALTERPROFILE:CPIDLS
.ix Idle
ALTERPROFILE:CPIDLES~~~number of idles to follow cursor positioning
sequence; 1 byte
.sp
.un 23
.ix ALTERPROFILE:ROWDISP
.ix Displacement, Row Number
ALTERPROFILE:ROWDISP~~~displacement into cursor positioning sequence of row
number; 1 byte
.sp
.cp 4
.un 23
.ix ALTERPROFILE:COLDISP
.ix Displacement, Column Number
ALTERPROFILE:COLDISP~~~displacement into cursor positioning sequence of
column number; 1 byte
.sp
.un 23
.ix ALTERPROFILE:CLLEN
.ix CLEAR Sequence
.ix ASCII:LF
.ix Top of Page
.ix Printer Device
.ix Paper Form Size
ALTERPROFILE:CLLEN~~~~~significant length of CLEAR sequence following; 1
byte in range 0 to 4.  If 0, a CLEAR sequence will be simulated by
generating enough ASCII:LFs to move to the top of a page if a printer
device (page depth can be changed by CC:SETPARAMS).  This is a useful device
if a system has different size paper forms, and no forms control tape.
.sp
.un 23
.ix ALTERPROFILE:CLSEQ
.ix CLEAR Sequence
ALTERPROFILE:CLSEQ~~~~~CLEAR sequence; 4 bytes
.sp
.un 23
.ix ALTERPROFILE:CLIDLES
.ix Number of Idles
.ix CLEAR Sequence
ALTERPROFILE:CLIDLES~~~number of idles to follow CLEAR sequence; 1 byte
.sp
.un 23
.ix ALTERPROFILE:EEOLLEN
.ix Erase to End of Line Sequence
ALTERPROFILE:EEOLLEN~~~significant length of EEOL sequence following; 1
byte in range 0 to 4.  If 0, the sequence will be simulated.
.sp
.un 23
.IX ALTERPROFILE:EEOLSEQ
.ix Erase to End of Line Sequence
ALTERPROFILE:EEOLSEQ~~~EEOL sequence; 4 bytes
.sp
.un 23
.ix ALTERPROFILE:EEOLIDLES
.ix Number of Idles
.ix Erase to End of Line Sequence
ALTERPROFILE:EEOLIDLES~number of idles to follow EEOL sequence; 1 byte.
.sp
.in 5
.ju
.fo
.tc
.un 5
CC:WRITEEDITLINE
.ix CC:WRITEEDITLINE
.ix WRBUF Contents
.ix Input Line Buffer
.ix READA
.ix CC:ACTIVATIONCK Control Call
.ix Operator Edit
.ix Activation Character
.ix CC:NOECHO
.ix Display Inhibiting
.ix WRLEN
.ix Input Buffer Space Available
.ix Illegal Device Operation
.br
This appends the contents of WRBUF to the end of the input line buffer as if
the typist had entered that data.  A subsequent READA or CC:ACTIVATIONCK
control call will cause the data to be displayed, in the usual fashion, and
the typist may edit the data until an activation character is entered.  Note
that using the CC:NOECHO control call, prior to invoking CC:WRITEEDITLINE,
will inhibit that data from being displayed at the time of the READA or
CC:ACTIVATIONCK control  call. An activation character may be present in
WRBUF, but will prevent the typist from editing characters prior to the
activation character: activation will occur immediately. If WRLEN is greater
than the space available in the input line buffer, or data follows an
activation character in WRBUF, an Illegal Device Operation error is returned
and no data is transferred to the input line buffer.
.sp
.ix Syscall Block Extension
.ix Cursor Position
.ix WRBUF
.ix Data Echoed
If present, the syscall block extension contains a cursor position at which
the cursor should be left, after the data has been echoed by the input
operation; otherwise, the cursor will be left at the end of the data
supplied in WRBUF.  
.sp
.ix CC:SETFIELDSIZE
.ix Syscall Extension
.ix Column Number
.ix Cursor
.ix READA
.ix CC:ACTIVATIONCK
.ix Tab Expansion
When a field has been explicitly defined (see the CC:SETFIELDSIZE control
call, below), the 1-byte syscall extension is the column number at which the
cursor is to be placed, at the time of the READA or CC:ACTIVATIONCK control
call; if that column is in the middle of a tab expansion, the cursor will be
positioned following the expanded tab.
.in 0
.pa
.in 5
.tc
.un 5
CC:SETFIELDSIZE
.br
.ix CC:SETFIELDSIZE
.ix READA
.ix CC:ACTIVATIONCK
.ix WRBUF
.ix Field Width Size
.ix Bad Field Width
This defines an input field for a subsequent READA or CC:ACTIVATIONCK
control call.  WRBUF contains the field width. The field width must be at
least 1 and no greater than the width of the display. If the field width is
0, or exceeds the limits of the display, a "Bad Field Width" error will be
returned, and the field definition will not be made.
.sp
.ix Cursor Control Key
.ix Activation Character
.ix Field Boundary
.ix SC:GETACTCOL
.ix Column of Exit
Unless any of the cursor control keys for moving left, right, up, and down
have been designated activation characters, they may be used to position
within the defined field.  When an attempt is made to position the cursor
beyond the boundary of the field, that character is treated as an activation
character and the operation is terminated; the terminating cursor control
character is appended as the activation character, and the cursor is not
moved.  An SC:GETACTCOL status call may be issued to determine the exact
column of exit.  If any of the cursor control characters is designated an
activation character, then that character cannot cause a field exit
condition, and will activate immediately upon use.
.sp
.ix Field Definition
.ix Field Exit
.ix Activation Character
.ix Bad Field Width
.ix ^C^C
The field definition terminates upon field exit, or entry of an activation
character.  If the field, at the time of the input operation, is not
contained completely within the display width, that input operation will
terminate with an "Bad Field Width" error and the field input mode will be
cancelled. ^C^C will cancel any outstanding field definition.
.sp 2
.un 5
CC:SETPARAMS
.tc
.br
.ix CC:SETPARAMS
.ix Display Width
.ix Display Depth
.ix Device Profile
Sets the width (1 byte) and the depth (1 byte) of the display; this
overrides the default from the device profile chosen. Zero depth means that
the terminal is not a paging device and will print ^L when given a form feed
character.
.in 0
.pa
.in 5
.un 5
CC:ACTIVATIONCK
.tc
.br
.ix CC:ACTIVATIONCK
.ix Keyboard Input
.ix Activation Received
.ix Input Line Buffer
.ix Type-Ahead Buffer
.ix READA
.ix ^C^C
.ix SDOS/MT
.ix KILLPROOF Flag
.ix Program Killed
This is used to enable keyboard input without causing the program to suspend
operation.  CC:ACTIVATIONCK returns an "Activation Received" error if an
activation character is in either the input line buffer or the type-ahead
buffer. If no activation character is present in either buffer, the input
line buffer is filled from the type-ahead buffer, unless this has already
been done by a previous call of CC:ACTIVATIONCK. A READA issued following an
"Activation Received" error will always return immediately with the data
requested and/or an error appropriate to a READA (If ^C^C has been seen
while the SDOS/MT and KILLPROOF flags are set, a "Program Killed" error will
be returned; otherwise, ^C^C will result in the program being killed.)
*Once the CC:ACTIVATIONCK control call has been issued, subsequent I/O
requests (with the exception of CC:ACTIVATIONCK, status requests, and
SYSCALL:READA) will result in an "I/O In Progress" error. This state is
exited by issuing a READA upon receipt of an "Activation Received" error.  A
CC:SETREADTIMEOUT control call issued prior to the initial CC:ACTIVATIONCK
can be used to limit the time spent in this state.  When the timed period
expires, the next CC:ACTIVATIONCK will return an "Activation Received"
error, and the subsequent READA will return the expected "Timed Input
Expired" error, along with any data received prior to the expiration.
.in 7
.sp 2
.un 2
*~See the section on SDOS/MT support for a caveat that applies to this note.
.in 5
.SP
.un 5
CC:SETBAUDRATE
.tc
.ix SETBAUDRATE
.ix Device Baud Rate
.ix WRBUF
.ix Illegal Device Operation
.br
This call is used to change the baud rate of a device.  WRBUF contains a 16
bit unsigned integer representing the exact baud rate desired (rounded to an
integer).  An "Illegal Device Operation" is returned if the baud rate cannot
be changed, or cannot be changed to the specified value.
.in 0
.pa
.in 5
.un 5
CC:COLORING
.tc
.ix CC:COLORING
.IX Change Text Appearance
.ix Color
.ix Intensity
.ix Underscoring
.ix Blinking
.ix Double-Width
.ix Double-Height
.ix WRBUF
.br
For the purposes of this control call, a "color" is that which changes the
appearance of text without changing its meaning or size.  This call supports
the myriad available features dealing with display appearance: these
include, but are not limited to: color, intensity, underscoring, and
blinking.  It explicitly does NOT handle characters whose size is
non-standard (i.e., double-width or double-height) for the device. 16 bits
of data, found in WRBUF, specify the desired display mode for subsequent
output: all display characteristics must be specified by the same control
call at one time.
.sp
.ix Position Control Call
.ix WRITEA
.ix Position Control Call
.ix CC:BACKGROUND
The mode change is made immediately, and the mode is saved for later use by
the position control call.  All characters output via WRITEA are "colored"
according to the last color selected by this call.  When a position control
call is made, the "zero" coloring is selected (see CC:BACKGROUND, below),
the positioning is performed, and the coloring selected by CC:COLORING is
re-instated.
.sp
.ix Design Deficient Terminal
CC:COLORING does not cause the cursor to move (some terminals violate this,
due to their design deficiencies).
.sp
.ix WRBUF
.ix Display Mode
.ix Alternate Roman Character Set
.ix Default Color
.ix CRT, Dumb
.ix OPEN
Two bytes in WRBUF are used to specify the display modes.  The first byte is
divided as follows: 2 bits for intensity, 1 bit for blink, 1 bit for
underscore, 1 bit for reverse video, 3 bits for (inverted) color (1 bit each
for "not red", "not green", and "not blue"). The second byte contains 3 bits
for selecting alternate Roman character sets; the remaining bits are
undefined and must be zero.  The default color of "zero"  (both bytes zero)
selects the standard Roman character set, standard intensity, no reverse
video, no underscore, no blink, and the color white (i.e., the display mode
obtained for virtually all "dumb" CRTs). The "zero" color is automatically
selected by OPEN.
.sp
.ix NOP
Although this control call is recognized by all systems, its actual
implementation will vary according to the particular terminals being
supported; in the simplest of cases, it will be implemented as a NOP.
.in 0
.pa
.in 5
.un 5
CC:BACKGROUND
.tc
.br
.ix CC:BACKGROUND
A "background" color is the color displayed in all screen locations which do
not contain a character.
.sp
.ix Default Color
.ix CC:COLORING
.ix WRBUF
.ix OPEN
CC:BACKGROUND selects the default coloring to be used when the display is
cleared, or when cursor positioning is to be done (see CC:COLORING, above).
The required byte of data is found in WRBUF and is of the same format as for
the first byte of CC:COLORING, above. A black background (hex :07) is
automatically selected by OPEN.
.sp
.ix NOP
Although this control call is recognized by all systems, its actual
implementation will vary according to the particular terminals being
supported; in the simplest of cases, it will be implemented as a NOP.
.sp
.un 5
CC:KILLPROOF
.tc
.ix CC:KILLPROOF
.ix VT Input Device
.ix ^C^C
.ix ^D
.ix Beep
.ix Type-Ahead Buffer
.br
This is used to KILLPROOF a specific VT input device.  What that means is
that ^C^C and ^D will be rejected with a beep when they are entered. ^C
while killproof clears the type-ahead buffer.
.sp
.un 5
CC:KILLENABLE
.tc
.ix CC:KILLENABLE
.ix CC:KILLPROOF
.ix VT Input Device
.IX SYSCALL:KILLPROOF
.br
This is used to cancel the effect of a CC:KILLPROOF control call directed at
the same VT input device.  Note that SYSCALL:KILLPROOF is not overridden by
this control call.
.sp
.un 5
CC:SETEXCEPTION
.tc
.br
.ix CC:SETEXCEPTION
.ix VT Driver Processing Exception
.ix SEDIT
.ix ASCII:RUBOUT
.ix ^U
.ix ^L
.ix Left End of Field
.ix Right End of Field
This call is used to specify exceptions to VT driver processing. At this
time, the only exception defined is for SEDIT; and specifies that fields
also activate on ASCII:RUBOUT at left end of field, and on ^U or ^L at right
end of field.
.sp
.un 5
CC:SETOUTPUTTIMEOUT
.tc
.br
.ix CC:SETOUTPUTTIMEOUT
.ix Timeput Interval
.ix Device Profile Block
.ix VT:MALLPT
.ix Printer,  Large Buffer
.ix WRBUF
This call is used to specify a new value for output timeout interval, and
overrides the default selected by the Device Profile Block last chosen. It
is especially useful with the VT:MALLPT profile when the printer has a large
buffer of its own, and goes "BUSY" for long periods while it prints.  The
interval is specified as a two byte number in WRBUF in 60ths of a second.
.sp
.in
.pa
.tc
STATUS OBTAINABLE FROM THE VT DRIVER
.ix Status
.ix VT Driver
.ix SDOSSET Program
.sp
Many of the statuses available from the VT driver are simply images of data
specified by Control calls to the driver.  This is for convenience of the
SDOSSET program, and allows it to show the operator the "current" settings
of things before modification.
.sp
.in 5
.tc
.un 5
SC:GETPOS
.ix SC:GETPOS
.ix Cursor Position
.ix CC:POSITION
.br
Reads the cursor position in the same form as CC:POSITION.
.sp
.tc
.un 5
SC:GETCOL
.br
.ix SC:GETCOL
.ix Input Line Buffer Empty
.ix Column Number, Output
.ix CC:POSITION
.ix READB
.ix TERSE Command Line
.ix VERBOSE Command Line
If the input line buffer is empty, this returns the output column number;
otherwise, this returns the column number corresponding to the first byte to
satisfy the next read. The column number is the same as used in CC:POSITION.
A READB zeroes the column number. Returning the column number corresponding
to the next input character when there is a partially-read input line makes
it possible to distinguish between "TERSE" command lines and "VERBOSE"
command lines; if the column count is zero when a program gets control,
there must be nothing in the line buffer and so VERBOSE mode is desired;
otherwise, something is in the line buffer and so TERSE mode is desired
(see COMMAND INTERPRETER).
.sp
.tc
.un 5
SC:GETEOF
.ix SC:GETEOF
.ix ^Z
.ix READA Mode
.ix Input Line Buffer Empty
.ix End of File
.ix READB Mode
.ix CLOSE Channel
.ix OPEN Channel
.br
This returns a non-zero byte if ^Z was seen while in READA mode, and the
input line buffer is empty; otherwise, this returns a zero byte.  End of
File status is never set while in READB mode to a VT device.  Note that the
only way to reset this status is to CLOSE and reOPEN the channel.
.sp
.tc
.un 5
SC:GETTYPE
.br
.ix SC:GETTYPE
.ix DVTYP.CONSOLE
.ix DVTYP.PRINTER
Returns DVTYP.CONSOLE or DVTYP.PRINTER, as appropriate.
.sp
.tc
.un 5
SC:GETPARAMS
.ix SC:GETPARAMS
.ix Display Width
.ix Display Depth
.ix Hard Copy Device
.ix Printer
.ix Paper Width
.ix Paper Depth
.br
Returns the width (1 byte) and the depth (1 byte) of the display.  Zero
depth means that the terminal is a hardcopy device with continuous paper.
Printers return paper width and depth.
.in 0
.sp
.in 5
.tc
.un 5
SC:GETPROFILE
.ix SC:GETPROFILE
.ix CC:SETPROFILE
.ix Profile Name
.br
Returns the current profile "name" (a one byte number); suitable for use by
the CC:SETPROFILE control call.
.sp
.tc
.un 5
SC:GETPROFILENAME
.ix SC:GETPROFILENAME
.ix ASCII Text String
.ix Numeric Profile Name
.ix WRBUF
.ix No Such Profile
.ix Sysgen
.ix I/O Package
.ix SDOSSET
.ix DPBs
.br
Returns a one to 16 character ASCII text string corresponding to the numeric
profile "name" (1 byte) specified in WRBUF. This call does NOT change the
profile currently selected on the device. Return a "No Such Profile" error
if the profile name specified in WRBUF is not sysgenned into the I/O
package.  This call is used to all SDOSSET produce a human-readable list of
DPBs configured into a system.
.pa
.tc
.un 5
SC:GETPROFILEALTERATION
.ix SC:GETPROFILEALTERATION
.ix Profile Alteration
.ix CC:ALTERPROFILE
.ix Profile Not Malleable
.br
Returns the current profile alterations in exactly the format given to
CC:ALTERPROFILE.  Gives a "Profile Not Malleable" error if the profile
currently selected is not malleable (and therefore has no alterations).
.sp
.tc
.un 5
SC:GETFREECOUNT
.ix SC:GETFREECOUNT
.ix Output Buffer Available Space
.ix Video Display, Memory-Mapped
.br
Returns a 16 bit integer specifying how much room is currently available in
the output buffer for a device (memory-mapped video displays always return
"1").
.sp
.tc
.un 5
SC:GETDATACOUNT
.ix SC:GETDATACOUNT
.ix Input Ring Buffer
.ix READB
.ix Hanging the System
.br
Returns a 16 bit integer specifying how much data is currently available in
the input ring buffer for this device.  Can be used to prevent hanging the
system when doing READB.
.sp
.tc
.un 5
SC:GETOUTPUTTIMEOUT
.ix SC:GETOUTPUTTIMEOUT
.ix CC:SETOUTPUTTIMEOUT
.ix Output Timeout
.br
Returns the current value of the Output Timeout for this device, in a form
suitable for use with CC:SETOUTPUTTIMEOUT.
.sp
.tc
.un 5
SC:GETBAUDRATE
.ix SC:GETBAUDRATE
.ix Baud Rate
.ix CC:SETBAUDRATE
.br
Returns the current baud rate for this device, in exactly the form required
for CC:SETBAUDRATE.  Devices which cannot change baud rates usually return
"0".
.sp
.IN 0
.IN 5
.tc
.un 5
SC:GETTABS
.ix SC:GETTABS
.ix CC:TABS
.ix Tab Setting
.br
Returns the current tab settings for this device, in exactly the form
required for CC:TABS.
.sp
.tc
.un 5
SC:GETIDLES
.ix SC:GETIDLES
.ix Idle Trigger Character
.ix New Line Sequence
.ix CC:IDLES
.br
Returns the count of idles to follow a Newline sequence, and the Idle
trigger character, in exactly the form required for CC:IDLES.
.sp
.tc
.un 5
SC:GETWRAP
.ix SC:GETWRAP
.ix SC:WRAP
.ix Wrapping
.br
Returns a non-zero byte if Wrapping (see SC:WRAP) is enabled, else return a
zero byte (wrapping is disabled).
.sp
.tc
.un 5
SC:GETCOLORING
.ix SC:GETCOLORING
.ix Color
.ix CC:COLORING
.br
Returns 2 bytes of Coloring information in exactly the form required by
CC:COLORING.
.sp
.tc
.un 5
SC:GETBACKGROUND
.ix SC:GETBACKGROUND
.ix Background Color
.ix CC:COLORING
.br
Returns 1 byte of Background Coloring information in exactly the form
required by CC:COLORING.
.pa
.tc
.un 5
SC:GETACTCOL
.ix SC:GETACTCOL
.ix Column Position
.ix Line Buffer Displacement
.ix Activation Character
.ix READA
.ix READB
.ix Echoing Disabled
.br
Returns both the column position and the line buffer displacement at which
the last activation character was entered (the activation character, itself,
is placed at the end of the input line and is obtained via READA or READB).
Note that if echoing is disabled, the returned column position value will be
meaningless.
.sp
.tc
.un 5
SC:ATTENTIONCK
.ix SC:ATTENTIONCK
.ix Operator Requested Attention
.br
This checks for "Operator Requested Attention" status.  If found, the status
is cleared and an "Operator Requested Attention" error is returned.
.sp
.tc
.un 5
SC:STATUSCK
.ix SC:STATUSCK
.ix Status Has Changed
.ix Activation Character
.ix ^C^C
.ix Timed Input Expired
.ix Device Time Out
.br
This returns a "Status Has Changed" error if the VT device has had an
interesting change of status, which include receipt of an activation
character, receipt of ^C^C, a "Timed Input Expired" error, a "Device Timed
Out" error, etc.
.in
.ll 65
.PW 85
.IN 0
.pa
.tc
CONTROL CHARACTERS
.ix Control Character
.ix Activation Character
.ix CC:SETACTIVATION
.sp 2
This table describes how control characters are treated if they are NOT
marked as activation characters (see CC:SETACTIVATION).
.sp
.in 23
.ix :00
.ix NUL
.un 23
:00~~~~NUL~~~~~input:~~ignored
.sp
.un 8
output:~discarded
.sp
.ix :01
.ix ^A
.ix CAPS LOCK
.un 23
:01~~~~^A~~~~~~input:~~toggles the CAPS LOCK switch,
echoes immediately at the end of the line
.sp
.un 8
output:~prints ^A
.sp
.ix :02
.ix ^B
.ix BASIC Breakpoint
.un 23
:02~~~~^B~~~~~~input:~~requests BASIC breakpoint, 
does not echo
.sp
.un 8
output:~prints ^B
.sp
.ix :03
.ix ^C
.ix Input Buffer
.ix Output Buffer
.ix FREEZE OUTPUT
.ix DISCARD OUTPUT
.ix PAGE MODE
.ix ^P
.ix ^C
.ix KILLPROOF
.ix ^C^C
.un 23
:03~~~~^C~~~~~~input:~~clears the input and output buffers, resets the
FREEZE OUTPUT and DISCARD OUTPUT switches (see ^S, ^O), resets the PAGE
MODE switch (see ^P),  echoes immediately at the end of the line,  aborts
the program if two ^C's are received in succession; ^C^C will be rejected
with a beep if KILLPROOF is set.
.sp
.un 8
output:~prints ^C
.sp
.ix :04
.ix ^D
.ix Debugger
.ix CNFG:VTDEBUG=0
.ix SDOS/MT
.un 23
:04~~~~^D~~~~~~input:~~invokes the debugger immediately, 
does not echo; a beep is echoed if no debugger is available
(CNFG:VTDEBUG=0).  Illegal under SDOS/MT.
.sp
.un 8
output:~prints ^D
.sp
.ix :05
.ix ^E
.ix Input Erased
.ix Input Buffer
.un 23
:05~~~~^E~~~~~~input:~~causes all input at, and to the right of, the
cursor to be erased from the display and deleted from the input
buffer.
.sp
.ix Display Line
.ix Erase to End of Line
.un 8
output:~erases the remainder of the display line (erase to EOL)
.sp
.ix :06
.ix ^F
.ix Cursor Position
.ix Hard Copy Terminal
.ix Input Field
.un 23
:06~~~~^F~~~~~~input:~~positions cursor at left side (front) of current
input field. Illegal for hardcopy terminals.
.sp
.un 8
output:~prints ^F
.IN 0
.pa
.IN 23
.ix :07
.ix ^G
.ix BASIC Execution
.ix BASIC Breakpoint
.ix Beep
.un 23
:07~~~~^G~~~~~~input:~~causes BASIC to resume execution from the  current
breakpoint, does not echo
.sp
.un 8
output:~beeps
.sp
.ix :08
.ix ^H
.ix Backspace
.un 23
:08~~~~^H~~~~~~input:~~implements the backspace function, does not echo
.sp
.un 8
output:~implements the backspace function. Backspace across edge of screen
is not allowed.
.sp
.ix :09
.ix ^I
.ix Tab Column
.un 23
:09~~~~^I~~~~~~input:~~positions the cursor at the next tab column, when read
.sp
.un 8
output:~positions the cursor at the next tab column
.sp
.ix :0A
.ix ^J
.ix Rejected with Beep
.ix CC:SETFIELDSIZE
.un 23
:0A~~~~^J~~~~~~input:~~rejected with beep; see CC:SETFIELDSIZE
.sp
.un 8
output:~discarded
.sp
.ix :0B
.ix ^K
.ix Rejected with Beep
.ix CC:SETFIELDSIZE
.un 23
:0B~~~~^K~~~~~~input:~~rejected with beep; see CC:SETFIELDSIZE
.sp
.un 8
output:~prints ^K
.sp
.ix :0C
.ix ^L
.ix Forespace
.un 23
:0C~~~~^L~~~~~~input:~~implements the forespace function,
does not echo
.sp
.ix PAGE BREAK
.IX PAGE MODE
.IX ^P
.ix Background Color
.ix Clear Display
.ix Printer Device
.ix Top of Form
.un 8
output:~causes a PAGE BREAK if the PAGE MODE switch is set (see ^P), homes
the cursor, selects the background color, and clears the display if depth is
not zero, prints ^L if the the depth is zero; for a printer device, moves
paper to the top of form, such that the next character will be printed in
the first position of the line.
.sp
.ix :0D
.ix ^M
.ix <CR><LF>
.un 23
:0D~~~~^M~~~~~~input:~~echoes <CR><LF>, causes program activation
.sp
.un 8
output:~prints <CR><LF>
.sp
.ix :0E
.ix ^N
.ix Passed to Application
.un 23
:0E~~~~^N~~~~~~input:~~passed to the application, echoed when read
.sp
.un 8
output:~prints ^N
.sp
.ix :0F
.ix ^O
.ix DISCARD INPUT
.IX ^Q
.IX ^C
.IX READA
.IX CC:ACTIVATIONCK
.un 23
:0F~~~~^O~~~~~~input:~~toggles the DISCARD OUTPUT switch (see ^Q, ^C),
echoes immediately; not functional while a READA or CC:ACTIVATIONCK control
call is being satisfied
.sp
.un 8
output:~prints ^O
.IN 0
.PA
.IN 23
.ix :10
.ix ^P
.ix PAGE MODE
.ix ^Q
.ix ^C
.ix End of Line
.un 23
:10~~~~^P~~~~~~input:~~toggles the PAGE MODE switch (see ^Q, ^C),
echoes immediately at the end of the line
.sp
.un 8
output:~prints ^P
.sp
.ix :11
.ix ^Q
.ix Output Suspended
.ix PAGE BREAK
.IX ^P
.IX DISCARD OUTPUT
.IX ^Q
.IX FREEZE OUTPUT
.IX ^S
.un 23
:11~~~~^Q~~~~~~input:~~resumes output suspended due to a PAGE BREAK (see
^P), resets the DISCARD OUTPUT switch (see ^Q), resets the FREEZE OUTPUT
switch (see ^S), does not echo
.sp
.un 8
output:~prints ^Q
.sp
.ix :12
.ix ^R
.ix CRT
.ix Cursor Position
.ix Input Field
.ix Hard Copy Device
.ix <CR><LF>
.un 23
:12~~~~^R~~~~~~input:~~if CRT, positions cursor to Right end of
current input field; for hardcopy devices echoes ^R<CR><LF> followed by
all data entered since the last activation
.sp
.un 8
output:~prints ^R
.sp
.ix :13
.ix ^S
.ix FREEZE OUTPUT
.ix ^Q
.ix ^C
.un 23
:13~~~~^S~~~~~~input:~~sets the FREEZE OUTPUT switch (see ^Q, ^C),
echoes immediately
.sp
.un 8
output:~prints ^S
.sp
.ix :14
.ix ^T
.ix Toggle BASIC Line Trace Switch
.un 23
:14~~~~^T~~~~~~input:~~toggles the BASIC line trace switch,
does not echo
.sp
.un 8
output:~prints ^T
.sp
.ix :15
.ix ^U
.ix Character Delete
.ix Input Buffer
.un 23
:15~~~~^U~~~~~~input:~~deletes the character at the current cursor location,
deletes the corresponding character from the input buffer, does not echo
.sp
.un 8
output:~prints ^U
.sp
.ix :16
.ix ^V
.ix Toggle BASIC Single Step Switch
.un 23
:16~~~~^V~~~~~~input:~~toggles the BASIC single step switch, does not echo
.sp
.un 8
output:~prints ^V
.sp
.ix :17
.ix ^W
.ix CRT
.ix Input Line, Last
.ix Hard Copy Device
.un 23
:17~~~~^W~~~~~~input:~~for CRTs, causes the last input line to be
retrieved as though the typist had entered it explicitly, if no
other keys have been typed since the last input.  Illegal for hardcopy
devices.
.sp
.un 8
output:~prints ^W
.sp
.IN 0
.PA
.IN 23
.ix :18
.ix ^X
.ix Input Buffer, Clear
.ix Hard Copy
.ix <CR><LF>
.ix Erase on Terminal
.ix Activation Character
.ix Cursor Position
.ix Field Content
.ix Field Location
.un 23
:18~~~~^X~~~~~~input:~~clears the input buffer; for hardcopy, echoes
^X<CR><LF> and positions to the column at which input began; for a terminal,
erases, from the display, the data entered since the last activation
character, and positions the cursor at the location where input began; for a
terminal with fields defined, erases the displayed field contents, and
positions the  cursor at the first location of the field
.sp
.un 8
output:~prints ^X
.sp
.ix :19
.ix ^Y
.un 23
:19~~~~^Y~~~~~~input:~~passed to the application, echoed when read
.sp
.un 8
output:~prints ^Y
.sp
.ix :1A
.ix ^Z
.ix End of File
.un 23
:1A~~~~^Z~~~~~~input:~~causes END OF FILE status to be set, causes program
activation with an END OF FILE error, echoes immediately at the end of the
line
.sp
.un 8
output:~prints ^Z
.sp
.ix :1B
.ix ESC
.ix Operator Requested Attention
.un 23
:1B~~~~ESC~~~~~input:~~causes cursor to be placed at right end of current
input field, OPERATOR REQUESTED ATTENTION status to be set, and returns
"Operator Requested Attention" error.
.sp
.ix ^[
.un 8
output:~prints ^[
.sp
.ix :1C
.ix ^\
.un 23
:1C~~~~^\~~~~~~input:~~passed to the application, echoed when read
.sp
.un 8
output:~prints ^\
.sp
.ix :1D
.ix ^]
.un 23
:1D~~~~^]~~~~~~input:~~passed to the application, echoed when read
.sp
.un 8
output:~prints ^]
.sp
.ix :1E
.ix ^^
.un 23
:1E~~~~^^~~~~~~input:~~passed to the application, echoed when read
.sp
.un 8
output:~prints ^^
.IN 0
.PA
.IN 23
.ix :1F
.ix ^_
.un 23
:1F~~~~^_~~~~~~input:~~passed to the application, echoed when read
.sp
.un 8
output:~prints ^_
.sp
.ix :7F
.ix RUB
.ix Character Delete
.ix Input Buffer
.un 23
:7F~~~~RUB~~~~~input:~~deletes the character preceeding the current cursor
location, deletes the corresponding character from the input buffer, does
not echo
.sp
.un 8
output:~discarded
.sp 3
.in 6
.un 6
NOTE:~No control character is passed to the application unless explicitly
noted.
.in
.pa
.tc
SOFTWARE SWITCHES AFFECTED BY CONTROL CHARACTERS
.sp
.in 5
.un 5
CAPS LOCK
.ix CAPS LOCK
.IX READA
.IX Lowercase Letter
.ix Uppercase Letter
.ix ^A
.br
When set, READA will interpret the lowercase letters a-z as uppercase
letters.  ^A toggles the switch.  If a terminal is stuck in upper case, and
the alpha lock key isn't the problem, someone probably typed ^A by accident.
.sp 1
.un 5
FREEZE OUTPUT
.ix FREEZE OUTPUT
.ix Output Suspended
.ix CRT
.ix ^S
.ix ^Q
.ix ^C
.ix Reset Switch
.br
When set, further output will be suspended until the switch is reset. On
CRTs, ^S will be displayed to remind the typist that the switch has been
set. ^S sets the switch, ^Q and ^C reset the switch.
.sp 1
.un 5
DISCARD OUTPUT
.ix DISCARD OUTPUT
.ix READA
.ix READB
.ix Output Discarded
.ix ^O
.ix ?
.ix ^Q
.ix ^C
.br
When set, all output will be discarded until either the switch is reset or a
READA/READB is issued.  ^O will be displayed to remind the typist that the
switch has been set.  A READA will reset the switch and overwrite the "^O"
with "? ".  A READB will simply reset the switch.  ^O toggles the switch, ^Q
and ^C reset the switch.
.sp 1
.un 5
PAGE MODE & PAGE BREAK
.ix PAGE MODE
.IX PAGE BREAK
.IX WRITEA
.ix Display Depth
.ix Clear Screen
.ix Cursor Position
.br
When set, subsequent WRITEA lines will be counted, and when <display depth>
lines have been output, a Clear screen request is output, or cursor
positioning is attempted, then a PAGE BREAK will occur, and no more output
will occur until the typist has acknowledged the page break. This gives the
typist a chance to read what is displayed before more output occurs. On a
.ix CRT
.ix ^P
.ix Hard Copy Device
.ix ^Q
.ix ^C
CRT, a page break will be signalled by ^P being displayed in the lower
right-hand corner of the screen; on hardcopy devices, output will simply
cease. The acknowledgement can be ^P (which prevents further page breaks),
^Q (which allows output until the next page break), or ^C (which prevents
further page breaks). On CRTs, a Clear screen requests causes a page break
BEFORE the screen is cleared, so the text may be read before it disappears;
on hardcopy terminals, the page break occurs AFTER the FORM character moves
.ix Form Character
.ix Truncated Line
.ix Wrapping
the paper to top-of-page, so individual sheets of paper may be conveniently
printed. All lines output while in page mode will be truncated to fit within
the current display width, thus ensuring that line wrapping does not occur
so that all lines between page breaks will be captured on the display.
.sp 2
.in 6
.ix Reminder Display
.un 6
NOTE:~All reminders are displayed in the lower, right corner of the display.
Reminders will overwrite any characters already in those locations.
.in
.pa
.tc
SDOS/MT SUPPORT
.ix SDOS/MT Support
.sp
.ix Control Function
.ix Status Function
The following control and status functions are included for complete
documentation only.  They are subject to change without notice.
.sp
Caveat Emptor!!
.sp 2
.tc
MULTIUSER CONTROL FUNCTIONS
.ix Control Function, Multiuser
.in 5
.sp
.un 5
CC:SETTIMESHARE
.ix CC:SETTIMESHARE
.ix SDOS/MT Flag
.ix ^C^C
.ix SDOS/MT Already Running
.ix RDBUG
.ix System Dependent Linkage
.br
Sets the SDOS/MT flag, which results in different handling of the line flags
and ^C^C abort.  If the flag has already been set, an
"SDOS/MT~Already~Running" error is returned.  RDBUF is filled with
system-dependent linkage information for use by SDOS/MT.
.sp
.un 5
CC:STOPTIMESHARE
.ix CC:STOPTIMESHARE
.ix SYSTEM CRASH
.ix SDOS/MT Flag
.ix User Program
.ix WARNING
.br
Turns off the SDOS/MT flag.  SHOULD NOT BE EXECUTED BY USER PROGRAMS, OR A
SYSTEM CRASH WILL RESULT.
.sp
.un 5
CC:WRITEANOWAIT
.ix CC:WRITEANOWAIT
.ix WRBUF
.ix Asynchronous WRITEA
.ix WRLEN
.ix Source of Data
.ix RDBUF
.br
This defines, for the VT driver, WRBUF as the source of data for an
asynchronous WRITEA of WRLEN bytes.  RDBUF contains 3 bytes, the first of
which the VT driver will set to zero when the request is accepted, and set
to non-zero when WRLEN bytes have been written; the remaining two bytes will
contain either an error code, or zero if the operation had no errors. Note
that WRBUF must not be modified until the request is complete (the first
byte of RDBUF becomes non-zero).
.sp
.un 5
CC:WRITEBNOWAIT
.ix CC:WRITEBNOWAIT
.ix WRBUF
.ix Asynchronous WRITEB
.ix WRLEN
.br
This defines, for the VT driver, WRBUF as the source of data for an
asynchronous WRITEB of WRLEN bytes.  RDBUF contains 3 bytes, the first of
which the VT driver will set to zero when the request is accepted, and set
to non-zero when WRLEN bytes have been written; the remaining two bytes will
contain either an error code, or zero if the operation had no errors. Note
that WRBUF must not be modified until the request is complete (the first
byte of RDBUF becomes non-zero).
.sp
.in
.ll 65
.pa
.tc
MULTIUSER STATUS FUNCTIONS
.sp
.ll 60
.in 5
.un 5
SC:GETLINEFLAGSHINT
.ix SC:GETLINEFLAGSHINT
.ix Line Flag
.ix SC:GETLINEFLAGS
.ix True Line Flag
.br
Returns zero if no line flags have been collected since the last call to
SC:GETLINEFLAGS, otherwise returns non-zero value.  The value returned is
only intended as a hint; the program must call SC:GETLINEFLAGS to get the
true line flags and acknowledge their receipt. Don't ask why.
.sp
.un 5
SC:GETLINEFLAGS
.ix SC:GETLINEFLAGS
.ix Line Flag
.ix ^C^C
.ix SDOS/MT
.IX KILLPROOF Flag
.ix Program Killed
.br
Exchanges a zero with the line flags, and returns that byte. If ^C^C has
been seen while the SDOS/MT and KILLPROOF flags are set,  a "Program Killed"
error will be returned; otherwise, ^C^C will result in the program being
killed.
.sp
.un 5
SC:GETTIMESHARE
.ix SC:GETTIMESHARE
.IX SDOS/MT Running
.ix SDOS/MT Already Running
.br
This checks to see if SDOS/MT is running.  If it is, an
"SDOS/MT~Already~Running" error will be returned; otherwise, a normal return
will be made.
.sp
.un 5
SC:ALLSTATUS
.ix SC:ALLSTATUS
.ix SC:STATUSCK
.ix Status Has Changed
.br
This checks to see if an SC:STATUSCK status call issued to any VT device
would return a "Status Has Changed" error as a response; if so, a "Status
Has Changed" error is returned.  Note that this status call supplies only a
hint.
.in
.ll 65
.pa
.pa
.tc
The CLOCK: Device Driver
.ix CLOCK: Device Driver
.ix Time
.ix Date
.sp
The CLOCK: device is used to set and read the current time and date.  Since
its function is limited, so is its conformance to the SDOS file concept.
.sp
.ix OPEN
.IX CREATE
.IX RENAME
.IX DELETE
.IX WRITEA
.IX CONTROL
.IX Illegal Operation
.ix CLOSE
The CLOCK: device can only be OPENed.  CREATE, RENAME, DELETE, WRITEA, and
CONTROL operations are illegal.  CLOSE does nothing except to disassociate
the I/O channel from the driver.
.sp
.ix READA
A READA directed to the CLOCK: device returns a string of 17 bytes in the
following form:
.sp
.im 1
        HH:MM:SS MO/DD/YY
.ix ASCII:CR
.ix READA
.ix Line Mode
.ix Buffer Space
.sp
where HH is hours on a 24 hour clock, MM is minutes, SS is seconds, MO is
the month, DD is the day number, and YY is the year modulo 100.  An ASCII:CR
is appended if the READA has line mode enabled and buffer space permits.
.sp
.ix READB
A READB returns 6 bytes exactly in the following form:
.sp
.im 1
        T T T M D Y
.sp
where T T T is a 24 bit binary value equal to the number of 1/60 second
clock ticks since midnight; D is the day, M is the month, and Y is the year
modulo 100, all in BCD.
.sp
.ix WRITEB
.ix READB
.ix Time of Day, Set
A WRITEB must write exactly 6 bytes in the format read
by READB, and is used to set the time of day.
.sp
.ix SC:GETTYP
.ix DVTYP.CLOCK
The only status syscall accepted is SC:GETTYP, which returns DVTYP.CLOCK.
.sh SECTION III: SYSCALLS
.pa
.tc
SYSCALLS - CONCEPTS
.tc
.ix Syscall Concept
.sp
.ix System Call
.ix Subroutine Call
.ix Parameter Block
Programs running under SDOS communicate with it via system calls
(SYSCALLs). A SYSCALL is a subroutine call (from the user program to SDOS)
with a parameter block describing the function to be performed.
.sp
This section describes the general philosophy behind the SYSCALLs and their
general format.  It assumes some knowledge of assembly language.
.sp
.ix Function Code
.ix Write Buffer
.ix Reply Buffer
.ix Parameter
The most general form of a SYSCALL contains a function code, some fixed
parameters needed by the function, a (pointer to) Write buffer and a
(pointer to) Reply buffer.  Essentially, the SYSCALL causes the specified
function to be performed according to the parameters, using data from the
write buffer, and storing a result in the reply buffer.  Many readers will
recognize this as an implementation of
.sp
.im 1
        RDBUF:= F(PARAMS, WRBUF)
.sp
.ix Networking
The purpose of constraining all SYSCALLs to this form is to simplify the
process of transmitting a request from one computer to another, to
facilitate networking of multiple computers.
.sp
.ix Syscall Execution
Conceptually, SYSCALL execution proceeds as follows:
.sp
.in 3
.un 3
1)~The user program issues a SYSCALL.
.br
.un 3
2)~SDOS transmits the function code, the parameters, and the contents of the
WRITE Buffer from the user's computer to some target computer.
.br
.un 3
3)~The target computer processes the SYSCALL and produces a reply.
.br
.un 3
4)~The reply, along with any error information, is sent back to the SDOS
which sent out the request.
.br
.un 3
5)~SDOS places the reply in the user program's reply buffer.
.sp
.in 0
.ix Stand-Alone System
.ix Target Computer
.ix User's Computer
In a stand-alone system, the target computer and the user's computer are one
and the same.
.sp
.ix Forwarding Logic
The primary advantage of this scheme is that by forcing all SYSCALLS to have
a fixed form for transmitting, performing, and receiving replys to function
requests, the software logic processing the request can forward it to
another computer without having a lot of function-specific knowledge.  In
particular, it means that the forwarding logic need not be changed even when
new functions are added to the list of legal SYSCALLs.
.pa
.ix OPEN
.ix READ
.ix LOAD
.IX STATUS
.IX ASCII
.ix EXIT to System
.ix CLOSE I/O Channel
.ix Buffer, Write
.ix Buffer, Reply
Typical SYSCALL functions are: OPEN file, READ byte stream, LOAD a program,
etc.  Not all functions require write data (i.e., a STATUS Syscall needs
only the function, some parameter bytes and a reply buffer); nor do all
functions return a result (WASCII writes a string of ASCII bytes to a file
and returns no result).  Some functions have neither write nor reply buffers
(i.e., EXIT to system).  Furthermore, many functions have side effects (like
CLOSE I/O channel).
.sp
SYSCALL Format:
.tc
.sp
The following definitions give the formats of a SYSCALL block
.ix SCBLK
(SCBLK).
.sp
.ix Syscall Block Displacement
.ix ORG
.IX SCBLK:OPCODE
.IX SCBLK:WLEN
.IX SCBLK:PARAMS
.IX SCBLK:WRBUF
.IX SCBLK:WRLEN
.IX SCBLK:RPLEN
.IX SCBLK:RDBUF
.IX SCBLK:RELEN
.IX SCBLK:DATA
.IX SCBLK:END
.im 22
*
*      SYSCALL BLOCK DISPLACEMENTS
*
ORG     0
SCBLK:OPCODE   RMB     1       Primary SYSCAL Function (Open,
                               Read, Etc.)
SCBLK:WLEN     RMB     1       Wait Flag Bit (0=Wait) and SYSCALL
                               Block Length (0..127)
SCBLK:PARAMS   RMB     2       Parameter Bytes to Opcode (Secondary
                               Opcode, Channel #)
SCBLK:WRBUF    RMB     2       Pointer to Write Data Buffer
SCBLK:WRLEN    RMB     2       Number of Bytes in Write Data Buffer
SCBLK:RPLEN    RMB     2       Length of Reply (Result of SYSCALL)
SCBLK:RDBUF    RMB     2       Pointer to Read Data Buffer (Where
                               Result Goes
SCBLK:RDLEN    RMB     2       Ceiling on Size of Reply (Read Data
                               Buffer)
SCBLK:DATA     RMB     0       Other Parameters for SYSCALL; up
                               to 127-14=113 Bytes
SCBLK:END      RMB     0       End of SYSCALL Block;
                               Assert SCBLK:WLEN[1..7]=
                               SCBLK:END-SCBLK:OPCODE
.sp
.in 5
.ix SCBLK:OPCODE
.IX Definition, SYSCALL Opcode
.ix Legal Operation
.un 5
SCBLK:OPCODE is the desired function, and occupies a single byte.  Legal
functions under SDOS 1.0 are shown in table 1. (Definitions of all values
for SYSCALL opcodes and related information is given in the SDOSIOPKDEFS.ASM
listing in the back of this manual).
.pa
.ix SCBLK:WLEN
.IX LENgth
.ix Wait Flag
.ix Execution Time
.ix READ/WRITE Overlap
.ix SCBLK:OPCODE
.IX SCBLK:WLEN
.un 5
SCBLK:WLEN is a single byte with two parts: a Wait flag (the most
significant bit) and a LENgth (2 to 127, measured in bytes) (the SYSCALL
block length).  The wait flag is intended to allow overlapped READ and WRITE
operations to files, but is not implemented in SDOS 1.0.  When this bit = 0,
it means "wait for operation complete before returning control to user
program".  "1" means "don't wait".  To retain compatibility with future
releases of SDOS, the user is advised to leave this bit reset (0).  The LEN
field specifies precisely how long the SYSCALL block is.  Each opcode
requires that this byte have some minimum value, or the SYSCALL will be
aborted. The LEN field is used to determine how much data must be sent to
another computer.  The LEN field can specify more bytes than actually needed
by the SYSCALL without ill effect, but processing the unused bytes may
increase the execution time of the SYSCALL.  All SYSCALLs have at least the
SCBLK:OPCODE and SCBLK:WLEN bytes.
.sp
.ix SCBLK:PARAMS
.ix I/O Channel
.ix STATUS
.IX CONTROL
.IX SETERROR
.ix Error Code
.ix LEN
.IX CLOSE
.IX EXIT
.un 5
SCBLK:PARAMS are 2 bytes used for sundry purposes as parameters to the
opcode requested.  Three cases are of particular note: first, one of the two
parameter bytes is generally used to hold an I/O channel number on
I/O-oriented SYSCALLS.  Second, a parameter byte may contain an opcode
extension byte, as with the STATUS and CONTROL SYSCALLs; the parameter byte
selects which control function is to be performed or the particular piece of
status information to read back.  The third case is some 16 bit number, such
as passing an error code to SDOS via the SETERROR SYSCALL.  In no case may
these two bytes contain a pointer or any other kind of reference to other
data in the memory of the user's computer; only data values or relative
references to data in the write buffer or the SYSCALL block itself are legal
(because after the SYSCALL has been sent to another computer, how could we
follow a pointer?) SCBLK:PARAMs need not be included in the LEN count for
SYSCALLS such as SYSCALL:CLOSE, SYSCALL:EXIT, etc.
.sp
.ix SDBLK:WRBUF
.IX SCBLK:WRLEN
.IX Data Buffer, Write
.ix WRITEB
.ix Write Binary
.IX Data Buffer Definition
.un 5
SCBLK:WRBUF and SCBLK:WRLEN define the starting address of the write data
buffer, and its length in bytes.  SCBLK:WRBUF contains the address of the
first byte of the buffer; SCBLK:WRLEN contains the number of bytes in the
buffer (0 to 65535).  Note that SCBLK:WRLEN is the actual number of bytes to
be processed by the SYSCALL, not the allocated size of the buffer.  These
parameters are used in SYSCALLs involving filenames to specify the (device
and) filename desired, or as data buffer definitions for SYSCALL:WRITEB
(Write Binary), etc.
.pa
.ix SCBLK:RDBUF
.IX SCBLK:RPLEN
.ix SCBLK:RDLEN
.IX Buffer Address
.ix Reply Byte
.un 5
SCBLK:RDBUF and SCBLK:RDLEN select a buffer address and size in which a
SYSCALL result/reply is returned.  The SCBLK:RDLEN must contain the expected
maximum size of the result (in bytes). SCBLK:RPLEN is set to the actual
length of the reply given, that is, the actual number of reply bytes placed
in the RDBUF.   Many SYSCALLs do not return a result. If the SYSCALL block
includes space for SCBLK:RPLEN, it will be zerod if no reply is given. If
RDBUF overlaps any part of the SYSCALL block or the WRBUF, the SYSCALL
operation is not well defined. When an error is returned by a syscall,
RPLEN and RDBUF contents are undefined (unless explicitly specified by
description of the particular syscall). In particular, there is no
guarantee that the RDBUF contents are preserved (even in the presence of an
error).
.sp
.ix SCBLK:RDLEN
.in 0
Bytes in the SYSCALL block beyond SCBLK:RDLEN are interpreted in a manner
specific to the particular SYSCALL opcode (like the SCBLK:PARAMs bytes). 
Most SYSCALLs do not need or use these bytes.
.sp
An error occurring during execution of a SYSCALL is handled in the manner
described under SDOS Error handling.  The calling sequence for SYSCALLS is
thus:
.sp
.in 5
.im 9
        .
        .
        .
        LDX     #SYSCALLBLOCKADDRESS
        JSR     SYSCALL$        (Equated TO $FB)
        BCS     OOPS            (Go Process Error Code In X)
        .
        .
        .
.in 0
.sh SECTION IV: ERROR HANDLING
.pa
.tc
ERROR HANDLING
.ix Error Handling
.ix Error Recovery
.sp
Error handling is an important part of any programming system.  It allows
application programs to continue or effect recovery in spite of problems
encountered. The error handling strategy outlined here is used throughout
most SD software. Facilities to handle errors in a similar fashion are
provided by the SD BASIC Compiler, so application programs can also support
the same scheme.
.sp
.ix Error Code
.ix Error, SDOS
.ix Error, BASIC
.ix Error, EDIT
Errors detected by SDOS are passed back to the user program for inspection
or handling. Each error which can occur is assigned a 16 bit error code (0
to 65535).  Blocks of codes are assigned to each possible detector of an
error (i.e., errors which SDOS detects have codes from 1000 to 1999,
compiled BASIC programs detect errors 2 to 99, EDIT errors are 200 to 299,
etc.).
.sp
.ix Exit, Successful
.ix Exit, Error
Each (assembly or SYSCALL) subroutine has two exits: a success exit (meaning
no unexpected/unrecoverable errors occurred) and an error exit (meaning some
error which the subroutine cannot handle occurred).
.sp
If the success exit is taken, normal processing can continue. If the error
exit is taken, an error code is passed back to the caller for his
inspection.  The caller has three options:
.sp
.in 3
.un 3
1)~Process and recover from the error (example: for "No Such
File" error on an OPEN, a standard default file name might be
OPENed).
.br
.un 3
2)~Give up; notify the operator of the error and exit.
.br
.un 3
3)~Decide to pass the error back to his caller with an error indication.
This option is particularly important when the caller can fail in many ways
not understood by the caller (such as I/O faults).
.sp
.in 0
.ix Error Code
Processing the error requires explicit checking for each of the possible
error codes of interest (due to the large number of unexpected errors, an
"if it's not this, it must be that" scheme is not safe; one should ALWAYS
check explicitly). Sometimes, data associated with the error is needed for
the processing routine to continue; in these cases, the original detector of
the error must have saved that data in a place agreed upon by the detector
and the routine attempting recovery.  An example is a "recovery" routine
that prints out the Logical Sector Number of a disk sector on which a read
error occurred -- the recovery routine must know that a GETLASTBADLSN STATUS
syscall will retrieve the LSN desired.
.pa
.IX SYSCALL:ERROREXIT
.ix DEFAULTPROGRAM
.IX Command Interpreter
.ix DO File
.ix EFERROR
.ix Error Code
"Giving up" is aided by the SDOS SYSCALL:ERROREXIT. The error code is stored
into the SYSCALL block, and the SYSCALL is executed.  SDOS will print a text
message corresponding to the error code, and pass control to the command
interpreter (DEFAULTPROGRAM).  The command interpreter can retrieve this
error code, and a DO file can process it via IFERROR statements (see command
interpreter description).
.sp
.ix Error Code
.ix Recovery Routine
Passing back the error code to the next level of subroutine is generally
done only if the recovery routine does not find an error code it is willing
to handle.  This provides an opportunity for subroutines at successively
higher levels to effect recovery.
.sp
.ix Error Handling Philosophy
The subroutine calling convention that implements this error handling
philosophy is as follows:
.sp
.pw 120
.ll 100
.cp 27
.im 27
        *                       (S) = K HERE
        JSR     Subroutine
        BCS     ERROROCCURRED
        *       SUCCESS EXIT    (S) = K HERE
        .
        .
        .
        CLC                     FLAG "SUCCESS EXIT"
        RTS
ERROROCCURRED   EQU     *       (S) = K HERE
        CPX     #ERR:--
        BEQ     HANDLE1STERROR
        CPX     #ERR:--
        BEQ     --
        .
        .
        .
        SEC                     (6809 "CMPX" DESTROYS CARRY BIT)
        RTS                     WITH CARRY SET, INDICATING ERROR

HANDLE1STERROR  EQU     *       TO RECOVER FROM 1ST ERROR
        .
        .
        .
        CLC                     (OKRTS IN DEFS)
        RTS




.ll 65
.pw 85
.pa
Carry reset on exit means the subroutine completed successfully.  The carry
set on exit from a subroutine means "error occurred" (only for those
subroutines which adhere to this convention!); the X register contains a 16
bit error code.  Note that the calling subroutine must provide a BCS after
the JSR in order to detect an error.  The ERROROCCURRED routine tests the X
register for errors from which it can recover; if the wrong error happens,
no test will match and another RTS (with carry  set) will occur, providing
the next higher level subroutine a chance at processing the error code.  In
either case, error or not, the contents of the stack above the return
address is untouched.  The stack register itself has the original value of
the stack pointer at the time of the JSR, so that all higher level routines
can be returned to exactly as normal.  Last, notice that the HANDLEERROR and
the success paths both exit by clearing the carry (indicating "success"
exit).
.sp
.ix SYSCALLS
.ix BCC
.ix BCS
.ix Return Address
SYSCALLs are implemented as subroutine calls and follow the above convention
with one variation.  If an error occurs, SDOS unwinds the stack until a
return address on top of the stack points to a BCC or BCS. This means that a
SYSCALL must be followed by a BCC/BCS or SDOS will unwind the stack too far,
with unpredictable results.  The unwinding process consists of repeatedly
popping two bytes, and assuming the top of the stack is a return address,
(with obviously bad consequences if this is not true) until an appropriate
return address is found (This scheme was chosen to minimize the amount of
processing an SDOS routine had to do when it didn't care about errors, and
has the side effect of speeding things up 5 to 10 percent).
.sh SECTION V: SYSCALLS - IMPLEMENTATION
.in 0
.pa
.tc
SYSCALLS - Implementation
.tc
.ix Implementing SYSCALLs
.ix Opcode Value
.sp
This section details the SYSCALLs implemented in this version of SDOS. See
SDOSUSERDEFS.ASM listing for opcode values.
.sp
.ix Error, Common
.ix Application Program
.ix Error, Hardware Specific
Errors listed are only common errors, i.e., ones for which application
programs attempt recovery. Many other (even hardware specific errors) are
possible, but due to the size and changing nature of the list, are not
recorded here.
.sp
.ix SYSCALLS, List Of
Table 1 - Syscalls implemented in SDOS 1.1
.sp
.nj
*      SYSCALL$ OPCODE DEFINITIONS
.br
*
.br
.pw 120
.ll 100
.im 34
                    ORG     0
SYSCALL:OPEN        RMB     1   Open File
SYSCALL:CREATE      RMB     1   Create a New File
SYSCALL:CLOSE       RMB     1   Close a File
SYSCALL:RENAME      RMB     1   Rename a File
SYSCALL:DELETE      RMB     1   Delete a File
SYSCALL:LOAD        RMB     1   Load an Overlay
SYSCALL:CHAIN       RMB     1   Chain to a File
SYSCALL:CREATELOG   RMB     1   Create the Log File
SYSCALL:CLOSELOG    RMB     1   Close the Log File
SYSCALL:DISKDEFAULT RMB     1   Select Default Disk Device
SYSCALL:READA       RMB     1   Read ASCII Bytes From a File
SYSCALL:READB       RMB     1   Read Binary Bytes From a File
SYSCALL:WRITEA      RMB     1   Write ASCII Bytes To a File
SYSCALL:WRITEB      RMB     1   Write Binary Bytes To a File
SYSCALL:CONTROL     RMB     1   Perform a Control Operation
                                On a File/Device
SYSCALL:STATUS      RMB     1   Read File/Device Status
SYSCALL:WAITDONE    RMB     1   Wait for I/O on Channel to Complete
SYSCALL:EXIT        RMB     1   Give Control Back to Operating System
SYSCALL:ERROREXIT   RMB     1   Exit to System With Error Code
SYSCALL:SETERROR    RMB     1   Report an Error To The System
SYSCALL:GETERROR    RMB     1   Read Back the Last Error Code
SYSCALL:DISPERROR   RMB     1   Display Error Message Corresponding
                                To Last Error Code
SYSCALL:KILLPROOF   RMB     1   Prevent User Program Being Killed
SYSCALL:KILLENABLE  RMB     1   Allow User Program to be Killed
SYSCALL:DEBUG       RMB     1   Call System Debugger
SYSCALL:ATTNCHECK   RMB     1   Operator Attention Request Check
SYSCALL:ISCONSOLE   RMB     1   Check Channel 0 Input Device = Console:
SYSCALL:INTERLOCK   RMB     1   Perform Interlock functions on objects
SYSCALL:DELAY       RMB     1   Delay for n 1/60ths of a second
SYSCALL:NOTUSED     RMB     1
SYSCALL:GETSERIALNUMBER RMB 1   Get processor serial number

.ll 65
.pw 85
.ju
.pa
.tc
SYSCALL:OPEN
.ix SYSCALL:OPEN
.ix I/O Channel
.ix File, Read
.ix File, Updated
.sp
This SYSCALL is used to establish an association between an existing file
(to be read and/or updated) and an I/O channel.
.sp
OPEN SYSCALL Block Format:
.sp
.im 13
        SCBLK:OPCODE    FCB     SYSCALL:OPEN
        SCBLK:WLEN      FCB     SCBLK:END-SCBLK:OPCODE
        SCBLK:PARAMS    FCB     CHANNELNUMBER,IGNORED
        SCBLK:WRBUF     FDB     FILENAMESTRING
                                POINTS TO FIRST BYTE
        SCBLK:WRLEN     FDB     FILENAMELENGTH
                                IN BYTES
        SCBLK:RPLEN     RMB     2       EXPECTED RETURNED VALUE OF 2
        SCBLK:RDBUF     FDB     SCANNEDCOUNT
                                # FILENAME CHARACTERS
                                PROCESSED
        SCBLK:RDLEN     FDB     2       SIZE OF RDBUF
        SCBLK:END       EQU     *
.sp
.ix WAIT
.ix WRBUF
.ix File Name
.ix WRLEN
The WAIT flag must be zero.  The first parameter byte is the channel number
desired.  The second parameter byte is not used.  The Write Buffer (WRBUF)
contains the filename (including device name, etc.) desired, WRLEN contains
the number of bytes in the filename.
.sp
.ix Channel
.ix RDBUF
.ix Directoried Device
.ix Error
The OPEN SYSCALL checks the channel to ensure that it is not open already. 
If not open, the filename is scanned to determine the selected device
(default to DISK: if no device) and a filename on that device.  The number
of bytes scanned is returned as a 2 byte value in the buffer selected by
RDBUF; the rest of the bytes in WRBUF are ignored.  Leading blanks on the
filename are ignored, but are included in the scanned count.  (Note: All
SYSCALLs that deal with file or device names return the number of bytes of
the filename scanned as the result.  The entire filename is scanned even if
an error occurs.) The device is searched for the file if it is a directoried
device, and an error issued if not found. If the device is not a directoried
device, the device is simply opened. The file is positioned so that a
subsequent read will read the zeroth (first) byte of the file.
.sp
(Some) possible errors are:
.sp
.ix Error, Bad File Name
.ix Error, No Such File
.ix Error, Can't Open, Must Create
.ix Error, No Such Device
.ix Error, Channel Busy
.im 5
        Bad File Name
        No Such File
        Can't Open, Must Create
        No Such Device
        Channel Busy
.pa
.tc
SYSCALL:CREATE
.ix SYSCALL:CREATE
.ix File, New
.ix I/O Channel
.ix Channel Number, I/O
.sp
This SYSCALL is used to CREATE a new file and establish an association
between an I/O channel number and the new file. It is also used when a
program will do output only to a device (such as a line printer; the
philosophy is that such output is a new file).
.sp
CREATE SYSCALL Block Format:
.sp
.im 9
        SCBLK:OPCODE    FCB     SYSCALL:CREATE
        SCBLK:WLEN      FCB     SCBLK:END-SCBLK:OPCODE
        SCBLK:PARAMS    FCB     CHANNELNO,IGNORED
        SCBLK:WRBUF     FDB     FILENAMESTRING
        SCBLK:WRLEN     FDB     FILENAMELENGTH
        SCBLK:RPLEN     RMB     2       EXPECTED RETURNED VALUE OF 2
        SCBLK:RDBUF     FDB     SCANNEDCOUNT
        SCBLK:RDLEN     FDB     2       SIZE OF SCANNED COUNT
        SCBLK:END       EQU     *
.ix WAIT
.ix WRBUF
.ix Channel Number
.sp
The WAIT flag must be zero.  The first parameter byte is the desired channel
number; the second parameter byte is ignored. WRBUF points to the filename
(device name) of the new file.
.sp
.ix RDBUF
.ix SYSCALL:OPEN
Like SYSCALL:OPEN, RDBUF points to a 2 byte area in which the number of
bytes of the filename scanned by SDOS is placed on completion of the
SYSCALL.
.sp
.ix File, Disk
.ix OPEN
.ix Close
.ix Crash, System
.ix Delete, Implied
.ix File, Write Protected
If a disk file is specified and there is an old file, the old file must
not write protected or an error will occur and the new file will not be
created (nor will the channel be opened).  Otherwise, the new file is
created, and the channel is opened.  If an old file does exist, an OPEN
SYSCALL executed after the CREATE, looking for the same file, will find the
old file.  If the system crashes before the new file is closed, the old
file will be unaffected in any way. Even after the new file is closed,
channels still open to the old file will not notice any difference. When the
last channel to the old file is closed, it is deleted and the space for the
old file is returned to free disk space.  Effectively, a CREATE includes an
"implied" delete of the older version of the file.
.sp
The file is positioned so that a write will write its first byte in byte #0
of the file.
.sp
.ix Error, File is Delete Protected
.ix Error, File is Write Protected
.ix Error, No Such Device
.ix Error, Channel is Busy
.ix Error, Bad File Name
.ix Error, File is Being Created
Possible errors are:
.sp
.im 6
        File is Delete Protected
        File is Write Protected
        No Such Device
        Channel is Busy
        Bad Filename
        File is Being Created
.pa
.tc
SYSCALL:CLOSE
.ix SYSCALL:CLOSE
.ix Channel, I/O
.ix File
.sp
The CLOSE SYSCALL is used to break the association between an I/O channel
number and a file.
.sp
CLOSE SYSCALL Format:
.sp
.im 4
        SCBLK:OPCODE    FCB     SYSCALL:CLOSE
        SCBLK:WLEN      FCB     SCBLK:END-SCBLK:OPCODE
        SCBLK:PARAMS    FCB     CHANNELNO,IGNORED
        SCBLK:END       EQU     *
.sp
This SYSCALL frees the I/O channel to be opened to another file, and causes
the CLOSE entry point of a device driver to be called.  Action of the driver
is driver-dependent.
.ix Disk File
.ix Directory
.ix Free Disk Space
.sp
If the channel was open to a disk file, then changes to the file size,
protection, and other characteristics are updated on the disk (not before). 
If the disk file is newly created, and is not replacing another by the same
name, closing will make its name appear in the directory.  If the file is
newly created, and it is a replacement for a file that already exists (i.e.,
one by the same name), then the new file will replace the old in the
directory, and the disk space allocated to the old file will be returned to
free space as soon as no other I/O channels remain open to the old version
of the file.
.sp
Possible errors are:
.sp
.ix Error, Illegal Channel Number
.ix Error, Channel is Already Closed
.im 2
        Illegal Channel Number
        Channel is Already Closed
.pa
.tc
SYSCALL:RENAME
.ix SYSCALL:RENAME
.IX Channel
.ix File
.sp
The RENAME Syscall is used to change the name of a file.  The file must be
open on some channel; it must not be a newly created file, and no file (new
or old) having the new name must exist.
.sp
RENAME SYSCALL Format:
.sp
.im 9
        SCBLK:OPCODE    FCB     SYSCALL:RENAME
        SCBLK:WLEN      FCB     SCBLK:END-SCBLK:OPCODE
        SCBLK:PARAMS    FCB     CHANNELNUMBER,IGNORED
        SCBLK:WRBUF     FDB     NEWFILENAME
        SCBLK:WRLEN     FDB     NEWFILENAMELENGTH
        SCBLK:RPLEN     RMB     2       EXPECTED RETURNED VALUE OF 2
        SCBLK:RDBUF     FDB     SCANNEDCOUNT
        SCBLK:RDLEN     FDB     2
        SCBLK:END       EQU     *
.sp
.ix OPEN
The SYSCALL format is identical to that of an OPEN syscall; parameters and
results are passed the same way.
.sp
This SYSCALL affects nothing except the name of the file.
.ix OPEN Speed Up
.sp
RENAMEing a disk file to its own name is legal, and can speed up later OPENs
of that file since a rename causes the file name to be re-hashed into the
directory.  Refer to hash-lookup description of files.
.sp
Possible errors are:
.sp
.ix Error, New File Exists Already
.ix Error, File is Write Protected
.ix Error, File is Delete Protected
.ix Error, Can't Rename to a Different Device
.ix Error, File is Being Created
.ix Error, Bad File Name
.IX Error, Channel Not Open
.im 7
        Channel Not Open
        Bad File Name
        File is Being Created
        Can't Rename to a Different Device
        File is Delete Protected
        File is Write Protected
        New File Already Exists
.pa
.tc
SYSCALL:DELETE
.ix SYSCALL:DELETE
.sp
.ix File
The DELETE SYSCALL is used to delete a file from a disk device.
.sp
DELETE SYSCALL Format:
.sp
.im 9
        SCBLK:OPCODE    FCB     SYSCALL:DELETE
        SCBLK:WLEN      FCB     SCBLK:END-SCBLK:OPCODE
        SCBLK:PARAMS    FCB     IGNORED,IGNORED
        SCBLK:WRLEN     FDB     FILENAMEBUFFER
        SCBLK:WRBUF     FDB     FILENAMESIZE
        SCBLK:RPLEN     RMB     2       EXPECTED RETURNED VALUE OF 2
        SCBLK:RDBUF     FDB     REPLYBUFFER
        SCBLK:RDLEN     FDB     REPLYBUFFERSIZE
        SCBLK:END       EQU     *
.ix Directory
.ix I/O Channel
.ix Closed
.ix Illegal Operation
.sp
The file specified on the specified device is deleted (this syscall is not
legal for devices which do not have directories).  No I/O channel is
specified or needed.  If the deletion is successful, the directory entry is
removed so that the file can no longer be opened.  If the file is open on
some I/O channel when the delete SYSCALL is issued, then the SYSCALL will
complete successfully, but the file will not actually be deleted until the
last channel open to the file is closed (in fact, the file may actually be
allocated more disk space via the other channel!).
.sp
The reply buffer is loaded with the actual length of the filename (see
SYSCALL:OPEN).
.sp
Possible errors are:
.sp
.ix Error, No Such File
.ix Error, File is Delete Protected
.im 2
        No Such File
        File is Delete Protected
.pa
.tc
SYSCALL:LOAD
.ix SYSCALL:LOAD
.ix Overlay Program Segment
.sp 2
The LOAD Syscall is used to load an overlay program segment into memory,
without transferring control.
.sp
LOAD SYSCALL Format:
.sp
.im 9
        SCBLK:OPCODE    FCB     SYSCALL:LOAD
        SCBLK:WLEN      FCB     SCBLK:END-SCBLK:OPCODE
        SCBLK:PARAMS    FCB     IGNORED,IGNORED
        SCBLK:WRBUF     FDB     FILENAMESTRING
        SCBLK:WRLEN     FDB     FILENAMELENGTH
        SCBLK:RPLEN     RMB     2       EXPECTED RETURNED VALUE OF 4
        SCBLK:RDBUF     FDB     COUNTANDSTART
        SCBLK:RDLEN     FDB     4       MINIMUM REQUIRED
        SCBLK:END       EQU     *
.sp
No channel number need be specified.
.ix File Name
.ix Open
.ix File, Load Format
.ix Scatter Loading
.ix Close
.sp
.ix LOADER FORMAT
.ix Memory, Non-Contiguous
The filename specified is opened on a special system channel, and checked to
see if a load format file is given (first byte must be ASCII "S" or Hex
:01).  If so, the file contents are loaded into memory as specified by the
load records (see LOADER FORMATs).  Scatter loading (loading into
non-contiguous parts of memory) is possible.  Upon completion of the loading
process, control is returned to the user, and the file is closed.
.sp
.ix SYSCALL:OPEN
The results returned in the reply buffer are 2 bytes of filename count (the
first 2 bytes; see SYSCALL:OPEN) and 2 bytes of start address (the second 2)
as specified by the load records.
.sp
.ix Abort SDOS
Load records which would load on top or above SDOS cause the load to be
aborted.
.sp
.ix Damage, Address
.ix Damage, SDOS
A load record whose address conflicts with that of the reply buffer may be
damaged; conversely, the reply may be garbled. Loading into the area used by
the stack may cause SDOS to crash.  SDOS does not check for this.
.sp
.ix Error, Loading
.ix Error Exit
Errors while loading cause the error exit of the Syscall to be taken.
.sp
In any case, on completion of the load, the file is closed.
.sp
.ix Encryption
Attempting to LOAD a program with a different encryption key is illegal.
.pa
Possible errors are:
.ix Error, Not a Load File
.ix Error, Bad File Name Size
.ix Error, Bad File Name
.ix Error, Load Record Format
.ix Error, Checksum
.ix Error, End of File Hit (EOF)
.ix Error, No Such File
.sp
.im 7
        Not a Load File
        No Such File
        EOF Hit
        Checksum Error
        Load Record Format Error
        Bad Filename
        Bad Filename Size
.pa
.tc
SYSCALL:CHAIN
.ix SYSCALL:CHAIN
.ix Control, Load
.ix Control, Transfer
.ix Overlay Segment
.ix Program Segment
.sp
The CHAIN Syscall is used to load and transfer control to an overlay or
program segment.
.sp
CHAIN SYSCALL Format:
.sp
.im 9
        SCBLK:OPCODE    FCB     SYSCALL:CHAIN
        SCBLK:WLEN      FCB     SYSCALL:END-SYSCALL:OPCODE
        SCBLK:PARAMS    FCB     IGNORED,IGNORED
        SCBLK:WRBUF     FDB     FILENAMESTRING
        SCBLK:WRLEN     FDB     FILENAMELENGTH
        SCBLK:RPLEN     RMB     2       EXPECTED RETURNED VALUE OF 4
        SCBLK:RDBUF     FDB     COUNTANDSTART
        SCBLK:RDLEN     FDB     4       MINIMUM REQUIRED
        SCBLK:END       EQU     *
.sp
.ix Close I/O Channel
.ix I/O Channel
.ix LRU Queue
.ix LOAD
.ix Error Exit
CHAIN first closes all I/O channels except channel 0. It then causes all
modified disk sectors in the LRU queue to get written back to the disk to
ensure validity of disk contents, and then performs exactly the same
function as SYSCALL:LOAD.  If an error occurs, control will return to the
caller only if no data has been loaded into the user space.  The most common
causes of this are the following errors:
.ix Error, Bad File Name
.ix Error, Bad File Name Size
.ix Error, File Not Found
.ix Error, Not a Load File
.ix Error, No Start Address
.sp
.im 5
        Bad File Name
        Bad File Name Size
        File Not Found
        Not a Load File
        No Start Address
.sp
.ix SYSCALL:ERROREXIT
.ix Terminal Session Record
All other errors will cause an implied SYSCALL:ERROREXIT to be executed
(because of the possibility of the program issuing the CHAIN being
overlayed).
.ix Control Transfer
.sp
On successful completion of the load, control will be transferred to the
start address of the file.  The stack pointer is set to the contents of
$FC,$FD, minus 1 (see SDOS Memory Map).
.sp
.ix Encryption
.ix WARNING
Chaining to a program with a different encryption key will cause the user
space to be zeroed before control is transferred.
.pa
.tc
SYSCALL:CREATELOG
.ix SYSCALL:CREATELOG
.ix Terminal Session Record
.ix Bug
.sp
There are occasions on which a record of a terminal session would be very
convenient, such as when a purported bug arises, or when an example is
required. This copy can be laboriously constructed by hand, or it can be
made automatically via a CREATELOG syscall.
.sp
CREATELOG SYSCALL Format:
.sp
.im 9
        SCBLK:OPCODE    FCB     SYSCALL:CREATELOG
        SCBLK:WLEN      FCB     SCBLK:END-SCBLK:OPCODE
        SCBLK:PARAMS    FCB     CHANNELNO,IGNORED
        SCBLK:WRBUF     FDB     FILENAMESTRING
        SCBLK:WRLEN     FDB     FILENAMELENGTH
        SCBLK:RPLEN     RMB     2       EXPECTED RETURNED VALUE OF 2
        SCBLK:RDBUF     FDB     SCANNEDCOUNT
        SCBLK:RDLEN     FDB     2       SIZE OF SCANNED COUNT
        SCBLK:END       EQU     *
.sp
.ix Channel Number
.ix I/O Channel
.ix File Name Size
.ix OPEN
.ix SYSCALL:CREATE
CREATELOG creates a new file (just like the CREATE syscall), but no channel
number is given (SDOS reserves a special, unnumbered, I/O channel
specifically for this purpose).  It returns file name size information in
the same manner as OPEN.
.sp
.ix Channel, Log
.ix Write ASCII
.ix Read ASCII
.ix Log File
.ix Console Session Copy
There is no way for a user program to explicitly read or write data to the
log channel; all I/O through the log channel is done invisibly by SDOS. 
Essentially, any data written via a Write ASCII to channel 0 (the control
channel) is also copied to the log file.  Data read via a Read ASCII on
channel 0 is also written to the log file.  In this way, a complete copy of
console sessions (carried on through the control channel) is recorded in the
log file for later retrieval.  The writes to the log file are done only when
the log file is open (has been created).
.sp
.ix Syscall, Channel-Oriented
.ix STATUS
.ix CONTROL
STATUS and CONTROL syscalls are re-directed from channel 0 to the log
channel when it is open, so that status information read from channel 0 may
not actually be that of channel 0. All other channel-oriented syscalls (in
particular, Read Binary and Write Binary) are not affected by the log
channel. If the log channel is not open, it has no effect whatsoever on
channel 0 operations.
.sp
.ix SYSCALL:CLOSELOG
.ix CREATE
.ix Program Kill
.ix ^C^C
.ix SDOSCOMMANDS
.ix Command, LOG
.ix Command, DO
The log file will not be found in the directory until it is closed (via
CLOSELOG).  Like any CREATEd disk file, PROGRAM KILL (^C^C) automatically
closes the log file.  This Syscall is used mainly by SDOSCOMMANDS to
implement the LOG and DO commands.
.sp
A program can set up a DO file by:
.sp
.in 3
.un 3
1)~Verifying that the DO file exists by OPENing it on some channel.
.br
.un 3
2)~CLOSEing channel 0
.br
.un 3
3)~OPENing channel 0 to the DO file
.br
.un 3
4)~CREATELOG on the "CONSOLE:" device
.sp
.ix Console I/O
.in 0
Further input will come from the DO file.  If an error occurs during step 2
or 3, the program must reOPEN channel 0 to the CONSOLE: or no further
console I/O can occur.
.sp
Possible errors are:
.ix Error, Channel Already Open
.ix Error, Illegal File Name
.ix Error, No Disk Space
.sp
.im 3
        Channel Already Open
        Illegal File Name
        No Disk Space
.pa
.tc
SYSCALL:CLOSELOG
.ix SYSCALL:CLOSELOG
.ix SYSCALL:CREATELOG
.ix I/O Channel, Log
.sp
This Syscall is used to close the special log I/O channel (see
SYSCALL:CREATELOG).
.sp
CLOSELOG SYSCALL Format:
.sp
.im 3
        SCBLK:OPCODE    FCB     SYSCALL:CLOSELOG
        SCBLK:WLEN      FCB     SCBLK:END-SCBLK:OPCODE
        SCBLK:END       EQU     *
.sp
.ix CLOSE
.ix Log Channel
This Syscall performs the same operation as a CLOSE Syscall on the Log
channel.  No channel number or other parameters are needed.
.sp
Possible errors are:
.sp
.ix Error, Channel Not Open
.im 1
        Channel Not Open
.pa
.tc
SYSCALL:DISKDEFAULT
.ix SYSCALL:DISKDEFAULT
.sp
This SYSCALL is used to select which disk is default-selected when a file
name with no explicit disk device indentification is given.
.sp
DISKDEFAULT SYSCALL Format:
.sp
.im 12
        SCBLK:OPCODE    FCB     SYSCALL:DISKDEFAULT
        SCBLK:WLEN      FCB     SCBLK:END-SCBLK:OPCODE
        SCBLK:PARAMS    FCB     IGNORED,IGNORED
        SCBLK:WRBUF     FDB     FILENAMESTRING
                                POINTS TO FIRST BYTE
        SCBLK:WRLEN     FDB     FILENAMELENGTH
                                IN BYTES
        SCBLK:RPLEN     RMB     2       EXPECTED RETURNED VALUE OF 2
        SCBLK:RDBUF     FDB     SCANNEDCOUNT
                                # FILENAME CHARS PROCESSED
        SCBLK:RDLEN     FDB     2       SIZE OF RDBUF
        SCBLK:END       EQU     *
.sp
.ix Device Name
.ix File Name
DISKDEFAULT parses the device name, and ensures that the device name is a
valid disk device name (filenames passed with the device name are not
examined).  The specified disk will then be used whenever a filename with no
device specification is encountered by a filename SYSCALL.
.sp
No channel number is needed.
.sp
Data is returned in the same form as an OPEN syscall.
.sp
.ix Device Name DISK:
After a successful return, the device name DISK: refers to the default disk.
.sp
Possible errors are:
.ix Error, Device is Not a Disk
.sp
.im 1
        Device is Not a Disk
.pa
.tc
SYSCALL:READA
.ix SYSCALL:READA
.IX Read ASCII Data
.ix File
.ix I/O Channel
.sp 2
This SYSCALL is used to read (ASCII) textual data from a file.  The file
must be open on some I/O channel.
.sp
READA SYSCALL Block Format:
.sp
.im 13
        SCBLK:OPCODE    FCB     SYSCALL:READA
        SCBLK:WLEN      FCB     SCBLK:END-SCBLK:OPCODE
        SCBLK:PARAMS    FCB     CHANNELNUMBER,LMFLAG
        SCBLK:WRBUF     RMB     2
        SCBLK:WRLEN     FDB     0
                                (MINIMIZES PROCESSING TIME)
        SCBLK:RPLEN     RMB     2
                                ACTUAL NUMBER BYTES READ
        SCBLK:RDBUF     FDB     READBUFFER
                                WHERE TO PUT DATA
        SCBLK:RDLEN     FDB     READBUFSIZE
                                MAXIMUM NUMBER BYTES TO READ
        SCBLK:END       EQU     *
.ix Channel
.ix Null
.ix Line
.ix Rubout
.sp
.ix Read Buffer
.ix Error
READA will read the specified number of bytes into the read buffer from the
file open on the specified channel, and advance the file position past the
number of bytes examined, subject to the following conditions: the file has
enough bytes, and no errors occur during the read.  Nulls (:00), line feeds
(:0A), and rubouts (:7F) are deleted from the stream of characters read from
the file/device.
.sp
Bit 7 of all characters read via SYSCALL:READA is zeroed. Other characters
may be removed from the input stream by the particular device driver in use.
.sp
.ix Column Count
.ix Character, Printing
.ix SYSCALL:STATUS
.ix Buffer, Read-Back
.ix <CR>
The column count for this channel is updated for each byte placed in the
read-back buffer, according to the following rule: a printing character
(:20-:7E) causes the column count to be incremented.  CR (:0D) causes the
column count to be zeroed.  All other codes leave the count alone.  The
column count can be read by a SYSCALL:STATUS call.
.sp
.ix LMFLAG
.ix Buffer, Read
If LMFLAG is non-zero, the read proceeds in single line mode. If a CR (:0D)
character is encountered, it will be placed in the read buffer, and the read
will be terminated.  LMFLAG=0 prevents CRs from terminating the read, so the
buffer will be filled.
.sp
.ix SCBLK:RPLEN
.ix Error
SCBLK:RPLEN is set to the actual number of bytes read, even if an error
(such as End of File) occurs.
.sp
.ix WRBUG
The WRBUF is ignored if supplied.
.pa
.ix Channel 0
.ix Log File
.ix CONSOLE:
.ix Error, End of File (EOF)
All data read from channel 0 via a READA is copied (via WRITEA) to the log
file if the log channel has been opened. A READA with LMFLAG=1 directed at
channel 0 will be completed from the CONSOLE: device if a complete line
cannot be read because of an EOF error (this finishes a partial line from a
DO file).
.sp
.ix SYSCALL:READA
.ix Byte Transfer, Speed Up
.ix SYSCALL:WRITEA
.IX SYSCALL:WRITEB
.IX SYSCALL:READB
The overhead for doing a single-byte SYSCALL:READA is fairly high; larger
buffers will cause this overhead to be divided between all the bytes
transferred.  Large buffers can achieve a 40 to 1 speedup over single byte
transfers.  Such speed ups are also typical for SYSCALL:WRITEA,
SYSCALL:WRITEB, and SYSCALL:READB.
.sp
.ix Position, Implied
If the SYSCALL block length is 18 bytes or more, then the first four bytes
of the extension hold a file position, and an implied positioning operation
is performed BEFORE the actual read takes place.  Compared to a CC:POSITION
call followed by a SYSCALL:READA, a combined position/read operation
is considerably more efficient in a network environment, so it is encouraged.
Similar efficiencies accrue for combined position/write operations.
.ix Error, End of File (EOF)
.ix Line Mode
.ix <CR>
.sp
An EOF hit error will occur: (1) if not in line mode and the buffer cannot
be filled; (2) if in line mode and no CR character is encountered before
EOF.
.sp
.ix SYSCALL:STATUS
An end-of-file condition (which can be sensed via a SYSCALL:STATUS) is set
whenever a read of the last data byte of the file occurs.
.sp
Possible errors are:
.sp
.ix Error, Channel Not Open
.ix Error, EOF Hit
.im 2
        Channel Not Open
        EOF Hit
.pa
.tc
SYSCALL:READB
.ix SYSCALL:READB
.ix Binary Data
.ix File
.ix I/O Channel
.sp 2
This SYSCALL is used to read binary data from a file.  The file must be open
on some I/O channel.
.sp
READB Syscall Block format
.sp
.im 13
        SCBLK:OPCODE    FCB     SYSCALL:READB
        SCBLK:WLEN      FCB     SCBLK:END-SCBLK:OPCODE
        SCBLK:PARAMS    FCB     CHANNELNUMBER,IGNORED
        SCBLK:WRBUF     RMB     2
        SCBLK:WRLEN     FDB     0
                                (MINIMIZES PROCESSING TIME)
        SCBLK:RPLEN     RMB     2
                                ACTUAL NUMBER BYTES READ
        SCBLK:RDBUF     FDB     READBUFFER
                                WHERE TO PUT DATA
        SCBLK:RDLEN     FDB     READBUFSIZE
                                MAXIMUM NUMBER BYTES TO READ
        SCBLK:END       EQU     *
.sp
.ix File Position
.ix File Position, Current
.ix File, End of
.ix Buffer Size
.ix Error
READB will read the specified number of bytes into the read buffer from the
file opened on the specified I/O channel, and advance the file position by
the number of bytes actually read.  In order for the specified buffer to be
completely filled, the distance between the current file position and the
end of the file must be greater or equal to the buffer size, and no errors
may occur during the read.  The data bytes read from the file are not
changed in any way.
.sp
.ix SCBLK:RPLEN
SCBLK:RPLEN is set to the actual number of data bytes read (usually equal to
the buffer size).
.sp
.ix Column Count
Using a READB SYSCALL causes the column count for the specified channel to
be zeroed.
.sp
.ix SCBLK:WRBUF
SCBLK:WRBUF is ignored if supplied; however, its length should be specified
as zero to minimize SYSCALL processing time.
.sp
.ix Error, End of File (EOF)
An EOF error will occur if the read request is not completely satisfied
.ix Buffer, Unfilled
(i.e., the buffer was not filled).
.sp
.ix Read, Single-Byte
The overhead for doing single-byte reads is high; long buffers will
distribute this overhead so that the average time per byte is some 40 times
faster than single byte reads.
.sp
.ix Position, Implied
If the SYSCALL block length is 18 bytes or more, then the first four bytes
of the extension hold a file position, and an implied positioning operation
is performed BEFORE the actual read takes place.
.pa
Possible errors are:
.ix Error, Channel Not Open
.ix Error, EOF Hit
.ix Error, Disk Read Error
.ix Error, Device Not Ready
.ix Error, Device Timed Out
.sp
.im 5
        Channel Not Open
        EOF Hit
        Disk Read Error
        Device Not Ready
        Device Timed Out
.pa
.tc
SYSCALL:WRITEA
.ix SYSCALL:WRITEA
.IX ASCII Data Write
.ix Column Count
.sp
WRITEA is used to Write ASCII data to a file.  The primary difference
between this and WRITEB is that the column count gets updated, and certain
output editing is done.
.sp
WRITEA SYSCALL Format:
.sp
.im 6
        SCBLK:OPCODE    FCB     SYSCALL:WRITEA
        SCBLK:WLEN      FCB     SCBLK:END-SCBLK:OPCODE
        SCBLK:PARAMS    FCB     CHANNELNUMBER,IGNORED
        SCBLK:WRBUF     FDB     WRITEDATABUFFER
        SCBLK:WRLEN     FDB     NUMBEROFBYTESTOWRITE
        SCBLK:END       EQU     *
.sp
.ix Open
.ix I/O Channel
.ix File Position
.ix NUMBEROFBYTESTOWRITE
.ix Disk File
.ix Column Count
.ix CRT Driver
.ix WRITEDATABUFFER
The data bytes in the WRITEDATABUFFER are copied to the file open on the
specified I/O channel.  The file position is advanced by
NUMBEROFBYTESTOWRITE.  Disk files are extended automatically, if necessary,
to make more room and the file size is changed.  The column count for this
I/O channel is changed according to the same rules as specified by
SYSCALL:READA.  The output stream may be modified by the device driver; a
CRT driver will typically add LF (:0A) and nulls (idle characters) after a
CR (:0D) character.
.sp
.ix Line Feed <LF>
.ix <CR>
SDOS conventions dictate that LF characters are superflous in the presence
of CR characters.  To write a line of text to a file (or device),
terminating it with a CR is sufficient.
.sp
.ix EOF
.ix Error
An EOF condition will happen if the last data byte of the file is
overwritten, and/or the file was extended in order to accomodate the write
request.  An EOF condition on a WRITE to a disk does not cause an error.
.sp
.ix Channel 0
.ix Log Channel
Data written via WRITEAs to channel 0 is also sent (via WRITEAs) to the log
channel if the log channel is open.
.sp
Multi-byte writes are more efficient than single-byte writes.
.sp
.ix Buffer, Read-Back
No read-back buffer is required.
.sp
.ix Position, Implied
If the SYSCALL block length is 18 bytes or more, then the first four bytes
of the extension hold a file position, and an implied positioning operation
is performed BEFORE the actual read takes place.
.sp
Possible errors are:
.ix Error, Device Not Ready
.ix Error, Device Timed Out
.ix Error, Disk Write Error
.ix Error, Disk Space Exhausted
.ix Error, Channel Not Open
.sp
.im 5
        Channel Not Open
        Disk Space Exhausted (for disk files)
        Disk Write Error
        Device Timed Out
        Device Not Ready
.pa
.tc
SYSCALL:WRITEB
.ix SYSCALL:WRITEB
.sp 2
.IX Binary Data Write
.ix File
The WRITEB SYSCALL is used to write binary data to a file. The stream of
data bytes is copied directly to the file or device without any change to
its content.
.sp
WRITEB SYSCALL Format:
.sp
.im 6
        SCBLK:OPCODE    FCB     SYSCALL:WRITEB
        SCBLK:WLEN      FCB     SCBLK:END-SCBLK:OPCODE
        SCBLK:PARAMS    FCB     CHANNELNUMBER,IGNORED
        SCBLK:WRBUF     FDB     WRITEDATABUFFER
        SCBLK:WRLEN     FDB     NUMBEROFBYTESTOWRITE
        SCBLK:END       EQU     *
.sp
.ix Open
.ix File Position
.ix NUMBEROFBYTESTOWRITE
.ix Disk File
.ix File Size
.ix Column Count
The data bytes in the specified buffer are copied without change to the file
that is open on the specified I/O channel. The file position is advanced by
NUMBEROFBYTESTOWRITE.  If necessary, a disk file is extended automatically
to make more room, and the file size is adjusted accordingly.  The column
count for this channel is zeroed.
.ix Single-Byte Write
.ix Multi-Byte Write
.sp
Multi-byte writes are more efficient than single-byte writes.
.sp
.ix EOF
An EOF condition will happen if the last data byte of the file is
overwritten, and/or the file was extended in order to accomodate the write
request.
.sp
No read-back buffer is required.
.sp
.ix Position, Implied
If the SYSCALL block length is 18 bytes or more, then the first four bytes
of the extension hold a file position, and an implied positioning operation
is performed BEFORE the actual read takes place.
.sp
Possible errors are:
.ix Error, Device Not Ready
.ix Error, Disk Write Error
.ix Error, Illegal Device Operation
.ix Error, Disk Space Exhausted
.ix Error, Channel Not Open
.sp
.im 6
        Channel Not Open
        Disk Space Exhausted
        Illegal Device Operation
                (for line-printer-like devices)
        Disk Write Error
        Device Not Ready
.pa
.tc
SYSCALL:CONTROL
.ix SYSCALL:CONTROL
.ix I/O Channel Number
.ix Rewind
.ix Eject
.ix Dismount
.ix OPEN
.sp 2
This SYSCALL is used to control or modify the operation of a device/file. 
The first parameter byte selects the I/O channel number; the second
parameter byte determines the actual operation performed (rewind, eject,
dismount, etc.) so this SYSCALL actually represents an entire class of
operations.  A control operation may be issued only to an I/O channel that
is already OPEN.
.sp
.ix Logging
.ix CONTROL Operation
.ix Log Channel
If logging is active, and a CONTROL operation is issued for channel 0, the
control operation is actually applied to the log channel.
.sp
CONTROL SYSCALL Block Format:
.sp
.im 7
        SCBLK:OPCODE    FCB     SYSCALL:CONTROL
        SCBLK:WLEN      FCB     SCBLK:END-SCBLK:OPCODE
        SCBLK:PARAMS    FCB     CHANNELNUMBER
                        FCB     CC:controlcode
        SCBLK:WRBUF     FDB     CONTROLPARAMETERS
        SCBLK:WRLEN     FDB     NUMBEROFCONTROLBYTES
        SCBLK:END       EQU     *
.sp
.ix Control Operation, Device Specific
.ix Control Operation, Common
SDOS divides device control operations into two classes: common, and device
specific.  Common control operations are those operations for which all
devices generally have a capability.  Currently only the following
operations fit in the category of common:
.ix CC:POSITION
.IX CC:DUMPBUFFERS
.sp
.im 1
        CC:POSITION and CC:DUMPBUFFERS
.sp
.ix Select Echo Mode
.ix Set Tab
.ix Dismount Tab
All other control operations are device specific and are documented with the
specific device driver.  Typical device-specific operations include: select
echo mode, set tabs, and dismount disk.
.ix CONTROL SYSCALL
.ix Buffer, Write
.sp
The format of the CONTROL SYSCALLs varies because different device
operations require different parameters.  In particular, most CONTROL
SYSCALLs do not require a write buffer.  For specific formats, refer to the
device driver descriptions.
.pa
.tc
CC:POSITION
.ix CC:POSITION
.ix File
.ix File Position
.ix Rewind
.ix Port Number
.ix Screen Position
.sp 2
CC:POSITION is used to select the next byte of a file to be read/written.  A
4 byte, 2's complement integer is used to select the byte index into a
(disk) file (it can also be used as a record number, a port number, a screen
position, or whatever is appropriate for the device).  The number must be
positive (i.e., the sign bit must be zero) or an error will result.
Following a CC:POSITION command, further read/writes start from the
specified file position and advance sequentially.  A "rewind" is obtained by
specifying a zero for the value of the 4 byte integer.
.sp
.ix Disk File
.ix EOF
.ix Error
Setting a file position which is equal or greater than the size of the
(disk) file will cause an EOF condition to occur and cause an error.
.sp
No reply is given for this syscall.
.ix CRT
.ix CRT Driver
.ix Row
.ix Column
.ix Cursor Position
.ix Screen
.ix Display
.sp
Alphanumeric CRTs are an interesting special case.  It is standard for SDOS
CRT drivers to interpret the positioning parameter as cursor positioning
data.  The parameter is interpreted as 2 bytes of zero, 1 byte to specify
the screen row number (zero being the top screen row) and 1 byte of column
number (zero being the leftmost column).  Given R for row and C for column,
the value of the positioning parameter is then Row*256+Column.  In this way,
cursor positioning on screens is generalized to work for a broad variety of
CRT displays.
.sp
CC:POSITION SYSCALL Format:
.sp
.im 10
        SCBLK:OPCODE    FCB     SYSCALL:CONTROL
        SCBLK:WLEN      FCB     SCBLK:RPLEN-SCBLK:OPCODE
        SCBLK:PARAMS    FCB     CHANNELNUMBER,CC:POSITION
        SCBLK:WRBUF     FDB     POSITIONDATA
        SCBLK:WRLEN     FDB     4
        .
        .
        .

        POSITIONDATA    RMB     4       NEED FILE POSITION
.sp
For CRTs, POSITIONDATA has the following form:
.sp
.im 6
        POSITIONDATA    FCB     0,0
        SCREENROW       RMB     1
        SCREENCOL       RMB     1
        .
        .
        .

.pa
CC:DUMPBUFFERS
.tc
.ix CC:DUMPBUFFERS
.ix I/O Device
.sp
CC:DUMPBUFFERS is used to force an I/O device to dump any buffers it may
still have filled. CC:DUMPBUFFERS is particularly useful in transaction
oriented programs which need to force all disk file changes back to the
disk. No parameters are required; operation is device specific.
.sp
CC:DUMPBUFFERS Format:
.sp
.im 3
        SCBLK:OPCODE    FCB     SYSCALL:CONTROL
        SCBLK:WLEN      FCB     SCBLK:WRBUF-SCBLK:OPCODE
        SCBLK:PARAMS    FCB     CHANNELNUMBER,CC:DUMPBUFFERS
.pa
.tc
SYSCALL:STATUS
.ix SYSCALL:STATUS
.ix File
.ix Open
.ix Channel
.ix READA
.ix READB
.ix Buffer, Reply
.sp
The STATUS Syscall is used to read file or device-dependent descriptive data
about that file or device (as opposed to reading data from the file or
device itself).  This syscall is really an entire group of operations; a
parameter byte selects the device-specific data to read.  A STATUS Syscall
must reference an open I/O channel.  Like READA and READB, the data is read
back into the reply buffer.
.ix Channel 0
.ix Logging
.ix Log Channel
.sp
If a STATUS syscall is issued for channel 0, and logging is active, the
status read back will be that of the log channel, not channel 0.
.sp
STATUS SYSCALL Block Format:
.sp
.im 8
        SCBLK:OPCODE    FCB     SYSCALL:STATUS
        SCBLK:WLEN      FCB     SYSCALL:END-SYSCALL:OPCODE
        SCBLK:PARAMS    FCB     CHANNELNO,SC:statuscode
        SCBLK:WRBUF     FDB     IGNORED
        SCBLK:WRLEN     FDB     IGNORED
        SCBLK:RPLEN     FDB     CHANGED
        SCBLK:RDBUF     FDB     STATUSBUFFER
        SCBLK:RDLEN     FDB     STATUSCODEDEPENDENTLENGTH
.sp
There are two classes of STATUS requests: those standard across all devices,
and those specific to the particular device type.  The following status
information is obtainable from most devices:
.sp
.ix SC:GETPARAMS
.IX SC:GETTYP
.IX SC:GETFILESIZE
.IX SC:GETEOF
.IX SC:GETCOL
.IX SC:GETPOS
.im 6
                 SC:GETPOS
                 SC:GETCOL
                 SC:GETEOF
                 SC:GETFILESIZE
                 SC:GETTYP
                 SC:GETPARAMS
.sp
All other status-reading operations are device specific and are detailed
under the specific device drivers.
.sp
.ix SC:GETPOS
.ix File, Current Position
.ix Device Driver
.in 5
.un 5
SC:GETPOS is used to read the current position in a file, i.e., if one
executes a CC:POSITION command, an SC:GETPOS will read back the same value
as the positioning value given for the CC:POSITION.  SC:GETPOS always reads
back four data bytes (the interpretation of these bytes is up to the device
driver).
.ix SC:GETCOL
.ix Print Position
.ix READA
.ix WRITEA
.ix I/O Channel
.sp
.un 5
SC:GETCOL reads back the print position of a simulated print head on a
particular I/O channel (see READA, WRITEA syscalls).  0 means "no characters
printed on this line." Only one data byte is returned.
.pa
.ix SC:GETEOF
.ix I/O Channel
.ix End of File
.un 5
SC:GETEOF returns a single-byte flag indicating whether the I/O channel has
positioned, read or written past the last data byte in the file.  A non-zero
returned byte indicates past or at end of file; zero means more data can be
read from the file before the end of file is encountered.
.sp
.ix SC:GETFILESIZE
.ix File
.ix Disk File
.un 5
SC:GETFILESIZE returns the size of the file (in bytes).  The size is
returned as a four byte integer, appropriate for use in a positioning
command (this is convenient for appending data to the end of a file).  This
is normally only implemented on disk files.
.sp
.ix SC:GETTYP
.ix FILE
.IX DISK
.IX TAPE
.IX DIRECTORIED TAPE
.IX CONSOLE
.IX LINEPRINTER
.IX SERIALOUT
.IX SERIALIN
.IX PARALELLOUT
.IX PARALELLIN
.IX DUMMY
.ix Device Type
.un 5
SC:GETTYP returns a single-byte device type code, which places a device into
one of the following classes: FILE, DISK, TAPE, DIRECTORIED TAPE, CONSOLE,
LINEPRINTER, SERIALOUT, SERIALIN, PARALELLOUT, PARALELLIN, DUMMY.  Other
device types may be added as needed.
.ix SC:GETPARAMS
.ix SC:GETTYP
.sp
.un 5
SC:GETPARAMS reads device class-specific parameters.  To know what kind of
data to expect for a reply, the program must first determine the device type
(using SC:GETTYP).  Currently defined device-specific parameters are:
.sp
Disk FILE:
.ix Disk File
.ix NSPC
.ix NBPS
.sp
.im 2
            DVDAT:NSPC      Number of Sectors Per Cluster
            DVDAT:NBPS      Sector Size in Bytes
.sp
.in 12
.ix File Size Computation, Maximum
The maximum file size may be computed as:
.sp
.im 1
                 (NBPS*NSPC/2-1)*NBPS*NSPC
.sp 2
.ix DISK Device
.in 5
DISK Device:
.sp
.ix NBPS
.IX NSPT
.IX NTPC
.IX NCYL
.im 4
            DVDAT:NBPS      Number of Bytes Per Sector
            DVDAT:NSPT      Number of Sectors Per Track
            DVDAT:NTPC      Number of Tracks Per Cylinder
            DVDAT:NCYL      Number of Cylinders
.sp
.ix CONSOLE:
.IX WIDTH
.IX DEPTH
CONSOLE:
.sp
.im 3
            DVDAT:WIDTH     In Characters
            DVDAT:DEPTH     Screen or Page Depth in Lines, or
                            0 If Continuous Form Paper
.sp
PRINTER:
.ix PRINTER:
.IX WIDTH
.sp
.im 2
            DVDAT:WIDTH     In Characters
            DVDAT:DEPTH     Page Depth in Lines
.pa
.tc
.in 0
SYSCALL:WAITDONE
.ix SYSCALL:WAITDONE
.ix Wait for Operation
.ix I/O Channel
.sp
This system call is used to wait for an operation initiated on an I/O
channel to complete.
.sp
.ix Parallel Initiation
.ix No-Operation
This SYSCALL and the parallel initiation feature ARE NOT IMPLEMENTED IN
FINAL FORM.  It currently is a no-operation, and is provided to allow
programs to be coded as though parallel SYSCALLS were implemented.
.sp
WAITDONE SYSCALL Format:
.sp
.im 4
        SCBLK:OPCODE    FCB     SYSCALL:WAITDONE
        SCBLK:WLEN      FCB     SCBLK:END-SCBLK:OPCODE
        SCBLK:PARAMS    FCB     CHANNELNUMBER
        SCBLK:END       EQU     *
.sp
.ix WAIT Flag
.ix Error
If any parallel SYSCALL (a syscall with the WAIT flag = "don't wait") was
issued on the specified I/O channel, WAITDONE delays the execution of the
user program until that operation is complete.  Error status returned is
that of the parallel SYSCALL returned as though the parallel SYSCALL had the
WAIT flag reset when executed.
.sp
.ix Multiple WAITDONEs
A second WAITDONE issued on an I/O channel, without any other intervening
SYSCALLS, returns immediately with no error possible, so multiple WAITDONEs
on a channel may be performed without conflicts arising.
.pa
.tc
SYSCALL:EXIT
.ix SYSCALL:EXIT
.ix DEFAULTPROGRAM
.ix Pass Control
.sp 2
This syscall is used by a user program to pass control to the
DEFAULTPROGRAM.  It is an indication that the user program completed
execution successfully.
.sp
EXIT SYSCALL Format:
.sp
.im 3
        SCBLK:OPCODE    FCB     SYSCALL:EXIT
        SCBLK:WLEN      FCB     SCBLK:END-SCBLK:OPCODE
        SCBLK:END       EQU     *
.sp
There are no parameters, and control does not return to the user program.
.sp
.ix I/O Channel
.ix CLOSE
All I/O channels except channel 0 are CLOSEd.
.sp
.ix SDOS Checksum
.ix EXIT
.ix Error
.ix Memory Failure
SDOS does a quick checksum on itself after an EXIT is completed, and reports
an error if it thinks memory is starting to fail; otherwise, no errors are
possible.
.sp
.ix SYSCALL:ERROREXIT
This syscall is functionally identical to SYSCALL:ERROREXIT with an error
code of 0.
.pa
.tc
SYSCALL:ERROREXIT
.ix SYSCALL:ERROREXIT
.ix Abnormal Cease Execution
.sp 2
This syscall is used by a user program to cease execution abnormally, and
notify the operator the reason for stopping.
.sp
ERROREXIT SYSCALL Format:
.sp
.im 4
        SCBLK:OPCODE    FCB     SYSCALL:ERROREXIT
        SCBLK:WLEN      FCB     SCBLK:END-SCBLK:OPCODE
        SCBLK:PARAMS    FDB     ERRORCODE
        SCBLK:END       EQU     *
.sp
.ix Error Code, ERROREXIT
The error code is displayed on the console as either
.sp
.im 1
        Error <CR>
.br
or
.br
.im 1
        <TEXT MESSAGE> <CR>
.sp
.ix ERRORMSGS.SYS
.ix SYSCALL:DISPERROR
.IX DEFAULTPROGRAM
.IX Command Interpreter
.ix DO File
depending on whether SDOS can successfully extract the corresponding text
message from the ERRORMSGS.SYS file on drive 0 (see SYSCALL:DISPERROR).  If
the error code is 0, a message is not displayed.  Control is then passed to
the DEFAULTPROGRAM (usually the SDOS command interpreter, which can
interrogate and conditionally branch on the error code if a DO file is
being processed). No error is possible.
.sp
.ix Error Handling
This syscall is intended to be used as very simple error handling in user
programs.
.sp
.cp 25
.im 25
Example:

               LDX     #PARAMETERLISTADDRESS
               JSR     SYSCALL$
               BCS     OOPS    B/ ERROR
               .
               .
               .

OOPS           CPX     #ERR:...
               BEQ     ICANHANDLEIT1
               CPX     #ERR:...
               BEQ     ICANHANDLEIT2
               .
               .
               .
IGIVEUP        STX     ERROREXIT+SCBLK:PARAMS
               LDX     #ERROREXIT
               JSR     SYSCALL$
               BCS     *       CAN'T GET HERE!
               JMP     *

ERROREXIT      FCB     SYSCALL:ERROREXIT
               FCB     4       SCBLK:WLEN
               FDB     0       SCBLK:PARAMS
.pa
.tc
SYSCALL:SETERROR
.ix SYSCALL:SETERROR
.IX SYSCALL:DISPERROR
.ix Failure, Syscall
.sp
This syscall, coupled with SYSCALL:DISPERROR, is used by a program to
display the reason a SYSCALL failed.
.sp
SETERROR SYSCALL Format:
.sp
.im 4
        SCBLK:OPCODE    FCB     SYSCALL:SETERROR
        SCBLK:WLEN      FCB     SCBLK:END-SCBLK:OPCODE
        SCBLK:PARAMS    FDB     ERRORCODE
        SCBLK:END       EQU     *
.sp
.ix Error Code
.ix Syscall Block
.ix DISPERROR
.IX GETERROR
.IX EXIT
.IX DEFAULTPROGRAM
.ix Text Display
The user program first stores an error code into the syscall block, and then
issues the syscall.  The error code has now been stored in SDOS for use by
the DISPERROR and GETERROR syscalls.  Normally, a SETERROR is followed by a
DISPERROR, so that a text display of the error cause occurs.  Since control
returns to the user program, this is an effective procedure for displaying
the cause of an error without EXITing to the DEFAULTPROGRAM.
.sp
.ix EXIT
.IX ERROREXIT Syscall
A GETERROR syscall can be used to later retrieve the error code.  A
subsequent EXIT or ERROREXIT syscall will change the code set by SETERROR.
.pa
.tc
SYSCALL:GETERROR
.ix SYSCALL:GETERROR
.sp 2
.ix Error Code
.ix EXIT
.ix ERROREXIT
.ix SETERROR
This syscall is used to retrieve an error code given to SDOS by EXIT,
ERROREXIT, or SETERROR syscalls.
.sp
GETERROR SYSCALL Format:
.sp
.im 11
        SCBLK:OPCODE    FCB     SYSCALL:GETERROR
        SCBLK:WLEN      FCB     SYSCALL:END-SCBLK:OPCODE
        SCBLK:PARAMS    FDB     IGNORED
        SCBLK:WRBUF     FDB     IGNORED
        SCBLK:WRLEN     FDB     IGNORED
        SCBLK:RPLEN     FDB     2       EXPECTED RETURNED VALUE
        SCBLK:RDBUF     FDB     ERRORCODEBUF
                                WHERE TO PUT ERROR CODE
        SCBLK:RDLEN     FDB     2       LENGTH OF 16 BIT ERROR
                                        CODE
        SCBLK:END       EQU     *
.sp
.ix Buffer, Reply
The 2 byte error code last given to SDOS is returned in the reply buffer. 
No parameters other than the reply buffer discriptor are necessary.
.sp
Possible errors are:
.ix Error, Syscall Length Too Short
.ix Error, Read-Back Buffer Too Short
.sp
.im 2
        Syscall Length Too Short
        Read-Back Buffer Too Short
.pa
.tc
SYSCALL:DISPERROR
.ix SYSCALL:DISPERROR
.ix Error Message Display
.ix SYSCALL:EXIT
.IX SYSCALL:ERROREXIT
.IX SYSCALL:SETERROR
.sp
The DISPERROR is used to display a text message corresponding to the most
recent error code given to SDOS by SYSCALL:EXIT, SYSCALL:ERROREXIT, or
SYSCALL:SETERROR.
.sp
DISPERROR SYSCALL Block Format:
.sp
.im 3
        SCBLK:OPCODE    FCB     SYSCALL:DISPERROR
        SCBLK:WLEN      FCB     SCBLK:END-SCBLK:OPCODE
        SCBLK:END       EQU     *
.sp
No parameters are needed.
.sp
Either
.sp
.im 1
        ERROR nnnnn <CR>
.br
or
.ix ERRORMSGS.SYS
.br
.im 1
        <TEXT FROM ERRORMSGS.SYS> <CR>
.ix Channel 0
.ix CONSOLE:
.ix SYSCALL:ERROREXIT
.sp
is displayed on channel 0.  If the error code is 0, and error message IS
displayed (see SYSCALL:ERROREXIT for contrast). If channel 0 is not open,
SDOS automatically opens it to the CONSOLE: device.  SDOS gets the text
message from the ERRORMSGS.SYS file based on the error code.  If SDOS cannot
retrieve the error message from the ERRORMSGS.SYS file, it displays the
simpler form, with nnnnn being the decimal equivalent of the error code.
No carriage return is output, so that the user program may precede
or append text to the error message (such as ...  AT LINE 100 for BASIC).
.sp
.ix Error, Display Processing
.ix Re-Boot
.ix SDOS Hung-Up
If an error occurs during the process of displaying the message, SDOS will
hang.  The operator must re-boot.  This can only occur if SDOS cannot output
to the CONSOLE:.
.pa
.tc
SYSCALL:KILLPROOF
.ix SYSCALL:KILLPROOF
.ix File
.ix Data Base Consistency
.sp 2
This SYSCALL is used by an application which needs to perform a long
computation or large amounts of I/O without being killed by the operator for
correct operation.  This situation occurs when several files need to be
updated in order to maintain data base consistency.
.sp
KILLPROOF SYSCALL Block Format:
.sp
.im 3
        SCBLK:OPCODE    FCB     SYSCALL:KILLPROOF
        SCBLK:WLEN      FCB     SCBLK:END-SCBLK:OPCODE
        SCBLK:END       EQU     *
.sp
.ix ^C^C
.ix ERROREXIT
.ix DEFAULTPROGRAM
Normally, when the operator types ^C^C, SDOS kills the currently running
program and causes a forced ERROREXIT. This in turn displays an appropriate
message and causes the DEFAULTPROGRAM to be loaded.
.sp
.ix Operator Abort
.ix I/O Package
.ix SYSCALL:ATTNCHECK
.ix SYSCALL:KILLPROOF
.ix SYSCALL:KILLENABLE
A double ^C is deferred if a SYSCALL:KILLPROOF has been executed more
recently than a KILLENABLE.  Operation of the program continues undisturbed
until it executes SYSCALL:KILLENABLE, at which point the program is stopped.
The user program can still sense operator attention requests via the
ATTNCHECK syscall.
.sp
.ix EXIT
.IX SDOS
.IX KILLENABLE Mode
.ix DEFAULTPROGRAM
.ix SYSCALL:CHAIN
.ix KILLENABLE Status
On EXIT, SDOS switches user programs back to KILLENABLEd mode automatically,
(actually, the DEFAULTPROGRAM is loaded as a KILLENABLEd user program) so a
set of programs invoked by a DO file is killable.  SYSCALL:CHAIN does not
affect the KILLENABLE status of a program, so a large program consisting of
several serially executed segments can operate entirely KILLPROOFed if
needed.
.sp
Possible errors are:
.ix Error, Syscall Block Too Short
.sp
.im 1
        Syscall Block Too Short
.pa
.tc
SYSCALL:KILLENABLE
.ix SYSCALL:KILLENABLE
.ix Operator Program Kill
.ix KILLDISABLE
.sp 2
This syscall allows a program to be killed by the operator. It is normally
only used after a critical portion of a program, running KILLDISABLEd, is
finished executing.
.sp
KILLENABLE SYSCALL Block Format:
.sp
.im 3
        SCBLK:OPCODE    FCB     SYSCALL:KILLENABLE
        SCBLK:WLEN      FCB     SCBLK:END-SCBLK:OPCODE
        SCBLK:END       EQU     *
.sp
.ix ^C^C
.ix SDOS:KILLPROGRAM
.IX KILLPROOF
.ix Cause Program to Quit
Executing this syscall will allow a program to be killed when the operator
types ^C^C (when the I/O package calls SDOS:KILLPROGRAM).  If a ^C^C (call
to SDOS:KILLPROGRAM) has occurred while the user program was KILLPROOF,
execution of the SYSCALL:KILLENABLE will cause the program to quit execution
immediately (i.e., control does not return to the user program in this
case).
.sp
.ix SDOSCOMMANDS
.ix Command Interpreter
.ix CHAIN
.ix SYSCALL:DISABLE
SDOSCOMMANDS (the command interpreter) runs KILLENABLEd and loads user
programs initially KILLENABLEd.  The user program must execute a
SYSCALL:KILLDISABLE syscall before performing any critical operations (see
SYSCALL:KILLDISABLE). CHAIN syscalls do not affect the KILLENABLE status of
the user program.
.sp
Possible errors are:
.ix Error, Program Killed
.ix Error, Syscall Block Too Short
.sp
.im 2
        Program Killed
        Syscall Block Too Short
.pa
.tc
SYSCALL:DEBUG
.ix SYSCALL:DEBUG
.ix System Debugger
.ix Control Transfer
.sp
The DEBUG syscall is used to transfer control from a user program to the
local system debugger.
.sp
DEBUG SYSCALL Block Format:
.sp
.im 3
        SCBLK:OPCODE    FCB     SYSCALL:DEBUG
        SCBLK:WLEN      FCB     SCBLK:END-SCBLK:OPCODE
        SCBLK:END       EQU     *
.sp
.ix I/O Package Dependency
.ix ERROREXIT, No Debugger
No parameters are needed.  Control is passed to the system debugger's entry
point.  The actual method of passing control is I/O package dependent.  If
there is no debugger, an ERROREXIT is forced.
.sp
.ix IDB
.ix Non-Maskable Interrupt
.ix EXIT from IDB
.ix G Command
For systems with IDB (an SD assembly language debugging tool), control is
passed to the debugger in such a way that a non-maskable interrupt appears
to have occurred.  EXIT from IDB should be made via a "G" command. Using
nnnnG to exit IDB and return to the user program will also work. If a "G"
command is executed, control returns to the user program just beyond the
call, as with any other SYSCALL.
.sp
Possible errors are:
.ix Error, Syscall Too Short
.ix Error, No Debugger
.sp
.im 2
        Syscall Too Short
        No Debugger
.pa
.tc
SYSCALL:ATTNCHECK
.ix SYSCALL:ATTNCHECK
.IX <ESC>
.IX I/O Package
.ix Operator/User Program Interaction
.ix Console:
.sp
This SYSCALL is used to determine if the operator would like to interact
with the user program (the operator normally signals this by striking the
ESCape key on his console; the actual mechanism is determined by the I/O
package).
.sp
ATTNCHECK SYSCALL Block Format:
.sp
.im 3
        SCBLK:OPCODE    FCB     SYSCALL:ATTNCHECK
        SCBLK:WLEN      FCB     SCBLK:END-SCBLK:OPCODE
        SCBLK:END       EQU     *
.sp
.ix Error Exit
.ix ERR:ATTENTION
The ATTNCHECK syscall will return normally if no attention has been
requested since the last ATTNCHECK syscall.  If the operator has requested
attention at least once since the last ATTNCHECK SYSCALL was issued, then an
error exit is taken with error code ERR:ATTENTION.
.sp
There are no parameters and no returned results.
.sp
.ix <ESC>
.ix Line Input Mode
.ix CONSOLE:
Note that depressing ESCape terminates line input mode from the CONSOLE:;
thus, with suitable program design, ESCape can be used to get a program out
of one interaction mode and into another mode of interaction.
.pa
.tc
SYSCALL:ISCONSOLE
.ix SYSCALL:ISCONSOLE
.ix Channel 0
.ix Console
.ix STATUS
.ix Log Channel
.ix Logging
.sp
This system call is used to determine if channel zero is open to the
operator's console (this is needed because a STATUS syscall will read back
the status of the log channel if logging is active).
.sp
.ix Command Interpreter
.ix DO File Aborted
This SYSCALL is used primarily by the command interpreter (when an error is
encountered) to determine whether or not a DO file should be aborted.
.sp
ISCONSOLE SYSCALL Block Format:
.sp
.im 3
        SCBLK:OPCODE    FCB     SYSCALL:ISCONSOLE
        SCBLK:WLEN      FCB     SCBLK:END-SCBLK:OPCODE
        SCBLK:END       EQU     *
.sp
.ix Error Exit
There are no parameters and no returned results.  A normal exit indicates
that channel zero truly is open to the console device; otherwise, an error
exit occurs.  The only possible errors are:
.sp
.ix Error, Channel is Not Open At All
.ix Channel 0 is Open; But Not to the Console
.im 2
        Channel is Not Open at All
        Channel 0 is Open; But Not to the Console
.pa
.tc
SYSCALL:INTERLOCK
.ix SYSCALL:INTERLOCK
.ix Synchronize Usage
.ix INTERLOCK "Object"
.ix Capability
.IX Releasing the Object
.ix Locking an Object
.ix Returning an Error
.ix Null Operation
.SP
This SYSCALL enables multiple users to synchronize usage of one or more
resources (under single-user SDOS, these calls are null operations).  Each
resource is represented by an INTERLOCK "object" (note: future SDOS's will
provide for many other abstract object types), and the means of referencing
that object is called a CAPABILITY.  The functions which the INTERLOCK
syscall will perform, include creating a capability to an interlock object;
destroying an existing capability to an interlock object; reserving an
object for exclusive use (also known as "locking" an object), and, if the
object has been already locked, suspending execution of the caller until
that object has been released; releasing the object, allowing the next
suspended requestor to resume execution; conditionally locking an object,
returning an error if that object is already locked; and releasing and
removing all requests for an object.  Note that objects and capabilities do
not "belong" to users (e.g., user 1 may create an interlock capability to an
object named "MYFILE", communicate that capability to user 2, and proceed to
lock MYFILE twice, thereby  blocking himself; user 2 subsequently releases
MYFILE, which causes user 1 to be unblocked).
.sp
.ix PARAMS Field of SYSCALL Block
The function codes are expressed as 16-bit values in the PARAMS field of the
SYSCALL block; the specific functions and their requirements are:
.sp
.in 5
.un 5
IC:CREATE
.ix IC:CREATE
.IX ERR:NOSUCHOBJECT
.ix Invalid Object
.br
Create a capability to an interlock object.  ERR:NOSUCHOBJECT will be
returned if the named object is invalid.
.sp
.ix WRBUF
.ix WRLEN
.ix RDBUF
WRBUF must contain an object name, and WRLEN must be 16. A 16-byte
capability to the object will be returned in RDBUF.
.sp 2
.un 5
IC:DESTROY
.ix IC:DESTROY
.ix Interlock Object
.ix Suspended Requestor of Object
.IX ERR:OBJECTDESTROYED
.IX ERR:NOSUCHOBJECT
.br
Destroy the usefulness of all capabilities to the named interlock object.
Release the object if it has been locked; release all requests for the
object; release all suspended requestors of the object, with
ERR:OBJECTDESTROYED. If the capability is invalid, ERR:NOSUCHOBJECT will be
returned.
.sp
.ix WRBUF
.ix Valid Capability
.ix WRLEN
WRBUF must contain a valid capability to the object, and WRLEN must be 16.
.pa
.un 5
IC:LOCK
.ix IC:LOCK
.ix Implementation Restriction
.ix ERR:IMPLEMENTATIONLIMITREACHED
.IX ERR:NOSUCHOBJECT
.ix Invalid Capability
.br
Lock the named interlock object.  If the object is already locked, the
caller's execution is suspended until the object has been released.  Under
SDOS/MT 1.2, no more than 32 different objects may be locked at any one time
(implementation restriction); attempted violation of the restriction will
result in ERR:IMPLEMENTATIONLIMITREACHED.  If the capability is invalid,
ERR:NOSUCHOBJECT will be returned.
.sp
.ix WRBUF
.ix Valid Capability
.ix WRLEN
WRBUF must contain a valid capability to the object, and WRLEN must be 16.
.sp 2
.un 5
IC:RELEASE
.ix IC:RELEASE
.ix ERR:NOTLOCKED
.ix Invalid Capability
.ix ERR:NOSUCHOBJECT
.br
Release the named interlock object.  If the object has not been previously
locked, ERR:NOTLOCKED is returned. If the capability is invalid,
ERR:NOSUCHOBJECT will be returned.
.sp
.ix WRBUF
.ix WRLEN
WRBUF must contain a valid capability to the object, and WRLEN must be 16.
.sp 2
.un 5
IC:TEST
.ix IC:TEST
.ix ERR:ALREADYLOCKED
.IX ERR:NOSUCHOBJECT
.IX Invalid Capability
.br
Lock the named interlock object.  If the object is already locked, no
further action is taken and ERR:ALREADYLOCKED is returned. If the capability
is invalid, ERR:NOSUCHOBJECT will be returned.
.sp
.ix WRBUF
.ix WRLEN
WRBUF must contain a valid capability to the object, and WRLEN must be 16.
.sp 2
.un 5
IC:RESET
.ix IC:RESET
.ix ERR:LOCKRESET
.IX ERR:NOSUCHOBJECT
.ix Invalid Capability
.br
Unconditionally release the named interlock object, if locked; remove all
requests for the object.  Callers suspended, awaiting use of the object,
will be returned to execution with ERR:LOCKRESET. If the capability is
invalid, ERR:NOSUCHOBJECT will be returned.
.sp
.ix WRBUF
.ix WRLEN
WRBUF must contain a valid capability to the object, and WRLEN must be 16.
.sp 2
.in 0
.pa
.tc
SYSCALL:DELAY
.ix SYSCALL:DELAY
.sp
.ix Multi-User System
This system call is used by a program to wait for some fixed period of time
before continuing execution. This is useful on multi-user systems when a
periodic check is required, as no resources are used while a program is
waiting for the delay to complete.
.sp
DELAY SYSCALL Block Format:
.sp
.im 4
        SCBLK:OPCODE   FCB   SYSCALL:DELAY
        SCBLK:WLEN     FCB   SCBLK:END-SCBLK:OPCODE
        SCBLK:PARAMS   FCB   DELAY ; in 1/60th second units
        SCBLK:END      EQU   *
.sp
.ix Delay
The delay is a 16 bit value given in 1/60th second units (i.e., 60 = 1
seconds, 3600 = 1 minute, etc.). The actual delay is at least that
requested, and may be longer.
.sp
Possible errors:
.ix Error, Syscall Block Too Short
.sp
        Syscall Block is Too Short
.pa
SYSCALL:GETSERIALNUMBER
.tc
.sp
.ix SYSCALL:GETSERIALNUMBER
This system call is used to read the 8 byte hardware serial number of the
computer.
.sp
GETSERIALNUMBER SYSCALL Block Format:
.sp
.im 8
        SCBLK:OPCODE   FCB   SYSCALL:GETSERIALNUMBER
        SCBLK:WLEN     FCB   SCBLK:END-SCBLK:OPCODE
        SCBLK:PARAMS   FDB   IGNORED
        SCBLK:WRBUF    FDB   IGNORED
        SCBLK:WRLEN    FDB   IGNORED
        SCBLK:RPLEN    FDB   8         EXPECTED RETURNED VALUE
        SCBLK:RDBUF    FDB   SERIALNUMBERBUFFER
        SCBLK:RDLEN    FDB   8

.sp
Possible errors:
.sp
.im 1
        Syscall Block is Too Short
.ix Error, Syscall Block Too Short
.pa
.pw 130
.ll 100
.lm 5
.im 50
ASM/6809 1.4A1: 0000                    
09/17/84 19:43:57; Page 1; Form 1       *** SDOS SYSCALL Example ***
listfile.asm
                5: * This is a sample assembly language program to list
                6: * a file to the console: device (i.e., it does exactly
                7: * the same thing as a list file command does), and
                8: * illustrates use of syscalls and error recovery logic.
                9: *
  0200         10:         org     $200            nice place for program
               11: *       set up the equs we need
               12: *
  0000         13: channel0 equ    0               user terminal channel
  0001         14: channel1 equ    1               channel for file i/o
  0001         15: linemode equ    1               input in "line mode"
               16: *
               17: * Print a "hello" message on user channel
               18: *
0200 8E024C    19: listfile ldx    #himessage
0203 9DFB      20:          jsr    syscall$
               21: * If we get an error when printing the "hi" message
               22: * (i.e., the carry is set), this BCS will take us
               23: * to the error routine which will do an error exit
0205 2528      24:          bcs    error
               25: *
               26: * Now input the name of the file the user wishes
               27: * to list to his/her terminal
               28: *
0207 8E0277    29:          ldx    #inputfilename
020A 9DFB      30:          jsr    syscall$
020C 2521      31:          bcs    error
               32: *
               33: * Next, open the file...to do this we set the length
               34: * of the file name in the OPEN syscall block equal
               35: * the number of characters read in by the last syscall.
               36: * We don't have to move the file name anywhere since
               37: * we very cleverly made the place that SDOS will look
               38: * at for the file name the same place where SDOS
               39: * read in the string from the user
               40: * (similar to INPUT a$\OPEN #1,a$ in BASIC)
               41: *
               42: * Get how many chars the user typed in
020E BE027F    43:          ldx    inputfilename+reada:actualcount
               44: * Set the length of file name to number of chars read
0211 BF028D    45:          stx    openfile+open:length
0214 8E0287    46:          ldx    #openfile       address of syscall block
0217 9DFB      47:          jsr    syscall$        make SDOS open the file
0219 2514      48:          bcs    error           take branch if "no such
               49: *                               file", "bad name", etc.



.lm 10
.ll 65
.pw 85
.pa
.lm 5
.pw 130
.ll 100
.im 50
ASM/6809 1.4A1: 0219                    
09/17/84 19:43:57; Page 2; Form 1       *** SDOS SYSCALL Example ***
listfile.asm
               51: * main program loop
               52: *
021B 8E0291    53: readloop ldx    #readaline      read line from...
021E 9DFB      54:         jsr     syscall$        the input file
               55: *
               56: * Now check to see if the read got an error.
               57: * If it did, see if the error was an end of file.
               58: *
0220 2517      59:         bcs     checkforeof
               60: *
               61: * If we get to here, we know we didn't get an error.
               62: * So set the length of the write buffer equal to the
               63: * number of characters read in
               64: *
0222 BE0299    65:         ldx     readaline+reada:actualcount
0225 BF02A7    66:         stx     writealine+writea:count
               67: *
               68: * and then send the line out to the user
               69: *
0228 8E02A1    70:         ldx     #writealine
022B 9DFB      71:         jsr     syscall$
               72: * If no error on output, go read another line
022D 24EC      73:         bcc     readloop
               74: *
               75: * Error routine: copy error code in X to a syscall
               76: * block which will have SDOS print out the
               77: * corresponding error message and exit
               78: *
022F BF02AB    79: error   stx     errorexit+errorexit:code
0232 8E02A9    80:         ldx     #errorexit
0235 9DFB      81:         jsr     syscall$        SDOS shouldn't return,
0237 25FE      82:         bcs     *               should never get here
               83: *
               84: *  Check for EndOfFile: if so, wrap things up and exit.
               85: *  Otherwise, do an error exit.
               86: *
0239 8C03E9    87: checkforeof cpx #err:eofhit     EndOfFile error?
023C 26F1      88:         bne     error           if not, go complain
023E 8E02AD    89:         ldx     #byemessage     print "I'm done" message
0241 9DFB      90:         jsr     syscall$
0243 25EA      91:         bcs     error           murphy's law strikes again!
0245 8E02BD    92:         ldx     #exit           now exit
0248 9DFB      93:         jsr     syscall$
024A 25E3      94:         bcs     error           this can't happen
               95: *
               96: * end of code



.lm 10
.ll 65
.pw 85
.pa
.lm 10
.pw 130
.ll 100
.lm 5
.im 50
ASM/6809 1.4A1: 024A                    
09/17/84 19:43:57; Page 3; Form 1       *** SDOS SYSCALL Example ***
listfile.asm
               98: * blocks for syscalls
               99: *
  024C        100: himessage ; syscall block to output "hello" message
024C 0C       101:         fcb     syscall:writea
024D 08       102:         fcb     writea:sclen
024E 00       103:         fcb     channel0
024F 00       104:         fcb     ignored         filler
0250 0254     105:         fdb     hitext          pointer to message
0252 0023     106:         fdb     hitextlen       length of message
              107:
0254 48692128 108: hitext  fcc     'Hi! What file do you want to list? '
  0023        109: hitextlen equ   *-hitext        length of message
              110:
  0277        111: inputfilename ; syscall block to accept line from user
0277 0A       112:         fcb     syscall:reada
0278 0E       113:         fcb     reada:sclen
0279 00       114:         fcb     channel0        from the user
027A 01       115:         fcb     linemode        input up to a <cr>
027B 0000     116:         fdb     ignored         dummy write buffer stuff
027D 0000     117:         fdb     ignored
027F 0000     118:         fdb     ignored
0281 02BF     119:         fdb     filenamebuf     read buffer
0283 0100     120:         fdb     filenamebufmax  max amount to read
0285 0002     121:         rmb     2               amount read (set by SDOS)
              122:
  0287        123: openfile ; syscall block to open a file
0287 00       124:         fcb     syscall:open
0288 0E       125:         fcb     open:sclen
0289 01       126:         fcb     channel1
028A 00       127:         fcb     ignored         filler
028B 02BF     128:         fdb     filenamebuf     where user's input is
028D 0004     129:         rmb     4               buffer length (set by pgm)
              130:
  0291        131: readaline ; syscall block to read a line from a file
0291 0A       132:         fcb     syscall:reada
0292 0E       133:         fcb     reada:sclen
0293 01       134:         fcb     channel1
0294 01       135:         fcb     linemode
0295 0000     136:         fdb     ignored         dummy write buffer stuff
0297 0000     137:         fdb     ignored
0299 0000     138:         fdb     ignored
029B 02BF     139:         fdb     readbuffer
029D 0100     140:         fdb     readbuffermax
029F 0002     141:         rmb     2               how much data read




.lm 10
.ll 65
.pw 85
.pa
.lm 5
.pw 130
.ll 100
.im 50
ASM/6809 1.4A1: 029F                    
09/17/84 19:43:57; Page 4; Form 1       *** SDOS SYSCALL Example ***
listfile.asm
  02A1        143: writealine ; syscall block to write a line on terminal
02A1 0C       144:         fcb     syscall:writea
02A2 08       145:         fcb     writea:sclen
02A3 00       146:         fcb     channel0
02A4 00       147:         fcb     ignored         filler
02A5 02BF     148:         fdb     writebuffer
02A7 0002     149:         rmb     2               length of line
              150:
  02A9        151: errorexit ; syscall block to effect error exit
02A9 12       152:         fcb     syscall:errorexit
02AA 04       153:         fcb     errorexit:sclen
02AB 0002     154:         rmb     2               set to error code by pgm
              155:
  02AD        156: byemessage ; syscall block to print "done..."
02AD 0C       157:         fcb     syscall:writea
02AE 08       158:         fcb     writea:sclen
02AF 00       159:         fcb     channel0
02B0 00       160:         fcb     ignored
02B1 02B5     161:         fdb     byetext
02B3 0008     162:         fdb     byetextlen
              163:
02B5 646F6E65 164: byetext fcc     "done..."
02BC 0D       165:         fcb     $0d             carriage return
  0008        166: byetextlen      equ             *-byetext
              167:
  02BD        168: exit ; syscall block to effect normal exit
02BD 11       169:         fcb     syscall:exit
02BE 02       170:         fcb     exit:sclen
              171:
              172: * and here's the i/o buffer
  02BF        173: filenamebuf     equ     *
  02BF        174: readbuffer      equ     *
  02BF        175: writebuffer     equ     *
  0100        176: filenamebufmax  equ     $100
  0100        177: readbuffermax   equ     $100
02BF 0100     178:         rmb     readbuffermax   space for buffer
              179: *
              180: * that's all folks!
              181: *
              182:         end     listfile












.lm 10
.ll 65
.pw 85
.sh SECTION VI: SDOS CONSTRUCTION/FUNCTIONS
.pa
.tc
.ju
WRITING and DEBUGGING User Assembly Programs
.tc
.IX User Assembly Program, Writing
.ix User Assembly Program, Debugging
.ix Assembly Language Program
.sp
Writing a User Assembly-Language program to run under SDOS requires the
following steps:
.sp
.ix EDIT
.ix ASM
.ix DEBUG
.in 3
.un 3
1)~Use EDIT (or some other means) to place the desired assembly source
program on a disk.
.sp
.un 3
2)~Use ASM to produce a listing (optional) and a .BIN (Binary) version of
the desired program.
.sp
.un 3
3)~a)~Execute the program by typing its name
.in 0
.br
.in 6
or
.br
.in 3
.un 3
3)~b)~Debug the program by typing
.sp
.im 1
           .DEBUG name
.ix System Debugger
.ix IDB
.sp
This will pass control to the local system debugger (usually IDB) and
debugging may commence.
.sp
.in 6
.ix Breakpoint
.ix BCC
.ix BCS
.ix SYSCALL:EXIT
.IX SYSCALL:ERROREXIT
.ix Re-Boot
.un 6
Note:~Breakpoints should not be placed on a BCC/BCS after a SYSCALL (SDOS
will not see the BCx if an error occurs and a system failure will result). 
Further, breakpoints should all be removed before a SYSCALL:EXIT or
SYSCALL:ERROREXIT is executed.  Also, SDOS has no "warm start" entry point;
if the program runs away, the operator's only safe choice is to re-boot.
.in 0
.pa
MEMORY MAP
.tc
.ix Memory Map
.sp
The memory of the 6800/6809 computer, when executing a user program under
SDOS, has the following layout:
.ix Memory Content
.sp
.im 1
LOCATIONS              CONTENTS
.sp
.in 15
.un 15
$0-$7 (6800 and 6809)
.br
.un 15
$18-$1F (6801 and 6811)
.ix Scratch
.ix SYSCALL
.br
Scratch temporaries, usable by user program. Note: These temporaries are
also used by SDOS; so any SYSCALL will destroy their contents.
.un 15
.sp
.un 15
$20-$EF
.ix User Program Page Zero
.ix I/O Package
.br
User program page zero.  Not used by SDOS or the I/O package.
.sp
.un 15
$FO-$FA        
.ix ROM
.ix Hardware Dependent
.ix Configuration Dependent
.br
System dependent data used by system hardware (ROM), I/O package or
interrupt routines for any purpose; see specific I/O packages.  User
programs must not disturb this data; references to this data will make the
program hardware or configuration dependent.
.sp
.un 15
$FB,$FC,$FD    
.ix SYSCALL Entry Point
.ix SDOS Location
.ix CHAIN
.IX LOAD
.ix Memory Space, User Program
.br
SYSCALL entry point.  These three bytes contain a JMP to the SYSCALL entry
point in SDOS.  All user programs should define SYSCALL$ as $FB; this will
make them independent of the actual location of SDOS. These bytes are
initialized by SDOS whenever a CHAIN or LOAD SYSCALL is executed.  Bytes
$FC,$FD form a 16 bit pointer to the first byte of SDOS (to the first byte
above the memory space available to the user program).
.sp
.un 15
$FE,$FF        
.ix System Dependent Data
.ix RAM
.ix User Program
.br
Reserved for system dependent data (typically a pointer to last byte or page
of RAM).  User program must not disturb or use.
.sp
.un 15
$100-(SDOS-1)  
.ix User Program Area
.ix CHAIN
.ix Stack Register
.br
User program area.  Used in any way desired by user programs.  Last byte of
this area has an address equal to contents of ($FC,$FD) minus 1.  On entry
(CHAIN) to a user program, the stack register is set to this value (SDOS-1).
Generally, user programs have a start address of $100.
.sp
.ix SDOS, Beginning
.ix User Program Boundary
.un 15
SDOS --        
.br
Beginning of SDOS (and/or I/O package).  User program may not overlay or
store any byte on or above this boundary.
.in 0
.pa
.ix SDOS Address Space
Typical SDOS Address Space
.ix Software, SD
.ix Software, Customer
.ix I/O Package
.ix Disk Read
.ix Disk Write
.ix Disk Waitdone
.ix Disk Sector Buffer
.ix Disk File Management
.ix Memory, Non-Existent
.ix IDB
.ix SDOS Boot
.ix I/O Space
.ix ROM Vector
.sp 2
.cp 47
.im 47
                --------------------
        LOW     !                  !
                !    PAGE ZERO     !
                !__________________!
     $:0100     !                  !
                !                  !
                ! SD SOFTWARE or   !
                ! CUSTOMER SOFTWARE!
                !                  !
                !__________________!
                !        .         !
                !        .         !
                !        .         !
                !
                !                  !
                !                  !
       :7800    !__________________!
 TTY,           !                  !\
 LINEPRINTER,   !   MISCELLANEOUS  ! \
 DRIVERS,       !__________________!  \
 (ETC.)         !     DISK READ    !   |
                !    DISK WRITE    !   |
                !  DISK WAITDONE   !   |  I/O Package
                !__________________!   |
                !      DISK        !   |
                !      SECTOR      !   |
                !      BUFFERS     !  /
                !                  ! /
                !------------------!
                !     VT DRIVER    !
                !__________________!
                !      SDOS        ! 48K
                !   (DISK FILE     !
                !    MANAGEMENT)   ! 63K DEPENDING ON
                !__________________! CONFIGURATION
                !//////////////////!
                !//////////////////! NON-EXISTENT MEMORY
                !//////////////////!
                !------------------!
        :F000   !        IDB       !
                !__________________!
        :FC00   !    SDOS BOOT     !
                !__________________!
        :FF00   !                  !
                !    I/O SPACE     ! ROM VECTORS TO OTHER ROM
        HIGH    !__________________!

.in
.pa
.tc
SDOS LOADER FORMATS
.ix Loader Format, SDOS
.sp
.ix File
SDOS will load files containing one of two types of records:
.ix Load Record, SDOS
.ix Encrypted Load Record
.in 3
.sp
.un 3
1)~SDOS Load Records
.br
.un 3
2)~Encrypted Load Records
.in 0
.sp
.ix File
A file to be loaded must contain only SDOS load records, or encrypted load
records.
.sp 2
.tc
SDOS LOAD RECORD FORMATS
.ix Load Record Format
.ix Scatter Load Capability
.ix Contiguous Memory
.sp
SDOS Load Records are designed to let SDOS load large blocks of contiguous
memory efficiently, and still retain scatter-load capability.  A file
containing SDOS Load Records appears as a stream of load records.  Each load
record has a type and a format.  There are four SDOS load record types; all
four contain binary information for ease of processing by the loader and to
minimize file space occupied.  Each load record type is identified by its
first byte.  One record immediately follows another.
.ix Load Record Type 1
.ix Start Address
.ix MSB
.sp
SDOS load record type 1 must be the first record (i.e., start on byte 0) of
the file.  It is followed by 2 bytes forming a 16 bit start address, MSB
first.  The next two bytes are the 16 bit one's complement of the start
address, MSB first (this record format makes it extremely improbable that a
non-load format file is actually loaded by accident). The first byte of a A
Type 1 load record specifies the CPU type:
.sp
.im 5
        $01     6800
        $03     6801/6803
        $02     6809
        $07     6303
        $11     6811
.sp
.ix Load Record Type 0
.ix Skip Record
.ix File Position
SDOS load record type 0 is a skip record.  The two bytes following the
record type byte form a 16 bit count (MSB first) of the number of bytes
following the skip record to ignore.  The loader processes this record by
positioning the file to the file position after the skip record, plus count
bytes.  This record format is used to align following load records on power
of two boundaries which can speed up loading of larger data records.
.ix Load Record Type 2
.ix Load Record Type 3
.ix Load Data Block
.ix Memory Address
.sp
SDOS load record types 2 and 3 are identical in format.  Both record types
are used to load blocks of data into the memory address specified by the two
bytes following the record type byte (MSB first).  The number of bytes to be
loaded is given by the 16 bit count specified by the next two bytes (MSB
first).  The data bytes to be loaded immediately follow the count bytes.
.pa
.ix Load Record Type 2
.ix EOF
.ix Load Record Type 3
.ix SYSCALL:CHAIN
.ix Control Transfer
.ix Start Address
A type 2 record specifies that another load record follows (i.e., that EOF
does not immediately follow the records) and that further load record
processing is needed.  A type 3 record indicates that the load process is
complete once the data bytes in the type 3 record are loaded (i.e., there
are no more load records in the file).  After processing a type 3 record, a
SYSCALL:CHAIN will transfer control to the start address specified by the
type 1 record.
.pa
SDOS LOAD RECORD FORMATS

.ix Load Record Format
.sp
Command
.sp
.im 11
_____________________________     ____________
!     0 !   COUNT   !       !.....!          !
!_______!_____!_____!_______!     !__________!
        2 BYTES     !________________!
                               !
                               !
                          COUNT BYTES
                       Meaning: Skip  COUNT  bytes  to  find
                                next  command.   Used  as  a
                                space  filler to  pad  to the
                                next physical sector boundary.
.sp
.im 5
_________________________________________
!CPU Type !  ADDRESS  ! 16 BIT CHECKSUM !    Set   start  address.
!_________!_____!_____!________!________!    Must be first command
             2 BYTES        2 BYTES          in file.  CHECKSUM is
                                             :FFFF - address.

.sp
.im 12
__________________________________________________
!     2 !  ADDRESS  !   COUNT   !   DATA BYTES   !
!_______!_____!_____!_____!_____!________________!
           2 BYTES     2 BYTES     !__________!
                                        !
                                        !
                                   COUNT BYTES

                                  Causes data bytes to be loaded
                                  sequentially   into   memory
                                  starting  with  the  specified
                                  address.
.sp
.im 7
_________________________________________________
!     3 !  ADDRESS  !   COUNT   !   DATA BYTES  !
!_______!_____!_____!_____!_____!_______________!
             2 BYTES     2 BYTES

                                    Just  like  2,  but also causes
                                    JUMP to start address specified.
.sp
.pa
.ix Load Record
.ix Disk Read
The load records are used in the following way to optimize the disk reads
(example):
.sp
.im 25
                   ===================
Logical byte #'s   !  Type 1 record  !  Must be first in file
        !          !_________________!
        !          !                 !
        !          !                 !
        !          !  Type 0 record  !  Filler record
        !          !                 !
        !          !_________________!
        !          !  Type 2 record  !  Indicates "Load next
        !          !=================!  two sectors".
       NBPS        !  1ST Data Byte  !
                   !                 !
                   !=================!
      2*NBPS       !                 !
                   !                 !
                   !=================!
      3*NBPS       !  Type 3 record  !  Indicates "Load next
                   !_________________!  two sectors" and
                   !                 !  transfer control to
                   !                 !  start address when
                   !                 !  done.
                   !=================!
      4*NBPS       !                 !
                   !                 !
                   !=================!

.sp 2
.ix Encrypted File
Encrypted Files
.sp
.im 11
     ______________________________________________
     |  05  |S# COUNT |     48 Random Bits        |
     |______|_________|___________________________|
     |           1st Serial Number                |
     |____________________________________________|
     |           2nd Serial Number                |
     |____________________________________________|
     |           S#  Serial Number                |
     |____________________________________________|






.pa
.tc
ENCRYPTED OBJECT FILES
.ix Encrypted Object File
.ix Proprietary Program
.sp
An encrypted file is one whose content is not in a directly usable form.
Under SDOS, encrypted object files contain proprietary programs which are
designed to run on only a limited number of CPUs. Some programs are
proprietary to Software Dynamics; other programs are proprietary to other
vendors. Software Dynamics provides a tool to allow vendors to encrypt their
own object programs or suite of programs.
.sp
.ix Encryption Key
.ix Serial Number
An encrypted program is decrypted by SDOS while loading into memory by use
of an Encryption Key. The Encryption Key is a function of the serial
numbers of the CPUs on which the program is authorized run, and a 48 bit
"application suite" number embedded in the object file.
.sp
.ix Address Space
.ix Non-Zero Data
SDOS zeros the address space when loading an encrypted file whose Encryption
Key is different than the Encryption Key of the last file loaded.  This
prevents "Trojan Horse" software from obtaining a snapshot of a
previously-executed program.  Only programs with the same encryption key
may pass control (and non-zero data) to one another.  This is a common
requirement of an "application suite".
.sp
.ix Load Record Format
.ix Skip Record
Encrypted object files have an un-encrypted 1st object record, followed by
the rest of the file in an encrypted format. The encrypted portion of the
file, once un-encrypted, is in standard SDOS load record format, with the
exception that no skip records are allowed (decrypting skip records is
simply a waste of time).
.sp
.ix Application Suite
.ix Utility Program
The first object record starts with a byte containing :05, signifying this
file is an encrypted object file. The SerialNumberCount (S#) specifies how
many serial numbers for which this object file was encrypted.
Following the SerialNumberCount are 6 bytes of Application Suite number
(typically a random number chosen at time of encryption).  Last are a
series of 8 byte Serial Numbers on which this object file is authorized to
run. These serial numbers are in a clear text form so they can be easily
inspected by a utility program.
.pa
.tc
SDOS DISK FILE STRUCTURE
.IX Disk File Structure, SDOS
.ix Logical Sector Number
.ix Logical Cluster Number
.sp
This section gives detailed information on the structure of the SDOS disk
file system.  Two concepts are critical to the understanding of the file
system: Logical Sector Numbers and Logical Cluster Numbers.  These concepts
are detailed xbelow.
.sp
Definitions:
.sp
.in 8
.ix NBPS
.ix BOOT Sector
.un 8
NBPS~~~~Number of bytes/sector (2^n,n=1..15). Must be power of 2!!  NBPS is
limited to 128*32=4096 by directory search routine. Minimum size is 128
bytes (see BOOT sector).
.br
.ix NSPT
.un 8
NSPT~~~~Number of sectors/track
.br
.ix NTPC
.un 8
NTPC~~~~Number of tracks/cylinder
.br
.ix NCYL
.un 8
NCYL~~~~Number of cylinders/drive
.br
.ix NLSN
.un 8
NLSN~~~~Number of (logical) sectors on a disk (= NSPT*NTPC*NCYL)
.sp
.in 8
.un 8
Note:~~~Number of bytes/cluster < 2^16 for 6800/6809 implementation.
.in 0
.pa
.tc
LOGICAL SECTOR NUMBERS (LSNs)
.ix Logical Sector Number
.ix LSN
.ix Track
.ix Cylinder
.ix Sector
.ix File System
.sp
LSN's are imaginary sequence numbering applied to physical disk sectors on a
disk cartridge or floppy diskette.  The reason for using them is that
Logical Sector Numbers can be mapped onto any disk removing any structure
that the disk drive might arbitrarily impose from the knowledge and concern
of SDOS; i.e., the distinction between tracks, cylinders, and sectors ceases
to be of concern to the SDOS file system.
.ix Booting the System
.ix Track 0
.ix Sector 0
.ix Cylinder 0
.ix LSN 0
.sp
The only requirements placed by SDOS on LSN's is that they begin with 0 and
increase sequentially; further, track 0, sector 0, cylinder 0 (usually) maps
into LSN 0.  This is because most hardware interfaces can read in this
physical disk block as a means for booting the system, so SDOS reserves LSN
0 for this block.
.sp
A useful method for choosing the LSN number for a disk block on
physical cylinder C, track T, and sector S is:
.ix LSN
.sp
.in 10
LSN(C,T,S)=S+NSPT*(T+NTPC*C)
.in 0
.ix NSPT
.IX NTPC
.ix Sectors Per Track
.ix Tracks Per Cylinder
.ix NSPT
.IX NTPC
.IX NCYL
.ix Disk Read
.ix Disk Write
.ix I/O Package
.sp
where NSPT and NTPC are the number of Sectors per Track and the number of
Tracks per Cylinder, respectively; where 0<=S<NSPT, 0=<T<NTPC, and 0<=C<NCYL
(NCYL= number of cylinders).  This has the advantage of allowing SDOS to
allocate new blocks to a file by use of their LSN's, attempting to minimize
LSN distance (which minimizes Cylinder, Track, and Sector distance, in that
order.  The name NLSN refers to the number of logical sector numbers for a
disk and is equal to NSPT*NTPC*NCYL.  There are physical disk read and write
routines in the I/O package which are required to convert LSN's into the
corresponding values of S, T and C.  Each LSN occupies 3 bytes (maximum of
(2^24)-1 LSN's).
.pa
.tc
CLUSTERS (LCNs)
.ix Cluster (LCN)
.ix Disk Space
.ix Sector, Contiguous
.sp
SDOS allocates disk space in units of "clusters" (not sectors!).  A cluster
is simply a set of sectors whose LSN's are contiguous, and whose lowest LSN
is a multiple of the cluster size (an arbitrary constant for a particular
diskette or disk pack).  Data placed in a cluster is generally related in
some fashion.
.ix LCN
.sp
Each cluster is assigned a logical cluster number (LCN).  An (LCN) is the
number given to a cluster of sectors.  Every LSN is in a cluster whose LCN
is given by:
.sp
.im 1
        LCN(LSN)=INT(LSN/NSPC)
.ix NSPC
.ix Number of Sectors Per Cluster
.sp
where NSPC is the number of disk sectors per cluster (defined for the disk).
.sp
The total number of clusters on a disk is given by:
.sp
.im 1
        NSPC=INT(NLSN/NSPC)
.ix Cluster Number
.ix :FFFF
.ix No Such Cluster
.ix Cluster, Unallocated
.sp
The special cluster number :FFFF is reserved, and means "no cluster
allocated" or "no such cluster".  This is the value to which unallocated
clusters specified in cluster headers are set.
.sp
.ix Disk Space
The advantage of this clustering technique is that it saves space and time. 
Space savings are effected on the disk because each file does not need to
explicitly record all the sectors it contains.  This means less disk space
used keeping track of disk space.
.sp
.ix Time Saving
.ix File
.ix Disk Storage
Time savings are effected when SDOS is reading sequentially through a file,
because (NSPC-1)/NSPC*100% (for NSPC=4, 75%) of the time, SDOS knows the
next LSN which is required without having to do any disk reads to collect
this information.  The disadvantage is a small loss in efficiency of disk
storage (i.e., each file wastes NSPC/2 disk sectors on the average, instead
of 1/2 disk sector average).
.sp
.ix Cluster Size
.ix Seek Time
The cluster size is chosen to either minimize average waste of disk sectors
in files, or to minimize the seek time between disk sectors in a cluster,
subject to several constraints.
.sp
.ix LCN, Legal
The first constraint is that all legal LCN's are limited to the range
0-65534 decimal (65535 is reserved; 2 bytes inside SDOS), i.e.,
INT((NLSN-1)/NSPC)<65535.
.sp
.ix Cluster
.ix Header Cluster
.ix NBPS
The second constraint is that one cluster should have enough space to
contain all the LCN's defined for a disk, i.e., NSPC*NBPS/2 >=
INT(NLSN/NSPC) where NBPS is the number of bytes per sector.  This
constraint allows SDOS to use a single cluster to record all the clusters of
a file.  This constraint can be violated, but the result is that a single
file might not be able to use the entire disk.  SDOS will complain if the
Header Cluster of a file overflows when allocating space to a file.
.sp
.ix NSPC
The third constraint is that 1<=NSPC<=255.  This is purely an implementation
restriction and must be followed.
.sp
Assuming a file with 2^31=2.1x10^9 bytes, NBPS=512, NSPC=255, we have
2.1x10^9/512=4.2x10^6 sectors in file; 4.2x10^6/255=16449 clusters in file. 
The header cluster has room for 255*512/2=65280 clusters, which covers such
a file easily.
.sp
.ix Waster Space
.ix Disk File
.ix NSPC
.ix Sectors Per Cylinder
.ix NLSN
.ix Cluster
.ix Track Boundary
.ix Cylinder Boundary
To minimize average wasted space in disk files, NSPC should be chosen to be
as small as possible within the constraints specified.  This may leave some
disk sectors (with high LSNs) unused by SDOS if NLSN is not a multiple of
NSPC, but the total wastage here is again only 1/2*NSPC sectors average, and
if one has 100 files on a disk, this is insignificant in comparison with the
total savings.  A final note: if the number of sectors per cylinder is not a
multiple of NSPC, some time inefficiency will occur when reading
sequentially through a cluster because some clusters will cross track or
cylinder boundaries.  This inefficiency will be small if the average file
size is much greater than NSPT*NSPC.
.sp
.ix File Size
.ix Time Saving
.ix Seek Time
If the average file size is smaller than NSPT*NTPC, some time savings can be
gained by making NSPC a divisor of NTPC - this will generally prevent part
of file (cluster) from overlapping cylinder boundaries, and will therefore
save seek time.
.sp
.ix NSPC Sample Calculation
A sample calculation of NSPC:
.sp
.in 5
Assume we have 77 cylinders (NCYL=77), 1 track/cylinder (NTPC=1), 16
sectors/track (NSPT=16), 256 bytes/sector (NBPS=256) (so
NLSN=NSPT*NTPC*NCYL=16*1*76=1232).  Let LSN(C,T,S)=S+16*(T+1*C).  Since we
have only one track (track #0), the formula simplifies:
.sp
LSN(C,S)=S+16C
.sp
For any NSPC>=1 then NLSN/NSPC < 65536, satisfying constraint 1.
.br
Constraint 2 implies:
.br
NSPC*256/2>=INT(1232/NSPC)
.br
NSPC*128>=INT(1232/NSPC)
.br
which is true for any NSPC>=4
.br
If we choose NSPC=4, constraint 3 is also satisfied.
.in 0
.sp
To minimize average wasted space, we choose NSPC=4.  On a disk with 100
files, an average of 100*4/2=200 disk sectors are wasted.  With NSPC=3, with
100 files wastes an average of 100*3/2=150 sectors, and prevents files from
containing more than 1152 sectors (i.e., a particular file can only cover
93% of the disk).
.pa
.tc
DISK FILE STRUCTURE
.ix Disk File Structure
.sp
.ix File
.ix Application Program
.ix Disk Size, Physical
A File under SDOS is a mechanism for storing logically related information. 
From the point of view of an application program, a disk file is a very
large array of 8 bit bytes which can be read/written sequentially, can be
positioned for later read/writes, and can be automatically extended (at the
end) to add more information.  These files can be up to 2^31 bytes (2.1
billion bytes) in size, physical disk size being the real limitation.
.sp
.ix Device Driver
This view of files is implemented by device drivers.  The operations that a
device driver considers legal and the actual operation performed are
dependent on each device driver (see Device Drivers).  There are two kinds
of drivers: non-disk file and disk file.
.sp
.ix Disk File Driver
.ix Cluster
.ix Sector
The disk file driver is a component of SDOS proper.  It handles files by
breaking them down into two layers: clusters and sectors.  Sectors are the
physical unit of transfer to/from the disk drive.  Clusters are a logical
grouping of sectors used to minimize the amount of information required to
record where all the sectors of a file are located.
.sp
.ix Header Cluster
.ix Logical Cluster Number
Each file has a special cluster of sectors known as the Header Cluster.  The
Header Cluster contains the logical cluster numbers of all (data) clusters
contained in the file. These numbers are placed in the Header Cluster in
such a way as to indicate the relative (byte) position of the target cluster
in the file.
.sp
.ix Sparse File
.ix :FFFF
.ix No Data Cluster Allocated
A special cluster number of hex :FFFF means "no data cluster allocated" to
this place in the file.  This allows sparse files to be built with very
little wasted space.
.sp
.cp 40
.ix File, Cluster Structure
.im 39
                           __________
                           !        !  First Cluster Pointer
                           !        !  Points to Headercluster
                           !        !
                           V        !
Header      -       ______________  !
Cluster     !   2B  !     ----------!
            !   2B  !     ------------------
            !   2B  !     ---------------  !  Remaining Cluster Pointers
            !       !     .      !      !  !  Point to Data Clusters
            !       !     .      !      !  !
            !       !____________!      !  !
            !       !      ----------   !  !
            !       !            !  !   !  !   Data Cluster #0
        NSPC*NBPS   !            !  !   !  !   ____________
            !       !____________!  !   !  !-->!          !
            !       !            !  !   !      !          !
            !       !            !  !   !      !__________!
            !       !            !  !   !
            !       !            !  !   !
            -       !____________!  !   !      Data Cluster #1
                                    !   !      ____________
                                    !   !----->!     0    !
                                    !          !__________!
                                    !          !     1    !
                                    !          !__________!
                                    !          !     .    !
                                    !          !     .    !
                                    !          !     .    !
                                    !          !__________!
                                    !          !  NSPC-1  !
                                    !          !__________!
                                    !
                                    !
                                    !          Data Cluster #N
                                    !          ____________
                                    !--------->!          !
                                               !          !
                                               !__________!
.sp
.ix Header Cluster
.ix Cluster Number
.ix Logical Cluster Number
The first two bytes in the header cluster are reserved to contain the
cluster number of the header cluster itself (this simplifies the space
allocation routines).  Succeeding pairs of bytes contain the logical cluster
numbers of the 0th data clusters, 1st data cluster, etc.
.sp
.ix File
.ix :FFFF
.ix Header Cluster, Garbage
When a file is first allocated, all the pointers (except the first) in the
first sector of the header cluster are initialized as :FFFF (no data cluster
allocated).  The other sectors in the header cluster are left as garbage.
.sp
.ix DIR:HCSIC
.ix Header Cluster Initialized Count
A special 1 byte counter (stored in the directory), DIR:HCSIC (header
cluster initialized count) tells SDOS how many of the sectors in the header
cluster are initialized.
.sp
.ix LBN
.ix Logical Byte Number
If a data byte is in logical byte number "LBN" in a file, then SDOS can
access that byte (in at most two disk reads) by the following process
(definition):
.sp
First, compute:
.ix NBPC
.ix RDCN
.ix HSLSN
.im 4
        NBPC := NSPC*NBPS       (COMPUTE # BYTES/CLUSTER)
        RDCN := INT(LBN/NBPC)   (COMPUTE THE RELATIVE DATA
                                CLUSTER NUMBER)
        HSLSN := INT[(RDCN+1)*2]/NBPS + HCLCN*NSPC
.sp
.in 8
where HSLSN = header sector logical sector number
.br
and HCLCN = header cluster logical cluster number.
.sp
.ix LSN
.ix Header Cluster
This computes the LSN of desired sector in the Header Cluster.  The "+1" is
because the first cluster pointer is the pointer to the header cluster.  The
"*2" is because each cluster number occupies two bytes.
.sp
.ix HCSIC
.ix HSLSN
Note: HCSIC may indicate that this sector (HSLSN) has not been initialized!!
.sp
.un 8
Next:
.br
.ix HSLSN
.ix HBBUF
.ix Header Buffer
read HSLSN into memory in HBBUF (header buffer)
.br
DBLCN := @((((RDCN+1)*2)MOD NBPS)+.HBBUF)
.br
this computes the LCN of the data cluster containing the byte.
.sp
.ix @
.ix DBLCN
.ix :FFFF
.ix Memory Address
"@" means use the value to the right as a memory address and fetch 16 bits. 
".HBBUF" means the address of the header buffer. Note: DBLCN may be :FFFF
(undefined)!!
.sp
.un 8
Finally:
.ix DBLSN
.br
DBLSN := DBLCN*NSPC+INT((LBN MOD NSPC*NBPS)/NBPS)
.br
Read DBLSN into memory; desired byte is found at displacement RBN := LBN MOD
NBPS
.in 0
.pa
SDOS FILE STRUCTURE
.tc
.ix File Structure, SDOS
.ix Directory Entry
.ix LCN
.ix Header Cluster
.sp
.cp 41
.im 40
        !       .      !
        !       .      !
        !       .      !
        !______________!
        !  DIRECTORY   !
        !    ENTRY     !
        !              !
        !     LCN -----------
        !______________!    !
        !      .       !    !
        !      .       !    !
        !      .       !    !
                            /
                           /
                          /
                         /
          --------------/
          !
          !
  ____    !
  !  !    !  Header Cluster - First Cluster of File
  ! _V____V_  ________  ________      ________
  !-----   !  !      !  !      !      !      ! )(Some)
    !______!  !      !  !      !      !      ! )Sections
!-------   !  !      !  !      !      !      ! )Initialized
!   !______!  !      !  !      !      !      ! )To "No
! !-----   !  !      !  !      !......!      ! )Cluster
! ! !______!  !      !  !      !      !      ! )Allocated"
! ! ! 3RD  !  !      !  !      !      !      ! )At File
! ! !______!  !      !  !      !      !      ! )Creation
! ! !  .   !  !      !  !      !      !      ! )Time
! ! !  .   !  !      !  !      !      !      !
! ! !______!  !______!  !______!      !______!
! ! 
! !-------> 2nd Data Cluster    _______________________
!                               ! A Cluster Number Of !
!---------> 1st Data Cluster    !       :FFFF         !
                                !  Means "No Cluster  !
                                !     Allocated"      !
                                !_____________________!

.cp 25
.ix Header Cluster Structure
.im 24
     __________
     !        !
     !        V   Header Cluster
     !    __________
     !--------     !
     ---------     !
     !    !        !
     !    !    ------------> 2nd Data Cluster
     !    !    ------------> Etc.
     !    !________!
     !
     !
     !   1st Data Cluster
     !
     !    -------  -------  -------     -------
     !    !     !  !     !  !     !     !     !
     !----->    !  !     !  !     !     !     !
          !     !  !     !  !     !     !     !
          !     !  !     !  !     !.....!     !
          !     !  !     !  !     !     !     !
          !     !  !     !  !     !     !     !
          !     !  !     !  !     !     !     !
          !     !  !     !  !     !     !     !
          -------  -------  -------     -------
.ix Logical Sector Number
.sp
Logical sector number of 1st sector in cluster =
.br
cluster number * cluster size in sectors.
.br
Succeeding sector numbers are base sector number + index into cluster.
.pa
.tc
DIRECTORY.SYS STRUCTURE
.ix DIRECTORY.SYS Structure
.ix Header Cluster
.ix Directory
.sp
The directory stores the name and location of the header cluster for all
files on the disk (SDOS allows no magic disk files which are not in the
directory; even system files are mentioned in the directory).
.sp
Each Directory entry is 32 bytes and contains the following
information:
.sp
.in 5
.ix DIR:FILENAME
.ix File Name
.ix Lowercase Character
.ix Uppercase Character
.un 5
DIR:FILENAME
.br
The file name can be any left-justified sequence of letters (uppercase
only), digits 0 through 9, $ or ".".  It may not begin with a "." or a
digit.  The name is blank filled to 16 bytes.  Two file names are considered
equivalent if they match byte for byte.  SDOS automatically folds lowercase
characters in disk file names into uppercase. Bit 7 of all bytes must be
zero.
.sp
.ix DIR:HLCN
.ix Header Logical Cluster
.un 5
DIR:HLCN
.br
The Header Logical Cluster Number specifies the location of the Header
Cluster for the file if DIR:HCSIC > 0.  If DIR:HCSIC = 0, then DIR:HLCN is
actually the cluster number of the 1st data cluster.
.sp
.ix DIR:HCSIC
.ix Header Clustor Sector Initialized Count
.ix System Programmer
.un 5
DIR:HCSIC
.br
The Header Cluster Sector Initialized Count tells SDOS how many sectors of
the header cluster have been initialized properly (see File Structure) and
need not concern any but the systems programmer. DIR:HCSIC is updated
whenever a new header cluster sector is initialized.  If DIR:HCSIC is zero,
and DIR:NCLUSTERS > 0, then the file is contiguously allocated on the disk,
with the first data cluster being in DIR:HLCN, contiguous for DIR:NCLUSTERS.
.sp
.ix DIR:NCLUSTERS
.ix Cluster Number Allocated
.un 5
DIR:NCLUSTERS
.ix Sparse File
.ix Logical File Size
.br
DIR:NCLUSTERS is the number of clusters allocated. This count is needed as a
very sparse file may have an enormous logical file size, and yet have a very
small actual disk allocation.  SDOS updates DIR:NCLUSTERS only when a file
is closed.  If DIR:NCLUSTERS is zero, this directory entry is not valid and
is available for use by a new file (name).
.sp
.un 5
DIR:FILESIZE
.ix DIR:FILESIZE
.ix File Size, Apparent
.ix Sector Size
.ix Cluster Size
.br
DIR:FILESIZE is the apparent size of the file in bytes, and is equal to the
position of the last data byte written in the file, +1.  The filesize is
completely independent of sector or cluster size.
.pa
.un 5
DIR:PROTECTION
.ix DIR:PROTECTION
.ix File Protection Bit
.ix Protection Bit Table
.br
DIR:PROTECTION contains file protection bits.  The protection bits prevent
inadvertant or undesired references to file.  The currently defined bits
are:
.sp
.im 8
               7       <NOT DEFINED>
               6       PROTECT:WRITE
               5       <NOT DEFINED>
               4       <NOT DEFINED>
               3       <NOT DEFINED>
               2       <NOT DEFINED>
               1       <NOT DEFINED>
               0       PROTECT:BACKUP
.sp
.in 10
.un 5
PROTECT:WRITE
.ix PROTECT:WRITE
.ix DELETE
.IX RENAME
.IX CREATE
.ix Accidental Eraser
.ix System File, Critical
.ix PROTECT:WRITE
.ix Writing Data
.br
The PROTECT:WRITE bit prevents DELETE, RENAME, and CREATE commands on a
file with the corresponding name.  This is used by SDOS to prevent
accidental erasures of critical system files, and may be used by the user to
protect his critical files.
.sp
.un 5
PROTECT:BACKUP
.br
.ix PROTECT:BACKUP
.ix SDOSDISKBACKUP
.ix CHANGED Option
.iX SYSCALL:WRITEA
.IX SYSCALL:WRITEB
.IX CC:SETFILESIZE
This bit prevents SDOSDISKBACKUP from backing up a file if the CHANGED
option is specified. It is reset whenever a file is first created, or when a
file is modified in any way (SYSCALL:WRITEA, SYSCALL:WRITEB, CC:SETFILESIZE,
etc.). It is set by SDOSDISKBACKUP whenever a file has been backed up using
the CHANGED option.
.sp
.in 5
.un 5
DIR:CREATIONDATE
.ix DIR:CREATIONDATE
.IX Day
.ix Month
.ix Year
.ix BCD
.br
DIR:CREATIONDATE contains the creation date of the file in the form DDMMYY. 
DD is one byte containing the day number in BCD; MM is one byte of BCD
month; and YY is the year number modulo 100 in one BCD byte.
.sp
.in 0
.ix SDOSDISKINIT
.ix Cluster
.ix Directory
.ix Boot Cluster
SDOSDISKINIT generally places the first data cluster of the directory at
INT(NLCN/2) (the middle of the logical disk) in an attempt to decrease
seek-to-directory time.  This also causes SDOS to extend the directory in
the middle of the disk if need be.  Note: This LCN must be non-zero! 
(Otherwise, the directory and the boot cluster collide.)
.sp
.IX BOOT:DIRLSN
.IX BOOT.SYS
.IX DIRECTORY.SYS
.ix LSN
SDOS locates the directory initially by reading BOOT:DIRLSN from the
BOOT.SYS file.  BOOT:DIRLSN gives the LSN of the directory sector containing
the DIRECTORY.SYS entry.  The directory entry for DIRECTORY.SYS is located
in the first 32 bytes of the sector.  This requirement also forces the
sector size to be at least 32 bytes (the first entry must be contained
entirely in the first directory sector), and to be a multiple of 32!
.pa
.ix File Name
.ix Directory
All other filenames in the directory are added to it according to the
following procedure:
.sp
.ix Directory
.ix Circular Search
.in 5
The directory is searched by initially hashing the desired name to
choose a directory sector, and then searching circularly through the
directory for the desired name.  The hashing scheme tends to make lookups
of existing names very quick, as long as the directory is 80% or less
loaded.  The circular search guarantees that even if the directory size
changes, files
will still be found.
.sp
.ix Directory
.ix Automatic Expansion
The directory is automatically expanded by SDOS if it is full and a new
filename needs to be added.  This automatic expansion invalidates all the
previous hashes, but since new (or renamed) files will get hashed to the
correct place, after the system has been used with the expanded directory
awhile, lookups will speed up again. Renaming a file rehashes it, so
renaming all files will rehash them all.
.sp
.ix Directory Size
.ix DIR:FILESIZE
.IX DIRECTORY.SYS
.IX NBPC
.in 0
The directory size is kept in the DIR:FILESIZE entry of the
DIRECTORY.SYS entry, and is always a multiple of the cluster size (NBPC).
.sp
.ix DIRECTORY.SYS
As a convenience to the hashing algorithm, a limit of 65536 directory
sectors is imposed on the DIRECTORY.SYS file.
.sp
.cp 41
.ix DIR:NAME
.IX Directory Entry
.ix DIR:HCN
.IX DIR:FILESIZE
.IX DIR:PROTECTION
.IX DIR:HCSIC
.IX DIR:NCLUSTERS
.IX DIR:CREATIONDATE
.ix Directory Structure
.im 41
                Directory Entry
                       .
                       .
                       .
               !       .        !
               !       .        !
               !       .        !
               !       .        !
               !       .        !
               !================!
               !                ! 16 Bytes,
               !    DIR:NAME    ! Legal Names Contain
               !                ! A-Z, 0-9, $, "."
               !----------------!
               !    DIR:HLCN    ! 2B, Header Cluster Number
               !                !
               !                !
               !----------------!
               !   DIR:HCSIC    ! 1B Header Cluster Sector
               !                ! Initialized Count
               !----------------!
               !  DIR:NCLUSTERS ! 2B Number of Data
               !                ! Clusters in File
               !----------------!
               !  DIR:FILESIZE  ! 4B, Number of Bytes in
               !                ! The File
               !----------------!
               ! DIR:PROTECTION ! 1B, Protection Bits
               !                !
               !----------------!
               !DIR:CREATIONDATE! 3B
               !----------------!
               !    UNUSED      ! 1B
               !================!
               !       .        !
               !       .        !
               !       .        !
               !                !
               !                !
               !                !
               !                !
.pa
.ix DIRECTORY.SYS
.IX Directory Header Cluster
.ix LCN
.ix SDOS.SYS
.IX DISMAP.SYS
.ix Directory Search Scheme
.ce
File System Sketch
.im 38

                   DIRECTORY.SYS
                     file body
                   _____________
                   !           !<-------|
LCN 0, LSN 0       !    ...    !        |  DIRECTORY.SYS
____________       !___________!        |  Header Cluster
! BOOT:    !       !           !     ___|___________________
! DIRLSN *-------> ! DIRECTORY !     !  |  !    !     !    !
!__________!       ! .SYS  #-------->!  #  !    ! ... !    !
  ^                !___________!     !_____!____!_____!____!
  |                !           !      usually, LCN=@(Directory)-1
  |   BOOT.SYS     !   ...     !
  |   Header       !___________!
__|____________    !           !
! # ! ... !   !<-----# BOOT    !
!___!_____!___!    !   .SYS    !
                   !___________!           DISKMAP.SYS file body
                   !           !           "Busy Cluster Map"
                   !   ...     !             (1 cluster)
SDOS.SYS           !___________!     _______________________
Header Cluster     !           !     !     !    !     !    !
---------------    ! SDOS.SYS  !     !     !    ! ... !    !
! # ! ... !   !<--------#      !     !_____!____!_____!____!
!_|_!_____!___!    !___________!        ^
  |                !           !        |
  | SDOS.SYS       !   ...     !        |  DISKMAP.SYS
  | file body      !___________!        |  Header Cluster
__V________        !           !     ___|___________________
! LCN #1  !        ! DISKMAP   !     !  |  !    !     !    !
! LCN #2  !        ! .SYS #--------->!  #  !    ! ... !    !
! LCN #3  !        !___________!     !_____!____!_____!____!
!   ...   !        !           !
! LCN #n  !        !   ...     !
!_________!        !___________!

Notes: *  represents pointer to (logical) sector
       #  represents pointer to (logical) cluster
.sp
.ix Directory Entry
.ix Circular Search
SDOS hashes to 1st directory entry, and does linear circular search
thereafter.
.pa
.ix Disk Map
.ix Logical Sector
.ix BOOT.SYS
.IX Logical Cluster
.ix LCN
.ix Cluster
.ix NLCN
.ix DIRECTORY.SYS
.ce
Physical Placement of Files on Disk
.sp 2
.im 22
       LCN ~~ NLCN/2
              |     Logical Sector 0
              |            |
       _______|____________V_________
      /       |        !  BOOT.SYS  /\
     /        |        !___________/  \
    /         |                    \ S \ <--- Logical Cluster #1
   /        __V____________         \ D \ <--- LCN 2, 3, etc.
  /         ! DISKMAP.SYS !          \ O \
 /          ---------------           \ S \
!                  ______             ! . !
!                 /      \            ! S !
!                 !      !     _____  ! Y !
!                 !      !     ! S !  ! S !
!                 \______/     ! Y !  !___!
!                              ! S !      !
 \                            / . / <--------- LCN ~~ NLCN/2
  \          _______________ / Y /      /
   \         ! D I R E C T O R  /      /
    \        ------------------/      /
     \                               /
      \_____________________________/



.in 0
.pa
.tc
THE BOOT.SYS FILE
.ix BOOT.Sys
.ix Boot Sector
.ix LSN 0
.sp
BOOT.SYS is a file which owns LSN 0 (the boot sector).
.sp
The BOOT.SYS file contains three things:
.sp
.ix Disk Identification
.in 3
.un 3
1)~a disk identification (32 bytes of text blank
padded).
.br
.ix DISKINFO
.ix Tuning Parameters
.un 3
2)~the appropriate DISKINFO (tuning parameters) for this
disk
.br
.un 3
3)~a "simple" program to read SDOS off the disk and into memory as a means
of booting.
.in 0
.sp
.ix BOOT.SYS
.IX Bootstrap Program
.ix Sector Size, Minimum
Items 1 and 2 are stored in fixed places in LSN 0 and occupy the first 64
bytes.  This sets a minimum sector size requirement of 64 + 1 --> 128
(sector sizes must be a power of two!).  Other LSN's in the BOOT.SYS file
are simply wasted or used to store an extended bootstrap program if needed.
.sp
.ix Boot Sector
The form of the boot sector must be as follows:
.sp
.cp 25
.ix DISKINFO
.IX Boot ROM Routine
.ix DISKINFOCKSUM
.IX Disk ID
.ix Boot Routine
.im 25
              ________________
              !              !
     16 BYTES !     JUMP ----------- These Bytes Are
              !______________!     ! Used For Any
              !              !     ! Purpose By Boot
     15 BYTES !     DISK     !     ! or Boot ROM
              !     INFO     !     ! Routine
              !______________!     !
      1 BYTE  !DISKINFOCKSUM ! <------ = :FF - Sum of
              !______________!     !     Bytes in
              !              !     !     DISKINFO Part
              !              !     !
              !              !     !
     32 BYTES !     DISK     !     !
              !      ID      !     !
              !              !     !
              !              !     !
              !______________!     !
              !              !     !
              !           <---------
              !    BOOT      !
     REST OF  !   ROUTINE    !
     SECTOR   !              !
              !              !
              !______________!

.sp
.ix Boot Routine
This ensures that the disk identification string is easily locatable, and
that it does not prevent the boot routine from executing.
.sp
.ix BOOT.SYS
.ix Control Transfer
Normally, LSN 0 is read into memory at $100 by a ROM boot routine, and
control is passed to location $100.  The boot sector reads in the rest of
BOOT.SYS if necessary.
.pa
.ix Boot Routine
The boot routine then reads the contents of the SDOS file into memory at the
appropriate place, and transfer control to the starting point.
.sp
.in 5
.ix BOOT:FILESYSTEMVERSION
.ix File System Version
.ix Revision Number
.un 5
BOOT:FILESYSTEMVERSION is a single byte containing a file system version and
revision number in the left and right nibbles, respectively.  This document
describes file system version 1.1 (note: SDOS revision numbers do not
necessarily match file system revision numbers!).
.sp
.ix BOOT:NSPC
.ix Cluster Size
.un 5
BOOT:NSPC is a single byte which specifies the cluster size of clusters on
this disk (0<BOOT:NSPC<=255).
.sp
.ix BOOT:MINALLOC
.ix Cluster, Minimum Number
.ix Illegal Operation
.un 5
BOOT:MINALLOC is two bytes which specify the minimum number of data clusters
to allocate to a disk file when it is created on this disk.  0 is not legal.
.sp
.ix BOOT:MIDALLOC
.ix Cluster, Minimum Number
.un 5
BOOT:MIDALLOC is two bytes which specify the minimum number of clusters to
be allocated to a file being extended. BOOT:MIDALLOC must be >= 1.
.sp
.ix BOOT:MAPALGORITHM
.ix Disk Sector Driver
.ix Tune
.ix Latency Times
.un 5
BOOT:MAPALGORITHM is 16 bits which are used in a disk-sector driver
dependent way to tune rotational and seek latency times to a minimum.
.sp
.ix Spiralling
.ix Sector
.ix Cylinder
.ix Logical Sector Number
Commonly, the upper 8 bits are used as "spiralling", or the number of
sectors each cylinder should be offset from the next (cylinder) to tune
seeks for sequential reads; the lower byte tunes the physical spacing
between adjacent logical sector numbers (also measured in units of sector
times). SDOS can usually only read every other sector, best case.
.sp
.ix Map Algorithm
.ix LSN
.ix Cylinder
.ix Track
.ix Sector
When using the "common" mapalgorithm interpretation to map LSNs into
physical CYLINDER, TRACK, and SECTOR (assuming CYLINDERs and TRACKs increase
sequentially from 0, and physical sector 0 on all TRACKs are aligned) the
following formulas apply:
.in 0
.pa
.pw 120
.ll 100
.cp 17
.im 17
        REM PSUEDO-BASIC TO COMPUTE PHYSICAL CYLINDER, TRACK, SECTOR
        CYLINDER= INT(LSN/(NSPT*NTPC))
        TRACK= INT((LSN-CYLINDER*NSPT*NTPC)/NSPT)
        SECTOR= ((CYLINDER*SPIRAL)+MAP[LSN MOD NSPT]) MOD NSPT

where   MAP[i]= (i*SPACING) MOD NSPT if SPACING is relatively
                prime to NSPT, and is generally computed as:

                MAP[0]:= 0 \ !RULE!
                K= SPACING
                FOR i= 1 TO NSPT-1
            100 FOR J= 0 TO i-1
                IF K= MAP[J] THEN K=(K+1) MOD NSPT\ GOTO 100
                NEXT J
                MAP[i]= K
                K= (K+SPACING) MOD NSPT
                NEXT i
.ll 65
.pw 85
.sp
.ix Formatting Disk
.ix Map Algorithm
On hardware systems where formatting a disk is used to effect this tuning,
the Mapalgorithm is by convention always set to "1".
.sp
.in 5
.ix BOOT:CREATIONDATE
.ix SDOSDISKINIT
.ix Date
.ix Day
.ix Month
.ix Year
.un 5
BOOT:CREATIONDATE is the date that this disk was SDOSDISKINITed, and
consists of 3 BCD bytes: day, month, and year MOD 100, respectively.
.sp
.ix BOOT:DIRLSN
.ix Logical Sector Number
.ix DIRECTORY.SYS
.un 5
BOOT:DIRLSN is the Logical Sector Number of the DIRECTORY.SYS sector that
contains the DIRECTORY.SYS directory entry in the first 32 bytes.
.sp
.ix BOOT:CHECKSUM
.IX BOOT:FILESYSTEMVERSION
.ix Disk Validity
.un 5
BOOT:CHECKSUM contains :FF-[sum of the 15 bytes between (and including)
BOOT:FILESYSTEMVERSION] modulo 256, and is used to check the validity of the
disk.
.sp
.ix BOOT:DISKID
.ix Disk Identification
.ix Application Program
.un 5
BOOT:DISKID contains 32 ASCII characters blank filled, used solely as a disk
identification.  This ID is displayed by the FILES command.  It can be used
(read) by an application for the purpose of verifying the disk before the
application uses it.
.sp
.ix Boot Routine
.ix SDOS.SYS
.in 0
.ix BOOT Sector
The boot routine is used to read the contents of SDOS.SYS into memory. 
Ususally, the boot routine does not fit entirely into the remainder of the
BOOT sector; the rest of the boot routine is stored in memory image format
in the remaining sectors of LCN 0.  Listings of sample boot routines can be
obtained from the distributor of SDOS or from Software Dynamics.
.pa
.TC
SERIALNUMBER.SYS
.sp
.ix Encryption
.ix Boot Disk, SDOS
.ix Boot, Successful
.ix SERIALNUMBER.SYS
SERIALNUMBER.SYS is a file required to be on an SDOS boot disk in order that
SDOS may successfully boot.  The file is encrypted, and contains several
things:
.sp
.in 5
A first-time-only conversation with the purchaser of SDOS;
.ix Serial Number
.sp
The serial number of the computer for which the particular version of SDOS
was sold; and
.sp
.ix End-User Name
The name of the end-user, or organization.
.ix Error, No SERIALNUMBER.SYS File
.ix CHAIN
.ix Decryption
.ix ROM Serial Number
.ix SDOS Operation Aborted
.ix Error, Wrong Serial Number
.in 0
.sp
SDOS, after initializing operation of the system, goes and hunts for
SERIALNUMBER.SYS.  If this file does not exist, SDOS displays, and hangs up
with a "No SERIALNUMBER.SYS file" error.  If the file does exist, it is
CHAINed to, causing implicit decryption.  The SDOS decrypting loader will
refuse to load SERIALNUMBER.SYS if the serial number encoded into it does
not match that of the ROM included in the system hardware; this causes a
"Wrong Serial Number" message to be printed, and operation of SDOS is
aborted.  If SERIALNUMBER.SYS is not encrypted, an error message will
likewise be generated and SDOS will not run.  Otherwise, the module is
loaded and executed.  If this is not the first time SERIALNUMBER.SYS has
been loaded, then SERIALNUMBER.SYS first prints the ROM serial number, and
the name of the end-user; further operation of SDOS is normal.
.sp
.ix Computer Serial Number
.ix Invalid Response
.ix Demonstration Copy
.ix Code Number
The name of the end-user is supplied by the end-user when the copy is first
run by him; i.e., if the end-user name is blank.  SERIALNUMBER.SYS asks the
name and then waits for the operator to enter a corresponding code number
that he must obtain from Software Dynamics.  This code number is generated
by Software Dynamics from the serial number of the computer and the string
entered by the user (this may be obtained from Software Dynamics well in
advance of system installation, in order to minimize delays).  An invalid
response is so indicated, and the end-user name is NOT updated.  A correct
response causes SERIALNUMBER.SYS to change the end-user name to the supplied
string.  Once set, the SERIALNUMBER.SYS file can never be changed again.  A
response of <CR> is taken as a signal that the user does not wish to set the
name yet (this may be a demo copy, or the user may not have yet obtained the
corresponding code number from Software Dynamics); in this case, after a 30
minute delay, SDOS will operate normally.
.pa
.tc
SDOS.SYS
.ix SDOS.SYS
.ix Operating System
.ix Load Record Format
.ix BOOT
.sp
SDOS.SYS is an SDOS load record format file containing the memory resident
part of the operating system.  It is used by the boot procedure to load a
copy of the system from the disk into memory.
.sp
.ix SDOS.SYS File Structure Restriction
To simplify the boot process, certain restrictions are made on the file
structure of SDOS.SYS.
.sp
.ix LCN of SDOS
.ix Boot Routine
.ix SDOSDISKINIT
.ix Header Cluster
The data LCNs of SDOS must be numbered 1, 2, 3,...  etc., i.e., a
contiguously allocated file.  This guarantees sequentially increasing LSNs
which makes the boot routine's job (of computing LSNs) extremely simple.
The header LCN of SDOS (if it has one) may be anywhere on the disk; the boot
routine need not look at it (many boot routines never bother reading the
SDOS header clusters).  Normally, the SDOSDISKINIT program assigns a very
high LCN to the header cluster of SDOS.SYS.
.sp
.ix Start Address, SDOS.SYS
.ix SYSCALL$ (:FB)
The start address of SDOS.SYS is defined to be SYSCALL$ (:FB).
.sp
.ix Debugging
.ix SYSGEN
.ix I/O Package
.ix Load Record
.ix Patch
.ix Breakpoint
.ix BMP
.ix Binary Maintenance Program
When debugging a (newly SYSGENed) I/O package, a convenient trick is to
modify (using BMP, the Binary Maintenance Program) the first load record
(actually the start record) in the SDOS.SYS file so the SDOS start address
is the entry point to the ROM debugger instead of :FB.  With this change
made, "booting" will cause SDOS to get loaded, and the debugger will then
gain control.  Patches may be made and breakpoints established, and then
SDOS can be started by causing a jump to
.ix :FB
:FB.  When debugging is completed, the first load record should be restored
to its initial state.
.pa
.tc
DISKMAP.SYS
.ix DISKMAP.SYS
.ix Cluster Allocated
.ix Disk File
.sp
The DISKMAP.SYS file is used to keep track of clusters allocated to disk
files for that disk.  Each disk cartridge or floppy diskette has its own
DISKMAP.SYS.
.sp
.ix Cluster, Free
.ix LCN
.ix Bit, On
.ix Bit, Off
The file has one bit per cluster on the disk on which the file resides.  An
"on" bit indicates the cluster is allocated (or contains a bad sector).  An
"off" bit indicates a free cluster, available for allocation to a file. 
SDOS assumes that the entire disk map can be contained in a single cluster,
so if constraint 2 of LCNs is violated (see section on CLUSTERS), one needs
to make sure that NBPS*8*NSPC>=INT(NLSN/NSPC) (otherwise the diskmap
doesn't fit into a single cluster). If constraint 2 is satisfied, so is this
condition (the 8 is the number of bits per byte).
.sp
.ix DISKMAP.SYS
.ix LCN
.ix Bit Number
.ix Logical Byte Number
.ix Logical Cluster Number
Each byte of DISKMAP.SYS represents 8 clusters, such that bit number n
(starting with 0, counting from the right) represents an LCN such that (LCN
mod 8) = n.  Bytes at logically higher byte addresses within DISKMAP.SYS
represent groups of LCNs with higher values, so that if LBN (logical byte
number), BITN (bit number) represent a particular bit in the DISKMAP.SYS,
then that bit corresponds to LCN=LBN*8+BITN (logical cluster number).
.ix Cluster Space Allocation
.ix Cluster, Free
.ix :FFFF
.sp
Cluster space allocation is done by taking the previously allocated cluster
number (to a file) as the starting point of a search for a free cluster. 
Searches toward logical cluster number 0 and NLCN-1 are both made in an
attempt to minimize the distance between the cluster number (allocated to
the preceding cluster in the file) and the new. Furthermore, an old cluster
number of :FFFF causes allocation starting at a random place within the map.
.sp
.ix Search, Forward
.ix Search, Backwards
The allocator prefers a forward search, and will not bother with a backwards
search if it can get a distance of 1 between the old cluster number and the
new.
.pa
.ix Disk Cluster Allocation Map
DISK CLUSTER ALLOCATION MAP
.ix LSB
.ix Logical Cluster #0
.ix NLCN
.ix Cluster Number, Illegal
.sp
.im 40
    MSB represents Logical Cluster #7
                     |
                     |    LSB corresponds to Logical Cluster #0
                     |                  !
                   __V__________________V__
        BYTE #0    !                      !<--Logical Clusters #0-7
             #1    !                      !<--#8-15
             #2    !                      !<--#16-23
            .      !                      !<--#24-31
            .      !                      !
            .      !                      !
            .      !                      !
                   !                      !
                   !                      !
                   !                      !
                   !                      !
                   !                      !
                   !                      !
                   !                      !
                   !                      !
           ^       !                      !
           |       !                      !
           |       !                      !
     One Cluster   !           /-------------- Bit # (NLCN-1) mod 8
           |       !___________V__        !    (max legal cluster number)
           |       !/////////!   !        !
           v       !/////////!___!________!
                   !//////////////////////!
                   !//////////////////////!
                   !//////////////////////!
  NOTE: Sector     !//////////////////////!
  Containing Bit   !//////////////////////!
  For NLCN-1 is    !///////ILLEGAL////////!
  Null Filled With !///////CLUSTER////////!
  1's to Make it   !///////NUMBERS////////!
  Appear that the  !//////////////////////!
  Illegal LCNs     !//////////////////////!
  are allocated.   !//////////////////////!
                   !//////////////////////!
                   !----------------------!
.sp
A "1" bit --> cluster is busy
.br
A "0" bit --> cluster is free (available).
.sp
.pa
.tc
ERRORMSGS.SYS (ERROR MESSAGE FILE) FORMAT:
.ix ERRORMSGS.SYS
.IX Error Message File
.sp
.ix Error Code
The ERRORMSGS.SYS file is used by SDOS to convert 16 bit error codes into
English text messages for the operator.
.sp
.ix File
The file must exist on the default disk, and the default disk must be
mounted, in order for SDOS to use the file (otherwise SDOS merely prints
"Error nnnnn").
.sp
.ix Sparse File
The file is organized into two parts, and is sparse.
.sp
.ix Error Message, Raw Text
The first part of the file converts 16 bit error codes into string pointers
into the file.  The second part of the file contains the raw error message
text.
.sp
.ix Error Message Routine
.ix SYSCALL:DISPERROR
The 16 bit error code is multiplied by 3, and used as a byte index on the
file to fetch a 3 byte relative index into the file.  The 3 byte index
points to an ASCII error message string, ending with a CR (:0D) character. 
The SDOS error routines do not print the CR explicitly but use it only to
decide where the end of the error message is (see SYSCALL:DISPERROR).  A 3
byte index value of zero means "no message defined".
.sp
The first 65536*3=196608 bytes of the file are reserved for this lookup;
since the number of error messages actually defined out of the 65536
possible is very small, this region of the file is sparsely allocated.  The
first text message starts in byte number 65536*3 of the file.  This section
of the file is dense.
.sp
.ix Error Message, New Addition
New messages are added to the file by merely appending them to the end, and
adjusting the 3 byte pointer corresponding to the error code to point to the
old end of file.
.sp
.ix SDOSERRORMAINT
.ix ERRORMSGBUILD.DO
The program SDOSERRORMAINT is used to maintain the contents of this file.
The file ERRORMSGBUILD.DO is a DO file used to initially construct this
file.
.sp
.ix Error Message Number Assignment
ERROR MESSAGE NUMBER ASSIGNMENTS:
.im 8
0              No Error
1              Operator Requested Attention
2-99           BASIC Compiler Runtime Errors
100-199        Errors Related to System Processors, Etc.
200-299        EDITor Errors
300-999        Application System Dependent Errors
1000-1999      SDOS / I/O Errors
2000-65535     Reserved
.pa
.tc
BUILDING A TURN-KEY APPLICATION SYSTEM
.ix Turn-Key Application, Building
.sp
.ix Personnel Training
In many circumstances, the full generality of an SDOS development system is
not needed; a simple menu-driven application program selector plus the
applications is sufficient.  This is useful in an office environment because
it reduces the training required of the office personnel.
.sp
.ix Turn-Key Application
Only two things need be done to build a turn-key application system:
.sp
.in 3
.ix Boot Process
.ix Hardware Dependent
.un 3
1)~The boot process needs to be made automatic.  This procedure is hardware
dependent and is not described further here.
.sp
.ix DEFAULTPROGRAM
.ix CHAIN
.ix EXIT
.un 3
2)~The DEFAULTPROGRAM on an otherwise bootable SDOS disk needs to be
replaced by the menu-display program.  This program may contain the entire
application, or it may CHAIN to other segments at the appropriate time.  The
other segments, on completion, will EXIT, which causes DEFAULTPROGRAM (the
menu-display program) to be reloaded, and the cycle repeats.
.sp
.in 0
.ix Application Program
.ix Time
.ix Date
.ix WRITEB
.ix CLOCK$
Note that the application program must set the time and date itself by doing
a WRITEB to the CLOCK$ device.
.sp
.ix SDOSCOMMANDS
.ix Turn-Key System
System development can still continue on a turn-key system if the menu
program has a way of chaining to SDOSCOMMANDS, or if a regular development
disk is inserted (just the boot part is automatic).
.sp
.ix DEFAULTPROGRAM
.IX BASIC 1.4
.ix Runtime Package
If DEFAULTPROGRAM is replaced by a compiled BASIC 1.4
program, the 1.4 program must be combined with a runtime package.
.he
.sh
.pa
.np
.pc
.ce
TABLE OF CONTENTS
.sp 3
INTRODUCTION
.sp
SECTION I: DEVICE-DEPENDENT I/O
.BR
~~~DEVICE-INDEPENDENT I/O
.SP
SECTION II: DEVICE DRIVERS
.BR
~~~DEVICE DRIVER CHARACTERISTICS
.BR
~~~DISK FILE DRIVER
.BR
~~~DISK DEVICE DRIVER
.BR
~~~VIRTUAL TERMINAL DRIVER
.BR
~~~~~~OPEN & CREATE
.br
~~~~~~CLOSE
.br
~~~~~~RENAME & DELETE
.br
~~~~~~READA & WRITEA
.br
~~~~~~READB
.br
~~~VTCONTROL
.in 6
CC:POSITION
CC:DUMPBUFFERS
CC:ECHO
CC:NOECHO
CC:WRAP
CC:NOWRAP
CC:IDLES
CC:TABS
CC:SETACTBLOCK
CC:CLRINPUT
CC:CLROUTPUT
CC:SETREADTIMEOUT
CC:SETPROFILE
CC:ALTERPROFILE
CC:WRITEEDITLINE
CC:SETFIELDSIZE
CC:SETPARAMS
CC:ACTIVATIONCK
CC:SETBAUDRATE
CC:COLORING
CC:BACKGROUND
CC:KILLPROOF
CC:KILLENABLE
CC:SETEXCEPTIONS
CC:SETOUTPUTTIMEOUT
.un 3
VTSTATUS
SC:GETPOS
SC:GETCOL
SC:GETEOF
SC:GETTYPE
SC:GETPARAMS
SC:GETPROFILE
SC:GETPROFILENAME
SC:GETPROFILEALTERATION
SC:GETFREECOUNT
SC:GETDATACOUNT
SC:GETOUTPUTTIMEOUT
SC:GETBAUDRATE
SC:GETTABS
SC:GETIDLES
SC:GETWRAP
SC:GETCOLORING
SC:GETBACKGROUND
SC:GETACTCOL
SC:ATTENTIONCK
SC:STATUSCK
.in 3
CONTROL CHARACTERS
SWITCHES
SDOS/MT SUPPORT
~~~MULTI-USER CONTROL FUNCTIONS
~~~MULTI-USER STATUS FUNCTIONS
.BR
THE CLOCK: DEVICE DRIVER
.SP
SECTION III: SYSCALLS
.BR
~~~CONCEPTS
.BR
~~~SYSCALL FORMAT
.SP
SECTION IV: ERROR HANDLING
.SP
SECTION V: SYSCALLS - IMPLEMENTATION
.br
~~~IMPLEMENTATION
.BR
~~~~~~SYSCALL:OPEN
.BR
~~~~~~SYSCALL:CREATE
.BR
~~~~~~SYSCALL:CLOSE
.BR
~~~~~~SYSCALL:RENAME
.BR
~~~~~~SYSCALL:DELETE
.BR
~~~~~~SYSCALL:LOAD
.BR
~~~~~~SYSCALL:CHAIN
.BR
~~~~~~SYSCALL:CREATELOG
.BR
~~~~~~SYSCALL:CLOSELOG
.BR
~~~~~~SYSCALL:DISKDEFAULT
.BR
~~~~~~SYSCALL:READA
.BR
~~~~~~SYSCALL:READB
.BR
~~~~~~SYSCALL:WRITEA
.BR
~~~~~~SYSCALL:WRITEB
.BR
~~~~~~SYSCALL:CONTROL
.BR
~~~~~~~~~CC:POSITION
.BR
~~~~~~~~~CC:DUMPBUFFERS
.BR
~~~~~~SYSCALL:STATUS
.BR
~~~~~~SYSCALL:WAITDONE
.BR
~~~~~~SYSCALL:EXIT
.BR
~~~~~~SYSCALL:ERROREXIT
.BR
~~~~~~SYSCALL:SETERROR
.BR
~~~~~~SYSCALL:GETERROR
.BR
~~~~~~SYSCALL:DISPERROR
.BR
~~~~~~SYSCALL:KILLPROOF
.BR
~~~~~~SYSCALL:KILLENABLE
.BR
~~~~~~SYSCALL:DEBUG
.BR
~~~~~~SYSCALL:ATTNCHECK
.BR
~~~~~~SYSCALL:ISCONSOLE
.BR
~~~~~~SYSCALL:INTERLOCK
.BR
~~~~~~SYSCALL:DELAY
.BR
~~~~~~SYSCALL:GETSERIALNUMBER
.SP
SECTION VI: SDOS CONSTRUCTION/FUNCTIONS
.BR
~~~WRITING AND DEBUGGING USER ASSEMBLY PROGRAMS
.BR
~~~MEMORY MAP
.BR
~~~SDOS LOADER FORMATS
.BR
~~~SDOS LOAD RECORD FORMATS
.BR
~~~ENCRYPTED OBJECT FILES
.BR
~~~SDOS DISK FILE STRUCTURE
.BR
~~~LOGICAL SECTOR NUMBERS (LSN)
.BR
~~~CLUSTERS (LCN)
.BR
~~~DISK FILE STRUCTURE
.BR
~~~SDOS FILE STRUCTURE
.BR
~~~DIRECTORY.SYS STRUCTURE
.BR
~~~THE BOOT.SYS FILE
.BR
~~~SERIALNUMBER.SYS
.BR
~~~SDOS.SYS
.BR
~~~DISKMAP.SYS
.BR
~~~ERRORMSGS.SYS FORMAT
.BR
~~~BUILDING A TURN-KEY APPLICATION SYSTEM
