SAFETRAN Grade Crossing Predictor Runtime Environment Specification

INTRODUCTION

This document specifies the software Run Time Environment (RTE) in which the
SAFETRAN Grade Crossing Predictor (GCP) application program executes. The
document gives some background on the environmental requirements, the
hardware constraints, and then specifies the interface to all routines used
in the runtime environment.  This runtime environment is expected to
be used for work on the GCP after June 1, 1986.  Prior to that time,
the runtime enviroment is undefined.

BACKGROUND

<insert RTP requirements document here>

HARDWARE

The GCP application runs on a 6809 microprocessor with 48Kb of ROM and 16Kb
of RAM, with some small portion of the address space dedicated for I/O. 
Approximately 256(??) bytes of battery-backed RAM (call NOVRAM, or
non-volatile RAM) is used to store long-term application configuration
parameters.

A real-time clock generates an interrupt every 1.9? milliseconds for use by
the GCP application to handle timing needs.

An HP64000 logic analyzer is used in the test environment, and provides not
only conventional logic analyzer facilities such as examine, change, stop,
go, but also provides a Virtual I/O interface used by the GCP runtime
environment for high-level language debugging features.

DEVELOPMENT ENVIRONMENT

The GCP application is written primarily using SDM, a programming language
derived from the Software Development Methodology defined originally by
Westinghouse, Ltd. of England.

SDM defines 3 language dialects: SDM (proper), PDL and PAP.  The three
dialects are required to organize the software into components analyzable by
special fault detection tools.  From the point of view of the runtime
environment, however, all three dialects might as well be one as the runtime
enviroment must provide support for the needs of the union of all three, and
so no further distinction is made in this document, except where dialectic
limitations force specialized support. The application is broken into many
seperately-compiled modules, each of which may be coded in any of the three
dialects.

The SDM dialects are compiled by the SDM compiler into assembly source code.
The compiler is used in two modes: for testing of unreleased software, and
for final production.  In test mode, the compiler generates many validity
checks in the application code to help detect problems quickly, and also
generates information used by the runtime enviroment debugger to inspect
execution state and variables of the various application program modules. In
production mode, the compiler generates smaller and faster code than in test
mode, giving up the test and inspection support. The SDM methodology
requires that production mode output of the compiler be inspected by
Safetran personnel to ensure an accurate implementation of the SDM code has
been effected.  Test mode code is not inspected manually. A compile time
switch selects the style of code production.  Presence of test mode code in
any module is signalled (HOW?? NEED EXPLICIT TEST IN RTE) to the runtime
enviroment, and eventually to the application so that the presence of ANY test
mode code in a "production" release is easily detected.

The compiler output is fed to the 2000 A.D. assembler running on an IBM
PC; thus, the runtime enviroment is indirectly affected by characteristics
of that assembler.  Assembler output in the form of relocatable modules
is linked with other already compiled modules, and a series of modules
which comprise the runtime environment, to produce an executable
program.

The program is typically downloaded into a HP64000 logic analyzer connected
to a test bed containing the execution hardware outlined earlier.
The analyzer is used to:

   inspect or change memory at a machine-language level

   start execution of the application at its normal starting point

   stop the program at specific instructions or on the detection of certain
   data patterns present in the instruction or data stream

   perform diagnostic display as required by the RTE on the detection of a
   fault in the application program

   start the SDM Debug portion of the RTE, and act as keyboard/display
   for the Debug so that an application programmer can interrogate
   the state of variables or the status of the various activities
   in the application.

A production program may also be burned into Read-only memory, installed
in the testbed, and tested by use of the analyzer.  RTE diagnostic
displays and the SDM Debug facility are not available in this test
arrangement.

RUN TIME ENVIRONMENT LOGICAL COMPONENTS

The RTE is composed of several logical components.  Each component plays a
different role in fulfilling the needs of application execution and test.
The components of the RTE are all coded in assembly language, and thus fall
outside the SDM methodology as far as coding is concerned, but within the
methodology via the requirement for each RTE component to be verified by a
structured walk-through and validation. The interfaces to each routine or
data structure defined by the RTE modules are specified in this document.

    SDOSRT   Software Dynamics Operating System for Real Time
             This provides a high-performance, priority-driven, real-time
             task scheduler, task synchronizing routines, interrupt
             architecture and task interface, and sundry support routines.
             SDOSRT is considerably more general purpose than GCP requires.
             The specifications for the interface to SDOS/RT are supplied
             in a seperate document.
>>>> IRA: YOU MUST GENERATE THOSE SPECS!

    SDDBG    Software Dynamics Debugger.  Simple debugger to allow
             memory inspection and modification, register inspection
             and change, and a single breakpoint.  Also provides
             communication facility used by SDMDBG.  SDDBG is provided
             to allow test in an environment where a HP64000 is
             not available.
>>> IRA: YOU MUST GENERATE THOSE SPECS!


    FPPKG    Floating point arithmetic package.  Provides re-entrant
             routines to perform 24 bit floating point operations,
             including (but not limited to) ADD, SUBTRACT, MULTIPLY,
             DIVIDE, COMPARE, FIX (convert float to 16 bit signed integer),
             FLOAT (convert 16 bit signed integer to floating format),
             FCONVI (floating point input conversion) and FCONVO
<DOES COMPILER GENERATE FLOATING COMPARE LIKE IT SHOULD?>
             (floating point output conversion).  While the floating
             point package is not particularly defined for use by
             GCP, its limited precision was determined by the GCP
             application program needs, and is understood by the SDM
             compiler.
??? WHERE ARE SPECS FOR THIS?

    SDMSPT   SDM high-level language support other than floating point.    
             Includes re-entrant routines used to implement compiler
             generated macros, such as 16 bit by 16 bit multiplication
             and division, 16 bit shifting and masking operations,
             array indexing support, interface between SDM channels
             and SDOSRT task synchronizing primitives, and other
             miscellaneous operations.

    SDMDBG   SDM high-level language debugging facility.  Provides
             programmer with facilities to determine state of each
             activity (running, waiting for xxx, register values),
             activation record chain trace, subroutine execution trace,
             (HOW IS SUBR EX TRACE DIFF THAN ACTIVA RECORD TRACE?)
             variable inspection facility, and application fault trap
             and tracking to module and source line number. This code
             is not GCP specific, but is SDM specific.

     INTRPT  Interrupt routines and system Reset code for RTE and
             application program.  Part of this module is custom coded
             specifically for the application.

     APPGLB  Application Program Global data.  Contains Pools,
             Channels, and other data specified as global by the
             various SDM application modules.  Also contains tables
             used by SDMDBG and INTRPT to locate SDM-compiled modules.
             This module is coded specifically for GCP.

RUN TIME ENVIRONMENT PHYSICAL COMPONENTS

The RTE is organized into a set of assembly language modules.
Relocatable object files of these modules are linked with compiler
output to produce executable object programs.  Modules whose
name is marked with an "*" are used only in the test enviroment,
not in the production environment.

------------------------
The following stuff should go after the RTE requirements document.

THE 15 POINTS, INSTANTIATED FOR THE APPLICATION

1) CLASS OF APPLICATIONS TO BE SERVICED BY RUNTIME ENVIRONMENT

The product called Micro Grade Crossing Predictor (MGCP) is the main
application to be serviced by the SDM compiler methodology.  This
application requires the prediction of the time of arrival of passanger or
freight trains at a crossing, so that a warning gate can be lowered. 
Various sensors must be sampled in real time, and computation performed
quickly enough to make such prediction possible.  The prediction causes a
signal to go to a crossing gaurd gate as to whether it should be up or
down. Multiple prediction activities are necessary at the same time due to
multiple possible train approaches (at least tracks).  Information from
nearby MGCPs must be integrated into the predictions.  Programmable
configurability is required to allow customization of MGCP to the local
site and locally changing conditions.

The MGCP performs many actions simultaneously:
   a) it predicts the arrival of trains based upon collected data
   b) collects analog data for task a) from 8 sources
   c) interfaces to local operator via keyboard and display
   d) drives gate crossing guard with unique frequency to hold
      gaurd in "gate up" state
   e) scans inputs
   f) preprocess collected data before predictions
   g) records data

Micro S-Code is a contemplated product that computes boolean outputs
from a variety of real-time analog data inputs with thresholds.
This product too could be potentially implemented using the
SDM methodology.

Solid State Interlock is a third product which will block multiple
trains from occupying the same section of track.  It might also be
built using the SDM methodology.

It is a requirement that the software for the above products be very
reliable, and thus considerable attention is being paid to the construction
and test methodologies in an attempt to minimize design errors being
delivered to the field, as well as minimizing the impact of various
hardware failures.

2) MECHANISMS REQUIRED OF THE RUNTIME ENVIRONMENT

The MGCP application demonstrates need for the following mechanisms:
    a) Datatypes: Booleans, Integers, Reals, Arrays of same, Text strings.
    b) Computational facilities for the above:
          +,-,*,/, shift, and/or, comparison, conversion between types,
          array indexing facilities.
    c) Control flow mechanisms: loops, subroutines, conditionals
    d) Multiple threads of execution (tasks)
    e) Shared data among tasks
    f) Fast interrupt must be serviced reliably to provide signature output.
    g) Data collection via interrupt: 500uS response acceptable.
    h) Some tasks must meet real-time deadlines, while others can be delayed.
    i) Data reporting to display device and logger; low priority.
    j) Error detection for "obvious faults"

Micro S-code and the Solid State Interlock product do not obviously
require reals.

Items a), b) and c) are provided by the SDM compiler (text strings are
treated as arrays of bytes).  Items d) and e) are provided by a combination
of the SDM compiler (which allows the programmer to state his intentions)
and SDOS/RT, which carries out the management of task multiplexing and
synchronization. Items f) and g) are carried out by a specialized piece of
assembly code which handles an approx. 2mS. interrupt and converts it to
task wakeup signals honored by SDOSRT; the application programmer defines a
high-priority task to be woken at an appropriate time to collect whatever
data is needed. Item h), different requirements on tasks priorities are
handled by SDOSRT's task priorities; the application programmer states which
tasks are high priority, and SDOSRT pre-empts lower priority tasks when high
priority tasks become ready, and runs those tasks to completion before
running/continuing tasks of lower priority. Task priorities, coupled with
the assurance that the amount of CPU time required by the tasks that have
hard periodic deadlines is less than the total amount of CPU available
during the most congested period in which a deadine must be met, assures
that deadlines ARE met. Item i) is handled as a low priority application
task.  Item j) is handled by a combination of the compiler and the runtime
support system.

There is no identifiable requirement for any SDM activity to use more
than one task.

There is no identifiable requirement for any SDM activity to respond
to more than one external event at a time.

3 and 4) RESOURCE CONFLICTS AND POLICIES FOR RESOLUTION

   The following kinds of resource conflicts are present:
   a) Competition by multiple activities for CPU.  Some activities
      must be run before others when there is a choice.
      This is handled by SDOS/RT as outlined above.
   b) Interaction over pools of data between activities.
      SDM provides EXCHANGES, a relatively clumsy method.
      SDOS/RT and an extension to SDM provide LOCKs, a
      clean way to resolve this.
      Both of these methods avoiding timing splinters on problems
      storing as simple as storing reals into shared pools.
   c) Interaction over NonVolative RAM between activities (variant of b)
      Solved by same policy as for b).
   d) Competition for use of compiler support routines such as
      floating point, array indexing logic, etc.
      Solved by requiring that all potentially sharable compiler support
      routines either be coded re-entrantly, or that they be serially
      sharable (by use of disable/enable interrupt over PROVABLY short
      periods of time, or SDOS/RT LOCK sequences over longer periods
      of time.)
   e) Total amount of CPU: Is there enough?
      Enumeration of tasks for MGCP and computation of percentage demand
      over deadline windows, given current SDM compiler code quality,
      shows enough CPU is currently available.  When modifying compiler,
      leave compiler code quality alone unless easy opportunity for
      code space or execution cost shrinkage is possible.
   f) Competition for ROM space to hold application procedures (48Kb available)
      Apparantly enough ROM space.  Same policy as e).
   g) Allocation of stack space: how to determine how much?
      This is a very tough problem.  Strategy is to allocate stack
      areas by hand and to install stack overflow/underflow checks.
   h) Competition by application programs for use of shared application
      subroutines. The SDM compiler (specification?) implementation makes
      this impossible due to its method of parameter passing.
EITHER WE LIVE WITH THIS OR WE FIX IT. HAROLD?

5) COMPILER EFFICIENCY. See section 4.

6) RUNTIME DEBUG SUPPORT

Errors made by the application program which are potentially detectable
by run-time checks are:
   a) Division by zero
      Easily accomplished in FPPKG. Accepted.
   b) Unnormalized Real (probably uninitialized variable)
      Easily accomplished in FPPKG. Accepted.
   c) Floating Overflow
      Easily accomplished in FPPKG. Accepted.
   m) Uninitialized variable.
      Not easily accomplished, therefore rejected.
   e) Integer arithmetic overflow
      Detectable only at high code cost (BVS after every computation). Rejected.
   f) Array subscript errors
      Array subscript code bulky anyway; if placed in a subroutine,
      array subscript checking does not add much. Accepted.
   g) Bad value errors on store.
      Requires test on every data store, which is infrequent compared
      to data fetches, and takes medium amount of code.
      Accepted.
   h) Bad value errors on fetch.
      Requires test on every data fetch, which happens frequently and
      and therefore increases demand on CPU, and it takes medium amount
      of extra code to accomplish.
      Does not catch many problems not caught by g), therefore rejected.
   i) Missed task deadlines COMMENT?
   j) Stack overflow. COMMENT?
   k) Stack underflow. COMMENT?
   l) Misused EXCHANGEs. COMMENT?

Facilities that a runtime environment can provide to aid debugging:
   a) Reporting of detected faults by activity name/module name/line number
   b) Stop execution
   c) Report status of all activities
   c) Activation record trace for a particular activity
   d) Inspect local variables of a module
   e) Inspect global variables
   f) Modify variable
   g) Continue execution
   h) Start execution

7) COMPILER SEQUENCES NEEDING PERFORMANCE TAILORING

   <<<SEE SAFETRAN COMPILER MODS DOCUMENT>>>
8) RUNTIME ARCHITECTURAL SUPPORT FOR COMPILER SEQUENCES

   EXCHANGE, LOCK, WAIT, etc.

9) RUNTIME SPECIFICATION FOR COMPILER SUPPORT


TEST ENVIRONMENT

   Serial port to host
   Serial port to talk to programmer
   Debugger to allow low level debugging
   Use NMI for "Stop execution"
   FIRQ for "address out of range"
   IRQ for 2 Ms interrupt
   SWI for debugger

   Memory Organization


   !-----------------------!   (high addresses)
   !    Interrupt Vectors  !
   !-----------------------!
   !      I/O Window       ! -------------> to serial terminal for debugger
   !-----------------------!
   !        SDDBG          !   Standalone debugger
   !-----------------------!
   !                       !
   !  Run Time Environment !
   !                       !
   !-----------------------!
   !                       !
   !         RAM           !
   !       holding         !
   !     Application       !
   !      Software         !
   !                       !
   !-----------------------!  :8000
   !                       !
   !         RAM           !
   !       variable        !
   !       storage         !
   !                       !
   !-----------------------!
   !      NonVolatile      !
   !         RAM           !
   !-----------------------!
   !     Page Zero RAM     !
   !-----------------------!  :0000


10) INTERRUPT SYSTEM IDOSYNCRASIES (CLI, SEI, priorities must be
   addressed)

     /------------\
     !    IRQ     !
     \------------/
           |
           V
   ------------------
   ! Switch Stacks  !
   ------------------
           |
           |
           V
           ^
          / \
         /   \
        /     \
       /       \   YES
      <  EVENT? >---------------------> (as below)
       \       /
        \     /
         \   /
          \ /
           V  NO
           |
           V
           ^
          / \
         /   \
        /     \
       /       \   YES
      <  EVENT? >---------------------> (as below)
       \       /
        \     /
         \   /
          \ /
           V  NO
           |
           V
           ^
          / \
         /   \
        /     \
       /       \   YES
      <  EVENT? >---------------------------\
       \       /                            |
        \     /                             |
         \   /                              |
          \ /                               |
           V  NO                            |
           |                                |
           |                                V
           |                 -----------------------------------
           |                 !  JSR  SDMcodedinterruptroutine  !
           |                 -----------------------------------
           V                                |
    ---------------                         |
    !     RTI     ! <-----------------------/
    ---------------

      WHAT IF SDMcodedinterrupt routine DAMAGES SFP???

Who sets "TEST INT FLAG"? Who clears it? What does trigger event mean?

11) INITIALIZATION
   Need to initialize task list, stacks, locks, local storage required
by variables, etc, RAM data tables that require initz from ROM.

A problem with an application with multiple tasks is ensuring that the tasks
get reset in a controlled order that is application dependent. If no order for
reset is necessary at all, then all tasks may be started at once and simply
compete for the processor immediately.  If a particular order is required, it
can be accomplished in the following way. Without loss of generality, let us
call the first task which we desire to reset TASK1, the second, TASK2, etc.
Then the following structure ensures that the reset code for TASK1 is executed
before the reset code of TASK2, which is executed before the reset code of
TASK3, etc., regardless of the task priorities. We require that each task have
an SDOS/RT lock named TASKx_INITIALIZED. TASK1_INITIALIZED is special because
the reset code for the system starts it out in the locked state.  All other
locks start in an uninitialized state.

               TASK1
                 |
                 V
     ----------------------------
     ! RESET TASK2_INITIALIZED  !
     ! RESET TASK3_INITIALIZED  !
     ! RESET TASK4_INITIALIZED  !
     !           ...            !
     ! RESET TASKN_INITIALIZED  !
     ! UNLOCK TASK1_INITIALIZED !   \
     ! UNLOCK TASK1_INITIALIZED !    \
     !           ...            !     > N times
     ! UNLOCK TASK1_INITIALIZED !    /
     ! UNLOCK TASK1_INITIALIZED !   /
     !   <DO RESET FOR TASK1>   !
     ! UNLOCK TASK2_INITIALIZED !  (tell TASK2 that it can do its reset code)
     ----------------------------
                 |
                 V
          -----------------
          ! BODY OF TASK1 !
          -----------------


               TASK2
                 |
                 V
     ----------------------------
     !  LOCK TASK1_INITIALIZED  !  (ensures that TASK1 gets control first)
     !  LOCK TASK2_INITIALIZED  !  (this makes TASK2 wait for TASK1 reset done)
     !   <DO RESET FOR TASK2>   !
     ! UNLOCK TASK3_INITIALIZED !  (tell TASK3 that it can do its reset code)
     ----------------------------
                 |
                 V
          -----------------
          ! BODY OF TASK3 !
          -----------------


               TASK3
                 |
                 V
     ----------------------------
     !  LOCK TASK1_INITIALIZED  !  (ensures that TASK1 gets control first)
     !  LOCK TASK3_INITIALIZED  !  (this makes TASK3 wait for TASK2 reset done)
     !   <DO RESET FOR TASK3>   !
     ! UNLOCK TASK4_INITIALIZED !  (tell TASK4 that it can do its reset code)
     ----------------------------
                 |
                 V
          -----------------
          ! BODY OF TASK3 !
          -----------------


                 *
                 *                  (same diagram N-4 times)
                 *


               TASKN
                 |
                 V
     --------------------------------
     !  LOCK TASK1_INITIALIZED      !  (ensures that TASK1 gets control first)
     !  LOCK TASK(N-1)_INITIALIZED  !  (this makes TASKN wait for TASK(N-1) reset done)
     !   <DO RESET FOR TASKN>       !  (no need to tell anybody else)
     --------------------------------
                 |
                 V
          -----------------
          ! BODY OF TASK3 !
          -----------------

One could allow some tasks to perform their reset code in paralell, but it
gets complicated to think about, and since the system need not run fast
at reset time, there is no advantage to doing so.


IT WOULD BE REALLY NICE IF COMPILER WOULD COMPILE GLOBAL DATA AS A SEPERATE
MODULE, WOULD MEAN THERE WOULD NOT BE SO MUCH HAND CODING OF THE
APPLICATION DATA MODULE.  I LIKE THE IDEA!
Who owns pool variables? exchanges? locks? etc.? (Harold says, Hardware Module)

12) INTERFACE REQUIREMENTS

Fill up H/W definition module with more stuff...everything that needs
to be defined
What to do if error detected? Three policies: restart system is
one, log error and continue (how?), give control to debug

Reset code must act identically to JMP [$FFFE] so that system restart
is possible by literally doing JMP [$FFFE].  THIS MEANS THAT RESET
CODE CANNOT DEPEND ON RESET PULSE TO PLACE I/O DEVICES IN RESET STATE;
THE RESET CODE MUST EXPLICITLY RESET EACH DEVICE COMPLETELY.



<NEED TO RECORD THE 15 POINTS>
------------------------------------
>>> IMPLEMENT LOCK AND UNLOCK VIA EXCHANGE? NO. PUT IN SPECIAL
EXCHANGE LOGIC, AS WELL AS LOCK/UNLOCK (BECAUSE IT IS MORE NATURAL)
CAN COMPILER INITAILIZE AN ARRAY OF READ-ONLY DATA? IF SO, THEN A
TEXT STRING IS EASILY HANDLED AT COMPILE TIME, ELSE MUST PUT TEXT
STRNG INTO GLOBAL MODULE>

NEED STACK OVER/UNDERFLOW CHECKS.
NEED MISUSED EXCHANGE CHECK (3 tasks using same exchange)
NEED MISSED TASK DEADLINE CHECK ...hmm...


.PA
The 2 Millisecond interrupt routine serves 3 functions for MGCP:
    a) it generates unique signature signal to keep grade crossing
       gate raised, only if it has been told to do so recently.
    b) if not told to raise gate recently, it lowers the gate
       by NOT issuing the unique signature signal (this handles
       the prediction logic computing proper answers, and also
       handles many failures)
    c) provides TICKS to SDOSRT to allow clock tick routines
       to run.
A schematic of the interrupt routine is shown.  The corresponding assembly code
for it should be extremely short and easy to understand and validate.
GATEUP is XDEF'd so that the prediction task can set it non-zero
if it predicts "no train will arrive soon".  If GATEUP is a single
byte, the prediction task must set it 255 every 500 milliseconds or
the real gate will drop.

       ---------------
      < 2Ms Interrupt >
       ---------------
              |
              |
              ^
             / \
            /   \
           /     \
          /       \   >0 (set nonzero when prediction task sez "no train")
         <  GATEUP >---------------------------\
          \       /                            |
           \     /                             |
            \   /                              |
             \ /                               |
              V  =0                            |
              |                                |
              |                                V
              |                 --------------------------------------
              |                 !       GATEUP := GATEUP -1          !
              |                 ! Send special signal to gateup hdwe !
              |                 --------------------------------------
              |                                |
    !-------------------!                      |
    !      A:=2         !<---------------------/
    !-------------------!
              |
              |
        ------------
       <   RTTICK   >
        ------------
              |
              V
           -------
          <  RTI  >
           -------



<NEED TO SPECIFY WHAT HAPPENS TO ALL
HARDWARE VECTORS> <NEED TO RESERVE SWI VECTOR FOR SDDBG> <ALL MODULES MUST
BE LISTED IN THE GCBGLB MODULE SO THAT A RESET ROUTINE IN EACH MODULE CAN
BE CALLED AT RESET TIME, BEFORE APPLICATION PROGRAM EXECUTES>

IMPLEMENTING THE SDM EXCHANGE MECHANISM

To keep within the spirit of the original SDM language design document,
SDMSPT provides support routines to implement the EXCHANGE primitive.
Two kinds of exchanges are allowed by the language: a "standard" exchange,
in which the first activity executing an EXCHANGE waits for second to
do the same, and then a single scalar value is exchanged.
The second type is a REALTIME EXCHANGE, which, when executed, determines if
another activity is already waiting, and if so, proceeds with a standard
exchange, and if not, aborts the exchange; a boolean result of the REALTIME
EXCHANGE indicates TRUE if the exchange was succesful, and false if aborted.
Ideally, an exchange should operate regardless of whether the other
activity is software or hardware. A single interface is provided to
the compiler that implements these ideas properly.


>>>THIS CODE NEEDS COMPLETE REWRITE
? How does SDM ensure that only two tasks reference an exchange at any one
time? <CAN IMPLEMENT EXCHANGE BY:
     <initialize SDOSRT LOCK to -2 resources>

* DECLARE <channel> generates following code:
<channel> RMB  SCB:SIZE                reserve storage for Semaphore
          RMB  4                       data exchange area

RESET     CLR  <channel>+4             note: 1st task thru code
          LDX  #<channel>
          JSR  RTISCB                  reset semaphore
          LDA  #-2                     lock semaphore twice too often(??)
          STA  SCB:COUNT
          ...
          RTS

* EXCHANGE <channel> generates following code:
         LD?  value                    fetch value to exchange
         LDX  #<channel>
         JSR  SDMXCHG                  call RTE support routine
         ST?  value                    store exchanged value
     ...
SDMXCHG EQU * ; SDM RTE support routine to implement exchange
* (X) points to channel (SDOSRT Semaphore)
         pshs  x,y,u,a,b               save value to exchange
         jsr   RTUNLK                  unlock semaphore
* Note: 2 unlocks needed to cause an exchange
         jsr   RTLOCK                  lock the semaphore
* Assert: can't get here unless 2 UNLOCKs applied to same channel!
             ??? more thought needed here???



APPGLB: APPLICATION PROGRAM GLOBAL DATA MODULE ORGANIZATION

The module APPGLB contains Pools, Channels, and other data specified as global
by the various SDM application modules.  It also contains tables used by SDMDBG
and INTRPT to locate SDM-compiled modules. This module is coded by hand, in
assembly code.

The global table ACTVTS specifies the list of "activities" defined by the SDM
application program modules, by giving information about each activity. The
>>>> NEED NOTE REFERENCING SDOSRT INTERFACE REQUIREMENTS, saying they
are nodfned in this document, but form a basis for all.


programmer must specify, for each activity, a pointer to an SDOS/RT Task
Control Block, the task priority, a Stack area and size, and the starting
address of each activity.  The Task Control block and stack area for each task
are reserved within the APPGLB module, but are filled in the the RESET code in
INTRPT.  The start address for each task is defined externally to APPGLB.  At
system reset time, the RESET routine scans the ACTVTS table, fills in each TCB,
sets the task priorities, initializes the stack areas for over/underflow
detection, sets each task up to start immediate execution at the start address
specified for that task, and marks all tasks as ready for execution. If the
tasks require further initialization in some particular order, this can be
accomplished by judicious use of LOCKs in the application code of the various
tasks, as this is a synchronizing problem.

         XDEF  ACTV1B,ACTV2B,...,ACTVnB
  ACTVTS EQU * ; "Activities" definition table
         ; FDB PointerToTCB,TaskPriority,PointerToStackArea,StackSize,BeginAddress
         FDB   ACTVT1,ACTV1P,ACTV1S,ACTV1C,ACTV1B
         FDB   ACTVT2,ACTV2P,ACTV2S,ACTV2C,ACTV2B
         FDB   ...
         FDB   ACTVTn,ACTV3P,ACTVnS,ACTVnC,ACTVnB

ACTVTS is used by SDMDBG to locate TCBs for the various activities, in
order to be able to state the status of any particular activity.

Each activity has a TCB, as defined by SDOS/RT.  In addition, the text
name of an activity (and the length of that name in bytes) is concatenated
onto the TCB so the activity name can be printed by SDMDBG.  An example
is shown below:
   TASK1 RMB  TCBSIZ                   RESERVE SPACE FOR TCB FOR TASK1
         FCB  lengthofTASK1name        # BYTES REQUIRED TO HOLD NAME OF TASK
         FCC  "nameofTASK1"
For production mode, task names may be left out of the system.

The global tables MODULS is used by SDMDBG to locate module headers for
all compiled modules in an application, to allow programmer inspection
of variables.  This table is constructed by the application programmer
by hand (although it might be possible to construct it automatically
given the link editor commands used to combine all the modules in an
application), and has the following format:
         XDEF MODULS ; make table global so SDMDBG can find it
         FDB  addressofmoduleentrypoint1
         FDB  addressofmoduleentrypoint2
         FDB  addressofmoduleentrypoint3
         ...
         FDB  addressofmoduleentrypoint
         FDB  0      ; marks end of module header list
For production mode, this table may be left out of the system.

SDM MODULE ORGANIZATION

The RTE requires that SDM modules produced by the compiler contain
certain kinds of embedded information to aid in problem diagnosis and
interrogation by the SDBDBG module.

Several structures are required: a MODULE HEADER, ERROR DIAGNOSIS CODE, and
error diagnostic reporting source cross reference information. This
information is included in an SDM module whenever the compiler is operating in
test mode. The module header contains the text name of the module, for
printing by the SDBDBG, as well as pointers to the source reference
information. The source reference information consists of two kinds: SOURCE
LINE CROSS REFERENCE, and VARIABLE NAME TO VALUE TABLE.  The source line cross
reference allows SDBDBG to convert a program counter value back to a source
line number in the original program.  The variable name to value table allows
the value of a variable to be interrogated via SDBDBG by the operator. Error
diagnosis code is compiled for array references, to ensure that array bounds
are within declared bounds, and for checking that values stored into a variable
are within declared bounds. All of this structure is produced automatically by
the compiler.

The module header consists of a single fixed record of information, one
per module, and has the following structure:

  mname  FCC   /nameofmoduleinascii/   ; hold textual name of module
         FCB   mnamelength             ; number of characters in module name
         FDB   mname                   ; pointer to module name as text
         FDB   slcrt                   ; points to source line cross reference
         FDB   vntvt                   ; points to variable name to value table
;        FDB   *+2                     ; points to base of module code
         XDEF  moduleentrypoint        ; make entry point of module known
moduleentrypoint EQU * ;
         <all code of module follows>
??WHAT ABOUT RESET CODE ?

The module name (and name length) is needed to allow SDMDBG to identify, to a
programmer, the name of an offending module when an error is detected.  The
pointer to the source line cross reference table is needed to locate that
table when trying to convert a program counter back to a source line.
The varible-name to value table pointer is likewise needed to locate that
table when a programmer wishes to determine the value of some variable.
When the compiler is operating in test mode, the module header is produced
as shown. When operating in production mode, the module header is simply not
generated.

The module header is located by use of the current value of a variable
called the Stack Frame Pointer (SFP), which exists for each independent
process. On entry to an SDM module, the current value of SFP is pushed onto
the runtime stack, as well as the address of the current module header, and
then SFP is set to the current value of the processor's S register; this set
of values is called the STACK FRAME CORE. During execution of the module,
various values may be pushed/popped from the stack, but the stack frame core
will remained unchanged.  The stack frame core, plus the set of values pushed
onto the stack by the currently executing module, is collectively called a
STACK FRAME.  Exiting from this module will cause the entire stack frame to be
removed from the stack, and the SFP to be restored to the value it had on
entry. At any instant in time, several stack frames may exist on the stack for
an executing task, and all stack frames are locatable via SFP and the chain of
stack frame cores. A dummy stack frame is pushed at the very top of the stack
by the system reset code; the dummy stack frame contains a return address of 0
and terminates the chain of stack frames.

     !----------------------!    (higher addresses)
     !  return address      !         pushed by caller of this module doing JSR
     !----------------------!
     ! SFP of caller (SFP1) !         pushed on entry to module
     !----------------------!
     !  ptr to module hdr   !         pushed on entry to module
     !----------------------!
     !      values          ! <---  SFP  made to point here on entry to module
     !      pushed          !
     !      onto            !
     !      stack           !         temporary values, return addresses, etc.
     !      during          !
     !      module          !
     !      execution       !
     !                      ! <--- S register    of processor executing module
     !----------------------!    (lower addresses)

     The current stack frame for a task.

When SDMDBG is asked to display the status of a particular task, it first
locates the corresponding TCB by searching the ACTVTS table for a task whose
name matches that of the inquiry.  The TCB contains information about a
suspended task, including its current S register value, and the value of the
last SFP when the task was active.  The top of a suspended task's stack always
contains an interrupt context block, including the most recent value of the PC
for a task.  This PC value is used to locate which source line number was being
executed when the task was suspended. Using the SFP, the stack frame core is
easily located.  The pointer to the module header can be followed to determine
and display the name of the module currently being executed. The PC from the
stack frame core indicates the return address of the module which called this
 FDB   GLOBAL  ; points to dummy GLOBAL module (MUST XDEF
OTHER MODULENAMEAMES

one, and is used to determine the source line of the
caller's module which was executed to pass control to this one.  The chain
of stack frames can be followed back to the dummy stack frame, pulling
PC's from the stack frame cores, and displaying the corresponding source
lines. Thus the dynamic call structure of an arbitrary task can be
displayed in terms easily understood by the programmer.

In the case of an automatically detected error, a TCB is implicitly selected by
the task that was executing when the error was detected [this assumes that no
interrupt routine is coded in SDM; this is easily accomplished by requiring
that interrupt routines always be coded in assembly, and do very little more
than acknowledge the device interrupt and signal an event to wake an activity
that services the device]. Since each TCB has the name of the activity
attached, the name of the erroring activity can be displayed.  The rest of the
process of displaying the source line numbers and call structure is as outlined
above.

[The process of locating the last value of the task's S register and SFP is
complicated slightly by the stack switching mechanism of SDOS/RT. This
complication does not affect the logical mechanism outlined above. SDOS/RT has
a pointer called RTCTSK (???); if RTCTSK points to a TCB, then the S register
for the task is stored in RTISP, and the SFP for the task is stored in the
scratchpad area in page zero, rather than the scratchpad area in the TCB.  If
RTCTSK does not point to a particular TCB, then the procedure for locating S
and SFP is as outlined earlier.]

The SOURCE LINE CROSS REFERENCE TABLE (SLCRT) allows SDMDBG to convert a PC
value back into a source line number in the original SDM module.  The compiler
produces code for each source line statement in a block of sequentially
increasing addresses, and it is extremely unlikely that any one source line can
occupy more than 255 bytes of object code [note: while SDM specifies that
IF-THEN-ELSE and DO WHILE are statements, and can obviously occupy arbitrarily
large blocks of object code, we are discussing source LINES, not STATEMENTS]. 
On these assumptions, a byte (FCB; FDB could have been used but the table would
necessarily be twice as large with virtually no gain in utility) table of
offsets can be constructed; each slot in the table corresponds to one line in
the original source, and holds the size of the object code for that source line
in bytes.  Thus, slot 10 of the table holds the size of the object code for
line 10 in bytes.  Converting the value of a PC, known to be inside a
particular module, to a source line number in that module, then requires the
following algorithm to be executed:

     1) subtract the base address of the module from the PC to get an offset
        (the base address is stored in the module header)
     2) set source line number to 0.
     3) scan the SLCRT, adding 1 to the source line number, and
        subtracting the byte length of each statement, until the
        remaining offset goes negative.
     4) Print the source line number.

The structure of the Source Line Cross Reference table is as follows:
         FCB   sizeofline1inbytes
         FCB   sizeofline2inbytes
         FCB   sizeofline3inbytes
         ...
         FCB   sizeoflineNinbytes
When operating in production mode, the compiler simply does not produce this
table, to conserve space.

The VARIABLE NAME TO VALUE TABLE (VNTVT) is used to convert the name of a
variable in a module into the address of a routine to compute the location of
the value of that variable.  This address can then be used to fetch the value
for display, or to modify the value of the variable, on demand by a programmer
via SDMDBG.  The structure of the VNTVT is as follows:
         FDB   pointertoaccessroutineforvariable1,encodednameofvariable1
         FDB   pointertoaccessroutineforvariable2,encodednameofvariable2
         FDB   pointertoaccessroutineforvariable3,encodednameofvariable3
         ...
         FDB   pointertoaccessroutineforvariableM,encodednameofvariableM
         FDB   0
Each variable name defined LOCALLY by the program has an entry in this
table. The name is encoded by computing a 16 bit "signature" of the actual
variable name.  [The actual signature used is a Cyclic Redundancy Checksum
computed over the stream of bytes forming the ascii name of the variable;
this signature was chosen because it produces values that act "random", so
the probability of any 2 variables having the same signature in a module
with 100 variables is approximately 1-(1-(1/65536))^100) or about .001] The
reason for encoding a variable name into 16 bits is simply to save space
(storing the text strings would be prohibitive). The
"pointertoaccessroutineforvariablen" is the address of a piece of code
which computes the location of the desired variable, given that (D) holds
the first subscript index (if needed) and that (X) holds the second
subscript index (if needed), and returns the address of the datum in (X).
It also signals to the caller the type of data by JMP'ing to a particular
re-entry point in SDMDBG as its last action; the data type entry points
include DTBITV (Data Type: Bit Vector), DTSINT (Data Type: Signed Integer),
DTBYTE (Data Type: Unsigned Byte), DTBOOL (Data Type: Boolean) or DTREAL
(Data Type: Real).

Access procedures for scalar variables consist of the following code:
           accessroutineforscalarN EQU *
                 LDX    #scalarNstorageaddress  ; fetch address of scalar
                 JMP    DTtype                  ; signal type of data

Access procedures for array variables consist of the following code:
           accessroutineforarrayM EQU *
                 JSR    subscriptarrayM         ; do subscript computation
                 JMP    DTtype                  ; signal type of data
??? WHY NOT EMBED THIS CODE IN THE TABLE AND SAVE THE POINTER?

In production mode, the compiler does not generate the VNTVT or the
access procedures, to save space.

ERROR DIAGNOSIS CODE is generated by the compiler to check that constraints
declared by the programmer on subscript and value ranges is not violated
at execution time.

Subscript range checking is combined with array subscript operations into
a subroutine generated by the compiler, one per each LOCALLY declared
subscripted array, in order to minimize the amount of space occupied
by subscripting code.  For each singly-subscripted array, the compiler
generates the following code:
          subscriptN EQU * ; code to perform subscript check/computation
          * Entered with (D) holding subscript index value
                  CMPD  #upperbound
                  LBHI  UB1ERR    branch if upper bound violation
                  SUBD  #lowerbound
                  LBLO  UB1ERR    branch if lower bound violation
                  LDX   #storageallocatedforarray
                  IF    bytetype
                  LEAX  D,X       compute location of data
                  ELSEIF wordtype
                  LEAX  D,X       compute location of data
                  LEAX  D,X       ... as displacement * 2
                  ELSEIF realtype
                  LEAX  D,X       compute location of data
                  LEAX  D,X       ... as displacement * 3
                  LEAX  D,X
                  ENDIF
                  RTS
>>>code ABOVE becomes SUBROUTINE CODE above
For each doubly-subscripted array, the compiler generates the following
subroutine code:
           subscriptN EQU * ; code to perform subscript check/computation
           * Entered with (D) holding 2nd subscript index value
           * and (X) holding 1st subscript index value
                  CMPD  #upperboundon2ndsubscript
                  LBHI  UB2ERR    branch if upper bound violation
                  SUBD  #lowerboundon2ndsubscript
                  LBLO  LB2ERR    branch if lower bound violation
                  CMPX  #lowerboundon1stsubscript
                  LBHI  UB1ERR    branch if upper bound violation
                  LEAX  -lowerboundon1stsubscript,X
?? DOES THE ABOVE LINE REALLY WORK?
                  LBLO  LB1ERR    branch if lower bound violation
                  IF upperboundon1stsubscript-lowerboundon1stsubscript>255
                  LDU   #upperboundon1stsubscript-lowerboundon1stsubscript
                  JSR   MULDUX    multiply D by U and add X
>>> MULDUX belongs in SDMSPT module
                  ELSE
                  LDA   #upperboundon1stsubscript-lowerboundon1stsubscript
                  MUL             multiply 2nd subscript by stride
                  LEAX  D,X       compute offset into array in units of elements
                  TFR   X,D       convert elements to byte offset
                  ENDIF
                  LDX   #storageallocatedforarray
                  IF    bytetype
                  LEAX  D,X       compute location of data
                  ELSEIF wordtype
                  LEAX  D,X       compute location of data
                  LEAX  D,X       ... as displacement * 2
                  ELSEIF realtype
                  LEAX  D,X       compute location of data
                  LEAX  D,X       ... as displacement * 3
                  LEAX  D,X
                  ENDIF
                  RTS

These routines perform the subscript computation necessary to access an
array, as well as ensuring that out-of-bounds subscripts are detected. The
labels UB1ERR, UB2ERR, LB1ERR and LB2ERR are entry points into SDMDBG, which
cause an appropriate error message to be displayed, along with the module
name and line number that failed. In production mode, the compiler leaves out
the upper bound CMP instructions and the LBxx to save space, and some time.

VALUE CHECKING routines ensure that all variables contain values as
declared by the application programmer.  For each variable declared locally
to a module, the compiler generates the following subroutine:
       storeintovariablen EQU * ; check and store value into variable N
       * On entry, value to be stored is in (A), (D) or (A,U).
                  IF    scalarvariable
                  IF    bytetype
                  STA   variablen
                  ELSEIF wordtype
                  STD   variablen
                  ELSEIF realtype
                  STA   variablen
                  STU   variablen+1
                  ENDIF
                  ELSE
                  IF    bytetype
                  STA   ,X           ; address pre-computed
                  ELSEIF wordtype
                  STD   ,X
                  ELSEIF realtype
                  STA   ,X
NOTE THAT FLOAT VALUE IS IN (A,U)
                  STU   1,X
                  ENDIF
                  ENDIF
                  IF    bytetype
                  CMPA  #lowervaluebound
                  LBLO  LBVERR      ; branch if lower value bound violated
                  CMPA  #uppervaluebound
                  LBHI  UBVERR
                  ELSEIF wordtype
                  CMPD  #lowervaluebound
                  LBLT  LBVERR
                  SUBD  #uppervaluebound
                  LBGT  UBVERR
                  ELSEIF realtype
                  LDB   #lowervalueboundexponent
NOTE THAT 2nd FLOAT VALUE IS IN (B,U)
                  LDX   #lowervalueboundmantissa
                  JSR   FCMP
NOTE THAT FCMP DOES NOT DESTROY (A,X), sets CC according to signed
result,etc.
                  LBLT  LBVERR
                  LDB   #uppervalueboundexponent
                  LDX   #uppervalueboundmantissa
                  JSR   FCMP
                  LBGT  UBVERR
                  ENDIF
                  RTS

The compiler always generates a
                  JSR   storevariablen
to cause a value to be stored into a local variable.  The store subroutine
stores the value first and then checks it for validity, so if a value error
is detected, the programmer can see the bad value, which may give him some
clue as to its source.  In production mode, the compares and branches
are not generated by the compiler, to save some time and space.










A module whose name is GLOBAL must be defined by hand by the application
programmer.  It must contain a module header, an empty SLCRT (because the
GLOBAL module won't have any compiled source code in it), storage areas for
all global variables and matching XDEFS, error diagnosis and subscripting
routines for such variables, and a VNTVT which includes all global variables
defined by the application.  Construction of this module enables SDMDBG to
show variable values of global variables to the programmer, as well as
correct operation of the compiled application program using global variables.
An assembly-time macro to compute the signature of a variable name will be
provided to help the application programmer encode variable names. (I HOPE IT
CAN BE WRITTEN, OTHERWISE HOW DO WE ENCODE VARIABLE NAMES BY HAND?)

SDMDBG PROGRAMMER INTERFACE

SDMDBG allows the programmer to write any of the following
 <activity>.<module>.<variablename> '[' subscript1value ',' subscript2value ']'
 <activity>.<module>.<variablename> '[' subscript1value ']'
 <activity>.<variablename> '[' subscriptue ']'
to fetch the value of a variable and display it.
[extra cost to allow := value on end, or simplified syntax to focus
on particular activity/module if not mentioned again]


Allow NMI: what are you doing?
Allow task interrogaton, modif?
Reporting of errors by error type, task, module, line.
Set breakpoints on task/module/line.
