        TITLE   YIKBUG FOR 6809 *** (C) 1982 SOFTWARE DYNAMICS ***
        WITH    WI=132,DE=66,ndmp


        PCC     0
        PCA     0
        PSR     0


;        Edit date:                    8/12/83
;        Edit time:                    11:26



*       CONFIGURATION
*


         IFUND STANDARDCOLORCOMPUTER
STANDARDCOLORCOMPUTER  EQU 1
         FIN   STANDARDCOLORCOMPUTER

         IF    STANDARDCOLORCOMPUTER
displaybuffer equ ($3800)&$FF00        SAM chip limitation
RAM      EQU   displaybuffer+16*32
CODE     EQU   RAM+256
         FIN   STANDARDCOLORCOMPUTER

         ifund code
code     equ   $f800
         fin

         ifund ram
ram      equ   $F700
ramend   equ   $F7FF
         fin   ram


         ifund nspt
nspt     equ   18                       default to tandy disks
         fin   nspt

         ifund nbps
nbps     equ   256
         fin   nbps
         page  Standard Yikbug Definitions




;       REGISTER DISPLACEMENTS INTO THE STACK
;       ASSUMING USER'S (S) IS IN (X)

        ORG     0
CCREG   RMB     1       condition code
AREG    RMB     1       A register
BREG    RMB     1       B register
DPREG   RMB     1       Direct Page register
XREG    RMB     2       X register
YREG    RMB     2       Y register
UREG    RMB     2       user stack pointer (U register)
PREG    RMB     2       program counter



        ORG     $0
;       RAM STORAGE NEEDED BY DEBUG
defaultuserstack equ ram
        RMB     12              ONE STACK FRAME (Default User's frame)
USRSTK  RMB     2               USER'S STACK POINTER (HIS S)
USRPC   RMB     2               USER'S PC
OURSTK  RMB     2               OUR STACK
*
PARMF   EQU     $80             'PARAMETER GIVEN' FLAG
FIRST   RMB     5               FIRST PARAMETER
INTSAV  EQU     FIRST           USER'S INTERRUPT STATE
FSTSIZ  RMB     1               # OF BYTES IN FIRST PARAMETER
SECOND  RMB     5               SECOND PARAMETER
SECSIZ  RMB     1               # OF BYTES IN SECOND PARAMETER
NXDLOC  RMB     2               NEXT LOCATION TO DISPLAY
NUMBER  RMB     2               POINTER TO THE NUMBER ENTERED (GNUM)
TMPBYTE RMB     2               SCRATCH SPACE
TMPWORD RMB     2               SCRATCH SPACE
CKSUM   EQU     FIRST           CHECKSUM ACCUMULATOR
OPNLOC  RMB     2               LAST OPENED LOCATION
OPNFLG  RMB     1               FLAG INDICATING VALIDITY OF OPNLOC
BRKLOC  RMB     2               PLACE WHERE BREAKPOINT SET, $FFFC --> NONE
BRKSAV  RMB     3               HOLDS DATA WHERE BREAKPOINT IS SET

        ORG     $80             END OF DEBUGGER RAM
STACKE  RMB     0               END OF STACK
         page  Colormate (TM) Definitions




         org   ram-64


dcddsrstatus   rmb                     1 ; for 6551 acia dcd/dsr status
fdcstatusave   rmb                     1 ; a place to save fdc status on nmi
fdccontrolsave rmb                     1 ;for tandy fdc control byte
nmipointer     rmb                     2 ; for nmi
firqpointer    rmb                     2 ; for firq
irqpointer     rmb                     2 ; for irq
swipointer     rmb                     2
swi2pointer    rmb                     2
swi3pointer    rmb                     2
runningencrypted                       rmb 1



;        SDOS boot definitions


         org   0

currentdrive   rmb                     1
currentsector  rmb                     1
currenttrack   rmb                     1
currentcyl     rmb                     1
bootnspt rmb   1
bootntpc rmb   1
bootsectororg  rmb                     1
bootsteprate   rmb                     1
sectorlength   rmb                     2
lsn      rmb   2
diskbufferpointer                      rmb 2
tempx    rmb   2
bytecount      rmb                     2
startaddress   rmb                     2
loadaddress    rmb                     2
readsectorpointer                      rmb 2
checkerrorpointer                      rmb 2
diskbufferend  rmb                     2
diskloadaddress                        rmb 2

;        spiraling constants

k1modnspt      rmb                     1
k2modnspt      rmb                     1
k4modnspt      rmb                     1
k8modnspt      rmb                     1
k16modnspt     rmb                     1
k32modnspt     rmb                     1

;        sector map

fdmap    rmb   26
         page  Misc. Definitions




;       CHARACTER DEFINITIONS




NULL    EQU     $0
BELL    EQU     7
CR      EQU     $D
LF      EQU     $A
FF      EQU     $C
DC0     EQU     $10             DEVICE CONTROL CODES
DC1     EQU     $11
DC2     EQU     $12
DC3     EQU     $13
escape   equ   $1B
EQUAL   EQU     $3D
SLASH   EQU     $2F
BANG    EQU     $21
QMARK   EQU     $3F
DBLQUOTE EQU    '"
COLON   EQU     $3A
SEMIC   EQU     $3B
PLUS    EQU     $2B
MINUS   EQU     $2D
BKSLSH  EQU     $5C
UPARW   EQU     $5E
COMMA   EQU     $2C
SPACE   EQU     $20
PERIOD  EQU     $2E
QUOTE   EQU     $27
A       EQU     $41
C       EQU     $43
F       EQU     $46
G       EQU     $47
H       EQU     $48
K       EQU     $4B
L       EQU     $4C
M       EQU     $4D
O       EQU     $4F
P       EQU     $50
R       EQU     $52
S       EQU     $53
T       EQU     $54
U       EQU     'U
LETRX   EQU     $58
LETRA   EQU     $41
LETRB   EQU     $42
Z       EQU     $5A
ZERO    EQU     $30
NINE    EQU     $39






;       ODDBALL DEFS




TRUE    EQU     $FF             FLAG 'ON'
FALSE   EQU     $0              FLAG 'OFF'
         page  Standard Yikbug Code




        ORG     CODE

RUNAWY  NOP                     RUNAWAY PROGRAM ENTERS HERE
        NOP                            SYNCHRONIZE PC EVEN IF 5 BYTE OPCODE PRECEDES THIS
        NOP
        NOP
DEBUG   JMP     DBUG            DEBUG RESTART POINT

breakpoint     jmp                     breakpointentry  entered via JSR only!

NMIH    JMP     REENTER         INTERRUPT ENTRY POINT

GETC    RMB     3
PUTC    RMB     3
escchk   rmb   3
OPENL   RMB     3
GETL    RMB     3
CLOSEL  RMB     3
INITZ   RMB     3
selbnk0  rmb   3
selbnk1  rmb   3

INTRTI  RTI


breakpointentry
         pshs  a,b,cc,dp,u,x,y           fake an nmi
         orcc  #%11010000
         ldaa  #ram/256
         tfr   a,dp
         sts   usrstk
         ldd   preg,s                  entered via JSR, back up PC
         subd  #3
         std   preg,s
         JSR   REMOVEBREAKPOINT          RESTORE ORIGINAL CODE
         ldx   #brkmsg
         bra   reenter2

reenter  orcc  #%01010000              set f & i just like real nmi
         LDA     #RAM/256
        TFR     A,DP
        STS     USRSTK          COME HERE FOR ALL INTS BUT RESET
        LDS     #RAM+STACKE
        LDX     #INTMSG
reenter2
        JSR     PSTR
        JSR     RDUMP
        JMP     CLROPNFLG
        PAGE
*
*       MAIN DEBUG ENTRY POINT (ENTERED HERE BY RESTART)
*
dbug

;        Reset entry point

        orcc    #%01010000      set f & i just like real reset
        LDA     #RAM/256        set up direct page register
        TFR     A,DP
        LDX     #DEFAULTUSERSTACK
        STX     USRSTK
        LDS     #RAM+STACKE
        LDX     #$FFFC          = pointer to NMI vector (3 bytes of ROM)
        STX     BRKLOC          ==> "No breakpoint set"
        JSR     INITZ           INITIALIZE THE WORLD
HELLO   LDX     #GOMSG
GOLUP   JSR     PSTR            PRINT (X) -> ASCIIZ(STRING)
        BRA     CLROPNFLG

ERROR   LDA     #RAM/256        set up direct page register
        TFR     A,DP
        LDS     #STACKE+RAM     WE GOTTA HAVE A STACK
        LDX     #EHMSG
        BRA     GOLUP
        PAGE
CLROPNFLG
        JSR     CRLF            TO END PRINT-OUT PRETTILY
        CLR     OPNFLG          YOU GUESS!
COMAND
        LDX     #FIRST+RAM      GET FIRST PARAMETER
        JSR     GNUM            GET A NUMBER TO (X)
COM1    LDX     #OPTBL          NO, ZERO OR ONE PARAMETERS
COMLUP  TST     0,X             HIT END OF TABLE?
        BEQ     ERROR           YEP, COMMAND IS NO GOOD
        CMPA    0,X             NO, FOUND MATCHING COMMAND?
        BEQ     JMPX            YES, JUMP TO ROUTINE
        LEAX    3,X             BUMP X TO NEXT TABLE ENTRY
        BRA     COMLUP          CHECK FOR MATCH

JMPX    LDD     FIRST+3         sheesh!  some commands want SERVICE!
        JSR     [1,X]           AND GO TO ROUTINE
        BRA     COMAND
*
GOMSG   FCB     CR,LF,BELL
        FCC     "IDB09 (C) 1983 Software Dynamics"
        FCB     0       EOS MARKER

EHMSG   FCB     '?,'?,BELL,0

INTMSG  FCB     CR,LF,bell,'I,'N,'T,0
brkmsg   fcb   cr,lf,bell,'B,'r,'k,0
        PAGE
OPTBL   FCB     LF              EX NEXT
        FDB     EXNX
        FCB     LF+PARMF        DEPOSIT AND EXAMINE NEXT
        FDB     STEXNX
        FCB     CR              NOP (CLOSE'OPEN' LOC)
        FDB     CLOSE
        FCB     CR+PARMF        DEPOSIT AND CLOSE CELL
        FDB     DEPOSC
        FCB     SLASH+PARMF     EXAMINE MEMORY
        FDB     EXAMM
        FCB     UPARW           EXAMINE PREVIOUS
        FDB     EXPREV
        FCB     UPARW+PARMF     DEPOSIT THIS AND EXAMINE
        FDB     DEPEXP
        FCB     L               LOAD MIKBUG THROUGH LOAD ACIA
        FDB     LOADL1
        FCB     G               GO TO PC ON STACK
        FDB     GO
        FCB     G+PARMF         GO TO SPECIFIED LOC
        FDB     GO1
        FCB     R+PARMF         COMPUTE BRANCH DISPLACEMENT
        FDB     BRANCHDISP
        FCB     SEMIC+PARMF     DEPOSIT IN REGISTER
        FDB     RSTORE
        FCB     QMARK           REGISTER DUMP
        FDB     RDUMP
        FCB     '!+PARMF        SET BREAKPOINT
        FDB     SETBREAKPOINT
        FCB     'X+PARMF        EXECUTE UNTIL ADDRESS HIT
        FDB     EXECUTEUNTILADDRESS
        FCB     0               END OF LIST
        PAGE
EXNX    LDAA    #CR             EXAMINE NEXT
        JSR     PUTCHAR
        LDAA    #NULL
        JSR     PUTCHAR
        TST     OPNFLG
        BEQ     JERR1
        LDX     NXDLOC
EXNX2   STX     OPNLOC
EXNX3   LDX     OPNLOC
        JSR     PNUMX
EXNX4   LDAA    #SLASH
        JSR     PUTCHAR
        BRA     EXAM1
*
EXAMM   STD     OPNLOC          EXAMINE MEMORY
        LDAA    #TRUE
        STAA    OPNFLG
EXAM1   BSR     JTSP1
        LDAA    #1
EXAM2   LDX     OPNLOC          SET UP DISPLAY BYTE COUNT
        STX     NXDLOC          NEXT LOCATION TO EXAMINE...
EXAM3   STAA    TMPBYTE         = LAST LOCATION DISPLAYED + 1
        BNE     EXAML           B/ NONZERO DISPLAY BYTE COUNT
        LDAA    #QMARK          ILLEGAL OPCODE, SHOW "?XX"
        BSR     JPUTCHAR1
        INC     TMPBYTE         SET DISPLAY COUNT TO ONE
EXAML   LDX     NXDLOC
        LDA     ,X+
        STX     NXDLOC
        JSR     PNUMA
        DEC     TMPBYTE
        BNE     EXAML
JTSP1   JMP     TSP
JERR1   JMP     ERROR
        PAGE
STEXNX  LDAA    #CR             DEPOSIT THIS AND EXAMINE NEXT
        BSR     JPUTCHAR1
        LDAA    #NULL
        BSR     JPUTCHAR1
        BSR     DEPOSIT         DO THE DEPOSIT
        BRA     EXNX2
*
DEPOSIT TST     OPNFLG          DEPOSIT INTO OPNLOC
        LBEQ    ERROR           B/ NOT OPEN
        LDB     FSTSIZ          get significance
        LDY     #FSTSIZ+RAM
        LDX     OPNLOC          GET OPEN LOCATION ADDRESS
        LEAX    B,X
        NEGB
DEPOSIT.1
        LDA     B,Y
        STA     B,X
        INCB
        BNE     DEPOSIT.1
        RTS
        PAGE
DEPOSC  BSR     DEPOSIT
CLOSE   LDAA    #LF             CLOSE THE OPEN CELL
        CLR     OPNFLG
JPUTCHAR1
        JMP     PUTCHAR

DEPEXP  BSR     DEPOSIT         DEPOSIT THIS, EXAMINE PREVIOUS
EXPREV  TST     OPNFLG          EXAMINE PREVIOUS
        BEQ     JERR1
        JSR     CRLF
        LDX     OPNLOC
        DEX
        JMP     EXNX2
*
PRVAL1  JSR     GCFOLD          GET TERMINATOR FOR VALUE
        ORAA    #$80
        LEAS    2,S
        JMP     COM1

BRANCHDISP      ; COMPUTE BRANCH DISPLACEMENT BYTE
        TST     OPNFLG          = (A,B)-(.+1)
        BEQ     JERR5           B/ NOT EXAMINING A PLACE !?
        SEC                     THIS DOES THE -1 PART OF -(.+1)
        SBCB    OPNLOC+1
        SBCA    OPNLOC
        STAB    FIRST+2
        ROLB                    BRANCH OUT OF RANGE ?
        ADCA    #0              (A)=SIGN(B) ?
        BNE     JERR5           B/ TOO FAR, SCREW YOU!
        INCA                    INVENT SIGNIFICANCE OF "1"
        STAA    FSTSIZ
        BRA     PRVAL1
        PAGE
LOADL1  JSR     GETL            LOOK FOR LEADING "S" CODE...
        CMPA    #S
        BNE     LOADL1
        JSR     GETL            GET BLOCK TYPE
        CMPA    #NINE
        BEQ     LOADX
        CMPA    #ZERO+1         DATA BLOCK?
        BNE     LOADL1          NO, IGNORE
        CLR     CKSUM           ZERO THE CHECKSUM
        BSR     LBYTE           GET BYTE COUNT+2 (FOR ADDRESS)
        SUBA    #2
        STAA    TMPBYTE         SAVE NUMBER OF BYTES TO LOAD
        BSR     LBYTE
        STAA    OPNLOC          FORM ADDRESS
        BSR     LBYTE
        STAA    OPNLOC+1
        LDX     OPNLOC
        STX     FIRST+1
LOADB   BSR     LBYTE           FETCH NEXT DATA BYTE
        DEC     TMPBYTE         ALL DATA BYTES LOADED ?
        BEQ     LOADD           YES, GO CHECK CHECKSUM
        LDX     OPNLOC          GET STORE ADDRESS
        STA     ,X+             STORE THE BYTE
        STX     OPNLOC          BUMP THE STORE POINTER
        BRA     LOADB
*
LOADD   INC     CKSUM           CHECKSUM OK?
        BEQ     LOADL1          YES, GO LOOK FOR ANOTHER RECORD
LDERR   BSR     TSP             NO, YELL AND SCREAM AND SHOUT!
        LDX     FIRST+1
        BSR     PNUMX
JERR5   JMP     ERROR
        PAGE
LBYTE   BSR     LNIBBLE LOAD 1ST NIBBLE
        BSR     LNIBBLE AND THEN SECOND NIBBLE
CKSUMA  TAB             ADD (A) TO CHECKSUM WITHOUT DISTURBING (A)
        ADDB    CKSUM
        STAB    CKSUM
        RTS

LNIBBLE EQU     *       LOAD NIBBLE, COMBINE WITH (A)
        ASLA            SHIFT OLD (A) LEFT 4 PLACES TO MAKE ROOM FOR NEW NIBBLE
        ASLA
        ASLA
        ASLA
        PSHA
        JSR     GETL    READ LOAD BYTE
        JSR     ISHEXDIG        A HEX DIGIT ?
        BCS     LDERR   B/ NO, CROAK DIE
        ADDA    ,S+     YES, COMBINE WITH LEFT SHIFTED NIBBLE
        RTS

LOADX   BSR     TSP
        LDX     OPNLOC
        DEX
        BSR     PNUMX   PRINT OUT LAST LOC'N LOADED AND FALL THROUGH

CRLF    LDA     #CR             DO A CARRIAGE RETURN, LINE FEED
        JSR     PUTCHAR
        LDA     #LF             ECHO LINE FEED
        JMP     PUTCHAR

TSP     LDA     #SPACE          TYPE A SPACE
        JMP     PUTCHAR
        PAGE
*
*       PNUMX ---- PRINT NUMBER IN X
*       ASSUMED TO HAVE 4 DIGITS
*
PNUMX   LDAB    #4              PRINT 2 BYTE VALUE IN X
PNUMV   STX     NUMBER          PRINT A VARIABLE # BYTES
        BRA     PNUML
*
*       PNUMA --- PRINT NUMBER IN A
*       ASSUMED TO BE ONE BYTE
*
PNUMA   STAA    NUMBER          STORE VALUE
        LDAB    #2              # DIGITS TO PRINT
PNUML   LDAA    #ZERO/16                THIS REALLY ISN'T MAGIC
        PSHB            SAVE # DIGITS TO PRINT
        LDAB    #4      GET BIT SHIFT COUNT
PNUM2   ASL     NUMBER+1                SHIFT MSB INTO A
        ROL     NUMBER
        ROLA
        DECB            DOWN COUNT BIT SHIFT
        BNE     PNUM2   B/ MORE BITS TO SHIFT
        CMPA    #NINE           > DECIMAL 9?
        BLS     PNUM1           NO, GO PRINT IT...
        ADDA    #LETRA-ZERO-10          YES, CONVERT TO A-F
PNUM1   JSR     PUTCHAR         DISPLAY DIGIT
        PULB            GET DIGIT DISPLAY COUNT BACK
        DECB                    DOWN COUNT # OF DIGITS TO PRINT
        BNE     PNUML           LOOP TILL ALL PRINTED
        RTS                     THEN EXIT
        PAGE
*
*       ISHEXDIG -- CHECKS TO SEE IF (A) IS A HEX DIGIT
*       RETURNS CARRY RESET IF YES, DIGIT CONVERTED TO BINARY
*       CARRY SET IF NO, CHARACTER UNDISTURBED
*
ISHEXDIG
        CMPA    #NINE
        BLS     IS0TO9
        CMPA    #G
        BCS     ISATOF
ISDNO   ORCC    #1
        RTS

IS0TO9  CMPA    #ZERO
        BCS     ISDNO
        SUBA    #ZERO
        RTS

ISATOF  CMPA    #LETRA
        BCS     ISDNO
        SUBA    #LETRA-$A
        RTS
        PAGE
*       GNUM -- GET NUMBER TO ( X..X+4 )
*       RETURNS TERMINATOR IN A
*       NUMBER SIZE ('0'..'4' BYTES) IN (B), (X+5)
*
GNUM    STX     NUMBER          SAVE POINTER TO NUMBER BUFFER
        CLR     5,X             SET NUMBER DIGITS RECEIVED
        CLR     0,X             SET VALUE TO ZERO
        CLR     1,X
        CLR     2,X
        CLR     3,X
        CLR     4,X
GNUML   BSR     GCFOLD          GET NEXT CHARACTER
        BSR     ISHEXDIG        IS IT A DIGIT?
        LDX     NUMBER          GET POINTER TO VALUE BUFFER
        BCS     GNUMX           B/ WE'RE DONE
        INC     5,X             YES, BUMP DIGIT COUNT
        LDAB    #4              # BITS TO SHIFT FOR ONE HEX DIGIT
GNUMS   ASL     4,X             SHIFT COLLECTED VALUE...
        ROL     3,X             LEFT ONE HEX DIGIT
        ROL     2,X
        ROL     1,X
        ROL     0,X
        DECB                    DOWN COUNT SHIFT DISTANCE
        BNE     GNUMS
        ADDA    4,X             ADD NEW DIGIT TO OLD VALUE
        STAA    4,X
        BRA     GNUML           GO GET ANOTHER DIGIT
        PAGE
GNUMX   LDAB    5,X             ANY DIGITS ENTERED?
        BNE     GNUMR           YES, NOT REFERENCE TO LOCATION
        CMPA    #QUOTE          SINGLE QUOTE?
        BEQ     GNUMQ           YES, MUST BE A CHARACTER VALUE
        CMPA    #PERIOD         IS TERMINATOR THE SPECIAL DOT ?
        BNE     GNUMP           NO, GO TRY FOR PC VALUE
        LDD     OPNLOC          GET VALUE OF LAST LOCATION OPENED
GNUMV   LDX     NUMBER          GET POINTER TO NUMBER BUFFER
        STD     3,X             STORE THE VALUE IN (A,B)
        BSR     GCFOLD          GET THE TERMINATOR CHARACTER
        LDAB    #2              USE LOCATION COUNTER SIZE = 2
        BRA     GNUM1           TAG THE OPERATOR AS MONADIC
*
GNUMP   CMPA    #'*             REFERENCE TO LAST PC VALUE ?
        BNE     GNUMR           B/ NO, GO ROUND DIGIT COUNT TO BYTE SIGNIFICANCE
        LDX     USRSTK          GET POINTER TO USER'S STACK
        LDD     PREG,X          USE USER'S PC AS VALUE
        BRA     GNUMV

GNUMR   ASRB                    ROUND B FROM DIGITS...
        ADCB    #0              TO NIBBLES
        BEQ     GNUMZ
        CMPB    #5
        BHI     JERR6           # BYTES MUST BE <= 5
GNUM1   ORAA    #$80            TAG THE OPERATOR AS MONADIC
GNUMZ   LDX     NUMBER          GRAB POINTER TO THE VALUE
        STAB    5,X             STORE THE SIGNIFICANCE INTO THE VALUE
        RTS

JERR6   JMP     ERROR
GNUMQ   BSR     GCECHO          THIS IS THE VALUE
        LDX     NUMBER          GET POINTER TO VALUE
        STAA    4,X             STORE QUOTED CHARACTER INTO VALUE
        BSR     GCFOLD          GET THE TERMINATOR
        LDAB    #1              SET VALUE PRECISION
        BRA     GNUM1           GO MARK AS MONADIC AND EXIT
        PAGE
*
*       GCFOLD -- GET CHARACTER AND FOLD LOWER INTO UPPER CASE
*
GCFOLD  EQU     *
        BSR     GCECHO  GET A CHARACTER AND ECHO IT
        CMPA    #$61-1  LOWER CASE ?
        BLS     GCFOLD1 B/ NO
        CMPA    #$61+'Z-'A      ... ?
        BHI     GCFOLD1
        ANDA    #%01011111      YES, MASK OFF LOWER CASE BIT
GCFOLD1 RTS             AND EXIT
*
GCECHO  EQU     *
        PSHS    X
        JSR     GETC
        JSR     PUTCHAR
        PULS    X
        RTS

*       PSTR -- PRINT AN (X) -> ASCIIZ STRING

PSTR    LDA     ,X+
        BEQ     PSTR1
        JSR     PUTCHAR
        BRA     PSTR

PSTR1   RTS

PUTCHAR PSHS    A,X
        JSR     PUTC
        PULS    A,X
        RTS
        PAGE
*       RSTORE -- DEPOSIT INTO A REGISTER

RSTORE  JSR     GCFOLD          GET REGISTER NAME
        LDX     #RTABLE1
RSTOREL TST     ,X              SEE IF END OF LIST
        LBEQ    ERROR           B/ DIDN'T RECOGNIZE REGISTER NAME
        CMPA    ,X
        BEQ     RSTOREM         B/ MATCH
        LEAX    3,X             NEXT ENTRY
        BRA     RSTOREL

RSTOREM JSR     TSP             PUT OUT A SPACE
        LDB     1,X             SEE IF SIGNIFICANCE IS OK
        CMPB    FSTSIZ
        LBLO    ERROR           B/ TOO MUCH DATA
        LDA     2,X             PICK UP DISPLACEMENT INTO STACK
        BMI     RSTM2           B/ S REGISTER GETS SPECIAL TREATMENT
        LDY     USRSTK          THIS IS WHERE ALL THE REGISTERS ARE
        LEAY    A,Y
RSTM3   LDX     #RAM+FIRST+5    THIS IS WHERE THE VALUE IS
RSTM4   LDA     ,-X
        STA     ,-Y
        DECB
        BNE     RSTM4           B/ KEEP GOING UNTIL ALL BYTES TRANSFERRED
        RTS

RSTM2   LDY     #RAM+USRSTK+2
        LDX     FIRST+3         ADJUST SUPPLIED STACK BASE
        LEAX    -12,X
        STX     FIRST+3
        BRA     RSTM3
        PAGE
*       DEFINES VALID REGISTER NAMES
*               FIRST COMPONENT: REGISTER NAME
*               SECOND COMPONENT: MAXIMUM ALLOWED BYTES
*               THIRD COMPONENT: DISPLACEMENT IN STACK

RTABLE1 FCB     'C,1,1
        FCB     'A,1,2
        FCB     'B,1,3
        FCB     'D,2,3
        FCB     'Z,1,4
        FCB     'X,2,6
        FCB     'Y,2,8
        FCB     'U,2,10
        FCB     'P,2,12
        FCB     'S,2,255        255 => SPECIAL TREATMENT
        FCB     0               END OF LIST
        PAGE
*       RDUMP -- DUMP THE REGISTERS

RDUMP   JSR     CRLF
        LDU     USRSTK          THE U STACK IS GONNA MIMIC THE USER'S STACK
        LDY     #RTABLE         THIS DESCRIBES THE FORMAT OF THE DUMP
RDUMP.1 LDX     ,Y++            PRINT REGISTER NAME
        JSR     PSTR
        JSR     [,Y++]          PRINT THE CONTENTS
        BRA     RDUMP.1

*       BYTE1 -- PRINT ONE BYTE, FOLLOWED BY A SPACE

BYTE1   PULU    A
        JMP     PNUMA

*       BYTE2 -- PRINT TWO BYTES

BYTE2   PULU    X
        JMP     PNUMX

*       BYTES -- PRINT (U), CLEAN OFF THE STACK, AND EXIT

BYTES   TFR     U,X
        JSR     PNUMX
        LEAS    2,S             RETURN TO CALLER'S CALLER
        JMP     CRLF
        PAGE
*       RTABLE -- DEFINES THE FORMAT OF THE REGISTER DUMP

RTABLE  FDB     CEQ,BYTE1
        FDB     AEQ,BYTE1
        FDB     BEQ,BYTE1
        FDB     ZEQ,BYTE1
        FDB     XEQ,BYTE2
        FDB     YEQ,BYTE2
        FDB     UEQ,BYTE2
        FDB     PEQ,BYTE2
        FDB     SEQ,BYTES

CEQ     FCB     'C,'=,0
AEQ     FCB     SPACE,'A,'=,0
BEQ     FCB     SPACE,'B,'=,0
ZEQ     FCB     SPACE,'Z,'=,0
XEQ     FCB     SPACE,'X,'=,0
YEQ     FCB     CR,LF,'Y,'=,0
UEQ     FCB     SPACE,'U,'=,0
PEQ     FCB     SPACE,'P,'=,0
SEQ     FCB     SPACE,'S,'=,0
*
         PAGE
GO1     LDX     USRSTK          SET P AND GO
        STD     PREG,X
GO      JSR     CRLF            SO NEXT OUTPUT LINE IS NOT WITH DEBUG STUFF
        BSR     INSTALLBREAKPOINT
        LDS     USRSTK
        JMP     INTRTI          pass control to user program

EXECUTEUNTILADDRESS ; SET BREAKPOINT AT (D) AND THEN DO A "G"
         BSR    SETBREAKPOINT
         BRA    GO

SETBREAKPOINT ; SET BREAKPOINT AT (D); 0 --> kill breakpoint
         STD   BRKLOC                  MUST CALL INSTALLBREAKPOINT...
         BNE   SETBREAKPOINTRTS        B/ SETTING A BREAKPOINT
         LDD   #$FFFC                  = "NO BREAKPOINT"
         STD   BRKLOC
SETBREAKPOINTRTS
         jmp   tsp                     SHOW ACTION COMPLETE

REMOVEBREAKPOINT ; REMOVE BREAKPOINT JSR FROM CODE
         LDX   BRKLOC                  POINTS TO $FFFC IF NONE
         LDD   BRKSAV
         STD   ,X
         LDA   BRKSAV+2
         STA   2,X
         RTS

INSTALLBREAKPOINT ; SET BREAKPOINT JSR INTO CODE
; ITS NOT SMART TO SET A BREAKPOINT ON AN INSTRUCTION WHICH IS FOLLOWED
; BY A BRANCH TARGET WITHIN 3 BYTES; CAVEAT EMPTOR!
         LDX   BRKLOC
         LDD   ,X
         STD   BRKSAV
         LDA   2,X
         STA   BRKSAV+2
         LDA   #$BD                    = "JSR" OPCODE
         STA   ,X
         LDD   #BREAKPOINT
         STD   1,X
         RTS

*******  END OF STANDARD YIKBUG CODE
         IF    STANDARDCOLORCOMPUTER


initialize
         ldx   #defaultuserstack
         ldd   #debug                  in case user forgets to set it
         std   preg,x                    set default program counter
         clr   dpreg,x                 set to something consistent
         ldaa  #$ff                    disable all ints
         staa  ccreg,x
         ldaa  #$0c                    form feed
         jsr   putcharacter            go clear screen
         rts

bufptr   fdb   displaybuffer

putcharacter   pshs B,X,U,Y
         ldab  $ff22                   select alphanumerics mode
         andb  #%01100111              see page 24 of color computer tech ref
         stb   $ff22
         clr   $ffc4                   v2:=0
         clr   $ffc2                   v1:=0
         clr   $ffc0                   v0:=0
ref      equ   *
         rpt   7                       select display buffer address
         clr   $ffc6+((*-ref)/3)*2+((displaybuffer##(-9-((*-ref)/3)))&1)
         cmpa  #$20                    a control character ?
         bhs   putcharacter0           b/ no
         cmpa  #$0c                    form feed ?
         beq   putcharacterform        b/ yes
         cmpa  #$0d                    carriage return ?
         bne   putcharacterrts         b/ no
putcharactercrlf ; do cr/lf
         ldd   bufptr
         andb  #%11100000
         addd  #%00100000              advance pointer to next row
         tfr   d,x
         bra   putcharacter2

putcharacter0 ; output printing character
         cmpa  #$60
         blo   putcharacteru           b/ upper case already
         suba  #$20                    fold to upper case
putcharacteru
         anda  #$3f                    mask to six bits
         oraa  #$40                    to make black char on green background
         ldx   bufptr
         sta   ,x+                     store and advance pointer
putcharacter2
         cmpx  #displaybuffer+32*16
         blo   putcharacter1
         ldx   #displaybuffer
shufflescreenuploop
         lda   32,x
         sta   ,x+
         cmpx  #displaybuffer+16*32-32
         bne   shufflescreenuploop
         ldb   #32                     blank out last line
         lda   #$40!$20                blank on green background
blanklastlineloop
         sta   ,x+
         decb
         bne   blanklastlineloop
         ldx   #displaybuffer+16*32-32
putcharacter1
         stx   bufptr
         PULS  B,X,U,Y
         RTS

putcharacterform ; form feed seen
         ldx   #displaybuffer
         stx   bufptr
         ldaa  #$40!$20                put blanks all over screen
putcharacterformloop
         sta   ,x+
         cmpx  #displaybuffer+16*32
         bne   putcharacterformloop
putcharacterrts
         puls  b,x,u,y
         rts


getcharacter   equ                     *
         pshs  B,X,U,Y
getcharacter2
         JSR   [$A000]                 GO POLL KEYBOARD FOR CHARACTER
         BEQ   GETCHARACTER2
         ANDA  #$7F
         PULS  B,X,U,Y
         rts

escapecheck
         pshs  B,X,U,Y
         JSR   [$A000]                 GO POLL KEYBOARD FOR CHARACTER
         BNE   ESCAPECHECK6
         PULS  B,X,U,Y
         ldaa  #1                        clear Z bit
         rts

escapecheck6
         PULS  B,X,U,Y
         anda  #%01111111               mask parity
         cmpa  #3                      "BREAK"
         rts

openload
         ldaa  #DC1
         bra   putcharacter

closeload
         ldaa                    #DC3
         bra   putcharacter

readload bra   getcharacter

         ORG   GETC
         JMP   GETCHARACTER
         ORG   PUTC
         JMP   PUTCHARACTER
         ORG   escchk
         JMP   ESCAPECHECK
         ORG   OPENL
         JMP   OPENLOAD
         ORG   GETL
         JMP   READLOAD
         ORG   CLOSEL
         JMP   CLOSELOAD
         ORG    INITZ
         JMP    INITIALIZE

         org   $FFFE                   put a byte where nobody cares!
         fcb   0                       goddam loader screws up w/o trail byte



         ELSE
         title Alta Systems Yikbug I/O v1.00
         page  ColorMate Hardware Definitions



;        ColorMate Hardware Definitions



::       set   *


         ifund colormate
colormate      equ                     1
         fin



         if    colormate

iopage   equ   $ff00


         org   iopage

;        tandy keyboard pia


pia1ora  rmb   1
pia1cra  rmb   1
pia1orb  rmb   1
pia1crb  rmb   1

         org   iopage+$20

;        tandy video control pia


pia2ora  rmb   1
pia2cra  rmb   1
pia2orb  rmb   1
pia2crb  rmb   1



         org   iopage+$6C

;        ColorMate I/O stuff


aciadata rmb   1
aciastatus     rmb                     1
aciacommand    rmb                     1
aciacontrol    rmb                     1


viaorb   rmb   1
viaora   rmb   1
viaddrb  rmb   1
viaddra  rmb   1
viat1cl  rmb   1
viat1ch  rmb   1
viat1ll  rmb   1
viat1lh  rmb   1
viat2cl  rmb   1
viat2ch  rmb   1
         rmb   1                        ;via shift reg.
viaacr   rmb   1
viapcr   rmb   1
viaifr   rmb   1
viaier   rmb   1
         rmb   1                        ;via ora/ira ( no handshake )

         org   iopage+$40

fdccontrol     rmb                     1

         org   iopage+$48

fdccommand     equ                     *
fdcstatus      rmb                     1
fdctrack rmb   1
fdcsector      rmb                     1
fdcdata  rmb   1
         fin   colormate


         org   getc

         jmp   getcharacter
         jmp   putcharacter
         jmp   escapecheck
         jmp   openload
         jmp   readload
         jmp   closeload
         jmp   initialize
         jmp   selectbank0
         jmp   selectbank1


         page  General Yikbug I/O

         org   ::



initialize     ldx                     #$1000

wastetime      dex
         bne   wastetime

         staa  aciastatus               ;reset acia
         ldaa  #%00011110               ;set control register
         staa  aciacontrol
         ldaa  #%00001001               ;set command register
         staa  aciacommand
         nop
         nop
         ldaa  aciastatus               ;clear junk
         anda  #%01100000               ;get dcd & dsr status
         staa  dcddsrstatus
         ldd   #diskirqunexpected
         std   nmipointer
         ldd   #reenter                 ;set interrupt pointers
         std   firqpointer
         std   irqpointer
         std   swipointer
         std   swi2pointer
         std   swi3pointer
         ldx   #defaultuserstack
         ldd   #boot
         std   preg,x                    set default program counter
         clr   dpreg,x
         ldaa  ccreg,x
         oraa  #%10000000               Set E bit
         staa  ccreg,x
         ldd   #$FE34                    set up tandy pia's
         std   pia2ora
         ldd   #$FA34
         std   pia2orb
         ldaa  #$02
         ldaa  #$F0
         staa  pia2orb
         ldd   #$0034
         std   pia1ora
         ldd   #$FF34
         std   pia1orb
         staa  pia2ora
         ldaa  #$D0                     abort ==> disk ( no irq gen'ed )
         staa  fdccommand
         rts


getcharacter   equ                     *
         pshs  b

getcharacter2  ldaa                    aciastatus
         bita  #%00001000               ;rdf?
         beq   getcharacter2            ;b/ nope
         tab
         ldaa  aciadata
         anda  #%01111111               ; no parity please
         bitb  #%00000111               ; any errors?
         beq   getcharacterex           ; b/ nope
         ldaa  #$7F                      ; make it a rubout

getcharacterex puls                    b
         rts

putcharacter   pshs                    b

putcharacter2
         ldab  aciastatus
         bitb  #%00010000
         beq   putcharacter2

         staa  aciadata
         puls  b
         rts

escapecheck
         pshs  b                         save b
         ldab  aciastatus               getstatus
         bitb  #%00001000               anything there?
         beq   escapecheck4             b/ nope
         ldaa  aciadata                 read in character
         bra   escapecheck6

escapecheck4
         puls  b                         restore b
         ldaa  #1                        clear Z bit
         rts

escapecheck6
         puls  b                         restore b
         anda  #%01111111               mask parity
         cmpa  #escape
         rts


openload
         ldaa  #DC1
         bra   putcharacter

closeload      ldaa                    #DC3
         bra   putcharacter

readload bra   getcharacter
         page  Interrupt Routines





diskirqunexpected
         ldaa  fdccontrolsave           disable disk irq's
         anda  #%01011111
         staa  fdccontrolsave
         staa  fdccontrol
         ldaa  fdcstatus                save 179X status
         staa  fdcstatusave
         jmp   nmih

nmientry
         ldaa  fdccontrolsave           clear halt enable bit
         anda  #%01011111               and irq enable bit
         staa  fdccontrol
         staa  fdccontrolsave
         ldaa  fdcstatus                get 179x status
         staa  fdcstatusave             and save it
         jmp   [nmipointer]



firqentry      jmp                     [firqpointer]

irqentry jmp   [irqpointer]

swientry jmp   [swipointer]

swi2entry      jmp                     [swi2pointer]

swi3entry      jmp                     [swi3pointer]

resetentry
         lds   #defaultuserstack
         ldx   #$FFC0                    initialize SAM
         staa  $10,x
         staa  $12,x
         staa  $14,x
         staa  $15,x                      set sam to page 1
         staa  $16,x
         staa  $18,x
         staa  $1A,x
         staa  $1D,x
         staa  5,x
         staa  3,x
         ldaa  #%00000001                set map bit
         staa  viaorb                     select our ram
         staa  viaddrb
         clr   fdccontrol
         clr   fdccontrolsave
         clr   currentdrive
         jmp   debug
         page  Memory Bank Selection




;        Bank selection routine

selectbank0
         ldaa  viaorb
         anda  #%11111110
         staa  $FFD4                     set sam to bank 0
         staa  viaorb
         rts


selectbank1
         ldaa  viaorb
         oraa  #%00000001
         staa  $FFD5                     select sam bank 1
         staa  viaorb
         rts
         page  Disk I/O Routines





getdriveready
         ldaa  #$d0                      get 179x's attention
         staa  fdccommand
         bsr   getdrivenotbusy
         ldx   #$2000
getdriveready2
         ldaa  fdcstatus
         bita  #%00000010               get index=1
         bne   getdriveready3
         dex
         beq   getdrivereadytimeout
         bra   getdriveready2
getdriveready3
         ldaa  fdcstatus                get index=0
         bita  #%00000010
         beq   getdrivereadyexit
         dex
         bne   getdriveready3
getdrivereadytimeout
         sec
         rts
getdrivereadyexit
         clc
         rts
selectdrive
         ldab  currentdrive
         ldaa  fdccontrolsave
         ldx   #drivemasktable
         anda  #%10101000               mask out drive bits
         oraa  b,x                       set drive select bit
         tfr   a,b
         oraa  #%00001000               set motor enable bit
         staa  fdccontrol               select disk
         staa  fdccontrolsave           save new control byte
         bitb  #%00001000               was motor already on?
         beq   delayonesecond           b/ yup
         rts

restoredrive
         ldab  fdccontrolsave
         andb  #%01001111               set new control word
         stab  fdccontrolsave
         bsr   selectdrive              select drive
         bsr   getdriveready
         ldaa  #$0b                      do a restore without verify
         staa  fdccommand
         bsr   getdrivenotbusy
         bita  #%00010000               errors?
         bne   restoreerror             b/ yup
         bita  #%00000100               track 0 from drive?
         beq   restoreerror             b/ no!  error out
         clr   currentcyl
         clc                             c=0 for no errors
         rts
restoreerror
         sec
         rts


delayonesecond
         ldab  #4
delayonesecond2
         ldx   #31251                   set 1/4 second timeout
delayoneloop
         dex
         bne   delayoneloop
         decb
         bne   delayonesecond2
         rts

getdrivenotbusy
         exg   a,a                      delay
         exg   a,a
getdrivenotbusy2
         ldaa  fdcstatus
         lsra
         bcs   getdrivenotbusy2
         rola
         rts


seek
         ldaa  fdccontrolsave           turn off control junk
         anda  #%01001111
         staa  fdccontrolsave
         bsr   selectdrive
         ldaa  currentcyl
         staa  fdcdata                   tell 179X where to go
         ldaa  #$18                      set seek without verify
         oraa  bootsteprate
         staa  fdccommand
         bsr   getdrivenotbusy
         bita  #%00010000               any errors?
         bne   seekerror
         clc
         rts
seekerror
         ldab  #$FF
         stab  fdctrack
         sec
         rts


readsector
         ldaa  fdctrack
         cmpa  currentcyl               need to seek?
         beq   readsector2
         bsr   seek
         bcs   readerrorexit
readsector2
         pshs  cc                        save a copy or user's irq flags
         orcc  #%01010000               no irq's please
         ldaa  currentsector            tell 179X which sector
         staa  fdcsector
         ldab  #$80                      179X read command ==> B
         ldaa  fdccontrolsave           set up fdc control reg.
         oraa  #%10100000
         ldx   #readdone                set nmipointer
         stx   nmipointer
         ldx   diskloadaddress          get read buffer pointer
         staa  fdccontrolsave           save fdc control byte
         stab  fdccommand               tell the 179X about it
         staa  fdccontrol               halt goes low here 
         nop                             to make sure the halt happens first

;        the first drq from the 179X releases halt

readsectorloop
         ldab  fdcdata                   grab the data ( Halt goes low here )

;        the procssor is halted here as a result of drq being inactive
;        drq becomming active removes halt and allows processing to resume
;        approximate time between drq active and halt ( time to store b and then
;        read the fdc data ) is 19 micro seconds

         stab  ,x+                       drq causes execution to resume here
         bra   readsectorloop

readdone
         leas  12,s                      fix the stack pointer
         ldx   #diskirqunexpected      and the nmi pointer
         stx   nmipointer
         puls  cc                        get users cc back
         ldaa  fdcstatusave             get returned status
         bita  #%00011100               any errors?
         bne   readerrorexit            b/ yup!
         clc
         rts

readerrorexit
         sec
         rts



;        Check error routine

checkerror
         bcc   checkerrorexit
         jsr   breakpoint
         sec
         rts
checkerrorexit
         clc
         rts

drivemasktable fcb                     1,2,4,$40
         page  Prom Boot Routine




boot
         clra
         tfr   a,dp
         ldx   #$100                     initialize boot params
         stx   diskloadaddress
         ldd   #nbps
         std   sectorlength
         ldd   #readsector
         std   readsectorpointer
         ldd   #checkerror
         std   checkerrorpointer
         ldaa  #nspt
         staa  bootnspt
         ldaa  #1
         staa  bootntpc
         staa  bootsectororg
         ldaa  #3
         staa  bootsteprate
         clr   currentdrive
         clr   currenttrack
         ldaa  bootsectororg
         staa  currentsector
         ldx   #fdmap
boot1
         clr   ,x+
         cpx   #fdmap+26
         bne   boot1
         jsr   restoredrive
         bcc   boot2
         bra   booterror
boot2
         jsr   readsector
         bcs   booterror
         jmp   $100

booterror
         jsr   breakpoint
         bra   boot



promleft equ   iopage-*
         page  6809 Vectors




         org   $FFF2

         fdb   swi3entry
         fdb   swi2entry
         fdb   firqentry
         fdb   irqentry
         fdb   swientry
         fdb   nmientry
         fdb   resetentry

         FIN   STANDARDCOLORCOMPUTER

         end   DEBUG

