         TITLE   IDB FOR 6809 *** (C) 1982 SOFTWARE DYNAMICS ***
;        Edit date:                    8/16/83
;        Edit time:                    15:44
*
*       CONFIGURATION
*
        IFUND   USESWIFORBREAKPOINT
USESWIFORBREAKPOINT EQU 1
        FIN

        IFUND   NARROWDISPLAY
NARROWDISPLAY   EQU     0
        FIN

        ifund   idb09code
idb09code    equ     $f800
        fin

        ifund   idb09ram
idb09ram equ     $F700
        fin     idb09ram
        page    Standard IDB09 Definitions

;       REGISTER DISPLACEMENTS INTO THE STACK
;       ASSUMING USER'S (S) IS IN (X)

        ORG     0
CCREG   RMB     1       condition code
AREG    RMB     1       A register
BREG    RMB     1       B register
DPREG   RMB     1       Direct Page register
XREG    RMB     2       X register
YREG    RMB     2       Y register
UREG    RMB     2       user stack pointer (U register)
PREG    RMB     2       program counter

;       RAM STORAGE NEEDED BY DEBUG
        ORG     idb09RAM ; define page zero offsets
        setdpr  idb09RAM
        RMB     30              30 BYTES OF STACK FOR THE USER
defaultusercontextblock ; use this if not overridden by INITZ
        RMB     12              ONE STACK FRAME (Default User's frame)
USRSTK  RMB     2               USER'S STACK POINTER (HIS S)
USRPC   RMB     2               USER'S PC
OURSTK  RMB     2               OUR STACK
*
PARMF   EQU     $80             'PARAMETER GIVEN' FLAG
FIRST   RMB     5               FIRST PARAMETER
INTSAV  EQU     FIRST           USER'S INTERRUPT STATE
FSTSIZ  RMB     1               # OF BYTES IN FIRST PARAMETER
SECOND  RMB     5               SECOND PARAMETER
SECSIZ  RMB     1               # OF BYTES IN SECOND PARAMETER

NXDLOC  RMB     2               NEXT LOCATION TO DISPLAY
NUMBER  RMB     2               POINTER TO THE NUMBER ENTERED (GNUM)
TMPBYTE RMB     2               SCRATCH SPACE
TMPWORD RMB     2               SCRATCH SPACE
CKSUM   EQU     FIRST           CHECKSUM ACCUMULATOR
OPNLOC  RMB     2               LAST OPENED LOCATION
OPNFLG  RMB     1               FLAG INDICATING VALIDITY OF OPNLOC

BRKLOC  RMB     2               PLACE WHERE BREAKPOINT SET, BRKSAV --> NONE
        IF      USESWIFORBREAKPOINT
BRKSAV  RMB     1               HOLDS BYTE WHERE BREAKPOINT IS SET
        ELSE
BRKSAV  RMB     3               HOLDS DATA WHERE BREAKPOINT IS SET
        FIN

        RMB     20              stack space used by debugger
STACKE  RMB     0               END OF STACK
debugramhighest equ *

debugramsize  equ debugramhighest-IDB09RAM
        if      (debugramhighest&$FF00)#(idb09ram&$FF00)
        ?IDB09 ram doesn't all fit within one page?
        fin
         page  Misc. Definitions

;       CHARACTER DEFINITIONS

NULL    EQU     $0
BELL    EQU     7
CR      EQU     $D
LF      EQU     $A
FF      EQU     $C
DC0     EQU     $10             DEVICE CONTROL CODES
DC1     EQU     $11
DC2     EQU     $12
DC3     EQU     $13
escape   equ   $1B
EQUAL   EQU     $3D
SLASH   EQU     $2F
BANG    EQU     $21
QMARK   EQU     $3F
DBLQUOTE EQU    '"
COLON   EQU     $3A
SEMIC   EQU     $3B
PLUS    EQU     $2B
MINUS   EQU     $2D
BKSLSH  EQU     $5C
UPARW   EQU     $5E
COMMA   EQU     $2C
SPACE   EQU     $20
PERIOD  EQU     $2E
QUOTE   EQU     $27
A       EQU     $41
C       EQU     $43
F       EQU     $46
G       EQU     $47
H       EQU     $48
K       EQU     $4B
L       EQU     $4C
M       EQU     $4D
O       EQU     $4F
P       EQU     $50
R       EQU     $52
S       EQU     $53
T       EQU     $54
U       EQU     'U
LETRX   EQU     $58
LETRA   EQU     $41
LETRB   EQU     $42
Z       EQU     $5A
ZERO    EQU     $30
NINE    EQU     $39

;       ODDBALL DEFS

TRUE    EQU     $FF             FLAG 'ON'
FALSE   EQU     $0              FLAG 'OFF'
         page  Standard IDB09 Code
        ORG     IDB09CODE

RUNAWY  NOP                     RUNAWAY PROGRAM ENTERS HERE
        NOP                     SYNCHRONIZE PC EVEN IF 5 BYTE OPCODE
        NOP                     PRECEDES THIS
        NOP
DEBUG   JMP     DBUG            DEBUG RESTART POINT

breakpoint ; come here when breakpoint encountered
        jmp     breakpointentry entered via JSR or SWI only!

NMIH    JMP     REENTER         NMI ENTRY POINT

GETC    RMB     3
PUTC    RMB     3
PSTR    RMB     3
OPENL   RMB     3
GETL    RMB     3
CLOSEL  RMB     3
INITZ   RMB     3

INTRTI  RTI

breakpointentry
        IF      USESWIFORBREAKPOINT
* context block already pushed, we need do nothing
         ldd   preg,s                  entered via SWI, back up PC
         subd  #1
         std   preg,s
        ELSE
         pshs  a,b,cc,dp,u,x,y         push balance of context block
         ldd   preg,s                  entered via JSR, back up PC
         subd  #3
         std   preg,s
        fin
        LDU     #BRKMSG
REENTER BSR     REENTERSETUP
        STS     USRSTK                 COME HERE FOR ALL INTS BUT RESET
        LDS     #STACKE
        LDU     #INTMSG
        BSR     PSTR
        JSR     REMOVEBREAKPOINT       RESTORE ORIGINAL CODE
        JSR     RDUMP
        JMP     CLROPNFLG
REENTERSETUP
        ORCC    #%01010000             SET f & i just like real nmi
        LDA     #IDB09RAM/256
        TFR     A,DP
        RTS
        PAGE
*
*       MAIN DEBUG ENTRY POINT (ENTERED HERE BY RESTART)
*
DBUG    BSR     REENTERSETUP
        LDS     #STACKE
        LDX     #BRKSAV         = pointer to a don't care location in ram
        STX     BRKLOC          ==> "No breakpoint set"
        CLR     OPNFLG          mark "No cell open"
        LDX     #DEFAULTUSERCONTEXTBLOCK
        BSR     INITZ           INITIALIZE THE WORLD
        ; Note: when INITZ is called, the debugger is completely set up.
        ; This allows INITZ to simply not return if it wishes to start
        ; some other activity, such as Booting the computer, etc., and
        ; still retain the ability to re-enter IDB via SWI and get a register
        ; dump, and proceed as though the debugger had started normally.
        STX     USRSTK          INITZ sets up user context block
HELLO   LDU     #GOMSG
GOLUP   BSR     PSTR            PRINT (X) -> ASCIIZ(STRING)
        BRA     CLROPNFLG

ERROR   BSR     REENTERSETUP
        LDU     #EHMSG
        BRA     GOLUP
        PAGE
CLROPNFLG
        JSR     CRLF            TO END PRINT-OUT PRETTILY
        CLR     OPNFLG          YOU GUESS!
COMAND
        LDX     #FIRST          GET FIRST PARAMETER
        JSR     GNUM            GET A NUMBER TO (X)
COM1    LDX     #OPTBL          NO, ZERO OR ONE PARAMETERS
COMLUP  TST     0,X             HIT END OF TABLE?
        BEQ     ERROR           YEP, COMMAND IS NO GOOD
        CMPA    0,X             NO, FOUND MATCHING COMMAND?
        BEQ     JMPX            YES, JUMP TO ROUTINE
        LEAX    3,X             BUMP X TO NEXT TABLE ENTRY
        BRA     COMLUP          CHECK FOR MATCH

JMPX    LDD     FIRST+3         sheesh!  some commands want SERVICE!
        JSR     [1,X]           AND GO TO ROUTINE
        BRA     COMAND
*
GOMSG   FCB     CR,LF,BELL
        FCC     "IDB09 (C) 1983 Software Dynamics"
        FCB     0       EOS MARKER

EHMSG   FCB     '?,'?,BELL,0

INTMSG  FCB     CR,LF,bell,'I,'N,'T,0
brkmsg   fcb   cr,lf,bell,'B,'r,'k,0
        PAGE
OPTBL   FCB     LF              EX NEXT
        FDB     EXNX
        FCB     LF+PARMF        DEPOSIT AND EXAMINE NEXT
        FDB     STEXNX
        FCB     CR              NOP (CLOSE'OPEN' LOC)
        FDB     CLOSE
        FCB     CR+PARMF        DEPOSIT AND CLOSE CELL
        FDB     DEPOSC
        FCB     SLASH+PARMF     EXAMINE MEMORY
        FDB     EXAMM
        FCB     UPARW           EXAMINE PREVIOUS
        FDB     EXPREV
        FCB     UPARW+PARMF     DEPOSIT THIS AND EXAMINE
        FDB     DEPEXP
        FCB     L               LOAD MIKBUG THROUGH LOAD ACIA
        FDB     LOADL1
        FCB     G               GO TO PC ON STACK
        FDB     GO
        FCB     G+PARMF         GO TO SPECIFIED LOC
        FDB     GO1
        FCB     R+PARMF         COMPUTE BRANCH DISPLACEMENT
        FDB     BRANCHDISP
        FCB     SEMIC+PARMF     DEPOSIT IN REGISTER
        FDB     RSTORE
        FCB     QMARK           REGISTER DUMP
        FDB     RDUMP
        FCB     '!+PARMF        SET BREAKPOINT
        FDB     SETBREAKPOINT
        FCB     'X+PARMF        EXECUTE UNTIL ADDRESS HIT
        FDB     EXECUTEUNTILADDRESS
        FCB     0               END OF LIST
        PAGE
EXNX    LDAA    #CR             EXAMINE NEXT
        JSR     PUTCHAR
        LDAA    #NULL
        JSR     PUTCHAR
        TST     OPNFLG
        BEQ     JERR1
        LDX     NXDLOC
EXNX2   STX     OPNLOC
EXNX3   LDX     OPNLOC
        JSR     PNUMX
EXNX4   LDAA    #SLASH
        JSR     PUTCHAR
        BRA     EXAM1
*
EXAMM   STD     OPNLOC          EXAMINE MEMORY

        LDAA    #TRUE
        STAA    OPNFLG
EXAM1   BSR     JTSP1
        LDAA    #1
EXAM2   LDX     OPNLOC          SET UP DISPLAY BYTE COUNT
        STX     NXDLOC          NEXT LOCATION TO EXAMINE...
EXAM3   STAA    TMPBYTE         = LAST LOCATION DISPLAYED + 1
        BNE     EXAML           B/ NONZERO DISPLAY BYTE COUNT
        LDAA    #QMARK          ILLEGAL OPCODE, SHOW "?XX"
        BSR     JPUTCHAR1
        INC     TMPBYTE         SET DISPLAY COUNT TO ONE
EXAML   LDX     NXDLOC
        LDA     ,X+
        STX     NXDLOC
        JSR     PNUMA
        DEC     TMPBYTE
        BNE     EXAML
JTSP1   JMP     TSP
JERR1   JMP     ERROR
        PAGE
STEXNX  LDAA    #CR             DEPOSIT THIS AND EXAMINE NEXT
        BSR     JPUTCHAR1
        LDAA    #NULL
        BSR     JPUTCHAR1
        BSR     DEPOSIT         DO THE DEPOSIT
        BRA     EXNX2
*
DEPOSIT TST     OPNFLG          DEPOSIT INTO OPNLOC
        LBEQ    ERROR           B/ NOT OPEN
        LDB     FSTSIZ          get significance
        LDY     #FSTSIZ
        LDX     OPNLOC          GET OPEN LOCATION ADDRESS
        LEAX    B,X
        NEGB
DEPOSIT.1
        LDA     B,Y
        STA     B,X
        INCB
        BNE     DEPOSIT.1
        RTS
        PAGE
DEPOSC  BSR     DEPOSIT
CLOSE   LDAA    #LF             CLOSE THE OPEN CELL
        CLR     OPNFLG
JPUTCHAR1
        JMP     PUTCHAR

DEPEXP  BSR     DEPOSIT         DEPOSIT THIS, EXAMINE PREVIOUS
EXPREV  TST     OPNFLG          EXAMINE PREVIOUS
        BEQ     JERR1
        JSR     CRLF
        LDX     OPNLOC
        DEX
        JMP     EXNX2
*
PRVAL1  JSR     GCFOLD          GET TERMINATOR FOR VALUE
        ORAA    #$80
        LEAS    2,S
        JMP     COM1

BRANCHDISP      ; COMPUTE BRANCH DISPLACEMENT BYTE
        TST     OPNFLG          = (A,B)-(.+1)
        BEQ     JERR5           B/ NOT EXAMINING A PLACE !?
        SEC                     THIS DOES THE -1 PART OF -(.+1)
        SBCB    OPNLOC+1
        SBCA    OPNLOC
        STAB    FIRST+2
        ROLB                    BRANCH OUT OF RANGE ?
        ADCA    #0              (A)=SIGN(B) ?
        BNE     JERR5           B/ TOO FAR, SCREW YOU!
        INCA                    INVENT SIGNIFICANCE OF "1"
        STAA    FSTSIZ
        BRA     PRVAL1
        PAGE
LOADL1  JSR     GETL            LOOK FOR LEADING "S" CODE...
        CMPA    #S
        BNE     LOADL1
        JSR     GETL            GET BLOCK TYPE
        CMPA    #NINE
        BEQ     LOADX
        CMPA    #ZERO+1         DATA BLOCK?
        BNE     LOADL1          NO, IGNORE
        CLR     CKSUM           ZERO THE CHECKSUM
        BSR     LBYTE           GET BYTE COUNT+2 (FOR ADDRESS)
        SUBA    #2
        STAA    TMPBYTE         SAVE NUMBER OF BYTES TO LOAD
        BSR     LBYTE
        STAA    OPNLOC          FORM ADDRESS
        BSR     LBYTE
        STAA    OPNLOC+1
        LDX     OPNLOC
        STX     FIRST+1
LOADB   BSR     LBYTE           FETCH NEXT DATA BYTE
        DEC     TMPBYTE         ALL DATA BYTES LOADED ?
        BEQ     LOADD           YES, GO CHECK CHECKSUM
        LDX     OPNLOC          GET STORE ADDRESS
        STA     ,X+             STORE THE BYTE
        STX     OPNLOC          BUMP THE STORE POINTER
        BRA     LOADB
*
LOADD   INC     CKSUM           CHECKSUM OK?
        BEQ     LOADL1          YES, GO LOOK FOR ANOTHER RECORD
LDERR   BSR     TSP             NO, YELL AND SCREAM AND SHOUT!
        LDX     FIRST+1
        BSR     PNUMX
JERR5   JMP     ERROR
        PAGE
LBYTE   BSR     LNIBBLE LOAD 1ST NIBBLE
        BSR     LNIBBLE AND THEN SECOND NIBBLE
CKSUMA  TAB             ADD (A) TO CHECKSUM WITHOUT DISTURBING (A)
        ADDB    CKSUM
        STAB    CKSUM
        RTS

LNIBBLE EQU     *       LOAD NIBBLE, COMBINE WITH (A)
        ASLA            SHIFT OLD (A) LEFT 4 PLACES TO MAKE ROOM FOR NEW NIBBLE
        ASLA
        ASLA
        ASLA
        PSHA
        JSR     GETL    READ LOAD BYTE
        JSR     ISHEXDIG        A HEX DIGIT ?
        BCS     LDERR   B/ NO, CROAK DIE
        ADDA    ,S+     YES, COMBINE WITH LEFT SHIFTED NIBBLE
        RTS

LOADX   BSR     TSP
        LDX     OPNLOC
        DEX
        BSR     PNUMX   PRINT OUT LAST LOC'N LOADED AND FALL THROUGH

CRLF    LDA     #CR             DO A CARRIAGE RETURN, LINE FEED
        JSR     PUTCHAR
        LDA     #LF             ECHO LINE FEED
        JMP     PUTCHAR

TSP     LDA     #SPACE          TYPE A SPACE
        JMP     PUTCHAR
        PAGE
*
*       PNUMX ---- PRINT NUMBER IN X
*       ASSUMED TO HAVE 4 DIGITS
*
PNUMX   LDAB    #4              PRINT 2 BYTE VALUE IN X
PNUMV   STX     NUMBER          PRINT A VARIABLE # BYTES
        BRA     PNUML
*
*       PNUMA --- PRINT NUMBER IN A
*       ASSUMED TO BE ONE BYTE
*
PNUMA   STAA    NUMBER          STORE VALUE
        LDAB    #2              # DIGITS TO PRINT
PNUML   LDAA    #ZERO/16                THIS REALLY ISN'T MAGIC
        PSHB            SAVE # DIGITS TO PRINT
        LDAB    #4      GET BIT SHIFT COUNT
PNUM2   ASL     NUMBER+1                SHIFT MSB INTO A
        ROL     NUMBER
        ROLA
        DECB            DOWN COUNT BIT SHIFT
        BNE     PNUM2   B/ MORE BITS TO SHIFT
        CMPA    #NINE           > DECIMAL 9?
        BLS     PNUM1           NO, GO PRINT IT...
        ADDA    #LETRA-ZERO-10          YES, CONVERT TO A-F
PNUM1   JSR     PUTCHAR         DISPLAY DIGIT
        PULB            GET DIGIT DISPLAY COUNT BACK
        DECB                    DOWN COUNT # OF DIGITS TO PRINT
        BNE     PNUML           LOOP TILL ALL PRINTED
        RTS                     THEN EXIT
        PAGE
*
*       ISHEXDIG -- CHECKS TO SEE IF (A) IS A HEX DIGIT
*       RETURNS CARRY RESET IF YES, DIGIT CONVERTED TO BINARY
*       CARRY SET IF NO, CHARACTER UNDISTURBED
*
ISHEXDIG
        CMPA    #NINE
        BLS     IS0TO9
        CMPA    #G
        BCS     ISATOF
ISDNO   ORCC    #1
        RTS

IS0TO9  CMPA    #ZERO
        BCS     ISDNO
        SUBA    #ZERO
        RTS

ISATOF  CMPA    #LETRA
        BCS     ISDNO
        SUBA    #LETRA-$A
        RTS
        PAGE
*       GNUM -- GET NUMBER TO ( X..X+4 )
*       RETURNS TERMINATOR IN A
*       NUMBER SIZE ('0'..'4' BYTES) IN (B), (X+5)
*
GNUM    STX     NUMBER          SAVE POINTER TO NUMBER BUFFER
        CLR     5,X             SET NUMBER DIGITS RECEIVED
        CLR     0,X             SET VALUE TO ZERO
        CLR     1,X
        CLR     2,X
        CLR     3,X
        CLR     4,X
GNUML   BSR     GCFOLD          GET NEXT CHARACTER
        BSR     ISHEXDIG        IS IT A DIGIT?
        LDX     NUMBER          GET POINTER TO VALUE BUFFER
        BCS     GNUMX           B/ WE'RE DONE
        INC     5,X             YES, BUMP DIGIT COUNT
        LDAB    #4              # BITS TO SHIFT FOR ONE HEX DIGIT
GNUMS   ASL     4,X             SHIFT COLLECTED VALUE...
        ROL     3,X             LEFT ONE HEX DIGIT
        ROL     2,X
        ROL     1,X
        ROL     0,X
        DECB                    DOWN COUNT SHIFT DISTANCE
        BNE     GNUMS
        ADDA    4,X             ADD NEW DIGIT TO OLD VALUE
        STAA    4,X
        BRA     GNUML           GO GET ANOTHER DIGIT
        PAGE
GNUMX   LDAB    5,X             ANY DIGITS ENTERED?
        BNE     GNUMR           YES, NOT REFERENCE TO LOCATION
        CMPA    #QUOTE          SINGLE QUOTE?
        BEQ     GNUMQ           YES, MUST BE A CHARACTER VALUE
        CMPA    #PERIOD         IS TERMINATOR THE SPECIAL DOT ?
        BNE     GNUMP           NO, GO TRY FOR PC VALUE
        LDD     OPNLOC          GET VALUE OF LAST LOCATION OPENED
GNUMV   LDX     NUMBER          GET POINTER TO NUMBER BUFFER
        STD     3,X             STORE THE VALUE IN (A,B)
        BSR     GCFOLD          GET THE TERMINATOR CHARACTER
        LDAB    #2              USE LOCATION COUNTER SIZE = 2
        BRA     GNUM1           TAG THE OPERATOR AS MONADIC
*
GNUMP   CMPA    #'*             REFERENCE TO LAST PC VALUE ?
        BNE     GNUMR           B/ NO, GO ROUND DIGIT COUNT TO BYTE SIGNIFICANCE
        LDX     USRSTK          GET POINTER TO USER'S STACK
        LDD     PREG,X          USE USER'S PC AS VALUE
        BRA     GNUMV

GNUMR   ASRB                    ROUND B FROM DIGITS...
        ADCB    #0              TO NIBBLES
        BEQ     GNUMZ
        CMPB    #5
        BHI     JERR6           # BYTES MUST BE <= 5
GNUM1   ORAA    #$80            TAG THE OPERATOR AS MONADIC
GNUMZ   LDX     NUMBER          GRAB POINTER TO THE VALUE
        STAB    5,X             STORE THE SIGNIFICANCE INTO THE VALUE
        RTS

JERR6   JMP     ERROR
GNUMQ   BSR     GCECHO          THIS IS THE VALUE
        LDX     NUMBER          GET POINTER TO VALUE
        STAA    4,X             STORE QUOTED CHARACTER INTO VALUE
        BSR     GCFOLD          GET THE TERMINATOR
        LDAB    #1              SET VALUE PRECISION
        BRA     GNUM1           GO MARK AS MONADIC AND EXIT
        PAGE
*
*       GCFOLD -- GET CHARACTER AND FOLD LOWER INTO UPPER CASE
*
GCFOLD  EQU     *
        BSR     GCECHO  GET A CHARACTER AND ECHO IT
        CMPA    #$61-1  LOWER CASE ?
        BLS     GCFOLD1 B/ NO
        CMPA    #$61+'Z-'A      ... ?
        BHI     GCFOLD1
        ANDA    #%01011111      YES, MASK OFF LOWER CASE BIT
GCFOLD1 RTS             AND EXIT
*
GCECHO  EQU     *
        PSHS    X
        JSR     GETC
        JSR     PUTCHAR
        PULS    X
        RTS
*
PUTCHAR PSHS    A,X
        JSR     PUTC
        PULS    A,X
        RTS
        PAGE
*       RSTORE -- DEPOSIT INTO A REGISTER

RSTORE  JSR     GCFOLD          GET REGISTER NAME
        LDX     #RTABLE1
RSTOREL TST     ,X              SEE IF END OF LIST
        LBEQ    ERROR           B/ DIDN'T RECOGNIZE REGISTER NAME
        CMPA    ,X
        BEQ     RSTOREM         B/ MATCH
        LEAX    3,X             NEXT ENTRY
        BRA     RSTOREL

RSTOREM JSR     TSP             PUT OUT A SPACE
        LDB     1,X             SEE IF SIGNIFICANCE IS OK
        CMPB    FSTSIZ
        LBLO    ERROR           B/ TOO MUCH DATA
        LDA     2,X             PICK UP DISPLACEMENT INTO STACK
        BMI     RSTM2           B/ S REGISTER GETS SPECIAL TREATMENT
        LDY     USRSTK          THIS IS WHERE ALL THE REGISTERS ARE
        LEAY    A,Y
RSTM3   LDX     #FIRST+5        THIS IS WHERE THE VALUE IS
RSTM4   LDA     ,-X
        STA     ,-Y
        DECB
        BNE     RSTM4           B/ KEEP GOING UNTIL ALL BYTES TRANSFERRED
        RTS

RSTM2   LDY     #USRSTK+2
        LDX     FIRST+3         ADJUST SUPPLIED STACK BASE
        LEAX    -12,X
        STX     FIRST+3
        BRA     RSTM3
        PAGE
*       DEFINES VALID REGISTER NAMES
*               FIRST COMPONENT: REGISTER NAME
*               SECOND COMPONENT: MAXIMUM ALLOWED BYTES
*               THIRD COMPONENT: DISPLACEMENT IN STACK

RTABLE1 FCB     'C,1,1
        FCB     'A,1,2
        FCB     'B,1,3
        FCB     'D,2,3
        FCB     'Z,1,4
        FCB     'X,2,6
        FCB     'Y,2,8
        FCB     'U,2,10
        FCB     'P,2,12
        FCB     'S,2,255        255 => SPECIAL TREATMENT
        FCB     0               END OF LIST
        PAGE
*
*       RDUMP -- DUMP THE REGISTERS
*
RDUMP   JSR     CRLF
        LDU     USRSTK          THE U STACK IS GONNA MIMIC THE USER'S STACK
        LDY     #RTABLE         THIS DESCRIBES THE FORMAT OF THE DUMP
RDUMP.1 LDA     ,Y+             PRINT REGISTER NAME
        LBEQ    CRLF
        JSR     PUTC
        LDA     #'=
        JSR     PUTC
        LDA     ,Y+
        BNE     RDUMP.2         B/ TWO BYTE NUMBER
        PULU    A
        JSR     PNUMA
        BRA     RDUMP.4
RDUMP.2 PULU    X
        CMPA    #2
        BNE     RDUMP.3
        LEAX    -2,U
RDUMP.3 JSR     PNUMX
RDUMP.4 LDA     #SPACE
        JSR     PUTC
        BRA     RDUMP.1
*
*       RTABLE -- DEFINES THE FORMAT OF THE REGISTER DUMP
*
RTABLE  FCB     'C,0
        FCB     'A,0
        FCB     'B,0
        FCB     'Z,0
        FCB     'X,1
        FCB     'Y,1
        FCB     'U,1
        FCB     'P,1
        FCB     'S,2
        FCB     0
        PAGE
GO1     LDX     USRSTK          SET P AND GO
        STD     PREG,X
GO      JSR     CRLF            SO NEXT OUTPUT LINE IS NOT WITH DEBUG STUFF
        BSR     INSTALLBREAKPOINT
        LDS     USRSTK
        JMP     INTRTI          pass control to user program

EXECUTEUNTILADDRESS ; SET BREAKPOINT AT (D) AND THEN DO A "G"
         BSR    SETBREAKPOINT
         BRA    GO

SETBREAKPOINT ; SET BREAKPOINT AT (D); 0 --> kill breakpoint
         STD   BRKLOC                  MUST CALL INSTALLBREAKPOINT...
         BNE   SETBREAKPOINTRTS        B/ SETTING A BREAKPOINT
         LDD   #BRKSAV                 = "NO BREAKPOINT"
         STD   BRKLOC
SETBREAKPOINTRTS
         jmp   tsp                     SHOW ACTION COMPLETE

REMOVEBREAKPOINT ; REMOVE BREAKPOINT JSR FROM CODE
        IF      USESWIFORBREAKPOINT
        LDA     BRKSAV
        STA     [BRKLOC]
        ELSE
        LDX     BRKLOC                  POINTS TO BRKSAV IF NONE
        LDD     BRKSAV
        STD     ,X
        LDA     BRKSAV+2
        STA     2,X
        FIN
        RTS

INSTALLBREAKPOINT ; SET BREAKPOINT JSR INTO CODE
        IF      USESWIFORBREAKPOINT
        LDA     [BRKLOC]
        STA     BRKSAV
        LDA     #$3F                  SINGLE BYTE SWI OPCODE
        STA     [BRKLOC]
        ELSE
; ITS NOT SMART TO SET A 3 byte BREAKPOINT ON AN INSTRUCTION
; WHICH IS FOLLOWED BY A BRANCH TARGET WITHIN 3 BYTES; CAVEAT EMPTOR!
         LDX   BRKLOC
         LDD   ,X
         STD   BRKSAV
         LDA   2,X
         STA   BRKSAV+2
         LDA   #$BD                    = "JSR" OPCODE
         STA   ,X
         LDD   #BREAKPOINT
         STD   1,X
        fin
         RTS
*
FIRQENTRY
        LEAS    -1,S                   MAKE A HOLE FOR UH
        PSHS    Y,X,DP,D,CC
        LDA     UREG+1,S               GET THE CC
        STU     UREG,S                 SAVE THE U
        ORCC    #$80                   SET E BIT
        STA     CCREG,S                AND THE CC
        JMP     NMIH                   THEN DO NMI
******  END OF STANDARD IDB09 CODE
