#ifndef	lint
static char sccsid[] = "@(#)atalku.c	1.1	02/19/85";
#endif

/*
 * AppleTalk package for UNIX (4.2 BSD).
 *
 * Packets are enclosed by IP/UDP headers, which are handled by the
 * protocol-translating ethernet appletalk gateway.
 *
 * Copyright (C) 1985, Stanford Univ. SUMEX project.
 * May be used but not sold without permission.
 */

/*
 * history
 * 02/16/85	croft	created.
 */


#include <sys/types.h>
#include <sys/uio.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/file.h>

#include <netinet/in.h>

#include <time.h>
#include <signal.h>
#include <stdio.h>
#include <strings.h>
#include <errno.h>
#include <ctype.h>
#include <setjmp.h>

#include <atalk.h>
#include <atalku.h>


struct atpstats {		/* statistics counters */
	int	icount;		/* input packet count */
	int	ocount;		/* output packet count */
				/* input (receive) counters: */
	int	tooshort;	/* packet too short */
	int	badheader;	/* bad packet header fields */
	int	irelease;	/* 'release' count */
	int	irequest;	/* 'request' count */
	int	irexmit;	/* rexmit count */
	int	ibadseq;	/* bad TID sequence */
	int	ibadsrc;	/* bad src address */
} atpstats;


/*
 * Open an atp responding socket.
 */
atpopenres(as, lsoc)
	register struct atpsoc *as;
{
	register int i;

	/* XXX check if lsoc == 0, get dynamic socket num */

	as->lsin.sin_family = AF_INET;
	as->lsin.sin_port = htons(ddp2ipskt(lsoc));
	if ((as->fd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
		return (as->fd);
	/* if ((i = setsockopt(as->fd, SOL_SOCKET, SO_REUSEADDR, 0, 0)) < 0)
		return (i); */
	if ((i = bind(as->fd, (caddr_t)&as->lsin, sizeof (as->lsin), 0)) < 0)
		return (i);
	for (i = 0 ; i < NRES ; i++)	/* clear response cache */
		as->res[i].stamp = 0;
	return (0);
}


/*
 * 'Disconnect' an atp socket.
 */
atpdisconnect(as)
	register struct atpsoc *as;
{
	as->connect = 0;
}


/*
 * Close an atp responding socket.
 */
atpcloseres(as)
	register struct atpsoc *as;
{
	if (as->fd > 0)
		close(as->fd);
	as->fd = as->connect = 0;
}


/*
 * Rebind a socket to a free local socket number in the
 * range beginning at lsoc.
 */
atprebind(as, lsoc)
	register struct atpsoc *as;
{
	register s, i, err;

	if (as->fd <= 0)
		return (EINVAL);
	close(as->fd);
	if ((as->fd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
		return (as->fd);
	s = ddp2ipskt(lsoc);
	for (i = 0 ; i < 128 ; i++,s++,lsoc++) {
		as->lsin.sin_port = htons(s);
		if ((err = bind(as->fd, (caddr_t)&as->lsin, 
		    sizeof (as->lsin), 0)) == 0)
			break;
	}
	if (err == 0)
		return (lsoc);
	else
		return (err);
}


/*
 * Receive next request on this atp responding socket.
 */
atprecreq(as)
	register struct atpsoc *as;
{
	int sinlen;
	register i;
	register struct atpbuf *ab = &as->req;
	static struct timeval tv;
	int ires;
	struct sockaddr_in sin;
	short tid;

again:
	if (as->noblock && select(1, 1<<as->fd, 0, 0, &tv) != 1)
		return (0);
	sinlen = sizeof (sin);
	as->reqlen = recvfrom(as->fd, (caddr_t)ab,
	    sizeof *ab, 0, (caddr_t)&sin, &sinlen);
	if (as->reqlen <= 0)
		goto again;
	/*
	 * We would like to use a real 'connect' call to bind both 
	 * the src and dst ports for this socket.  However the Apple
	 * ATP package is such that it can pick a 'random' src socket
 	 * on each sendrequest.
	 */
	if (as->connect == 0)
		as->fsin = sin;		/* save foreign src addr */
	if (as->connect && sin.sin_addr.s_addr != as->fsin.sin_addr.s_addr) {
		atpstats.ibadsrc++;
		goto again;
	}
	atpstats.icount++;
	/* check valid length and header */
	if (as->reqlen < (sizeof ab->lapddp + atpSize)) {
		atpstats.tooshort++;
		goto again;
	}
	bcopy(&ab->lapddp[lapSize], (caddr_t)&as->reqddp, ddpSize);
	as->reqlen = ntohs(as->reqddp.length) - ddpSize - atpSize;
	if (as->reqddp.type != ddpATP || as->reqlen < 0) {
		atpstats.badheader++;
		goto again;
	}
	atptores(as);	/* timeout response cache */
	tid = ntohs(ab->atp.transID);
	for (i = 0 ; i < NRES ; i++)	/* look for this tid in cache */
		if (as->res[i].stamp && as->res[i].tid == tid)
			break;
	ires = i;

	switch (ab->atp.control & (~atpFlagMask)) {
	default:
		atpstats.badheader++;
		goto again;

	case atpReqCode:
		atpstats.irequest++;
		if (ires < NRES) {	/* asking for cache retransmit */
			atpstats.irexmit++;
			atpxres(as, ires);	/* resend what he wants */
			goto again;	
		}
		/* XXX if ((ab->atp.control & atpXO) == 0) return (1); */
		if (as->connect == 0) {
			as->connect = 1;
			as->tid = tid;
			return (1);
		} else {
			/*
			 * If 'oneonly' mode, TIDs must be in sequence;
			 * otherwise the user will do any TID filtering.
			 */
			if (as->oneout == 0)
				return (1);
			if (tid != as->tid+1) {
				atpstats.ibadseq++;
				goto again;
			}
			as->tid = tid;
			return (1);
		}

	case atpRelCode:
		atpstats.irelease++;
		if (ires >= NRES)
			goto again;	/* not in cache */
		as->res[i].stamp = 0;	/* free cache entry */
		goto again;
	}
}


/*
 * Transmit response 'ires' from the response cache.
 */
atpxres(as, ires)
	register struct atpsoc *as;
{
	register struct atpres *ar = &as->res[ires];
	register i;
	register struct atpbuf *abr = &as->req;
	struct atpbuf abw;
	struct iovec iov[2];
	struct DDP ddp;
	long time(), tloc;
	struct msghdr msg;

	time(&tloc);
	ar->stamp = tloc;	/* restart timer */
	/* setup ddp, atp header */
	ddp.checksum = 0;
	ddp.srcNet = as->reqddp.dstNet;
	ddp.dstNet = as->reqddp.srcNet;
	ddp.srcNode = as->reqddp.dstNode;
	ddp.dstNode = as->reqddp.srcNode;
	ddp.srcSkt = as->reqddp.dstSkt;
	ddp.dstSkt = as->reqddp.srcSkt;
	ddp.type = as->reqddp.type;
	abw.atp.transID = abr->atp.transID;
	msg.msg_name = (caddr_t)&as->fsin;
	msg.msg_namelen = sizeof as->fsin;
	as->fsin.sin_port = htons(ddpNWKSUnix);
	msg.msg_iov = &iov[0];
	msg.msg_iovlen = 2;
	msg.msg_accrights = 0;
	msg.msg_accrightslen = 0;
	iov[0].iov_base = (caddr_t)&abw;
	iov[0].iov_len = lapSize + ddpSize + atpSize;
	/*
	 * send each packet requested.
	 */
	for (i = 0 ; i < ar->bdslen ; i++) {
		if ((abr->atp.bitmap & (1 << i)) == 0)
			continue;
		ddp.length = htons(ar->bds[i].buffSize + ddpSize + atpSize);
		bcopy((caddr_t)&ddp, &abw.lapddp[lapSize], ddpSize);
		abw.atp.control = atpRspCode;
		if (i == (ar->bdslen - 1))
			abw.atp.control += atpEOM;
		abw.atp.bitmap = i;
		abw.atp.userData = htonl(ar->bds[i].userData);
		iov[1].iov_base = ar->bds[i].buffPtr;
		iov[1].iov_len = ar->bds[i].buffSize;
		sendmsg(as->fd, &msg, 0);
		/* writev(as->fd, &iov[0], 2); */
		atpstats.ocount++;
	}
}
	

/*
 * Time out response cache.  Return index of cache entry for reuse.
 */
atptores(as)
	register struct atpsoc *as;
{
	register i;
	long time(), tloc;

	time(&tloc);
	for (i = 0 ; i < NRES ; i++)
		if (tloc - as->res[i].stamp > TRES)
			as->res[i].stamp = 0;
	return ((as->tid)&(NRES-1));	/* XXX may not be good enough */
}


/*
 * Send an atp response (to the preceding 'atprecreq' call).
 * This call is stream oriented.  'atpsendresbds' is packet oriented.
 */
atpsendres(as, buf, len, userdata)
	register struct atpsoc *as;
	char *buf;
{
	BDS bds[atpMaxNum], *bp;
	static char nulls[2];
	int nbds;

	if (len <= 0) {
		len = 2;
		buf = nulls;
	}
	bp = &bds[0];
	nbds = 0;
	while (len > 0) {
		bp->buffSize = (len > atpNData ? atpNData : len);
		bp->buffPtr = buf;
		bp->userData = userdata;
		buf += atpNData;
		len -= atpNData;
		bp++;
		nbds++;
	}
	return (atpsendresbds(as, &bds[0], nbds));
}


/*
 * Send an atp response (to the preceding 'atprecreq' call).
 * Arguments point to a vector of BDS structures.
 */
atpsendresbds(as, bp, bdslen)
	register struct atpsoc *as;
	register BDS *bp;
{
	register i;
	register struct atpres *ar;
	int ires;
	register BDS *mybp;
	char *bufp;
	int buflen = sizeof ar->buf;
	long time(), tloc;

	for (i = 0 ; i < atpMaxNum ; i++)	/* count the requested bits */
		if ((as->req.atp.bitmap & (1<<i)) == 0)
			break;
	if (bdslen > i)
		return (-1);	/* too many packets */
	ires = atptores(as);
	ar = &as->res[ires];
	/* copy response into our own buffer */
	ar->stamp = 0;
	mybp = &ar->bds[0];
	ar->tid = as->tid;
	ar->bdslen = bdslen;
	bufp = ar->buf;
	for (i = 0 ; i < bdslen ; i++,bp++,mybp++) {
		mybp->buffSize = bp->buffSize;
		mybp->buffPtr = bufp;
		mybp->userData = bp->userData;
		if (buflen < bp->buffSize)
			return (-1);	/* too big! */
		bcopy(bp->buffPtr, bufp, bp->buffSize);
		bufp += bp->buffSize;
		buflen -= bp->buffSize;
	}
	time(&tloc);
	ar->stamp = tloc;
	atpxres(as, ires);
	return (0);
}		

	
