/*	efs.h	x.x	03/30/85	*/

/*
 * efs definitions
 */

/*
 *  Copyright (c) 1984 by John Seamons, Lucasfilm Ltd.
 *  All rights reserved.
 *
 * history
 * 07/XX/84	jks	created
 * 03/30/85	croft	added appletalk
 */


#define	OUR_FSID	0x1138
#define	DRIVE_SIZE	20480		/* 10 MB */
#define	POST_DELAY	900		/* 15 secs */
#define	RETRY_DELAY	180		/* 3 secs */

#define	min(a,b)	(a<b? a:b)
#define	max(a,b)	(a>b? a:b)
#define	dref(h)		(((int)*(h)) & 0xffffff)

/* scatter/gather data types */
#define	NIL	0
#define	B	1
#define	S	2
#define	L	3
#define	STR	4
#define	ARB	5
#define	P1(a)		(a)
#define	P2(a,b)		(b<<3 | a)
#define	P3(a,b,c)	(c<<6 | b<<3 | a)
#define	P4(a,b,c,d)	(d<<9 | c<<6 | b<<3 | a)

/* packet field sizes */
#define	BSIZE		512+16
#define	HDRSIZE		4
#define	OVERHEAD	10
#define	SAFETY		2
#define	FRAGSIZE	(BSIZE - HDRSIZE - OVERHEAD - SAFETY)

/*
 *  Packet buffer layout.  Warning: structure fields must align the
 *  same way even when compiled on machines with different field alignments.
 *  Don't place a long on anything but a 32-bit boundary (etc.).
 */
struct netBuf {
	unsigned char	n_cmd;
	unsigned char	n_xxx;
	short		n_dlen;
	union {
		unsigned char	n_data[BSIZE-HDRSIZE];
		short		n_flNum;
		char		n_fname[1];
		short		n_dirIndex;
		struct {
			short	n_numFiles;
			char	n_len;
			char	n_volname[1];
		} n_mountVol;
		struct {
			char	n_perm;
			char	n_fname[1];
		} n_open;
		struct {
			long	n_size;
			long	n_flNum;
			long	n_fd;
		} n_oreply;
		struct {
			long	n_reqCount;
			long	n_mark;
			short	n_flNum;
			short	n_posMode;
		} n_read;
		struct {
			long	n_actCount;
			char	n_buf[1];
		} n_rreply;
		struct {
			long	n_reqCount;
			long	n_mark;
			short	n_flNum;
			char	n_buf[1];
		} n_write;
		struct {
			long	n_actCount;
		} n_wreply;
		struct {
			fileDirectory	n_FDir;
			char		n_len;
			char		n_name[1];
		} n_gfi;
	} n_un;
};

int efserr, efscmd;

#define	EFSSOCKET	35	/* server socket number (should use
				   NBP instead) */
#define	PROTOCOL	3	/* protocol number */
#define	VERSION		1	/* version number */

#define	OPACK		1	/* acknowledge bit (or'ed into opcode) */
#define	OP(n)		((PROTOCOL << 12) | (VERSION << 8) | n )
#define	OPMASK		0xFFFF	/* opcode mask */

/* opcodes in userData */
#define	OPNEW		OP(2)	/* new user */
#define	OPNORM		OP(4)	/* normal transaction */
#define	OPERROR		OP(10)	/* error reply */

#define	SEPCHAR		'|'	/* field separator character */
#define	IDLETO		(60*60*24*2)	/* idle timeout (2 days) */

#define	MACSBUG

#ifdef MACSBUG	/* !!! WARNING! You must have a 'return' before this. */
#define SYM(x) { short foo; \
   asm("unlk a6");asm("rts");asm(".asciz 'x'");asm(".even");}
#else
#define SYM(x)
#endif

