/*	efsinit.c	x.x	03/30/85	*/

/*
 * External file system initialization.
 */

/*
 *  Copyright (c) 1984 by John Seamons, Lucasfilm Ltd.
 *  All rights reserved.
 *
 * history
 * 07/XX/84	jks	created.
 * 03/30/85	croft	added host dialog, alerts, ...
 */

#include <sys/types.h>		/* u_short, etc. */
#include <mac/quickdraw.h>
#include <mac/toolintf.h>
#include <mac/res.h>
#include "fs.h"
#include "efs.h"
#define	MAC	1
#include "atalk.h"

#define	CntrlParam paramBlk	/* use John's names to avoid hassles */
#define	csParam pb_un.pbIOP.ioMisc

CntrlParam atpb;		/* atalk transaction paramblock */
BDS atbds;			/* buffer data structures */
char atresbuf[64];
char atreqbuf[64];			/* request buffer */
extern int atpTimeOut;		/* ATP request timeout in seconds */
extern int atpRetries;		/* ATP retries before error */
char *linep;

main() {
	struct QDVar QDVar;
	register int err, driveNum = 0;
	register driveQ *dp, *dqp;
	register volCtlBlk *vp, *vqp;
	VBLCtlBlk *vbl;
	Handle handle;
	paramBlk pb;
	struct ATPParam *ap = (struct ATPParam *)&atpb.csParam;

	QD = &QDVar;
	InitGraf(&thePort);
	InitFonts();
	InitWindows();
	InitMenus();
	TEInit();
	InitDialogs((ProcPtr)NIL);
	SetCursor(&QD->arrow);

	if ((err = atalkopen(1)) != noErr)
		efsAlert(atalkerror(err));
	atbds.buffSize = sizeof atresbuf;
	atbds.buffPtr = atresbuf;
	ap->atpNumBufs = 1;
	ap->atpBDS = &atbds;
	ap->atpFlags = atpXO;
	if (namedialog() == 0)
		ExitToShell();
	/* save socket number of forked daemon */
	ap->atpAddrBlock.skt = atresbuf[0];

	/* POKE REMOTE END, GET HOST LIST, QUERY FOR HOST/DIR, CONNECT */

	SetZone (SystemZone());

	/*
	 *  toExtFS is a system global pointing to an external file system.
	 *  The efs driver is the second CODE resource in our resource file
	 *  and is loaded into the system heap because the ATT_SYSHEAP bit
	 *  was specified in efs.rc.  The resource is detached to prevent
	 *  the driver from being removed after efsinit exits.  In order
	 *  for the volume to be mounted a "disk inserted" event must be
	 *  posted while the Finder is running.  The Finder will then
	 *  attempt a MountVol.  Because the Finder flushes all input events
	 *  when it starts up we can't simply post the event here.  Instead
	 *  we set a timer via the vertical retrace manager and post the
	 *  event after efsinit has exited and the Finder is initialized.
	 *  The first call to the efs driver below relocates the driver and
	 *  returns a pointer a routine in the driver which posts the event.
	 */
	if (toExtFS != -1)
		efsAlert("External file system already installed.");
	if (toExtFS == -1) {		/* Inside Mac incorrectly says 0 */
		if ((handle = GetResource ("CODE", 2)) == 0) {
			efsError (ResError());
		}
		DetachResource (handle);
		if ((vbl = (VBLCtlBlk*) NewPtr (sizeof (VBLCtlBlk))) == 0)
			efsError (memFulErr);
		bzero (vbl, sizeof (VBLCtlBlk));
		vbl->vblType = QE_VBLQ;
		vbl->vblAddr = (ProcPtr)
		    (*((ProcPtr)(dref(handle) + sizeof (struct codehead))))();
		/* pass the AddrBlock to the driver */
		bcopy((caddr_t)&ap->atpAddrBlock,
		    (caddr_t)(vbl->vblAddr)+2, 4);
#ifdef DEBUG
		printf ("loaded efs driver: handle 0x%x\n\r", handle);
#endif
	}

	/*
	 *  Link a new entry into the drive queue.  We scan the existing
	 *  drive queue in order to assign a drive number that is not in use.
	 *  Drives 0 and 1 are reserved for Sony drives.  Drive 2 is reserved
	 *  for the RAM disk.  The drive number is placed in a low memory
	 *  global (vblDrive) so the driver routine that posts the
	 *  "disk inserted" event knows which drive to specify.
	 */
	if ((dp = (driveQ*) NewPtr (sizeof (driveQ))) == 0)
		efsError (memFulErr);
	bzero (dp, sizeof (driveQ));
	dqp = (driveQ*) &drvQHdr->qHead;
	do {
		dqp = dqp->dqLink;
		driveNum = max (driveNum, dqp->dqDrive + 1);
	} while (dqp != (driveQ*) drvQHdr->qTail);
	driveNum = max (driveNum, 3);
	dp->dqFSID = OUR_FSID;
	dp->dqDrvSize = DRIVE_SIZE;
	dp->dqType = QE_DRIVEQ;
	AddDrive (0, driveNum, dp);
	vbl->vblCount = POST_DELAY;
	vblDrive = driveNum;
	VInstall (vbl);
}

efsError (code)
{
	char num[20];
	char str[64];

	strcpy(str, "Error number ");
	NumToString(code, num);
	strcat(str, num);
	efsAlert(str);
}

efsAlert(s)
	char *s;
{
	ParamText("EFS initialization", s, "", "");
	CautionAlert(1, (ProcPtr)0);
	ExitToShell();
}

char	user[32];		/* user name */
char	node[32];		/* node name */
char	pass[32];		/* password */

/*
 * Dialog to obtain node name, user name and password.
 * Verify this information with the remote host.
 */
namedialog()
{
	DialogPtr dialp;
	int item;
	Rect box;
	Handle itemH;
	int itemtype;
	register struct ATPParam *ap = (struct ATPParam *)&atpb.csParam;
	register i;

	dialp = GetNewDialog(2, (Ptr)0, (WindowPtr)-1);
dloop:
	for (;;) {
		ModalDialog((ProcPtr)NIL, &item);
		GetDItem(dialp, item, &itemtype, &itemH, &box);
		if (item == OK)
			break;
		switch (itemtype) {
		case ctrlItem+chkCtrl:
		case ctrlItem+radCtrl:
			SetCtlValue(itemH, GetCtlValue(itemH) ? 0 : 1);
		}
	}
	GetDItem(dialp, 2, &itemtype, &itemH, &box);
	GetIText(itemH, node);
	GetDItem(dialp, 3, &itemtype, &itemH, &box);
	GetIText(itemH, user);
	GetDItem(dialp, 4, &itemtype, &itemH, &box);
	GetIText(itemH, pass);
	if (lookupnode(node, &ap->atpAddrBlock) != noErr)
		goto dloop;
	linep = atreqbuf;		/* stuff characters into here */
	catline(user, pass, 0);
	atpTimeOut = 8;		/* # seconds before request timeout */
	atpRetries = 4;
	if ((i = atpsendrequest(&atpb, atreqbuf, linep-atreqbuf, 
	    OPNEW)) != noErr){
		matalert("Remote node not responding. ", i);
		return (0);
	}
	if (atbds.userData == (OPNEW | OPACK))
		goto out;
	matalert(atresbuf, 0);
	return (0);
out:
	DisposDialog(dialp);
	return (1);
}


/*
 * KLUDGE!  Until NBP is implemented, we use this built-in name
 * table (or the user can type 'netnumber,nodenumber').
 */
struct nodetable {
	char	*name;
	short	net;
	short	node;
} nodetable[] = {
	"safe", 44, 1,
	"lindy", 9, 11,
	"argus", 9, 10,
	"diablo", 45, 193,
	"ardvax", 47, 1,
	0, 0, 0
};


/*
 * Lookup a node name and set the net/node/socket fields into
 * the supplied AddrBlock.
 */
lookupnode(s, ab)
	char *s;
	register AddrBlock *ab;
{
	register struct nodetable *ntp;
	short anet,anode;

	/* lookup node name (should be using NBP) */
	for (ntp = &nodetable[0] ; ntp->net ; ntp++)
		if (strcmp(ntp->name, s) == 0)
			break;
	anet = ntp->net;
	anode = ntp->node;
	if (anet == 0) {	/* not found, try number */
		linep = s;	/* start scanning here */
		if ((anet = line2int()) == -1 ||
		    (anode = line2int()) == -1) {
			ParamText("Unknown node name.",
			   "You can also use net, node numbers; e.g.: '44,1'",
			   "", "");
			CautionAlert(1, (ProcPtr)NIL);
			return (-1);
		}
	}
	ab->net = anet;
	ab->node = anode;
	ab->skt = EFSSOCKET;	/* XXX use NBP value instead */
	return (noErr);
}


/*
 * Convert string in *linep to an integer and return that value.
 * 'linep' is updated to point to the next numeric string component.
 * Returns -1 if error.
 */
line2int()
{
	register char *cp = linep;
	register i = 0;
	register t;

	for ( ; *cp >= '0' && *cp <= '9' ; cp++) {
		t = *cp - '0';
		i = (i*10) + t;
	}
	if (cp == linep)
		return (-1);
	while (*cp != 0 && !(*cp >= '0' && *cp <= '9'))
		cp++;
	linep = cp;
	return (i);
}


/*
 * Concatinate string arguments into 'linep' area, separated by
 * SEPCHAR.
 */
catline(sa)
	char *sa;
{
	register char *sp,*dp = linep;
	register char **ap = &sa;

	for ( ; (sp = *ap) ; ap++) {
		while (*dp++ = *sp++);
		dp--;
		*dp++ = SEPCHAR;
	}
	dp--;
	*dp++ = 0;
	linep = dp;
}


/*
 * Report an error string using a CautionAlert and atalk error string.
 */
matalert(s, i)
	char *s;
	int i;		/* atalk error number */
{
	ParamText(s, (i == 0 ? "" : (char *)atalkerror(i)), "", "");
	CautionAlert(1, (ProcPtr)NIL);
}
