		.insrt	"/usr/include/mac/toolmacs.h"
		.insrt	"/usr/include/mac/sysequ.h"
|-----------------------------------------------------------------------------
| from io.s
|-----------------------------------------------------------------------------
|
|function fsread(refnum: integer| var count: longint| buffptr: ptr): oserr|
|
|function fswrite(refnum: integer| var count: longint| buffptr: ptr): oserr|
|
|

		.text
		.globl	_fsread
_fsread:
        .globl  _fswrite

        clrl      d1                      | set up read
        bra   doblk

_fswrite:
        moveq      #1,d1                      | set up write

doblk:
        link     a6,#-ioqelsize         | make room on stack for cmd block
        lea     a6@(-ioqelsize),a0       | address of cmd block

        movl    a6@(8),a0@(iobuffer)      | buffer address
        movw    a6@(16),a0@(iorefnum)     | refnum
        movl    a6@(12),a1               | address of the count
        movl    a1@,a0@(iobytecount)    | read count
        clrw   a0@(ioposmode)           | no special mode
        clrl   a0@(ioposoffset)         | clear offset

        tstb   d1                      | look for read or write
        bne   .L3
        .word	__read
        bra   .L4
.L3:      .word	__write
.L4:
        movw    d0,a6@(18)               | return the result code

        movl    a6@(12),a1               | address of the count
        movl    a0@(ionumdone),a1@      | return count read

        unlk    a6
        movl    sp@+,a1                | return address
        addl   #10,sp                  | fix up stack
        jmp     a1@
|
| function opendriver(drivername: osstr255): integer|
|
|function killio(refnum: integer): oserr|
|

|
|   opendriver opens the driver of a given name, returning its refnum
|
		.text
		.globl	_opendriv
_opendriv:

                movl    sp@(4),a0           |get a pointer to the name
                moveq   #[ioqelsize/2]-1,d0
.L1:              clrw   sp@-
                dbra    d0,.L1

                movl    a0,sp@(iofilename)  |set up name
                movl    sp,a0           |point to it
                .word	__open                   |open the driver
                bne   badopen         |if an error, don't return refnum

                movw    sp@(iorefnum),d0        |get the refnum
doneopen:
                addw     #ioqelsize,sp          |pop off command buffer
                movw    d0,sp@(8)        |return the refnum

                movl    sp@+,sp@      |strip return address
                rts
badopen:
                moveq   #0,d0
                bra   doneopen
|
| procedure adddrive(drvrrefnum: integer| drvnum: integer| qel: drvqelptr)|

		.text
		.globl	_adddrive
_adddrive:
                movl    sp@+,a1        |get return address
                movl    sp@+,a0        |ptr to memory for queue element
                movw    sp@+,d0        |drive number
                swap    d0              |put it in high word
                movw    sp@+,d0        |driver ref num
                .word	__adddrive
                jmp     a1@

|-----------------------------------------------------------------------------
| from misc.s
|-----------------------------------------------------------------------------
|
|function vinstall(vblblockptr: vblcbptr): oserr|
|

		.text
		.globl	_vinstall
_vinstall:

            movl    sp@+,a1                |get the return address
            movl    sp@+,a0                |addr of vertical retrace control blk
            movl    a1,sp@-                |restore return address

            .word	__vinstall
            movw    d0,sp@(4)                |return error

            rts

|
|function vremove(vblblockptr: vblcbptr): oserr|
|

		.text
		.globl	_vremove
_vremove:

            movl    sp@+,a1                |get the return address
            movl    sp@+,a0                |addr of vertical retrace control blk
            movl    a1,sp@-                |restore return address

            .word	__vremove
            movw    d0,sp@(4)                |return error

            rts
|-----------------------------------------------------------------------------
| from mem.s
|-----------------------------------------------------------------------------
|----------------------------------------------------------------------
|
| function getzone: thz|
|
| returns value of thezone
|
| arguments:
|       none
|
| result:
|                       current value of thezone pointer
|
| registers:
|       a1 -            holds return address
|
		.text
		.globl	_getzone
_getzone:

                .word	__getzone                |ask os to do request
                movl    a0,sp@(4)        |_save result
                bra   _save            |set error code and return


|----------------------------------------------------------------------
|
| procedure setzone(hz: thz)|
|
| sets thezone to hz
|
| arguments:
|       hz:             holds new value for thezone
|
| registers:
|       a2 -            holds return address
|
		.text
		.globl	_setzone
_setzone:
|
                movl    sp@+,a1        |get return address
                movl    sp@+,a0        |zone pointer
                .word	__setzone                |ask os to do request
                bra   _savereta1       |save 0 result code and return via a1



|----------------------------------------------------------------------
|
| function appliczone: thz|
|
| returns value of applzone
|
| arguments:
|       none
|
| result:
|                       current value of applzone pointer
|
| registers:
|       a1 -            holds return address
|
		.text
		.globl	_appliczo
_appliczo:

                movl    applzone,sp@(4)
                bra   _save0           |set error code 0 and return



|----------------------------------------------------------------------
|
| function systemzone: thz|
|
| returns value of syszone
|
| arguments:
|       none
|
| result:
|                       current value of syszone pointer
|
| registers:
|       a1 -            holds return address
|
		.text
		.globl	_systemzo
_systemzo:

                movl    syszone,sp@(4)
                bra   _save0           |set error code and return


|----------------------------------------------------------------------
|----------------------------------------------------------------------
|
| function newptr(bytecount: size): ptr|
|
| returns a pointer to a newly allocated non-relocatable block of
| memory bytecount bytes long.
|
| arguments:
|       bytecount:      number of bytes needed
|
| result:
|                       pointer to new block, or nil, if not enough room
|
| registers:
|       a0 - points to new block, or nil
|       a1 - return address
|       d0 - number of bytes needed/error code
|
		.text
		.globl	_newptr
_newptr:

                movl    sp@+,a1        |get return address
                movl    sp@+,d0        |get the byte count
                .word	__newptr                 |ask os to do request
                movl    a0,sp@         |return result ptr on stack
               bra     _savereta1       |save result code and return via a1



|----------------------------------------------------------------------
|
| procedure disposptr(p: ptr)|
|
| releases the block pointed to by p.
|
| arguments:
|       p:              pointer to block to be freed
|
| result:
|       none
|
| registers:
|       a0 - points to block to be freed
|       a1 - return address
|       d0 - error code
|
		.text
		.globl	_dispospt
_dispospt:
|
                movl    sp@+,a1        |get return address
                movl    sp@+,a0        |get parameter
                .word	__disposptr              |let os do work
                bra     _savereta1       |save result code and return via a1



|----------------------------------------------------------------------
|
| procedure blockmove(srcptr, destptr: ptr| bytecount: size)|
|
| marks the relocatable block referred to by h as not purgeable.
|
| arguments:
|       srcptr:         source pointer
|       destptr:        destination pointer
|       bytecount:      bytecount for move
|
| registers:
|       a0 -            source pointer
|       a1 -            destination pointer
|       d0 -            bytecount for move
|       d1 -            holds return address
|
		.text
		.globl	_blockmov
_blockmov:
|
                movl    sp@+,d1        |return address
                movl    sp@+,d0        |byte count
                movl    sp@+,a1        |destination ptr
                movl    sp@+,a0        |source ptr
                .word	__blockmove              |let os to do it.
                movl    d1,a1           |return address
                bra     _savereta1       |save result code and return via a1



|----------------------------------------------------------------------
|----------------------------------------------------------------------
|
| procedures _save, save0, save0reta1, savereta1|
|
| _saves d0 into errorcode. alternately sets d0 to 0 first. alternately returns
| via a1.  a1 is destroyed in any case . . .
|
| arguments:
|       d0:             error code to be _saved in errorcode
|
| result:
|       none
|
| registers:
|       a1 - points to errorcode
|
                .globl    errorcode


errorcode:
               .word   0


_save0reta1:
                moveq   #0,d0          |this entry zeroes result, returns via a1

_savereta1:
                movl    a1,sp@-        |a1 has return address

_save:
                movw    d0,errorcode         |_save error

                rts                     |return

_save0:
                moveq   #0,d0           |this entry zeroes the result
                bra     _save

|
| copy bytes, using movb,movw, or movl as appropriate.
|
	.globl	bcopy
bcopy:	movl	sp@(4),d0
	movl	d0,a0
	movl	d0,d1
	movl	sp@(8),d0
	movl	d0,a1
	orl	d0,d1
	movl	sp@(12),d0
	orl	d0,d1
	btst	#0,d1
	beqs	2$
	subql	#1,d0
1$:	movb	a0@+,a1@+
	dbra	d0,1$
	rts

2$:	btst	#1,d0
	beqs	4$
	asrl	#1,d0
	subql	#1,d0
3$:	movw	a0@+,a1@+
	dbra	d0,3$
	rts

4$:	asrl	#2,d0
	subql	#1,d0
5$:	movl	a0@+,a1@+
	dbra	d0,5$
	rts


|
|function	serhshake(refnum: integer; flags: sershk): oserr;
|
		.text
		.globl	_serhshak
_serhshak:

	link	a6,#-ioqelsize	| make room on stack for cmd block
	lea	a6@(-ioqelsize),a0	| address of cmd block

	movw	a6@(12),a0@(iorefnum)	| refnum
	movw	#10,a0@(cscode)	| code for setting handshake options
	movl	a6@(8),a1	|ptr to flags record
	movl	a1@+,a0@(csparam)	|copy the first 4 bytes
	movl	a1@,a0@(csparam+4)	|copy the second 4 bytes

	.word	__control
	movw	d0,a6@(14)	| return the result code

	unlk	a6
	movl	sp@+,a1	| return address
	addqw	#6,sp	| fix up stack
	jmp	a1@

