/*	net.c	x.x	03/30/85	 */

/*
 * network IO
 */

/*
 *  Copyright (c) 1984 by John Seamons, Lucasfilm Ltd.
 *  All rights reserved.
 *
 * history
 * 07/XX/84	jks	created
 * 03/30/85	croft	added appletalk
 */


#include <sys/types.h>		/* u_short, etc. */
#include <mac/quickdraw.h>
#include <mac/toolintf.h>
#include "fs.h"
#include "efs.h"
#define	MAC	1
#include "atalk.h"

/* icon states */
#define	SAVE	0
#define	RESTORE	1
#define	FLIP	2

#define	CntrlParam paramBlk	/* use John's names to avoid hassles */
#define	csParam pb_un.pbIOP.ioMisc

struct netBuf netIBuf, netOBuf;

int atready = 0;		/* true if atalk initialized */
CntrlParam atpb;		/* atalk transaction paramblock */
BDS atbds[8];			/* buffer data structures */
extern int atpTimeOut;		/* ATP request timeout in seconds */
extern int atpRetries;		/* ATP retries before error */

/* pass a pointer to the arguments on the stack (like printf) */
netIO (params)
unsigned params;
{
	return (netio (&params));
}

netio (params)
unsigned char **params;
{
	unsigned char **iparams;
	register struct netBuf *np;
	register unsigned char *dp;
	register unsigned char *p;
	register unsigned imask = *(int*)params++, omask;
	int len, resid, err;
	extern AddrBlock atAddr;
	
	np = &netOBuf;
	dp = np->n_un.n_data;
	if (atready == 0) {
		struct ATPParam *ap = (struct ATPParam *)&atpb.csParam;
/*		if ((err = atalkopen(1)) != noErr)
			return (err); */
		ap->atpNumBufs = atpsetupbds(atbds, (caddr_t)&netIBuf,
		    sizeof netIBuf, 0);
		ap->atpBDS = atbds;
		bcopy((caddr_t)&atAddr, (caddr_t)&ap->atpAddrBlock, 4);
		ap->atpFlags = atpXO;
		atready = 1;
	}

#ifdef DEBUG
dprintf ("out: ");
#endif
	/* gather up all the data for the outgoing packet */
	while (imask&7) {
		p = *params++;
		switch (imask&7) {
		case STR:
			bcopy (p+1, dp, *p);
			dp += *p;
			*dp++ = 0;
#ifdef DEBUG
			dprintf ("STR <%s> ", dp-*p-1);
#endif
			break;
		case L:
			/* *(long*)dp = htonl ((long)p); */
			*(long*)dp = (long)p;
			dp += sizeof (long);
#ifdef DEBUG
			dprintf ("L 0x%x ", p);
#endif
			break;
		case S:
			/* *(short*)dp = htons ((short)p); */
			*(short*)dp = (short)p;
			dp += sizeof (short);
#ifdef DEBUG
			dprintf ("S 0x%x ", p);
#endif
			break;
		case B:
			err = (int)p;	/* because movb a,a@+ is illegal */
			*dp++ = (unsigned char)err;
#ifdef DEBUG
			dprintf ("B 0x%x ", p);
#endif
			break;
		case ARB:
			len = *(int*)params++;
			bcopy (p, dp, len);
			dp += len;
#ifdef DEBUG
			dprintf ("ARB %d ", len);
#endif
			break;
		}
		imask >>= 3;
	}

	/* set the packet header fields */
	np->n_cmd = efscmd;
	np->n_dlen = dp - np->n_un.n_data;
	efsCursor (SAVE);
	iparams = params;
#ifdef DEBUG
	dprintf ("cmd %d dlen %d ", np->n_cmd, np->n_dlen);
#endif

retry:
	params = iparams;
	np = &netOBuf;
	efsCursor (FLIP);
	len = HDRSIZE + np->n_dlen;
	if ((err = atpsendrequest(&atpb, (caddr_t)np, len, OPNORM)) != noErr){
		SysBeep(1);
		goto retry;
	}

#define netread(buf,size) bcopy(dp, (caddr_t)buf, size); dp += size;

	np = &netIBuf;
	dp = np->n_un.n_data;
	omask = *(int*)params++;
	resid = np->n_dlen;
#ifdef DEBUG
	dprintf ("in: msk 0x%x resid %d ", omask, resid);
#endif
	/* scatter all the data from the incoming packet */
	while (resid > 0 && omask&7) {
		p = *params++;
		switch (omask&7) {
		case ARB:
			len = *(int*)params++;
#ifdef DEBUG
			dprintf ("ARB 0x%x %d ", p, len);
#endif
			netread(p, len);
			break;
		case B:
			len = sizeof (char);
			netread(p, len);
#ifdef DEBUG
			dprintf ("B 0x%x", *p);
#endif
		case S:
			len = sizeof (short);
			netread(p, len);
			/* *(short*)p = ntohs (*(short*)p); */
#ifdef DEBUG
			dprintf ("S 0x%x ", *(short*)p);
#endif
			break;
		case L:
			len = sizeof (long);
			netread(p, len);
			/* *(long*)p = ntohl (*(long*)p); */
#ifdef DEBUG
			dprintf ("L 0x%x ", *(long*)p);
#endif
			break;
		case STR:
			len = 1;
			netread(p, len);
			resid--;
			len = *p++;
			netread(p, len);
			p += len;
			*p = 0;
#ifdef DEBUG
			dprintf ("STR <%s> ", p-len);
#endif
			break;
		}
		resid -= len;
		omask >>= 3;
	}
	if (resid > 0) {
#ifdef DEBUG
		dprintf ("resid %d", resid);
#endif
	}
	efsCursor (RESTORE);
	return (efserr = *(char*)&np->n_cmd);
	SYM(NETIO);
}


/* maintain an icon that tracks the progress of the I/O */
#define CURLOC ((int *)0x7a7b8)
efsCursor (op)
register int op;
{
	register unsigned int i, *ip;
	static unsigned int save[2];
	static unsigned int bit,cell;

	switch (op) {
	case SAVE:
		ip = CURLOC;
		save[0] = *ip;
		ip += 16;
		save[1] = *ip;
		/* fall thru */

	case FLIP:
		i = 1 << (31-bit);
		cell = (cell ^ i);
		ip = CURLOC;
		*ip = cell;
		ip += 16;
		*ip = cell;
		bit = ((bit + 1) & 0x1F);
		break;

	case RESTORE:
		ip = CURLOC;
		*ip = save[0];
		ip += 16;
		*ip = save[1];
		break;
	}
	return;
	SYM(EFSCUR);
}
