/*	atalk.c	1.0	03/15/85	*/

/*
 * AppleTalk C interface routines for Macintosh.
 *
 * (C) 1984, Stanford Univ. SUMEX project.
 * May be used but not sold without permission.
 */

/*
 * history
 * 03/16/85	Croft	Created.
 */


#include <quickdraw.h>
#include <osintf.h>
#include <toolintf.h>

#include <sys/types.h>
#define	MAC	1
#include <atalk.h>


#define	SPConfig	(*(u_char *)0x1FB)	/* sys param config for SCC */
#define	PortBUse	(*(u_char *)0x291)	/* current port B usage */
#define	useMask		0xF			/* use mask for port B */
#define	freeMask	0x80			/* port is free if 'negative'*/
#define	useATalk	0x1			/* use = appletalk */
#define	atpLoaded	0x10			/* bit in PortBUse */


int	atpRefNum = 	-11;	/* atp driver refnum from open */
int	mppRefNum = 	-10;	/* mpp driver refnum */

int	atpRetries =	30;	/* default number of retries */
int	atpTimeOut =	2;	/* default timeout in seconds */
int	atpAsync =	0;	/* default to syncronous IO calls */


/*
 * Open the appletalk drivers.  The argument is true if you want
 * ATP loaded;  otherwise just MPP is loaded.
 * Returns error status (noErr [0] if successful).
 */
atalkopen(loadatp)
{
	IOParam pb;
	register i;

	if ((PortBUse & freeMask)) {	/* if port B free */
		i = (SPConfig & useMask);
		if (i != 0 && i != useATalk)
			return (portNotCf);	/* not ok with config RAM */
		bzero((caddr_t)&pb, sizeof pb);
		pb.ioNamePtr = "\004.MPP";
		if ((i = PBOpen(&pb, 0)) != noErr)
			return (i);
		mppRefNum = pb.ioRefNum;
	} else {			/* port B in use */
		if ((PortBUse & useMask) != useATalk)
			return (portInUse);	/* but not for us */
	}
	if (loadatp == 0)	/* only wanted MPP */
		return (0);
	if ((PortBUse & atpLoaded))
		return (0);	/* we're done, ATP is loaded */
	bzero((caddr_t)&pb, sizeof pb);
	pb.ioNamePtr = "\004.ATP";
	if ((i = PBOpen(&pb, 0)) != noErr)
		return (i);
	atpRefNum = pb.ioRefNum;
	return (0);
}


/*
 * Return an error string corresponding to an appletalk error number.
 * This list doesnt contain all the possible errors;  just the 
 * ones likely to be reported to a human user.
 */
char *
atalkerror(n)
{
	register char *cp;
	static char astr[32];

	switch (n) {
	case portNotCf:
		cp = "port B not configured for atalk in param ram";
		break;

	case portInUse:
		cp = "port B already 'in use'";
		break;

	case excessCollsns:
		cp = "excess collisions";
		break;

	case noBridgeErr:
		cp = "no bridge (no route to net)";
		break;

	case ddpLenErr:
		cp = "DDP length too big";
		break;

	case ddpSktErr:
		cp = "error in socket number";
		break;

	case reqFailed:
		cp = "ATP SendRequest failed: retries exceeded";
		break;

	default:
		sprintf(astr, "error number %d", n);
		cp = astr;
		break;
	}
	return (cp);
}


/*
 * atpsendrequest
 *
 * Before calling, you should one-time setup these fields 
 * in the PB: atpFlags (atpXO, atpSendChk), atpAddrBlock;
 * and these globals: atpRetries, atpTimeOut, atpAsync.
 *
 * Setup atpBDS and atpNumBufs for your receive BDS.
 * 'atpsetupbds()' can help with this.
 *
 * The function return value is the PBControl 'result code'
 * (0 if OK).  If no error occured your return data will be in
 * atpBDS[0 thru atpNumRsp-1].  You can also check the 
 * following fields in the PB: atpFlags (atpEOM), atpNumRsp,
 * atpCurrBitMap [if a timeout occured, this will show any
 * buffers received], atpRetries.
 */
atpsendrequest(pb, buf, buflen, userdata)
	register CntrlParam *pb;
	char *buf;
	int buflen, userdata;
{
	register struct ATPParam *ap = (struct ATPParam *)&pb->csParam;

	pb->ioRefNum = atpRefNum;
	pb->csCode = atpSendRequest;
	pb->atpUserData = (Ptr)userdata;
	ap->atpFlags &= (atpXO | atpSendChk);
	ap->atpReqLength = buflen;
	ap->atpReq = buf;
	ap->atpTimeOut = atpTimeOut;
	ap->atpRetries = atpRetries;
	return (PBControl(pb, atpAsync));
}


/*
 * Setup a BDS area to point to a contiguous buffer region,
 * using buffers of size atpNData (the 'normal' amount of
 * data usually carried per ATP packet).
 *
 * Returns the number of BDS elements used.
 */
atpsetupbds(bds, buf, len, userdata)
	BDS *bds;
	char *buf;
	int len;
{
	register BDS *bp;
	int nbds;

	bp = bds;
	nbds = 0;
	while (len > 0) {
		bp->buffSize = (len > atpNData ? atpNData : len);
		bp->buffPtr = buf;
		bp->userData = userdata;
		buf += atpNData;
		len -= atpNData;
		bp++;
		nbds++;
	}
	return (nbds);
}
