/*	mat.c	1.0	03/17/84	*/

/*
 * MAT - Mac ATP Test program (or: Mac ATP Transfer)
 *
 */

/*
 * history
 * 03/17/84	Croft	created.
 */


#include "quickdraw.h"
#include "osintf.h"
#include "toolintf.h"
#include "packintf.h"

#include <sys/types.h>		/* u_short, etc. */
#include "mat.h"
#define	MAC	1		/* pulls in Mac CntrlParam structs */
#include "atalk.h"


#define	TRUE	1
#define	VIS	1
#define	FALSE	0
#define	NIL	0

char	user[32];		/* user name */
char	node[32];		/* node name */
char	pass[32];		/* password */
char	rfile[32];		/* remote file name */
char	lfile[32];		/* local file name */

extern int atpTimeOut;		/* ATP request timeout in seconds */
extern int atpRetries;		/* ATP # of retries */
char	initsoc;		/* initial connection socket */
char	xxx;
extern char *atalkerror();
BDS	bds[8];			/* buffer data structures */
CntrlParam pb;			/* ATP request parameter block */
char	*reqbuf;		/* ATP request buffer (length REQLEN) */
char	*resbuf;		/* ATP response buffer (length RESLEN) */
char	*linep;			/* pointer within string being parsed */

short	sfwhere[] = { 40, 40 };	/* std file dialog location */
SFReply	sfreply;		/* std file reply record */


main()
{
	struct QDVar QDVar;	/* or we could call NewPtr */
	register i;
	register struct ATPParam *ap = (struct ATPParam *)&pb.csParam;

	QD = &QDVar;
	skelinit();		/* initialize toolbox skeleton */
	/* open appletalk and allocate memory */
	if ((i = atalkopen(TRUE)) != noErr)
		abort("atalk open error, ", atalkerror(i));
	if ((reqbuf = NewPtr(REQLEN)) == NIL ||
	    (resbuf = NewPtr(RESLEN)) == NIL)
		abort("can't allocate memory", "");
	ap->atpNumBufs = atpsetupbds(bds, resbuf, RESLEN, 0);
	ap->atpBDS = bds;
	ap->atpFlags = atpXO;
	
	printf("Mac ATP Transfer.\n");
	namedialog();		/* get node, user, password */
	printf("Choose get/put from FILE menu.\n");
	skeleventloop();	/* never returns */
}


/*
 * File menu selection.  Called from skeleton upon menu event.
 * Argument is menu item index.
 */
filemenu(item)
{
	switch (item) {
	case 1:
		get();
		break;

	case 2:
		put();
		break;

	case 3:
		namedialog();
		break;

	case 4:
		Exit();
		break;
	}
}


/*
 * Get a remote file.
 */
get()
{
	char rfork;
	int vrn, rn, i;
	register struct ATPParam *ap = (struct ATPParam *)&pb.csParam;

	rfiledialog((char *)0);
	if (rfile[0] == 0)	/* if no name was specified */
		return;
	strcpy(lfile, rfile);
	rfork = isrsrc(lfile);	/* check if it is-a-rsrc file */
	SFPutFile((Point *)sfwhere, "local file", lfile,
	   (ProcPtr)NIL, &sfreply);
	if (sfreply.good == 0)
		return;
	p2cstr(sfreply.fName);
	strcpy(lfile, sfreply.fName);
	SetVol((char *)0, (vrn = sfreply.vRefNum));
	/* open the local file */
	FSDelete(lfile, vrn);
	if (Create(lfile, vrn, "MATP", rfork ? "APPL" : "TEXT") != noErr
	    || (rfork ? OpenRF(lfile, vrn, &rn) : FSOpen(lfile, vrn, &rn))
	    != noErr ) {
		matalert("Can't open local file. ", 0);
		return;
	}
	/* send OPREAD request to remote */
	ap->atpAddrBlock.skt = initsoc;
	atpTimeOut = 8;
	atpRetries = 4;
	linep = reqbuf;	/* stuff arguments in here */
	catline(user, pass, rfile, 0);
	if ((i = atpsendrequest(&pb, reqbuf, linep-reqbuf, OPREAD)) != noErr)
		goto noresp;
	if (bds[0].userData != (OPREAD|OPACK))	/* remote open failed */
		goto badresp;
	/* remote daemon has forked, use the new socket */
	ap->atpAddrBlock.skt = *resbuf;
	atpTimeOut = 4;
	for (;;) {
		int count;
		if ((i = atpsendrequest(&pb, reqbuf, 0, OPDATA)) != noErr)
			goto noresp;
		if ((bds[0].userData & OPMASK) != (OPDATA|OPACK))
			goto badresp;
		count = bds[0].userData >> 16;
		if (count == 0)
			break;
		FSWrite(rn, &count, resbuf);
	}
	FSClose(rn);
	printf("got %s\n", lfile);
	return;	

badresp:
	FSClose(rn);
	matalert(resbuf, 0);
	return;
noresp:
	FSClose(rn);
	matalert("Remote not responding. ", i);
	return;
}


/*
 * Put local file to remote.
 */
put()
{
	char rfork;
	int vrn, rn, i;
	FileParam fp;
	register struct ATPParam *ap = (struct ATPParam *)&pb.csParam;

	SFGetFile((Point *)sfwhere, "local file", (ProcPtr)NIL, -1, "",
	   (ProcPtr)NIL, &sfreply);
	if (sfreply.good == 0)
		return;
	bzero((caddr_t)&fp, sizeof fp);
	fp.ioNamePtr = sfreply.fName;
	PBGetFInfo(&fp, 0);		/* is it a .rsrc file? */
	rfork = (fp.ioFlRLgLen ? 1 : 0);
	p2cstr(sfreply.fName);
	strcpy(lfile, sfreply.fName);
	strcpy(rfile, lfile);
	SetVol((char *)0, (vrn = sfreply.vRefNum));
	/* open the local file */
	if ( (rfork ? OpenRF(lfile, vrn, &rn) : FSOpen(lfile, vrn, &rn))
	    != noErr ) {
		matalert("Can't open local file. ", 0);
		return;
	}
	if (rfork)
		strcat(rfile, ".rsrc");
	rfiledialog(rfile);
	/* send OPWRITE request to remote */
	ap->atpAddrBlock.skt = initsoc;
	atpTimeOut = 8;
	atpRetries = 4;
	linep = reqbuf;	/* stuff arguments in here */
	catline(user, pass, rfile, 0);
	if ((i = atpsendrequest(&pb, reqbuf, linep-reqbuf, OPWRITE)) != noErr)
		goto noresp;
	if (bds[0].userData != (OPWRITE|OPACK))	/* remote open failed */
		goto badresp;
	/* remote daemon has forked, use the new socket */
	ap->atpAddrBlock.skt = *resbuf;
	atpTimeOut = 4;
	for (;;) {
		int count, err;
		count = REQLEN;
		err = FSRead(rn, &count, reqbuf);
		if ((i = atpsendrequest(&pb, reqbuf,
		    count, OPDATA | (count << 16))) != noErr)
			goto noresp;
		if ((bds[0].userData & OPMASK) != (OPDATA|OPACK))
			goto badresp;
		if (count == 0)
			break;
	}
	FSClose(rn);
	printf("sent %s\n", lfile);
	return;	

badresp:
	FSClose(rn);
	matalert(resbuf, 0);
	return;
noresp:
	FSClose(rn);
	matalert("Remote not responding. ", i);
	return;
}


/*
 * Check a filename string to see if it refers to a 'resource' file.
 * This is true if the extension is '.RF' or '.rsrc'.  If such an
 * extension is found, remove it and return 'true'.
 */
isrsrc(cp)
	register char *cp;
{
	for ( ; *cp ; cp++)
		if (*cp == '.')
			break;
	if (*cp == 0)
		return (0);
	cp++;
	if (strcmp(cp, "rsrc") == 0 ||
	    strcmp(cp, "RF") == 0) {
		*(--cp) = 0;
		return (1);
	}
	return (0);
}


/*
 * Dialog to obtain node name, user name and password.
 * Verify this information with the remote host.
 */
namedialog()
{
	DialogPtr dialp;
	int item;
	Rect box;
	Handle itemH;
	int itemtype;
	register struct ATPParam *ap = (struct ATPParam *)&pb.csParam;
	register i;

	dialp = GetNewDialog(2, (Ptr)0, (WindowPtr)-1);
dloop:
	for (;;) {
		ModalDialog((ProcPtr)NIL, &item);
		GetDItem(dialp, item, &itemtype, &itemH, &box);
		if (item == OK)
			break;
		switch (itemtype) {
		case ctrlItem+chkCtrl:
		case ctrlItem+radCtrl:
			SetCtlValue(itemH, GetCtlValue(itemH) ? 0 : 1);
		}
	}
	GetDItem(dialp, 2, &itemtype, &itemH, &box);
	GetIText(itemH, node);
	GetDItem(dialp, 3, &itemtype, &itemH, &box);
	GetIText(itemH, user);
	GetDItem(dialp, 4, &itemtype, &itemH, &box);
	GetIText(itemH, pass);
	if (lookupnode(node, &ap->atpAddrBlock) != noErr)
		goto dloop;
	initsoc = ap->atpAddrBlock.skt;
	linep = reqbuf;		/* stuff characters into here */
	catline(user, pass, 0);
	atpTimeOut = 8;		/* # seconds before request timeout */
	atpRetries = 4;
	if ((i = atpsendrequest(&pb, reqbuf, linep-reqbuf, OPCHECK)) != noErr){
		matalert("Remote node not responding. ", i);
		goto out;
	}
	if (bds[0].userData == (OPCHECK | OPACK))
		goto out;
	matalert(resbuf, 0);
out:
	DisposDialog(dialp);
}


/*
 * Dialog to obtain remote filename.  Argument string, if present
 * is used to preset the EditText field.
 */
rfiledialog(s)
	char *s;
{
	DialogPtr dialp;
	int item;
	Rect box;
	Handle itemH;
	int itemtype;

	dialp = GetNewDialog(3, (Ptr)0, (WindowPtr)-1);
	if (s) {
		GetDItem(dialp, 2, &itemtype, &itemH, &box);
		SetIText(itemH, s);
	}
	for (;;) {
		ModalDialog((ProcPtr)NIL, &item);
		GetDItem(dialp, item, &itemtype, &itemH, &box);
		if (item == OK)
			break;
		switch (itemtype) {
		case ctrlItem+chkCtrl:
		case ctrlItem+radCtrl:
			SetCtlValue(itemH, GetCtlValue(itemH) ? 0 : 1);
		}
	}
	GetDItem(dialp, 2, &itemtype, &itemH, &box);
	GetIText(itemH, rfile);
	DisposDialog(dialp);
}


/*
 * KLUDGE!  Until NBP is implemented, we use this built-in name
 * table (or the user can type 'netnumber,nodenumber').
 */
struct nodetable {
	char	*name;
	short	net;
	short	node;
} nodetable[] = {
	"safe", 44, 1,
	"lindy", 9, 11,
	"argus", 9, 10,
	"diablo", 45, 193,
	"ardvax", 47, 1,
	0, 0, 0
};


/*
 * Lookup a node name and set the net/node/socket fields into
 * the supplied AddrBlock.
 */
lookupnode(s, ab)
	char *s;
	register AddrBlock *ab;
{
	register struct nodetable *ntp;
	short anet,anode;

	/* lookup node name (should be using NBP) */
	for (ntp = &nodetable[0] ; ntp->net ; ntp++)
		if (strcmp(ntp->name, s) == 0)
			break;
	anet = ntp->net;
	anode = ntp->node;
	if (anet == 0) {	/* not found, try number */
		linep = s;	/* start scanning here */
		if ((anet = line2int()) == -1 ||
		    (anode = line2int()) == -1) {
			ParamText("Unknown node name.",
			   "You can also use net, node numbers; e.g.: '44,1'",
			   "", "");
			CautionAlert(1, (ProcPtr)NIL);
			return (-1);
		}
	}
	ab->net = anet;
	ab->node = anode;
	ab->skt = MATSOCKET;	/* XXX use NBP value instead */
	return (noErr);
}


/*
 * fatal abort.
 */
abort(s1,s2)
	char *s1,*s2;
{
	ParamText("Fatal error:", s1, s2, "");
	StopAlert(1, (ProcPtr)NIL);
	ExitToShell();
}


/*
 * Convert string in *linep to an integer and return that value.
 * 'linep' is updated to point to the next numeric string component.
 * Returns -1 if error.
 */
line2int()
{
	register char *cp = linep;
	register i = 0;
	register t;

	for ( ; *cp >= '0' && *cp <= '9' ; cp++) {
		t = *cp - '0';
		i = (i*10) + t;
	}
	if (cp == linep)
		return (-1);
	while (*cp != 0 && !(*cp >= '0' && *cp <= '9'))
		cp++;
	linep = cp;
	return (i);
}


/*
 * Concatinate string arguments into 'linep' area, separated by
 * SEPCHAR.
 */
catline(sa)
	char *sa;
{
	register char *sp,*dp = linep;
	register char **ap = &sa;

	for ( ; (sp = *ap) ; ap++) {
		while (*dp++ = *sp++);
		dp--;
		*dp++ = SEPCHAR;
	}
	dp--;
	*dp++ = 0;
	linep = dp;
}


/*
 * Report an error string using a CautionAlert and atalk error string.
 */
matalert(s, i)
	char *s;
	int i;		/* atalk error number */
{
	ParamText(s, (i == 0 ? "" : (char *)atalkerror(i)), "", "");
	CautionAlert(1, (ProcPtr)NIL);
}


/*
 * Zero an area of memory.  'bzero(buf,size)'
 */
asm("	.globl	bzero");
asm("bzero:	movl	sp@(4),a0");
asm("	movl	sp@(8),d0");
asm("	subql	#1,d0");
asm("	moveq	#0,d1");
asm("1$:	movb	d1,a0@+");
asm("	dbra	d0,1$");
asm("	rts");
