/*	pbuf.h	1.1	84/11/15	*/

/*
 * Constants related to memory allocator.
 */
#define	MAXHEAD		128		/* max space for header */
#define	MAXDATA		630		/* max space for data */

struct pbuf {
	struct	pbuf *p_next;		/* next buffer in queue */
	u_char	*p_off;			/* offset of data */
	short	p_len;			/* amount of data in this pbuf */
	short	p_type;			/* pbuf type (0 == free) */
	u_char	p_head[MAXHEAD];	/* header storage */
	u_char	p_data[MAXDATA];	/* data storage */
};
/* WARNING: assembler constants in lap.s use this pbuf structure */

/* pbuf types */
#define	PT_FREE		0	/* should be on free list */
#define	PT_ABUS		1	/* incoming abus packet */
#define	PT_ENET		2	/* incoming ethernet packet */
#define	PT_ARP		3	/* arp packet */
#define	PT_DATA		4	/* general data */

#define	PGET(p, t) \
	{ int ms = splimp(); \
	  if ((p)=pfree) \
		{ if ((p)->p_type != PT_FREE) panic("pget"); (p)->p_type = t; \
		  pbnfree--; pbntypes[t]++; \
		  pfree = (p)->p_next; (p)->p_next = 0; \
		  (p)->p_off = &(p)->p_data[0]; } \
	  else \
		pbndrops++; \
	  splx(ms); }

#define	PFREE(p, n) \
	{ int ms = splimp(); \
	  if ((p)->p_type == PT_FREE) panic("pfree"); \
	  pbntypes[(p)->p_type]--; (p)->p_type = PT_FREE; \
	  (n) = (p)->p_next; (p)->p_next = pfree; \
	  pfree = (p); pbnfree++; \
	  splx(ms); }

struct pqueue {
	struct pbuf *pq_head;
	struct pbuf *pq_tail;
	short	pq_len;
};

/*
 * Pbuf statistics.
 */
short	pbntypes[16];	/* type specific pbuf allocations */
short	pbnfree;	/* pbufs on our free list */
short	pbndrops;	/* times failed to find space */

struct	pbuf *pfree;
struct	pbuf *p_get(),*p_free(),*p_deq();

struct pqueue pq;			/* main packet queue */

#define	NBUF	64			/* number of packet buffers */

struct	pbuf pbufs[NBUF];		/* buffer pool area */
