#define	SCC 0x1f6000
#define	ABOFF	1

struct	scc {
	char	bctl;
	char	actl;
	char	bdata;
	char	adata;
};

int	delay;

main()
{
	register struct scc *sccp;
	register i,j;

	sccp = (struct scc *)SCC;
	printf("SCC register R/W\n");
	for (;;) {
		i = sccp->bctl;		/* ensure synced */
		printf("\n:");
		switch (getchar()) {
		case 'a':
			sccp = (struct scc *)(SCC+ABOFF);
			printf(" A selected");
			break;
			
		case 'b':
			sccp = (struct scc *)SCC;
			printf(" B selected");
			break;
			
		case 'p':
			i = getnum();
			sccp->bdata = i;
			break;
			
		case 'g':
			i = sccp->bdata & 0xff;
			printf(" data %x",i);
			break;

		case 'G':
			while (!linereadyrx(0))
				i = sccp->bdata;
			break;

		case 'P':
			i = getnum();
			while (!linereadyrx(0))
				sccp->bdata = i;
			break;

		case 'r':
			i = getnum();
			sccp->bctl = i;
			delay++;  delay++;
			i = sccp->bctl;
			printf(" = %x",i);
			break;

		case 'R':
			i = getnum();
			while (!linereadyrx(0)) {
				sccp->bctl = i;
				delay++;  delay++;
				j = sccp->bctl;
				delay++;  delay++;
			}
			break;

		case 'w':
			i = getnum();
			sccp->bctl = i;
			delay++;  delay++;
			i = getnum();
			sccp->bctl = i;
			break;

		case 'W':
			i = getnum();
			j = getnum();
			while (!linereadyrx(0)) {
				sccp->bctl = i;
				delay++;  delay++;
				sccp->bctl = j;
				delay++;  delay++;
			}
			break;
		}
	}
}
			
getnum()
{
	register i;
	register c;

	i = 0;
	for (;;) {
		c = getchar();
		if (c=='\r' || c==' ') 
			break;
		i <<= 4;
		if (c >= '0' && c <= '9')
			c -= '0';
		else
			c = c - 'a' + 10;
		i += c;
	}
	return (i);
}

getn()
{
	while (getchar() != '\n');
}
