/*
 * V Kernel - Copyright (c) 1985 by Stanford University, All rights reserved.
 *
 *	The mnemonics for the microVAX privileged registers
 *
 * $Revision: 1.4.1.2 $
 * $Locker:  $
 * $State: Exp $
 */

#ifndef ASMDEFS_H
#define ASMDEFS_H

asm("	.set	ksp, 0x0");
asm("	.set	esp, 0x1");
asm("	.set	ssp, 0x2");
asm("	.set	usp, 0x3");
asm("	.set	isp, 0x4");
asm("	.set	p0br, 0x8");
asm("	.set	p0lr, 0x9");
asm("	.set	p1br, 0xa");
asm("	.set	p1lr, 0xb");
asm("	.set	sbr, 0xc");
asm("	.set	slr, 0xd");
asm("	.set	pcbb, 0x10");
asm("	.set	scbb, 0x11");
asm("	.set	ipl, 0x12");
asm("	.set	astlvl, 0x13");
asm("	.set	sirr, 0x14");
asm("	.set	sisr, 0x15");
asm("	.set	cmierr, 0x17");
asm("	.set	iccs, 0x18");
asm("	.set	nicr, 0x19");	/* Unused/Unimplemented/Inaccesible */
asm("	.set	icr, 0x1a");	/* Unused/Unimplemented/Inaccesible */
asm("	.set	todr, 0x1b");	/* Unused/Unimplemented/Inaccesible */
asm("	.set	csrs, 0x1c");	/* Unused/Unimplemented/Inaccesible */
asm("	.set	csrd, 0x1d");	/* Unused/Unimplemented/Inaccesible */
asm("	.set	csts, 0x1e");	/* Unused/Unimplemented/Inaccesible */
asm("	.set	cstd, 0x1f");	/* Unused/Unimplemented/Inaccesible */
asm("	.set	rxcs, 0x20");
asm("	.set	rxdb, 0x21");
asm("	.set	txcs, 0x22");
asm("	.set	txdb, 0x23");
asm("	.set	tbdr, 0x24");	/* Unused/Unimplemented/Inaccesible */
asm("	.set	cadr, 0x25");
asm("	.set	mcesr, 0x26");
asm("	.set	caer, 0x27");	/* Unused/Unimplemented/Inaccesible */
asm("	.set	accs, 0x28");	/* Unused/Unimplemented/Inaccesible */
asm("	.set	savisp, 0x29");
asm("	.set	savpc, 0x2a");
asm("	.set	savpsl, 0x2b");
asm("	.set	wcsa, 0x2c");	/* Unused/Unimplemented/Inaccesible */
asm("	.set	wcsb, 0x2d");	/* Unused/Unimplemented/Inaccesible */
asm("	.set	sbifs, 0x30");	/* Unused/Unimplemented/Inaccesible */
asm("	.set	sbis, 0x31");	/* Unused/Unimplemented/Inaccesible */
asm("	.set	sbisc, 0x32");	/* Unused/Unimplemented/Inaccesible */
asm("	.set	sbimt, 0x33");	/* Unused/Unimplemented/Inaccesible */
asm("	.set	sbier, 0x34");	/* Unused/Unimplemented/Inaccesible */
asm("	.set	sbita, 0x35");	/* Unused/Unimplemented/Inaccesible */
asm("	.set	sbiqc, 0x36");	/* Unused/Unimplemented/Inaccesible */
asm("	.set	ioreset, 0x37");
asm("	.set	mapen, 0x38");
asm("	.set	tbia, 0x39");
asm("	.set	tbis, 0x3a");
asm("	.set	tbdata, 0x3b");	/* Unused/Unimplemented/Inaccesible */
asm("	.set	mbrk, 0x3c");	/* Unused/Unimplemented/Inaccesible */
asm("	.set	pmr, 0x3d");	/* Unused/Unimplemented/Inaccesible */
asm("	.set	sid, 0x3e");
asm("	.set	tbchk, 0x3f");

#endif ASMDEFS_H
