/*
 * V Kernel - Copyright (c) 1985 by Stanford University, All rights reserved.
 *
 * $Revision: 1.7.1.2 $
 * $Locker:  $
 * $State: Exp $
 */

#include "asmdefines.h"
#include "memory.h"
#include "memaccess.h"
#include "debugger.h"
#include "externals.h"

struct pcb {
		unsigned		ksp; /* kernel stack pointer */ 		/* 0 */
		unsigned		esp; /* executive stack pointer */		/* 4 */
		unsigned		ssp; /* supervisor stack pointer */		/* 8 */
		unsigned		usp; /* user stack pointer */			/* 12 */
		unsigned		r0,	/* registers */						/* 16 */
						r1, 									/* 20 */
						r2,										/* 24 */
						r3,										/* 28 */
						r4,										/* 32 */
						r5,										/* 36 */
						r6,										/* 40 */
						r7,										/* 44 */
						r8,										/* 48 */
						r9,										/* 52 */
						r10,									/* 56 */
						r11,									/* 60 */
						ap,										/* 64 */
						fp,										/* 68 */
						pc;										/* 72 */
		unsigned		psl;									/* 76 */
		unsigned		p0br;									/* 80 */
		unsigned		p0lr:22,	/* p0 length register */ 	/* 84 */
						zero1:2,	/* must be zero */
						astlvl:3,	/* ast level */
						zero2:5;	/* must be zero */
		unsigned		p1br;									/* 88 */
		unsigned		p1lr:22,	/* p1 length register */	/* 92 */
						zero3:9,	/* must be zero */
						pme:1;		/* performance monitor enable bit */
} db_pcb = {0}, *db_pcb_ptr = &db_pcb, *db_pcb_old;
/* debugger's process control block for svpctx */

/* set a breakpoint */

static unsigned char	old_contents; /* old contents of address */
static unsigned char	bp_is_set=0;	/* boolean to sense if bp is set */
static unsigned char	bp_opcode=0x03; /* opcode used for breakpoint trap */
static unsigned long	bp_addr;	/* current bp address */

void
bp_set(address)
unsigned long address;
{
	if(!KernelCanWrite((unsigned)address,sizeof(address)))/* must change access on page */
	{ 
		ChangeSysPagesProtection((unsigned)address,sizeof(bp_opcode),VM_RW__);
	 }
	/* we now have write permission on the virtual memory page */
	/* set breakpoint */

	old_contents = *((char *)address); /* get whatever is there now */
	*((char *)address) = bp_opcode; /* set bpt instruction there */
	bp_addr = address; /* set current bp address info */
	bp_is_set = 1; /* we have a breakpoint set */

}

void
bp_reset() /* reset bp */
{
	if(!bp_is_set && bp_addr != 0) /* reset breakpoint if possible */
		bp_set(bp_addr);
}

void
bp_unset() /* unset bp */
{
	if(bp_is_set)
	{
	*((char *)bp_addr) = old_contents; /* restore contents */
	}
}

void
bp_clear() /* clear breakpoint */
{
	bp_unset();
	bp_is_set=0;
	old_contents=0;
	bp_addr=0;	
}


/**************** db_bp_hndlr **************/

unsigned *db_stack_ptr; /* pointer to stack when interrupt called */
unsigned *db_bp_pc; /* pc value */
unsigned *db_bp_psl; /* psl value */
asm("	.globl _db_bp_hndlr");

void
DummyBpHndlr() /* handle breakpoints */
{
	asm("	.align 2");
	asm("_db_bp_hndlr2:");	/* handler version # 2 */
	asm("	jmp callException");
	asm("	.align 2");
	asm("_db_bp_hndlr:");
	/* this is a hack... */
	asm("   tstb    _bp_is_set");
	asm("   beql    _db_bp_hndlr2");
	/* so, bp_is_set != 0, now, is the address in kernel space? */
	/* first, test the value on the top of the stack, then if it is */
	/* not negative (i.e. in kernel space) go to the normal handler */
	asm("	tstl	(sp)");
	asm("	bgeq	_db_bp_hndlr2");
	/* save information */
	asm("	movl	sp,_db_stack_ptr"); /* save the stack pointer !!! */
	asm("	mfpr	$ksp,_db_pcb");
	asm("	mfpr	$esp,_db_pcb+4");
	asm("	mfpr	$ssp,_db_pcb+8");
	asm("	mfpr	$usp,_db_pcb+12");
	asm("	movl	r0,_db_pcb+16");
	asm("	movl	r1,_db_pcb+20");
	asm("	movl	r2,_db_pcb+24");
	asm("	movl	r3,_db_pcb+28");
	asm("	movl	r4,_db_pcb+32");
	asm("	movl	r5,_db_pcb+36");
	asm("	movl	r6,_db_pcb+40");
	asm("	movl	r7,_db_pcb+44");
	asm("	movl	r8,_db_pcb+48");
	asm("	movl	r9,_db_pcb+52");
	asm("	movl	r10,_db_pcb+56");
	asm("	movl	r11,_db_pcb+60");
	asm("	movl	ap,_db_pcb+64");
	asm("	movl	fp,_db_pcb+68");
	db_pcb.pc = *db_stack_ptr;
	db_pcb.psl = *(db_stack_ptr + 1);
	asm("	mfpr	$p0br,_db_pcb+80");
	asm("	mfpr	$p0lr,_db_pcb+84");
	asm("	mfpr	$p1br,_db_pcb+88");
	asm("	mfpr	$p1lr,_db_pcb+92"); 


	/* set up necessary pointers */
	asm("	moval	_db_pcb+72,_db_bp_pc");
	asm("	moval	_db_pcb+76,_db_bp_psl");
	/* db_bp_pc = db_pcb.pc */
	/* db_bp_psl = db_pcb.psl */

	printx("pc = %x\n",*db_bp_pc);
	printx("psl = %x\n",*db_bp_psl);
	printx("bpt fault\n");

	bp_unset();

	use_debugger();
	printx("\nfinished debugger\n");
	*db_bp_psl |= 0x10;	/* turn on trace bit */

	asm("	movl	_db_stack_ptr,sp"); /* restore the stack */
	asm("	mtpr	_db_pcb,$ksp");
	asm("	mtpr	_db_pcb+4,$esp");
	asm("	mtpr	_db_pcb+8,$ssp");
	asm("	mtpr	_db_pcb+12,$usp");
	asm("	movl	_db_pcb+16,r0");
	asm("	movl	_db_pcb+20,r1");
	asm("	movl	_db_pcb+24,r2");
	asm("	movl	_db_pcb+28,r3");
	asm("	movl	_db_pcb+32,r4");
	asm("	movl	_db_pcb+36,r5");
	asm("	movl	_db_pcb+40,r6");
	asm("	movl	_db_pcb+44,r7");
	asm("	movl	_db_pcb+48,r8");
	asm("	movl	_db_pcb+52,r9");
	asm("	movl	_db_pcb+56,r10");
	asm("	movl	_db_pcb+60,r11");
	asm("	movl	_db_pcb+64,ap");
	asm("	movl	_db_pcb+68,fp");
	*db_stack_ptr = db_pcb.pc;
	*(db_stack_ptr + 1) = db_pcb.psl;
	asm("	mtpr	_db_pcb+80,$p0br");
	asm("	mtpr	_db_pcb+84,$p0lr");
	asm("	mtpr	_db_pcb+88,$p1br");
	asm("	mtpr	_db_pcb+92,$p1lr"); 
	printx("rei\n");
	asm("	rei");
	asm("	halt"); /* never gets here, right? */
	
}

asm("	.globl _db_tp_hndlr"); 

void
DummyTpHndlr() /* handle trace pending stuff */
{
	asm("	.align 2");
    	asm("_db_tp_hndlr2:");	/* handler version # 2 */
	asm("	jmp callException");
	asm("	.align 2");
	asm("_db_tp_hndlr:");
	/* this is a hack... */
	asm("   tstb    _bp_is_set");
	asm("   beql    _db_tp_hndlr2");
	asm("	tstl	(sp)");
	asm("	bgeq	_db_tp_hndlr2");
	/* set up necessary pointers */
	asm("	movl	sp,_db_stack_ptr"); /* save the stack pointer !!! */
	asm("	mfpr	$ksp,_db_pcb");
	asm("	mfpr	$esp,_db_pcb+4");
	asm("	mfpr	$ssp,_db_pcb+8");
	asm("	mfpr	$usp,_db_pcb+12");
	asm("	movl	r0,_db_pcb+16");
	asm("	movl	r1,_db_pcb+20");
	asm("	movl	r2,_db_pcb+24");
	asm("	movl	r3,_db_pcb+28");
	asm("	movl	r4,_db_pcb+32");
	asm("	movl	r5,_db_pcb+36");
	asm("	movl	r6,_db_pcb+40");
	asm("	movl	r7,_db_pcb+44");
	asm("	movl	r8,_db_pcb+48");
	asm("	movl	r9,_db_pcb+52");
	asm("	movl	r10,_db_pcb+56");
	asm("	movl	r11,_db_pcb+60");
	asm("	movl	ap,_db_pcb+64");
	asm("	movl	fp,_db_pcb+68");
	db_pcb.pc = *db_stack_ptr;
	db_pcb.psl = *(db_stack_ptr + 1);
	asm("	mfpr	$p0br,_db_pcb+80");
	asm("	mfpr	$p0lr,_db_pcb+84");
	asm("	mfpr	$p1br,_db_pcb+88");
	asm("	mfpr	$p1lr,_db_pcb+92"); 
	/* db_bp_pc = db_pcb.pc */
	/* db_bp_psl = db_pcb.psl */

	printx("trace pending handler\n");
	printx("pc = %x\n",*db_bp_pc);
	printx("psl = %x\n",*db_bp_psl);

	*db_bp_psl &= ~0x10; /* turn off trace bit */

	bp_reset();
	printx("breakpoint reset\n");

	asm("	movl	_db_stack_ptr,sp"); /* restore the stack */
	asm("	mtpr	_db_pcb,$ksp");
	asm("	mtpr	_db_pcb+4,$esp");
	asm("	mtpr	_db_pcb+8,$ssp");
	asm("	mtpr	_db_pcb+12,$usp");
	asm("	movl	_db_pcb+16,r0");
	asm("	movl	_db_pcb+20,r1");
	asm("	movl	_db_pcb+24,r2");
	asm("	movl	_db_pcb+28,r3");
	asm("	movl	_db_pcb+32,r4");
	asm("	movl	_db_pcb+36,r5");
	asm("	movl	_db_pcb+40,r6");
	asm("	movl	_db_pcb+44,r7");
	asm("	movl	_db_pcb+48,r8");
	asm("	movl	_db_pcb+52,r9");
	asm("	movl	_db_pcb+56,r10");
	asm("	movl	_db_pcb+60,r11");
	asm("	movl	_db_pcb+64,ap");
	asm("	movl	_db_pcb+68,fp");
	*db_stack_ptr = db_pcb.pc;
	*(db_stack_ptr + 1) = db_pcb.psl;
	asm("	mtpr	_db_pcb+80,$p0br");
	asm("	mtpr	_db_pcb+84,$p0lr");
	asm("	mtpr	_db_pcb+88,$p1br");
	asm("	mtpr	_db_pcb+92,$p1lr"); 

	asm("	rei");
	asm("	halt");
}
