/*
 * V Kernel - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 *
 * Configuration-specific code for a version of the kernel which runs on
 *   MicroVAX IIs (and on the main processor of a Firefly) with a DEQNA
 *   ethernet interface.  Works with virtual-memory and non-VM versions.
 *   Can support the RQDX disk controller and QVSS or MDC framebuffers (if for
 *   some bizarre reason both framebuffers are present it prefers the MDC).
 * At present (5-Mar-87) the RQDX and (I think) the MDC use Q-Bus DMA mapping
 *   in a fashion that will not work on a MicroVAX I.  The rest of this version
 *   should run happily on a MicroVAX I but hasn't been tested on one.
 *
 * $Revision: 1.13.1.5 $
 * $Locker:  $
 * $State: Exp $
 */

#include <Venviron.h>		/* SystemCode */
#include "config.h"		/* ROOT_PRIORITY, INIT_STACK */
#include "process.h"
#include "processor.h"		/* disable */
#ifdef FIREFLY
#include "firefly.h"
#endif FIREFLY
#include <Vquerykernel.h>	/* Configuration structures */
#include "qvss.h"
#include "rqdx.h"
#include "deqnalocal.h""
#include "console.h"
#include "timer.h"

/* Saved configration information */
MachineConfigurationReply	MachineConfig;
PeripheralConfigurationReply	PeripheralConfig;
KernelConfigurationReply	KernelConfig;

DeviceDirectoryFunc EnetModify;
DeviceDirectoryFunc EnetQuery;
void (*EnetPowerup)();

static short DiskType	     = PRF_NONE;
       short FramebufferType = PRF_NONE;
int	     (*FramebufferEnableVideo)() = 0;

static unsigned char *LastPeripheral = &PeripheralConfig.peripheral[0];

BooleanInt
AddPeripheral(p)
    unsigned char p;
  {
    if (LastPeripheral >= &PeripheralConfig.peripheral[MAX_PERIPHERALS])
	return 0;
    *LastPeripheral++ = p;
    return 1;
  }

void
FindConfiguration()
  {
    extern unsigned versionnum; /* from vers.c */
    extern unsigned long MaxProcesses, MaxTeams; /*Set by CalcNum_PDs_and_TDs*/

    /* Pseudo MI configuration information */
#ifdef ENET3MEG
    KernelConfig.ikcType = IKC_3MBIT;
#else
#ifdef ENET10MEG
    KernelConfig.ikcType = IKC_10MBIT;
#else
    KernelConfig.ikcType = IKC_NONE;
#endif
#endif
    CalcNum_PDs_and_TDs();
    KernelConfig.maxProcesses	= (unsigned)MaxProcesses;
    KernelConfig.maxTeams	= (unsigned)MaxTeams;

    KernelConfig.rootPriority = ROOT_PRIORITY;
    KernelConfig.initStack = INIT_STACK;
#ifdef VM
    KernelConfig.vmConfig = VM_PRESENT;
#else !VM
    KernelConfig.vmConfig = VM_NONE;
#endif VM
    KernelConfig.versionNumber = versionnum;

    if ( (FramebufferType = FindMdc (&FramebufferEnableVideo)) == PRF_NONE )
	  FramebufferType = FindQvss(&FramebufferEnableVideo);
    if ( (DiskType = FindRqdxDisks()) != PRF_NONE )
	AddPeripheral(DiskType);
    /* Assume we have a terminal as our console */
    AddPeripheral(PRF_CONSOLE_TERMINAL);
  }

void
BuildSysMap_Config()
  {
    BuildSysMap_Deqna();
    if (DiskType == PRF_DISK_RQDX)
	BuildSysMap_Rqdx();
    if (FramebufferType == PRF_FRAMEBUFFER_QVSS)
	BuildSysMap_Qvss();
    else if (FramebufferType == PRF_FRAMEBUFFER_MDC)
	BuildSysMap_Mdc ();
  }

void
Powerup()
  /* Perform all device initializations and such like
   * as is required initially and logically after a powerup
   * after power failure.
   */
  {
    disable;

    InitException();
#ifdef FIREFLY
#if 1
    if (Multiprocessor)
      {
        BootSecondaryProcessors();
        PrimaryProcessorComplete();
        WaitForSecondaryProcessors();
      }
#endif 0
#endif FIREFLY
    InitConsole();
    Init_timer();
    InitDeqna();
/* Not necessarily the right place to do these, but better than what we used */
/*   to have:								     */
    AddDevice("console", 0, ConsoleCreate, 0, 0);
    AddDevice("nullin",  0, NullInCreate,  0, 0);
    AddDevice("nullout", 0, NullOutCreate, 0, 0);
    EnetPowerup();
    if (DiskType == PRF_DISK_RQDX)
	RqdxPowerup();
    if (FramebufferType == PRF_FRAMEBUFFER_QVSS)
	QvssPowerup();	/* this does the mouse and serial powerups also */
    else if (FramebufferType == PRF_FRAMEBUFFER_MDC)
	MdcPowerup();
    LockSCB();          /* Keep SCB from getting clobbered */
  }

