/*
 * V Kernel - Copyright (c) 1981 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 * Copyright (c) 1982 Stanford University.
 *
 */

#include "asmdefs.h"
#include "config.h"
#include "process.h"
#include "processor.h"
#include "firefly.h"
#include "devman.h"
#include "interrupt.h"

#include "externals.h"

extern int ProcessorNo;
int ProcessorBooted = 0;
int ProcessorStopped = 0;

int NotPrimaryComplete = 1;
int NotSecondariesComplete = MAX_PROCESSORS - 1;

extern int ProcessorStopped;
SyncQueue *GlobalReadyqKludge;
KErrorInfoType KErrorInfo[MAX_PROCESSORS];

int KernelLock = 0; /* The kernel lock */

/* Pointer to processor record of holder of kernel lock */
ProcessorRec *KLockHolder = NULL; 

int HoldKLock = 0;

char *ipcrs_v = NULL;

IPRBufferType IPRBuffer =
  { 
    NULL_PROCESSOR,
    0,
    NO_IPR,
    NULL,
    NULL_FUNCTION,
    {0}
  };

/* 
 * Copy a JMP to the initialization code for a secondary processor.
 * FF_SECONDARY_INIT_PC.
 * Called before virtual memory is enabled.
 */

void
CopyJmpInitSecondary()
{
  register int r11;
  register int r10;


  r11 = FF_SECONDARY_INIT_PC;


  asm("	movl	$JmpStart,r10");
  asm("1:");
  asm("		movb	(r10)+,(r11)+");
  asm("	cmpl	r10,$JmpEnd");
  asm("	blss	1b");


}

void
InitInterprocessorInts()
  {
    Unspec *p;

    p = (Unspec *) PrimaryIPIVecLoc; 
    *p =  (Unspec)VecInterProcessorInt;

    p = (Unspec *) SecondaryIPIVecLoc;
    *p = (Unspec)VecInterProcessorInt;
  }

void
BootSecondaryProcessors()
  {
    extern Interprocessor_interrupt();
    unsigned i;

    setexvec(Interprocessor_interrupt, (VecInterProcessorInt / 4));

    NProcessors = MAX_PROCESSORS;
    for (i = 1; i < MAX_PROCESSORS; i++)
      BootProcessor();
  }

void
BootProcessor()
/*
 * Attempt to boot a CCF non-I/O processor.
 * Executed AFTER virtual memory is enabled.
 * Reference: Firefly Programmer's Manual, Section 6.
 */
{
   unsigned i;
   unsigned *uptr;
   unsigned u;

  /* Boot secondary processor */

  ProcessorNo++;
  ProcessorBooted = 0;

  /* Boot Step 1 (from Firefly Programmer's Manual, section 6) */
  IPCR(ProcessorNo) = FF_RESET | FF_SET; 
  IPCR(ProcessorNo) = FF_CACHE_INIT | FF_SET; 
  IPCR(ProcessorNo) = FF_INTERRUPT | FF_CLEAR; 

  /* Boot Step 2 */

  asm("mtpr	$0,$mapen"); /* Disable virtual memory */
  

  /*
   * We read and write a 128Kb block of contiguous physical memory so that
   * this procedure can be executed on CCF processors with 64k byte caches 
   */
  for (uptr = (unsigned *) 0x80001000; uptr <= (unsigned *) (0x80001000 + 128 * 1024); uptr++)
     {
       u = *uptr;
       *uptr = u;
     }

  asm("mtpr	$1,$mapen"); /* Reenable virtual memory */

  /* Boot Step 3 */
  IPCR(ProcessorNo) = FF_CACHE_INIT | FF_CLEAR; 
  IPCR(ProcessorNo) = FF_RESET | FF_CLEAR; 

  for ( i = 0; !ProcessorBooted && i < 500000; i++); 

  if (ProcessorBooted) printx("Processor %d booted\n", ProcessorNo);
   else printx("Processor %d failed to boot", ProcessorNo);
}

DummyInitSecondaryAndHaltHandler()

{
 /* Code executed by secondary processors when booted or halted */

  register int *r11;
  register int r10;
  register int r9;
  register ProcessorRec *r8;
  register int i;
  register KErrorInfoType *ei;

  asm("	InitSecondaryAndHaltHandler:");

  asm("	mfpr	$savisp,r0");
  asm("	mfpr	$savpc,r1");
  asm("	mfpr	$savpsl,r2");
  asm("	cmpzv	$8,$7,r2,$3");
  asm("	beql	InitializeSecondary");
   
  asm(" subl2	$8,sp");
  asm(" movl	r0,r11");
  asm(" movl	r1,r10");
  asm(" movl	r2,r9");

  AsmGetProcessorRecord(r8);
  asm(" mfpr	$p1br,r8");
  i = GetProcessorNo(r8);
  ProcessorArray[i].active->PC = (Unspec) r10;
  ProcessorArray[i].active->status = (Unspec) (r10 & 0xffff00ff); 
  ei = &KErrorInfo[i];
  /* ei->errcode = blah; */
  ei->haltcode = (unsigned) ( (r9 & 0x0000ff00) >> 8 );
  ProcessorStopped |= ( 1 << i );
  /* Let the primary reset all secondaries */
  while (1);

  asm("	InitializeSecondary:");
  
  ;asm("	mtpr	$0xec, $cadr");   /* Enable on chip icache */

  ;asm(" jmp	*$InitStacks");
}

Dummy_Resched()
  {
    register ProcessorRec *r11;		/* r11 */
    asm("Resched:");
    KLock();
    AsmGetProcessorRecord(r11);
    if ( r11->active->localPid != INVALID_PROCESS 
         || r11->active == &r11->idle_process )
      /* If active process is not dead */
      Addready(r11->active);
    ;asm("  jmp 	ActivateReadyqHead");
  }

/* Interprocessor interrupt handler */
void 
Dummy_Interprocessor_interrupt()
  {
    register ProcessorRec *r11;		/* r11 */
    register IPRBufferType *iprb;    	/* r10 */
    register unsigned pno;   		/* r9  */
    register unsigned r8;		/* r8  */
    register unsigned resched_flag;	/* r7 */
    register Process *r6;		/* r6 */
    asm("	.text");
    asm("	.align 2");
    asm("_Interprocessor_interrupt:");
    asm(" pushr	$0x0fff");
    ;Kdisable;
    resched_flag = 1;

    AsmGetProcessorRecord(r11);
    asm(" bitl    $0x03000000,52(sp)"); /* Were we in kernel mode ? */  
    asm(" bneq	2f");			/* No, we were in a process */	
    asm(" bitl    $0x001f0000,52(sp)");   /* Is saved IPL = 0? */    
    asm(" bneq	1f");			/* no, we were in the kernel */	
    if ( r11->active == &r11->idle_process ) 
      {
        ;asm(" brb  2f");
      }
    ;asm(" 1:");
    resched_flag = 0;
    asm(" 2:");
    pno = GetProcessorNo(r11);
    iprb = &IPRBuffer;
    IPCR(pno) = FF_INTERRUPT | FF_CLEAR;	/* clear interrupt */

    if ( pno != 0 )
      /* Secondary Processor */
      {
        if ( ProcessorStopped )
          {
            KForceStop();
          }
        if ( r11->md.ticks > 0)
          {
            r11->active->processorTime += r11->md.ticks;
            r11->md.ticks = 0;
          }
        if ( iprb->dest != pno ) 
          {
            if ( resched_flag &&  r11->readyq.head != NULL &&
                 r11->readyq.head->priority < r11->active->priority ) 
               {
                  KLockNowait(r8);
                  if ( r8 == 1 )
                    {
                      Addready(r11->active);
                      ;asm(" popr	$0x0fff");
                      asm("  jmp 	Switch"); 
                    }
                }
            ;asm(" popr	$0x0fff");
            asm(" rei");
          }
      }
    if (iprb->dest != pno)
    /* Case of inter-processor request being handled by the KLock stuff first */
    /* Another processor may be executing in the kernel */
      {
        /* Must be primary processor */
        if ( r11->active->priority > NULL_PROCESS_PRIORITY && resched_flag )
        /* If active process is suspended or dead */
          {
            ;asm("  popr  	$0x0fff");
            SaveProcessContext();
 	    asm("   movl	$0x00150000,-(sp)");
            asm("   moval	Resched,-(sp)");
            asm("   rei");
          }
        else
          {
            ;asm("  popr  $0x0fff");
            asm("   rei");
          }
      }
    iprb->dest = NULL_PROCESSOR;
    switch (iprb->type)
      {
        case DEVICE_SERVICE:
          r6 = GetAddressableProcess();
          SetAddressableProcess(iprb->addressableProcess);
          DeviceService();
          SetAddressableProcess(r6);
          break;
        case MEM_INVALIDATE:
          MemoryInvalidate();
          break;
        case RESCHEDULE:
          if ( ( !resched_flag || r11->readyq.head->finish_up != NULL )
              && ( r11->active->queuePtr == &r11->readyq ) )
                 /* If active process is still alive */
            {
              /* Remove from readyq */
              r6 = (Process *) &(r11->readyq.head);
              while( r6->link != r11->active)
                {
                  r6 = r6->link;
                }
              r6->link = r11->active->link;
              r11->active->queuePtr = NULL;
            }
          if ( resched_flag )
            {
              if ( r11->readyq.head->finish_up != NULL )
                {
                  iprb->sequenceNo--;
                  ;asm("  popr  	$0x0fff");
                  SaveProcessContext();
                  AsmGetProcessorRecord(r11);
                  pno = GetProcessorNo(r11);
                  if (pno == 0)
                    {
 	              ;asm("   movl	$0x00150000,-(sp)");
                    }
                  else
                    {
		  /*
        	   * It is essential that the psl pushed on the stack has
		   * a non-zero ipl. If the ipl is = 0 and an
		   * interprocessor interrupt occurs while active = the idle 
		   * process, a reschedule occurs which stores the pc of the
                   * idle process as Resched which causes the idle process
                   * to loop in this routine, endlessly claiming and releasing
                   * the lock. This bug doesn't crash the kernel but it kills
     		   * performance.
                   */   
                  
 	              ;asm("   movl	$0x00130000,-(sp)");
                    }
            	  asm("   moval	Resched,-(sp)");
                  asm("   rei");
                }
              else
                {
                  ;asm(" popr	$0x0fff");
                  asm(" jmp	Switch");
                }
            }
          break;
        default:
          break;
      }
     iprb->sequenceNo--;
     asm(" popr	$0x0fff");
     asm(" rei");
  }

/* Returns TRUE if the argument pd is the active process on some processor */ 
BooleanInt
InActiveProcessSet(pd)
  register Process *pd;
  {
    register ProcessorRec *prp = ProcessorArray;
    register unsigned i;
   
    for (i = 0; i < NProcessors; i++, prp++)
       {
         if ( pd == prp->active )
           return(TRUE);
       }
    return(FALSE);
  }

/* Kills off dead processes which are active */
void
TerminateDeadActiveProcesses()
  {
    register ProcessorRec *r11;
    register ProcessorRec *prp = ProcessorArray;
    register IPRBufferType *iprb = &IPRBuffer;
    register unsigned i;
    register Process *active;
    register Process *myactive;
    AsmGetProcessorRecord(r11);
    myactive = ActiveProcess(r11);
    for (i = 0; i < NProcessors; i++, prp++)
       {
         active = prp->active;
         if ( active != myactive && active != NULL && 
              active->localPid == INVALID_PROCESS &&
              active != &prp->idle_process )
           /*
            * Note that in some cases a RESCHEDULE request may already have
            * been sent, but the destination processor was not able to 
	    * reschedule.
            */
           {
             printx("Destroy Oth Processors pno %x pd = %x ...",i,active);
             iprb->type = RESCHEDULE;
             SendIPR(i);
           }
       }
  }

/* 
 * Invalidate the TLB on other other processors when a mapping is changed 
 */

void
InvalidateTLBOnOtherProcessors(td)
  register Team *td;
  {
    register ProcessorRec *r10;
    register ProcessorRec *pr;
    register IPRBufferType *iprb = &IPRBuffer;
    register unsigned i;
    extern ProcessorRec *KLockHolder;

    AsmGetProcessorRecord(r10);
    pr = ProcessorArray;
    for (i = 0; i < NProcessors; i++, pr++)
       {
         if ( pr != r10 && pr->active != NULL && pr->active->team == td &&
              KLockHolder == r10)
           {
#if defined(ITLB_DEBUG)
             printx("ITLB called pRec is %x, holder is %x active is %x\n", 
                     r10, KLockHolder, r10->active->localPid);
#endif
             iprb->type = MEM_INVALIDATE;
             SendIPR(i);
           }
       }
  }

/* Used by exception handlers to get the kernel lock */
void
ExceptionKLock()
  {
    Kdisable;
    asm("	tstl	_KernelLock");
    asm("	beql	acquire_lock");
    AsmGetProcessorRecord(-(sp));
    asm("	cmpl	(sp)+,_KLockHolder");
    asm("	beql	have_lock");
    asm("acquire_lock:");
    KLock();
    asm("have_lock:");
    return;
    
  }

/*
 * Service  an interprocessor request to the primary processor to do  
 * device access.
 */
DeviceService()
  {
    register IPRBufferType *iprb = &IPRBuffer;
    extern K_putchar();
    extern SystemCode ConsoleWrite();
    extern ResetMdc();
    extern SystemCode MdcRead();
    extern SystemCode MdcWrite();
    extern EnetReset();
    extern NetworkWriteDeqna();
    extern KabortDeqna();

    switch (iprb->device_function)
      {
        case K_PUTCHAR:
          K_putchar( (int) iprb->params[0] );
          break;
        case CONSOLE_WRITE:
          iprb->params[0] = (Unspec) ConsoleWrite( (Process *) iprb->params[0],
                                   (DeviceInstance *) iprb->params[1] );
          break;
        case RESET_MDC:
          ResetMdc();
          break;
        case MDC_READ:
          iprb->params[0] = (Unspec) MdcRead( (Process *) iprb->params[0],
                                   (DeviceInstance *) iprb->params[1] );
          break;
        case MDC_WRITE: 
          iprb->params[0] = (Unspec) MdcWrite( (Process *) iprb->params[0],
                                   (DeviceInstance *) iprb->params[1] );
          break;
        case ENET_RESET:
          EnetReset( (int) iprb->params[0]);
          break;
        case NETWORK_WRITE_DEQNA:
          NetworkWriteDeqna( (BufferList *) iprb->params[0]);
          break;
        case KABORT_DEQNA:
          KabortDeqna( (Process *) iprb->params[0], 
                       (ExceptionRequest *) iprb->params[1], 
                       (char *) iprb->params[2] );
          break;
        default:
          break;
      }
  }

/* Service an interprocessor request to invalidate the TLB */
void
MemoryInvalidate()
  {
    register ProcessorRec *r11;
    register unsigned r10;
    register IPRBufferType *iprb = &IPRBuffer;
    
#if 0
    AsmGetProcessorRecord(r11);
    r10 = (unsigned) iprb->params[0];
    r11->active->proc_state.ProgLenReg = r10;
    asm("  mtpr	r10,$p0lr");
#endif 0
    asm("  mtpr	$0,$tbia");
  }


/* Handler for interprocessor requests */
void
HandleIPR()
  {
    register ProcessorRec *r11;		/* r11 */
    register IPRBufferType *iprb = &IPRBuffer;
    register Process *oldprocess;
    register Process *pd;

    iprb->dest = NULL_PROCESSOR;
    switch (iprb->type)
      {
        case DEVICE_SERVICE:
          oldprocess = GetAddressableProcess();
          SetAddressableProcess(iprb->addressableProcess);
          DeviceService();
          SetAddressableProcess(oldprocess);
          break;
        case MEM_INVALIDATE:
          MemoryInvalidate();
          break;
        case RESCHEDULE:
          AsmGetProcessorRecord(r11);
          if ( r11->active->queuePtr == &r11->readyq )
             /* If active process is still alive */
            {
              /* Remove from readyq */
              Lockq(&r11->readyq);
              pd = (Process *) &(r11->readyq.head);
              while( pd->link != r11->active ) pd = pd->link;
              pd->link = r11->active->link;
              Unlockq(&r11->readyq);
              r11->active->queuePtr = NULL;
            }
        default:
          break;
      }
     iprb->sequenceNo--;
  }

/* Send a n interprocessor request */
void
SendIPR(dest)
  register unsigned dest;
  {									
    register ProcessorRec *r10;
    register IPRBufferType *iprb = &IPRBuffer;
    register unsigned myPno;
    register unsigned mySequenceNo;

    AsmGetProcessorRecord(r10);
    myPno = GetProcessorNo(r10);

    mySequenceNo = iprb->sequenceNo++;				
    if ( iprb->type == DEVICE_SERVICE ) 
      iprb->addressableProcess = GetAddressableProcess();			

    iprb->dest = dest;					
    KLockHolder = &ProcessorArray[dest];
    IPCR(dest) = FF_INTERRUPT | FF_SET; 			
    while (1)								
      {									
        if ( iprb->sequenceNo == mySequenceNo )
          {								
            KLockHolder = r10;
            return;							
          }

        /* Handle a recursive request */
        if ( iprb->dest == myPno )
          {
            HandleIPR();
            iprb->sequenceNo--;
          }   
      }									
  }

/*
 * The following code is moved to FF_SECONDARY_RESET_PC by 
 * CopyJmpInitSecondary 
 */

  asm("	JmpStart:");

  asm(" jmp	*$InitSecondaryAndHaltHandler");

  asm(" JmpEnd:");
