#include "ipl.h"

extern int	XResVec();
extern int	XMachineChk();
extern int	XKernStackInval();
extern int	XPwrFail();
extern int	XResPrivInstrn();
extern int	XXFC();
extern int	XOperandReserved();
extern int	XAddrModeReserved();
extern int	XAccessCntlViol();
extern int	XXlationInval();
extern int	XTracePending();
extern int	XBreakPoint();
extern int	XArithmetic();
extern int	XCHMK();
extern int	XCHME();
extern int	XCHMS();
extern int	XCHMU();
extern int	XBusTimeout();
extern int	XSoftware();
extern int	XIntervalTimer();
extern int	XUndoneEMT();
extern int	XDoneEMT();
extern int	XRxConsole();
extern int	XTxConsole();
extern int	XQ22();

static	char	*intname[] = {
		"ResVec",
		"MachineChk",
		"KernStackInval",
		"PwrFail",
		"ResPrivInstrn",
		"XFC",
		"OperandReserved",
		"AddrModeReserved",
		"AccessCntlViol",
		"XlationInval",
		"TracePending",
		"BreakPoint",
		"Arithmetic",
		"CHMK",
		"CHME",
		"CHMS",
		"CHMU",
		"BusTimeout",
		"Software",
		"IntervalTimer",
		"UndoneEMT",
		"DoneEMT",
		"RxConsole",
		"TxConsole",
		"Q22"
		};



GotAnInt(type, numparams)
int	type, numparams;
{
	register int	r11;
	int	*param = &numparams + 13;
	int	i;

	asm("	mfpr	$ipl, r11");
	printx("Got a (%d)%s, ipl is %x, %d parameters were pushed\n",
		type, intname[type], r11, numparams);
	for (i = 0; i < numparams; i++, param++) {
		printx("%d: %x\n", i, *param);
	}
	printx("pc: %x\npsl: %x\n", *param, *(param+1));
	asm("	mtpr	$0xf05, $txdb");
}

initints()
{
	register int	r11;
	static	SCB_t	*SCBB;

	/* initialize SCB */
	asm("	mfpr	$scbb, r11");
	SCBB = (SCB_t *)r11;
	for (r11 = 0; r11 < 0x100; r11++) {
		SCBB->vec[r11] = XResVec;
	}
	SCBB->vec[VecMachineChk]	= XMachineChk;
	SCBB->vec[VecKernStackInval]	= XKernStackInval;
	SCBB->vec[VecPwrFail]		= XPwrFail;
	SCBB->vec[VecResPrivInstrn]	= XResPrivInstrn;
	SCBB->vec[VecXFC]		= XXFC;
	SCBB->vec[VecOperandReserved]	= XOperandReserved;
	SCBB->vec[VecAddrModeReserved]	= XAddrModeReserved;
	SCBB->vec[VecAccessCntlViol]	= XAccessCntlViol;
	SCBB->vec[VecXlationInval]	= XXlationInval;
	SCBB->vec[VecTracePending]	= XTracePending;
	SCBB->vec[VecBreakPoint]	= XBreakPoint;
	SCBB->vec[VecArithmetic]	= XArithmetic;
	SCBB->vec[VecCHMK]		= XCHMK;
	SCBB->vec[VecCHME]		= XCHME;
	SCBB->vec[VecCHMS]		= XCHMS;
	SCBB->vec[VecCHMU]		= XCHMU;
	SCBB->vec[VecBusTimeout]	= XBusTimeout;
	for (r11 = VecBegSoftware; r11 <= VecEndSoftware; r11++)
		SCBB->vec[r11] = XSoftware;
	SCBB->vec[VecIntervalTimer]	= XIntervalTimer;
	SCBB->vec[VecUndoneEMT]		= XUndoneEMT;
	SCBB->vec[VecDoneEMT]		= XDoneEMT;
	SCBB->vec[VecRxConsole]		= XRxConsole;
	SCBB->vec[VecTxConsole]		= XTxConsole;
	for (r11 = VecQ22Base; r11 < 0x100; r11++)
		SCBB->vec[r11] = XQ22;

}
