/*
 * V Kernel - Copyright (c) 1985 by Stanford University
 *
 * Support for QVSS keyboard.  DEC calls the keyboard an LK201 and uses it
 *   with other framebuffers, so... the keyboard code is in lk201.c; only the
 *   QVSS-specific code is in this file.
 *
 * The initialization code here ("QvssKeyboardInit") is called from qvss.c.
 *
 * We only process receive interrupts, we poll for transmit interrupts
 *   because they are only done at initialization.
 *
 * $Revision: 1.11.1.4 $
 * $Locker:  $
 * $State: Exp $
 */

#include <Venviron.h>
#include "interrupt.h"
#include "qvss.h"

Call_inthandler(IntQvssUart);

/* INTERRUPT HANDLER */
void
IntQvssUart() 
  /*
   * Interrupt handler for the Qvss Uarts.
   *
   * For now we know that the only interrupts we will get are from
   * Key events from the keyboard.
   */
  {
    /* lower our IPL to something reasonable */
    asm("	mtpr	$0x14, $ipl");
    
    LK201_GotKey( 0xff &
	((qvss_reg_t *)QVSS_REGS_V)->regs[QV_UBUFF+UARTAOFFS] );
  }

static void 
QvssKeyboardPutchar( c )
    int c;
  {
    register qvss_reg_t *qvss = (qvss_reg_t *)QVSS_REGS_V;

    while (0 == (qvss->regs[QV_USCSR+UARTAOFFS] & 0x4));
    qvss->regs[QV_UBUFF+UARTAOFFS] = c;
  }

void
QvssKeyboardInit()
  {
    LK201_Init(QvssKeyboardPutchar);
  }
