/*
 * Distributed V Kernel
 * Copyright (c) 1986 by Stanford University, All rights reserved.
 *
 * Kernel MSCP disk driver, William Lees
 *
 * $Revision: 1.10.1.3 $
 * $Locker:  $
 * $State: Exp $
 */
#ifndef RQDX_H
#define RQDX_H
/*
 * This include file contains all the definitions common to the MSCP driver
 * source files.  It also contains the defintions for the RQDX disk
 * controller.
 */

#ifndef QBUSADDRESSES_H
# include "qbusaddresses.h"
#endif

/* Disk parameters */

#define NUM_RQDX_DISKS		3
#define SECSIZE			512
#define BLOCK_FACTOR		2
#define RQDX_BUFFER_BLOCKS	16
/*
 * We need to add one more block to the buffersize
 * we use to allocate DVMA map registers in case the
 * user's buffer is the maximum length, but not page alligned.
 */
#define RQDX_DISK_BUFFER_SIZE	((RQDX_BUFFER_BLOCKS + 1) * BLOCK_FACTOR * SECSIZE)

/*
 * Driver table describing state of each unit.
 */

struct rqdx_unit_info {
	unsigned short	unit_online;
	unsigned	unit_last_block;
	unsigned	unit_DMA_Address;
	SyncQueue	unit_diskq;	/* Pending IO request queue */
	Process		*CurrentPD;
	unsigned short	unit_done_setup;
	char		device_type[4];
	char		media_name[6];
};


/* At present, we recognize only a single (physical) RQDX device on the Q-bus.
 * The possible Q-bus addresses are given by the array "PossibleRqdxQBusAddrs".
 * "FindRqdxDisks()" probes these addresses, in order, and uses the first 
 * successful address, if any.
 * `Someone' should fix this code to allow more than one physical device,
 * at different Q-bus addresses.
 */
#define POSSIBLE_RQDX_QBUS_ADDRESSES { 017772154, 017772150 }
extern unsigned PossibleRqdxQBusAddrs[]; /* = POSSIBLE_RQDX_QBUS_ADDRESSES */
extern unsigned RqdxQBusAddr;		/* Set by FindRqdxDisks() */
#define RQDX_BASE_ADDRESS	qbus_device_to_v(RqdxQBusAddr)

#define PhysRqdx(qBusAddr)	qbus_device_to_p(qBusAddr)

/* Device register addresses */
#define RQDX_IP_ADDRESS		RQDX_BASE_ADDRESS
#define RQDX_SA_ADDRESS		(RQDX_BASE_ADDRESS+2)

/* Interrupt vector */
#define RQDX_INTERRUPT		3
#define VecRqdx			(128+RQDX_INTERRUPT)

/* Device registers */

struct rqdx {
	short unsigned ip;	/* Interrupt / Poll register */
	short unsigned sa;	/* Status / Address register */
};

/* Device register flags */

#define UDA_ERR		0100000 /* Error bit */
#define UDA_STEP4	0040000 /* Step 4 has started */
#define UDA_STEP3	0020000 /* Step 3 has started */
#define UDA_STEP2	0010000 /* Step 2 has started */
#define UDA_STEP1	0004000 /* Step 1 has started */
#define UDA_NV		0002000 /* No host settable interrupt vector */
#define UDA_QB		0001000 /* Controller supports Q22 bus */
#define UDA_DI		0000400 /* Controller implements diagnostics */
#define UDA_IE		0000200 /* Interrupt enable */
#define UDA_PI		0000001 /* Host requests adapter purge interrupts */
#define UDA_GO		0000001 /* Start operation, after initialization */

/* Number of comand and response packets.  ULTRIX uses 8 too */

#define NRSPL2	3		/* LOG2 number of response packets */
#define NCMDL2	3		/* LOG2 number of command packets */
#define NRSP	(1<<NRSPL2)	/* Actual number of response packets */
#define NCMD	(1<<NCMDL2)	/* Actual number of command packets */

/* RQDX communications area */

struct rqdx_ca {
	short		ca_xxx1;	/* Unused */
	char		ca_xxx2;	/* Unused */
	char		ca_bdp;		/* Buffered data path to purge */
	short		CommandInterrupt; /* Command ring interrupt flag */
	short		ResponseInterrupt; /* Response ring interrupt flag */
	unsigned	ResponseDesc[NRSP]; /* Response packet descriptors */
	unsigned	CommandDesc[NCMD]; /* Command packet descriptors */
};

/* Packet descriptor modifiers */

#define UDA_OWN		0x80000000 /* RQDX owns this descriptor */
#define UDA_INT		0x40000000 /* Allow interrupt on ring transition */
#define UDA_MAP		0x80000000 /* Modifier for mapped buffer desc's */

/* Driver Interrupt States (software) */

#define S_IDLE	0	/* Not initialized */
#define S_STEP1	1	/* Doing init step 1 */
#define S_STEP2	2	/* Doing init step 2 */
#define S_STEP3	3	/* Doing init step 3 */
#define S_SCHAR	4	/* Doing "set controller characteristics" */
#define S_RUN	5	/* Running */

unsigned char FindRqdxDisks _TAKES(());
void BuildSysMap_Rqdx _TAKES(());
void RqdxDoUnitSetup _TAKES((int));
ResponseCode RqdxPowerup _TAKES(());
#endif RQDX_H
