/*
 * V Kernel - Copyright (c) 1985 by Stanford University, All rights reserved.
 *
 * scanx - printx's counterpart
 * not yet it isn't
 *
 * $Revision: 1.5.1.2 $
 * $Locker:  $
 * $State: Exp $
 */

#include "process.h"
#include "debugger.h"
#include "processor.h"


/* scanx(buffer)
	char *buffer;  buffer to place string into
	
*/

void
scanx(buffer)
char *buffer;
{

	for(;;)
	{
		int	ch;

		switch((ch = K_getchar()))
		{
			case '\n': /* echo the newline */
				KernelPutChar('\n');
				*buffer = '\0'; /* mark end of string */
				return;
			case 127: /* delete */
			case 17: /* ^h */
				buffer--;
				*buffer = ' ';
				KernelPutChar('\010');
				KernelPutChar(' ');
				KernelPutChar('\010');
				break;
			default:
				KernelPutChar(ch);
				*buffer = ch;
				buffer++;
				break;
		}
	}
}

