/*
 * V Kernel - Copyright (c) 1985 by Stanford University, All rights reserved.
 *
 * $Revision: 1.3.1.2 $
 * $Locker:  $
 * $State: Exp $
 */

#include "externals.h"
#include "uvaxmemory.h"
#include "asmdefs.h"
#include <Venviron.h>
#include <Vquerykernel.h>

extern MachineConfigurationReply MachineConfig;

void
Reboot()
  {
    printx("<<< If I don't manage to reboot myself, please reboot me >>>\n");
    switch (MachineConfig.processor)
      {
	case PROC_UVAX1:
	    ;asm("	mtpr	$0xf04, $txdb"); /* "reboot in progress" off */
	     asm("	mtpr	$0xf02, $txdb"); /* .. and ask for a reboot. */
	    break;
	case PROC_UVAX2:

#define CPMBX (* (char *)(uvax2_local_io_v + 0x3801c) )
		/* Console Program Mailbox; a location in the clock chip's */
		/*   battery-backed RAM, used for communication between the*/
		/*   Console Rom and the operating system		   */
	    CPMBX = (CPMBX & ~0x0f) | 0x02;
			/* ^        ^ Set Halt-Action field to "reboot, if   */
			/* ^	      that fails, halt"			     */
			/* ^ clear Restart-In-Progress, Boot-In-Progress and */
			/*   Halt-Action fields				     */
	    asm("	halt");
	    break;
	default:
	    asm("	halt");
      }
    printx("Aaargh - didn't manage to reboot or even to halt\n");
    printx("       - going into tight loop...\n");
    while (1)
      { }
  }
