/*
 * Assignment of physical addresses in MicroVAX I, II and Firefly.
 *
 *	UVAX	constants are true of all three machines
 *	UVAX1	    "		   "  I only
 *	UVAX2	constants are true of II AND Firefly
 *	FF	constants are true of Firefly only
 *
 * Note that on the Firefly some of these constants, particularly ones related
 *   to the Q-Bus, are only valid on the main (#0) processor.
 *
 * $Revision: 1.3.1.4 $
 * $Locker:  $
 * $State: Exp $
 */

#ifndef  UVAXMEMORY_H
#define  UVAXMEMORY_H

#define	UVAX_LOCAL_MEM_P	0x0000000	/* Processor's RAM memory:   */
#define	UVAX1_LOCAL_MEM_SIZE	0x0400000	/*   I uses Q-Bus memory     */
#define	UVAX2_LOCAL_MEM_SIZE	0x1000000	/*   II has 16Mb maximum,    */
		/* Firefly actually uses last few pages for various hacks    */

#define	UVAX_Q22_IO_P		0x20000000	/* Window into Q-Bus I/O     */
#define	UVAX_Q22_IO_SIZE	0x00002000	/*   (register) space	     */
#define	UVAX_Q22_IO_BASE	0x003fe000	/* First Q-Bus I/O address   */
						/*   mapped (octal 017760000)*/

#define	UVAX2_HALT_ROM_P	0x20040000	/* Console/boot ROM (64K).   */
#define	UVAX2_RUN_ROM_P		0x20050000	/*   Executing it at first   */
#define	UVAX2_ROM_SIZE		0x00010000	/*   64K disables halts.     */

#define	UVAX2_LOCAL_IO_P	0x20080000	/* Processor's private funny */
#define	UVAX2_LOCAL_IO_SIZE	0x00040000	/*   registers etc.	     */
extern char *uvax2_local_io_v;			/* The virtual address at    */
						/*   which we map LOCAL_IO   */

						/* Window on Q-bus memory:   */
#define UVAX1_Q22_MEM_P		0x00000000	/*   I is same as main memory*/
#define UVAX2_Q22_MEM_P		0x30000000	/*   II is separate	     */
#define	UVAX_Q22_MEM_SIZE	0x00400000	/*   all map full 22 bits    */
#define UVAX_Q22_MEM_BASE	0x00000000	/* First Q-Bus address mapped*/

/*
 * Offsets in the UVAX2_LOCAL_IO space on IIs and Fireflies:
 */
#define	UVAX2_BDR		0x00000	/* Boot/Diagnostic Register	     */
#define	UVAX2_MSER		0x00004	/* Memory System Error Register	     */
#define	UVAX2_CEAR		0x00008	/* CPU Error Address Register	     */
#define	UVAX2_DEAR		0x0000C	/* DMA Error Address Register	     */
#define	UVAX2_QMAP_START	0x08000	/* Q-Bus Map (8192 4-byte registers) */
#define	UVAX2_QMAP_SIZE		0x08000
#define	UVAX2_TOY_START		0x38000	/* Clock, battery-backed RAM	     */
#define	UVAX2_TOY_SIZE		0x00080	/*   (64 bytes on 2-byte boundaries) */

/*
 * Qbus memory map.  This maps Q-bus memory addresses, generated by DMA
 * devices on the Q-bus, to addresses in the CPU's local memory space.
 * The MicroVAX I doesn't have any local memory (it's all on the Q-bus)
 * so this map is unnecessary.
 */
#define QBMAP_Valid		(1<<31)
#define QBMAP_NumEntries	(0x2000)

/*
 * MicroVAX II Memory System Error Register.  Bits marked with an 'X' are
 *   cleared by writing 1 to them.
 */
#define	MSER_PAR_ENB	0x00000001 /*   Parity (error detection) enable	*/
#define	MSER_WRW_PAR	0x00000002 /*   Write wrong parity		*/

#define	MSER_MS_LEB	0x00000008 /* X Memory System Lost Error Bit	*/
#define	MSER_DMA_QPE	0x00000010 /* X DMA Q-Bus Parity Error		*/
#define	MSER_CPU_QPE	0x00000020 /* X CPU Q-Bus Parity Error		*/
#define	MSER_CPU_LPE	0x00000040 /* X CPU Local Parity Error		*/
#define	MSER_CPU_NXM	0x00000080 /* X CPU NoneXistent Memory error	*/
#define	MSER_MEM_mask	0x00000300
#define	MSER_MEM_pos	8
int Probe _TAKES(( short *, unsigned));
unsigned GetMemorySize _TAKES((unsigned));
void BasicInit_SpecificVAX _TAKES(());
void BuildSysMap_SpecificVAX _TAKES(());
void InitMem_SpecificVAX _TAKES(());
void AllocateDvmaSpace _TAKES(( unsigned, unsigned *));
void AllocateAlignedDvmaSpace _TAKES(( unsigned, unsigned *, unsigned));
void MapDvma _TAKES(( char **, char *, unsigned));
int MachineCheckMagic _TAKES(());
#endif UVAXMEMORY_H
