/*	@(#)memvar.h 1.23 84/04/04 SMI	*/

/*
 * Copyright (c) 1983 by Sun Microsystems, Inc.
 */

/*
 * A memory pixrect is a special type of pixrect.  Its image resides in
 * memory, in a publicly known format permitting more direct access to the
 * image than possible with the general pixrectops.
 *
 * In the memory pixrect the image is stored in consecutive
 * memory locations, across the row from left to right, and then from top
 * row to bottom.  Row boundaries come at shortword boundaries whence
 * rows have an even number of bytes.
 *
 * The depth of a pixel is the number of bits required to represent it.
 * Pixels are placed in consecutive fields of width the depth of each pixel,
 * with placement being independent of word or byte boundaries.
 */
struct mpr_data {
	int	md_linebytes;	/* number of bytes from one line to next */
	short	*md_image;	/* word address */
	struct	pr_pos md_offset;
	short	md_primary;
	short	md_flags;	/* Flag bits, see below */
};

/*
 * Bits from md_flags:
 */
/* 				Reverse video on this pixrect.  This bit
 *				can only be on when MP_DISPLAY is on */
#define MP_REVERSEVIDEO	1
/*				This pixrect is a bw2 device, not plain mem */
#define MP_DISPLAY	2

#define mpr_d(pr)							\
	((struct mpr_data *)(pr)->pr_data)
#define	mpr_linebytes(x, depth)						\
	( ((pr_product(x, depth) + 15) >> 3) &~ 1)
#define mpr_prlinebytes(mpr)						\
	mpr_linebytes((mpr)->pr_size.x, (mpr)->pr_depth)
#define	mpr_mdlinebytes(mpr)						\
	(mpr_d(mpr)->md_linebytes)

#define mprd_addr(mprd, xo, yo)						\
	((short *)(							\
	    (int)(mprd)->md_image                                       \
	    + pr_product((mprd)->md_linebytes,(mprd)->md_offset.y+(yo)) \
	    + (((mprd)->md_offset.x+(xo)) >> 3) &~ 1))
#define mprd8_addr(mprd, xo, yo, d)					\
	 ((u_char *)(							\
	     (int)(mprd)->md_image					\
	    + pr_product((mprd)->md_linebytes,(mprd)->md_offset.y+(yo)) \
	    + (pr_product((mprd)->md_offset.x+(xo), (d)) >> 3) )  )

#define	mprd_skew(mprd, xo, yo)						\
	(((mprd)->md_offset.x + (xo)) & 15)
#define	mprs_addr(mprs)		_mprs_addr(&(mprs))
#define	mprs8_addr(mprs)	_mprs8_addr(&(mprs))
#define	mprs_skew(mprs)		_mprs_skew(&(mprs))
short	*_mprs_addr();
u_char	*_mprs8_addr();
int	_mprs_skew();

/*
 * Static pixrects.  A pixrect may be created at compile time using the
 * mpr_static macro as part of the static declarations of a program.  Thus
 * mpr_static(cursor, 16, 16, 1, rawcursordata);
 * will declare and initialize (using rawcursordata) the storage needed
 * for a pixrect that may be referred to as 'cursor' subsequently in the
 * same file, or as &cursor if a pointer to that pixrect is called for rather
 * than the pixrect itself.
 */

#ifndef lint
#define mpr_static(name, w, h, d, image)				\
	struct	mpr_data name/**/_data =				\
	    {mpr_linebytes(w,d), (short *)(image), {0, 0}, 0, 0};	\
	extern struct pixrectops mem_ops;				\
	struct	pixrect name =						\
	    {&mem_ops, w, h, d, (caddr_t)&name/**/_data}
#else /* Temporary hack to get the mpr_static macro through lint */
#define mpr_static(name, w, h, d, image)				\
	struct  pixrect name
#endif

/*
 * During rop calls need to determine if dst/src is something that
 * mem_rop() can handle.  Use the following macro to find out.
 */
#define	MP_NOTMPR(pr)	((pr)->pr_ops->pro_rop != mem_rop)

int	mem_rop();
#ifndef KERNEL
int	mem_stencil();
int	mem_batchrop();
struct	pixrect *mem_create();		/* General mpr create routine */
int	mem_destroy();
int	mem_get();
int	mem_put();
int	mem_vector();
struct	pixrect *mem_region();
#endif KERNEL
int	mem_putcolormap();
#ifndef KERNEL
int	mem_getcolormap();
int	mem_putattributes();
int	mem_getattributes();
#endif KERNEL

#ifdef KERNEL
/*
 * Always work w/o ropc in kernel.  Do this so window mouse tracker
 * can move cursor while window locked without context switching ROPC.
 */
#define	MEM_WITHOUTROPC	
#else
#define	MEM_WITHOUTROPC		/* work w/o ropc (temporarily) */
#endif KERNEL

#ifdef MEM_WITHOUTROPC
#define	MEM_CODESIZE		50
#define	MEM_CODESIZETOUNROLL	20
extern int	(*mem_lrcode())(), (*mem_rlcode())();
#endif MEM_WITHOUTROPC
