/*	@(#)reg.h 4.11 83/08/16 SMI	*/

/*
 * Copyright (c) 1983 by Sun Microsystems, Inc.
 */

/*
 * Location of the users' stored
 * registers relative to R0.
 * Usage is u.u_ar0[XX].
 */
#define	R0	(0)
#define	R1	(1)
#define	R2	(2)
#define	R3	(3)
#define	R4	(4)
#define	R5	(5)
#define	R6	(6)
#define	R7	(7)
#define	AR0	(8)
#define	AR1	(9)
#define	AR2	(10)
#define	AR3	(11)
#define	AR4	(12)
#define	AR5	(13)
#define	AR6	(14)
#define	AR7	(15)
#define	SP	(15)
#define	PS	(16)
#define	PC	(17)

/*
 * And now for something completely the same...
 *
 * NOTE: function code, access address, and instruction register
 * are valid only for bus and address error traps.
 */
#ifndef LOCORE
struct	regs {	
	int	r_dreg[8];	/* data registers */
#define r_r0	r_dreg[0]	/* r0 for portability */
	int	r_areg[8];	/* address registers */
#define r_sp	r_areg[7]	/* user stack pointer */
	short	r_buserr;	/* buserr register (on bus error only) */
	short	r_sr;		/* status register */
#define	r_ps	r_sr
	int	r_pc;		/* program counter */
	int	r_stkfmt : 4;	/* stack format */
	int		 : 2;
	int	r_vector : 10;	/* vector offset */
};
#endif
