/*	@(#)optionsw.h 1.8 84/01/17 SMI	*/

/*
 * Copyright (c) 1984 by Sun Microsystems Inc.
 */

#ifndef optionsw_defined
#define optionsw_defined

/*
 *	optionsw.h:	An option subwindow presents labels, boolean
 *	(on-off) states, enumerated choices, and text parameters for
 *	the user to set, and command buttons for the user to invoke.
 */

struct item_place  {
	struct rect	rect;
	struct		{	u_int	x : 1;
				u_int	y : 1;
				u_int	w : 1;
				u_int	h : 1;
	}	 	fixed;
};

struct string_buf {
	u_int	 limit;
	char	*data;
};

struct typed_pair {
	u_int	type;
	caddr_t	value;
};

/*		Image types						*/
#define	IM_UNKNOWN	0
#define	IM_COMPOUND	1
#define	IM_GRAPHIC	2
#define	IM_TEXT		3	/* unattributed -- assumes default font */
#define	IM_TEXTVEC	4	/* vector of TEXT pointers		*/
#define	IM_GRAPHICVEC	5	/* vector of GRAPHIC pointers		*/

/*	flags for create routines of particular item types	*/

#define OPT_ENUMBREAK	 1
#define OPT_ENUMVERTICAL 2

#define OPT_TEXTMASKED	 1

extern struct toolsw	*optsw_createtoolsubwindow();
extern caddr_t		 optsw_init();
extern			 optsw_done();
extern			 optsw_dumpsw();
extern			 optsw_dumpitem();
extern caddr_t		 optsw_getcaret();
extern caddr_t		 optsw_setcaret();
extern struct pixfont	*optsw_getfont();
extern			 optsw_setfont();
extern			 optsw_getplace();
extern			 optsw_setplace();
extern			 optsw_coltox();
extern			 optsw_linetoy();
extern int		 optsw_getvalue();
extern			 optsw_setvalue();
extern caddr_t		 optsw_nextitem();
extern int		 optsw_removeitems();
extern int		 optsw_restoreitems();
extern caddr_t		 optsw_bool();
extern caddr_t		 optsw_command();
extern caddr_t		 optsw_enum();
extern caddr_t		 optsw_label();
extern caddr_t		 optsw_text();
extern			 optsw_handlesigwinch();
extern			 optsw_selected();

#ifdef	cplus
/*
 * Library routines specifically related to optsw subwindow functions.
 */

struct toolsw
	 *optsw_createtoolsubwindow(	struct tool  *t;
					char	     *swname;
					u_int	      width,
						      height;
	  );

caddr_t	  optsw_init(	  int		 windowfd;
	  );

void	  optsw_done(	  caddr_t	 optsw;
	  );

void	  optsw_dumpsw(	  FILE		*file;
			  caddr_t	 optsw;
			  bool		 verbose
	  );
void	  optsw_dumpitem( FILE		*file;
			  caddr_t	 ip
	  );

caddr_t	  optsw_bool(	  caddr_t 	 optsw;
			  typed_pair	*label;
			  u_int		 init,
				       (*notify)();
	  );

caddr_t	  optsw_getcaret( caddr_t	 optsw;
	  );

caddr_t	  optsw_setcaret( caddr_t	 optsw;
			  caddr_t	 ip;
	  );

struct pixrect
	 *optsw_getfont( caddr_t	 optsw;
	  );

void	  optsw_setfont( caddr_t	 optsw;
			 struct pixfont	*font;
	  );

int	  optsw_getplace( caddr_t		 optsw;
			  caddr_t		 ip;
			  struct item_place	*place;
	  );

void	  optsw_setplace( caddr_t		 optsw;
			  caddr_t		 ip;
			  struct item_place	*place;
			  u_int			 reformat
	  );

void	  optsw_coltox(	  caddr_t	 optsw;
			  u_int		 col;
	  );

void	  optsw_linetoy(  caddr_t	 optsw;
			  u_int		 line;
	  );

caddr_t	  optsw_getvalue( caddr_t	 ip;
			  caddr_t	 dest;
	  );

void	  optsw_setvalue( caddr_t	 optsw;
			  caddr_t	 ip;
			  caddr_t	 value;
	  );

caddr_t	  optsw_nextitem(    caddr_t	 optsw;
			     caddr_t	 ip;
	  );

caddr_t	  optsw_removeitems( caddr_t	 optsw;
			     caddr_t	 ip;
			     u_int	 count;
			     u_int	 reformat;
	  );

caddr_t	  optsw_restoreitems(caddr_t	 optsw;
			     caddr_t	 prev;
			     caddr_t	 ip;
			     u_int	 reformat;
	  );

caddr_t	  optsw_command(  caddr_t	 optsw;
			  typed_pair	*label;
			  u_int	       (*notify)();
	  );

caddr_t	  optsw_enum(	 caddr_t	 optsw;
			 typed_pair	*label,
					*choices;
			 u_int		 flags,
					 init,
				       (*notify)();
	  );

caddr_t	  optsw_label(  caddr_t		 optsw;
			typed_pair	*label;
	  );

caddr_t	  optsw_text(	 caddr_t	 optsw;
			 typed_pair	*label;
			 char		*default;
			 u_int		 flags,
				       (*notify)();
	  );
void	  optsw_handlesigwinch( caddr_t	 optsw;
	  );

void	  optsw_selected( caddr_t	   optsw;
			  int		  *ibits;
			  int		  *obits;
			  int		  *ebits;
			  struct timeval **ibits;
	  );

#endif
#endif
