/*	@(#)ttysw.h 1.4 83/08/26 SMI	*/

/*
 * Copyright (c) 1983 by Sun Microsystems, Inc.
 */

/*
 * A tty subwindow is a subwindow type that is used to provide a
 * terminal emulation for teletype based programs.
 * It is usually a child of a tool window and doesn't worry about a border.
 *
 * The caller of ttysw_fork typically waits for the child process to die
 * before exiting.
 */

struct ttysubwindow {
	int	ttysw_placeholder;
};

extern	struct ttysubwindow *ttysw_init();
extern	int ttysw_handlesigwinch(), ttysw_selected();
extern	struct toolsw *ttysw_createtoolsubwindow();

#ifdef	cplus
/*
 * C Library routines specifically related to ttysw subwindow functions.
 */
struct	ttysubwindow *ttysw_init(int windowfd);
int	ttysw_fork(struct ttysubwindow *ttysw, char **argv,
	    int *inputmask, *outputmask, *exceptmask);
void	ttysw_becomeconsole(struct ttysubwindow *ttysw);
void	ttysw_handlesigwinch(struct ttysubwindow *ttysw);
void	ttysw_selected(struct ttysubwindow *ttysw, int *ibits, *obits, *ebits,
	    struct timeval **timer);
void	ttysw_done(struct ttysubwindow *ttysw);

/*
 * Utility for initializing toolsw as ttysw in suntool environment
 */
struct	toolsw *ttysw_createtoolsubwindow(
	struct tool *tool, char *name, short width, height);
#endif

