/*	@(#)pixfont.h 1.6 83/08/25 SMI	*/

/*
 * Copyright (c) 1983 by Sun Microsystems, Inc.
 */

/*
 * Definition of pixfonts for pixrect library.
 * Include <pixrect/pixrect.h> before this file.
 */

/*
 * A character descriptor contains the pixrect constituting the actual
 * character, the coordinates of the home (top left) of that pixrect
 * relative to the character origin (a point on the baseline near the left
 * of the character), and the distance by which to advance the origin after
 * printing this character.
 */

struct pixchar {
	struct pixrect *pc_pr;	   /* pixrect for this char */
	struct pr_pos pc_home;	   /* home coords relative to left baseline */
	struct pr_pos pc_adv;	   /* distance to next char */
};

/*
 * A font descriptor contains the width of a space (intended to be used
 * in computing backspace and tab distances), the distance between consecutive
 * baselines in the absence of any superscripting, subscripting, or similar
 * vertical monkey business, and an array of 256 character descriptors.
 */

struct pixfont {
	struct pr_size pf_defaultsize;	/* default character size */
	struct pixchar pf_char[256];
};

typedef struct pixfont PIXFONT;

PIXFONT	*pf_open();
PIXFONT	*pf_default();
struct	pr_size pf_textbatch();
struct	pr_size pf_textwidth();
