/*	@(#)scmb.h 4.8 84/01/25 SMI	*/

/*
 * Copyright (c) 1984 by Sun Microsystems, Inc.
 */

#define NLPART	NDKMAP		/* number of logical partitions (8) */

/*
 * SCSI unit block.
 */
struct scsi_unit {
	char	un_target;		/* scsi bus address of controller */
	char	un_lun;			/* logical unit number of device */
	char	un_present;		/* unit is present */
	u_char	un_scmd;		/* special command */
	struct	scsi_subroutines *un_ss;/* scsi device subroutines */
	struct	scsi_ctlr *un_c;	/* scsi ctlr */
	struct	mb_device *un_md;	/* mb device */
	struct	mb_ctlr *un_mc;		/* mb controller */
	struct	buf un_utab;		/* queue of requests */
	struct	buf un_sbuf;		/* fake buffer for special commands */
	struct	buf un_rbuf;		/* buffer for raw i/o */
	/* following are disk specific */
	struct	dk_map un_map[NLPART];	/* logical partitions */
	struct	dk_geom un_g;		/* disk geometry */
	/* following are tape specific */
	char	un_openf;		/* tape is open */
	int	un_bufcnt;		/* number of buffers in use */
	char	un_eof;			/* eof seen but not sent to user */
	int	un_next_block;		/* next record on tape */
	int	un_last_block;		/* last record of file, if known */
	char	un_read_only;		/* tape is read only */
	char	un_lastiow;		/* last i/o was write */
	short	un_status;		/* status from last sense */
	short	un_retry_ct;		/* retry count */
	short	un_underruns;		/* number of underruns */
};

struct scsi_ctlr {
	struct	scsi_ha_reg *c_har;	/* bus registers in i/o space */
	struct	scsi_cdb c_cdb;		/* command description block */
	struct	scsi_scb c_scb;		/* status completion block */
	struct	scsi_sense *c_sense;	/* sense info on errors */
	int	c_present;		/* bus is alive */
	/* current transfer: */
	struct scsi_unit *c_un;		/* scsi unit using the bus */
	int	c_baddr;		/* virtual buffer address */
	daddr_t	c_blkno;		/* current block */
	short	c_sec_left;		/* sector count for single sectors */
	short	c_cmd;			/* command (for cdb) */
	short	c_count;		/* num sectors to xfer (for cdb) */
	int	c_dma_addr;		/* dma address */
	u_short	c_dma_count;		/* byte count expected */
	short	c_retries;		/* retry count */
	short	c_restores;		/* restore count */
	char	c_wantint;		/* expecting interrupt */
};

struct	scsi_subroutines {
	int	(*ss_attach)();
	int	(*ss_start)();
	int	(*ss_mkcdb)();
	int	(*ss_intr)();
	char	*ss_devname;
};

/*
 * Defines for getting configuration parameters out of mb_device.
 */
#define	TYPE(flags)	(flags)
#define TARGET(slave)	((slave >> 3) & 07)
#define LUN(slave)	(slave & 07)

#define NUNIT		8	/* max nubmer of units per controller */

/*
 * SCSI Error codes passed to device routines.
 * The codes refer to SCSI general errors, not to device
 * specific errors.  Device specific errors are discovered
 * by checking the sense data.
 * The distinction between retryable and fatal is somewhat ad hoc.
 */
#define	SE_NO_ERROR	0
#define	SE_RETRYABLE	1
#define	SE_FATAL	2
