/*	@(#)optionsw_impl.h 1.4 84/01/17 SMI	*/

/*
 * Copyright (c) 1984 by Sun Microsystems Inc.
 */


/*	optionsw_impl.h	1.1
 *
 *	An option subwindow presents labels; boolean and enumerated choices
 *	and text parameters for the user to set, and command buttons for
 *	the user to invoke.
 */

#ifndef optionsw_impl_defined
#define optionsw_impl_defined

#include <errno.h>
#include <stdio.h>
#include <suntool/tool_hs.h>
#include <optionsw.h>
#include <user_profile.h>

struct opt_image {
	u_int	im_type;
	union {
		struct {			/*  IM_TEXT arm	*/
			char		*text;
			struct pixfont	*font;
		}		 t;
		struct pixrect	*pixrect;	/*  IM_GRAPHIC arm  */
	}	im_value;
};
typedef struct opt_image	*opt_image_handle;

struct opt_ops {
	caddr_t	(*oop_remove)();
	caddr_t	(*oop_restore)();
	int	(*oop_destroy)();
	int	(*oop_layout)();
	int	(*oop_paint)();
	int	(*oop_feedback)();
	int	(*oop_cancel)();
	int	(*oop_accept)();
	int	(*oop_getvalue)();
	int	(*oop_setvalue)();
	int	(*oop_dump)();
};
typedef	struct opt_ops *opt_ops_handle;

struct opt_item		{
	opt_ops_handle	  oi_ops;
	caddr_t	 	  oi_data;
	struct	rect	  oi_rect;
	u_int		  oi_flags;
	struct opt_item	 *oi_next;
};
typedef	struct opt_item *opt_item_handle;

#define LAY_TENDNULL	   0	/*  first 16 flags reserved for item layout  */
#define LAY_TENDMIN	   1
#define LAY_TENDMID	   2
#define LAY_TENDMAX	   3
#define LAY_TENDS	0x0F
#define LAY_HTENDS	0x03
#define LAY_VTENDS	0x0C
#define LAY_XFIXED	0x10
#define LAY_YFIXED	0x20
#define LAY_WFIXED	0x40
#define LAY_HFIXED	0x80

#define LAY_CLIENTSET	0x2000

#define OI_COMPOSITE	0x00010000
#define OI_REMOVED	0x00020000


struct opt_special {		/*  mechanism to allow global state &	*/
	caddr_t	 opsp_data;	/*  operations on items of specific type */
	int    (*opsp_handler)();	/*  e.g. caret in text fields	*/
};
#define	OPSP_NULL	0	/*  op codes to be passed as arguments	*/
#define OPSP_GET	1	/*	to the special's handler	*/
#define OPSP_SET	2	/*  others may be defined as needed	*/
#define OPSP_DISPLAY	3
#define OPSP_DESTROY	4


struct optionsw	{

	int		    opt_windowfd;
	struct pixwin	   *opt_pixwin;
	struct rect	    opt_rect;
	struct pixfont	   *opt_font;
	u_int		    opt_status;
	struct user_info    opt_user_info;
	opt_item_handle	    opt_items;
	opt_item_handle	    opt_current;
	struct opt_special  opt_caret;
/*	struct opt_special  opt_sel_primary;		Implementation TBD
 *	struct opt_special  opt_sel_secondary;
 *	struct opt_special  opt_sel_apparent;
 */
};
typedef struct optionsw	*optsw_handle;

/*			opt_status flags				*/
#define OPT_LAIDOUT	1
#define OPT_MOUSING	2
#define OPT_FLUSHING	4

#define laid_out(osw)	(osw->opt_status & OPT_LAIDOUT)
#define mousing(osw)	(osw->opt_status & OPT_MOUSING)
#define flushing(osw)	(osw->opt_status & OPT_FLUSHING)

#define	OPT_HLEAD	8
#define	OPT_VLEAD	4

#define	BIG		0x7FFF
#define	KEY_NEXT	KEY_BOTTOMRIGHT

int
optsw_nullproc();

int
optsw_fonthome();

opt_item_handle
optsw_successor();

opt_item_handle
optsw_finditem();

struct pr_size
optsw_alloclabel();

opt_item_handle
optsw_append();

#endif
