/*
 * sib.c
 *
 * sib board functions
 */

#include "sib.h"
#include "nubus.h"

#include <stdio.h>
#include <stdlib.h>

/* NOTE: "CSI" for Color SIB */
#define SIB_BOARD_NAME "SIB"

/* FIXME: Should be part of board structure */
u8 millisecond_timer;
u8 millisecond_timer_hack; /* FIXME: Just Plain Wrong. */

void increment_millisecond_timer(void)
{
    if (!millisecond_timer_hack--) {
	millisecond_timer_hack = 4;
	millisecond_timer++;

	if ((millisecond_timer & 15) == 10) millisecond_timer += 6;

	if ((millisecond_timer & 240) == 160) millisecond_timer = 0;
    }
}

nubus_result sib_read8(struct nubus_board *board, u32 address, u8 *data)
{
    printf("sib_read8: 0x%06lx.\n", address);

    if (address == 0xfffe00) {
	*data = 0x00;
    } else if (address == 0xffff04) {
	*data = 0xc3;
    } else if (address == 0xffff38) {
	*data = 0x00;
    } else if (address == 0xffff3c) {
	*data = 0xfe;
    } else if (address == 0xffff40) {
	*data = 0xff;
    } else if (address == 0xffff84) {
	*data = SIB_BOARD_NAME[0];
    } else if (address == 0xffff88) {
	*data = SIB_BOARD_NAME[1];
    } else if (address == 0xffff8c) {
	*data = SIB_BOARD_NAME[2];
    } else if (address == 0xffc000) {
	printf("sib_read8: %%Memory-Configuration-Register.\n");
	return NR_BUSERR;
    } else if (address == 0xffff00) {
	printf("sib_read8: CROMO-Resource-Bits.\n");
	*data = 0x28; /* monitor, keyboard */
    } else if (address == 0xf80004) {
	printf("sib_read8: \"milli-address\".\n");
	/* This appears to be a 2-digit BCD-encoded value for elapsed time */
	*data = millisecond_timer;
	increment_millisecond_timer();
    } else if (address == 0xf80050) {
	printf("sib_read8: \"status-address\".\n");
	*data = 0;
    } else if (address == 0xf80040) {
	printf("sib_read8: \"RTC-Interrupt-Status\".\n");
	*data = 0;
    } else if (address == 0xe00080) {
	printf("sib_read8: %%SIB-TV-Video-Attribute.\n");
	*data = 0;
    } else {
	printf("sib_read8: 0x%06lx Unknown address.\n", address);
	exit(-1);
    }

    return NR_SUCCESS;
}

nubus_result sib_read16(struct nubus_board *board, u32 address, u16 *data)
{
    printf("SIB: Read to unmapped space (0x%06lx).\n", address);
    exit(-1);
}

nubus_result sib_read32(struct nubus_board *board, u32 address, u32 *data)
{
    if (address >= 0xfffe00) {
	nubus_result result;
	u8 data2;
	
	printf("SIB: 32-bit CROM access hack.\n");
	result = sib_read8(board, address, &data2);
	*data = data2;
	return result;
    }
    
    printf("SIB: Read to unmapped space (0x%06lx).\n", address);
    exit(-1);
}

nubus_result sib_write8(struct nubus_board *board, u32 address, u8 data)
{
    printf("SIB: Write to unmapped space (0x%06lx = 0x%02x).\n",
	   address, data);
    
    return NR_SUCCESS;
}

nubus_result sib_write32(struct nubus_board *board, u32 address, u32 data)
{
    printf("SIB: Write to unmapped space (0x%06lx = 0x%08lx).\n",
	   address, data);
    
    return NR_SUCCESS;
}

void sib_create(u8 slot)
{
    struct nubus_board *board;

    board = malloc(sizeof *board);
    board->read8 = sib_read8;
    board->read16 = sib_read16;
    board->read32 = sib_read32;
    board->write8 = sib_write8;
    board->write32 = sib_write32;
    board->get_memory_base = NULL;

    nubus_add_board(slot, board);

    millisecond_timer = 0;
    millisecond_timer_hack = 4;
}

/* EOF */
