    ;;; -*- cold-load:t; Mode:Common-Lisp; Package:SI; Base:10. -*-

;;;                           RESTRICTED RIGHTS LEGEND

;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.

;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151

;	** (c) Copyright 1980 Massachusetts Institute of Technology **
; Copyright (c) 1983-1989 Texas Instruments Incorporated  All Rights Reserved 

;;;
;;; Edit History
;;;
;;;                   Patch
;;;   Date    Author  Number   Description
;;;---------------------------------------------------------------------------------
;;; 02-06-86    ab     --      Derived this file from WINDOW;COLD #204.
;;; 02-12-86    te             Common Lisp conversion for VM2
;;; 03-24-86    ab             Changed :element-type '(unsigned-byte 16.) and
;;;                              friends to :type 'art-16b becuase subtypes
;;;                              won't work this early in the cold load.
;;; 10-07-86    te             Removed the keypad support code and made the user-interface
;;;				 functions obsolete.
;;; 11/20/86    hw             Added ISO characters.
;;;  1/09/87    te             Add back the keypad support which was deleted on 11/20/86.
;;;				 Also changed explorer character constants to the equivalent
;;;				 reader macros so that one can generate a hardcopy of this
;;;				 file and be able to get some meaning out of those characters
;;;  3/23/87    hw             Added U-umlaut and i-accute-accent; moved Greek Mu to S-Sh-m.
;;;  4/15/87	DNG	       Add NOTINLINE proclamation for dummy BEEP function. [SPR 4841]
;;;  1/12/88    ab             Change KBD-CONVERT-TO-SOFTWARE-CHAR for MX.

#|

This file contains the basic keyboard software part of the window system
that needs to be in the cold-load.

Note that this file has to be in the SYSTEM-INTERNALS (SI) package
rather than TV because it is part of the cold-load.

|#

(DEFVAR SHIFT-LOCK-XORS NIL
  "If T, both SHIFT LOCK and SHIFT is the same as neither if the
character is alphabetic.")

;;ab 1/12/88.  Changes for MX.
(DEFUN KBD-CONVERT-TO-SOFTWARE-CHAR
       (HARD-CHAR &OPTIONAL (UPCASE-CONTROL-CHARS T))
  "Convert hardware character to software character, or NIL to ignore.
UPCASE-CONTROL-CHARS if NIL means leave Meta-lowercase-letter, etc.,
not converted to upper case."
  ;; Watch out!  KBD-CONVERT-TI returns multiple values.
  (COND (tv:*mac-keyboard-p*
	 (tv:kbd-convert-mac hard-char upcase-control-chars))
	(t (KBD-CONVERT-TI HARD-CHAR UPCASE-CONTROL-CHARS)))
  )

(DEFVAR KBD-TRANSLATE-TABLE)
;Keyboard translate table is a 3 X 64 array.
;3 entries for each of 100 keys.  First is vanilla, second shift, third top.
;The function KBD-INITIALIZE is only called once, in order to setup this array.
(DEFUN KBD-INITIALIZE ()
  (SETQ KBD-TRANSLATE-TABLE (MAKE-ARRAY '(3 #o100)
					:AREA  WORKING-STORAGE-AREA
					:TYPE 'ART-8b))
;;;					:ELEMENT-TYPE '(UNSIGNED-BYTE 8))) << too early for subtypes
  (DO ((I 0 (1+ I))  ;2ND DIMENSION
       (L '(
            #\BREAK             #\BREAK         #\NETWORK
            #\TERM              #\TERM  	#\SYSTEM
            #\1                 #\!     	#\!
            #\2                 #\"     	#\"
            #\3                 #\#     	#\#
            #\4                 #\$     	#\$
            #\5                 #\%     	#\%
            #\6                 #\&     	#\&
            #\7                 #\'     	#\'
            #\8                 #\(     	#\(
            #\9                 #\)     	#\)
            #\0                 #\_     	#\_
            #\-                 #\=     	#\=
            #\@                 #\`     	#\`
            #\^                 #\~     	#\~
            #\BACKSPACE         #\BACKSPACE     #\BACKSPACE
            #\CALL              #\CALL  	#\ABORT
            #\CLEAR-INPUT       #\CLEAR-INPUT   #\CLEAR-INPUT
            #\TAB               #\TAB   	#\TAB
            #\ESCAPE            #\ESCAPE        #\ESCAPE
            #\q                 #\Q     	#\AND-SIGN
            #\w                 #\W     	#\OR-SIGN
            #\e                 #\E     	#\UP-HORSESHOE
            #\r                 #\R     	#\DOWN-HORSESHOE
            #\t                 #\T     	#\LEFT-HORSESHOE
            #\y                 #\Y     	#\RIGHT-HORSESHOE
            #\u                 #\U     	#\NOT-SIGN
            #\i                 #\I     	#\CIRCLE-X
            #\o                 #\O     	#\DOWN-ARROW
            #\p                 #\P     	#\UP-ARROW
            #\[                 #\{     	#\{
            #\]                 #\}     	#\}
            #\\                 #\|     	#\|
            #\/                 #\INFINITY      #\INFINITY
            #\PLUS-MINUS        #\DELTA 	#\CENTER-DOT
            #\CIRCLE-PLUS       #\GAMMA 	#\GAMMA
            #\PAGE              #\PAGE  	#\PAGE
            #\DELETE            #\DELETE        #\DELETE
            #\RUBOUT            #\RUBOUT	#\RUBOUT
            #\a                 #\A     	#\LESS-OR-EQUAL
            #\s                 #\S     	#\GREATER-OR-EQUAL
            #\d                 #\D     	#\EQUIVALENCE
            #\f                 #\F     	#\PARTIAL-DELTA
            #\g                 #\G     	#\NOT-EQUALS
            #\h                 #\H     	#\HELP
            #\j                 #\J     	#\LEFT-ARROW
            #\k                 #\K     	#\RIGHT-ARROW
            #\l                 #\L     	#\DOUBLE-ARROW
            #\;                 #\+     	#\+
            #\:                 #\*     	#\*
            #\RETURN            #\RETURN    	#\END
            #\LINE              #\LINE  	#\LINE
            #\BACK-NEXT         #\BACK-NEXT 	#\BACK-NEXT
            #\z                 #\Z     	#\ALPHA
            #\x                 #\X     	#\BETA
            #\c                 #\C     	#\EPSILON
            #\v                 #\V     	#\LAMBDA
            #\b                 #\B     	#\PI
            #\n                 #\N     	#\UNIVERSAL-QUANTIFIER
            #\m                 #\M     	#\EXISTENTIAL-QUANTIFIER
            #\,                 #\<     	#\<
            #\.                 #\>     	#\>
            #\/                 #\?     	#\?
            #\SPACE             #\SPACE    	#\SPACE
            ) (CDDDR L)))
      ((NULL L))
    (SETF (AREF  KBD-TRANSLATE-TABLE 0 I) (CAR L))
    (SETF (AREF  KBD-TRANSLATE-TABLE 1 I) (CADR L))
    (SETF (AREF  KBD-TRANSLATE-TABLE 2 I) (CADDR L))))  

;;;These two variables are bit masks for the shifting keys held down.
;;;Bit numbers are the same as those in the all-keys-up code sent by the
;;;keyboard, i.e.
;;;	0 shift		3 caps lock	6 super		9 mode lock
;;;	1 greek		4 control	7 hyper		10 repeat
;;;	2 top		5 meta		8 alt lock
;;;There are two variables so that if both shifts of a given type are pushed
;;;down. then one is released, we can tell what's going on.
(DEFVAR KBD-LEFT-SHIFTS  0)
(DEFVAR KBD-RIGHT-SHIFTS 0)

;; Too early for subtypes here
(DEFVAR KBD-KEY-STATE-ARRAY			;1 if key with that ascii code is down
	(MAKE-ARRAY #o400 :TYPE 'ART-1B :AREA PERMANENT-STORAGE-AREA))
(DEFVAR KBD-KEY-STATE-ARRAY-16B			;For fast clearing of above array
	(MAKE-ARRAY #o20 :TYPE 'ART-16B :AREA PERMANENT-STORAGE-AREA
		    :DISPLACED-TO KBD-KEY-STATE-ARRAY))

(DEFVAR SAVED-FIRST-CHAR 0)     ; Put first char of pair here while waiting for second

;;; Do the right thing if the "software character" read out of kbd-new-table had
;;; bit 15 set.  If bit 14 is set then the key is undefined.  Otherwise we should update 
;;; kbd-left-shifts and kbd-right-shifts.
(DEFUN KBD-BIT-15-ON (SOFT-CHAR DOWN-P)
  (IF (LOGTEST (EXPT 2 14.) SOFT-CHAR)  ; An undefined key  
      (AND DOWN-P (KBD-CONVERT-BEEP))
      ;; Not illegal, must be shift code for kbd-shifts.
    (LET ((BOOLE (IF DOWN-P 7 2))
	  (BIT (LSH 1 (LOGAND SOFT-CHAR #o37))))
      (IF (LOGTEST #o40 SOFT-CHAR)
	  (SETQ KBD-RIGHT-SHIFTS (BOOLE BOOLE BIT KBD-RIGHT-SHIFTS))
          (SETQ KBD-LEFT-SHIFTS  (BOOLE BOOLE BIT KBD-LEFT-SHIFTS)))))
  NIL)

(DEFUN KBD-CONVERT-BEEP ()
  (BEEP))

(PROCLAIM '(NOTINLINE BEEP)) ; don't do inline expansion of this temporary dummy definition.
(DEFUN BEEP (&OPTIONAL &REST IGNORE))

(PROCLAIM '(SPECIAL KBD-TI-TABLE))  	;Array used as translation table.
;;;The second dimension is 200 long and indexed by keycode.
;;;The first dimension is the shifts:
;;; 0 unshifted
;;; 1 shift
;;; 2 symbol (top)                   
;;; 3 shift symbol (greek)
;;; 4 ?
;;; 5 repeatable
;;;Elements in the table are 16-bit unsigned numbers.
;;;Bit 15 on and bit 14 on means undefined code, ignore and beep.
;;;Bit 15 on and bit 14 off means low bits are shift for bit in KBD-SHIFTS
;;;   (40 octal for right-hand key of a pair)
;;;Bit 15 off is ordinary code.

(DEFVAR ESCAPE-FLAG NIL)			; Escape code (received t)
(DEFVAR LOCK-BITS 0)				; Status of lock keys 




;;;OBSOLETE KEYPAD STUFF.  The keypad facility has been moved to a window, which is
;;;where it should have been in the first place.

(DEFVAR TV:KEYPAD-IN-APPLICATION-MODE-P NIL
  "Indicates the state of the keypad on the keyboard.
NIL -- keypad acts as indicated on the keycaps.

T -- keypad keys return a character code who's name is formed from
     KEYPAD-name, where name is the label on the keycap.  Exceptions
     are the special characters, which are spelled out (for example the
     keypad key labelled, would have a character code name of
     KEYPAD-COMMA).")

(COMPILER:MAKE-OBSOLETE TV:SETUP-KEYPAD-MODE "Use the KEYPAD option in a window instead")
(DEFUN TV:SETUP-KEYPAD-MODE ()
  (SETQ TV:KEYPAD-IN-APPLICATION-MODE-P NIL))

(COMPILER:MAKE-OBSOLETE TV:SETUP-APPLICATION-MODE "Use the KEYPAD option in a window instead")
(DEFUN TV:SETUP-APPLICATION-MODE ()
  (SETQ TV:KEYPAD-IN-APPLICATION-MODE-P T))




;;; The following are TI scan code constants used to augment the
;;; keyboard tables.  Specifically, they are used to implement mode
;;; lock.
(DEFCONSTANT SCAN-CODE-HELP              #o001) 
(DEFCONSTANT SCAN-CODE-CAPS-LOCK         #o003)
(DEFCONSTANT SCAN-CODE-BOLD-LOCK         #o004)
(DEFCONSTANT SCAN-CODE-ITAL-LOCK         #o005)
(DEFCONSTANT SCAN-CODE-MODE-LOCK         #o006)
(DEFCONSTANT SCAN-CODE-LEFT-HYPER        #o007)
(DEFCONSTANT SCAN-CODE-SYSTEM            #o010)
(DEFCONSTANT SCAN-CODE-NETWORK           #o011)
(DEFCONSTANT SCAN-CODE-STATUS            #o012)
(DEFCONSTANT SCAN-CODE-TERMINAL          #o013)
(DEFCONSTANT SCAN-CODE-CLEAR-SCREEN      #o015)
(DEFCONSTANT SCAN-CODE-CLEAR-INPUT       #o016)
(DEFCONSTANT SCAN-CODE-UNDO              #o017)
(DEFCONSTANT SCAN-CODE-END               #o020)
(DEFCONSTANT SCAN-CODE-LEFT              #o021)
(DEFCONSTANT SCAN-CODE-MIDDLE            #o022)
(DEFCONSTANT SCAN-CODE-RIGHT             #o023)
(DEFCONSTANT SCAN-CODE-F1                #o024)
(DEFCONSTANT SCAN-CODE-F2                #o025)
(DEFCONSTANT SCAN-CODE-F3                #o026)
(DEFCONSTANT SCAN-CODE-F4                #o027)
(DEFCONSTANT SCAN-CODE-LEFT-SUPER        #o032)
(DEFCONSTANT SCAN-CODE-LEFT-META         #o033)
(DEFCONSTANT SCAN-CODE-LEFT-CONTROL      #o034)
(DEFCONSTANT SCAN-CODE-RIGHT-CONTROL     #o035)
(DEFCONSTANT SCAN-CODE-RIGHT-META        #o036)
(DEFCONSTANT SCAN-CODE-RIGHT-SUPER       #o037)
(DEFCONSTANT SCAN-CODE-RIGHT-HYPER       #o040)
(DEFCONSTANT SCAN-CODE-RESUME            #o041)
(DEFCONSTANT SCAN-CODE-ALT               #o043)
(DEFCONSTANT SCAN-CODE-1                 #o044)
(DEFCONSTANT SCAN-CODE-2                 #o045)
(DEFCONSTANT SCAN-CODE-3                 #o046)
(DEFCONSTANT SCAN-CODE-4                 #o047)
(DEFCONSTANT SCAN-CODE-5                 #o050)
(DEFCONSTANT SCAN-CODE-6                 #o051)
(DEFCONSTANT SCAN-CODE-7                 #o052)
(DEFCONSTANT SCAN-CODE-8                 #o053)
(DEFCONSTANT SCAN-CODE-9                 #o054)
(DEFCONSTANT SCAN-CODE-0                 #o055)
(DEFCONSTANT SCAN-CODE-MINUS             #o056)
(DEFCONSTANT SCAN-CODE-EQUALS            #o057)
(DEFCONSTANT SCAN-CODE-BACK-QUOTE        #o060)
(DEFCONSTANT SCAN-CODE-TILDE             #o061)
(DEFCONSTANT SCAN-CODE-KEYPAD-EQUAL      #o062)
(DEFCONSTANT SCAN-CODE-KEYPAD-PLUS       #o063)
(DEFCONSTANT SCAN-CODE-KEYPAD-SPACE      #o064)
(DEFCONSTANT SCAN-CODE-KEYPAD-TAB        #o065)
(DEFCONSTANT SCAN-CODE-BREAK             #o066)
(DEFCONSTANT SCAN-CODE-TAB               #o070)
(DEFCONSTANT SCAN-CODE-Q                 #o071)
(DEFCONSTANT SCAN-CODE-W                 #o072)
(DEFCONSTANT SCAN-CODE-E                 #o073)
(DEFCONSTANT SCAN-CODE-R                 #o074)
(DEFCONSTANT SCAN-CODE-T                 #o075)
(DEFCONSTANT SCAN-CODE-Y                 #o076)
(DEFCONSTANT SCAN-CODE-U                 #o077)
(DEFCONSTANT SCAN-CODE-I                 #o100)
(DEFCONSTANT SCAN-CODE-O                 #o101)
(DEFCONSTANT SCAN-CODE-P                 #o102)
(DEFCONSTANT SCAN-CODE-OPEN-PARENTHESIS  #o103)
(DEFCONSTANT SCAN-CODE-CLOSE-PARENTHESIS #o104)
(DEFCONSTANT SCAN-CODE-BACKSLASH         #o106)
(DEFCONSTANT SCAN-CODE-UP-ARROW          #o107)
(DEFCONSTANT SCAN-CODE-KEYPAD-7          #o110)
(DEFCONSTANT SCAN-CODE-KEYPAD-8          #o111)
(DEFCONSTANT SCAN-CODE-KEYPAD-9          #o112)
(DEFCONSTANT SCAN-CODE-KEYPAD-MINUS      #o113)
(DEFCONSTANT SCAN-CODE-ABORT             #o114)
(DEFCONSTANT SCAN-CODE-RUBOUT            #o117)
(DEFCONSTANT SCAN-CODE-A                 #o120)
(DEFCONSTANT SCAN-CODE-S                 #o121)
(DEFCONSTANT SCAN-CODE-D                 #o122)
(DEFCONSTANT SCAN-CODE-F                 #o123)
(DEFCONSTANT SCAN-CODE-G                 #o124)
(DEFCONSTANT SCAN-CODE-H                 #o125)
(DEFCONSTANT SCAN-CODE-J                 #o126)
(DEFCONSTANT SCAN-CODE-K                 #o127)
(DEFCONSTANT SCAN-CODE-L                 #o130)
(DEFCONSTANT SCAN-CODE-SEMICOLON         #o131)
(DEFCONSTANT SCAN-CODE-APOSTROPHE        #o132)
(DEFCONSTANT SCAN-CODE-RETURN            #o133)
(DEFCONSTANT SCAN-CODE-LINE              #o134)
(DEFCONSTANT SCAN-CODE-LEFT-ARROW        #o135)
(DEFCONSTANT SCAN-CODE-HOME              #o136)
(DEFCONSTANT SCAN-CODE-RIGHT-ARROW       #o137)
(DEFCONSTANT SCAN-CODE-KEYPAD-4          #o140)
(DEFCONSTANT SCAN-CODE-KEYPAD-5          #o141)
(DEFCONSTANT SCAN-CODE-KEYPAD-6          #o142)
(DEFCONSTANT SCAN-CODE-KEYPAD-COMMA      #o143)
(DEFCONSTANT SCAN-CODE-LEFT-SYMBOL       #o146)
(DEFCONSTANT SCAN-CODE-LEFT-SHIFT        #o147)
(DEFCONSTANT SCAN-CODE-Z                 #o150)
(DEFCONSTANT SCAN-CODE-X                 #o151)
(DEFCONSTANT SCAN-CODE-C                 #o152)
(DEFCONSTANT SCAN-CODE-V                 #o153)
(DEFCONSTANT SCAN-CODE-B                 #o154)
(DEFCONSTANT SCAN-CODE-N                 #o155)
(DEFCONSTANT SCAN-CODE-M                 #o156)
(DEFCONSTANT SCAN-CODE-COMMA             #o157)
(DEFCONSTANT SCAN-CODE-PERIOD            #o160)
(DEFCONSTANT SCAN-CODE-QUESTION          #o161)
(DEFCONSTANT SCAN-CODE-RIGHT-SHIFT       #o162)
(DEFCONSTANT SCAN-CODE-RIGHT-SYMBOL      #o164)
(DEFCONSTANT SCAN-CODE-DOWN-ARROW        #o165)
(DEFCONSTANT SCAN-CODE-KEYPAD-1          #o166)
(DEFCONSTANT SCAN-CODE-KEYPAD-2          #o167)
(DEFCONSTANT SCAN-CODE-KEYPAD-3          #o170)
(DEFCONSTANT SCAN-CODE-SPACE             #o173)
(DEFCONSTANT SCAN-CODE-KEYPAD-0          #o175)
(DEFCONSTANT SCAN-CODE-KEYPAD-PERIOD     #o176)
(DEFCONSTANT SCAN-CODE-KEYPAD-ENTER      #o177)

(DEFVAR MODE-LOCK-MAPPING-ALIST
        `((,SCAN-CODE-UP-ARROW    #\MOUSE-M-2)
          (,SCAN-CODE-DOWN-ARROW  #\MOUSE-M-3)
          (,SCAN-CODE-LEFT-ARROW  #\MOUSE-L-2)
          (,SCAN-CODE-RIGHT-ARROW #\MOUSE-R-2))
  "Used to implement a keyboard variant when the MODE LOCK key is
on (the light on the MODE LOCK key is lit).  Each element of this list
is a pair.  The first element of the pair is the scan code for a key on
the keyboard.  The second element of the pair is the software
character code to be produced when the corresponding key on the
keyboard is pressed.  Note that the mouse characters are handled
specially -- they cause the mouse to move.  This mapping is only done
when the user is in MODE LOCK mode.")


;The sequence of hardware codes for a key, a, depressed and released is the following:
;   400320 400120 400000 400200
(DEFUN KBD-CONVERT-TI (CHAR &OPTIONAL (CTL-CHARS-UPPERCASE T))
  "Keystroke conversion routine to support the TI keyboard."
  ;; Changed 08/20/84 to return the ascii character plus a repeatable flag (nil or t)
  (SETQ CHAR (LOGAND #o377 CHAR))               ;strip off source bits
  (COND
    ((NULL ESCAPE-FLAG)				;is it not after an escape char?
     (COND ((LOGTEST (EXPT 2 7) CHAR)          ;up or down code?
	    (SETQ CHAR (LOGAND #o177 CHAR))	;strip off down bit
	    (MULTIPLE-VALUE-BIND (SOFT-CHAR UNSHIFTED-SOFT-CHAR)
		(TI-LOOKUP CHAR)
	      (COND ((LOGTEST (EXPT 2 15.) SOFT-CHAR)
		     (KBD-BIT-15-ON SOFT-CHAR T)
		     (SETQ SAVED-FIRST-CHAR NIL))	;clear previously-saved characters
		    (T                          ;normal character
		     (SETF (AREF KBD-KEY-STATE-ARRAY UNSHIFTED-SOFT-CHAR)  1)   ;set bitmap bit
                                                ;A real key depression.  Check for caps-lock.
		     (LET ((KBD-SHIFTS (LOGIOR KBD-LEFT-SHIFTS KBD-RIGHT-SHIFTS)))
						;Hyper, Super, Meta, Control bits
		       (SETQ UNSHIFTED-SOFT-CHAR (LDB (BYTE 4 4) KBD-SHIFTS))
		       (IF (AND CTL-CHARS-UPPERCASE
				(NOT (ZEROP UNSHIFTED-SOFT-CHAR)))
			   (IF (<= #\a SOFT-CHAR #\z)
			       (DECF SOFT-CHAR #o40)	;Control characters always uppercase,
			       (IF (<= #\A SOFT-CHAR #\Z)	;unless  Shift is typed
				   (INCF SOFT-CHAR #o40)))
                           (PROGN
			   ;; This code implements the MODE LOCK mode.
			   (WHEN (LOGTEST 1 LOCK-BITS)	;Mode lock
			     (SETQ SOFT-CHAR
				   (OR (CADR (ASSOC CHAR MODE-LOCK-MAPPING-ALIST :TEST #'EQ))
				       SOFT-CHAR)))
			   ;; Except for control chars for which Shift is reversed,
			   ;; consider the shift-lock key.
			   (AND (LOGTEST #o10 LOCK-BITS)        ;Caps lock
				(IF (AND SHIFT-LOCK-XORS (LOGTEST 1 KBD-SHIFTS))
				    (AND (>= SOFT-CHAR #\A)
					 (<= SOFT-CHAR #\Z)
					 (SETQ SOFT-CHAR (+ SOFT-CHAR #o40)))
				    (AND (>= SOFT-CHAR #\a)
					 (<= SOFT-CHAR #\z)
					 (SETQ SOFT-CHAR (- SOFT-CHAR #o40)))))))
		       (VALUES
			 (SETQ SAVED-FIRST-CHAR
			     (%LOGDPB UNSHIFTED-SOFT-CHAR %%KBD-CONTROL-META SOFT-CHAR))
			 (NOT (ZEROP (AREF KBD-TI-TABLE 5 CHAR)))))))))	;repeatable (t or nil)
	   (T					;0: key up or escape code
	    (COND ((ZEROP CHAR)
		   (SETQ ESCAPE-FLAG T)
		   NIL)
		  (T
		   (MULTIPLE-VALUE-BIND (SOFT-CHAR UNSHIFTED-SOFT-CHAR)
		       (TI-LOOKUP CHAR)
		     (COND ((LOGTEST (EXPT 2 15.) SOFT-CHAR)
			    (KBD-BIT-15-ON SOFT-CHAR NIL)
			    NIL)
			   (T (SETF (AREF KBD-KEY-STATE-ARRAY UNSHIFTED-SOFT-CHAR) 0)))
		     NIL))))))
    (T 
     (PROG1
       (SETQ ESCAPE-FLAG NIL)			;its a second byte (after escape byte)
       (IF (LOGTEST (EXPT 2 7) CHAR)			;all keys up?
	   (PROG1
	     (SETQ LOCK-BITS (LOGAND #o17 CHAR))
	     (SETQ KBD-LEFT-SHIFTS  0)		;all keys up, clear the status
	     (SETQ KBD-RIGHT-SHIFTS 0))))
     NIL)))



#|

Each row of the keyboard table corresponds to one key.  The columns in a
particular row are what are generated when a specific combination of
shifting keys is pressed.  These translations are:

  Column	Shifting key	Example keystroke	Resulting character
    1		none		L			l
    2		SHIFT		SHIFT-L			L
    3		SYMBOL		SYMBOL-L		 (double arrow)
    4		SYMBOL-SHIFT	symbol-SHIFT-L		 (lambda)
    5		unused column
    6		repeating flag

Note that column 5 is unused and can be removed.  It is present for
historical reasons only.  Column 6 is a flag used by the code which
generates repeating characters (i.e.  typo-matic).  If the value in this
column is NIL then that key, when held down, will not repeat.  Otherwise
the key is repeating.  This way one can make sure that certain
characters (e.g.  SYSTEM) will not repeat.

|#
;; Too early for subtypes
(DEFUN KBD-MAKE-TI-TABLE ()
  ;; Modified 08/20/84 to support repeating keys.  The 6th slot was
  ;; added to indicate key for key if it should be repeated. A positive
  ;; number in that slot indicates a repeating key.
  (LET ((TBL (MAKE-ARRAY '(6 #o200) :AREA  PERMANENT-STORAGE-AREA :ELEMENT-TYPE T)))
    (DO ((J 0 (1+ J))
         (L '( 
        ()                                                  ;0 not used
        (#\HELP #\HELP #\CALL NIL NIL NIL)                  ;1 Help  Symbol-help pops up map of keyboard 
        ()                                                  ;2 not used
        #o100003                                            ;3 Caps Lock
        ()                                                  ;4 Bold Lock
        ()                                                  ;5 Ital Lock
        #o100011                                            ;6 Mode lock
        #o100007                                            ;7 Left Hyper
        #\SYSTEM                                            ;10 system
        #\NETWORK                                           ;11 network
        #\STATUS                                            ;12 status
        #\TERM                                              ;13 terminal
        ()                                                  ;14 not used
        #\FORM                                              ;15 Clear screen
        #\CLEAR                                             ;16 Clear input
        #\UNDO                                              ;17 Undo
        #\END                                               ;20 End
        (#\MOUSE-L-1 #\MOUSE-L-1 #\MOUSE-L-1 #\MOUSE-L-1)   ;21 Left
        (#\MOUSE-M-1 #\MOUSE-M-1 #\MOUSE-M-1 #\MOUSE-M-1)   ;22 Middle
        (#\MOUSE-R-1 #\MOUSE-R-1 #\MOUSE-R-1 #\MOUSE-R-1)   ;23 Right
        #\F1                                                ;24 F1
        #\F2                                                ;25 F2
        #\F3                                                ;26 F3
        #\F4                                                ;27 F4 
        ()                                                  ;30 not used
        ()                                                  ;31 not used
        #o100006                                            ;32 Left super
        #o100005                                            ;33 Left Meta
        #o100004                                            ;34 Left control
        #o100044                                            ;35 Right control
        #o100045                                            ;36 Right Meta
        #o100046                                            ;37 Right Super
        #o100047                                            ;40 Right Hyper
        #\RESUME                                            ;41 resume
        ()                                                  ;42 not used
        (#\ESCAPE #\ESCAPE  NIL #\ACUTE-ACCENT NIL NIL)     ;43 Escape; symbol-shift-ESC = grave accent
        (#\1 #\! #\INVERTED-EXCLAMATION-MARK #o300 NIL 1)   ;44 One
        (#\2 #\@ #\AMERICAN-CENT-SIGN #o301 NIL 1)          ;45 Two
        (#\3 #\# #\BRITISH-POUND-SIGN #o302 NIL 1)          ;46 Three
        (#\4 #\$ #\CURRENCY-SIGN #o303 NIL 1)               ;47 Four
        (#\5 #\% #\JAPANESE-YEN-SIGN #o304 NIL 1)           ;50 Five
        (#\6 #\^ #\SECTION-SYMBOL #o305 NIL 1)              ;51 Six
        (#\7 #\& #\COPYRIGHT-SIGN #o306 NIL 1)              ;52 Seven
        (#\8 #\* #\FEMININE-ORDINAL-INDICATOR #o307 NIL 1)  ;53 Eight
        (#\9 #\( #\MASCULINE-ORDINAL-INDICATOR #o310 NIL 1) ;54 Nine
        (#\0 #\) #\REGISTERED-TRADEMARK #o311 NIL 1)        ;55 Zero
        (#\- #\_ #\MACRON #o312 NIL 1)                      ;56 Minus; symbol-minus = macron
        (#\= #\+ #\plus-minus #o313 NIL 1)                  ;57 Equals
        (#\` #\{ #\BROKEN-BAR #\NOT-SIGN NIL 1)             ;60 back quote
        (#\~ #\} #\} #o314 NIL 1)                           ;61 Tilde
        (#\KEYPAD-EQUAL #\KEYPAD-EQUAL #\DIVISION-SIGN #o315 NIL 1)      ;62 Keypad Equals
        (#\KEYPAD-PLUS  #\KEYPAD-PLUS #\MULTIPLICATION-SIGN #o316 NIL 1) ;63 Keypad Plus
        (#\KEYPAD-SPACE #\KEYPAD-SPACE #\KEYPAD-SPACE #o374 NIL 1)       ;64 Keypad Space
        (#\KEYPAD-TAB #\KEYPAD-TAB #\KEYPAD-TAB #o375 NIL 1)             ;65 Keypad Tab
        #\BREAK                                             ;66 Break
        ()                                                  ;67 not used
        (#\TAB #\TAB #\TAB #\TAB NIL 1)                     ;70 Tab forward and back
        (#\q #\Q #\AND-SIGN        #o317        NIL 1)      ;71 Q
        (#\w #\W #\OR-SIGN         #o320        NIL 1)      ;72 W
        (#\e #\E #\UP-HORSESHOE    #\EPSILON    NIL 1)      ;73 E
        (#\r #\R #\DOWN-HORSESHOE  #o321        NIL 1)      ;74 R
        (#\t #\T #\LEFT-HORSESHOE  #o322        NIL 1)      ;75 T
        (#\y #\Y #\RIGHT-HORSESHOE #o323        NIL 1)      ;76 Y
        (#\u #\U #\UNIVERSAL-QUANTIFIER #o324   NIL 1)      ;77 U
        (#\i #\I #\INFINITY        #o325        NIL 1)      ;100 I
        (#\o #\O #\EXISTENTIAL-QUANTIFIER #o326 NIL 1)      ;101 O
        (#\p #\P #\PARTIAL-DELTA   #\PI         NIL 1)      ;102 P
        (#\( #\[ #\PARAGRAPH-SYMBOL #o330       NIL 1)      ;103 Open parenthesis
        (#\) #\] #\] #o331 NIL 1)                           ;104 Close parenthesis
        ()                                                  ;105 not used
        (#\\ #\| #\| #o332 NIL 1)                           ;106 Backslash
        (#\UP-ARROW NIL NIL NIL NIL 1)                      ;107 Up arrow
        (#\KEYPAD-7 #\KEYPAD-7 #o354 #o333 NIL 1)           ;110 Keypad Seven ;hw
        (#\KEYPAD-8 #\KEYPAD-8 #\ESZET    #o334 NIL 1)      ;111 Keypad Eight; symbol-8 = Eszet ;hw
        (#\KEYPAD-9 #\KEYPAD-9 #o355 #o377 NIL 1)      ;112 Keypad Nine
        (#\KEYPAD-MINUS #\KEYPAD-MINUS #\SOFT-HYPHEN #o335 NIL 1) ;113 Keypad Minus; symbol-- = SHY
        #\ABORT                                             ;114 Abort
        ()                                                  ;115 not used
        ()                                                  ;116 not used
        (#\RUBOUT #\RUBOUT #\RUBOUT #\RUBOUT NIL 1)         ;117 rubout
        (#\a #\A #o363 #\ALPHA NIL 1)                       ;120 A
        (#\s #\S #o376 #o336   NIL 1)                       ;121 S
        (#\d #\D #o364 #\DELTA NIL 1)                       ;122 D/delta
        (#\f #\F #o365 #o340   NIL 1)                       ;123 F
        (#\g #\G #\UP-ARROW #\GAMMA NIL 1)                  ;124 G/gamma
        (#\h #\H #\DOWN-ARROW  #o341  NIL 1)                ;125 H
        (#\j #\J #\LEFT-ARROW  #o342  NIL 1)                ;126 J
        (#\k #\K #\RIGHT-ARROW #o343  NIL 1)                ;127 K
        (#\l #\L #\DOUBLE-ARROW #\LAMBDA  NIL 1)            ;130 L/lambda
        (#\; #\: #\CEDILLA #\PLUS-MINUS NIL 1)              ;131 Semicolon, colon, cedilla
        (#\' #\" #\DIARESIS #\CENTER-DOT NIL 1)             ;132 Apostrophe
        (#\RETURN #\RETURN #\RETURN #\RETURN NIL 1)         ;133 Return
        (#\LINE #\LINE #\LINE #\LINE NIL 1)                 ;134 Line
        (#\LEFT-ARROW NIL NIL NIL    NIL 1)                 ;135 Left arrow
        ()                                                  ;136 Home
        (#\RIGHT-ARROW NIL NIL NIL NIL 1)                   ;137 Right arrow
        (#\KEYPAD-4 #\KEYPAD-4 #\FRACTION-1/4 #o344 NIL 1)  ;140 Keypad Four
        (#\KEYPAD-5 #\KEYPAD-5 #\FRACTION-1/2 #o345 NIL 1)  ;141 Keypad Five
        (#\KEYPAD-6 #\KEYPAD-6 #\FRACTION-3/4 #o346 NIL 1)  ;142 Keypad Six
        (#\KEYPAD-COMMA #\KEYPAD-COMMA #o372  #o373 NIL 1)  ;143 Keypad comma
        ()                                                  ;144 not used
        ()                                                  ;145 not used
        #o100001                                            ;146 Left Greek (Symb)
        #o100000                                            ;147 Left Shift
        (#\z #\Z #o366               #o347 NIL 1)           ;150 Z
        (#\x #\X #o370               #o350 NIL 1)           ;151 X
        (#\c #\C #\NOT-EQUAL        #o351 NIL 1)            ;152 C
        (#\v #\V #o371               #o352 NIL 1)           ;153 V
        (#\b #\B #\EQUIVALENCE #\BETA   NIL 1)              ;154 B
        (#\n #\N #\LESS-OR-EQUAL    #o353 NIL 1)            ;155 N
        (#\m #\M #\GREATER-OR-EQUAL #\GREEK-MU  NIL  1)     ;156 M  ;hw
        (#\, #\< #\ANGLE-QUOTATION-LEFT  #\CIRCLE-PLUS NIL 1) ;157 comma
        (#\. #\> #\ANGLE-QUOTATION-RIGHT #\CIRCLE-X    NIL 1) ;160 Period

        (#\/ #\? #\INVERTED-QUESTION-MARK #\INTEGRAL   NIL 1) ;161 Question/Integral
        #o100040                                            ;162 Right Shift
        ()                                                  ;163 not used
        #o100041                                            ;164 Right Greek (Symb)
        (#\DOWN-ARROW NIL NIL NIL NIL 1)                    ;165 Down arrow
        (#\KEYPAD-1 #\KEYPAD-1 #\SUPERSCRIPT-1 #o356 NIL 1) ;166 Keypad One
        (#\KEYPAD-2 #\KEYPAD-2 #\SUPERSCRIPT-2 #o357 NIL 1) ;167 Keypad Two
        (#\KEYPAD-3 #\KEYPAD-3 #\SUPERSCRIPT-3 #o360 NIL 1) ;170 Keypad Three
        ()                                                  ;171 not used
        ()                                                  ;172 not used
        (#\SPACE #\SPACE #\SPACE #\SPACE NIL 1)             ;173 Space bar
        ()                                                  ;174 not used
        (#\KEYPAD-0 #\KEYPAD-0 #o254 #o361 NIL 1)           ;175 Keypad Zero
        (#\KEYPAD-PERIOD #\KEYPAD-PERIOD #\DEGREE-SIGN #o362 NIL 1)         ;176 Keypad Period
        (#\KEYPAD-ENTER #\KEYPAD-ENTER #\KEYPAD-ENTER #\KEYPAD-ENTER NIL 1) ;177 Keypad Enter
              ) (CDR L)))
        ((= J #o200) TBL)
      (DO ((I 0 (1+ I))
           (K (CAR L)))
          ((= I 6))
        (SETF (AREF TBL I J) (COND ((= I 5) (COND ((OR (ATOM K) (NULL (CAR K))) 0)
                                                  (T (CAR K))))
                                   ((ATOM K) (OR K #o140000))
                                   ((NULL (CAR K)) #o140000)
                                   (T (CAR K))))
        (AND (CONSP K) (SETQ K (CDR K)))))))

(DEFPARAMETER KBD-TI-TABLE (KBD-MAKE-TI-TABLE))

(DEFUN TI-LOOKUP (CHAR)
  "Get the software char corresponding to hardware char and bucky bits."
  (LET ((KBD-SHIFTS (LOGIOR KBD-LEFT-SHIFTS KBD-RIGHT-SHIFTS)))
    (VALUES (AREF KBD-TI-TABLE
		  (COND ((LOGTEST 2 KBD-SHIFTS)	;SYMBOL (same as TOP)
			 (+ (LOGAND 1 KBD-SHIFTS) 2))   ;SYMBOL-SHIFT (same as GREEK)  ;;; Steve Ford 12-12-84
			((LOGTEST 1 KBD-SHIFTS) 1)	;SHIFT
			(T 0))                          ;UNSHIFTED
		  CHAR)
            ;; We need to just get the character part of this entry
            ;; since we may have mouse characters here too.
	    (LDB %%CH-CHAR (AREF KBD-TI-TABLE 0 CHAR))))) 
