;;;-*- Mode:Common-Lisp; Package:TV; Base:10; Fonts:(CPTFONT HL12B HL12BI) -*-

;;;                           RESTRICTED RIGHTS LEGEND

;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.
;;;
;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151
;;;
;1;; Copyright (C) 1987-1989 Texas Instruments Incorporated.  All rights reserved.*


;;;
;;; Change history:
;;;
;;;  Date        Author  Description
;;; -------------------------------------------------------------------------------------
;;; 12/30/87     PMH     o Original
;;; 01-18-87     ab      o Add more symbols.
;;; 02-09-88     ab      o Improve efficiency of MX Window run-time checks by making them
;;;                      INLINEs where possible.
;;; 02-26-88     ab      o Make MAC-SYSTEM-P an INLINE now, since it is just a variable check.

;;; These definitions are included in the base window system and provide a "stubb"
;;; for "add-in" functionality.

;;; MAC Support
;;; The following three predicates will always return NIL
;;; until MX windows software gets loaded into the system.

(defvar *mac-system-p* nil)

(proclaim '(inline mac-system-p))
(defun mac-system-p ()
  "Returns true if the window system should behave as a MicroExplorer."
  *mac-system-p*)

(proclaim '(inline mac-window-p))
(defun mac-window-p (window)
  "Returns true if WINDOW was made for MicroExplorer."
  (AND window
       (NOT (ARRAYP window))
       (tv:sheet-window-id window)))

;;; This one is re-defined by WINDOW-MX, so make sure it isn't an INLINE.
(proclaim '(notinline mac-screen-p))
(defun mac-screen-p (screen)
  "Returns true if SCREEN was made for MicroExplorer."
  (declare (ignore screen))
  nil)

;;; The following functions and symbols should never be used unless we
;;; are in a MAC system, in which case the real definitions will exist.
;;; The purpose of these proclaimations is to inhibit compiler warnings
;;; for the base system.
(proclaim
  '(special *cold-load-streams-screen-selected-p*
	    *default-Mac-window-height*	    
	    *default-Mac-window-width*	    
	    *dont-clip-at-the-margins*
	    *Explorer-to-Mac-char-code-map*
	    *ignore-commands-for-the-mac*
	    *mac*
	    *mac-keyboard-p*
	    *Mac-resident-Explorer-screens*	;dab 8/24/88
	    *mac-system-p*
	    *window-system-mouse-on-the-mac*
	    *undisplaced-Mac-window-arrays*	;dab 8/24/88
	    kbd-mac-table

	    lispm-shift-bit
	    lispm-greek-bit
	    lispm-top-bit
	    lispm-capslock-bit
	    lispm-control-bit
	    lispm-meta-bit
	    lispm-super-bit
	    lispm-hyper-bit
	    lispm-altlock-bit
	    lispm-modelock-bit
	    lispm-repeat-bit

	    Mac-CONTROL-bit
	    Mac-OPTION-bit
	    Mac-CAPSLOCK-bit
	    Mac-SHIFT-bit
	    Mac-COMMAND-bit
	    Mac-MOUSE-bit
	    Mac-AUTOKEY-bit
	    Mac-Window-Activate-bit 
	    mac-explorer-screen-ID-for-screen-being-created	;dab 8/24/88
	    mac-extended-kbd-descriptor
	    mac-kbd-modifier-table
	    mac-kbd-modifier-table-zmacs-mode
	    mac-screen
	    mac-screen-for-printer		;dab 8/24/88
	    mac-standard-kbd-descriptor
	    not-visible-p			;dab 8/24/88

	))

(proclaim
  '(ftype (function (&rest t) t)
	  activate-mac-window
	  after-tv-initialized
	  analyze-last-button
	  deactivate-mac-screen
	  deactivate-mac-window
	  define-mac-resident-exp-screen
	  deselect-cold-load-streams-screen
	  display-mac-who-line
	  dump-draw-char-cache                   ;08-24-88 DAB
	  give-mouse-ownership-to-the-explorer
	  kbd-convert-mac
	  kbd-make-mac-table 
	  lispm-or-mac-mouse-wakeup
	  mac-consider-mouse
	  mac-key 
	  make-a-Mac-resident-Explorer-screen
	  make-explorer-screen			;dab 8/24/88
	  redirect-drawing-of-window-and-inferiors
	  remember-bit-array			       ;ab 10/18/88
	  remember-this-screens-last-selected-window
	  select-cold-load-streams-screen
	  send-adjust-bit-array-maybe
	  send-draw-char
	  send-draw-line
	  send-draw-point
	  send-draw-rectangle
	  send-draw-string
	  send-drawcircle
	  send-drawhollowcircle
	  send-drawhollowrectangle
	  send-draw-filled-polygon
	  send-select-window
	  select-a-screen
	  si-bitblt))

;;; These symbols should be imported by the MAC package
(defparameter *mac-support-symbols*
	'(
	  ;; variables
	  *cold-load-streams-screen-selected-p* 
	  *default-Mac-window-height*	    
	  *default-Mac-window-width*	    
	  *dont-clip-at-the-margins*
	  *Explorer-to-Mac-char-code-map*
	  *ignore-commands-for-the-mac*
	  *mac*
	  *mac-keyboard-p*
	  *mac-system-p*
	  *Mac-resident-Explorer-screens*	;dab 8/24/88
	  *undisplaced-Mac-window-arrays*	;dab 8/24/88
	  *window-system-mouse-on-the-mac*
	  dump-draw-char-cache                  ;dab 08-24-88 DAB
	  lispm-shift-bit
	  lispm-greek-bit
	  lispm-top-bit
	  lispm-capslock-bit
	  lispm-control-bit
	  lispm-meta-bit
	  lispm-super-bit
	  lispm-hyper-bit
	  lispm-altlock-bit
	  lispm-modelock-bit
	  lispm-repeat-bit 

	  Mac-CONTROL-bit
	  Mac-OPTION-bit
	  Mac-CAPSLOCK-bit
	  Mac-SHIFT-bit
	  Mac-COMMAND-bit
	  Mac-MOUSE-bit
	  Mac-AUTOKEY-bit
	  Mac-Window-Activate-bit 
	  
	  mac-explorer-screen-ID-for-screen-being-created	;dab 8/24/88
	  mac-extended-kbd-descriptor
	  mac-kbd-modifier-table
	  mac-kbd-modifier-table-zmacs-mode
	  mac-screen
	  Mac-screen-for-printer		;dab 8/24/88
	  mac-standard-kbd-descriptor
	  not-visible-p				;dab 8/24/88
	  kbd-mac-table 

	  ;; functions
	  activate-mac-window
	  after-tv-initialized
	  analyze-last-button
	  deactivate-mac-screen
	  deactivate-mac-window
	  define-mac-resident-exp-screen
	  deselect-cold-load-streams-screen
	  give-mouse-ownership-to-the-explorer
	  kbd-convert-mac
	  kbd-make-mac-table 
	  lispm-or-mac-mouse-wakeup
	  mac-consider-mouse
	  mac-key 
	  mac-screen-p
	  mac-system-p
	  mac-window-p
	  make-a-Mac-resident-Explorer-screen
	  make-explorer-screen			;dab 8/24/88
	  redirect-drawing-of-window-and-inferiors
          remember-bit-array			       ;10/18/88
	  remember-this-screens-last-selected-window
	  select-cold-load-streams-screen
	  send-adjust-bit-array-maybe
	  send-draw-char
	  send-draw-line
	  send-draw-point
	  send-draw-rectangle
	  send-draw-string
	  send-drawcircle
	  send-drawhollowcircle
	  send-drawhollowrectangle
	  send-draw-filled-polygon
	  send-select-window
	  select-a-screen
	  si-bitblt))

;;; Make the symbols :EXTERNAL from TV
(EVAL-WHEN (LOAD)
  (export *mac-support-symbols* 'tv))
