;;; -*- cold-load:t; Mode:COMMON-LISP; Package:SYSTEM-INTERNALS; Base:8; Fonts: CPTFONT,HL12B,HL12BI -*-

1;;;                           RESTRICTED RIGHTS LEGEND

;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.
;;;
;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151
;;;
;;; Copyright (C) 1984-1989 Texas Instruments Incorporated.  All rights reserved.

;;; This is file of definitions of the format of stack groups. 
;;; It will be used by the error handler
;;; If this file is changed, it goes without saying that you need to make a new cold load.
;;; Also SYS:SYS;QCOM and SYS:SYS2;GLOBAL must be changed to agree.
;;; Also the microcode might have to be reassembled, and at least the following must be recompiled:
;;;  SYS:EH;EH >, SYS:EH;EHF >, SYS:EH;EHC > (the error handler),
;;;  SYS:SYS;SGFCTN > (for MAKE-STACK-GROUP), 
;;;  SYS:SYS; QMISC > (for DESCRIBE), SYS:SYS2;PROCES >, SYS;LTOP > (for PROCESS-WAIT), 
;;;  SYS:SYS2;QTRACE (for FUNCTION-ACTIVE-P), LMCONS;CC >

;;;  SYS:SYS2;SYSTEM has a list of the symbols defined here which belong in the SYSTEM package

;;; Change History:
;;;
;;;  Oct 14, 1985  mjf  Redid stack-group definition to agree with changes in QCOM
;;;*			1Added defsubst to reference new call state words.*

(DEFSTRUCT (stack-group (:type :array-leader) (:constructor nil) (:alterant nil)
			(:conc-name nil) (:callable-constructors nil)
			(:predicate nil) (:copier nil))
;(DEFSTRUCT (stack-group :array-leader (:constructor nil) (:alterant NIL))
      sg-name			    1;String with the name of the stack group*
      sg-regular-pdl		    1;Regular PDL array, 0=base of stack*
      sg-regular-pdl-limit	    1;Max depth before trap*
      sg-special-pdl		    1;Special PDL array, 0=base of stack*
      sg-special-pdl-limit	    1;Max depth before trap*
      sg-initial-function-index	    1;Index into PDL of topmost function*
				    1;(Normally 3 unless initial call has adi)*
;     SG-UCODE			    1;   (unused)*
      sg-trap-tag		    1;Symbolic tag corresponding to SG-TRAP-MICRO-PC.*
				    1; gotten via MICROCODE-ERROR-TABLE, etc.  Properties*
				    1; off this symbol drive error recovery.*
      sg-recovery-history	    1;Available for hairy SG munging routines to attempt to*
				    1; leave tracks.*
      sg-foothold-data		    1;During error recovery, contains pointer to a stack frame*
				    1; which contains saved status of the main stack group.*
				    1; (Preventing it from being lost when the foothold is *
				    1; running.)*
      ((sg-state)
       (sg-current-state 0006)	    1;state of this stack group*
       (sg-foothold-executing-flag 0601)	1;not used*
       (sg-processing-error-flag 0701)		1;taking error trap (detect recursive errors)*
       (sg-processing-interrupt-flag 1001)	1;not used*
       (sg-safe 1101)
       (sg-inst-disp 1202)	                1;the instruction dispatch we are using*
       (sg-in-swapped-state 2601)               1;when in the swapped state*
       (sg-swap-sv-on-call-out 2501)	        1;if this is on in the caller, or*
       (sg-swap-sv-of-sg-that-calls-me 2401)	1;this in the callee, then swap*
       (sg-restore-microstack 2701 ))
      sg-previous-stack-group	    1;Stack group who just ran*
      sg-calling-args-pointer	    1;Pointer into previous stack group's REGPDL to*
      sg-calling-args-number	    1; the args passed to us.*
      sg-trap-ap-level		    1;Locative to a location in PDL Buffer, below which *
				    1;traps occur*
      sg-regular-pdl-pointer	    1;Saved pdl pointer (as index into regular-pdl array)*
      sg-special-pdl-pointer	    1;Saved A-QLBNDP (as index into special-pdl array)*
;;     sg-ap			    1;Saved M-AP  ** Not used ***
;;     sg-ipmark		    1;Saved A-IPMARK  ** Not used ***
      sg-trap-micro-pc		    1;Address of last call to TRAP*
;     sg-error-handling-sg	    1;Having these part of the SG would be nice, but*
;     sg-interrupt-handling-sg      1; it doesnt buy anything for the time being, and costs*
;				    1; a couple microinstructions.*
;;      sg-saved-qlaryh		    1;Saved A-QLARYH*
;;      sg-saved-qlaryl		    1;Saved A-QLARYL*
      ((sg-saved-m-flags)	    1;Saved M-FLAGS*
;;       (sg-flags-qbbfl %%m-flags-qbbfl)	               1;Binding-block-pushed flag*
       (sg-flags-car-sym-mode %%m-flags-car-sym-mode)  1;UPDATE PRINT-ERROR-MODE IN QMISC*
       (sg-flags-car-num-mode %%m-flags-car-num-mode)  1; IF ADD ANY..*
       (sg-flags-cdr-sym-mode %%m-flags-cdr-sym-mode) 
       (sg-flags-cdr-num-mode %%m-flags-cdr-num-mode) 
       (sg-flags-dont-swap-in %%m-flags-dont-swap-in)
       (sg-flags-trap-enable %%m-flags-trap-enable)
       (sg-flags-mar-mode %%m-flags-mar-mode)
       (sg-flags-pgf-write %%m-flags-pgf-write)
       (sg-flags-meter-enable %%m-flags-meter-enable)
       (sg-flags-trap-on-call %%m-flags-trap-on-call)
       )
      sg-pdl-phase		1;If you mung the sg's stack pointer, do same to this;*
				1;this is the actual value of PDL-BUFFER-POINTER reg.*
      sg-saved-vma		1;Pointer field of VMA as a locative*
      sg-vma-m1-m2-tags		;1Tag fields of VMA, M-1, M-2 packed into a fixnum*
      sg-m3-m4-tags		;Tag fields of M-3, M-4 packed into a fixnum
      sg-ac-1			1;Pointer field of M-1 as fixnum*
      sg-ac-2			1;Pointer field of M-2 as fixnum*
      sg-ac-3 			1; ...*
      sg-ac-4 
      sg-ac-a
      sg-ac-b
      sg-ac-c 
      sg-ac-d
      sg-ac-e
      sg-ac-f
      sg-ac-g
      sg-ac-h
      sg-ac-i
      sg-ac-j 
      sg-ac-k 
      sg-ac-l
      sg-ac-q			1; For old code compatibility:*
      sg-ac-r
      sg-ac-s
      sg-ac-zr
      sg-ac-t			1; Result Register, pseudo indicatiors.*
      sg-catch-pointer          ; typed pointer to catch block.

      ) 

;(DEFSTRUCT (regular-pdl :array-leader (:constructor nil) (:alterant nil)) regular-pdl-sg)
(DEFSTRUCT (regular-pdl (:type :array-leader) (:constructor nil) (:alterant nil) 
			(:conc-name nil) (:callable-constructors nil)
			(:predicate nil) (:copier nil) )
  regular-pdl-sg)

;(DEFSTRUCT (special-pdl :array-leader (:constructor nil) (:alterant nil)) special-pdl-sg)
(DEFSTRUCT (special-pdl (:type :array-leader) (:constructor nil) (:alterant nil) 
			(:conc-name nil) (:callable-constructors nil)
			(:predicate nil) (:copier nil) )
  special-pdl-sg)


1;; Defsubsts for accessing the Regular Pdl.*


(DEFSUBST rp-location-counter-offset (reg-pdl frame) (aref reg-pdl (+ frame %call-state-location-counter-offset)))
(DEFSUBST rp-exit-pc   (reg-pdl frame) (aref reg-pdl (+ frame  %call-state-location-counter-offset)))

(DEFSUBST rp-fef-word      (reg-pdl frame) (aref reg-pdl (+ frame %call-state-fef)))
(DEFSUBST rp-function-word (reg-pdl frame) (aref reg-pdl (+ frame %call-state-fef)))

(DEFSUBST rp-local-pointer (reg-pdl frame) (aref reg-pdl (+ frame %call-state-local-pointer)))

(DEFSUBST rp-argument-pointer (reg-pdl frame) (aref reg-pdl (+ frame %call-state-argument-pointer)))


(DEFSUBST rp-call-info-word (reg-pdl frame) (aref reg-pdl (+ frame %call-state-call-info)))

1;; Access to top frame in pdl*

(DEFSUBST sg-top-frame (sg) (1+ (sg-regular-pdl-pointer sg)))

(DEFSETF sg-top-frame set-top-frame)

(DEFUN set-top-frame (sg frame)
1  ;; change pdl phase as well as regular pdl pointer to one minus frame index*
; (setf (sg-pdl-phase sg) 
;	(logand (- (sg-pdl-phase sg) (- (sg-regular-pdl-pointer sg) frame 1))
;		(1- si:pdl-buffer-length)))
  (setf (sg-pdl-phase sg) 
	(ldb 0012 (+ (sg-pdl-phase sg) (- frame (sg-regular-pdl-pointer sg) 1))))
  (setf (sg-regular-pdl-pointer sg) (1- frame)))


1;; (DEFINE-REG-PDL-MACROS ((rp-foo %%foo) (rp-bar %%bar)) rp-call-info-word)
;;
;; produces
;;
;; (PROGN 'compile
;;*	1 (DEFSUBST rp-foo (reg-pdl frame)
;;*		1(LDB %%foo (rp-call-info-word reg-pdl frame)))
;;*	1 (DEFSUBST rp-bar (reg-pdl frame)
;;*		1(LDB %%bar (rp-call-info-word reg-pdl frame))))*

(DEFMACRO define-reg-pdl-macros (spec-list word-macro)
    (do ((l spec-list (cdr l))
         (byte)
         (name)
         (accum))
        ((null l) `(progn 'compile . ,accum))
      (setq name (caar l) byte (cadar l))
      (push `(defsubst ,name (reg-pdl frame)
	       (ldb ,byte (,word-macro reg-pdl frame)))
            accum)))

(DEFINE-REG-PDL-MACROS 
  (
1   ;;  Call stuff.*
   (rp-number-of-arguments %%call-info-number-of-arguments)
   (rp-number-args-supplied  %%call-info-number-of-arguments)
   (rp-lexpr-funcall-flag %%call-info-lexpr-funcall-flag)
   (rp-self-map-table-provided %%call-info-self-map-table-provided)
1   ;;  State stuff.*
   (rp-saved-destination %%call-info-saved-destination)
   (rp-destination %%call-info-saved-destination)
1   ;;  Return stuff.*
   (rp-return-type %%call-info-return-type)
   (rp-number-of-results %%call-info-number-of-results)
1   ;;  More state stuff.   *
   (rp-binding-block-pushed %%call-info-binding-block-pushed)
   (rp-micro-stack-pushed %%call-info-microstack-pushed )
   (rp-micro-stack-saved %%call-info-microstack-pushed)
   (rp-trap-on-exit %%call-info-trap-on-exit)
   (rp-env-ptr-points-here %%call-info-env-ptr-points-here)
   )
  RP-CALL-INFO-WORD)

1;; To get an arg/local buffer or an arg/local array index for reg pdl*

(DEFSUBST sg-pdl-zero-phase (sg)
  2"This is the pdl-buffer index of the first q in the pdl array,
which is constant throughout the life of a stack-group"*
  (without-interrupts
    (ldb 0012 (- (sg-pdl-phase sg) (sg-regular-pdl-pointer sg)))))

(DEFUN pdl-buffer-index (sg rp-array-index)
  2"Return the rp buffer index of a given rp array index"*
  (ldb 0012 (+ rp-array-index (sg-pdl-zero-phase sg))))

(DEFUN pdl-array-index (sg rp-array-index rp-buffer-index)
  2"Returns the rp array index for a given rp buffer index at a given rp array index"*
  (- rp-array-index 
     (ldb 0012 (- (+ rp-array-index (sg-pdl-zero-phase sg)) 
		  rp-buffer-index))))

(DEFUN rp-local-offset (sg rp frame)
  (let ((index-to-local-pointer  (+ frame %call-state-local-pointer)))
    (pdl-array-index sg  index-to-local-pointer (aref rp index-to-local-pointer)))) 

(DEFUN rp-argument-offset (sg rp frame)
  (let ((index-to-argument-pointer  (+ frame %call-state-argument-pointer)))
    (pdl-array-index sg index-to-argument-pointer (aref rp index-to-argument-pointer))))



1;; Defsubsts for accessing fields of the headers of Function Entry Frames.*

(DEFMACRO define-offset-byte-macros (ptr . words)
   (do ((ll words (cdr ll))
	(accum)
        (index 0 (1+ index)))
       ((null ll) `(progn 'compile . ,accum))
      (do ((l (car ll) (cdr l))
           (name)
           (byte))
          ((null l))
         (setq name (caar l) byte (cadar l))
         (push `(defsubst ,name (,ptr)
                  (%p-ldb-offset ,byte ,ptr ,index))
               accum))))


(DEFSUBST fef-initial-pc (fef) 
  (ash (%p-ldb-offset %%fef-header-location-counter-offset fef %fef-header-word) 1))

(DEFSUBST fef-length (fef)
  (%p-pointer-offset fef %fef-storage-length-word))

