/*
 * exploiter.c
 *
 * main file
 */

#include <sys/types.h>
#include <sys/mman.h>
#include <sys/stat.h>

#include <fcntl.h>
#include <stdio.h>

#include "types.h"

extern int process_data(u8 *, int);

struct loaded_file loadband;
struct loaded_file diskimage;

int load_file(char *filename, struct loaded_file *filestruct)
{
    int fd;
    struct stat st;
    u_int8_t *addr;

    stat(filename, &st);
    fd = open(filename, O_RDWR);
    if (fd < 0) {
	perror("opening file.");
	return -1;
    }
    
    addr = mmap(NULL, st.st_size, PROT_READ | PROT_WRITE, MAP_PRIVATE, fd, (off_t) 0);
    if (addr == MAP_FAILED) {
	perror("failed to mmap file.");
	return -1;
    }

    filestruct->data = addr;
    filestruct->size = st.st_size;

    return 0;
}

int main(int argc, char *argv[])
{
    if (argc != 3) {
	fprintf(stderr, "usage: %s <loadband> <diskimage>\n", argv[0]);
	return -1;
    }

    if (load_file(argv[1], &loadband)) {
	fprintf(stderr, "error loading load band %s.\n", argv[1]);
	return -1;
    }

    if (load_file(argv[2], &diskimage)) {
	fprintf(stderr, "error loading disk image %s.\n", argv[2]);
	return -1;
    }
    
    return process_data(loadband.data, loadband.size);
}

/* EOF */
