/*
 * memory.h
 *
 * memory load and access functions
 */

#ifndef MEMORY_H
#define MEMORY_H

#include "exploiter.h"

lisp_q inviz(lisp_q address, lisp_q *final_address);
lisp_q memread_unboxed(lisp_q address);
lisp_q memread(lisp_q address);
lisp_q memread_inviz(lisp_q address);
void memwrite_unboxed(lisp_q address, lisp_q data);
void memwrite(lisp_q address, lisp_q data);
void memwrite_inviz(lisp_q address, lisp_q data);
void push(lisp_q foo);
void push_cdrnext(lisp_q foo);
lisp_q pop(void);
lisp_q pop_loc(void);
lisp_q car(lisp_q cons);
lisp_q cdr(lisp_q cons);
lisp_q get_area_address(int area);
void memory_init(lisp_q *data);
lisp_q return_barrier(lisp_q data);

void bind(lisp_q where, lisp_q data);
void unbind_block(void);
void unbind_n(int n);

lisp_q allocate_list_qs(lisp_q area, int nqs);
lisp_q allocate_structure_qs(lisp_q area, int nqs);
lisp_q allocate_number_qs(int nqs);

int find_region_number(lisp_q address);
int find_region_area(int region_number);

lisp_q find_structure_header(lisp_q pointer);
lisp_q find_structure_leader(lisp_q pointer);
lisp_q structure_boxed_size(lisp_q pointer);
lisp_q structure_total_size(lisp_q pointer);

lisp_q get_pht_entry(lisp_q address);

void create_physical_page(int pfn);

lisp_q get_support_entry_vector(int);
lisp_q get_micro_code_link(int index);
lisp_q get_micro_code_entry(int);
lisp_q get_micro_code_entry_debug_info(int);

#endif /* MEMORY_H */

/* EOF */
