/*
 * utils.h
 *
 * utility functions
 */

#ifndef UTILS_H
#define UTILS_H

#include "types.h"
#include "exploiter.h"

extern char *ary_type_names[32];

int disassemble_instr(lisp_q fef, int address, u16 opcode);
void dump_dtp(u32 data);
void dump_q(u32 data, u32 address);

void dump_local_name(lisp_q fef, int offset);
void dump_arg_name(lisp_q fef, int offset);

void dump_array_header(lisp_q ary_header);
void dump_raw_array(lisp_q aryptr);
lisp_q dump_function_name(lisp_q fefptr);
void dump_raw_fef(lisp_q fefptr);

void internal_dump_string(lisp_q strptr);
void dump_string(lisp_q strptr);

void print_list(lisp_q list);

void dump_symbol_table(lisp_q table);

#endif /* UTILS_H */

/* EOF */
