;;; -*- Mode:Common-Lisp; Package:System; Base:10; Patch-file:T; Fonts:(CPTFONT CPTFONTB) -*-

;;; Reason: Fix DELETE-SYSTEM to not get an error when trying to update the SYSTEM key 
;;; assignments after deleting VisiDoc.  [SPR 10608 and 10609]

;;;                           RESTRICTED RIGHTS LEGEND
;;;
;;; Use, duplication, or disclosure by the Government is subject to
;;; restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;; Technical Data and Computer Software clause at 52.227-7013.
;;;
;;;   TEXAS INSTRUMENTS INCORPORATED      
;;;   P.O. BOX 149149, M/S 2151             
;;;   AUSTIN, TEXAS 78714
;;;
;;; Copyright (C) 1989 Texas Instruments Incorporated.
;;; All rights reserved.

;;; Written 10/13/89 13:45:56 by GRAY,
;;; while running on Kelvin from band LOD2
;;; With SYSTEM 6.20, VIRTUAL-MEMORY 6.2, EH 6.5, MAKE-SYSTEM 6.2, MICRONET 6.0, LOCAL-FILE 6.1,
;;;  BASIC-PATHNAME 6.2, NETWORK-SUPPORT-COLD 6.2, BASIC-NAMESPACE 6.4, NETWORK-NAMESPACE 6.0,
;;;  DISK-IO 6.1, DISK-LABEL 6.0, BASIC-FILE 6.4, MAC-PATHNAME 6.0, NETWORK-PATHNAME 6.0,
;;;  COMPILER 6.12, TV 6.15, DATALINK 6.0, CHAOSNET 6.1, GC 6.3, MEMORY-AUX 6.0, NVRAM 6.2,
;;;  SYSLOG 6.2, STREAMER-TAPE 6.4, UCL 6.0, INPUT-EDITOR 6.0, METER 6.1, ZWEI 6.7,
;;;  DEBUG-TOOLS 6.3, NETWORK-SUPPORT 6.0, NETWORK-SERVICE 6.1, DATALINK-DISPLAYS 6.0,
;;;  FONT-EDITOR 6.1, SERIAL 6.0, PRINTER 6.3, MAC-PRINTER-TYPES 6.1, PRINTER-TYPES 6.2,
;;;  IMAGEN 6.1, SUGGESTIONS 6.0, MAIL-DAEMON 6.3, MAIL-READER 6.5, TELNET 6.0, VT100 6.0,
;;;  NAMESPACE-EDITOR 6.3, PROFILE 6.2, VISIDOC 6.5, Inconsistent TI-CLOS 6.26, CLEH 6.5,
;;;  IP 3.54, Experimental CLX 6.5, CLUE 6.25, X11M 6.15, Experimental BUG 11.15,
;;;  Experimental DOCUMENTER 701.0, Experimental SHRINK-TOOLS 6.0,  microcode 430,
;;;  Band Name: 6.0+Scribe,&c,u430 9/6

;;; BUG REPORT NUMBER:  10608 and 10609
;;;
;;; PROBLEM:  Getting ">>Error: Cannot coerce NIL into a character" when using 
;;;	DELETE-SYSTEM on VisiDoc or VisiDoc Server.
;;;
;;; SOLUTION:  Modify function UPDATE-SYSTEM-KEYS to beware of non-character 
;;;	keys in the TV:*SYSTEM-KEYS* a-list.  [Several things that are in the 
;;;	system menu but don't have SYSTEM key assignments appear in the list with 
;;;	NIL instead of a character.]
;;;
;;; DEPENDENCIES:  [none]

#!C
; From file DELETE-SYSTEM.LISP#> BAND-TOOLS; Hotel:
#10R SYSTEM#:
(COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "SYSTEM"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* *COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: BAND-TOOLS; DELETE-SYSTEM.#"


(defun update-system-keys (&optional deleted-system-name)
  ;; Delete SYSTEM and TERM key assignments for things that aren't defined anymore.
1  ;;  9/08/89 DNG - Make sure (FIRST X) is a character [could be NIL] before 
  ;;*		1calling ASK-UNLESS-BATCH.  [SPR 10608, 10609]*
  (let ((question "Delete ~:@C (\"~A\") from the ~A key?"))
    (when (boundp 'tv:*system-keys*)
      (flet ((undefinedp (thing)
			 (and (symbolp thing)
			      (not (get thing 'si:flavor))
			      (not (boundp thing))
			      (not (fboundp thing)))))
	(dolist (x tv:*system-keys*)
	  (let ((finder (second x)))
	    (when (and (typecase finder
			 (keyword  (or (same-system-p finder deleted-system-name)
				       (not (selectable-system-p finder))))
			 (atom  (undefinedp finder))
			 (t (dolist (e finder nil)
			      (when (undefinedp e)
				(return t)))))
		       1(or (not (characterp (first x)))*
			   (ask-unless-batch question (first x) (third x) 'system)1)*)
	      (setq tv:*system-keys*
		    (remove x (the list tv:*system-keys*) :test #'eq)))))))
    (when (boundp 'tv:*terminal-keys*)
      (dolist (x tv:*terminal-keys*)
	(let ((fn (second x)))
	  (when (consp fn) (setq fn (car fn)))
	  (when (and (symbolp fn)
		     (not (fboundp fn))
		     (ask-unless-batch question (first x) (third x) 'term))
	    (setq tv:*terminal-keys*
		  (remove x (the list tv:*terminal-keys*) :test #'eq)) ))))
    (values)))
))
