;;; -*- Mode:Common-Lisp; Package:MACTOOLBOX; Fonts:(CPTFONT HL10B HL12I CPTFONT CPTFONTB); Base:10; Patch-file: t -*-

;;;			    RESTRICTED RIGHTS LEGEND
;;; Use, duplication, or disclosure by the Government is subject to restrictions as
;;; set forth in subdivision (c)(1)(ii) of the Rights in Technical Data and 
;;; Computer Software clause at 52.227-7013.
;;; 	 TEXAS INSTRUMENTS INCORPORATED, P.O. BOX 2909, AUSTIN, TEXAS 78769
;;;      Copyright (C) 1989 Texas Instruments Incorporated.  All rights reserved.


;1;; This file contains DEFCONSTANTs of TB:MAC-POINTER instances initialized to selected Macintosh*
;1;; system global variables from "Inside Macintosh".  To fetch one of these global constants use*
;1;; *tb:fetch1, *tb:fetchword1,  or *tb:fetchbyte1 on one of these tb:mac-pointer CONSTANTS.  These fetch*
;1;; functions are SETFable.  For example,*
;1;;*
;1;;*  4(tb:fetch !CaretTime-ptr)1                                             =>  2ticks per blink***
;1;;     4(setf (tb:fetch !CaretTime-ptr) 2new-interval*)* => 2new-interval**
;1;;*
;1;;*
;1;; 4 NOTE:  These pointer constants MAY be safely saved in a microExplorer**
;1;;4 load band because they record address which the Macintosh is **
;1;;   4guaranteed to maintain.*  *


(defmacro4 DEF-PTR-CONSTANT *(name value &optional documentation-string)
  "2defines NAME to be a constant TB:MAC-POINTER with :POINTER value VALUE*"
  `(defconstant ,name (make-instance 'mac-pointer :pointer ,value)
     ,documentation-string))

;1;;4 A**
(def-ptr-constant 4!ABusVars-ptr*	#x2D8
  "2pointer to pointer to AppleTalk variables*")
(def-ptr-constant 4!ACount-ptr *		#xA9A
  "2pointer to stage number, 0..3, of last alert as a 16-bit integer (see tb:!GetAlrtStage and
tb:!ResetAlrtStage)*")
(def-ptr-constant 4!ANumber-ptr *	#xA98
  "2pointer to resource ID of last alert as 16-bit integer*")
(def-ptr-constant 4!ApFontID-ptr *	#x984
  "2pointer to font number of application font as a 16-bit integer*")
(def-ptr-constant 4!ApplLimit-ptr *	#x130
  "2pointer to application heap limit (see tb:!GetApplLimit)*")
(def-ptr-constant 4!ApplScratch-ptr *	#xA78
  "2pointer to a 12-byte scratch area reserved for use by applications*")
(def-ptr-constant 4!ApplZone-ptr *	#x2AA
  "2pointer to address of application heap zone (see tb:!ApplicZone)*")
(def-ptr-constant 4!AppParamHandle-ptr *#xAEC
  "2pointer to a handle to Finder information*")
(def-ptr-constant 4!AtMenuBottom-ptr *	#xA0C
  "2pointer to flags for menu scrolling as a 32-bit integer*")
(def-ptr-constant 4!AuxWinHead-ptr *	#xCD0
  "2pointer to auxiliary window list header as a 32-bit integer*")

;1;; 4B**
(def-ptr-constant 4!Boot-Drive-ptr *	#x210
  "2pointer to working directory reference number for system startup volume as a 32-bit integer*")
(def-ptr-constant 4!BufPtr-ptr *		#x10C
  "2pointer to address of end of jump table*")
(def-ptr-constant 4!BufTgDate-ptr *	#x304
  "2pointer to file tags buffer:  date and time of last modification as a 32-bit integer*")
(def-ptr-constant 4!BufTgFBkNum-ptr *	#x302
  "2pointer to file tags buffer:  logical blocks number as a 32-bit integer*")
(def-ptr-constant 4!BufTgFFlg-ptr *	#x300
  "2pointer to file tags buffer:  flags*")
(def-ptr-constant 4!BufTgFNum-ptr *	#x2FC
  "2pointer to file tags buffer:  file number as a 32-bit integer*")


;1;; 4C**
(def-ptr-constant 4!CaretTime-ptr *	#x2F4
  "2pointer to caret-blink interval in 1/60th of a second ticks as a 32-bit integer (see tb:*CaretTime*)*")
(def-ptr-constant 4!CPUFlag-ptr *	#x12F
  "2pointer to microprocessor in use as a 16-bit integer*")
(def-ptr-constant 4!CrsrThresh-ptr *	#x8EC
  "2pointer to mouse-scaling threshold as a 16-bit integer*")
(def-ptr-constant 4!CurActivate-ptr *	#xA64
  "2pointer to pointer to window to receive activate event*")
(def-ptr-constant 4!CurApName-ptr *	#x910
  "2pointer to name of current application as a length byte followed by up to 31 characters*")
(def-ptr-constant 4!CurApRefNum-ptr *	#x900
  "2pointer to reference number of current application's resource file as a 16-bit integer*")
(def-ptr-constant 4!CurDeactive-ptr *	#xA68
  "2pointer to pointer to window to receive deactivate event*")
(def-ptr-constant 4!CurDirStore-ptr *	#x398
  "2pointer to directory ID of directory last opened as 32-bit integer*")
(def-ptr-constant 4!CurJTOffset-ptr *	#x934
  "2pointer to offset to jump talbe from location pointed to by A5 as a 16-bit integer*")
(def-ptr-constant 4!CurMap-ptr *		#xA5A
  "2pointer to reference number of current resource file as 16-bit integer*")
(def-ptr-constant 4!CurPageOption-ptr *	#x936
  "2pointer to sound/screen buffer configuration passed to Chaim or Launch as a 16-bit integer*")
(def-ptr-constant 4!CurPitch-ptr *	#x280
  "2pointer to value of count in square-wave synthesizer buffer as a 16-bit integer (see tb:!StopSOund)*")
(def-ptr-constant 4!CurrentA5-ptr *	#x904
  "2pointer to address of boundary between application globals and applications parameters*")
(def-ptr-constant 4!CurStackBase-ptr *	#x908
  "2pointer to assress of baase of stack; start of application globals*")


;1;; 4D**
(def-ptr-constant 4!DABeeper-ptr *	#xA9C
  "2pointer to address of current sound procedure*")
(def-ptr-constant 4!DAStrings-ptr *  	#xAA0
  "2pointer to handles to ParamText strings (16 bytes)*")
(def-ptr-constant 4!DefltStack-ptr *	#x322
  "2pointer to default space allotment for stack as 32-bit integer*")
(def-ptr-constant 4!DefVCBPtr-ptr *	#x352
  "2pointer to pointer to default volume control block*")
(def-ptr-constant 4!DeskHook-ptr *	#xA6C
  "2pointer to address of procedure for painting desktop or responding to clicks on desktop*")
(def-ptr-constant 4!DeskPattern-ptr *	#xA3C
2    *"2pointer to 8-byte pattern with which desktop os painted*")
(def-ptr-constant 4!DlgFont-ptr *	#xAFA
  "2pointer to font number for dialogs and alerts as a 16-bit integer (see tb:!SetDAFont)*")
(def-ptr-constant 4!DoubleTime-ptr *	#x2F0
  "2pointer to double-click interval in 1/60-th of a second ticks as a 32-bit integer (see tb:*doubleTime*)*")
(def-ptr-constant 4!DragHook-ptr *	#x9F6
  "2pointer to address of procedure to execute during tb:!TrackGoAway, tb:!DragWindow, tb:!GrowWindow,
tb:!DragGrayRgn, tb:!TrackControl, and tb:!DragControl*")
(def-ptr-constant 4!DragPattern-ptr *	#xA34
  "2pointer to 8-byte pattern of gragged region's outline*")
(def-ptr-constant 4!DrvQHdr-ptr *	#x308
  "2pointer to 10 byte drive queue header (see tb:!GetDrvQHdr)*")
(def-ptr-constant 4!DSAlertRect-ptr *	#x3F8
  "2pointer to 8-byte rectangle enclosing system error alert*")
(def-ptr-constant 4!DSAlertTab-ptr *	#x2BA
  "2pointer to pointer to system error alert table in use*")
(def-ptr-constant 4!DSErrCode-ptr *	#xAF0
  "2pointer to current system error ID as a 16-bit integer*")


;1;; 4E**
(def-ptr-constant 4!EventQueue-ptr *	#x14A
  "2pointer to 10-byte event queue header (see tb:!GetEvQHdr)*")
(def-ptr-constant 4!ExtStsDT-ptr *	#x2BE
  "2pointer to 16-byte external/status interrupt vector table*")


;1;; 4F**
(def-ptr-constant 4!FinderName-ptr *	#x2E0
  "2pointer to name of finder as length byte followed by up to 15 bytes*")
(def-ptr-constant 4!FracEnable-ptr *	#xBF4
  "2pointer to non-zero enables fractional width as a byte (see tb:!SetFractEnable)*")
(def-ptr-constant 4!FScaleDisable-ptr *	#xA63
  "2pointer to a byte, non-zero=>disables font scaling*")
(def-ptr-constant 4!FSQHdr-ptr *		#x360
  "2pointer to 10 byte file I/O queue header (see tb:!GetFSQHdr)*")

;1;; 4G**
(def-ptr-constant 4!GhostWindow-ptr *	#xA84
  "2pointer to a window never to be consider frontmost*")
(def-ptr-constant 4!GrayRgn-ptr *	#x9EE
  "2pointer to handle to region drawn as desktop (see tb:!GetGrayRgn)*")
(def-ptr-constant 4!GZRootHand-ptr *	#x328
  "2pointer to handle to relocatable block not to be moved by grow zone function (see tb:!GZSaveHnd)*")


;1;; 4H**
(def-ptr-constant 4!HeapEnd-ptr *	#x114
  "2pointer to address of end of application heap zone*")


;1;; 4I**
(def-ptr-constant 4!IntlSpec-ptr *	#xBA0
  "2pointer to a 32-bit integer which, if not -1, indicates international software installed*")


;1;; 4J**
(def-ptr-constant 4!JFetch-ptr *		#x8F4
  "2pointer to jump vector for Fetch function (cf. !JStash-ptr)*")
(def-ptr-constant 4!JIODone-ptr *	#x8FC
  "2pointer to jump vector for IODone function*")
(def-ptr-constant 4!JournalFlag-ptr *	#x8DE
  "2pointer to journaling mode as 16-bit integer*")
(def-ptr-constant 4!JournalRef-ptr*  	#x8E8
  "2pointer to refNum for journaling device driver as 16-bit integer*")
(def-ptr-constant 4!JStash-ptr *		#x8F8
  "2pointer to jump vector for Stash function (cf. !JFetch-ptr)*")

;1;; 4K**
(def-ptr-constant 4!KeyRepThresh-ptr *	#x190
  "2pointer to auto-key rate as a 16-bit integer*")
(def-ptr-constant 4!KeyThresh-ptr *	#x18E
  "2pointer to auto-key threshold as a 16-bit integer*")


;1;; 4L**
(def-ptr-constant 4!Lvl1DT-ptr *		#x192
  "2pointer to 32-byte Level-1 secondary interrupt vector table*")
(def-ptr-constant 4!Lvl2DT-ptr *		#x1B2
  "2pointer to 32-byte Level-2 secondary interrupt vector table*")


;1;; 4M**
(def-ptr-constant 4!MBarEnable-ptr *	#xA20
  "2pointer to unique menu ID as a 16-bit integer for active desk accessory, 
when menu bar belongs to the accessory*")
(def-ptr-constant 4!MBarHook-ptr *	#xA2C
  "2pointer to address of routine called by tb:!MenuSelect before menu is drawn*")
(def-ptr-constant 4!MemErr-ptr *		#x220
  "2pointer to current value of MemErr as a 16-bit integer (see tb:!MemErr function)*")
(def-ptr-constant 4!MemTop-ptr *		#x108
  "2pointer to address of end of RAM (see tb:!TopMem)*")
(def-ptr-constant 4!MenuFlash-ptr *	#xA24
  "2pointer to count for duration of menu item blinking as a 16-bit integer*")
(def-ptr-constant 4!MenuHook-ptr *	#xA30
  "2pointer to address of routine called during tb:!MenuSelect*")
(def-ptr-constant 4!MenuList-ptr *	#xA1C
  "2pointer to handle to current menu list*")
(def-ptr-constant 4!MinStack-ptr *	#xA06
  "2pointer to minimum space allotment for stack as 32-bit integer*")
(def-ptr-constant 4!MMU32Bit-ptr*	#xCB2
  "2pointer to current address mode as a byte (see tb:!GetMMUMode)*")


;1;; 4O**
(def-ptr-constant 4! *	#x
  "2pointer to *")
(def-ptr-constant 4!OldContent-ptr *	#x9EA
  "2pointer to handle to saved content region*")
(def-ptr-constant 4!OldStructure-ptr *	#x9E6
  "2pointer to handle to saved structure region*")


;1;; 4P**
(def-ptr-constant 4!PaintWhite-ptr *	#x9DC
  "2pointer to 32-bit flag for whether to paint window white before update event*")
(def-ptr-constant 4!PortBUse-ptr *	#x291
  "2pointer to 8-bit integer indicating current availability of serial port B*")
(def-ptr-constant 4!PrintErr-ptr *	#x944
  "2pointer to OSErr from last Printing Manager routine as 32-bit integer (see
tb:!PrError and tb:!PrSetError)*")


;1;; 4R**
(def-ptr-constant 4!RAMBase-ptr *	#x2B2
  "2pointer to trap dispatch table's base address for routines in RAM*")
(def-ptr-constant 4!ResErr-ptr *		#xA60
  "2pointer to current value of tb:!ResError (q.v.)*")
(def-ptr-constant 4!ResErrProc-ptr *	#xAF2
  "2pointer to address of resouce error procedure*")
(def-ptr-constant 4!ResLoad-ptr *	#xA5E
  "2pointer to current state of tb:!SetResLoad (q.v.) as 16-bit integer*")
(def-ptr-constant 4!ResumeProc-ptr *	#xA8C
  "2pointer to address of resume procedure*")
(def-ptr-constant 4!RndSeed-ptr *	#x156
  "2pointer to random number seed as 32-bit integer*")
(def-ptr-constant 4!ROMBase-ptr *	#x2AE
  "2pointer to base address of ROM*")
(def-ptr-constant 4!ROMFont0-ptr *	#x980
  "2pointer to handle to font record for system font*")


;1;; 4S**
(def-ptr-constant 4!ScrHRes-ptr *	#x104
  "2pointer to horizontal pixels/inch as 16-bit integer (see tb:!ScrVRes and tb:!ScreenRes)*")
(def-ptr-constant 4!ScrVRes-ptr *       #x102
  "2pointer to vertical pixels/inch as 16-bit integer (see tb:!ScrHRes and tb:!ScreenRes)*")
(def-ptr-constant 4!SnVolume-ptr *	#x260
  "2pointer to current speaker volume, 0..7, as 8-bit byte (see tb:!SetSoundVol and tb:!GetSoundVol)*")
(def-ptr-constant 4!SysEvtMask-ptr *	#x144
  "2pointer to system event mask as a 16-bit integer (see tb:!SetEventMask)*")
(def-ptr-constant 4!SysZone-ptr *	#x2A6
  "2pointer to address of system heap zone (see tb:!SystemZone)*")
(def-ptr-constant 4!SysParam-ptr *	#x1F8
  "2pointer to 20-byte low-memory copy of parameter RAM (see tb:!GetSysPPtr)*")2 *


;1;; 4T**
(def-ptr-constant 4!TEScrpHandle-ptr *	#xAB4
  "2pointer to handle to TextEdit Scrap (see tb:!TEScrapHandle)*")
(def-ptr-constant 4!TEScrpLength-ptr *	#xAB0
  "2pointer to size in bytes of TextEdit scrap as a 32-bit integer (see tb:!TEGetScrapLen
and tb:!TESetScrapLen)*")
(def-ptr-constant 4!Ticks *              #x16A
  "2pointer number of 1/60ths of a second `ticks' since boot as a 32-bit integer*")
(def-ptr-constant 4!Time-ptr *		#x20C
  "2pointer to seconds since midnight, 1 January 1904 as a 32-bit integer (see tb:!GetDateTime)*")

;1;; 4V**
(def-ptr-constant 4!VBLQHdr-ptr *	#x160
  "2pointer to 10 byte vertical retrace queue header (see tb:!GetVBLQHdr)*")
(def-ptr-constant 4!VCBQHdr-ptr*		#x356
  "2pointer to 10 byte volume-control-block queue header (see tb:!GetVCBQHdr)*")


;1;; 4W**
(def-ptr-constant 4!WidthListHane-ptr *	#x8E4
  "2pointer to handle to a list of handles to recently-used with tables*")
(def-ptr-constant 4!WidthPtr-ptr *	#xB10
  "2pointer to pointer to global width table*")
(def-ptr-constant 4!WidthTabHandle-ptr *#xB2A
  "2pointer to handle to global width table*")