;;; -*- Mode:Common-Lisp; Package:TV; Base:8; Fonts:(CPTFONT HL10B HL12BI HL12B CPTFONTB)1;* Patch-file:T1 *-*-

;1;;                     RESTRICTED RIGHTS LEGEND          *
;1;; Use, duplication, or disclosure by the Government is subject to*
;1;; restrictions as set forth in subdivision (b)(3)(ii) of the Rights in*
;1;; Technical Data and Computer Software clause at 52.227-7013.*
;1;;                   TEXAS INSTRUMENTS INCORPORATED.*
;1;;                            P.O. BOX 149149*
;1;;                         AUSTIN, TEXAS 78714-9149*
;1;;                             MS 2151*
;1;; Copyright (C) 1986,1987, 1988, 1989 Texas Instruments Incorporated. All rights reserved.*



;1;; Record of changes:*
;1;; 7/12/88 clm - made changes to prevent entering debugger when encountering *
;1;;               undefined flavors (spr 8232); changes submitted by R.Acuff.*
;1;; 7/13/88 clm - the function SYMBOL-STRING-LENGTH did not always calculate the*
;1;;               PACKAGE correctly; DEFF'd it to use the FORMAT:FLATSIZE function*
;1;;               instead.*
;1;; 7/14/88 clm - modified to include DEBUG command; implementation provided by *
;1;;               R. Acuff.*
;1;; 4/10/89 jlm - modified method (SHOW-MISCELLANEOUS-DATA :GENERATE-ITEM) to use FLAVOR-DEFINITION-PACKAGE*
;1;;*		1  Instead of FLAVOR-PACKAGE*
;1;; 6/15/89  tac - removed call to compiler:disassemble-current-flavor in SEARCH-POINTER function.*
 
#|
3This file contains a prototype Flavor Inspector.   Load this and press SYSTEM O.
This code was handed off to DSG to refine and add to the Explorer system.
Much of the documentation in the rest of this file is addressed primarily towards
my DSG contact.  --Hogge*
|#

;1(FORMAT T "~%Loading the Flavor Inspector.  When this finishes loading, press SYSTEM O.~%")*

#|
			3     Things to do

Important ones are starred

- starring of method combination type is buggy: method combination not stored always in flavor's method table.

- Like INSPECT function, FLAVOR-INSPECT (thing).

-* Please read any big-bold-faced comments I've made throughout the file.

-Who-Line in inspect panes sometimes give the standard inspector message --right click finds function definition, etc.

-* Show-All-Methods and SHow-All-Methods-Sorted need some work.  Don't assume that inherited primary methods
 which the main flavor has a definition for are shadowed by the main flavor's method.  The shadowing depends
 on the type of method combination.  For instance, with :OR combination, no primary methods are shadowed (all
 of them are used in the combined method).  Speaking of method combination, there's a bug in the flagging of
 special method combination types.  I had assumed that flavor method table entries are of the form
   (<method spec> <combination type> <order> ...)
 but really <combination type> is often NIL, even though an inherited method sets the combination type to
 :OR or something like that.  So for each displayed method, you need to search the flavor components and
 see what the combination type is.  You will be able to use DEBUGGING-INFO on the :COMBINED method spec to
 get at this quickly.

-* typing of method specs should possibly be reworked to behave differently.  Right now it expects a legal
 method spec to inspect the "method details" of.  For instance,  you could type 
   UCL:BAIX-COMMAND-LOOP :CASE :SET :ACTIVE-COMMAND-TABLES
 and get info on that method.  Instead of this, perhaps we should just accept expressions of the form
   <flavor-name> <message>
 and do the "show-message-handlers" on it.  This would speed up completion and might be more what the
 user really wants to see.

-* review on-line doc--make sure terms are consistent (i.e. handler (vs. operations ???) vs. method vs. daemom).

-Make sure I've got rid of all crashing problems.  Traditionally it seems like it was
 crashing on basic input operations (:ANY-TYI), but perhaps there is no real problem and
 I was just being faked out crashes caused in other parts of the code, that I've now fixed.

-Make sure interpreted methods are ok on all commands.

-Fix all commands to do reasonable things on inspected flavors whose components aren't defined yet.
 For example, try inspecting this flavor: (DEFFLAVOR foo () (undefined-flavor)).

b- Perhaps improve how show-message-handlers displays the structure of a combined method.  All it does now is give
 the handlers a roughly correct order; doesn't show imbedding on :WRAPPERS and :AROUNDS well.
 Fix it to show the right order for given special method combination styles, and for :BASE-FLAVOR-FIRST ordering.

b- See comment in (show-dependent-flavors :generate-item)--compiler problem?

e-on-line doc should explain all properties in flavor-plist, for show-misc-info.

e-Some search commands like
  -method apropos. Get flavor name, inspect all methods matching a substring.
  -flavor apropos.  Inspect all flavors having some property, such as instance var or method (difficult).

e- Other commands which should be implemented:
 -Display in Tree form for some of the outputs     ***I think this would be very important!!!***
 -Debug Flavor (prints all possible sources of errors in flavor, such as method 
  redefinitions, duplicate instance variable entries (both in the same or different 
  packages), shadowed methods, etc.
 -Who-Calls on method names (with disclaimer about what it outputs).



e-Add the means to easily inspect multiple lines of text, instead of just one line.
 This would be useful in designing special purpose inspectors and could also be used in
 the display of method documentations strings.

i-TV:INSPECT-FRAME is now a much more general beast; applications can use it as a mixin to design
 custom inspectors.  Perhaps it, TV:INSPECTION-DATA, ALLOCATE-DATA, etc. should be documented
 in the window system manual.

i-Recommend implementing meta-< and meta-> for inspectors.
 Recommend converting c-v and m-v to accept the ucl numeric argument and
 skip UCL:NUMERIC-ARG pages.*

|#

(DEFPARAMETER 4*flavor-inspector-configuration** :three-panes
"2Default configuration for the Flavor-Inspector*")
 
(EVAL-WHEN (COMPILE eval load)

;1; Help function for WITH-RECURSION.  Ironic, isn't it?*
(DEFUN 4replace-recurse-calls* (form)
  (WHEN (CONSP form)
    (COND ((OR (EQ (CAR form) 'recurse)
	       (EQ (CAR form) 'recurse-apply))
	   (SETF (CAR form) '.with-recursion.))
	  ((CONSP (CAR form))
	   (replace-recurse-calls (CAR form))))
    (replace-recurse-calls (CDR form)))
  form))

;1;;  With-Recursion provides the means of putting recursive operations \"in line\".*
;1;;  Instead of having to write a recursive function and make an initial call to*
;1;;  it from some body of code, this macro allows you to specify implicitly a recursive*
;1;;  function and an initial call.  *
;1;;*
;1;; Arguments:*
;1;;  LAMBDA-LIST specifies the arguments to the recursive function which WITH-RECURSION*
;1;;  builds.  There are no restrictions on this lambda list.*
;1;;*
;1;;  ARGS-FOR-FIRST-CALL specifies the initial arguments to use in FUNCALLing the recursive*
;1;;  function.  As with any FUNCALL, they will get evaluated.*
;1;;*
;1;;  BODY is a set of forms used as the body of the recusive function.*
;1;;  Two special forms may be used anywhere in BODY: RECURSE and RECURSE-APPLY.*
;1;;  RECURSE is synonymous with FUNCALL, RECURSE-APPLY is synonymous with APPLY.*
;1;;  They may be used to specify recursive FUNCALLs and APPLYs to the recursive function.*
;1;;  Both take arguments and expand into FUNCALLs and APPLYs, respectively.*
;1;;  If you don't use them in BODY, there's no need to use WITH-RECURSION at all, since they*
;1;;  provide the only means to recurse.*
;1;;*
;1;; Advantages: *
;1;;  -- Readability.  In some cases you want the recursive code to appear where it*
;1;;     is first called, to better show path of execution.  If you have to mode the*
;1;;     body off to a small help function, JUST because the body is executed recursively,*
;1;;     your code may become hard to read.  Top-Down-Design purists might scoff, but*
;1;;     remember that iterative constructs don't have to be written as help functions. *
;1;;     Why should recursive structures?  If you are only going to use the recursive body*
;1;;     once, why shouldn't it be in-line?*
;1;;  --Execution speed.  The BODY argument can reference variables locally bound in code*
;1;;     surrounding the macro.  The alternative is to use special bindings, which is less efficient.*
;1;;*
;1;; Disadvantages:*
;1;;  -- Reusability.  Whenever you DON'T write a help function to handle some task and instead*
;1;;     handle the task in-line, you prevent other code from making use of the task handler.*
;1;;     This isn't anything peculiar about WITH-RECURSION, of course.*
;1;;*
;1;;  Example: a simple recursive print of the elements of a list.*
;1;;  (WITH-RECURSION ((x) '(1 2 3))*
;1;;    (WHEN x *
;1;;      (PRINT (CAR x))*
;1;;      (RECURSE (CDR x))))*

(DEFMACRO 4with-recursion* ((lambda-list . args-for-first-call) &body body)
  "2With-Recursion provides the means of putting recursive operations \"in line\".
 LAMBDA-LIST specifies the arguments to the recursive function which WITH-RECURSION
 builds.  There are no restrictions on this lambda list. ARGS-FOR-FIRST-CALL specifies the
 initial arguments to use in FUNCALLing the recursive function. They will get evaluated. BODY
 is a set of forms used as the body of the recusive function. Two special forms may be used
 anywhere in BODY: RECURSE and RECURSE-APPLY. RECURSE is synonymous with FUNCALL,
 RECURSE-APPLY is synonymous with APPLY.
 Example: a simple recursive print of the elements of a list.
 (WITH-RECURSION ((x) '(1 2 3))
    (WHEN x 
      (PRINT (CAR x))
      (RECURSE (CDR x))))*"
  `(LABELS ((.with-recursion. ,lambda-list . ,(replace-recurse-calls body)))
     (.with-recursion. . ,args-for-first-call)))

;1; These first three are just some accessor functions.  JPR put them in SI since that's where flavors live.*
;1; *TAC 09-02-891 - David Gray suggests they should stay in TV package.*

;1; Return the message in METHOD-SPEC.*
(DEFUN 4message* (method-spec)
  (IF (FIFTH method-spec)
      (FOURTH method-spec)
      (CAR (LAST method-spec))))

;1; Return the method type in METHOD-SPEC if there is one, else return NIL.*
;1; Example method types: :AFTER, :BEFORE, :CASE, :AROUND, :WRAPPER, :OR, :AND...*
(DEFUN 4method-type* (method-spec)
  (WHEN (FOURTH method-spec)
    (THIRD method-spec)))

;1; Return the submessage in METHOD-SPEC if there is one.*
;1; Example: :INSPECTORS in (:METHOD TV:FLAVOR-INSPECTOR :CASE :SET :INSPECTORS).*
(DEFUN 4submessage* (method-spec)
  (FIFTH method-spec))

;1; Use of these globals avoids some excess consing.*
(DEFPARAMETER 4*blank-line-item** '(""))
(DEFPARAMETER 4*one-space-item** "3 *")
(DEFPARAMETER 4*no-items** '(((:font 2 "3 none*"))))

#|
3The following is a series of flavors which make up the main smarts of the flavor inspector.
Each flavor is used to represent and provide operations on a particular kind of flavor
information.  The main smarts reside in each flavor's :GENERATE-ITEM method, which
return two values. The first value is a list of items to display in an inspection pane 
(text scroll window).  The second value is a string to display in the pane's window label.
See documentation on flavor TV:INSPECTION-DATA for details of how these flavors work.*
|#

(DEFFLAVOR 4flavor-operation-mixin* () (inspection-data))

(DEFMETHOD 4(flavor-operation-mixin :who-line-doc*) (inspection-pane? &optional no-sensitive-item?)
  (COND
    (no-sensitive-item?
     `(:mouse-l-1 "3Choose an item to inspect*"
       :mouse-m-2 "3Lock/Unlock inspector pane*"
       :mouse-r-1 ,(FORMAT nil "3Menu of operations on ~s*" (si::flavor-name data))))
    (inspection-pane?
      '(:mouse-l-1 "3Inspect this flavor information*"
	:mouse-m-1 "3Inspect this information and display this pane's contents in middle pane*"
        :mouse-m-2 "3Lock/Unlock inspector pane*"
	:mouse-r-1 "3Menu of other operations*"))
    (t
     '(:mouse-l-1 "3Inspect this flavor information*"
       :mouse-m-1 "3Inspect this flavor information*"
       :mouse-m-2 "3Lock/Unlock inspector pane*"
       :mouse-r-1 "3Menu of other operations*")))) 

;1; 01/06/89 clm added eval-when - need to combine the following three forms*
(EVAL-WHEN (LOAD compile)
(DEFPARAMETER 4*flavor-options-menu**
   '(("3Instance Variables*"
      :eval (SEND ucl::this-application :inspect-thing 'show-instance-variables *flavor-data*)
      :documentation "3Inspect all instance variables of this flavor*")
     ("" :no-select t)
     ("3Local Methods*"
      :eval (SEND ucl::this-application :inspect-thing 'show-local-methods *flavor-data*)
      :documentation "3Inspect methods defined locally for this flavor*")
     ("3All Methods*"
      :eval (SEND ucl::this-application :inspect-thing 'show-all-methods *flavor-data*)
      :documentation "3Inspect methods defined for and inherited by this flavor*")
     ("3All Methods, Sorted*"
      :eval (SEND ucl::this-application :inspect-thing 'show-all-methods-sorted *flavor-data*)
      :documentation "3Sorted version of the \" ALL METHODS\" option*")
     ("3All Handled Messages*"
      :eval (SEND ucl::this-application :inspect-thing 'show-all-handled-messages *flavor-data*)
      :documentation "3Inspect all messages handled by this flavor.*")
     ("" :no-select t)
     ;1; This needs better who-line doc.  How it differs from Show Flavor.*
     ("3Component Flavors*"
      :eval (SEND ucl::this-application :inspect-thing 'show-component-flavors *flavor-data*)
      :documentation "3Inspect flavors which make up this flavor (non-heirarchical display).*")
     ("3Dependent Flavors*"
      :eval (SEND ucl::this-application :inspect-thing 'show-dependent-flavors *flavor-data*)
      :documentation "3Inspect flavors which directly or indirectly depend on this flavor*")
     ("" :no-select t)
     ("3Miscellaneous Data*"
      :eval (SEND ucl::this-application :inspect-thing 'show-miscellaneous-data *flavor-data*)
      :documentation "3Display miscellaneous data on this flavor*")
     ("3Edit*"
      :eval (SETQ call-edit t)   ;1;;(ed (si:flavor-name *flavor-data*))*
      :documentation "3Edit this flavor in a Zmacs buffer.*")))
;1     ("Debug"*
;1      :EVAL (BEEP)*
;1      :DOCUMENTATION "Find inconsistencies and dangerous characteristics of this flavor"))) *
)

;1; 7/15/88 clm - adding implementation of DEBUG command into flavor inspector*
;1; 9/19/88 clm - wrapped the eval-when around the form.*
(EVAL-WHEN (LOAD compile)
(DEFPARAMETER 4*flavor-options-menu-addition**
	      '("2Debug*"
		:eval (SEND ucl:this-application :inspect-thing 'debug-flavor *flavor-data*)
		:documentation "3Find inconsistencies and dangerous characteristics of this flavor (can be slow)*"))  
)

(EVAL-WHEN (LOAD compile)
  (IF (NOT (MEMBER *flavor-options-menu-addition* *flavor-options-menu* :test #'EQUALP))
      (SETQ *flavor-options-menu*
	    (APPEND *flavor-options-menu* (LIST *flavor-options-menu-addition*))))  
)

;1; Handles mouse clicks on the mouse-sensitive item which represents the inspection-data.  For*
;1; example, each piece of flavor info gets a mouse sensitive item in the inspection history.*
;1; Some flavor infos such as SHOW-FLAVOR get mouse sensitive items placed in inspection panes,*
;1; as part of other flavor info displays.  For instance, the SHOW-DEPENDENT-FLAVORS display*
;1; contains lots of mouse sensitive SHOW-FLAVOR items.*
(DEFMETHOD 4(flavor-operation-mixin :handle-mouse-click*) (blip flavor-inspector)
  (SELECTOR (FOURTH blip) =
    (#\Mouse-l-1 (SEND flavor-inspector :inspect-info-left-click))
    (#\Mouse-m-1 (SEND flavor-inspector :inspect-info-middle-click))
    (#\Mouse-r-1 (LET ((*flavor-data* data) (call-edit nil))
                   (DECLARE (SPECIAL *flavor-data* call-edit))
                   (w:menu-choose *flavor-options-menu*
                                          :label (FORMAT nil "3Operations on ~S*" (si::flavor-name data))
                                          :scrolling-p nil)
		   (IF call-edit
		       (ED (si::flavor-name *flavor-data*)))
		   ))
    (t
     (BEEP))))

(DEFFLAVOR 4show-flavor* () (flavor-operation-mixin))

(DEFMETHOD 4(show-flavor :format-concisely*) (STREAM)
  (FORMAT stream "3~s*" (si::flavor-name data)))

(DEFMETHOD 4(show-flavor :who-line-doc*) (inspection-pane? &optional no-sensitive-item?)
  (COND
    (no-sensitive-item?
     `(:mouse-l-1 "3Choose an item to inspect*"
       :mouse-m-2 "3Lock/Unlock inspector pane*"
       :mouse-r-1 ,(FORMAT nil "3Menu of operations on ~s*" (si::flavor-name data))))
    (inspection-pane?
      '(:mouse-l-1 "3Inspect this flavor*"
        :mouse-m-1 "3Inspect this flavor and display this pane's contents in middle pane*"
        :mouse-m-2 "3Lock/Unlock inspector pane*"
	:mouse-r-1 "3Menu of other operations*"))
    (t
     '(:mouse-l-1 "3Inspect this flavor*"
       :mouse-m-1 "3Inspect this flavor*"
       :mouse-m-2 "3Lock/Unlock inspector pane*"
       :mouse-r-1 "3Menu of other operations*")))) 

(DEFMETHOD 4(show-flavor :generate-item*) ()
  (LET* ((flavor-name (si::flavor-name data))
	 (all-components (flavor-components flavor-name))
	 text-items
	 redundant-included-flavor?
	 redundant-mixin-flavor?)
    (DECLARE (SPECIAL redundant-included-flavor? redundant-mixin-flavor?))
    (SETQ text-items (collect-dependent-flavors flavor-name 1 all-components all-components))
    (VALUES
     `(,*blank-line-item*
       ((:font 1 "3Flavor *")
        (:item1 instance ,(allocate-data 'show-flavor data))
	(:font 1 "3's component flavors.*")
	,@(WHEN redundant-mixin-flavor?
	    '((:font 2 "3  **")
              (:font 1 "3 = redundant mixin  *")))
	,@(WHEN redundant-included-flavor?
	    '((:font 2 "3  ***")
              (:font 1 "3 = redundant included flavor*"))))
       ,*blank-line-item*
	;1; For each component method, a mouse sensitive method name (METHOD-NAME).*
       ,@(OR text-items *no-items*))
     ;1; Make the label display the flavor name.*
     `(:font fonts:hl12bi :string ,(FORMAT nil "3~s*" flavor-name)))))  

(DEFFLAVOR 4show-undefined-flavor* ()
	   (flavor-operation-mixin)
  (:documentation :special-purpose
		  "3This flavor is like show-flavor only it is used to display undefined flavors.
   The value of the data field is the name of the undefined flavor.*"))
      
(DEFMETHOD 4(show-undefined-flavor :aux-data*) ()
"2Defined so that * gets set suitably.*"
  data)
      
(DEFMETHOD 4(show-undefined-flavor :format-concisely*) (STREAM)
"2Prints an undefined flavor simply.*"
  (FORMAT stream "3~s (Undefined)*" data))
      
(DEFMETHOD 4(show-undefined-flavor :generate-item*) ()
  "2Displays an undefined flavor in all its glory.*"
  (allocate-data 'show-undefined-flavor data)
  (VALUES
    `(,*blank-line-item*
      ((:font 1 ,(SYMBOL-NAME data))
       (:font 3 "3 (Undefined)*")
       )) 
    ;1;Make the label display the flavor name.*
    `(:font fonts:hl12bi :string ,(FORMAT nil "3~s*" data))))
      
(DEFMETHOD 4(show-undefined-flavor :who-line-doc*) (inspection-pane? &optional no-sensitive-item?)
  (COND
    (no-sensitive-item?
     `(:mouse-l-1 "3Inspect this flavor*"
		  :mouse-r-1 ""))
    (inspection-pane?
     '(:mouse-l-1 "3Inspect this flavor*"
		  :mouse-m-1 "3Inspect this flavor and display this pane's contents in middle pane*" 
		  :mouse-r-1 ""))
    (t
     '(:mouse-l-1 "3Inspect this flavor*"
		  :mouse-m-1 "3Inspect this flavor*"
		  :mouse-r-1 ""))))
      
(DEFMETHOD 4(show-undefined-flavor :handle-mouse-click*) (blip flavor-inspector)
  "2A dummy mouse handler for undefined flavors.*"
  (SELECTOR (FOURTH blip) =
    (#\Mouse-l-1
     (SEND flavor-inspector :inspect-info-left-click))
    (#\Mouse-m-1
     (SEND flavor-inspector :inspect-info-middle-click))
    (t
     (BEEP))))

(DEFUN 4flavor-components* (flavor-name &optional (top-level? t))
  "2Returns a list (<flavor name> <included flavors> <component flavors>)
 where <flavor name> is argument FLAVOR-NAME,
 <included flavors> is a list of entries representing FLAVOR-NAME's included flavors, and
 <component flavors> is a list of entries representing FLAVOR-NAME's mixins.
 Entries in <included flavors> and <component flavors> are of the same form as the value
 we are returning; in otherwords, we are returning a recursive data structure.*"
  (LET* ((flavor (GET flavor-name 'si::flavor))
	 ;1; 7/12/88 clm - do not enter debugger if flavor undefined*
	 (result (IF flavor
		     `(,flavor-name
		       ,(LOOP for included in (si::flavor-includes flavor)
			      collect (flavor-components included nil))
		       ,(LOOP for component in (si::flavor-depends-on flavor)
			      collect (flavor-components component nil)))
		     (LIST flavor-name))))
    ;1; Add on vanilla flavor at end of top-level flavor, unless it's an abstract flavor.*
    (WHEN (AND top-level? (NOT (si::flavor-get flavor :no-vanilla-flavor)))
      (SETF (THIRD result) (NCONC (THIRD result) '((si:vanilla-flavor nil nil)))))
    result))

;1; Use of these helps save some memory.*
(DEFPARAMETER 4*space-format** "3~v@t*") 
(DEFPARAMETER 4*space-format-2** "3~v@t *") 

;1; Returns a list of text scroll window items which describe in detail FLAVOR-NAME's*
;1; makeup, including its mixins, its mixins mixins, and any included flavors.  Any mixins or*
;1; included flavors which occur redundantly are flagged as such.*
;1; Also sets two specials (redundant-included-flavor? and redundant-mixin-flavor? to non-nil if*
;1; at least one redundant included flavor or one mixin flavor was encountered, respectively.*
;1; PRINT-LEVEL determines indentation level for text scroll window items. *
;1; ALL-COMPONENTS is the structure of FLAVOR-NAME returned by FLAVOR-COMPONENTS.*
;1; POINTER is a pointer into ALL-COMPONENTS, indicating the particular entry we are generating text scroll window items for.*
;1; We do our work by calling ourself recursively; in such calls, ALL-COMPONENTS never changes, while POINTER moves about in*
;1; ALL-COMPONENTS.*
(DEFUN 4collect-dependent-flavors* (flavor-name print-level all-components pointer)
  ;1; 7/12/88 clm - whenever a component is allocated it is done so as a show-flavor if the flavor is defined,*
  ;1; and a show-undefined-flavor if it is not.*
  (DECLARE (SPECIAL redundant-included-flavor? redundant-mixin-flavor?))
  (LET* ((flavor (GET flavor-name 'si::flavor)))
    `(,@(LOOP for included-entry in (SECOND pointer)
	      for included = (CAR included-entry)
	      collect
	      ;1;If this entry is the last included flavor and is not a mixin...*
	      (IF (AND (EQ included-entry (last-included-occurance included all-components))
			;1;We use this to try to find ANY mixin occurance; *
		       (NOT (first-mixin-occurance included all-components))) 
		  `((,*space-format* ,print-level)
		    (:item1 instance ,(IF (GET included 'si::flavor)
					  (allocate-data 'show-flavor (GET included 'si::flavor))
					  (allocate-data 'show-undefined-flavor included)))
		    (:font 1 "3 (included flavor of *")
		    (:item1 instance ,(IF flavor
					  (allocate-data 'show-flavor flavor)
					  (allocate-data 'show-undefined-flavor flavor-name)))
		    (:font 1 "3)*"))
		(SETQ redundant-included-flavor? t)
		`((,*space-format* ,print-level)
		  (:item1 instance ,(IF (GET included 'si::flavor)
					(allocate-data 'show-flavor (GET included 'si::flavor))
					(allocate-data 'show-undefined-flavor included)))
		  (:font 2 "3***")
		  (:font 1 "3 (included flavor of *")
		  (:item1 instance ,(IF flavor
					(allocate-data 'show-flavor flavor)
					(allocate-data 'show-undefined-flavor flavor-name)))
		  (:font 1 "3)*")))
	      append (collect-dependent-flavors included (+ 2 print-level) all-components included-entry))
      . ,(LOOP for mixin-entry in (THIRD pointer)
	      for mixin = (CAR mixin-entry)
	      collect
	       ;1;If this entry is the first mixin...*
	      (IF (EQ mixin-entry (first-mixin-occurance mixin all-components))
		  `((,*space-format* ,print-level)
		    (:item1 instance ,(IF (GET mixin 'si::flavor)
					  (allocate-data 'show-flavor (GET mixin 'si::flavor))
					  (allocate-data 'show-undefined-flavor mixin))))
		  ;1; else*
		  (SETQ redundant-mixin-flavor? t)
		  `((,*space-format* ,print-level)
		    (:item1 instance ,(IF (GET mixin 'si::flavor)
					  (allocate-data 'show-flavor (GET mixin 'si::flavor))
					  (allocate-data 'show-undefined-flavor mixin)))
		    (:font 2 "3**")))
	      append (collect-dependent-flavors mixin (+ 2 print-level) all-components mixin-entry))))) 

(DEFUN 4map-with-args* (some-function over-a-list &rest other-arguments)
"2This function is much like mapcar only more useful.  It takes a function and a 
 list to map the function over and an &Rest arguments feature.  It applies the   
 function to each element in the list, with the element being the first
 argument and any subsequent arguments being taken from the &Rest paremeter. 
 The value of a call to this function is a list of values from this function
 call, one element for each element in the source list.*"  
  (LOOP for element in over-a-list
	collect (APPLY some-function element other-arguments)))

(DEFUN 4uniqueise* (LIST)
"2Takes a list and returns a list which has no duplicates.*"
  (LET ((temp-list list))
       (LOOP for element in temp-list
	     do (SETQ temp-list (REST temp-list))
	     when (NOT (MEMBER element temp-list :test #'EQUALP))
	     collect element into result
	     finally (RETURN result))))

(DEFUN 4get-local-defined-components* (flavor)
"2Given a flavor structure it returns a list of the flavor structures that
represent its defined local components and locally defined included flavors.*"
  (LET ((local-components (APPEND (si::flavor-depends-on flavor) (si::flavor-includes flavor))))
       (LET ((defined-components (DELETE nil (map-with-args #'GET local-components 'si::flavor))))
	    (VALUES local-components defined-components))))

(DEFUN 4get-flavor-depends-on-all* (flavor)
"2Given a flavor structure it returns a list of all of the names of defined
components of that flavor, including itself.*"
  (MULTIPLE-VALUE-BIND (local-components defined-components) (get-local-defined-components flavor)
    (IGNORE local-components)
    (CONS (si::flavor-name flavor)
	  (uniqueise (APPEND (MAPCAR #'si::flavor-name defined-components)
			     (APPLY #'APPEND (MAPCAR #'get-flavor-depends-on-all defined-components)))))))

(DEFUN 4get-flavor-depends-on-all-even-undefined* (flavor)
"2Given a flavor structure it returns a list of all of the names of all of the
components of that flavor, including itself, whether defined or not.*"
  (MULTIPLE-VALUE-BIND (local-components defined-components)
      (get-local-defined-components flavor)
    (CONS (si::flavor-name flavor)
	  (uniqueise (APPEND local-components
			     (APPLY #'APPEND
				    (MAPCAR #'get-flavor-depends-on-all-even-undefined defined-components))
			     )))))

(DEFUN 4get-all-components* (flavor)
  "2Given a flavor structure it returns a list of the flavor structures of
 all of the defined components of that flavor, excluding itself.*"
  (MULTIPLE-VALUE-BIND (local-components defined-components) (get-local-defined-components flavor)
    (IGNORE local-components)
    (APPEND defined-components (APPLY #'APPEND (MAPCAR #'get-all-components defined-components)))))

(DEFUN 4first-mixin-occurance* (mixin remaining-components)
  (DOLIST (mixin-entry (THIRD remaining-components))
    ;1; First check a mixin.*
    (IF (EQ mixin (CAR mixin-entry))
	(RETURN mixin-entry))
    ;1; Then check the mixin's mixins.*
    (LET ((found (first-mixin-occurance mixin mixin-entry)))
      (IF found
	  (RETURN found)))))

(DEFUN 4last-included-occurance* (included remaining-components &optional last-encountered)
  ;1; First search the included flavors, in the CADR of REMAINING-COMPONENTS.*
  (DOLIST (included-entry (SECOND remaining-components))
    ;1; First check an included flavor.*
    (IF (EQ included (CAR included-entry))
	(SETQ last-encountered included-entry))
    ;1; Then check the included flavor's mixins' included flavors and mixins.*
    (LET ((found (last-included-occurance included included-entry last-encountered)))
      (IF found
	  (SETQ last-encountered found))))
  ;1; Then check the mixin flavors, in the CADDR of REMAINING-COMPONENTS.*
  (DOLIST (mixin-entry (THIRD remaining-components))
    (LET ((found (last-included-occurance included mixin-entry last-encountered)))
      (IF found
	  (SETQ last-encountered found))))
  last-encountered)

(DEFMETHOD 4(show-flavor :help*) ()
  (LET ((flavor-name (si::flavor-name data)))
    (FORMAT nil "
3The inspection pane you just selected is currently displaying a heirarchy of flavors which
make up flavor ~s.  Indentation is used to show the origin of each component
flavor.  Flavors displayed along the left margin are \"direct components\" of flavor ~s.
That is, they appear in the component flavors list of the DEFFLAVOR for ~s.  Flavors
indented further from the left margin are \"indirect components\" of ~s, inherited from
its direct components.

Special cases:
  1. Often a flavor will have two or more components which all supply some flavor as an
     inherited component.  In these cases, the redundant component flavors are flagged
     in the displayed heirarchy with an asterisk (*) next to the flavor name.

  2. Often component flavors define an \"included flavor\" which is added to the
     main flavor (in this case, ~s) if the main flavor is not otherwise going to 
     receive it as either a direct or indirect component.  Such included flavors are
     flagged in the displayed heirarchy with a note to the right of the flavor name.
     In addition, if ~s does receive the included flavor as a direct or indirect
     component, the included flavor is flagged with a double asterisk (**).
     For example, if flavor FOO includes BAR and BAR is flagged with **, the main
     flavor did not receive BAR from flavor FOO.*"
	    flavor-name flavor-name  flavor-name flavor-name  flavor-name flavor-name)))

(DEFFLAVOR 4show-component-flavors* () (flavor-operation-mixin))

(DEFMETHOD 4(show-component-flavors :format-concisely*) (STREAM)
  (FORMAT stream "3~s's component flavors*" (si::flavor-name data)))

;1; This differs from SHOW-FLAVOR's in that it just displays a flat list of the component flavors.*
;1; Included and redundant flavors are not tagged.  Doesn't show the flavor heirarchy--just the result.*
;1; This is easier to read, but less informational.*
(DEFMETHOD 4(show-component-flavors :generate-item*) ()
  ;1; 7/121/88 clm - prevent entering debugger if flavor undefined*
;1  (UNLESS (SI:FLAVOR-DEPENDS-ON-ALL data)*
;1    (SI:COMPOSE-FLAVOR-COMBINATION data))*
  (LET* ((flavor-name (si::flavor-name data))
  ;1;Modded here by JPR.*
	 (component-flavors (CDR (get-flavor-depends-on-all-even-undefined data))))
    (VALUES
      `(,*blank-line-item*
	("3Component flavors of flavor *"
	 (:item1 instance ,(allocate-data 'show-flavor data))
	 "3:*")
	,*blank-line-item*
	. ,(OR (LOOP for component in component-flavors
		     ;1;Modded here by JPR.*
		     collect `(,*one-space-item*
			       (:item1 instance ,(IF (GET component 'si::flavor)
			  				       (allocate-data 'show-flavor (GET component 'si::flavor))
			  				       (allocate-data 'show-undefined-flavor component)))))
	       *no-items*))
      `(:font fonts:hl12bi :string ,(FORMAT nil "3~s's component flavors*" flavor-name)))))  

(DEFMETHOD 4(show-component-flavors :help*) ()
  (LET ((flavor-name (si::flavor-name data)))
    (FORMAT nil "
3The inspection pane you just selected is currently displaying the
component flavors which make up flavor ~s.  The display does not show the flavor heirarchy;
for a look at the flavor heirarchy, type ~s followed by RETURN, or click L on any 
mouse sensitive display of ~s in the Flavor Inspector.

This display is useful when you are not interested in examining the flavor heirarchy but
are instead interested in seeing the resultant components of a flavor.*"
	    flavor-name flavor-name flavor-name)))

(DEFFLAVOR 4show-dependent-flavors* () (flavor-operation-mixin))

(DEFMETHOD 4(show-dependent-flavors :format-concisely*) (STREAM)
  (FORMAT stream "3~s's dependent flavors*" (si::flavor-name data)))

(DEFMETHOD 4(show-dependent-flavors :generate-item*) ()
  (LET* ((flavor-name (si::flavor-name data)))
    (VALUES
     `(,*blank-line-item*
       ((:font 1 "3Heirarchy of flavors directly or indirectly dependent on flavor *")
	(:item1 instance ,(allocate-data 'show-flavor data))
        "3:*")
       ,*blank-line-item*
;1; I tried to get this OR to work, but ITEMS always returns NIL.  Compiler problem?*
;	1. ,(OR (LET (items*
       ,@(LET (items
	       flavors)
	   (with-recursion ((dependent-flavors indentation) (si::flavor-depended-on-by data) 0)
	    (DOLIST (dependent-flavor dependent-flavors)
	      (UNLESS (MEMBER dependent-flavor flavors :test #'EQ)
		(PUSH dependent-flavor flavors)
		(PUSH-END
		 `((,*space-format* ,(1+ (* 2 indentation)))
		   (:item1 instance ,(allocate-data 'show-flavor (GET dependent-flavor 'si::flavor))))
		 items))
	      (recurse (si::flavor-depended-on-by (GET dependent-flavor 'si::flavor)) (1+ indentation))))
	   items))
;1     *	1       *no-items*))*
     `(:font fonts:hl12bi :string ,(FORMAT nil "3~s's dependent flavors*" flavor-name))))) 

(DEFMETHOD 4(show-dependent-flavors :help*) ()
  (LET ((flavor-name (si::flavor-name data)))
    (FORMAT nil "
3The inspection pane you just selected is currently displaying a heirarchy
of flavors which depend on flavor ~s.  Indentation is used to show the origin of each 
dependency.  Flavors displayed along the left margin are \"direct dependents\" of flavor ~s.
That is, ~s appears in the component flavors list of their DEFFLAVORs.  Flavors
indented further from the left margin are \"indirect dependents\" of ~s, inheriting it from
the flavors displayed above and to the left of them.*"
	    flavor-name flavor-name  flavor-name flavor-name)))

(DEFFLAVOR 4show-local-methods* () (flavor-operation-mixin))

(DEFMETHOD 4(show-local-methods :format-concisely*) (STREAM)
  (FORMAT stream "3~s's local methods*" (si::flavor-name data)))

;1;7/13/88 clm for may - the function below did not always calculate the PACKAGE correctly *
;1;  and the commented IF needed to be in there(?); just use FLATSIZE instead.*
(DEFF 4symbol-string-length* #'format::flatsize)
;1(DEFUN SYMBOL-STRING-LENGTH (SYMBOL)*
;1  "Return the length of the string that would be returned by (FORMAT NIL \"~S\" SYMBOL).*
;1Use of this function keeps you from having to generate such a string, if all you need is the length."*
;1  (+*
;1   (LET ((PKG (SYMBOL-PACKAGE SYMBOL)))*
;1     (COND*
;1       ((OR (EQ PKG *PACKAGE*) (EQ PKG PKG-GLOBAL-PACKAGE)) 0)*
;1       ((EQ PKG PKG-KEYWORD-PACKAGE) 1)*
;1       (T*
;	1(+*
;	1 (LENGTH (OR (CAR (PACKAGE-NICKNAMES PKG)) (PACKAGE-NAME PKG)))*
;	1 ;;This could be made more efficient by only doing what you need INTERN-SOFT to do.*
;	1; (IF (EQ (NTH-VALUE 1 (FIND-SYMBOL SYMBOL PKG)) :INTERNAL)*
;	1;   2*
;	1   1))))*
;1   (LENGTH (SYMBOL-NAME SYMBOL)))) *

;1; This is used by most of the operations which display methods.*
;1; Loops through methods stored in METHOD-TABLE, collecting text scroll items for each method.*
;1; ENTRY is bound to a method table entry during each iteration.*
;1; METHOD is bound to an element in the CDDDR of ENTRY on each iteration through ENTRY's combined methods.*
;1; PREDICATE can be supplied to control which methods are collected.*
;1; INCLUDE-COMBINED? controls whether or not :COMBINED methods are included.*
;1; WITH-FLAVOR-NAME? controls whether or not to include the flavor name of each method.  On displays where all the methods*
;1; are from the same flavor, this option is NIL.*
;1; Returns two values: the item list to display and a flag indicating whether or not any of the displayed methods*
;1; had special method combination types.*
(EVAL-WHEN (COMPILE eval load)
(DEFMACRO 4collect-method-items* ((entry method method-table) predicate 
				&optional include-combined? with-flavor-name?)
  `(LOOP with .any-special-method-combination?.
	 for ,entry in ,method-table
	 for .methods. = (LOOP for ,method on (REMOVE-IF-NOT 'si::meth-definedp (CDDDR ,entry)) ;1; subset*
			       ;1; Automatically exluced any :COMBINED methods, since they are generated by the *
			       ;1; flavor system for internal use.*
			       when ,(IF include-combined?
					 predicate
					 `(AND ,predicate (NEQ (THIRD (CAAR ,method)) :combined)))
			       collect ,(IF with-flavor-name?
					    ``((:item1 instance 
						       ,(allocate-data 'show-flavor 
								       (GET (SECOND (CAAR ,method)) 'si::flavor)))
					       (,*space-format*
						,(+ (- 29. (symbol-string-length (SECOND (CAAR ,method))))
						    (- 15. (IF (FOURTH (CAAR ,method))
							       (symbol-string-length (THIRD (CAAR ,method)))
							       0))))
					       (:item1 instance ,(allocate-data 'show-method (CAR ,method))))
					    ``((,*space-format-2*
						,(- 15. (IF (FOURTH (CAAR ,method))
							    (symbol-string-length (THIRD (CAAR ,method)))
							    0)))
					       (:item1 instance ,(allocate-data 'show-method (CAR ,method)))))
			       and do (WHEN (SECOND (CAR ,method))
					(SETQ .any-special-method-combination?. t)))
	 when .methods.
	 append .methods. into .collection.
	 finally (RETURN .collection. .any-special-method-combination?.))))

;1; The fields sizes were generated haphazardly, since we're using a variable width font.*
(DEFPARAMETER 4*method-display-columns**
   `((:font 2 ,(FORMAT nil "3~8@T~10A~33A~10A*" "3Type*" "3Message*" "3Arglist*")))) 

(DEFMETHOD 4(show-local-methods :generate-item*) ()
  (LET* ((flavor-name (si::flavor-name data))
	 ;1; Sort for readability.  There might be a better place to do the sort; for instance,*
	 ;1; always maintain a sorted entry for SHOW-METHOD in *INSPECTION-DATA*.*
	 (method-table (SORTCAR (COPY-LIST (si::flavor-method-table data)) #'STRING-LESSP))
	 (get-methods (get-methods data))
	 (set-methods (set-methods data)))
    (MULTIPLE-VALUE-BIND (items special-comb?)
      (collect-method-items (m tpl method-table)
                            (NOT (OR (MEMBER (CAR m) get-methods :test #'EQ)
                                     (MEMBER (CAR m) set-methods :test #'EQ))))
      (VALUES
       `(,*blank-line-item*
	 ((:font 1 "3Methods defined for flavor *")
	  (:item1 instance ,(allocate-data 'show-flavor data))
	  (:font 1 ,(IF special-comb?
		      "3.  * = special method combination type*"
		      "3:*")))
	  ;1; Collect the methods, excluding any GET and SET methods, which we want to list separately (for readability).*
	 ,@(IF items
	     (CONS *method-display-columns* items)
	     *no-items*)
	  ;1; Separate the display of :GET and :SET methods from the main body of defined methods,*
	  ;1; since most of these are trivial and automatically generated by the flavor system.*
	 ,*blank-line-item*
	 ((:font 1 "3 GET methods for instance variables of flavor *")
	  (:item1 instance ,(allocate-data 'show-flavor data)) (:font 1 "3:*"))
	 ,@(OR
	    (collect-method-items (m tpl method-table) (MEMBER (CAR m) get-methods :test #'EQ))
	    *no-items*)
	 ,*blank-line-item*
	 ((:font 1 "3 SET methods for instance variables of flavor *")
	  (:item1 instance ,(allocate-data 'show-flavor data))
          (:font 1 "3:*"))
	 ,@(OR
	    (collect-method-items (m tpl method-table) (MEMBER (CAR m) set-methods :test #'EQ))
	    *no-items*))
       `(:font fonts:hl12bi :string ,(FORMAT () "3~s's local methods*" flavor-name)))))) 

(DEFUN 4get-methods* (flavor)
  "2Returns a list of FLAVOR's GET messages.*"
  (LOOP with keyword-package = (SYMBOL-PACKAGE :foo)
	for ivar in (si::flavor-get flavor :gettable-instance-variables)
	collect (INTERN ivar keyword-package)))

(DEFUN 4set-methods* (flavor)
  "2Returns a list of FLAVOR's SET messages.*"
  ;1; The cons includes the :CASE :SET methods generated for each settable instance variable by the flavor system.*
  (CONS :set
	(LOOP with keyword-package = (SYMBOL-PACKAGE :foo)
	      for ivar in (si::flavor-get flavor :settable-instance-variables)
 	      collect (INTERN (FORMAT nil "3SET-~a*" ivar) keyword-package))))

(DEFUN 4assmemq* (x list)
  "2Combined ASSQ and MEMQ.*"
  (DOLIST (entry list)
    (COND
      ((EQ x entry)
       (RETURN entry))
      ((AND (LISTP entry) (EQ x (CAR entry)))
       (RETURN entry)))))

(DEFMETHOD 4(show-local-methods :help*) ()
  (LET ((flavor-name (si::flavor-name data)))
    (FORMAT nil "
3The inspection pane you just selected is currently displaying the methods
defined for flavor ~s.  Methods inherited from ~s's flavor components are NOT displayed. 
(\"All Methods\" and \"All Methods, Sorted\" options are available for viewing inherited methods.)

This display is divided into three sections:

  1. The first section displays methods defined explictly for ~s via DEFMETHOD.  Typically
     this section is the largest and most interesting of the three sections.

  2. The second section displays methods (usually) generated by the flavor system for
     use in fetching instance variable values.  These methods are commonly termed \"GET methods\".

  3. The last section displays methods (usually) generated by the flavor system for
     use in setting instance variable values.  These methods are commonly termed \"SET methods\".

The separation of GET and SET methods from the main body of methods is done only to help
you better understand flavor ~s.  Within the flavor system these methods are not separated in
any way whatsoever.  In fact, often flavors define their own GET and SET methods,
instead of accepting the versions the flavor system automatically generates.  This display
does not flag such definitions.

Each method is displayed by its type, message name, and argument list.  Further information
can be obtained by using the mouse.  Method types are any of the following:
 :AFTER, :AND, :AROUND, :BEFORE, :CASE, :DEFAULT, :OR, :OVERRIDE, :WRAPPER.
If a type is not present, the displayed method is a \"primary method\".  Type :WRAPPER
indicates wrappers (defined via DEFWRAPPER).  The rest are the standard, documented method
types.  Note that :COMBINED methods are not displayed, since they are seen as relatively
uninteresting and tend to add clutter.

Most methods are combined using the default method combination type :DAEMON.  However,
if a displayed method is combined using one of the other combination types (such as
:OR, :AND, or :CASE), an asterisk (*) is placed to the left of the method type.  Clicking
left on the method will show detailed information which includes the type of method 
combination used.*	3    *"
;1; This doc string brings up two points:*
;1; 1.  We could flag explicitly defined GET and SET methods by examining the method FEFs to see if *
;1;     they contain something other than the machine instructions normally contained in GET and SET methods.*
;1;     However, it might be too inefficient.*
;1; 2.  The display of :COMBINED methods throughout the flavor inspector could be customizable (ON\/OFF)*
;1;      I don't know who wants to see them.*
	    flavor-name  flavor-name flavor-name flavor-name)))

(DEFFLAVOR 4show-all-methods* () (flavor-operation-mixin))

(DEFMETHOD 4(show-all-methods :format-concisely*) (STREAM)
  (FORMAT stream "3~s's methods (all)*" (si::flavor-name data)))

(DEFMETHOD 4(show-all-methods :generate-item*) ()
  ;1; 7/12/88 clm - prevent entering debugger if flavor undefined*
  ;1  (UNLESS (SI:FLAVOR-DEPENDS-ON-ALL data)*
  ;1    (SI:COMPOSE-FLAVOR-COMBINATION data))*
  (VALUES
    ;1; This method borrows alot from SHOW-LOCAL-METHODS :GENERATE-ITEM.*
    ;1; NCONC for efficiency; copy-list to protect last element, which is often *NO-ITEMS*, which must not be destroyed.*
    (NCONC
      (COPY-LIST (SEND (allocate-data 'show-local-methods data) :generate-item))
      (LOOP with top-flavor-method-table = (si::flavor-method-table data)
	    ;1;Modded here by JPR.*
	    for flavor-name in (CDR (get-flavor-depends-on-all data))
	    for flavor = (GET flavor-name 'si::flavor)
	    for method-table = (SORTCAR (COPY-LIST (si::flavor-method-table flavor)) #'STRING-LESSP)
	    for get-methods = (get-methods flavor)
	    for set-methods = (set-methods flavor)
	    nconc (MULTIPLE-VALUE-BIND (items special-com?)
		      (collect-method-items (m tpl method-table) 
					    (AND (NOT (OR (MEMBER (CAR m) get-methods :test #'EQ)
							  (MEMBER (CAR m) set-methods :test #'EQ)))
						 (OR (FOURTH (CAAR tpl))
						     (NOT (ASSOC (THIRD (CAAR tpl))
								 top-flavor-method-table :test #'EQ)))))
		    `(,*blank-line-item*
		      ,*blank-line-item*
		      ((:font 1 "3Methods inherited from flavor *")
		       (:item1 instance ,(allocate-data 'show-flavor flavor))
		       (:font 1 ,(IF special-com? "3.  * = special method combination type*" "3:*")))
		      ;1; Collect the methods, excluding any GET and SET methods,*
		      ;1; which we want to list separately (for readability)*
		      ;1; and any base (non-demonic) methods which have been defined explicitly for DATA.*
		      ;1; (If DATA has it's own*
		      ;1; version of method :FOO, it doesn't really inherit it's mixins versions of :FOO).*
		      ;1; The ASSoc isn't enough--need to check previous mixins too and take into account*
		      ;1; the method combination type and order (:base-flavor-first/:base-flavor-first).*
		      ,@(IF items (CONS *method-display-columns* items) *no-items*)
		      ;1; Separate the display of :GET and :SET methods from the main body of defined methods,*
		      ;1; since most of these are trivial and automatically generated by the flavor system.*
		      ,@(WHEN get-methods
			  `(,*blank-line-item*
			    ((:font 1 "3 GET methods inherited from *")
			     (:item1 instance ,(allocate-data 'show-flavor flavor))
			     (:font 1 "3:*"))
			    . ,(collect-method-items (m tpl method-table)
						     (AND (MEMBER (CAR m) get-methods :test #'EQ)
							  (OR (FOURTH (CAAR tpl))
							      (NOT (ASSOC (THIRD (CAAR tpl))
									  top-flavor-method-table :test #'EQ)))))))
		      ,@(WHEN (> (LENGTH set-methods) 1) ;1;There's always at least a :SET entry.*
			  `(,*blank-line-item*
			    ((:font 1 "3 SET methods inherited from *")
			     (:item1 instance ,(allocate-data 'show-flavor flavor))
			     (:font 1 "3:*"))
			    . ,(collect-method-items (m tpl method-table)
						     (AND (MEMBER (CAR m) set-methods :test #'EQ)
							  (OR (FOURTH (CAAR tpl))
							      (NOT (ASSOC (THIRD (CAAR tpl))
									  top-flavor-method-table :test #'EQ)))))))))))
    `(:font fonts:hl12bi :string ,(FORMAT nil "3~s's methods (all)*" (si::flavor-name data)))))

(DEFMETHOD 4(show-all-methods :help*) ()
  (LET ((flavor-name (si::flavor-name data)))
    (FORMAT nil "
3The inspection pane you just selected is currently displaying all methods
defined for or inherited by flavor ~s.  The methods are presented under section headers which
indicate which component flavor of ~s provides them.  ~s's local methods are displayed in the
first section; subsequent sections are ordered according to precedence in ~s's flavor
heirarchy.

Each flavor's methods are divided into three sections:

  1. The first section displays methods defined explictly for ~s via DEFMETHOD.  Typically
     this section is the largest and most interesting of the three sections.

  2. The second section displays methods (usually) generated by the flavor system for
     use in fetching instance variable values.  These methods are commonly termed \"GET methods\".

  3. The last section displays methods (usually) generated by the flavor system for
     use in setting instance variable values.  These methods are commonly termed \"SET methods\".

The separation of GET and SET methods from the main body of methods is done only to help
you better understand flavor ~s.  Within the flavor system these methods are not separated in
any way whatsoever.  In fact, often flavors define their own GET and SET methods,
instead of accepting the versions the flavor system automatically generates.  This display
does not flag such definitions.

Each method is displayed by its type, message name, and argument list.  Further information
can be obtained by using the mouse.  Method types are any of the following:
 :AFTER, :AND, :AROUND, :BEFORE, :CASE, :DEFAULT, :OR, :OVERRIDE, :WRAPPER.
If a type is not present, the displayed method is a \"primary method\".  Type :WRAPPER
indicates wrappers (defined via DEFWRAPPER).  The rest are the standard, documented method
types.  Note that :COMBINED methods are not displayed, since they are seen as relatively
uninteresting and tend to add clutter.

Most methods are combined using the default method combination type :DAEMON.  However,
if a displayed method is combined using one of the other combination types (such as
:OR, :AND, or :CASE), an asterisk (*) is placed to the left of the method type.  Clicking
left on the method will show detailed information which includes the type of method 
combination used.*"
	    flavor-name flavor-name flavor-name flavor-name flavor-name)))

(DEFFLAVOR 4show-all-methods-sorted* () (flavor-operation-mixin))

(DEFMETHOD 4(show-all-methods-sorted :format-concisely*) (STREAM)
  (FORMAT stream "3~s's methods (sorted)*" (si::flavor-name data)))

;1; The fields sizes were generated haphazardly, since we're using a variable width font.*
(DEFPARAMETER 4*method-display-columns-2**
   `((:font 2 ,(FORMAT nil "3~35A~8T~10A~33A~10A*" "3Flavor*" "3Type*" "3Message*" "3Arglist*")))) 

;1; This COULD star :GET and :SET methods, to add some of the functionality of SHOW-ALL-METHODS.*
(DEFMETHOD 4(show-all-methods-sorted :generate-item*) ()
  ;1; Modded here by JPR.*
  ;1  (UNLESS (SI:FLAVOR-DEPENDS-ON-ALL data)*
  ;1    (SI:COMPOSE-FLAVOR-COMBINATION data))*
  ;1; Same as (SHOW-ALL-METHODS :generate-item), with output formatted differently.*
  (VALUES
;1; The ASSoc isn't enough--need to check previous mixins too and take into account*
;1; the method combination type and order (:base-flavor-first/:base-flavor-first).*
    (LET* ((special-comb?)
	   ;1; Modded here by JPR.*
	   (items (LOOP for flavor-name in (get-flavor-depends-on-all data)
			for flavor = (GET flavor-name 'si::flavor)
			for method-table = (si::flavor-method-table flavor)
			nconc (MULTIPLE-VALUE-BIND (items comb?)
				  (collect-method-items (m tpl method-table) t nil t)
				(WHEN comb?
				  (SETQ special-comb? t))
				items))))
      `(,*blank-line-item*
	((:font 1 "3All Methods of flavor *")
	 (:item1 instance ,(allocate-data 'show-flavor data))
	 (:font 1 ,(IF special-comb? "3.  * = special method combination type*" "3:*")))
	,*blank-line-item*
	,*method-display-columns-2*
	;1; This sorts the methods alphabetically by message, then by method type *
        ;1; (if any), then by submessage (if any).*
	,@(SORT items
		#'(lambda (x y)
		    (LET* ((x-method-spec (CAR (SEND (THIRD (THIRD x)) :data)))
			   (y-method-spec (CAR (SEND (THIRD (THIRD y)) :data)))
			   (x-message (message x-method-spec))
			   (y-message (message y-method-spec)))
		      (IF (EQ x-message y-message)
			  (LET ((x-method-type (method-type x-method-spec)))
			    (IF (AND x-method-type (EQ x-method-type (method-type y-method-spec)))
				(string-lessp-nil-wins (submessage x-method-spec) (submessage y-method-spec))
				(string-lessp-nil-wins x-method-type (method-type y-method-spec))))
			  (STRING-LESSP x-message y-message)))))))
    `(:font fonts:hl12bi :string ,(FORMAT nil "3~s's methods (all)*" (si::flavor-name data))))) 

(DEFUN 4string-lessp-nil-wins* (x y)
  (COND
    ((NULL x) t)
    ((NULL y) nil)
    (t (STRING-LESSP x y))))

(DEFMETHOD 4(show-all-methods-sorted :help*) ()
  (LET ((flavor-name (si::flavor-name data)))
    (FORMAT nil "
3The inspection pane you just selected is currently displaying all methods
defined for or inherited by flavor ~s.  The methods are sorted alphabetically by message name
and method type.  (The \"All Methods\" option provides a more organized display of the methods.)

Each method is displayed by its flavor, type, message name, and argument list.  
Further information can be obtained by using the mouse.  Method types are any of the following:
 :AFTER, :AND, :AROUND, :BEFORE, :CASE, :DEFAULT, :OR, :OVERRIDE, :WRAPPER.
If a type is not present, the displayed method is a \"primary method\".  Type :WRAPPER
indicates wrappers (defined via DEFWRAPPER).  The rest are the standard, documented method
types.  Note that :COMBINED methods are not displayed, since they are seen as relatively
uninteresting and tend to add clutter.

Most methods are combined using the default method combination type :DAEMON.  However,
if a displayed method is combined using one of the other combination types (such as
:OR, :AND, or :CASE), an asterisk (*) is placed to the left of the method type.  Clicking
left on the method will show detailed information which includes the type of method 
combination used.*"
	    flavor-name)))

(DEFFLAVOR 4show-all-handled-messages* () (flavor-operation-mixin))

(DEFMETHOD 4(show-all-handled-messages :format-concisely*) (STREAM)
  (FORMAT stream "3~s's messages (all)*" (si::flavor-name data)))

(DEFMETHOD 4(show-all-handled-messages :generate-item*) ()
  (LET ((ops (OR (si::flavor-which-operations data)
		 (LET (messages)
		   (with-recursion ((comp) (si::flavor-name data))
		     ;1;Modded here by JPR.*
		     (IF (GET comp 'si::flavor)
			 (PROGN (DOLIST (method-entry (si::flavor-method-table (GET comp 'si::flavor)))
				  (PUSHNEW (CAR method-entry) messages))
				(DOLIST (comp (si::flavor-includes (GET comp 'si::flavor)))
				  (recurse comp))
				(DOLIST (comp (si::flavor-depends-on (GET comp 'si::flavor)))
				  (recurse comp)))
			 nil))
		   (SORT messages #'STRING-LESSP)))))
    (VALUES
      `(,*blank-line-item*
	((:font 1 "3Messages handled by flavor *")
	 (:item1 instance ,(allocate-data 'show-flavor data))
	 (:font 1 "3:*"))
	,*blank-line-item*
	((:font 2 "3Message                                     Component Flavors Providing Handlers*"))
;1; This probably lists too many component flavors--those just having a :COMBINED method.*
;1; Plus it lists flavor X and Y where flavor X's method shadows flavor Y's method.*
;1; Once again, need to take method combination into account.*
	,@(LOOP for message in ops
		collect `((:item1 instance ,(allocate-data 'show-message data message))
			  ,@(LOOP with first? = t
				  ;1;Modded here by JPR.*
				  for flavor-name in (get-flavor-depends-on-all data)
				  for flavor = (GET flavor-name 'si::flavor)
				  when (flavor-message-handler? flavor message)
				  if first?
				     collect `(:item1 instance ,(allocate-data 'show-flavor flavor))
				     and do (SETQ first? nil)
				  else
				     collect '("3, *")
				     and collect `(:item1 instance ,(allocate-data 'show-flavor flavor))))))
      `(:font fonts:hl12bi :string ,(FORMAT nil "3~s's messages (all)*" (si::flavor-name data))))))

(DEFUN 4flavor-message-handler?* (flavor message)
  "2Returns non-nil if FLAVOR has some method for MESSAGE, not including any :COMBINED method.*"
  (LOOP for entry in (CDDDR (ASSOC message (si::flavor-method-table flavor) :test #'EQ)) when
     (NEQ (THIRD (CAR entry)) :combined) return t)) 

(DEFMETHOD 4(show-all-handled-messages :help*) ()
  (LET ((flavor-name (si::flavor-name data)))
    (FORMAT nil "
3The inspection pane you just selected is currently displaying all messages handled by
flavor ~s.  The left column displays each message, and the right column 
displays all component flavors of ~s which provide a method (including demons 
and wrappers) for the message.  Clicking on a message name inspects the set of methods
which are invoked when instances of ~s are sent the message.*"
	    flavor-name flavor-name flavor-name)))
  
(DEFFLAVOR 4show-instance-variables* () (flavor-operation-mixin))

(DEFMETHOD 4(show-instance-variables :format-concisely*) (STREAM)
  (FORMAT stream "3~s's instance variables*" (si::flavor-name data)))

;1; This makes sure that the flavor's mixin's instance variables have been included into the flavor.*
(DEFMETHOD 4(show-instance-variables :generate-item*) ()
  ;1; 7/12/88 clm - prevent entering debugger if flavor happens to be undefined.*
;1  (UNLESS (SI::FLAVOR-DEPENDS-ON-ALL data)*
;1    (SI:COMPOSE-FLAVOR-COMBINATION data))*
  (LET* ((flavor-name (si::flavor-name data))
	 (instance-size (si::flavor-instance-size data)))
    (VALUES
      `(,*blank-line-item*
	((:font 1 "3Local to flavor *")
	 (:item1 instance ,(allocate-data 'show-flavor data))
	 (:font 1 "3:*"))
	,@(IF (si::flavor-local-instance-variables data)
	      (local-instance-var-item-list (si::flavor-local-instance-variables data) data data) 
	      *no-items*)
	;1;Modded here by JPR.*
	. ,(LOOP for fname in (CDR (get-flavor-depends-on-all data))
		 for fl = (GET fname 'si::flavor)
		 for local-vars = (si::flavor-local-instance-variables fl)
		 append
		 (WHEN local-vars
		   `(,*blank-line-item*
		     ((:font 1 "3Inherited from *")
		      (:item1 instance ,(allocate-data 'show-flavor fl))
		      (:font 1 "3:*"))
		     . ,(local-instance-var-item-list local-vars fl data)))))
      `(:font fonts:hl12bi :string ,(FORMAT nil "3~S's ~@[~s ~]instance variables*" flavor-name instance-size)))))

(DEFPARAMETER 4*ivar-column-headers**
   `(:font 3
     ,(FORMAT nil
	      "3 Variable~40@tGettable  Settable  Inittable  Special  Default-Value                  *"))) 

;1; Help function for (:METHOD GENERAL-INSPECT-PANE :SHOW-INSTANCE-VARIABLES).*
;1; Returns a text scroll item for instance variables INHERITED-VARIABLES (a list of instance*
;1; variable symbols or symbol consed onto default value).  OF-FLAVOR is passed to allow us*
;1; to have the text indicate whether or not each variable is gettable, settable, and inittable.*
(DEFUN 4local-instance-var-item-list* (inherited-variables inherited-flavor of-flavor)
  (LET* ((init-options?)
	 (items
	  (LOOP for entry in inherited-variables
                for var = (ucl::first-if-list entry)	
                collect `(,*one-space-item* (:item1 instance ,(allocate-data 'show-instance-variable var))
                          (,*space-format* ,(- 36 (symbol-string-length var)))
                          ,*one-space-item*
                          ;1; This might be made more efficient by using constant strings separating the X's.*
                          ,(FORMAT () "3 ~:[   ~; G ~]     ~:[   ~; S ~]    ~:[   ~; I ~]    ~:[    ~; Sp ~]   *"
                                   (MEMBER var (si::flavor-gettable-instance-variables inherited-flavor) :test #'EQ)
                                   (MEMBER var (si::flavor-settable-instance-variables inherited-flavor) :test #'EQ)
                                   (MEMBER var (MAPCAR #'CDR
                                                       (si::flavor-inittable-instance-variables inherited-flavor)) 
					   :test #'EQ)
                                   (MEMBER var (si::flavor-special-instance-variables inherited-flavor) :test #'EQ))
                          ,(IF (SYMBOLP entry)
                               '(:font 2 "3unbound        *")
                               `(:item1 instance ,(allocate-data 'show-value (CADR entry) 24)))
			  ,*one-space-item*
                          ,@(LET* ((init (INTERN var 'keyword))
                                   (f-plist (si::flavor-plist of-flavor))
                                   (init-plist (GETF f-plist :default-init-plist))
                                   (value (GETF init-plist init)))
                              (WHEN (AND value
                                         (MEMBER init (GETF f-plist 'si::all-inittable-instance-variables) :test #'EQ))
                                (SETQ init-options? t)
                                `((:item1 instance ,(allocate-data 'show-value value nil)))))))))
    (IF init-options?
      `((,*ivar-column-headers*
	 (:font 3 ,(FORMAT () "3~s's Initializations*" (si::flavor-name of-flavor))))
	. ,items)
      `((,*ivar-column-headers*) . ,items)))) 

(DEFMETHOD 4(show-instance-variables :help*) ()
  (LET ((flavor-name (si::flavor-name data)))
    (FORMAT nil "
3The inspection pane you just selected is currently displaying all instance variables
of flavor ~s.  The instance variables are presented under section headers which
indicate which component flavor of ~s provides them.  ~s's local instance
variables are displayed in the first section; subsequent sections are ordered according
to precedence in ~s's flavor heiarchy.

The first column displays each instance variable name.  The second through fifth columns
indicate whether each instance variable is gettable, settable, inittable, and special.
The sixth column provides the default value for the variable as defined by the flavor
which provides the variable.  For instance, if ~s mixes in FOO and FOO provides
instance variable BAR, BAR's sixth column will display whatever default value FOO 
specifies.  The seventh column, however, displays the default value which ~s
provides in its :DEFAULT-INIT-PLIST (if it provides any at all).*"
;1; Actually, that probably isn't comprehensive enough.  Need an option which shows *
;1; the ivars alphabetically and which shows what their values will end up being*
;1; when the flavor is instantiated, taking into account all components' :DEFAULT-INIT-PLIST.*
	    flavor-name flavor-name flavor-name flavor-name flavor-name flavor-name)))


(DEFFLAVOR 4show-miscellaneous-data* () (flavor-operation-mixin))

(DEFMETHOD 4(show-miscellaneous-data :format-concisely*) (STREAM)
  (FORMAT stream "3~s's miscellaneous data*" (si::flavor-name data)))

(DEFMETHOD 4(show-miscellaneous-data :generate-item*) ()
  (LET* ((flavor-name (si::flavor-name data))
         (init-keywords (si::flavor-init-keywords data)))
	 ;1; There are some nasty conciderations to make here.  If you show the user the*
	 ;1; method hash table and the property list, he may expect to be able to modify components*
	 ;1; as in the regular Inspector.  Would recommend that this utility remain informational.*
	 ;1; Might add an Inspect command to allow inspection of flavor defstructs.*
    (VALUES
     `(,*blank-line-item* ((:font 1 "3Keywords in the :INIT message handled by this flavor:*"))
       ;1; What can we do on keywords wrt mouse-sensitivity?? Edit-Init-Method might be nice.*
       ,@(IF init-keywords
	   (LOOP for keyword in init-keywords
                 collect (LIST (FORMAT () "3 ~s*" keyword)))
	   *no-items*)
       ,*blank-line-item*
       ((:font 1 "3Flavor was defined in package *") ,(FORMAT () "3~A*" (si::flavor-definition-package data))) ;1 jlm 4/10/89*
       ,*blank-line-item*
       ((:font 1 "3Included Flavors:*"))
       ,@(OR (LOOP for included in (si::flavor-includes data)
                   collect `(,*one-space-item*
                             (:item1 instance ,(allocate-data 'show-flavor (GET included 'si::flavor)))))
             *no-items*)
       ,*blank-line-item*
       ((:font 1 "3Properties:*"))
       ;1; What can we do on properties wrt mouse-sensitivity??*
       
       ,@(IF (NULL (si::flavor-plist data))
	   *no-items*
	   (LOOP for (property value) on (si::flavor-plist data) by #'CDDR
                 collect (LIST (FORMAT () "3 ~S:*" property))
                 append (break-string-into-lines
                          (WITH-OUTPUT-TO-STRING (STREAM)
                            (GRIND-TOP-LEVEL value () stream () 'si::displaced t () (CONS value ())
				  'si::grind-opti-miser 3)))))
       ,*blank-line-item*
       . ,(COND ((NULL (si::flavor-method-hash-table data))
                 `(((:font 1 ,(FORMAT () "3Flavor ~S does not yet have a method hash table.*" flavor-name)))))
                ((EQ t (si::flavor-method-hash-table data))
                 `(((:font 1 ,(FORMAT ()
				    "3Flavor ~S has been method-composed but has no hash table - it is an :ABSTRACT-FLAVOR.*"
                                   flavor-name)))))
                (t
                 (CONS `((:font 1 ,(FORMAT () "3Flavor ~S has method hash table:*" flavor-name)))
                       (break-string-into-lines (WITH-OUTPUT-TO-STRING (STREAM)
                                                  (LET ((*standard-output* stream))
                                                    (DESCRIBE (si::flavor-method-hash-table data)))))))))
     `(:font fonts:hl12bi :string ,(FORMAT () "3~S' miscellaneous data*" flavor-name))))) 

(DEFUN 4break-string-into-lines* (STRING)
  "2Given a string, returns a list of strings, one for each line in STRING.
Lines are broken up by carriage returns encountered in STRING.*"
  (WITH-INPUT-FROM-STRING (STREAM string)
    (LOOP with line with eof?
	  do (MULTIPLE-VALUE-SETQ (line eof?) (READ-LINE stream nil))
	  collect (LIST (IF (STRINGP line) line ""))
	  until eof?)))

(DEFMETHOD 4(show-miscellaneous-data :help*) ()
  (LET ((flavor-name (si::flavor-name data)))
    (FORMAT nil "
The inspection pane you just selected is currently displaying miscellaneous data
on flavor ~s.  The following data are displayed:

 :INIT Keywords   -- any keywords handled by the :INIT method defined for ~s
 Package          -- the symbol package in which the DEFFLAVOR for ~s was called.
 Included Flavors -- Any flavors declared as :INCLUDED-FLAVORS in the DEFFLAVOR for ~s.
                     Included flavors are used to assure that any flavor mixing in ~s
                     also mix in the included flavors.  If they are not mixed in,
                     they are added right after ~s in the flavor heirarchy.
 Properties       -- The flavor property list of ~s.
 Hash Table       -- The state of ~s's method hash table.  If ~s doesn't have a hash table,
                     its methods haven't been composed (via initial instantiation of ~s or
                     through COMPILE-FLAVOR-METHODS).

Lots of information is displayed in the flavor properties.  The following lists the most
important of the properties:
 SI:ALL-INITTABLE-INSTANCE-VARIABLES
 SI::ALL-SPECIAL-INSTANCE-VARIABLES
 SI::REMAINING-DEFAULT-PLIST     -- ???
 SI:UNHANDLED-INIT-KEYWORDS      -- ???
 SI::REMAINING-INIT-KEYWORD      -- ???
 COMPILE-FLAVOR-METHODS          -- The file in which ~s's methods were compiled.
 SI::UNMAPPED-INSTANCE-VARIABLES -- ???
 :DEFAULT-INIT-PLIST             -- Default values ~s provides for its instance variables.

 Any others???"
	    flavor-name flavor-name flavor-name flavor-name flavor-name flavor-name
	    flavor-name flavor-name flavor-name flavor-name flavor-name flavor-name)))

;1; Odd-ball flavors--those not mixing in FLAVOR-OPERATION-mixin.*

(DEFFLAVOR 4show-method* () (inspection-data))

(DEFMETHOD 4(show-method :format-concisely*) (STREAM)
 ;1; DATA is a method spec (a cons stored in the method table of a flavor defstruct,*
 ;1; so we use the METH- accessor functions here.*
  (LET ((fun-spec (si::meth-function-spec data))
	;1; The CONSP is needed for wrappers.*
	;1; Change to check for :Method.  The method, which is the*
	;1; (second data) could be an interpretted named lambda.*
	(ARGLIST (ARGLIST (IF (AND (CONSP (CADR data)) (EQUAL :method (SECOND data)))
                              (CDADR data)
                              (CADR data)))))
	;1; Blow off the first arg, which is always SI:.OPERATION, except on wrappers. *
    (UNLESS (EQ (si::meth-method-type data) :wrapper)
      (POP arglist))
    ;1; If special method combination type, put an asterisk next to the message name.  Otherwise, just print a space.*
    (IF (CADR
      (ASSOC (OR (FOURTH (CAR data)) (THIRD (CAR data)))
	     (si::flavor-method-table (GET (CADAR data) 'si::flavor)) :test #'EQ))
      (UNWIND-PROTECT (PROGN
		       (SEND stream :set-current-font 1)
		       (FORMAT stream "3**"))
	(SEND stream :set-current-font 0))
      (FORMAT stream "3 *"))
    (FORMAT stream "3~:[~*~;~S~]~30@< ~S~@[ :~A~]~> ~:[~*()~;~S~]*" (si::meth-method-type data)
	    (si::meth-method-type data)
	    (IF (FIFTH fun-spec)
	      (FOURTH fun-spec)
	      (CAR (LAST fun-spec)))
	    (FIFTH fun-spec) arglist arglist))) 

(DEFMETHOD 4(show-method :who-line-doc*) (IGNORE &optional ignore)
  '(:mouse-l-1 "3Inspect method details*"
    :mouse-m-1 "3Show the combined methods used in handling the message for this flavor*"
    :mouse-r-1 "3Menu of method operations*"))

(DEFMETHOD 4(show-method :handle-mouse-click*) (blip flavor-inspector)
  (LET ((current-flavor (SEND (SEND (THIRD blip) :current-object) :data)))
    (SELECTOR (FOURTH blip) =
      (#\Mouse-l-1
       (select-method-operations data flavor-inspector current-flavor :inspect))
      (#\Mouse-m-1
       (select-method-operations data flavor-inspector current-flavor :show-combined-methods))
      (#\Mouse-r-1
       (select-method-operations data flavor-inspector current-flavor))
      (t
       (BEEP)))))

(DEFVAR 4*method-operations-menu**
	'(("3Inspect*" :value :inspect
	   :documentation "3Show information about this method:
instance variables and messages referenced, arglist, documentation, source file*")
	  ("3Show Combined Methods*" :value :show-combined-methods
	   :documentation "3Show the combined methods used in handling the message for this flavor*")
	  ("3Disassemble*" :value :disassemble
	   :documentation "3Use a standard Inspect window to show disassembled code.*")
	  ("3Edit Source*" :value :edit-source
	   :documentation "3Edit this method in a Zmacs buffer.*")
	  ("3Trace*" :value :trace
	   :documentation "3Invoke a trace window to trace this method*")))

;1; Used in several parts of the flavor inspector to let the user choose an operation on*
;1; the method stored in METHOD-TABLE-ENTRY.*
(DEFUN 4select-method-operations* (method-table-entry flavor-inspector current-flavor &optional selection)
  (CASE (OR selection
      (ucl::smart-menu-choose *method-operations-menu* :label
	 (FORMAT () "3~s*" (CDAR method-table-entry))))
    (:inspect
     (SEND flavor-inspector :inspect-thing 'show-method-details
	(GET (SECOND (CAR method-table-entry)) 'si::flavor) method-table-entry))
    (:show-combined-methods
     (LET ((found-entry
	    (ASSOC (OR (FOURTH (CAR method-table-entry)) (THIRD (CAR method-table-entry)))
		   (si::flavor-method-table current-flavor) :test #'EQ)))
	   ;1; Use the inspection pane's currently selected flavor (if there is one), instead of the one we are a method for,*
	   ;1; since that's what we want when we are displayed as an inherited method in SHOW-ALL-METHODS.*
       (IF found-entry
	 (SEND flavor-inspector :inspect-thing 'show-message-handlers current-flavor
	    (CAR (FOURTH found-entry)))
	 (SEND flavor-inspector :inspect-thing 'show-message-handlers
	    (GET (SECOND (CAR method-table-entry)) 'si::flavor) (CAR method-table-entry)))))
    (:disassemble (INSPECT (FDEFINITION (CAR method-table-entry))))
    (:edit-source (ED (CAR method-table-entry)))
    (:trace (trace-via-menus (CAR method-table-entry))))) 

  
(DEFFLAVOR 4show-method-details* () (auxiliary-data-mixin flavor-operation-mixin))

(DEFMETHOD 4(show-method-details :format-concisely*) (STREAM)
  (FORMAT stream "3Method~{ ~s~}*" (CDR (CAR aux-data))))

(DEFWRAPPER 4(show-method-details :handle-mouse-click*) ((blip flavor-inspector) . body)
  `(IF (= (FOURTH blip) #\Mouse-r-1)
       (select-method-operations aux-data flavor-inspector (SEND (SEND (THIRD blip) :current-object) :data))
       . ,body))

(DEFMETHOD 4(show-method-details :generate-item*) ()
 (LET (not-available)
   (VALUES
     (MULTIPLE-VALUE-BIND (referenced-ivars referenced-keywords problem)
         (ivars-and-messages-in-method (CAR aux-data))
       (WHEN problem
         (SETQ not-available (IF (EQ problem :wrapper)
                                 '(((:font 2 "3 not available for wrappers*")))
                                 '(((:font 2 "3 not available for interpreted methods*"))))))
       (MULTIPLE-VALUE-BIND (args returned-values)
           ;1; Wrappers and interpreted methods have a method table entry format different from the norm.*
           ;1; Wrappers' entries are (<spec> (MACRO . <fef>)...).  Interpreted methods are (<spec> (NAME-LAMBA <spec> <arglist> ...))*
           (COND ((EQ problem :wrapper) (ARGLIST (CDADR aux-data)))
                 ((EQ problem :interpreted) (CDR (THIRD (CADR aux-data)))) ;1;Take CDR to get rid of SI:.OPERATION. arg.*
                 (t (CDR (ARGLIST (CADR aux-data))))) ;1;Take CDR to get rid of SI:.OPERATION. arg.*
         `(,*blank-line-item*
           ((:font 1 "3Details of *")
            (:item1 instance ,(allocate-data 'show-method-details data aux-data)))
           ,*blank-line-item*
           ((:font 1 "3Source File:               *")
	   ;1; Changed by DAN to check for a null source-file property (Third aux-data) for the method,*
	   ;1; since the method may have been typed in interactively or generated automatically.*
	   ,(IF (GETF (THIRD aux-data) :source-file-name)
		(LET ((sf (GETF (THIRD aux-data) :source-file-name)))
		     (FORMAT nil "3~a*" (SEND (IF (CONSP sf) (CADR (ASSOC 'DEFUN sf :test #'EQ)) sf) :string-for-printing)))
		(FORMAT nil "3Not Defined*")))
           ((:font 1 "3Method combination type:   *")
            ,(LET ((method-entry (ASSOC (OR (FOURTH (CAR aux-data)) (THIRD (CAR aux-data)))
                                        (si::flavor-method-table data) :test #'EQ)))
               (IF (CADR method-entry)
                   `("3~S~@[ ~S~]*" ,(CADR method-entry) ,(CADDR method-entry))
                   "3:DAEMON (the default)*")))
           (,(IF returned-values
                 '(:font 1 "3Arglist  Returned Values: *")
                 '(:font 1 "3Arglist:                   *"))
            ("3~:[~*()~;~S~]*" ,args ,args)
            ,@(WHEN returned-values
                `(("3  ~S*" ,returned-values))))
           ,*blank-line-item*
           ((:font 1 "3Documentation:*"))
           ,@(LET ((doc (DOCUMENTATION (CADR aux-data))))
               (IF doc
                   (break-string-into-lines doc)
                   *no-items*))
           ,*blank-line-item*
           ((:font 1 "3Referenced Instance Variables:*"))
           ,@(OR not-available
                 (LOOP for ivar in referenced-ivars
                       collect `(,*one-space-item*
                                 (:item1 instance ,(allocate-data 'show-instance-variable ivar)))))
           ;1; Anything you try to provide other than just printing these out will*
           ;1; be truely inefficient, since you will have to search *ALL-FLAVOR-NAMES* for*
           ;1; all methods of KEYWORD.  So, printing is probably the right thing to do.*
           ,*blank-line-item*
           ((:font 1 "3Referenced Keywords (possibly messages passed):*"))
           ,@(OR not-available
                 (LOOP for keyword in referenced-keywords
                       collect `(("3 ~s*" ,keyword)))))))
     `(:font fonts:hl12bi :string ,(FORMAT nil "3Method~{ ~s~}*" (CDAR aux-data))))))

;1; Taken from DISASSEMBLE.  Returns three values: list of instance variables referenced,*
;1; list of keywords referenced, and NIL if everything went ok.  If third value is :WRAPPER or*
;1; :INTERPRETED, METHOD-SPEC is either a wrapper or isn't compiled, so no search was done.*
;1; We can't gleam any info out of a wrapper's fef, since it's mostly a macro.*
(DEFUN 4ivars-and-messages-in-method* (method-spec)
  (LET ((fef (FDEFINITION method-spec))
	lim-pc
	ilen
	*collected-ivars*
	*collected-messages*)
    (DECLARE
      (SPECIAL *collected-ivars* *collected-messages* *previous-op* *previous-previous-op*))
    (WHEN (SYMBOLP fef)				;1; Obsolete syntax for method definitions may*
      (SETF fef (SYMBOL-FUNCTION fef)))		;1; return symbols here.  PMH SPR#6810*
    (IF (CONSP fef)
	(VALUES () () (IF (EQ (CAR fef) 'MACRO)
			  :wrapper
			  :interpreted))
	(PROGN
	  (SETQ lim-pc (compiler:disassemble-lim-pc fef))
	  ;1; Loop through the instructions of FEF, searching for ivars and messages.*
	  (DO ((pc (fef-initial-pc fef) (+ pc ilen)))
	      ((>= pc lim-pc))
	    (SETQ ilen (search-instruction fef pc)))
	  (VALUES *collected-ivars* *collected-messages* ()))))) 

;1; Taken from COMPILER:DISASSEMBLE-INSTRUCTION.*
#+elroy
(DEFUN 4search-instruction* (fef pc)
  (LET (wd op name no-reg ilen)
    (SETQ ilen (compiler:disassemble-instruction-length fef pc))
    (BLOCK ()
      (SETQ wd (compiler::disassemble-fetch fef pc)
	    op (LDB si:%%qmi-full-opcode wd)
	    name (AREF (compiler:instruction-decode-table) op)
	    no-reg (GET name 'compiler::no-reg))
      (COND
	((EQ no-reg 'nil) ;1; does use register*
	 (search-address fef (LDB si:%%qmi-register wd) (LDB si:%%qmi-offset wd) nil pc))
	((EQ name 'compiler::push-long-fef)
	 (search-address fef 0 (LDB si:%%qmi-fef-offset wd) nil pc))
	(t nil))
      ilen)))

#-elroy
(DEFUN 4search-instruction* (fef pc)
  (LET (wd op subop dest reg disp ilen second-word)
    (SETQ ilen (compiler:disassemble-instruction-length fef pc))
    (BLOCK ()
      (SETQ wd (compiler::disassemble-fetch fef pc))
      (SETQ op (LDB (BYTE 4 11) wd)
            subop (LDB (BYTE 3 15) wd)
            dest (LDB (BYTE 2 16) wd)
            disp (LDB (BYTE 11 0) wd)
            reg (LDB (BYTE 3 6) wd))
      (COND ((= ilen 2)
             (INCF pc)
             (SETQ second-word (compiler::disassemble-fetch fef pc))
             ;1; If a two-word insn has a source address, it must be an extended address,*
             ;1; so set up REG and DISP to be right for that.*
             (UNLESS (= op 14)
               (SETQ reg (LDB (BYTE 3 6) second-word)
                     disp (DPB (LDB (BYTE 4 11) second-word) (BYTE 4 6) (LDB (BYTE 6 0) second-word))))))
      (WHEN (< op 11) (SETQ op (LDB (BYTE 5 11) wd)))
      (COND ((ZEROP wd)) ;1; Don't know what this is, but it's uninteresting.*
            ((< op 14)   ;1; Standard op*
             (search-address fef reg disp second-word pc))
            ((= op 14))  ;1; Branch op*
            ((= op 15)   ;1; Misc op*
             (IF (LOGTEST 1 subop)
                 (SETQ disp (+ disp 1000)))
             (COND ((< disp 240)
                    (AND (ZEROP dest) (RETURN)))
                   ((OR (= disp 460) (= disp 510)) (SETQ dest ()))))
            ;1;Don't know what these are either, but some of them are interesting.*
            ((= op 16)                                ;1ND4*
             (CASE subop
                   (5 (search-address fef reg disp second-word pc))
                   (6 (search-address fef reg disp second-word pc))))))
    ilen))

;1; Searches an instruction source address for instance variables and message (keyword) references.*
;1; REG is the register number of the address, and DISP is the displacement.*
;1; SECOND-WORD should be the instruction's second word if it has two.*
;1; PC should be where the instruction was found in the FEF.*
#+elroy
(DEFUN 4search-address* (fef reg offset ignore &optional pc &aux tem)
  (DECLARE (SPECIAL *collected-ivars*))
  (CASE reg
    (0 (search-pointer fef offset pc))
    (1 (search-pointer fef (+ offset 64.) pc))
    (2 (search-pointer fef (+ offset 128.) pc))
    ;1; Instance variable*
    (4 (LET* ((mapped (LDB-TEST si:%%qmi-ivar-mapped offset)))
	 (SETQ offset (LDB si:%%qmi-ivar-index offset))
	 (IF mapped
	     (WHEN (SETQ tem (compiler::disassemble-mapped-instance-var-name fef offset))
	       (PUSHNEW tem *collected-ivars*))
	     (WHEN (SETQ tem (compiler::disassemble-instance-var-name fef offset))
	       (PUSHNEW tem *collected-ivars*)))))
    (otherwise nil)))

#-elroy
(DEFUN 4search-address* (fef reg disp second-word &optional pc)
  (LET (tem)
    (DECLARE (SPECIAL *collected-ivars*))
    ;1; Taken from COMPILER:DISASSEMBLE-ADDRESS*
    ;1; In a one-word instruction, the displacement for types 4 thru 7 is only 6 bits,*
    ;1; so ignore the rest.  In a two word insn, we have been fed the full disp from word 2.*
    (IF (AND (>= reg 4) (NOT second-word))
        (SETQ disp (LOGAND 77 disp)))
    (COND ((< reg 4)
           (search-pointer fef disp pc))
          ((< reg 7))
          ((AND (NOT second-word) (= disp 77)))
          ;1; I couldn't ever find a case where this one happens, but included it anyway.*
          ((< disp 40)
           (WHEN (SETQ tem (compiler:disassemble-instance-var-name fef disp))
             (PUSHNEW tem *collected-ivars*)))
          ;1; Ditto here*
          ((< disp 70)
           (WHEN (SETQ tem (compiler:disassemble-mapped-instance-var-name fef (- disp 40)))
             (PUSHNEW tem *collected-ivars*))))))

;1 TAC 09-05-89 - this gets redefined in ti-env-flavor-inspector-interface.lisp *
(DEFUN 4search-pointer* (fef disp pc)
  (LET (tem)
    (DECLARE (SPECIAL *collected-ivars* *collected-messages*))
    pc ;1; keep compiler from complaining*
    ;1; Make sure DISP argument is reasonable.*
    (UNLESS (< disp (si:%structure-boxed-size fef))
      (FERROR nil "3Offset ~d. into function is not in function ~s's boxed-Q area*" disp fef))
    (COND ((= (si:%p-data-type-offset fef disp) dtp-self-ref-pointer)
           (MULTIPLE-VALUE-BIND (ptr component-flavor-flag)
               (si::flavor-decode-self-ref-pointer 
		 (si::fef-flavor-name fef)
                 (si:%p-pointer-offset fef disp))
             (WHEN ptr
               (UNLESS component-flavor-flag
                 (PUSHNEW ptr *collected-ivars*))))) ;1; Collect the instance variable!!*
          ;1; Don't think this ever refers to ivars or keywords.*
          ((= (si:%p-data-type-offset fef disp) dtp-external-value-cell-pointer))
          (t
           (SETQ tem (%p-contents-offset fef disp))
           ;1; When argument is a keyword and the operation is a call (FUNCALL or SEND),*
           ;1; assume it is a message.  There's also a special case caused by the popular (SEND <foo> :SEND-IF-HANDLES :bar) feature*
           ;1; which is covered here.  :BAR is included as a referenced message, even though it is technically just a keyword.*
           (WHEN (AND (SYMBOLP tem) (KEYWORDP tem))
             (PUSHNEW tem *collected-messages*))))))

(DEFMETHOD 4(show-method-details :help*) ()
  (FORMAT nil "
The inspection pane you just selected is currently displaying information about method
~s.  Included are the following:

  Source File                   -- The file in which ~s is defined
  Method Combination Type       -- Determines the manner in which methods are combined.
                                   The standard type is :DAEMON combination. It allows :BEFORE, :AFTER, and :AROUND demons.
  Arglist                       -- The argument list of the method, as specified in DEFMETHOD (or DEFWRAPPER).
                                   Note that this is actually the CDR of the method's argument list.  The first argument
                                   of every method is automatically SI:.OPERATION.
  Documentation                 -- The documentation string of the method, as specified in DEFMETHOD (or DEFWRAPPER).
  Referenced Instance Variables -- The instance variables which the method's compiled code refers to.  These instance
                                   variables are mouse sensitive to allow searching for other methods which reference them.
  Referenced Keywords           -- Symbols in the keyword package which the method's compiled code refers to.
                                   Often this can be used to determine what messages a method sends, since almost all messages
                                   are keywords.  However, there is no way to distinguish a message from any other keyword,
                                   so take this listing at face value."
	  (CDAR aux-data) (CDAR aux-data)))

(DEFFLAVOR 4show-message* () (auxiliary-data-mixin inspection-data))

;1; Print message followed by responsible flavors.*
(DEFMETHOD 4(show-message :format-concisely*) (STREAM)
  (FORMAT stream "3~40s*" aux-data))

(DEFMETHOD 4(show-message :who-line-doc*) (IGNORE &optional ignore)
  '(:mouse-any "3Show the method combination for the message handler for this flavor.*"))

(DEFMETHOD 4(show-message :handle-mouse-click*) (IGNORE flavor-inspector)
  (SEND flavor-inspector :inspect-thing 'show-message-handlers
	;1; Make a fake method spec list.  This doesn't hurt anything.  This flavor may not*
	;1; have a real method spec entry in its method table, in cases where it inherits methods from component flavors.*
	data (LIST :method (si::flavor-name data) aux-data)))

(DEFFLAVOR 4show-message-handlers* () (auxiliary-data-mixin flavor-operation-mixin))

(DEFMETHOD 4(show-message-handlers :format-concisely*) (STREAM)
  (FORMAT stream "3~s's message handlers for ~s*"
	  (SECOND aux-data) (OR (FOURTH aux-data) (THIRD aux-data))))


(DEFMETHOD 4(show-message-handlers :generate-item*) ()
  (LET* ((flavor-name (SECOND aux-data))
         (message (OR (FOURTH aux-data) (THIRD aux-data)))
	 (methods (find-combined-methods flavor-name message)))
	 ;1; Create a fake flavor-method-table for use below in COLLECT-METHOD-ITEMS.  This is a smludge.*
    (SETQ methods (LOOP for method in methods
                        for message = (OR (FOURTH method) (THIRD method))
                        for entry = (ASSOC message (si::flavor-method-table (GET (SECOND method) 'si::flavor)) :test #'EQ)
                        collect `(,message ,(SECOND entry) ,(THIRD entry)
				  ;1,(ASSOC METHOD (CDDDR ENTRY))*
				  ,(CADDDR entry))))
    (MULTIPLE-VALUE-BIND (items special-comb?)
      (collect-method-items (m tpl methods) t nil t)
      (VALUES
       `(,*blank-line-item*
	 ((:font 1 "3Methods called in handling message *")
          (:font 1 ,(FORMAT () "3~s*" message))
	  (:font 1 "3 for flavor *")
          (:item1 instance ,(allocate-data 'show-flavor data))
	  (:font 1 ,(IF special-comb? "3.*" "3:*")))
	 ,@(WHEN special-comb?
	     '(((:font 1 "3 * = special method combination type*"))))
	 ,*blank-line-item*
         ,*method-display-columns-2*
         ;1; Options are: T=always true predicate; NIL=don't include :COMBINED; T=include flavor names.*
         ,@items)
       `(:font fonts:hl12bi :string ,(FORMAT nil "3~s\'s message handlers for ~s*" flavor-name message))))))

;1; Once again, what do you do with non-demons??  Depends on method combination.*
;1; Taken from ZWEI:FIND-COMBINED-METHODS*
(DEFUN 4find-combined-methods* (flavor message)
  "2Return a list of the non-combined methods involved in handling MESSAGE for FLAVOR*"
  (LET (fl sm method dbi)
    (COND
      ;1; FLAVOR's methods have been compiled since it has a method hash table, so we can make use of DEBUGGING-INFO.*
      ((si::flavor-method-hash-table (SETQ fl (GET flavor 'si::flavor)))
       (SETQ method
             (FUNCTION-NAME (IF (si::flavor-get fl :abstract-flavor)
                                (NTH-VALUE 1 (FDEFINEDP `(:method ,flavor :combined ,message)))
                                (IGNORE-ERRORS (si::get-flavor-handler-for flavor message)))))
       (SETQ dbi (si:get-debug-info-struct method t))
;1       (COND ((SETQ SM (CDDDR (OR (CADR *
;				1    (ASSOC 'SI::COMBINED-METHOD-DERIVATION*
;1                                               (DEBUGGING-INFO (SI:UNENCAPSULATE-FUNCTION-SPEC METHOD)) :TEST #'EQ)*
       (COND ((SETQ sm (CDDDR (OR (GETF (si:get-debug-info-field dbi :plist) :combined-method-derivation)  ;1?????*
                                  (si:function-spec-get method 'si::combined-method-derivation))))
              ;1; Try to approximate the order*	1in which they're called*
              (NCONC (REVERSE (CDR (ASSOC :wrapper sm :test #'EQ)))
                     (REVERSE (CDR (ASSOC :around sm :test #'EQ)))
                     (REVERSE (CDR (ASSOC :before sm :test #'EQ)))
                     (REVERSE (CDR (ASSOC () sm :test #'EQ)))
                     (COPY-LIST (CDR (ASSOC :after sm :test #'EQ)))
                     (MAPCAN #'(lambda (x)
                                 (AND (NOT (MEMBER (CAR x) '(:wrapper :around :before nil :after) :test #'EQ))
                                      (REVERSE (CDR x))))
                             sm)))
             (t (LIST method))))
      (t
       ;1; FLAVOR's methods haven't been compiled, so we have to search its component flavors for handlers of MESSAGE.*
       (LET (wrappers
             arounds
             afters
             befores
             others)
         (LABELS ((collect-methods 
		    (flavor)
		    ;1; If we find an entry for MESSAGE, loop through whatever methods are defined.*
		    ;1; A given flavor may have several entries; for instance, a :COMBINED, a :BEFORE, and an :AFTER.*
		    (LOOP for (method-spec) in (CDDDR (ASSOC message (si::flavor-method-table flavor)))
			  do
			  (CASE (THIRD method-spec)
			    (:wrapper (PUSH-END method-spec wrappers))
			    (:around (PUSH-END method-spec arounds))
			    (:after (PUSH method-spec afters))
			    (:before (PUSH-END method-spec befores))
			    (:combined) ;1; We ignore combined since they aren't real useful info.*
			    (t (PUSH-END method-spec others))))))
           (with-recursion ((flavor) fl)
             (collect-methods flavor)
             (DOLIST (comp (si::flavor-includes flavor))
               (recurse (GET comp 'si::flavor)))
             (DOLIST (comp (si::flavor-depends-on flavor))
               (recurse (GET comp 'si::flavor))))
           (collect-methods (GET 'si:vanilla-flavor 'si::flavor))
           (APPEND wrappers arounds afters befores others))))))) 

#|
3These are just note I made while exploring the complexities of archain method combination types,
which need to be handled specially for several of the flavor inspection options.

<remember :OVVERRIDE and :DEFAULT methods--find out what they do.>
Using CADR of method entry doesn't cut it.  You have to search component flavors
 for combination style and order.
"Base flavor last" is the way I usually expect it--base flavor means last component.
"Base flavor first" is backwards.
What to do about user-defined method types, combination styles, and orderings?

:DAEMON 
  befores, base, afters
:DAEMON-WITH-OR
  befores, (OR <:OR of main> <:OR of highest comp> <:OR of next highest> <primary>) ,afters.
  Combination is SUPPOSED to have effect, but doesn't.

:DAEMON-WITH-AND befores, (AND <:AND of least comp> <:AND of second to least> <:AND of main> <primary>), afters
  Combination is SUPPOSED to have effect, but doesn't.

:PROGN  
  befores, primary of main, primary of highest comp, ... afters
  Return value of last primary.  Order doesn't matter.  Can be anything.

:OR
  befores, (OR <primary of main> <primary of highest comp> <primary of next hightest>), afters  --on :BASE-FLAVOR-LAST
  befores, (OR <primary of least> <primary of next least> <primary of main>), afters  --on :BASE-FLAVOR-FIRST

:AND
  befores, (AND <primary of main> <primary of highest comp> <primary of next hightest>), afters  --on :BASE-FLAVOR-LAST
  befores, (AND <primary of least> <primary of next least> <primary of main>), afters  --on :BASE-FLAVOR-FIRST

:APPEND and :NCONC
  Like :AND

:INVERSE-LIST
  befores, primarys, afters --combination order DOES affect it.

:PASS-ON
  befores, primarys, afters --combination order DOES affect it.

:CASE 
  befores, <:CASE of highest>, or if none, (OR <:OR of main> <:OR of highest comp>... <highest primary>), then afters
  --combination DOES affect the :CASE: if :BASE-FLAVOR-first, use <:CASE of lowest>.
    But it doesn't effect the OR.

(DEFFLAVOR q1 () () (:METHOD-COMBINATION (:OR :BASE-FLAVOR-last :bar)))
(DEFMETHOD (q1 :bar) () (PRINT 'p1) nil)
(DEFFLAVOR q2 () () (:METHOD-COMBINATION (:OR :BASE-FLAVOR-last :bar)))
(DEFMETHOD (q2 :bar) () (PRINT 'p2) nil)
(DEFFLAVOR q3 () (q2 q1))
(DEFMETHOD (q3 :bar) () (PRINT 'p3) nil)
(SEND (MAKE-INSTANCE 'q3) :bar)*

|#

;1; Explain how :WRAPPER and :AROUND work*
(DEFMETHOD 4(show-message-handlers :help*) ()
  (FORMAT nil "
3The inspection pane you just selected is currently displaying all methods
which execute when an instance of ~s is sent message ~s.
The methods are displayed roughly in the order in which they are called; for instance,
:BEFORE demons are displayed before the primary method, which is displayed before :AFTER
demons.  [[HOW DO :WRAPPER and :AROUND work??]]

Each method is displayed by its flavor, type, message name, and argument list.  
Further information can be obtained by using the mouse.  Method types are any of the following:
 :AFTER, :AND, :AROUND, :BEFORE, :CASE, :DEFAULT, :OR, :OVERRIDE, :WRAPPER.
If a type is not present, the displayed method is a \"primary method\".  Type :WRAPPER
indicates wrappers (defined via DEFWRAPPER).  The rest are the standard, documented method
types.  Note that :COMBINED methods are not displayed, since they are seen as relatively
uninteresting and tend to add clutter.

Most methods are combined using the default method combination type :DAEMON.  However,
if a displayed method is combined using one of the other combination types (such as
:OR, :AND, or :CASE), an asterisk (*) is placed to the left of the method type.  Clicking
left on the method will show detailed information which includes the type of method 
combination used.*"
	    (si::flavor-name data) (message aux-data)))


(DEFFLAVOR 4show-instance-variable* () (inspection-data))

(DEFMETHOD 4(show-instance-variable :format-concisely*) (STREAM)
  (FORMAT stream "3~s*" data))

(DEFMETHOD 4(show-instance-variable :who-line-doc*) (inspection-pane? &optional ignore)
  `(:mouse-l-1
    ,(FORMAT () "3Inspect methods of ~s referencing this variable*"
	     (si::flavor-name (SEND (SEND inspection-pane? :current-object) :data)))
    :mouse-m-1 "3Inspect methods of a specified flavor referencing this variable*")) 

;1; Reads and returns flavor name, with all completion and who-line help active.*
;1; This mimics UCL:HANDLE-READ-FUNCTION.*
(DEFUN 4read-flavor-name* ()
  (DECLARE (:self-flavor ucl::basic-command-loop))
  (LET ((ucl::typein-modes '(flavor-names))
	(ucl::command-loop-typein? self)
	flavor-name)
    (DECLARE (SPECIAL ucl::typein-modes ucl::command-loop-typein?))
    (SEND self :handle-prompt t "3Flavor name: *")
    (SETQ flavor-name (sys::internal-read-form-or-implicit-list))
    (COND
      ((AND (SYMBOLP flavor-name)
            (GET flavor-name 'si::flavor))
       (SEND self :handle-prompt)
       flavor-name)
      (t
       (FORMAT t "3** ~s is not a defined flavor*" flavor-name)
       (SEND self :handle-prompt)
       (THROW 'ucl::command-abort nil))))) 

(DEFMETHOD 4(show-instance-variable :handle-mouse-click*) (blip flavor-inspector)
  (IF (NOT (MEMBER (FOURTH blip) '(#\Mouse-l #\Mouse-m) :test #'EQ))
    (BEEP)
    (SEND flavor-inspector :inspect-thing 'show-methods-referencing-instance-variable
       (IF (EQL (FOURTH blip) #\Mouse-l)
	 (SEND (SEND (THIRD blip) :current-object) :data)
	 (GET (SEND flavor-inspector :funcall-inside-yourself (FUNCTION read-flavor-name))
	      'si::flavor))
       data))) 

(DEFFLAVOR 4show-methods-referencing-instance-variable*
	   ()
	   (auxiliary-data-mixin flavor-operation-mixin))

(DEFMETHOD 4(show-methods-referencing-instance-variable :format-concisely*) (STREAM)
  (FORMAT stream "3~s references in ~s*" aux-data (si::flavor-name data)))

(DEFMETHOD 4(show-methods-referencing-instance-variable :generate-item*) ()
  (LET* ((flavor-name (si::flavor-name data)))
    (VALUES
     (MULTIPLE-VALUE-BIND (items special-comb?)
       (collect-method-items (m tpl (si::flavor-method-table data))
	(method-uses-symbol?
	 ;1; Catches (MACRO <fef>) case for wrappers.*
	 (IF (CONSP (CADAR tpl))
	   (CDADAR tpl)
	   (CADAR tpl))
	 aux-data))
       `(,*blank-line-item*
	 ((:font 1 "3Methods of *")
          (:item1 instance ,(allocate-data 'show-flavor data))
	  (:font 1 "3 referencing instance variable *")
	  (:item1 instance ,(allocate-data 'show-instance-variable aux-data))
	  (:font 1 ,(IF special-comb? "3.*" "3:*")))
	 ,@(WHEN special-comb?
	     '(((:font 1 "3 * = special method combination type*"))))
	 ,*blank-line-item* . ,(IF items
				 (CONS *method-display-columns* items)
				 *no-items*)))
     `(:font fonts:hl12bi :string ,(FORMAT () "3~S references in ~s*" aux-data flavor-name)))))
  
;1;  The two specials are expected by SI:FIND-CALLERS-OF-SYMBOLS-AUX-FEF*
(DEFUN 4method-uses-symbol?* (method-fef &special symbol &aux (FUNCTION #'(lambda (IGNORE ignore use)
						(THROW 'found
						       use))))
  (CATCH 'found
    (si::find-callers-of-symbols-aux1 method-fef method-fef symbol function))) 

(DEFMETHOD 4(show-methods-referencing-instance-variable :help*) ()
  (FORMAT nil "
3The inspection pane you just selected is currently displaying all methods of flavor
~s which reference instance variable ~s.

Each method is displayed by its method type, message name, and argument list.  
Further information can be obtained by using the mouse.  Method types are any of the following:
 :AFTER, :AND, :AROUND, :BEFORE, :CASE, :DEFAULT, :OR, :OVERRIDE, :WRAPPER.
If a type is not present, the displayed method is a \"primary method\".  Type :WRAPPER
indicates wrappers (defined via DEFWRAPPER).  The rest are the standard, documented method
types.  Note that :COMBINED methods are not displayed, since they are seen as relatively
uninteresting and tend to add clutter.

Most methods are combined using the default method combination type :DAEMON.  However,
if a displayed method is combined using one of the other combination types (such as
:OR, :AND, or :CASE), an asterisk (*) is placed to the left of the method type.  Clicking
left on the method will show detailed information which includes the type of method 
combination used.*"
	    (si::flavor-name data) aux-data))

(DEFFLAVOR 4show-all-flavors* () (inspection-data)
   ;1; Used just to make allocate-data work on it.  See reference to 'IGNORE below.*
  (:default-init-plist :data 'IGNORE))

(DEFMETHOD 4(show-all-flavors :format-concisely*) (STREAM)
  (FORMAT stream "3All flavors*"))

(DEFMETHOD 4(show-all-flavors :who-line-doc*) (IGNORE &optional ignore)
  '(:any "3Inspect this flavor information*"))

(DEFMETHOD 4(show-all-flavors :handle-mouse-click*) (blip flavor-inspector)
  (SELECTOR (FOURTH blip) =
    (#\Mouse-l-1
     (SEND flavor-inspector :inspect-info-left-click))
    (#\Mouse-m-1
     (SEND flavor-inspector :inspect-info-middle-click))
    ;1; Could we put anything interesting on right click?  Maybe*
    ;1; Flavor-name apropos, or some complex query for locating sets of flavors with common characteristics?*
    (t
     (BEEP))))

(DEFMETHOD 4(show-all-flavors :generate-item*) ()
  (VALUES
   `(,*blank-line-item*
     ((:font 1 "3Currently defined flavors: *"))
     ,*blank-line-item*
     ;1; Sort flavors by package, then alphabetically*
     ,@(LOOP for flavor in
	  (SORT (COPY-LIST *all-flavor-names*)
		#'(lambda (f1 f2)
		    (LET ((p1 (PACKAGE-NAME (SYMBOL-PACKAGE f1)))
			  (p2 (PACKAGE-NAME (SYMBOL-PACKAGE f2))))
		      (OR (STRING< p1 p2) (AND (STRING= p1 p2) (STRING< f1 f2))))))
	  collect `((:item1 instance ,(allocate-data 'show-flavor (GET flavor 'si::flavor))))))
   '(:font fonts:hl12bi :string "3All flavors*")))  


(DEFMETHOD 4(show-all-flavors :help*) ()
  (FORMAT nil "
3The inspection pane you just selected is currently displaying all defined flavors.
The flavors are sorted alphabetically, first by symbol package, then by symbol name.
This makes it easier for you to inspect related flavors, since most related flavors
share the same symbol package.*"))

;1;----------------------------------------------------------------------------------------------*
;1; The rest of this defines the user interface.*
;1;*

(DEFFLAVOR 4flavor-inspector* () (basic-inspect-frame)
  (:default-init-plist
    :active-command-tables '(flavor-inspector-cmd-table)
    :all-command-tables '(flavor-inspector-cmd-table)
    :menu-panes '((menu flavor-inspector-menu))
    :typein-modes '(method-specs flavor-instance flavor-names ucl::command-names)
;1;Function needs to be written.  Include the stuff in Help On Syntax.*
    :basic-help '(fi-doc-cmd)
    :prompt "3Flavor\/Method: *"
    ;1; Activate the special handling of instances of TV:INSPECTION-DATA.*
    ;1; This hack keeps the inspector code from treating mouse-sensitive blips containing TV:INSPECTION-DATA*
    ;1; instances as normal Lisp objects to inspect and lets the instances dictate most inspector*
    ;1; actions, such as who-line-documentation when mouse is over the printed representation of the instance,*
    ;1; mouse button operations when it is clicked upon, and item generation when the blip is inspected.*
    :inspection-data-active? t))

;1;; Modified to fit into 604x432 window on MicroExplorer or 688x432 window on Explorer*
;1;; Change menu-history constraint from 3 to 4 lines high - 11/19/87 CAT*
(DEFMETHOD 4(flavor-inspector :before :init*) (plist)
 ;1; Specify our panes and constraints.  This differs from (TV:INSPECT-FRAME :BEFORE :INIT) only *
 ;1; in some of the who-line messages we provide, which are specific to flavor inspectors.*
  (LET ((noi (OR (GET plist :number-of-inspectors) 3)))
        ;1(iobuf (make-default-io-buffer)))*
    (SETQ panes
	  (LIST `(interactor inspector-interaction-pane
                             :label nil
                             :more-p nil
                             ;1:IO-BUFFER ,IOBUFF*
                             :font-map  ,(LIST (FIRST *inspector-font-map*) (SECOND *inspector-font-map*))
                             :who-line-message
                             "3To inspect a flavor, type its name.  To inspect a method, type <flavor name> <method name>
Press HELP for a help menu, META-HELP for help on typed expressions.  R2: System Menu.*")
                `(history inspect-history-window  ;1-WITH-MARGIN-SCROLLING*
;1                         :SCROLL-BAR 3*
                         :line-area-mouse-doc (:mouse-l-1 "3Inspect the indicated data*"
                                                          :mouse-m-1 "3Remove it from the Flavor Inspector*")
                         :normal-mouse-documentation (:mouse-l-1 "3Select data to inspect*"
                                                      :mouse-m-2 "3Lock/Unlock inspector pane*"
                                                      :mouse-r-2 "3System Menu*"))
                `(menu inspector-menu-pane)))
    ;1; Add an inspector to PANES, taking into account the number of inspector panes requested.  The first*
    ;1; inspector is given a typeout pane.  Also initialize INSPECTORS.*
    (DOTIMES (i noi)
      (LET ((name1 (INTERN (FORMAT () "3INSPECTOR-~D*" i) "3TV*")))
	(PUSH `(,name1 ,(IF (= i (1- noi)) 'inspect-window-with-typeout 'inspect-window)
;1                :SCROLL-BAR 2*
;1                :SCROLL-BAR-ALWAYS-DISPLAYED T*
                ;1; Otherwise we get "More Object Above", etc.*
;1                :MARGIN-SCROLL-REGIONS ((:TOP "Top" "More Above" FONTS:TR8B) (:BOTTOM "Bottom" "More Below" FONTS:TR8B))*
                :current-object-who-line-message 
		,(FUNCTION (lambda (current-object)
			     (COND
			       ((EQUAL current-object '(nil))
				"3Flavor Inspection Pane.  To inspect a flavor, type its name.  To inspect a method, type <flavor name> <method name> Press HELP for a help menu, META-HELP for help on typed expressions.  R2: System Menu.*")
			       ((TYPEP current-object 'flavor-operation-mixin)
				`(:mouse-l-1 "3Select data to inspect*"
					     :mouse-m-1 "3Help on currently displayed data*"
					     :mouse-m-2 "3Lock/Unlock inspector pane*"
					     :mouse-r-1 ,(FORMAT () "3Menu of operations on flavor ~s*"
								 (si::flavor-name (SEND current-object :data)))))
			       (t '(:mouse-l-1 "3Choose an item to inspect*"))))))
              panes)
	(PUSH name1 inspectors)))
    (SETQ constraints
	  `((:three-panes ,(REVERSE `(interactor menu-history ,@inspectors))
                         ((interactor 4 :lines))
                         ((menu-history
                            :horizontal (4 :lines history)
                            (menu history)
                            ((menu :ask :pane-size))
                            ((history :even))))
                         ,(MAPCAR #'(lambda (name1)
                                      `(,name1 :limit (1 36 :lines)
                                        ,(/ 0.3s0 (1- noi)) :lines))
                                  (CDR inspectors))
                         ((,(CAR inspectors) :even)))
	    (:one-pane (,(CAR inspectors) menu-history interactor)
                      ((interactor 4 :lines))
                      ((menu-history
                         :horizontal (4 :lines history)
                         (menu history)
                         ((menu :ask :pane-size))
                         ((history :even))))
                      ((,(CAR inspectors) :even)))
              (:two-horizontal-panes ,(REVERSE `(interactor menu-history inspector-2 inspector-1))
                    ((interactor 4 :lines))
                    ((menu-history :horizontal (4 :lines history) (menu history)
                                   ((menu :ask :pane-size))
                                   ((history :even))))
                    ((inspector-1 0.5))
                    ((inspector-2 :even)))
              (:two-vertical-panes ,(REVERSE `(interactor menu-history side-by-side))
                    ((interactor 4 :lines))
                    ((menu-history :horizontal (4 :lines history) (menu history)
                                   ((menu :ask :pane-size))
                                   ((history :even))))
                    ((side-by-side :horizontal (:even)
                                   (inspector-2 inspector-1)
                                   ((inspector-1 0.5))
                                   ((inspector-2 :even)))))
	    (:debug (,(CAR inspectors) menu-history interactor)
                      ((interactor 45 :lines))
                      ((menu-history
                         :horizontal (4 :lines history)
                         (menu history)
                         ((menu :ask :pane-size))
                         ((history :even))))
                      ((,(CAR inspectors) :even)))
            ))))

(DEFMETHOD 4(flavor-inspector :after :init*)(&rest ignore)
  (SETF (label-font label) fonts:cptfontb)
  (SETF (label-background label) w:75%-gray-color)
  (SETF (sheet-background-color (SEND self :get-pane 'menu)) w:33%-gray-color))


;1----------------------------------------------------------------------*
;1(LET ((compiler:compile-encapsulations-flag t))*
;1  (ADVISE (:method flavor-inspector :before :expose) :around*
;	1  :dont-run-if-general-inspector nil*
;1    (IF (TYPEP self 'general-inspector)*
;	1nil*
;	1:do-it)))*
;1----------------------------------------------------------------------*

(DEFMETHOD 4(flavor-inspector :before :expose*) ()
  (UNLESS (TYPEP self 'general-inspector)
    (SEND self :set-configuration *flavor-inspector-configuration*)))
;
;1(DEFWRAPPER (flavor-inspector :HANDLE-PROMPT) ((&OPTIONAL IGNORE use-prompt) . body)*
;1  ;; Makes our prompt print in bold font.  This helps the user to see that he is in the*
;1  ;; Flavor Inspector, instead of the normal inspector, since our prompt is different.*
;1  ;; We also accept an optional prompt argument to use instead of the normal prompt.*
;1  `(LET ((old-prompt UCL:PROMPT))*
;1     (UNWIND-PROTECT*
;	1 (PROGN*
;	1   (SEND user :SET-CURRENT-FONT 1)*
;	1   (WHEN use-prompt*
;	1     (SETQ UCL:PROMPT use-prompt))*
;	1   . ,body)*
;1       (SEND user :SET-CURRENT-FONT 0)*
;1       (SETQ UCL:PROMPT old-prompt))))*

(DEFMETHOD 4(flavor-inspector :around :handle-prompt*) (cont mt ignore &optional ignore use-prompt)
  ;1; Makes our prompt print in bold font.  This helps the user to see that he is in the*
  ;1; Flavor Inspector, instead of the normal inspector, since our prompt is different.*
  ;1; We also accept an optional prompt argument to use instead of the normal prompt.*
  (LET ((old-prompt ucl:prompt))
    (UNWIND-PROTECT
        (PROGN
          (SEND user :set-current-font 1)
          (WHEN use-prompt
            (SETQ ucl:prompt use-prompt))
          (FUNCALL-WITH-MAPPING-TABLE cont mt :handle-prompt))
          (SEND user :set-current-font 0)
          (SETQ ucl:prompt old-prompt))))

;1; This cdr-codes *ALL-FLAVOR-NAMES*, resulting in less paging during searches.*
(SETQ *all-flavor-names* (COPY-LIST *all-flavor-names*))

;1; Note--I'm not sure this works all that well, though it should.  Auto-completion is LIGHTENING*
;1; fast after the first completion--check it out.  This *should* succeed in paging in the same code*
;1; that the first auto-completion takes time to.*
(DEFMETHOD 4(flavor-inspector :after :select*) (&rest ignore)
  ;1; This is a hack to get the flavors list and the completion code paged in, so that auto-completion is fast.*
  ;1; Of course, if the user does enough stuff while in the window, it will get paged out.*
  ;1; GET-WORD-COMPLETIONS expects a string, not a symbol so quoted si:vanilla-flavor.*
  (w::get-word-completions "3si:vanilla-flavor*" *all-flavor-names*))

(DEFMETHOD 4(flavor-inspector :update-**) ()
  (LET* ((items (SEND history :items))
	 (nitems (IF items (ARRAY-ACTIVE-LENGTH items) 0)))
    (IF(>= nitems 1) (COND ((CONSP (AREF items (- nitems 1)))
			    (SETQ * (CAR (SEND (AREF items (- nitems 1)) :send-if-handles :aux-data))))
			   ((EQ 'IGNORE (SEND (AREF items (- nitems 1)) :data))
			    t)
			   (t (OR (SETQ * (SEND (AREF items (- nitems 1)) :send-if-handles :aux-data))
				  (SETQ * (si::flavor-name (SEND (AREF items (- nitems 1)) :data)))))))
    (IF (>= nitems 2)(COND ((CONSP (AREF items (- nitems 2)))
			    (SETQ ** (CAR (SEND (AREF items (- nitems 2)) :send-if-handles :aux-data))))
			   ((EQ 'IGNORE (SEND (AREF items (- nitems 2)) :data))
			    t)
			   (t (OR (SETQ ** (SEND (AREF items (- nitems 2)) :send-if-handles :aux-data))
				  (SETQ ** (si::flavor-name (SEND (AREF items (- nitems 2)) :data)))))))
    (IF (>= nitems 3)(COND ((CONSP (AREF items (- nitems 3)))
			    (SETQ *** (CAR (SEND (AREF items (- nitems 3)) :send-if-handles :aux-data))))
			   ((EQ 'IGNORE (SEND (AREF items (- nitems 3)) :data))
			    t)
			   (t (OR (SETQ *** (SEND (AREF items (- nitems 3)) :send-if-handles :aux-data))
				  (SETQ *** (si::flavor-name (SEND (AREF items (- nitems 3)) :data)))))))))

(DEFMETHOD 4(flavor-inspector :name-for-selection*) () name)
;1(ADD-SYSTEM-KEY #\o 'flavor-inspector "Flavor Inspector -- A utility for examining the structure of flavors.")*

;1;-------------------------------------------------------------------------------------*
;1; This code implements the expression processors which allow the user to type (and complete on)*
;1; flavor and method names for inspection. It defines two typein-modes: flavor names and method *
;1; specs.*
;1;*

(DEFFLAVOR 4flavor-names* () (ucl:typein-mode)
  (:default-init-plist
   :auto-complete-p t))

(DEFFLAVOR 4flavor-instance* () (ucl:typein-mode)
  (:default-init-plist
    :auto-complete-p t))

;1; Allow completion when flavor name is typed alone AND when it is typed as part of a method spec*
(DEFMETHOD 4(flavor-names :complete-p*) (syntax)
  (WHEN (MEMBER syntax '(:first-atom :function) :test #'EQ)
    "3Flavor Names*")) 

(DEFMETHOD 4(flavor-names :complete*) (word type)
  (CASE type
    (:recognition (w::get-word-completions word *all-flavor-names*))
    (:apropos
     (MULTIPLE-VALUE-BIND (name pkg)
       (w::separate-name-from-package word)
       (WHEN (PLUSP (LENGTH name))
	 (UNLESS pkg
	   (SETQ pkg *package*))
	 (LOOP for flavor-name in *all-flavor-names*
               when (AND (LET ((fnpkg (SYMBOL-PACKAGE flavor-name)))
                           (OR (EQ fnpkg pkg) (MEMBER fnpkg (PACKAGE-USE-LIST pkg) :test #'EQ)))
                         (SEARCH (THE string (STRING name)) (THE string (STRING flavor-name)) :test
                                 #'CHAR-EQUAL))
               collect flavor-name))))
    (:spelling-corrected
     (MULTIPLE-VALUE-BIND (name pkg)
       (w::separate-name-from-package word)
       (w::spell (INTERN name pkg) *all-flavor-names*))))) 


(DEFMETHOD 4(flavor-names :handle-typein-p*) (expression type)
  (COND ((AND (MEMBER type '(first-atom atom symbol) :test #'EQ) (SYMBOLP expression)
       (GET expression 'si::flavor))
	 (VALUES self ()))			
	((AND (SYMBOLP expression) (BOUNDP expression))
	    (SEND   self :handle-typein-p (SYMBOL-VALUE expression) (TYPE-OF (SYMBOL-VALUE expression))))
	(t (VALUES () (FORMAT nil "3~s is not a defined flavor *" expression)))))

(DEFMETHOD 4(flavor-instance :handle-typein-p*) (expression type)
  (IF (NOT (CONSP expression))
	   (IF (NOT (AND (SYMBOLP expression) (BOUNDP expression)))
	       (VALUES () (FORMAT nil "3~s is not a defined flavor 2*" expression))
	       (COND ((INSTANCEP (EVAL expression))
		      (IF (AND (MEMBER type '(first-atom atom symbol) :test #'EQ) (SYMBOLP expression)
			       (GET (TYPE-OF (EVAL expression)) 'si::flavor))
			  (VALUES self ())
			  (VALUES () (FORMAT nil "3~s is not a defined flavor *" expression))))
		     ((AND (SYMBOLP expression) (BOUNDP expression))
		      (SEND   self :handle-typein-p (SYMBOL-VALUE expression) (TYPE-OF (SYMBOL-VALUE expression))))
		     (t (VALUES () (FORMAT nil "3~s is not a defined flavor*" expression)))))  
	   (VALUES () (FORMAT nil "3~s is not a defined flavor*" expression))))

(DEFMETHOD 4(flavor-names :execute*) (flavor-inspector)
  (DECLARE (SPECIAL ucl::inhibit-results-print?))
  (IF (AND (SYMBOLP -) (BOUNDP -))
      (SETQ - (SYMBOL-VALUE -)))
  (LET* ((history (SEND flavor-inspector :history))
	 (flavor
	  (inspect-real-value
	   `(:value ,(allocate-data 'show-flavor (GET - 'si::flavor)) ,history))))
	 ;1; Might not work since not EQ*
    (inspect-flush-from-history flavor history)
    (SEND history :append-item flavor)
    (update-panes)
    ;1; We don't want our result to be printed.*
    (SETQ ucl::inhibit-results-print? t)))

(DEFMETHOD 4(flavor-instance :execute*) (flavor-inspector)
  (DECLARE (SPECIAL ucl::inhibit-results-print?))
  (IF (AND (SYMBOLP -) (BOUNDP -))
      (SETQ - (SYMBOL-VALUE -)))
  (LET* ((history (SEND flavor-inspector :history)) 
	 (flavor
	  (inspect-real-value
		`(:value ,(allocate-data 'show-flavor (GET (TYPE-OF (EVAL -)) 'si::flavor)) ,history))))
	 ;1; Might not work since not EQ*
    (inspect-flush-from-history flavor history)
    (SEND history :append-item flavor)
    (update-panes)
    ;1; We don't want our result to be printed.*
    (SETQ ucl::inhibit-results-print? t)))

(DEFMETHOD 4(flavor-names :arglist*) (symbol)
  (IF (AND (SYMBOLP symbol) (GET symbol 'si::flavor))
      (FORMAT nil "3Flavor ~S*" symbol)
      (VALUES nil (FORMAT nil "3~S is not a defined flavor*" symbol))))

(DEFFLAVOR 4method-specs* () (ucl:typein-mode)
  (:default-init-plist
    :auto-complete-p t))

;1; Allow completion when flavor name is typed alone AND when it is typed as part of a method spec*
(DEFMETHOD 4(method-specs :complete-p*) (syntax)
  (WHEN (EQ syntax :atom)
    "3Methods*"))

(DEFPARAMETER 4*method-types**
   '(:after :and :around :before :case :default :or :override :wrapper)) 

(defun-rh 4get-method-expression* ()
  (LET* ((first-word-start (rh-word-start 1))
	 (first-word-end (rh-word-end first-word-start))
	 (second-word-start (rh-word-start (1+ first-word-end)))
	 (second-word-end (MIN (rh-word-end second-word-start) (1- (rh-typein-pointer)))))
    (VALUES
      (READ-FROM-STRING (rh-substring-of-buffer first-word-start first-word-end))
      (READ-FROM-STRING (rh-substring-of-buffer second-word-start second-word-end))
      (UNLESS (= second-word-end (1- (rh-typein-pointer)))
	(rh-word-start (1+ second-word-end) t)))))

(DEFMETHOD 4(method-specs :complete*) (word type)
  (MULTIPLE-VALUE-BIND (flavor-name second-word more-than-two-words?)
    (SEND *standard-input* :funcall-inside-yourself (FUNCTION get-method-expression))
    (LET* ((flavor (GET flavor-name 'si::flavor))
	   (operations
	    (WHEN flavor
	     ;1; Prevent completion from completing method types more than*
	     ;1; once (example: TV:WINDOW :AFTER :AFTER :SELECT).*
	      (IF more-than-two-words?
		(WHEN (MEMBER second-word *method-types* :test #'EQ)
		  (si::flavor-method-table flavor))
		(APPEND *method-types* (si::flavor-method-table flavor))))))
      (WHEN flavor
	(LOOP for completion in
	   (CASE type
	     (:recognition (w::get-word-completions word operations))
	     (:apropos (w::list-apropos (SUBSEQ word 1) operations :dont-print t))
	     (:spelling-corrected (w::spell word operations)))
	   collect (ucl::first-if-list completion)))))) 

(DEFMETHOD 4(method-specs :handle-typein-p*) (expression type)
  (IF (NOT (CONSP expression))
      (IF (AND (SYMBOLP expression) (BOUNDP expression))
	  (IF (CONSP (SYMBOL-VALUE expression))
	      (SETQ expression (CDR (SYMBOL-VALUE expression)) type ':implicit-list)
	      (SETQ expression (SYMBOL-VALUE expression)))
	  (VALUES () (FORMAT nil "3~s is not a defined flavor *" expression))))
  (WHEN (MEMBER type '(:implicit-list cons) :test #'EQ)
   ;1; Make it (:method <flavor-name> <message-name>) or (:method <flavor-name> <type> <message-name>)*
   ;1; or even (:method <flavor-name> :CASE <message-name> <submessage>)*
    (PUSH :method expression)
    (COND
     ;1; Error if no method supplied*
     ((NULL (THIRD expression))
      (VALUES () (FORMAT () "3No method supplied.  Press META- for correct syntax.*")))
     ;1; Error if too many args supplied.*
     ((IF (MEMBER (THIRD expression) *method-types* :test #'EQ)
	(IF (EQ (THIRD expression) :case)
	  (SIXTH expression)
	  (FIFTH expression))
	(FOURTH expression))
      (VALUES () (FORMAT () "3Extraneous arguments.  Press META- for correct syntax.*")))
     ;1; Good method spec => we'll :EXECUTE the expression.*
     ((FDEFINEDP expression) (VALUES self ()))
     ;1; Bad method name.*
     ((GET (SECOND expression) 'si::flavor)
      (VALUES () (FORMAT () "3~{~s ~}is not a defined method.*" (CDR expression))))
     ;1; Bad flavor name.*
     (t (VALUES () (FORMAT () "3~s is not a defined flavor*" (SECOND expression))))))) 

(DEFMETHOD 4(method-specs :execute*) (flavor-inspector)
  (DECLARE (SPECIAL ucl::inhibit-results-print?))
  (IF (AND (SYMBOLP -) (BOUNDP -))
      (SETQ -(CDR (SYMBOL-VALUE -))))
  (LET* ((history (SEND flavor-inspector :history))
	 (flavor (GET (CAR -) 'si::flavor))
	 (method
	  (inspect-real-value
	   `(:value
	     ,(allocate-data 'show-method-details flavor
	       (CAR
		 (CDDDR
		       (ASSOC (OR (THIRD -) (SECOND -)) (si::flavor-method-table flavor) :test
			      #'EQ))))
	     ,history))))
    (inspect-flush-from-history method history)
    (SEND history :append-item method)
    (update-panes)
    ;1; We don't want our result to be printed.*
    (SETQ ucl::inhibit-results-print? t))) 

(DEFMETHOD 4(method-specs :arglist*) (symbol)
  (LET (flavor)
    (WHEN (VARIABLE-BOUNDP ucl::command-loop-typein?)
      (MULTIPLE-VALUE-BIND (flavor-name second-word more-than-two-words?)
          (SEND (SEND ucl::command-loop-typein? :user) :funcall-inside-yourself
                (FUNCTION get-method-expression))
        (COND
          ((NULL (SETQ flavor (GET flavor-name 'si::flavor))))
          ((AND (NOT more-than-two-words?) (MEMBER second-word *method-types* :test #'EQ))
           (FORMAT () "3method type ~s*" second-word))
          (t
           (LET* ((spec
                    (IF more-than-two-words?
                        `(:method ,flavor-name ,second-word ,symbol)
                        `(:method ,flavor-name ,symbol)))
                  (ARGLIST (WHEN (FDEFINEDP spec)
                             (ARGLIST spec))))
             (COND
               ((NULL arglist) (VALUES () "3Not a defined method*"))
               ((CDR arglist) (FORMAT () "3Method ~s  ~s*" symbol (CDR (ARGLIST spec))))
               (t (FORMAT () "3Method ~s  ()*" symbol)))))))))) 


(DEFPARAMETER 4flavor-names* (MAKE-INSTANCE 'flavor-names)) 
(DEFPARAMETER 4method-specs* (MAKE-INSTANCE 'method-specs))
(DEFPARAMETER 4flavor-instance* (MAKE-INSTANCE 'flavor-instance))

;1; The following is that code necessary to link the Flavor Inspector to the normal Inspector.*
 
;1; Define a command to allow the user to inspect flavors and methods from within the normal inspector.*
;1(DEFCOMMAND Flavor-Inspect-CMD NIL*			
;1            '(:DESCRIPTION *
;1             "Flavor Inspect a Flavor or Method."*
;1              :NAMES ("FlavIns") :KEYS (#\h-F))*
;1            (DECLARE (SPECIAL USER HISTORY = INSPECTORS FRAME)) (SEND USER :CLEAR-SCREEN)*
;1            (FORMAT USER "~&Object to Flavor Inspect:")*
;1            (MULTIPLE-VALUE-BIND (VALUE PUNT-P) (INSPECT-GET-VALUE-FROM-USER USER HISTORY INSPECTORS)*
;1              (OR PUNT-P (Flavor-Inspect VALUE)))*
;1            (SEND FRAME :HANDLE-PROMPT))*
 
;1; Add the new command to the list of inspector menu commands.  *
;1;;(Setq INSPECTOR-MENU-CMDS (Cons 'Flavor-Inspect-CMD (delete 'Flavor-Inspect-CMD INSPECTOR-MENU-CMDS)))*
 
;1; Now rebuild all of the command tables and menus for the inspector.  Copied from the inspector sources.*
;1(BUILD-COMMAND-TABLE 'INSPECTOR-MENU-CMD-TABLE 'INSPECT-FRAME INSPECTOR-MENU-CMDS :INIT-OPTIONS*	
;1                     '(:NAME "Inspector menu commands")) *
 
;1(BUILD-COMMAND-TABLE 'inspector-other-cmd-table 'inspect-frame*
;1  inspector-non-menu-cmds*
;1  :INIT-OPTIONS*
;1  '(:NAME "Other Inspector commands"))*
 
;1(BUILD-MENU 'UCL-INSPECTOR-MENU 'INSPECT-FRAME :DEFAULT-ITEM-OPTIONS `(:FONT ,inspect-standard-font)*	
;1            :ITEM-LIST-ORDER INSPECTOR-MENU-CMDS)  *

;1; Now throw away all previous inspector frames which will not have the new command.*
;1(clear-resource 'tv:inspect-frame-resource)*

;1;  Modified to fit into 604x432 window on MicroExplorer or 688x432 window on Explorer*
;1;  Added :names option to make menu name shorter - 11/19/87 CAT*
(DEFCOMMAND 4(flavor-inspector :help-on-syntax*) ()
  '(:names ("3Syntax Help*")
    :keys #\Meta-help
    :description "3Prints help on the processing of typed expressions.*")
  (SEND self :format-message
	"
You may type any of the following expressions:

-- a flavor name to inspect, terminated by pressing the RETURN key
-- a method specification to inspect.  The syntax is
     (Flavor-Name Method-Name)
   or
     (Flavor-Name Method-Type Method-Name)
   or
     Flavor-Name Method-Name
   or    
     Flavor-Name Method-Type Method-Name

   The last two types of expressions are terminated by pressing the RETURN key.
   Method-Type is one of the following:
     :AFTER :AND :AROUND :BEFORE :CASE :DEFAULT :OR :OVERRIDE :WRAPPER


While typing these expressions, you may press the SPACE Bar to complete a flavor
or method name.  You may also use the Input Editor completion commands summarized
below:

   CTRL-ESCAPE  -- Recognition Completion (same as the SPACE Bar)
   CTRL-\/      -- List Recognition Completions
   SUPER-ESCAPE -- Apropos Completions (complete word as an inner substring)
   SUPER-\/     -- List Apropos Completions
   HYPER-ESCAPE -- Spelling Corrected Completion (corrects minor typos)
   HYPER-\/     -- List Spelling Corrected Completions"))


(DEFCOMMAND 4(flavor-inspector :help-on-inspected-data*) ()  
   '(:keys #\Mouse-m       ;1; mouse-m-1 before xlate*
     :description "3Information about the data currently displayed in an inspection pane.*")
   (IF (MEMBER (THIRD ucl::kbd-input) inspectors :test #'EQ)
     (LET* ((inspection-data (SEND (THIRD ucl::kbd-input) :current-object))
	    (help
	     (WHEN (TYPEP inspection-data 'inspection-data)
	       (SEND inspection-data :send-if-handles :help))))
       (IF (EQUAL inspection-data '(nil))
	 (SEND self :format-message "
3MOUSE M is inactive when the inspection pane is empty.*")
	 (SEND self :format-message (OR help "
3No help is available on this data.*"))))
     (BEEP))) 

(DEFCOMMAND 4(flavor-inspector :options-menu*) ()  
   '(:keys #\Mouse-r 
     :description "3A menu of options for the selected (moused) inspection pane.*")
   (IF (MEMBER (THIRD ucl::kbd-input) inspectors :test #'EQ)
     (LET ((inspection-data (SEND (THIRD ucl::kbd-input) :current-object))
	   *flavor-data*)
       (DECLARE (SPECIAL *flavor-data*))
       (COND
	 ((EQUAL inspection-data '(nil))
	  (SEND self :format-message "3MOUSE R is inactive when the inspection pane is empty.*"))
	 ((TYPEP inspection-data 'flavor-operation-mixin)
	  (SETQ *flavor-data* (SEND inspection-data :data))
	  (LET ((call-edit nil))
                   (DECLARE (SPECIAL *flavor-data* call-edit))
                   (w:menu-choose *flavor-options-menu*
                                          :label (FORMAT nil "3Operations on ~S*" (si::flavor-name *flavor-data*))
                                          :scrolling-p nil)
		   (IF call-edit
		       (ED (si::flavor-name *flavor-data*)))
		   ))))
;	1  (w:MENU-CHOOSE *FLAVOR-OPTIONS-MENU**	
;1                         :LABEL (FORMAT () "Operations on ~S" (SI:FLAVOR-NAME *FLAVOR-DATA*))*	
;1                         :scrolling-p nil))))*
     (BEEP))) 

(DEFCOMMAND 4(flavor-inspector :end-cmd*) ()
  '(:description "3Exit the Flavor Inspector.*"
    :names ("3Exit*")
    :keys (#\End))
  (SEND self :bury))    ;1; changed from :bury, this returns the frame to its resource*

(DEFCOMMAND 4(flavor-inspector :all-flavors*) ()
  '(:description "3Display all flavor names in an inspection frame*"
    :documentation "3...permits user to select a flavor to inspect...*"
    :keys #\Super-a)
  (LET ((flavors (inspect-real-value `(:value ,(allocate-data 'show-all-flavors 'IGNORE) ,history))))
    ;1; Might not work since not EQ*
    (inspect-flush-from-history flavors history)
    (SEND history :append-item flavors)
    (update-panes)
    ;1; We don't want our result to be printed.*
    (SETQ ucl:inhibit-results-print? t))) 

(DEFCOMMAND 4config-toggle-cmd* nil
            '(:description  "3Select a new Flavor-Inspector pane configuration.*"
              :names ("3Config*")
              :keys (#\s-c))
            (DECLARE (SPECIAL frame))
            (LET ((new-cfg (w:menu-choose '(:three-panes :one-pane :two-horizontal-panes :two-vertical-panes)
                                        :label "3Choose a new flavor-inspector configuration*" :scrolling-p nil)))
              (delaying-screen-management 
                (COND (new-cfg
                       (SETQ *flavor-inspector-configuration* new-cfg)
                       (SEND frame :set-configuration new-cfg))))))

(DEFCOMMAND 4mode* ()
   '(:description "3Toggle between Lisp mode and Inspect mode.*"
     :names ("3Mode*")
     :keys (#\s-m))
   (DECLARE (SPECIAL ucl::typein-modes ucl::prompt))
   (COND
     ((MEMBER 'flavor-names ucl::typein-modes :test #'EQ) (SETQ ucl::prompt "3> *")
      (SETQ ucl::typein-modes ucl::*default-typein-modes*))
     (t (SETQ ucl::prompt "3Flavor\/Method: *")
      (SETQ ucl::typein-modes '(method-specs flavor-instance flavor-names ucl::command-names))))
   (SEND ucl::this-application :handle-prompt)) 


(DEFCOMMAND 4(flavor-inspector :trace-method*) ()
  '(:description "3Traces a specified method*"
    :names ("3Trace*")
    :keys (#\S-t))
  (DECLARE (SPECIAL ucl:typein-modes ucl:prompt))
  (LET ((method-spec (read-method-spec)))
    (trace-via-menus method-spec)))

;1; Reads and returns flavor spec, with all completion and who-line help active.*
;1; This mimics TV:READ-FLAVOR-NAME.*
(DEFUN 4read-method-spec* ()
  (DECLARE (:self-flavor ucl::basic-command-loop))
  (LET ((ucl::typein-modes '(method-specs))
	(ucl::command-loop-typein? self)
	method-spec)
    (DECLARE (SPECIAL ucl::typein-modes ucl::command-loop-typein?))
    (SEND self :handle-prompt t "3Method spec: *")
    (SETQ method-spec (CONS :method (sys::internal-read-form-or-implicit-list)))
    (COND
      ((AND (LISTP method-spec) (FDEFINEDP method-spec)) (SEND self :handle-prompt) method-spec)
      (t (FORMAT t "3** ~s is not a defined method*" method-spec) (SEND self :handle-prompt)
       (THROW 'ucl::command-abort
	      ()))))) 

;1;; Modified to fit into 604x432 window on MicroExplorer or 688x432 window on Explorer*
;1;; Change command name from doc to help (done in conjunction with changing help-on-syntax name) - 11/19/87 CAT*
;1Include the stuff in Help On Syntax.*
(DEFCOMMAND 4(flavor-inspector :fi-doc-cmd*) ()
            '(:description 
             "3Display some brief documentation about each of the Flavor-Inspector's panes.*"
             :names ("3Help*")
             :keys (#\c-help))
  (fi-doc-cmd))

;1;; Modified to fit into 604x432 window on MicroExplorer or 688x432 window on Explorer*
;1;; Changed text length to to max of 83 char long - 11/19/87 CAT*
(DEFUN 4fi-doc-cmd* ()
  "2Display some brief documentation about each of the Flavor-Inspector's panes.*"
  (si:with-help-stream (window :label "3Documentation for Flavor-Inspector*" :superior tv:default-screen)
    (FORMAT window
"                                FLAVOR INSPECTOR HELP
-----------------------------------------------------------------------------------
                        *** OPTIONAL THIRD INSPECTION PANE ***

    Displays previously inspected item.
-----------------------------------------------------------------------------------
                             *** OPTIONAL SECOND PANE ***

    Displays previously inspected item.
-----------------------------------------------------------------------------------
                             *** MAIN INSPECTION PANE ***

    This pane displays the structure of the most recently inspected item.
    Specify objects to inspect by either:
      * Entering them into the Interaction Pane or,
      * Clicking Mouse-Left on mouse sensitive elements of previously inspected
        items.

    Clicking Mouse-Right on items in this pane tries to inspect the item's flavor
    definition.
    Click MOUSE-MIDDLE-2 anywhere in the pane toggles the pane's locked status.
    When locked, the insepcted item in that pane will be frozen until unlocked.
    Only two of the 3 panes may be locked.
-----------------------------------------------------------------------------------
     COMMAND     |                         *** HISTORY PANE **
      MENU       |
                 |  This pane shows a list of the objects that have been inspected.
Click Mouse-Left |
to select a      |  To bring an object back into the Main Inspection Pane, click
command.         |  Mouse-Left on that object in this pane.
                 |
                 |  To remove an item from the History Pane, position the
                 |  mouse-cursor to the left of the item until the cursor becomes
                 |  a right-pointing arrow (this is the items \"line area\").
                 |  Now click Mouse-Middle.                 
-----------------------------------------------------------------------------------
                               *** INTERACTION PANE *** 

      Enter items to inspect in this pane.  You may enter any of the following:
           * A flavor name to inspect, terminated by pressing the RETURN key
           * A method specification to inspect.  The syntax is
                  (Flavor-Name Method-Name)   or
                  (Flavor-Name Method-Type Method-Name)   or
                  Flavor-Name Method-Name   or    
                  Flavor-Name Method-Type Method-Name

      The last two types of expressions are terminated by pressing the RETURN key.
      Method-Type is one of the following:
           :AFTER :AND :AROUND :BEFORE :CASE :DEFAULT :OR :OVERRIDE :WRAPPER
      This pane may also be used for command name typein and for Lisp typein.  
      For Lisp typein use the Mode command.  The last three inspected objects are 
      stored in the top three Inspection Panes.
-----------------------------------------------------------------------------------")))


#|3 
This documentation describes roughly how the DEBUG option of the flavor menu 
should work.

(DEFCOMMAND (flavor-inspector :debug-flavor) ()
  '(:DESCRIPTION "Displays inconsistencies in a given flavor."
    :DOCUMENTATION "Displays inconsistencies and possibly dangerous aspects of a flavor
whose name is read from the user.  The following lists each condition searched for and
a description of why the condition is considered inconsistent or dangerous.

[flesh this out]
 1. Flavor has an instance variable supplied by two or more of its flavor components.

    Each component probably makes assumptions about the nature of the instance variable
    and their methods will interfere with each other.


 2. Flavor has two or more instance variables having the same name in different packages;
    for instance, TV:FOO and ZWEI:FOO.

    This is buggy, especially if both are gettable and settable.  The methods :FOO and
    :SET-FOO will only operate on one of these variables, whichever's responsible flavor
    is highest in the heirarchy of component flavors.  Yet methods of the other flavor
    will be addressing the wrong variable in their sending of :FOO and :SET-FOO messages.

 3. Flavor defines a basic (non-demonic) method which is defined by one of its flavor
    components.

    This is not actually buggy; in fact, many times it is expected that a flavor specialize
    methods defined by their component flavors.  However, it is handy for you to see a
    list of all methods you have shadowed, in case you redefined a method without realizing
    it.  For instance, if your window flavor defines method :SELECT to have the user
    select something from a menu, your window won't be selectable because :SELECT is
    a low-level window method which shouldn't normally be redefined.  Using the Debug-Flavor
    option of the Flavor Inspector, you would quickly see that you have redefined an important
    method.

 4. ????"
    :KEYS #\SUPER-D)
  (SEND SELF :format-message "Not implemented yet."))*
|#

(BUILD-COMMAND-TABLE 'flavor-inspector-cmd-table 'flavor-inspector
  '(:all-flavors
     :help-on-syntax
     :help-on-inspected-data
     :end-cmd
     :options-menu
     :trace-method
     :fi-doc-cmd
     config-toggle-cmd
     mode
     ;1; These are Inspector commands we are able to borrow.*
     delete-all-cmd
     refresh-cmd
     page-up-cmd
     page-down-cmd
     page-to-top
     page-to-bottom
     break-cmd)
  :init-options '(:name "3Flavor Inspector Commands*"))



(BUILD-MENU 'flavor-inspector-menu 'flavor-inspector
  :item-list-order
  '(:help-on-syntax
    :all-flavors
     :trace-method
     :end-cmd
     :fi-doc-cmd
     delete-all-cmd
     refresh-cmd
     page-up-cmd
     page-down-cmd
     break-cmd
     mode
     config-toggle-cmd))

;1; Make sure this covers everything.*
(COMPILE-FLAVOR-METHODS 
  show-flavor
  show-component-flavors
  show-dependent-flavors
  show-local-methods
  show-all-methods
  show-all-methods-sorted
  show-all-handled-messages
  show-message
  show-instance-variables
  show-miscellaneous-data
  show-method
  show-method-details
  show-message-handlers
  show-instance-variable
  show-methods-referencing-instance-variable
  show-all-flavors
  flavor-inspector)


;1; The following is the code necessary to define the function Flavor-Inspect, a functional*
;1; interface to the flavor inspector.*
 
(DEFUN 4inspect-flavor* (&optional (object nil objp))
  "2Call the Flavor Inspector to inspect OBJECT.  Selects a Flavor Inspector window.
   The Inspector runs in its own process, so your special variable bindings will not be visible.
   If you type END or use the exit menu option the original object  will
   be returned.*"
  (LET ((iframe (find-or-create-window 'flavor-inspector))
        (top-item nil))
        (DECLARE (SPECIAL top-item))
	(IF objp
	    (COND ((INSTANCEP object)
		   (SEND iframe :inspect-instance object))
		  ((TYPEP object 'si::flavor)
		   (SEND iframe :inspect-structure object))
		  ( t (SEND iframe :inspect-object object)))
	     object)))
 
(DEFMETHOD 4(flavor-inspector :inspect-object*) (object)
  (LET ((thing (inspect-real-value
                 `(:value ,(allocate-data 'show-flavor (GET object 'si::flavor)) ,history))))
    ;1; First flush item we will be inspecting*
    (inspect-flush-from-history thing history)
    (SEND history :append-item thing)
    (update-panes)))

(DEFMETHOD 4(flavor-inspector :inspect-structure*) (object)
  (LET ((thing (inspect-real-value
                 `(:value ,(allocate-data 'show-flavor  object) ,history))))
    ;1; First flush item we will be inspecting*
    (inspect-flush-from-history thing history)
    (SEND history :append-item thing)
    (update-panes)))

(DEFMETHOD 4(flavor-inspector :inspect-instance*) (object)
  (LET ((thing (inspect-real-value
                 `(:value ,(allocate-data 'show-flavor (GET (TYPE-OF (EVAL object)) 'si::flavor)) ,history))))
    ;1; First flush item we will be inspecting*
    (inspect-flush-from-history thing history)
    (SEND history :append-item thing)
    (update-panes)))

;1(DEFUN Inspect-FLAVOR* (&OPTIONAL OBJECT)*
;1"Call the Flavor Inspector to inspect OBJECT.  Selects a Flavor Inspector window.*
;1The Inspector runs in calling process, so our special variable bindings are visible.*
;1If you type END or use the exit menu option the original object  will*
;1be returned.*
;1Written by JPR 21 May 86."*
;1  (USING-RESOURCE (IFRAME Flavor-Inspector-Resource DEFAULT-SCREEN)*
;1    (LET ((si:*keep-locals-for-eval* t))*
;1      (if (not (equal (SEND IFRAME :PREPARE-FOR-USE OBJECT*
;1                            (FORMAT NIL "Inspector for ~A" (SEND CURRENT-PROCESS :NAME)))*
;1                      :Object-Not-Found))*
;1          (WINDOW-CALL-WITH-SELECTION-SUBSTITUTE (IFRAME :DEACTIVATE) (INSPECT-COMMAND-LOOP IFRAME))*
;1          nil        ;Do nothing if it couldn't find a flavor or method. (JPR)*
;1          ))*
;1    object))*
 
(DEFUN 4find-flavor-inspectable-object* (initial-object)
"2This function is passed an object which should be coercable into a flavor
examinable object and does that coercion.  It returns either a 'Show-Flavor
object, to denote the flavor that it has managed to coerce, a
'Show-Method-Details object to denote the method its has coerced, or nil
if it can find neither a flavor nor a method in initial-object.
Written by JPR 21 May 86.*"
  (COND
    ((SYMBOLP initial-object)
      (IF (GET initial-object 'si::flavor)
	  (allocate-data 'show-flavor (GET initial-object 'si::flavor))
	  nil))
    ((TYPEP initial-object 'si::flavor) (allocate-data 'show-flavor initial-object))
    ((AND (CONSP initial-object) (EQUAL (FIRST initial-object) :method))
      (LET ((method-spec (system:dwimify-arg-package initial-object 'function-spec)))
	   (LET ((method-data (LIST method-spec (FDEFINITION method-spec) (si::method-plist method-spec))))
		(allocate-data 'show-method-details (GET (SECOND method-spec) 'si::flavor) method-data))))
    ((FUNCTIONP initial-object)
      (LET ((method-spec (FUNCTION-NAME initial-object)))
	   (IF (AND (CONSP method-spec) (EQUAL (FIRST method-spec) :method))
	       (LET ((method-data (LIST method-spec (FDEFINITION method-spec) (si::method-plist method-spec))))
		    (allocate-data 'show-method-details (GET (SECOND method-spec) 'si::flavor) method-data))
	       nil)))
    (t nil)))
 
(DEFMETHOD 4(flavor-inspector :prepare-for-use*) (initial-object new-label)
"2This is a modified version of the Inspect-Frame :Prepare-for-use method.
It is passed some object which should be coercable into a flavor examinable
thing, i.e. a symbol, a flavor structure, a method spec or a method.
It coerces the object suitably and puts it into the history list and
starts the window up.
Created by JPR on 21 May 86.*"
  (SEND self :set-label new-label)
  (LET ((object (find-flavor-inspectable-object initial-object)))
       (LET ((hw (SEND self :get-pane 'history)))
	 (IF (AND initial-object (NOT object))
	     ;1; If the initial object is non-nil but the coerced object is nil (i.e. it can't find a flavor or a method)*
	     ;1; then just beep and return an error code.*
	     (PROGN (BEEP) :object-not-found)
	     ;1; Otherwise put the object into the history list.*
	     (PROGN (COND
		      (object
		       (with-sheet-deexposed (self) (SEND hw :flush-contents)
					     (SEND hw :append-item object)
					     (DOLIST (iw (SEND self :inspectors))
					       (SEND iw :set-current-display
						     (SEND iw :setup
							   `(inspect-printer nil nil nil
									     (nil nil nil nil
										  ,(label-font (SEND iw :label))
										  "3Empty*"))))
					       (SEND iw :set-current-object (LIST nil))))))
		    (SEND (SEND self :typeout-window) :make-complete)
		    (SEND hw :clear-input))))))
 
;1; Resource for process-less Flavor-Inspectors.  Defined by JPR on 21 May 86.*
(DEFWINDOW-RESOURCE 4flavor-inspector-resource* nil :make-window
                    (flavor-inspector :process nil :label "3foo*") :reusable-when :deactivated) ;1:initial-copies 0) *
 
;1(add-to-system-menu-column :debug "Flavor Inspector"*
;			1   '(w:select-or-create-window-of-flavor 'flavor-inspector)*
;			1   "Select a Flavor Inspector, to browse through Flavor structures"*
;			1   :sorted)*

#|
3;; Garr's code.  Be sure to look at all Zmacs flavor commands.  Bug in Dwimifiy???

;; from Bambi: LYSTAD; IPATCHES2.#
zwei:
(DEFCOM COM-METHOD-APROPOS "You supply the flavor at the prompt, and then the extended search string to match
the methods against.  The result is a mouse sensitive typeout display of matching methods of flavor and its
components." ()
  (LET* ((FLAVOR-name*
	3   (READ-FLAVOR-NAME "Flavor"*
	3      "You are typing a flavor name, to list its methods which match a string you will enter."))*
	3 FLAVOR FUNCTION KEY STR METHOD-LIST)
    ;;Make sure we have a valid flavor name.
    (OR (SYMBOLP FLAVOR-NAME) (BARF "Enter a symbol which is the name of a flavor"))
    (SETQ FLAVOR (GET FLAVOR-NAME 'SI:FLAVOR))
    ;;We should be guaranteed a flavor by read-flavor-name, but to be safe...
    (OR FLAVOR (BARF "~s does not seem to be the name of any flavor in the system." FLAVOR-NAME))
    ;;Get the search function and string.
    (MULTIPLE-VALUE (FUNCTION KEY STR)
      (GET-EXTENDED-SEARCH-STRINGS (FORMAT nil "Find methods for ~s containing substring:" flavor-name)))
    ;;Get the list of matching methods for the flavor.
    (LOOP FOR ELEMENT IN (ALL-METHODS-SORTED FLAVOR)*
	3    AS NAME = (STRING (CAR (LAST ELEMENT)))*
	3    WHEN (FUNCALL FUNCTION KEY NAME)*
	3    DO (PUSH ELEMENT METHOD-LIST) )
    ;;Put up the list on the screen.
    (WITH-TYPEOUT-FONT-MAP-OF ((GET-SEARCH-MINI-BUFFER-WINDOW))
      (EDIT-DEFINITIONS T*
			3'DEFUN*
			3(MAPCAR #'(LAMBDA (OBJ)*
					3(CONS (FORMAT NIL "~S" OBJ) OBJ))*
			3      (REVERSE method-list))*
			3'com-go-to-next-possibility*
			3#\c-sh-p*
			3"All methods of flavor ~S and its components matching ~a:"*
			3"No methods of flavor ~S matching ~a."*
			3FLAVOR-name str)))
  dis-none)*
|#


;1; 7/15/88 clm - the following code implements a DEBUG feature.*
;1; The code was provided by Rich Acuff.  *

(DEFUN 4simplify-iv* (iv)
  "2If passed an instance variable, which is either a symbol or a (symbol default) list.
   It returns the symbol either way.*"
  (IF (CONSP iv)
      (FIRST iv)
      iv))

(DEFUN 4get-simple-ivs* (flavor)
  "2If passed a flavor structure returns a list of symbols denoting the names of the
   instance variables of that flavor.*"
  (MAPCAR #'simplify-iv (si::flavor-local-instance-variables flavor)))

(DEFUN 4get-ivs* (flavor)
  "2If passed a flavor structure this function returns values which are:
       The components of the flavor, excluding itself
       A list of all of the instance variables for all of the components.*"
  (LET ((components (get-all-components flavor)))
    (VALUES components (MAPCAR #'get-simple-ivs components))))  

(DEFUN 4symbols-match* (symbol-1 symbol-2 depackage-p)
  "2This is a sort of predicate, which tests whether two symbols could be said to    
   match.  It is passed two symbols and a flag, which determines whether the comparison
   is to be made in terms of the symbols themselves (equal test) or of their pnames
    (depackage-p = t). If the symbols are to be compared in terms of their pnames then
   they are said to match if they are no the same symbol and yet their pnames are   
   string-equal.*"
  (IF depackage-p
      (AND (NOT (EQUAL symbol-1 symbol-2)) (STRING-EQUAL (SYMBOL-NAME symbol-1) (SYMBOL-NAME symbol-2)))
      (EQUAL symbol-1 symbol-2)))

(DEFUN 4is-in* (symbol list test depackage-p)
  "2This function is passed a symbol, a list of symbols and a test to determine whether
   the symbol can be said to be in the list.  If the symbol is found to be in the list
   then the function returns a two-list having as its elements the symbol and the symbol
   in the list with which it was matched.  The depackage-p flag is used by the test  
   function to determine how it is to perform the test.*"  
  (DECLARE (optimize (safety 0)))
  (IF (EQUAL nil list)
      nil 
      (IF (FUNCALL test symbol (FIRST list) depackage-p)
	  (LIST symbol (FIRST list))
	  (is-in symbol (REST list) test depackage-p))))

(DEFUN 4look-for-match* (flavor ivs other-flavors other-ivs depackage-p)
  "2This function is passed a flavor structure and its local ivs, a list of other 
   flavors, which are other components like the first flavor and a list of lists of
   ivs in the component flavors.  It returns a list of match descriptors, one for   
   each instance of finding an iv in the current flavor redefined in one of the
   other flavors.  Each match descriptor is a three-list.  The first element
   is a two-list holding the two instance variable names for the matching names.  The
   second and thrid elements are the flavor structures for the multiple defining flavor
   and the multiple definee flavor.  The depackage-p argument is non-nil if the type of
   multiple definition looked for is to be one of looking for clashes like tv:foo and
   zwei:foo.*"  
  (DECLARE (optimize (safety 0)))
  (IF (EQUAL other-ivs nil)
      nil 
      (IF (EQUAL flavor (FIRST other-flavors))
	  (look-for-match flavor ivs (REST other-flavors) (REST other-ivs) depackage-p)
	  (LET ((matches (DELETE nil (map-with-args #'is-in ivs (FIRST other-ivs) #'symbols-match depackage-p))))
	    (IF matches
		(APPEND (map-with-args #'LIST matches flavor (FIRST other-flavors))
			(look-for-match flavor ivs (REST other-flavors) (REST other-ivs) depackage-p)
			)
		(look-for-match flavor ivs (REST other-flavors) (REST other-ivs) depackage-p))))))

(DEFUN 4find-multiple-definitions-1* (components ivs depackage-p result)
  "2This function is passed a list of flavor structures, which are the components of the
   structure in question, and a list of the instance variables, for which it is look for
   multiple definitions.  It returns a list of match descriptors, one for each multiple
   definition that it finds.  Each match descriptor is a three-list.  The first element
   is a two-list holding the two instance variable names for the matching names.  The
   second and thrid elements are the flavor structures for the multiple defining flavor
   and the multiple definee flavor.  The depackage-p argument is non-nil if the type of
   multiple definition looked for is to be one of looking for clashes like tv:foo and
   zwei:foo.*"  
  (DECLARE (optimize (safety 0)))
  (IF (EQUAL nil components)
      result
      (LET ((matches (look-for-match (FIRST components) (FIRST ivs) (REST components) (REST ivs) depackage-p)))
	(find-multiple-definitions-1 (REST components) (REST ivs) depackage-p (APPEND matches result)))))

(DEFUN 4find-multiple-definitions* (components ivs depackage-p)
  "2This function is passed a list of flavor structures, which are the components of the
   structure in question, and a list of the instance variables, for which it is look for
   multiple definitions.  It returns a list of match descriptors, one for each multiple
   definition that it finds.  Each match descriptor is a three-list.  The first element
   is a two-list holding the two instance variable names for the matching names.  The
   second and thrid elements are the flavor structures for the multiple defining flavor
   and the multiple definee flavor.  The depackage-p argument is non-nil if the type of
   multiple definition looked for is to be one of looking for clashes like tv:foo and
   zwei:foo.*"
  (find-multiple-definitions-1 components ivs depackage-p nil))

(DEFUN 4get-primary-methods* (methods)
  "2Is passed a list of method specs, found in the method table of a flavor structure.
   It returns a list of all of the methods, which are primary methods.  These have a
   method descriptor length of three (:method foo :bar).
   *"  
  (REMOVE-IF-NOT
    #'(lambda (element)
	(AND (= (LENGTH (FIRST (FOURTH element))) 3)
	     (NOT (EQUAL :set (FIRST element)))))   
    methods))  

(DEFUN 4recons* (a b)
  "2Reverse cons.*"
  (CONS b a))  

(DEFUN 4associate-all-methods* (method method-alist)
  "2Is passed a method descriptor and a list of method descriptors.  It returns a     
   list of all of the method descriptors in the alist, which have the same method
   name as Method.*"  
  (REMOVE-IF-NOT
    #'(lambda (element) (EQUAL (FIRST method) (FIRST (FIRST element))))
    method-alist))

(DEFUN 4check-for-shadowing-methods* (flavor)
  "2This function is passed a flavor structure.  It returns a two-list.  The
   first of the list is a list of all of the primary methods in itself and
   its components.  The second is a list of all of the primary methods of its
   components, which are shadowed by either itself or any of its components.*"  
  (LET ((components (DELETE flavor (get-all-components flavor)))
	(primary-methods (DELETE :set (get-primary-methods (si::flavor-method-table flavor)))))  
    (LET ((primary-methods-and-shadows-from-components (MAPCAR #'check-for-shadowing-methods components)))
      (LET ((primary-methods-from-components
	      (uniqueise 
		(APPLY #'APPEND (DELETE nil (MAPCAR #'FIRST primary-methods-and-shadows-from-components)))))
	    (shadows-from-components
	      (APPLY #'APPEND (DELETE nil (MAPCAR #'SECOND primary-methods-and-shadows-from-components))))
	    (primary-methods-and-flavor (map-with-args #'LIST primary-methods flavor)))
	(LET ((new-shadows
		(APPLY #'APPEND
		       (DELETE nil (map-with-args #'associate-all-methods primary-methods
						  primary-methods-from-components)))))     
	  (LIST (APPEND primary-methods-and-flavor primary-methods-from-components)
		(uniqueise (APPEND (map-with-args #'recons new-shadows flavor) shadows-from-components))) 
	  )))))

(DEFUN 4get-method-name-from-shadow* (SHADOW)
  "2Given a method structure for a shadowed method, which is a three-list
   whose elements are :- the shadowing flavor, the method as it is found
   in the flavor's method table and the shadowed flavor, this function
   returns the name of the method.*"  
  (FIRST (SECOND shadow)))

(DEFUN 4get-shadowed-methods* (flavor)
  "2Given a flavor structure this function returns a list denoting all of
   the cases in which a primary method of a component of this flavor is
   shadowed by some higher component.  This list is sorted so that the
   method names are in alphabetical order.  Each element in the list is
   a three-list with the following structure :-
    (#<shadowing-flavor> (method-data) #<shadowed-flavor>)*"  
  (SORT (uniqueise (SECOND (check-for-shadowing-methods flavor)))
	#'STRING-LESSP :key #'get-method-name-from-shadow))

(DEFUN 4collect-undefined-components* (flavor)
  "2Given a flavor structure this function returns a list of all of the
   components of that flavor, which have not yet been defined.*"
  (MULTIPLE-VALUE-BIND (local-components defined-components) (get-local-defined-components flavor)
    (LET ((result-from-components (DELETE nil (MAPCAR #'collect-undefined-components defined-components))))
      (uniqueise (APPEND (map-with-args #'LIST
					(SET-DIFFERENCE local-components (MAPCAR #'si::flavor-name defined-components))
					flavor) 
			 (MAPCAR #'APPEND result-from-components))))))

(DEFUN 4collect-required-things* (flavor selector)
  "2This is a general function which is passed a flavor and a keyword which is
   the name of the property denoting things that are required by the flavor,e.g.  
   methods, ivs.  It returns a list of two-lists.  Each two-list contains, first
   the name of the required component and second the flavor structure in which
   it is required.*"
  (MULTIPLE-VALUE-BIND (local-components defined-components) (get-local-defined-components flavor)
    (IGNORE local-components)
    (LET ((local-required-things (GET (CONS nil (si::flavor-plist flavor)) selector))
	  (inherited-required-things 
	    (DELETE nil (map-with-args #'collect-required-things defined-components selector))))
      (APPEND (map-with-args #'LIST local-required-things flavor) (APPLY #'APPEND inherited-required-things)))))

(DEFUN 4find-unsatisfied-things* (flavor selector test)
  "2Given a flavor structure, a keyword which denotes which sort of things
   is required, e.g. :Required-Methods, and a function which is able to
   determine whether the things that are required are indeed satisfied,
   this function returns a list of two-lists describing all of the required
   things that have not been defined.*"
  (LET ((required-things (collect-required-things flavor selector)))
    (FUNCALL test required-things flavor)))

(DEFUN 4filter-out-satisfied-flavors* (required flavor)
  "2Given a list of two-lists which describe required flavors and a
   flavor structure, this function returns that subset of the
   required components which is not satisfied.*"
  (IGNORE flavor)
  (REMOVE-IF #'(lambda (element) (GET (FIRST element) 'si::flavor))
	     required))

(DEFUN 4list-of-unsatisfied-required-flavors* (flavor)
  "2Given a flavor structure this returns a list of two-lists
   describing the unsatisfied required flavors for that flavor.*"
  (find-unsatisfied-things flavor :required-flavors #'filter-out-satisfied-flavors))

(DEFUN 4search-for-method* (flavor method)
  "2Given a flavor structure and a method name this returns T
   if the method is defined by the flavor or one of its components,
   otherwise it returns nil.*"
  (IF (ASSOC method (si::flavor-method-table flavor))
      t   
      (MULTIPLE-VALUE-BIND (local-components defined-components) (get-local-defined-components flavor)
	(IGNORE local-components)
	(NOT (EQUAL nil (DELETE nil (map-with-args #'search-for-method defined-components method)))))))

(DEFUN 4filter-out-satisfied-methods* (required flavor)
  "2Given a list of two-lists which describe required methods and a
   flavor structure, this function returns that subset of the
   required components which is not satisfied.*"
  (REMOVE-IF #'(lambda (element) (search-for-method flavor (FIRST element)))
	     required))

(DEFUN 4list-of-unsatisfied-required-methods* (flavor)
  "2Given a flavor structure this returns a list of two-lists
   describing the unsatisfied required methods for that flavor.*"
  (find-unsatisfied-things flavor :required-methods #'filter-out-satisfied-methods))

(DEFUN 4search-for-iv* (flavor iv)
  "2Given a flavor structure and an instance variable name this returns T
   if the instance variable is defined by the flavor or one of its components,
   otherwise it returns nil.*"
  (IF (MEMBER iv (get-simple-ivs flavor))
      t   
      (MULTIPLE-VALUE-BIND (local-components defined-components) (get-local-defined-components flavor)
	(IGNORE local-components)
	(NOT (EQUAL nil (DELETE nil (map-with-args #'search-for-iv defined-components iv)))))))

(DEFUN 4filter-out-satisfied-ivs* (required flavor)
  "2Given a list of two-lists which describe required instance
   variables and a flavor structure, this function returns
   that subset of the required components which is not satisfied.*"
  (REMOVE-IF #'(lambda (element) (search-for-iv flavor (FIRST element)))
	     required))

(DEFUN 4list-of-unsatisfied-required-ivs* (flavor)
  "2Given a flavor structure this returns a list of two-lists
   describing the unsatisfied required instance variables for
   that flavor.*"
  (find-unsatisfied-things flavor :required-instance-variables #'filter-out-satisfied-ivs))

(DEFFLAVOR 4debug-flavor* ()
	   (flavor-operation-mixin)
  (:documentation :special-purpose
		  "3A flavor used by the flavor inspector in order to represent a request be the user to
   execute the debug flavor command for a given flavor.  It is somewhat like Show-Flavor.*"))

(DEFMETHOD 4(debug-flavor :format-concisely*) (STREAM)
  "2Prints the instance of Debug-Flavor in a simple manner.  This is used
   to display the flavor in the flavor inspector's history window and
   such like.*" 
  (FORMAT stream "3~s's debug data*" (si::flavor-name data)))

(DEFMETHOD 4(debug-flavor :generate-item*) ()
  "2This method generates a window item for displaying in the flavor inspector
   which shows debug information associated with the flavor in question.
   This window item is made up of a number of window items describing the state
   of affairs in detail.*"  
  ;1; This makes sure that the flavor's mixin's instance variables have been included into the flavor.*
  (LET* ((flavor-name (si::flavor-name data))
	 (flavor data)
	 (clashes (MULTIPLE-VALUE-BIND (components ivs) (get-ivs flavor)
		    (find-multiple-definitions components ivs nil)))
	 (package-clashes (MULTIPLE-VALUE-BIND (components ivs) (get-ivs flavor)
			    (find-multiple-definitions components ivs t)))
	 (shadowed-methods (get-shadowed-methods flavor))
	 (undefined-components (collect-undefined-components flavor))
	 (unsatisfied-flavors (list-of-unsatisfied-required-flavors flavor))
	 (unsatisfied-methods (list-of-unsatisfied-required-methods flavor))
	 (unsatisfied-ivs (list-of-unsatisfied-required-ivs flavor))
	 ) 
    (VALUES
      `(,*blank-line-item*
	;1; ------------------------------*
	,@(IF clashes
	      `(((:font 1 "3Multiple declarations of the same instance variable for flavor *")    
		 (:item1 instance ,(allocate-data 'show-flavor data))
		 (:font 1 "3:*")))
	      nil
	      )
	,@(LOOP for clash in clashes
		append `(((:font 3 "3  *")
			  (:item1 instance ,(allocate-data 'show-instance-variable (FIRST (FIRST clash))))
			  (:font 3 "3 in flavors *")
			  (:item1 instance ,(allocate-data 'show-flavor (SECOND clash)))
			  (:font 3 "3 in flavors *")
			  (:item1 instance ,(allocate-data 'show-flavor (THIRD clash)))))
		)
	;1; ------------------------------*
	,@(IF package-clashes *blank-line-item*)
	,@(IF package-clashes *blank-line-item*)
	,@(IF package-clashes
	      `(((:font 1 "3Declarations of instance variables with the same PName but are in different packages for flavor *")
		 (:item1 instance ,(allocate-data 'show-flavor data))
		 (:font 1 "3:*")))
	      nil
	      )
	,@(LOOP for clash in package-clashes
		append `(((:font 3 "3  *")
			  (:item1 instance ,(allocate-data 'show-instance-variable (FIRST (FIRST clash))))
			  (:font 3 "3 in flavor *")
			  (:item1 instance ,(allocate-data 'show-flavor (SECOND clash)))
			  (:font 3 "3 and *")
			  (:item1 instance ,(allocate-data 'show-instance-variable (SECOND (FIRST clash))))
			  (:font 3 "3 in flavor *")
			  (:item1 instance ,(allocate-data 'show-flavor (THIRD clash)))))
		)
	;1; ------------------------------*
	,@(IF undefined-components *blank-line-item*)
	,@(IF undefined-components *blank-line-item*)
	,@(IF undefined-components
	      `(((:font 1 "3Undefined components of flavor *")
		 (:item1 instance ,(allocate-data 'show-flavor data))
		 (:font 1 "3:*")))
	      nil
	      )
	,@(LOOP for undefined in undefined-components
		append `(((:item1 instance ,(allocate-data 'show-undefined-flavor (FIRST undefined)))
			  (:font 3 "3 of flavor *")
			  (:item1 instance ,(allocate-data 'show-flavor (SECOND undefined)))))
		)
	;1; ------------------------------*
	,@(IF unsatisfied-flavors *blank-line-item*)
	,@(IF unsatisfied-flavors *blank-line-item*)
	,@(IF unsatisfied-flavors
	      `(((:font 1 "3Unsatisfied required flavors of flavor *")
		 (:item1 instance ,(allocate-data 'show-flavor data))
		 (:font 1 "3:*")))
	      nil
	      )
	,@(LOOP for unsatisfied in unsatisfied-flavors
		append `(((:item1 instance ,(IF (GET (FIRST unsatisfied) 'si::flavor)
						(allocate-data 'show-flavor (GET (FIRST unsatisfied) 'si::flavor))
						(allocate-data 'show-undefined-flavor (FIRST unsatisfied))))
			  (:font 3 "3 for flavor *")
			  (:item1 instance ,(allocate-data 'show-flavor (SECOND unsatisfied)))))
		)
	;1; ------------------------------*
	,@(IF unsatisfied-methods *blank-line-item*)
	,@(IF unsatisfied-methods *blank-line-item*)
	,@(IF unsatisfied-methods
	      `(((:font 1 "3Unsatisfied required methods of flavor *")
		 (:item1 instance ,(allocate-data 'show-flavor data))
		 (:font 1 "3:*")))
	      nil
	      )
	,@(LOOP for unsatisfied in unsatisfied-methods
		append `(((:font 1 ,(FORMAT nil "3~S*" (FIRST unsatisfied)))
			  (:font 3 "3 for flavor *")
			  (:item1 instance ,(allocate-data 'show-flavor (SECOND unsatisfied)))))
		)
	;1; ------------------------------*
	,@(IF unsatisfied-ivs *blank-line-item*)
	,@(IF unsatisfied-ivs *blank-line-item*)
	,@(IF unsatisfied-ivs
	      `(((:font 1 "3Unsatisfied required instance variables of flavor *")
		 (:item1 instance ,(allocate-data 'show-flavor data))
		 (:font 1 "3:*")))
	      nil
	      )
	,@(LOOP for unsatisfied in unsatisfied-ivs
		append `(((:font 1 ,(FORMAT nil "3~S*" (FIRST unsatisfied)))
			  (:font 3 "3 for flavor *")
			  (:item1 instance ,(allocate-data 'show-flavor (SECOND unsatisfied)))))
		)
	;1; ------------------------------*
	,@(IF shadowed-methods *blank-line-item*)
	,@(IF shadowed-methods *blank-line-item*)
	,@(IF shadowed-methods
	      `(((:font 1 "3Primary methods of component flavors shadowed by flavor *")
		 (:item1 instance ,(allocate-data 'show-flavor data))
		 (:font 1 "3:*")))
	      nil
	      )
	,@(LOOP for shadow in shadowed-methods
		append `(((:item1 instance ,(allocate-data 'show-method (FOURTH (SECOND shadow))))
			  (:font 3 "3 of flavor *")
			  (:item1 instance ,(allocate-data 'show-flavor (THIRD shadow)))
			  (:font 3 "3 shadowed by flavor *")
			  (:item1 instance ,(allocate-data 'show-flavor (FIRST shadow)))))
		)
	)  
      `(:font fonts:hl12bi :string ,(FORMAT nil "3~S's Debug data*" flavor-name)))))

(DEFCOMMAND 4(flavor-inspector :debug-flavor*) ()
  '(:description "3Displays inconsistencies in a given flavor.*"
		 :documentation "3Displays inconsistencies and possibly dangerous aspects of a flavor
   whose name is read from the user.  The following lists each condition searched for and
   a description of why the condition is considered inconsistent or dangerous.
      
    1. Flavor has an instance variable supplied by two or more of its flavor components.
      
       Each component probably makes assumptions about the nature of the instance variable
       and their methods will interfere with each other.
       
    2. Flavor has two or more instance variables having the same name in different packages;
       for instance, TV:FOO and ZWEI:FOO.
      
       This is buggy, especially if both are gettable and settable.  The methods :FOO and
       :SET-FOO will only operate on one of these variables, whichever's responsible flavor
       is highest in the heirarchy of component flavors.  Yet methods of the other flavor
       will be addressing the wrong variable in their sending of :FOO and :SET-FOO messages.
      
    3. Flavor has undefined components.
      
       This is buggy only if you try to instantiate the flavor.  During development this
       may be reasonable.
      
    4. Flavor has unsatisfied required component flavors.
      
       This is buggy only if you try to instantiate the flavor.  During development this
       may be reasonable.
      
    5. Flavor has unsatisfied required methods.
      
       This is buggy only if you try to instantiate the flavor.  During development this
       may be reasonable.
      
    6. Flavor has unsatisfied required instance variables.
      
       This is buggy only if you try to instantiate the flavor.  During development this
       may be reasonable.
      
    7. Flavor defines a basic (non-demonic) method which is defined by one of its flavor
       components.
      
       This is not actually buggy; in fact, many times it is expected that a flavor specialize
       methods defined by their component flavors.  However, it is handy for you to see a
       list of all methods you have shadowed, in case you redefined a method without realizing
       it.  For instance, if your window flavor defines method :SELECT to have the user
       select something from a menu, your window won't be selectable because :SELECT is
       a low-level window method which shouldn't normally be redefined.  Using the Debug-Flavor
       option of the Flavor Inspector, you would quickly see that you have redefined an important
       method.*"  
		 :keys #\Super-d)
  (DECLARE (SPECIAL *flavor-data* frame))
  (SEND ucl:this-application :inspect-thing 'debug-flavor *flavor-data*))