;;; -*- Mode:Common-Lisp; Package:TV; Base:10; Fonts:(CPTFONT HL10B HL12BI HL12B CPTFONTB)1; *Patch-File:T -*-

;1;;                     RESTRICTED RIGHTS LEGEND          *
;1;; Use, duplication, or disclosure by the Government is subject to*
;1;; restrictions as set forth in subdivision (b)(3)(ii) of the Rights in*
;1;; Technical Data and Computer Software clause at 52.227-7013.*
;1;;                   TEXAS INSTRUMENTS INCORPORATED.*
;1;;                            P.O. BOX 149149*
;1;;                         AUSTIN, TEXAS 78714-9149*
;1;;                             MS 2151*
;1;; Copyright (C) 1986,1987, 1988, 1989 Texas Instruments Incorporated. All rights reserved.*

;;;----------------------------------------------------------------------
;;; This software developed by:
;;;	James Rice
;;; at the Stanford University Knowledge Systems Lab in 1986, 1987.
;;;
;;; This work was supported in part by:
;;;	DARPA Grant F30602-85-C-0012
;;;----------------------------------------------------------------------
;;;  Much of this file is derived from code licensed from Texas Instruments
;;;  Inc.  Since we'd like them to adopt these changes, we're claiming
;;;  no rights to them, however, the following restrictions apply to the
;;;  TI code:
;;; Your rights to use and copy Explorer System Software must be obtained
;;; directly by license from Texas Instruments Incorporated.  Unauthorized
;;; use is prohibited.
;;;----------------------------------------------------------------------

;1-------------------------------------------------------------------------------*
;1;; Mouse sensitive printing in Inspector panes...*
;1-------------------------------------------------------------------------------*

;1;; This file contains a modification to the Inspector to allow the user to*
;1;; define the way in which things are inspected just like print methods.*
;1;; This can be done by using a special, which is bound when printing concisely. *
;1;; This is : *printing-mouse-sensitively*  *
;1;;           - true whilst printing concisely  (i.e. will accept item1s)*
;1;; This can be used within print methods or format directives to switch on*
;1;; the sending of item1 messages rather then just printing the object.*
;1-------------------------------------------------------------------------------*

(DEFUN 4print-concisely-as* (something stream print-as depth)
  "2Prints something concisely on stream, whose printed representation is Print-As.*"
  (IGNORE something)
  (Print-Item-Concisely print-as stream depth))

(DEFUN 4princ-concisely-as* (something stream princ-as depth)
  "2Princs something concisely on stream, whose printed representation is Princ-As.*"
  (IGNORE something depth)
  (PRINC princ-as stream))

;1-------------------------------------------------------------------------------*

(DEFUN 4fontify-string* (STRING font)
  "2 Given a normal string and a font it returns a fat string, whose chars are in
 the font Font.*"
  (LET ((LENGTH (LENGTH (THE string string))))
    (LET ((fat-string (MAKE-ARRAY length :type 'art-fat-string)))
      ;1; Don't change this to :element-type unless you are sure that*
      ;1; it will really give you an art-fat-string.*
      (LOOP for i from 0 to (- length 1) do
	    (SETF (AREF fat-string i) (CODE-CHAR (AREF string i) 0 font)))
      fat-string)))

;1------------------------------------------------------------------------------------*

format:
(DEFUN 4string-of-pads* (COUNT char)
  (WITH-OUTPUT-TO-STRING (*standard-output*)
    (format-ctl-repeat-char count char)
    *standard-output*))

format:
(DEFUN 4string-of-justify* (width size &optional (CHAR #\SPACE))
  (WITH-OUTPUT-TO-STRING (*standard-output*)
    (format-ctl-justify width size char)
    *standard-output*))

(DEFUN 4process-args* (STREAM args font)
  "2Given a set of args for the stream, which are an item, and a font, send the
 item to the stream, if provided, in the defined font, if provided.  Returns
 the agrs/font as appropriate.*"
  (IF font
      (IF stream
	  (LET ((old-font (SEND stream :send-if-handles :current-font)))
	    (UNWIND-PROTECT
		(PROGN (SEND stream :send-if-handles :set-current-font font)
		       (IF (SEND stream :operation-handled-p :item1)
			   (LEXPR-SEND stream args)
			   nil))
	      (SEND stream :send-if-handles :set-current-font old-font)
	      (LIST :font font args)))
	  (LIST :font font args))
      (PROGN (IF (SEND stream :operation-handled-p :item1)
		 (LEXPR-SEND stream args)
		 nil)
	     args)))

(DEFMETHOD 4(mouse-sensitive-text-scroll-window-without-click :compound*)
	   (some-items)
  (LOOP for item in some-items do
	(IF (CONSP item)
	    (LEXPR-SEND self item)
	    (FORMAT self "3~A*" item))))


(DEFUN 4process-params* (unencapsulated arg params &optional prin1p)
  (LET ((edge (CAR params))
	(period (CADR params))
	(MIN (CADDR params))
	(padchar (CADDDR params))
	(result nil))
    (COND
      ((NULL padchar) (SETQ padchar #\SPACE))
      ((NOT (NUMBERP padchar)) (SETQ padchar (CHARACTER padchar))))
    (IF format::atsign-flag
	nil
	(PUSH arg result))
    (COND
      ((NOT (NULL edge))
       (LET ((width
	       (FUNCALL
		 (COND
		   (prin1p (FUNCTION flatsize))
		   ((STRINGP unencapsulated) (FUNCTION length))
		   (t (FUNCTION flatc)))
		 unencapsulated)))
	 (COND
	   ((NOT (NULL min))
	    (PUSH (format::string-of-pads min padchar) result)
	    (SETQ width (+ width min))))
	 (COND
	   (period
	    (PUSH (format::string-of-pads
		    (* (CEILING (- edge width) period) period)
		    padchar) result))
	   (t (PUSH (format::string-of-justify edge width padchar) result))))))
    (IF (NOT format::atsign-flag)
	nil
	(PUSH arg result))
    (LIST :compound (REVERSE result))))

(DEFUN 4pp-objify-atom-different-name* (object location name)
  "2Makes a PP-Obj for an atom with a different printed representation than the
 original object.*"
  (DECLARE (SPECIAL sys::pprint-string))
  (IGNORE object)
  (LET ((start (LENGTH sys::pprint-string)))
    (print-object name 0 *standard-output* '(:string-out))
    (LET ((result
	    (sys::make-pp-obj :length   (- (LENGTH sys::pprint-string) start)
			     :object   start
			     :location location)))
      result)))

(DEFUN 4actually-itemize-for-list*
       (something stream print-as princ-as font)
  (LET ((*print-escape* print-as)
	(*standard-output* stream)
	(*fontify-this-region* (IF font font *fontify-this-region*)))
    (DECLARE (SPECIAL *print-escape*))
    (IF (OR (EQ something print-as)
	    (EQ something princ-as))
	(LET ((result
		(sys::pp-objify something (CONS something something))))
	  ;1; TAC 08-09-89 - not using *saved-pp-objects* *
	  ;1; (push result *saved-pp-objects*) *
	  result)
	(LET ((result
		(pp-objify-atom-different-name
		  something (CONS something something)
		  (OR print-as princ-as))))
	  ;1; TAC 08-09-89 - not using *saved-pp-objects* *
	  ;1; (push result *saved-pp-objects*)*
	  result))))


(DEFUN 4itemize-for-list* (something stream print-as princ-as font params &optional prin1p)
  "2Itemises something to stream in font either princed or printed, whilst
 grinding out a list as the top level object.*"
  (LET ((edge (CAR params))
	(period (CADR params))
	(MIN (CADDR params))
	(padchar (CADDDR params)))
    (COND
      ((NULL padchar) (SETQ padchar #\SPACE))
      ((NOT (NUMBERP padchar)) (SETQ padchar (CHARACTER padchar))))
    (IF format::atsign-flag
	nil
	(actually-itemize-for-list something stream print-as princ-as font))
    (COND
      ((NOT (NULL edge))
       (LET ((width
	       (FUNCALL
		 (COND
		   (prin1p (FUNCTION flatsize))
		   ((STRINGP something) (FUNCTION length))
		   (t (FUNCTION flatc)))
		 something)))
	 (COND
	   ((NOT (NULL min))
	    (format::format-ctl-repeat-char min padchar)
	    (SETQ width (+ width min))))
	 (COND
	   (period
	    (format::format-ctl-repeat-char
	      (* (CEILING (- edge width) period) period)
	      padchar))
	   (t (format::format-ctl-justify edge width padchar))))))
    (IF (NOT format::atsign-flag)
	nil
	(actually-itemize-for-list something stream print-as princ-as font))))

(DEFUN 4itemize-element* (something stream depth &Key print-as princ-as font params)
  "2Given something to print it displays it as a mouse sensitive item, which looks
 like Print-as or Princ-as in stream. Depth is the depth of mouse sensitive
 items displayed.  If neither Princ-as nor Print-as are supplied then it looks
 like Something.  If stream is nil it returns the item args that would be sent
 to a stream.*"
  (DECLARE (SPECIAL sys::pprint-string))
  (IF (AND (BOUNDP 'grind-into-list-string)
	   grind-into-list-string
	   (BOUNDP 'sys::pprint-string)
	   sys::pprint-string)
      (itemize-for-list something stream print-as princ-as font params)
      (LET ((args (process-params
		    something
		    (IF print-as
			(LIST :Item1 something
			      :Value #'print-concisely-as
			      print-as (+ 1 depth))
			(LIST :Item1 something
			      :Value #'princ-concisely-as
			      princ-as (+ 1 depth)))
		    params (NOT princ-as))))
	(process-args stream args font))))

;1-------------------------------------------------------------------------------*
;1 TAC 08-15-89 -  var put into INSPECT.LISP*

;1(DEFVAR *printing-mouse-sensitively* nil*
;1  "True when the things that are being printed should be turned into mouse*
;1 sensitive items if you know how to.")*

;1 TAC 08-15-89 -  advice put into function in GENERAL-INSPECTOR.LISP*
;1(LET ((compiler:compile-encapsulations-flag t))*
;1  (ADVISE Print-Item-Concisely :Around :Mouse-Sensitivity-Addition nil*
;1    ;;; Bind *printing-mouse-sensitively* because this is a good place to*
;1    ;;; have mouse sensitive objects.*
;1    (LET ((*printing-mouse-sensitively* t))*
;1      (DECLARE (SPECIAL *printing-mouse-sensitively*))*
;1      :Do-It)))*

;1-------------------------------------------------------------------------------*
;1 TAC 08-15-89 -  advice put into INSPECT.LISP where grind-top-level is called from*
;1                       grind-into-list.*

;1(LET ((compiler:compile-encapsulations-flag t))*
;1  (ADVISE Grind-Top-Level :Around :Mouse-Sensitivity-Addition nil*
;1    ;;; Bind *printing-mouse-sensitively* because this is a good place to*
;1    ;;; have mouse sensitive objects as long as you are grinding into an*
;1    ;;; inspect pane.*
;1    (IF (AND (SEVENTH arglist)*
;	1     (OR (EQUAL (SEVENTH arglist)  'grind-into-list-make-item)*
;		1 (EQUAL (SEVENTH arglist) #'grind-into-list-make-item))*
;	1     (NOT grind-into-list-string))*
;	1(LET ((*printing-mouse-sensitively* t))*
;	1  (DECLARE (SPECIAL *printing-mouse-sensitively*))*
;	1  :Do-It)*
;	1:Do-It)))*

;1-------------------------------------------------------------------------------*

(DEFVAR 4*inspect-details** (BOUNDP '*printing-mouse-sensitively*)
"2A global which is true if the user wants the contents of structures
 to be mouse sensitive in the inspector.*")

;1; Define some format directives for the Mouse system.*

;1; Formats something using two args; the first is the thing to format*
;1; the second it slashify.*

(format::defformat format:: (:Multi-Arg) (args params)
  "3Formats something, taking two arguments.  The first is the thing to format and the second 
 is the slashification. Thus (format stream 'A structure :- ~' a-struct slashify) will 
 print out a-struct slashifiedly if slashify is non-nil, otherwise unslashifiedly.
 If the thing being printed is being printed in an inspector pane then the thing to be printed 
 is printed out mouse sensitively as long as the *inspect-details* flag is true.*"
  (LET ((thing-to-print (FIRST args))
	(slashify (SECOND args)))
    (IF (AND *inspect-details*
	     (BOUNDP '*printing-mouse-sensitively*)
	     *printing-mouse-sensitively*)
	(itemize-element thing-to-print *standard-output* 0
			 (IF slashify :Print-as :Princ-as)
			 thing-to-print :params params)
	(format::format-ctl-ascii (FIRST args) params (SECOND args)))
    (REST (REST args))))

(DEFPROP 4format::* 2 format::number-of-arguments)

;1; Format something using one arg, which is a list.  The first is the thing*
;1; to print and the second is slashify.  If there is a third then this is used*
;1; as the thing to print, with the first being the internal representation*
;1; for the inspector.*

(format::defformat format:: (:One-Arg) (arg params)
  "3Formats something, taking one argument, which is a two/three/four list.
 This list is as follows :-
   The first is the thing to format
   The second is the slashification
   The third, if provided is the printed representation of the first 
       (i.e the thing to print).
   The font in which to print it.
 Thus (format stream 'A structure :- ~' (list a-struct nil '#<struct>') will
 print out a-struct as the string '#<struct>', which will be princed.
 If the thing being printed is being printed in an inspector pane then the
 thing to be printed is printed out mouse sensitively as long as the
 *inspect-details* flag is true.*"
  (LET ((thing-to-print (IF (CONSP arg) (FIRST arg) arg))
	(slashify (IF (CONSP arg) (SECOND arg) t))
	(display-as (IF (CONSP arg)
			(IF (< (LENGTH arg) 3)
			    (FIRST arg)
			    (THIRD arg))))
	(font (IF (CONSP arg) (FOURTH arg) nil)))
    (IF (AND *inspect-details*
	     (BOUNDP '*printing-mouse-sensitively*)
	     *printing-mouse-sensitively*
	     (> (LENGTH (FORMAT nil "3~A*" display-as)) 0))
	(itemize-element thing-to-print *standard-output* 0
			 (IF slashify :Print-as :Princ-as)
			 display-as :font font :params params)
	(format::format-ctl-ascii display-as params slashify))))

(format::defformat format:: (:One-Arg) (arg params)
  "3Formats something, taking one argument, which is a two/three list.  This list
 is as follows :-
   The first is the thing to format
   The second is the slashification
   The third, if provided is the printed representation of the first 
       (i.e the thing to print).
 Thus (format stream 'A structure :- ~' (list a-struct nil '#<struct>') will
 print out a-struct as the string '#<struct>', which will be princed.
 This format directive does not provide mouse sensitivity.  The reason for it
 is that it is compatible with ~, which does.  This means that you can make
 alternate elements in lists, for instance, mouse sensitive, whilst still
 formatting the list as for ~.*"
  (LET ((slashify (IF (CONSP arg) (SECOND arg) t))
	(display-as (IF (CONSP arg)
			(IF (< (LENGTH arg) 3)
			    (FIRST arg)
			    (THIRD arg)))))
    (format::format-ctl-ascii display-as params slashify)))