/* Mode: C; Tab-Width: 4.; */
/*                                                                       */
/*                                                                       */
/*                      RESTRICTED RIGHTS LEGEND                         */
/*                                                                       */
/* Use, duplication, or disclosure by the Government is subject to       */
/* restrictions as set forth in subdivision (c)(1)(ii) of the Rights in  */
/* Technical Data and Computer Software clause at 252.227-7013.          */
/*                                                                       */
/*                    TEXAS INSTRUMENTS INCORPORATED.                    */
/*                            P.O. BOX 149149                            */
/*                         AUSTIN, TEXAS 78714-9149                      */
/*                              MS 2151                                  */
/*                                                                       */
/*  Copyright (C) 1987,1988,1989,1990 Texas Instruments Incorporated.    */
/*  All rights reserved.                                                 */
/*                                                                       */
/*
	OSUtils.h -- Operating System Utilities

	C Interface to the Macintosh Libraries
	Copyright Apple Computer,Inc. 1985-1987
	All rights reserved.
*/

#ifndef __OSUTILS__
#define __OSUTILS__
#ifndef __TYPES__
#include <Types.h>
#endif

#define useFree 0
#define useATalk 1
#define useAsync 2
#define macXLMachine 0
#define macMachine 1

	/* Environs Equates */

#define envMac			-1
#define envXL			-2
#define envMachUnknown	0
#define env512KE		1
#define envMacPlus		2
#define envSE			3
#define envMacII		4

#define envCPUUnknown	0			/* CPU types */
#define env68000		1
#define env68010		2
#define env68020		3

#define envUnknownKbd	0			/* Keyboard types */
#define envMacKbd		1
#define envMacAndPad	2
#define envMacPlusKbd	3
#define envAExtendKbd	4
#define envStandADBKbd	5

		/* Environs Errors */

#define envNotPresent	-5500		/* returned by glue. Official stuff now */
#define envBadSel		-5501		/* Selector non-positive */
#define envSelTooBig	-5502		/* Selector bigger than call can handle */

#define false32b			0					/* 24 bit addressing */
#define true32b			1					/* 32 bit addressing */

typedef struct SysParmType {
	char valid;
	char aTalkA;
	char aTalkB;
	char config;
	short portA;
	short portB;
	long alarm;
	short font;
	short kbdPrint;
	short volClik;
	short misc;
} SysParmType,*SysPPtr;
typedef struct QElem {
	struct QElem *qLink;
	short qType;
	short qData[1];
} QElem,*QElemPtr;
typedef struct QHdr {
	short qFlags;
	QElemPtr qHead;
	QElemPtr qTail;
} QHdr,*QHdrPtr;
enum {
	dummyType,
	vType,
	ioQType,
	drvQType,
	evType,
	fsQType
};
typedef unsigned char QTypes;
typedef struct DateTimeRec {
	short year;
	short month;
	short day;
	short hour;
	short minute;
	short second;
	short dayOfWeek;
} DateTimeRec;
enum {
	OSTrap,
	ToolTrap
};
typedef unsigned char TrapType;

typedef struct SysEnvRec {
	short	environsVersion;
	short	machineType;
	short	systemVersion;
	short	processor;
	Boolean	hasFPU;
	Boolean	hasColorQD;
	short	keyBoardType;
	short	atDrvrVersNum;
	short	sysVRefNum;
} SysEnvRec;


SysPPtr GetSysPPtr();

pascal void SysBeep(duration)
	short duration;
	extern 0xA9C8;

pascal Boolean EQUALSTRING(str1, str2, caseSens, diacSens)
	Str255 *str1, *str2;
	Boolean caseSens, diacSens;
	extern;

pascal short RELSTRING(str1, str2, caseSens, diacSens)
	Str255 *str1, *str2;
	Boolean caseSens, diacSens;
	extern;

pascal void UPRSTRING(theString, diacSens)
	Str255 *theString;
	Boolean diacSens;
	extern;

pascal long KeyTrans(transData, keycode, state)
	Ptr transData;
	short keycode;
	long *state;
	extern 0xA9C3;

pascal OSErr DTInstall(dtTaskPtr)
	struct QElem *dtTaskPtr;
	extern;		

pascal char GetMMUMode()
	extern;
	
pascal void SwapMMUMode(mode)
	char *mode;
	extern;

pascal OSErr SysEnvirons(versionRequested, theWorld)
	short versionRequested;
	SysEnvRec *theWorld;
	extern;

pascal OSErr GetDateTime(secs)
   long *secs;
   extern;
pascal OSErr SetDateTime(secs)
   long secs;
   extern;


#endif
