;;;
;;; sib-timer.lisp
;;;
;;; SIB board interval timers
;;;

(in-package :nevermore)

;; This looks like the same 8254 PIT that the PC uses,
;; clocked at once every 7 microcycles (1 MHz).

(declaim (fixnum *sib-timer-7cycle-count*))
(defvar *sib-timer-7cycle-count* 0)

(defun sib-timer-microcycle-handler ()
  (if (zerop *sib-timer-7cycle-count*)
      (progn
	(setf *sib-timer-7cycle-count* 6))
      (decf *sib-timer-7cycle-count*)))

(add-microcycle-hook #'sib-timer-microcycle-handler)

(defun sib-timer-read (address)
  (declare (ignorable address))
  0)

(defun sib-timer-write (address data)
  (declare (ignorable address data))
  )

;;; EOF
