;;; -*- cold-load:t; Mode:Common-Lisp; Package:SYSTEM-INTERNALS; Base:10.; Fonts:(CPTFONT CPTFONTB) -*-

;;;                           RESTRICTED RIGHTS LEGEND

;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.
;;;
;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151
;;;
;;; Copyright (C) 1986-1989 Texas Instruments Incorporated.  All rights reserved.

(DEFMACRO LET-CLOSED (VARS &BODY BODY)
  "Binds VARS like LET, then returns a closure of the value of BODY over those variables."
  (LET ((VARNAMES (MAPCAR (FUNCTION (LAMBDA (V) (COND ((ATOM V) V) (T (CAR V))))) VARS)))
    `(LET ,VARS
       (DECLARE (SPECIAL . ,VARNAMES))
       (CLOSURE ',VARNAMES (PROGN . ,BODY)))))

(DEFMACRO CONVERT-CLOSURE-TO-LIST (closure)
  `(%MAKE-POINTER DTP-LIST ,closure))
