;;;-*- Mode:Common-Lisp; Package:SYSTEM-INTERNALS; Base:8 -*-

;;;                           RESTRICTED RIGHTS LEGEND

;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.
;;;
;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151
;;;
;;; Copyright (C) 1987-1989 Texas Instruments Incorporated.  All rights reserved.
 
;;  5/28/87 DNG - Added file HASHFL for SPR 5505.

;;  Must still develop a straightforward transformation for compiling DEFOP - JK
(defsystem cold-build-parameters
  (:name "cold-build-parameters")
  (:short-name "cbp")
  (:pathname-default "SYS:UCODE;")
  (:module system-definition-functions ("DEFSYSMAC"))
;  (:module control ("GEN-CONTROL"))
  (:module genasys-parameters-files-list ("QDEFS"
					  "LROY-QCOM"
					  "LROY-QDEV"
					  ;; "EXP2-QDEV"            ;ab 1/13/88
					  "EXP2-COMMON-TEMPLATES"   ;ab 1/13/88
					  "EXP2-UNIQUE-TEMPLATES"  ;ab 1/13/88
					  "MX-UNIQUE-TEMPLATES"     ;ab 1/13/88
					  "DEF-ELROY"
					  "DEFOP"))
  (:compile system-definition-functions)
;  (:auxiliary control)
  (:auxiliary genasys-parameters-files-list))

(DEFSYSTEM KERNEL-defs  
  (:NAME "KERNEL-defs")	
  (:PATHNAME-DEFAULT "SYS:KERNEL;")
  (:MODULE defunmac
	   (
  	    "FUNCTION-MACROS"       ;; defun
	    "DEFMACRO"              ;; defmacro
	     ))
  (:MODULE struct  
	   (
	    "TYPES"
	    "STRUCTURE"
	    "SETF"
	    ))
  (:MODULE rddefs
	   (
	    "READ-DEFINITIONS"      ;; printing-random-object, readtable
	    ))
  (:MODULE defs 
	   (
	    "VARIABLE-DEFINITIONS" ;; readtable,print-base,package,etc
	    "LET-DO-PROG-MACROS"   ;; dolist, dotimes,..
	    "ARRAYS-MACROS"        ;; elt,cli:aref
	    "PACKAGES-MACROS"      ;; do-symbols and friends
	    "CONDITIONALS-MACROS"  ;; when , unless ,etc
	    "CONDITION-MACROS"     ;; catch-error-restart, condition-bind, etc
	    "LOOP"                 ;; the loop macro
	    "LISTS-MACROS"         ;; first, rest, consp
	    "DEFSELECT"            ;; the defselect macro
	    "LISP-MODE"            ;; zetalisp-common macros
	    "READER-MACROS"        ;; backquote stuff 
	    "STREAMS-MACROS"           ;; with-open-file,etc
	    "STORAGE-MACROS"
	    "RESOURCE"             ;; defresource
	    "CHARACTERS-MACROS"    ;; char-upcase, etc
	    "RUNTIME-FLAVOR"
	    "CLOSURES-MACROS"
	    "SETQ-MACROS"          ;; psetq
	    "PROCESSES-MACROS"     ;; without-interrupts,with-lock
	    "PROCESS-DEFINITIONS"
	    "SEND"
	    "SYMBOLS-MACROS"
	    "PREDICATES"
	    "DEBUG-INFO"           ;; get accessor macros
	    ))

  (:MODULE aux-defs (
		     "SGDEFS"
		     "READTABLE-FUNCTIONS"
		     "RUNTIME-FLAVOR"
		     "SYS:COMPILER;MINDEFS"
		     "ENVIRONMENT-INQUIRIES"   ;ab 1/13/88
		     "MX-TV-SUPPORT"           ;ab 1/13/88
		 ))

  (:module conditional-load		       ;ab 1/13/88
	   (
	    "LOAD-PARAMETERS-ALWAYS"
	    "CONDITIONAL-LOAD"
	    ))

  (:module addin-templates ("SYS:MICRONET;ADDIN-QCOM"))

  (:module micronet-defs			;ab 1/13/88  must always be in the COMPILE-ENVIRONMENT
	   (
	    "SYS:MICRONET;ACB-DEFS"
	    "SYS:MICRONET;CHANNEL-DEFS"
	    ))

  (:readfile addin-templates)
  (:fasload conditional-load)			;ab 1/13/88
  (:fasload micronet-defs (:readfile addin-templates))                      ;ab 1/13/88
  (:fasload defunmac)
  (:fasload struct (:fasload defunmac))
  (:fasLOAD rddefs (:fasload struct defunmac))
  (:fasLOAD DEFS (:fasload rddefs struct defunmac))
  (:fasLOAD aux-DEFS (:FASLOAD  DEFS)))

;;; This is currently a component-system of KERNEL-AUX.
(defsystem zetalisp-support
  (:name "zetalisp-support")
  (:pathname-default "SYS:KERNEL;")
  (:module main ("ZETALISP-SUPPORT"))
  (:compile-load main))

;;; Note: this definition must precede the KERNEL defsystem since
;;; the module non-minimal-kernel-defs is referenced later.
(defsystem kernel-aux 
  (:name "kernel-aux")
  (:pathname-default "SYS:KERNEL;")
  (:module  non-minimal-kernel-defs		;this module is referenced by the 
	    (					;KERNEL defsystem
	     "loop"
	     "defselect"
	     ))

  (:module functions 
	   (
	    "FILLARRAY"
	    "WHO-CALLS"
	    "APROPOS"
	    "ENCAPSULATIONS"
	    "TRACE"
	    "ADVISE"
	    "SELECT-MATCH"
	    "METER"
	    "ALTERNATE-MACRO-DEFINITIONS"
	    "PLANE"
	    "MATRIX"
	    "INFIX"
	    "TIME-PARSE"
;;	    "ENVIRONMENT-INQUIRIES"              ;ab 1/13/88.  Moved to kernel-defs
	    "HASHFL" ; hash table flavors
	    ))
  (:module support-files ("SYS:SUGGESTIONS;SUGGESTIONS-MACROS-AND-FUNCTIONS"))
  (:COMPONENT-SYSTEMS zetalisp-support)
  (:COMPILE-LOAD non-minimal-kernel-defs)
;  (:COMPILE-LOAD defs (:fasload  non-minimal-kernel-defs))     ;no longer needed
  (:COMPILE-LOAD functions (:fasload non-minimal-kernel-defs)) ;removed DEFS as a dependency
  (:COMPILE support-files (:fasload non-minimal-kernel-defs))) 

;;; Note: The KERNEL defsystem references a module defined in KERNEL-AUX
(DEFSYSTEM KERNEL  
  (:NAME "KERNEL")	
  (:PATHNAME-DEFAULT "SYS:kernel;")
  (:warnings-pathname-default "SYS: CWARNS; kernel.lisp")  ;; 06.24.87 las
  (:module system-definition-functions ("SYS:UCODE;DEFSYSMAC"))
;  (:module control ("GEN-CONTROL"))
  (:module genasys-parameters-files-list ("SYS:UCODE;QDEFS"
					  "SYS:UCODE;LROY-QCOM"
					  "SYS:UCODE;LROY-QDEV"
					  ;; "EXP2-QDEV"                      ;ab 1/13/88
					  "SYS:UCODE;EXP2-COMMON-TEMPLATES"   ;ab 1/13/88, RJF 1/31/89
					  "SYS:UCODE;EXP2-UNIQUE-TEMPLATES"  ;ab 1/13/88, RJF 1/31/89
					  "SYS:UCODE;MX-UNIQUE-TEMPLATES"     ;ab 1/13/88, RJF 1/31/89
					  "SYS:UCODE;DEF-ELROY"
					  "SYS:UCODE;DEFOP"))
  (:MODULE defunmac
	   (
  	    "FUNCTION-MACROS"       ;; defun
	    "DEFMACRO"              ;; defmacro
	     ))
  (:MODULE struct  
	   (
	    "TYPES"
	    "STRUCTURE"
	    "SETF"
	    ))
  (:MODULE rddefs
	   (
	    "READ-DEFINITIONS"      ;; printing-random-object, readtable
	    ))
  (:MODULE defs 
	   (
	    "VARIABLE-DEFINITIONS" ;; readtable,print-base,package,etc
	    "LET-DO-PROG-MACROS"   ;; dolist, dotimes,..
	    "ARRAYS-MACROS"        ;; elt,cli:aref
	    "PACKAGES-MACROS"      ;; do-symbols and friends
	    "CONDITIONALS-MACROS"  ;; when , unless ,etc
	    "CONDITION-MACROS"     ;; catch-error-restart, condition-bind, etc
	    "LISTS-MACROS"         ;; first, rest, consp
	    "LISP-MODE"            ;; zetalisp-common macros
	    "READER-MACROS"        ;; backquote stuff 
	    "STREAMS-MACROS"           ;; with-open-file,etc
	    "STORAGE-MACROS"
	    "RESOURCE"             ;; defresource
	    "CHARACTERS-MACROS"     ;; char-upcase, etc
	    "RUNTIME-FLAVOR"
	    "CLOSURES-MACROS"
	    "SETQ-MACROS"          ;; psetq
	    "PROCESSES-MACROS"     ;; without-interrupts,with-lock
	    "PROCESS-DEFINITIONS"
	    "SEND"
	    "SYMBOLS-MACROS"
	    "PREDICATES"
	    "DEBUG-INFO"           ;; get accessor macros
	    ))

  (:module conditional-load		       ;ab 1/13/88
	   (
	    "CONDITIONAL-LOAD"
	    ))

  (:module load-parameters		       ;ab 1/13/88
	   (
	    "LOAD-PARAMETERS-MX"
	    "LOAD-PARAMETERS-EXP"
	    "LOAD-PARAMETERS-ALWAYS"
	    ))

  (:module default-load-parameters
	   (
	    "LOAD-PARAMETERS-ALWAYS"
	    ))

  (:module addin-templates ("SYS:MICRONET;ADDIN-QCOM"))

  (:module micronet-defs			;ab 1/13/88  must always be in the COMPILE-ENVIRONMENT
	   (
	    "SYS:MICRONET;ACB-DEFS"
	    "SYS:MICRONET;CHANNEL-DEFS"
	    ))

  (:MODULE aux-defs (
		     "SGDEFS"
		     "READTABLE-FUNCTIONS"
		     "RUNTIME-FLAVOR"
		     "SYS:COMPILER;MINDEFS"
		     "ENVIRONMENT-INQUIRIES"	;ab 1/13/88
		     "MX-TV-SUPPORT"		;ab 1/13/88
		 ))
  (:MODULE Main	
	   (
	    "INITIALIZATION"
	    "MACROS"
	    "FUNCALL"
	    "NUMBERS"
	    "SYMBOLS"
	    "FUNCTIONS"
	    "SUBSTS"
	    "ARRAYS"
	    "SEQUENCES1"
	    "SEQUENCES2"
	    "SEQUENCES-ZL"
	    "MAP"
	    "LISTS"
	    "MAPCAR"
	    "STREAMS"
	    "READER"
	    "AUX-READ"
	    "PRINT"
	    "WINDOW-INITS"
	    "MX-KEYBOARD-SUPPORT"		;ab 1/24
            "EXP2-PROCESSOR"
	    "SGFCTN"
	    "LISP-REINITIALIZE"
	    "COLD-BREAK"
	    "STORAGE-INTERNALS"
	    "SXHASH"
	    "HASH"
	    "STRINGS"
	    "PACKAGES"
	    "INITIAL-PACKAGES"
	    "INITIAL-PACKAGES-MX"		;ab 2/29
	    "PACKAGE-INITIALIZE"
	    "INITIAL-LISP-SYMBOLS"
	    "INITIAL-TICL-SYMBOLS"
	    "INITIAL-ZLC-SYMBOLS"
	    "EXTERNAL-SYSTEM-SYMBOLS"
	    "CHARACTERS"
	    "CLOSURES"
	    "SORT"
	    "KEYBOARD-CHARS"
	    "COLD-LOAD-STREAM"
	    "PROCESSES"
	    "TIMERS"
	    "TIME"
	    "MICRO-TIME"
	    "FLAVOR"
	    "PPRINT"
	    "QUERY"
	    "FQUERY"
	    "FORMAT"
	    "LOGIN"
	    "DWIMIFY"
	    "COLD-LOAD-UNCAPS-RECORD"))
  (:readfile addin-templates)
  (:COMPONENT-SYSTEMS evaluator kernel-aux)
  (:compile system-definition-functions)
;  (:auxiliary control)
  (:auxiliary genasys-parameters-files-list)
  (:compile-load defunmac)
  (:compile-load struct (:fasload defunmac))
  (:COMPILE-LOAD rddefs (:fasload struct defunmac))
  (:compile-load default-load-parameters)
  (:compile-load conditional-load (:fasload default-load-parameters))		;ab 1/13/88
  (:compile load-parameters)			;ab 1/13/88
  (:compile-load micronet-defs (:readfile addin-templates))			;ab 1/13/88
  (:COMPILE-LOAD (kernel-aux non-minimal-kernel-defs))
  (:COMPILE-LOAD DEFS ((:readfile addin-templates)
		       (:fasload rddefs struct defunmac conditional-load micronet-defs
				(kernel-aux non-minimal-kernel-defs))))	;ab 1/13/88
  (:COMPILE-LOAD aux-DEFS (:FASLOAD  DEFS))
  (:COMPILE-LOAD MAIN (:FASLOAD rddefs DEFS aux-DEFS))
  (:DO-COMPONENTS (:FASLOAD rddefs DEFS)))

(defsystem evaluator	
  (:name "evaluator")	
  (:short-name "eval")
  (:pathname-default "SYS:KERNEL;")
  (:module macros "EVALUATOR-MACROS")
  (:module functions 
	   ("EVALUATOR" 
	    "APPLY-LAMBDA"
	    "LET-DO-PROG"
	    "EVALUATOR-MISCELLANEOUS" 
	    "FLET" 
	    "MULTIPLE-VALUES"
	    "CONDITIONALS"
	    "CATCH"
	    "SETQ"
	    ))
  (:compile-load macros)
  (:compile-load functions (:fasload macros)))


