1;;; -*- *cold-load:t; 1Mode:Common-Lisp; Package:SYSTEM-INTERNALS; Base:10.; Fonts:(CPTFONT CPTFONTB) -*-

;;;                           RESTRICTED RIGHTS LEGEND

;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.

;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151

;;; Copyright (C) 1986-1989 Texas Instruments Incorporated. All rights reserved.*

(DEFSUBST CONSP (object)
 1 "T if OBJECT is a cons (a non-null list)."*
  (NOT (ATOM object)))

;;;(DEFSUBST CLI:LISTP (object)  ;; now microcoded
;;;1  "T if OBJECT is a list (either a cons or NIL)."*
;;;  (COMMON-LISP-LISTP object))

(DEFSUBST NLISTP (object)
1  "T if OBJECT is not a list (neither a cons nor NIL)."*
  (NOT (COMMON-LISP-LISTP OBJECT)))

(DEFSUBST FIRST (LIST)
1  "Return the first element of LIST."*
  (CAR LIST))

(DEFSUBST SECOND (LIST)
1  "Return the second element of LIST."*
  (CADR LIST))

(DEFSUBST THIRD (LIST)
1  "Return the third element of LIST."*
  (CADDR LIST))

(DEFSUBST FOURTH (LIST)
1  "Return the fourth element of LIST."*
  (CADDDR LIST))

(DEFSUBST FIFTH (LIST)
1  "Return the fifth element of LIST."*
  (CAR (CDDDDR LIST)))

(DEFSUBST SIXTH (LIST)
1  "Return the sixth element of LIST."*
  (CADR (CDDDDR LIST)))

(DEFSUBST SEVENTH (LIST)
1  "Return the seventh element of LIST."*
  (CADDR (CDDDDR LIST)))

(DEFSUBST EIGHTH (LIST)
1  "Return the eighth element of LIST."*
  (CADDDR (CDDDDR LIST)))

(DEFSUBST NINTH (LIST)
1  "Return the ninth element of LIST."*
  (CADDR (CDDR (CDDDDR LIST))))

(DEFSUBST TENTH (LIST)
1  "Return the tenth element of LIST."*
  (CADDR (CDDDR (CDDDDR LIST))))

(DEFSUBST REST (LIST)
1  "Return LIST sans its first element."*
  (CDR LIST))

;1; for lispm environments, the following :*

(DEFSUBST CADR-SAFE (object)
1  "Like CA2D*R, but treats all non-lists as NIL rather than getting an error."*
  (CAR-SAFE (CDR-SAFE object)))

(DEFSUBST CDDR-SAFE (object)
1  "Like C2DD*R, but treats all non-lists as NIL rather than getting an error."*
  (CDR-SAFE (CDR-SAFE object)))

(DEFSUBST CAAR-SAFE (object)
1  "Like CAAR, but treats all non-lists as NIL rather than getting an error."*
  (CAR-SAFE (CAR-SAFE object)))

(DEFSUBST CDAR-SAFE (object)
1  "Like CDAR, but treats all non-lists as NIL rather than getting an error."*
  (CDR-SAFE (CAR-SAFE object)))

(DEFSUBST ZLC:REST1 (LIST)
1  "Return LIST sans its first element."*
  (CDR LIST))

(DEFSUBST ZLC:REST2 (LIST)
1  "Return LIST sans its first two elements."*
  (CDDR LIST))

(DEFSUBST ZLC:REST3 (LIST)
1  "Return LIST sans its first three elements."*
  (CDDDR LIST))

(DEFSUBST ZLC:REST4 (LIST)
1  "Return LIST sans its first four elements."*
  (CDDDDR LIST))

(Defsubst COPY-LIST-INTERNAL (list)
  (LET* ((new-list nil)
	 (ptr (LOCF new-list)))
    (DOLIST (x list new-list)
      (RPLACD ptr (SETQ ptr (CONS x nil))))))
