1;;; -*- *cold-load:t; 1Mode:Common-Lisp; Package:SYSTEM-INTERNALS; Fonts:(CPTFONT CPTFONTB); Base:10 -*-

;;;                           RESTRICTED RIGHTS LEGEND

;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.

;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151

;;; Copyright (C) 1986-1989 Texas Instruments Incorporated. All rights reserved.*

;1;; 4/13/89*	1jlm*	1CHanged ZLC:ENTITYP to get rid of compiler warning*
;;; 4/19/89	DNG	Fixed 1ZLC:ENTITYP* the right way.

(Defsubst bigp (x)
  "Return T if X is a bignum."
  (and (integerp x) (not (fixnump x)))) 

;; this is now a misc-op
;;;(defsubst ratiop (object)
;;;  "T if OBJECT is a ratio -- a rational number which is not an integer."
;;;  (and (= (%data-type object) dtp-extended-number)
;;;     (= (%p-ldb %%header-type-field object) %header-type-rational))) 


(Defsubst flonump (object)
  "T if OBJECT is a full precision flonum."
  (and (floatp object) (not (small-floatp object)))) 


(Defsubst zlc:subrp (object)
  "T if OBJECT is a compiled or built-in function."
  (or (eq (%data-type object) dtp-u-entry) (eq (%data-type object) dtp-function))) 

;;  4/19/89 DNG - Added doc string.
(Defsubst INSTANCEP (object)
  "T if OBJECT is an instance of a flavor or standard-class."
  (declare (:expr-sxhash 6400274.)) ; 5/3/89 DNG
  (= (%data-type object) dtp-instance)) 

;;;03/16/89 clm - added for CLOS.
(DEFSUBST ticlos:clos-instance-p (i)
  (AND (INSTANCEP i) (ODDP (sys:%p-cdr-code i))))

(Defsubst COMPILED-FUNCTION-P (object)
  "T if OBJECT is a compiled function (a FEF)."
  (= (%data-type object) dtp-function)) 


(Defsubst MICROCODE-FUNCTION-P (object)
  "T if OBJECT is a microcoded function."
  (= (%data-type object) dtp-u-entry)) 

(Defsubst CLOSUREP (x)
  "T if X is a closure."
  (or (= (%data-type x) dtp-closure) (= (%data-type x) dtp-lexical-closure)))

(eval-when (compile) (assert (not (compiler:specialp 'object)))) ; don't want this to be a special variable.

;;  4/19/89 DNG - Fix to not bind a special variable.
(Defsubst ZLC:ENTITYP (object)
  "Entities are no longer supported.  Use flavors or CLOS."
  (declare (ignore object))
  ;; Entities don't exist, so OBJECT can't possibly be one.
  nil)


(defsubst stack-list-p (list)
  (= (%data-type list) dtp-stack-list))

(Defsubst LOCATIVEP (x)
  "T if X is a locative."
    (= (%data-type x) DTP-Locative))
