/*
 * exploiter.h
 *
 * basic typedefs and #defines
 */

#ifndef EXPLOITER_H
#define EXPLOITER_H

#include <common/types.h>

/*
 * Q layout
 */

typedef u32 lisp_q;

#define Q_BITS_CDRCODE 0xc0000000
#define Q_BITS_DTP     0x3e000000
#define Q_BITS_ADDRESS 0x01ffffff

#define CDR_NORMAL 0x00000000
#define CDR_ERROR  0x40000000
#define CDR_NIL    0x80000000
#define CDR_NEXT   0xc0000000

#define     DTP(q)     ((q) &  Q_BITS_DTP)
#define     CDRCODE(q) ((q) &  Q_BITS_CDRCODE)
#define NOT_CDRCODE(q) ((q) & ~Q_BITS_CDRCODE)
#define     ADDRESS(q) ((q) &  Q_BITS_ADDRESS)


/*
 * known constants
 */

#define C_NIL 0x06000000
#define C_T   0x06000005


/*
 * type tag codes
 */

#define DTP_TRAP_CODE              0
#define DTP_LIST_CODE              1
#define DTP_STACK_LIST_CODE        2
#define DTP_SYMBOL_CODE            3
#define DTP_ARRAY_CODE             4
#define DTP_FIX_CODE               5
#define DTP_CHARACTER_CODE         6
#define DTP_SINGLE_FLOAT_CODE      7
#define DTP_SHORT_FLOAT_CODE       8
#define DTP_INSTANCE_CODE          9
#define DTP_EXTENDED_NUMBER_CODE  10
#define DTP_LOCATIVE_CODE         11
#define DTP_FUNCTION_CODE         12
#define DTP_CLOSURE_CODE          13
#define DTP_LEXICAL_CLOSURE_CODE  14
#define DTP_U_ENTRY_CODE          15
#define DTP_STACK_GROUP_CODE      16
#define DTP_GC_FORWARD_CODE       17
#define DTP_EVCP_CODE             18
#define DTP_ONE_Q_FORWARD_CODE    19
#define DTP_HEADER_FORWARD_CODE   20
#define DTP_BODY_FORWARD_CODE     21
#define DTP_SYMBOL_HEADER_CODE    22
#define DTP_HEADER_CODE           23 /* Not in SSDN2 */
#define DTP_ARRAY_HEADER_CODE     24
#define DTP_INSTANCE_HEADER_CODE  25
#define DTP_FEF_HEADER_CODE       26
#define DTP_SELF_REF_POINTER_CODE 27
#define DTP_GCYP_CODE             28
#define DTP_FREE_CODE             29
#define DTP_NULL_CODE             30
#define DTP_ONES_TRAP_CODE        31

#define DTP_TRAP             (DTP_TRAP_CODE             << 25)
#define DTP_LIST             (DTP_LIST_CODE             << 25)
#define DTP_STACK_LIST       (DTP_STACK_LIST_CODE       << 25)
#define DTP_SYMBOL           (DTP_SYMBOL_CODE           << 25)
#define DTP_ARRAY            (DTP_ARRAY_CODE            << 25)
#define DTP_FIX              (DTP_FIX_CODE              << 25)
#define DTP_CHARACTER        (DTP_CHARACTER_CODE        << 25)
#define DTP_SINGLE_FLOAT     (DTP_SINGLE_FLOAT_CODE     << 25)
#define DTP_SHORT_FLOAT      (DTP_SHORT_FLOAT_CODE      << 25)
#define DTP_INSTANCE         (DTP_INSTANCE_CODE         << 25)
#define DTP_EXTENDED_NUMBER  (DTP_EXTENDED_NUMBER_CODE  << 25)
#define DTP_LOCATIVE         (DTP_LOCATIVE_CODE         << 25)
#define DTP_FUNCTION         (DTP_FUNCTION_CODE         << 25)
#define DTP_CLOSURE          (DTP_CLOSURE_CODE          << 25)
#define DTP_LEXICAL_CLOSURE  (DTP_LEXICAL_CLOSURE_CODE  << 25)
#define DTP_U_ENTRY          (DTP_U_ENTRY_CODE          << 25)
#define DTP_STACK_GROUP      (DTP_STACK_GROUP_CODE      << 25)
#define DTP_GC_FORWARD       (DTP_GC_FORWARD_CODE       << 25)
#define DTP_EVCP             (DTP_EVCP_CODE             << 25)
#define DTP_ONE_Q_FORWARD    (DTP_ONE_Q_FORWARD_CODE    << 25)
#define DTP_HEADER_FORWARD   (DTP_HEADER_FORWARD_CODE   << 25)
#define DTP_BODY_FORWARD     (DTP_BODY_FORWARD_CODE     << 25)
#define DTP_SYMBOL_HEADER    (DTP_SYMBOL_HEADER_CODE    << 25)
#define DTP_HEADER           (DTP_HEADER_CODE           << 25)
#define DTP_ARRAY_HEADER     (DTP_ARRAY_HEADER_CODE     << 25)
#define DTP_INSTANCE_HEADER  (DTP_INSTANCE_HEADER_CODE  << 25)
#define DTP_FEF_HEADER       (DTP_FEF_HEADER_CODE       << 25)
#define DTP_SELF_REF_POINTER (DTP_SELF_REF_POINTER_CODE << 25)
#define DTP_GCYP             (DTP_GCYP_CODE             << 25)
#define DTP_FREE             (DTP_FREE_CODE             << 25)
#define DTP_NULL             (DTP_NULL_CODE             << 25)
#define DTP_ONES_TRAP        (DTP_ONES_TRAP_CODE        << 25)


/*
 * symbol structure layout
 */

#define SYM_PRINTNAME 0
#define SYM_VALUE     1
#define SYM_FUNCTION  2
#define SYM_PROPERTY  3
#define SYM_PACKAGE   4


/*
 * scratch pad init area layout
 */

#define SPIA_INITIAL_FUNCTION 0
#define SPIA_ERROR_HANDLER_SG 1
#define SPIA_CURRENT_SG 2
#define SPIA_INITIAL_SG 3
#define SPIA_LAST_ARRAY_ELEMENT 4 /* ??? */


/*
 * call-info word layout
 */

#define CI_NUMARGS          0x0000003f
#define CI_LEXPRFUNCALL     0x00000040
#define CI_SELFMAPPINGTABLE 0x00000080
#define CI_LEXICALCLOSURE   0x00000100
#define CI_RETURNDEST       0x00000e00
#define CI_RETURNTYPE       0x00003000
#define CI_NUMRESULTS       0x000fc000
#define CI_BINDINGBLOCK     0x00100000
#define CI_MICROSTACK       0x00200000
#define CI_TRAPONEXIT       0x00400000
#define CI_ENVIRONMENT      0x00800000

#define CI_RETURNFIELDS     (CI_RETURNTYPE | CI_NUMRESULTS)

#define D_INDS     0x00000000
#define D_PUSH     0x00000200
#define D_RETURN   0x00000400
#define D_TAIL_REC 0x00000600


#endif /* EXPLOITER_H */

/* EOF */
