/*
 * dumpraw.c
 *
 * various debugging display functions
 */

#include "utils.h"
#include "exploiter.h"
#include "memory.h"
#include <stdio.h>

void dump_raw_array(lisp_q aryptr)
{
    int arysize;
    lisp_q arystart;
    lisp_q aryheader;
    int i;

    aryheader = memread(aryptr);
    if (aryheader & 0x20000) {
	arysize = 3 + ADDRESS(memread(aryptr - 1));
	arystart = 1 + aryptr - arysize;
    } else {
	arystart = aryptr;
	arysize = 1;
    }

    arysize += (aryheader & 0x1ff);

    for (i = 0; i < arysize; i++) {
	dump_q(memread(arystart+i), arystart+i);
    }
}

void dump_string(lisp_q strptr)
{
    int arysize;
    lisp_q aryheader;
    u32 foo;
    int i;
    char c;

    aryheader = memread(strptr);

    arysize = (aryheader & 0x1ff);

    foo = 0;
    
    for (i = 0; i < arysize; i++) {
	if ((i & 3) == 0) {
	    foo = memread(strptr + (i >> 2) + 1);
	}
	c = foo >> (i << 3);
	printf("%c", c);
    }
    printf("\n");
}

void dump_raw_fef(lisp_q fefptr)
{
    int codestart;
    int fefsize;
    int i;
    lisp_q tmp;
    lisp_q header;

    header = memread(fefptr);
    codestart = header & 0x3ff;
    fefsize = ADDRESS(memread(fefptr+1));

    printf("FEF: %ld req, %ld opt, %ld loc, calltype %ld.\n",
	   (header >> 14) & 15, (header >> 18) & 7,
	   (header >> 10) & 15, (header >> 21) & 7);
    
    for (i = 0; i < codestart; i++) {
	dump_q(memread(fefptr+i), fefptr+i);
    }

    for (i = codestart; i < fefsize; i++) {
	tmp = memread(fefptr+i);
	
	disassemble_instr((i << 1) + 0, tmp & 0xffff);
	disassemble_instr((i << 1) + 1, tmp >> 16);
    }

    dump_string(memread_inviz(memread_inviz(memread_inviz(fefptr+2)+2)+SYM_PRINTNAME));
}

/* EOF */
